#!/bin/sh
# This script was generated using Makeself 2.0.1
CRCsum=3043856338
MD5=041697cc81b0e550b04f22441b607011
TMPROOT=${TMPDIR:=/tmp}

label="Unreal Tournament 2003 for GNU/Linux 2107"
script="./setup.sh"
scriptargs=""
targetdir="ut2003_linux_2107"
keep=n

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Help()
{
    cat << EOH
Makeself version 2.0.1
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --target NewDirectory Extract in NewDirectory
EOH
}

MS_Check()
{
    MS_Printf "Verifying archive integrity..."
    if test $CRCsum = "0000000000"; then
	test x$2 = xy && echo " $1 does not contain a CRC checksum."
    else
	sum1=`tail +266 $1 | cksum | sed -e 's/ /Z/' -e 's/	/Z/' | cut -dZ -f1`
	if test "$sum1" = "$CRCsum"; then
	    test x$2 = xy && MS_Printf " Checksums are OK."
	else
	    echo "Error in checksums: $sum1 is different from $CRCsum"
	    exit 2;
	fi
    fi
    if test $MD5 = "00000000000000000000000000000000"; then
	test x$2 = xy && echo " $1 does not contain an embedded MD5 checksum."
    else
	OLD_PATH=$PATH
	PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_PATH=`type -p md5sum`
	MD5_PATH=${MD5_PATH:-`type -p md5`}
	PATH=$OLD_PATH
	if test -x "$MD5_PATH"; then
	    md5sum=`tail +266 $1 | "$MD5_PATH" | cut -b-32`;
	    if test "$md5sum" != "$MD5"; then
		echo "Error in MD5 checksums: $md5sum is different from  $MD5"
		exit 2
	    else
		test x$2 = xy && MS_Printf " MD5 checksums are OK."
	    fi
	else
	    echo An embedded MD5 sum of the archive exists but no md5sum program was found in $PATH
	    echo If you have md5sum on your system, you should try :
	    echo env GUESS_MD5_PATH=\"FirstDirectory:SecondDirectory:...\" $0 -check
        fi
    fi
    echo " All good."
}

UnTAR()
{
    tar xvf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=copy

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 17668 KB
	echo Compression: none
	echo Date of packaging: Thu Sep 19 20:44:07 EDT 2002
	echo Built with Makeself version 2.0.1 on linux-gnu
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"n" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	tail +266 $0  | cat | tar tvf -
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    -*)
	echo Unrecognized flag : "$1"
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    SCRIPT_COPY="$TMPROOT/makeself$$"
    echo "Copying to a temporary location..."
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2
    ;;
phase2)
    finish="$finish ; rm -f $0"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$@"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$@"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir"
	tmpdir="$targetdir"
    else
	tmpdir="$TMPROOT/selfgz$$"
    fi
    mkdir $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should perhaps try option -target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi

MS_Printf "Uncompressing $label"
cd $tmpdir
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up > /dev/tty; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 15
fi
if (cd "$location"; tail +266 $0; ) | cat | UnTAR |     (while read a; do MS_Printf .; done; echo; ); then
	(PATH=/usr/xpg4/bin:/usr/local/samsungprinter:/opt/intel/compiler60/ia32/bin:/usr/local/jdk/bin:/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/openwin/bin:/usr/games:/usr/local/openssh/bin:/usr/share/texmf/bin:/usr/local/kde/bin:/usr/src/qt/bin:/usr/local/pgp:/home/icculus/bin; chown -R `id -u` .;  chgrp -R `id -g` .)
	res=0
	if test x"$script" != x; then
		if test x"$verbose" = xy; then
			MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
			read yn
			if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			    $script $scriptargs $*; res=$?;
			fi
		else
			$script $scriptargs $*; res=$?
		fi
		if test $res != 0; then
		    echo "The program returned an error code ($res)"
		fi
	fi
	if test "$keep" = n; then
	    cd $TMPROOT
	    /bin/rm -rf $tmpdir
	fi
else
    echo "Unable to decompress $0"
    eval $finish; exit 1
fi
eval $finish; exit $res
Benchmark/                                                                                          0040777 0001750 0000144 00000000000 07542467526 012367  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  Help/                                                                                               0040777 0001750 0000144 00000000000 07542467526 011365  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  Help/Unreal.bmp                                                                                     0100644 0001750 0000144 00000015466 07537160332 013305  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  BM6      6   (   0   0                                                                                                                                                                                                                                                                                     """!!!
                                  #),.494;@6>C6>D5>C5>C5>C6?D6?D4<A18<)04 %)                             
&+.>EJCLR4=D *1#
  	
	!(-4=DMU\RZ_>EI&+.                         SZ_hqx/9@  
	 
 	 	 
"<FLeouemr;AE                      "%>GL;FM '		 (+3'/
 0'>$8#$)%06?HN]ek^gl'-1                    +25@IN&/6 '! #!()0!+2#+!%!2
':7ORq(j'pV	-F$*(9C$=M*7                 +37KTY:DJ%"$'&$ (*64G6NB\Xx$c3v=?>4Ry(@
'6;QLh?X->!               JRXISZ +2!$ ('.#*))9>WWx)n1z.0?GEFF)~Ov*@+6JTr"`&h\~Fd3H'              8AEMW]1<D&%&!)+2-7&AR.Zs1p6E;/6?CCD?)vJm:TXx-z1*z&w*oVx<T!-            [fk?JQ(/%,$+$,')1$;IMptqPL32?EGNUM0,o]'t42&}+H8_?\#.           .8<^jp.:A"#*(0&/'!-5+@LJ_kg:2@:AOjΏߛS:69953>@M=#fB`%.          WbhJV] ,4&'/ ,4!-5(4<9GN0;B(/DWatc)2_G63p>iZvJ/3:Ea3xүL|7R',         ityALT".6+3#08(5=*7>&3:2?G=JR)4<FYdoYt,QK<~*Na!1:,3)1-;DixКO*3@Z1n:`s_r|g6G"%        p{ERY,9A)6>*7?+8@(5=$19'4<3@I)5=L_jqP_'t=3&h >P(/&-"*)1 -4nW",CY'c&3#(+BMScyWu+=H       zP]e8EM4AI1?G.<D'4<'4<$1:*7?(4<PdopM`,z+!|^:L'-%.$,(0$Ofs\*7JK!`,)27BZg>au*8@       ~R^f@MU>KS9FO6CL-;C)6?&3<+8@+7?TgrrN#n7%y z^8K$*#,%-(1&Ldr|_:NVD$d+7&	

!((FWBXe )-      yI[f@OXERZBOW?LT:GP/<D-:B2?H/;CVhsvX0}?({%c9L#*$-%-(1&Kcp{gNd`F)h/:(/'.
 	7KV@JQ      sEct:O[GS\JW`FS\ERZ9FO8EN9FO0=ERdoxf5;+~("f<O'.'/$-'/%Lco~s]fZH(g,8&'/"* 
 T\c.47     p}U|4Rc=LVP\dN[cJX`=KS?MUAOW3?HPbmzi%p)r.|'~"e >P(/(0"+%.'NdruUMEC&e1=!' '%	   FNS;CG    [fjm6]s0ESP[cXenP^fFT\FT\LYbBNV]oz}^Xz,w*p#s_7I%%-"*)1!)Qhtk71<.!a.;!('
!	
 #,1JSX-36    8BGY,J^;KUcovanvTajQ_gTajJW`o}\
Rv96,#d9K#))1)1(5> ,4Zp{\$}(|@.#b-;!)' 		NX]>EH    "}Mu(I`S_hmzcqyVdlTajJV_mzk ~OUD-p<L(/%2;&3<3@I%19dvZ z$v>4*h/<"*!)
# 

CKQBIN   
_kq<p2ReZeldqy[hqWdmKXap|Ǒ]yw]9y#@P",3%2; -6-:C)1]nxn:<G=3o"8D*1&/'#$4>D@IN"%    3>Bq$[z2HWNZaZgoanwVclv̯sB&CS$/6$19&/$1:"*Xhrҏeb`X;u)>J&19+4 (#$	 *5<?HN&-1    frx˨JD_(=KDS]YfnXdlqʲH&CS&17%2;&.!.7"*[ktԭ~Bz*?J*5=&3<)1!)'%
!&2:@JP/6:     5AF٘1mD_ @S1GS9KVUsŧK'DS(29)6?)2 .6%.apyE|(=H,8?/<E*8@#19)1#%,#+(3;DNT5=A     UafA#`>W:S/clªJ+HX.8?,:B"09 -6(1et|Cz*?I/;C/<E&4<$2:)7?!),4*2,8@CNT2;?      "-2wsNFu`ݣO4P_8AH5BJ+9A#19*2mx}ؾrlBy3GS4@H2?G&4<+4!.6)1)6>!,53?GBMS*48      8DHR4Q_7BH<IQ7DL&4<!.6evթwj^Ax7KW2>F2?G.;C"08'/,5)6=,4COWJTZ#-1        MX]dB\i;FM@MU@MU4AI-;Djqqn;|8P\5@I1=F.;C+8@)6?,9B(6="/7YemOZ_ $        #'Yej삼|o\mwMY`JW_P]eR_fVn{lxB2Sc7EN;GO<IQANVDQZ;HQ1>F6BJeqxFQV        "'Yekpnvp|amu[gpcoxjwqhkO)]y1GSALTIV_P]fSaiES[7DLR^f[gm.9=            [fkdr{o{kwq}wwiu}_lthu|w2z%Ka9HRMYbUclXfnGU]@MUiu}DOU"            VafXJrxxw{{p}lydqyerzi.g)FWBOXVck[irGU]^ksfry*59              KVZZ;jo~r~mymyhu}fs{vj,^{*AOHT][hqP^f;GL
                +6;s~ܸEKdqv~~xq~vtlykxiw~XfnyBo0IXJX`o|EQV                  %>HMǓSyLdqcpwuxy~wrttdqyVdlZhpes|k}jkm9EK                    #.2Q[_sjztyvvuo|ft{^ltVck`nvuo8FL                        -8<IV\aowv}uq}q}o|q~jxm{fs{YfmGSX+6;                          &15>INR\bdott|xsp|^krR^e@LR,8= %                               !,1:DILV[S^cXchZekYekVbhR^dLW]FQW5@E).	                                                                                                                                                                                                                                                                                                                      README.linux                                                                                        0100644 0001750 0000144 00000200627 07542467526 012513  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  This package contains Unreal Tournament 2003 for x86 GNU/Linux.
Both the graphical client and dedicated server are included.


INSTALLATION:
  Run the installer. You're probably already doing that if you're
  reading this file. YOU NEED TO BE ABLE TO MOUNT AND UNMOUNT THE CD.
  If you can't unmount the disc at this point, stop now and start again
  when you can. If you have been playing the demo version, please remove
  the $HOME/.ut2003 directory and everything in it. Including your .INI
  files. Seriously.


UPDATING:
  If you are playing under the same login that you installed the game,
  you can go the "Play online/LAN" option on the main menu, and click the
  "news" tab. The master server that supplies the "message of the day"
  text alerts the game when there are new versions available and makes an
  "Upgrade" button available to you in the lower right corner. Click on
  it.

  Alternately, you can run /where/i/installed/ut2003/updater/update and
  follow the prompts. The in-game "Upgrade" button just runs this program
  anyhow. Server admins will want to do it this way. The updater does not
  require X11 to run.

  If there are updates available, loki_update will download them and
  automatically update the game to the latest version with a nice
  interface to let you know what's going on and give you as much or as
  little control as you want over the process.


UNINSTALLATION:
  There is an "uninstall" script in the directory where you installed the
  game. Run that as the same user that installed the game, and it should
  remove all traces of itself.

  Please note that personal game files (configs, screenshots, etc) are
  written to the player's homedir ("$HOME/.ut2003"). These files are not
  removed by the uninstaller, but can be safely deleted at your
  discretion.


FAQs:

  Q: Where do I report bugs?
  A: https://bugzilla.icculus.org/

      There is also a mailing list for discussion of ut2003 on
      non-Windows platforms, but bugs that are not in the bugtracking
      system will likely be ignored. We just don't have time to monitor
      mailing lists for things we should be fixing when there's a nice
      user interface to help us keep track of this. You Have Been Warned.

  Q: So what about this mailing list?
  A: Send a blank email to ut2003-subscribe@icculus.org to get on the
     list. You must be subscribed to post, as an anti-spam (and
     anti-rudeness) precaution. Unsubscribe instructions are sent to you.
     This list is for discussion, not bug reporting.

  Q: I have a TNT2 card...can I play the game?
  A: No. There is no S3TC hardware on the TNT2. THIS IS NOT A UT2003 BUG.
     Please upgrade if you want to play.

  Q: I have a AMD K6 processor...can I play the game?
  A: No. These CPUs lack instructions the physics code needs. This is
     true for both the client and server. This will NOT change. Please
     upgrade if you want to play.

  Q: How do I join a game from the pull-down console?
  A: "open hostname.of.game.server.com:portnum"

  Q: How do I take a screenshot in-game?
  A: F9, by default. It writes to $HOME/.ut2003/System/ by default.

  Q: How do I switch between fullscreen and windowed mode?
  A: You can change this in the Video settings menu, or the .INI file,
     but the quickest way is to just hit ALT-Enter. CTRL-G will grab
     and ungrab mouse input if you need to get at a different window.

  Q: I want to run a dedicated server, but have no idea where to start.
     Any pointers for me?
  A: There is an excellent collection of articles at:
     http://www.unrealadmin.org/modules.php?name=News&file=article&sid=67
     One of the links listed there you should pay close attention to is
     http://www.beyondunreal.com/content/articles/21_1.php

  Q: Any generic help for Linux gaming and ut2003 on Linux?
  A: More ut2003 FAQs and generic Linux game resources at the LGFAQ:
     http://icculus.org/lgfaq/

  Q: I get the following text on my console when I run the game:
      Xlib: extension "XiG-SUNDRY-NONSTANDARD" missing on display ":0.0".
     Is this a problem?
  A: No. This means you aren't using an X server from Xi Graphics.
     That message means we're looking for the X11 extension they use to
     change screen resolutions, and having a non-XiG X server, you
     don't have it. THIS IS NOT A UT2003 BUG. It's not a bug at all.
     Xlib prints that "error", but we handle it gracefully.

  Q: I see text like "qhull warning" and "BADCHOL" spewed to the console.
     Is this a problem?
  A: No. These are warning from MathEngine's Karma libraries (the code
     that handles those cool ragdoll death effects). They are harmless,
     and can be ignored. THIS IS NOT A UT2003 BUG. It's not a bug at all.

  Q: I click the "view stats" button in the menus, and either the wrong
     (that is, not my favorite) browser pops up, or no web browser at
     all appears.
  A: export the BROWSER environment variable before starting ut2003:
       export BROWSER="mozilla"
     See http://www.tuxedo.org/~esr/BROWSER/ for more info.

  Q: I have a working, hardware accelerated OpenGL setup, but when I try
     to run the game, I get a message on the console and in my logs that
     says something like "OpenGL renderer relies on DXTC/S3TC support".
  A: Your drivers do not support the "GL_EXT_texture_compression_s3tc"
     extension. This is needed to play the game. THIS IS NOT A UT2003
     BUG. Currently, the only working drivers we are aware of that
     support this extension on Linux are the official Nvidia binary-only
     drivers. We are currently exploring options with other driver
     vendors, and we are willing to cooperate with any driver vendor that
     wants to support ut2003. The bottom line, however, is this: if you
     want to play the game right now, you should pop an Nvidia card into
     your machine.

  Q: But Quake 3 Arena works with these drivers!
  A: Quake 3 Arena doesn't rely on S3TC support, and is a completely
     different codebase. Apples. Oranges.

  Q: My graphics are slow. Really slow. We're talking like 1 frame every
     few seconds. Surely this game doesn't need THAT much hardware to
     run well?!
  A: No, you are in software Mesa. If you hit this, it means your 3D
     drivers are set up incorrectly, or not at all. Please see your
     distribution vendor or driver provider for help. THIS IS NOT A
     UT2003 BUG.

  Q: I have a PCI video card, and the game loads, but it's slow. I'm
     definitely not using software Mesa, either.
  A: You need AGP support for this game to be generally playable. Sorry.

  Q: I have a GeForce892 and it's slow. I'm not using NVAGP or AGPGART.
  A: See above. The game might run, BUT IT WILL BE VERY VERY SLOW
     WITHOUT AGP TRANSFERS. There is nothing to do about this. If we
     can't pass vertex data over AGP, the fallback is slow. Very slow.

     If you see the following text in your log file (which should be
     $HOME/.ut2003/System/UT2003.log):

        WARNING: Couldn't allocate AGP memory - turning off support for GL_NV_vertex_array_range
        WARNING: This has a serious impact on performance.

     ...then you don't have AGP support. Enable AGP and/or get
     hardware that will let you enable AGP. If you SHOULD have it,
     then you're system is either misconfigured, or your drivers are
     buggy.

  Q: But the game will work with AGPGART, right?
  A: Yes. NvAgp and AGPGART should both work with the Nvidia drivers.

  Q: I don't get any sound, and/or audio output is very messed up.
  A: We use OpenAL for sound output. The included OpenAL is compiled
     with support for direct writes to /dev/dsp using the Open Sound
     System API provided by the kernel, and support for playback through
     SDL. Some systems may have buggy drivers or perhaps have the audio
     device captured by the esound or arts daemons. SDL is very good at
     handling the whole range of audio solutions and workarounds, and
     since we ship with SDL anyhow, it makes sense to use it as a
     fallback.

        The short answer is this:

            echo "(define devices '(sdl))" > ~/.openalrc

        That will coerce OpenAL to use SDL for audio output, which will
        solve 99% of the problems you might be having. SDL can be
        directed to use various audio targets with an environment
        variable, if it doesn't magically pick the right one.

     Alternately, you might need to put a custom SDL or OpenAL with
     support for your setup into UT2003, replacing the versions we
     supplied. Doing so is beyond the scope of this document, but please
     be sure to pull the latest versions of these libraries from CVS, as
     both have UT2003-specific fixes applied to them.

     If everything is utterly broken, and you can do without sound, run
     the game with -nosound on the command line (and submit a bug
     report!). If you don't want to type that every time, look for
     "UseSound" in your UT2003.ini file.

  Q: I made changes to UT2003.ini and User.ini in the game's System
     directory, but they aren't showing up when I run the game.
  A: UT2003, like the original UT, writes to your homedir, and not the
     game directory. Look in $HOME/.ut2003/System, where it should have
     written out, on your first run, a UT2003.ini and User.ini based on
     the game's Default.ini file. If this file exists, it is used instead
     of one in the game's System dir. So edit that one, instead.
     Screenshots and other files to be written will also go to your
     homedir.

     If you really hate this, you can have all reading and writing be
     done to the game's System dir instead: specify -nohomedir on the
     command line. Please make sure you've got write access to the
     installation directories if you do this.

     The game's menu interface is frequently a more user friendly way to
     do the common things. You should only need to get down and dirty in
     the .INI files if you want to do uncommon things (see next
     question) or you want to run a dedicated server exclusively.

  Q: I want to use a joystick, and it isn't working!
  A: Set "UseJoystick=True" in the [SDLDrv.SDLClient] section of your
     UT2003.ini file. (Make sure you do this in SDLDrv and not WinDrv or
     something else!) You'll need to configure the axes in the User.ini
     file. Joystick buttons and hats look like keypresses to the Unreal
     engine now, so those can be configured via the menus once you set
     UseJoystick. If you've got more than one joystick plugged in and
     recognized by SDL, you might need to set "JoystickNumber" to
     something other than "0"...check $HOME/.ut2003/System/UT2003.log for
     a list of what joystick is being assigned to what number. If you've
     got more than one hat switch, you can only use one (sorry): set
     "JoystickHatNumber" in the .ini file. If the log says it detected
     zero joysticks, it means it; please make sure you've got the correct
     /dev entries and kernel modules set up.

  Q: I have a 16 or more buttons on my joystick (!), but the log says I
     can only use 12!
  A: If you've got a hatswitch on your stick, set "IgnoreHat=True" in the
     [SDLDrv.SDLClient] section of your UT2003.ini file. This gives you
     four extra buttons, but you'll lose the use of your hat switch. (You
     can also modify SDL via environment variables and/or source hacking
     to make your controls be represented differently to the engine. Do
     some research if you want to try this approach). This is due to the
     fact that the Unreal Engine has 16 "keys" set aside for joystick
     buttons/hat switches. Really creative people could hack SDL to send
     keyevents on unused keys if you've got WAY too many joystick
     buttons. Patches to SDL are accepted.  :)

  Q: I replaced the openal.so you supplied with my own, and now the
     assault rifle sounds like an Ice Cream Truck.
  A: Your OpenAL has a buggy pitch filter. Use the latest OpenAL from
     CVS, or, alternately, look for "DisablePitch" in your UT2003.ini
     file and set it to "True". Thanks go to Joe Valenzuela for fixing
     the Linux OpenAL reference implementation at the last minute for me.

  Q: I replaced the libSDL.so you supplied with my own, and now the
     splash screen doesn't center in my display!
  A: Same deal; use the latest from CVS. There was a ut2003-specific
     patch applied a few days before we shipped.

  Q: How do I run a server without X11, OpenGL, or graphics at all?
  A: Quick start:

       cd /where/i/installed/ut2003/System ; ./ucc server DOM-SunTemple

       "DOM-SunTemple" can be replaced with any other map in the "Maps"
       directory. There's like a million different options you specify on
       the command line; go find a dedicated server tutorial on the net.
       Many of the options have the same syntax as the original Unreal
       Tournament.

       "ucc" does not link against SDL or OpenAL (but it does link
       against Ogg Vorbis for purely technical reasons...don't ask.),
       so you should be able to run it in a console, under "screen", on
       a rackmount, over ssh, or anywhere else that you can't see pretty
       graphics or hear bots calling you a camper.

  Q: What about FreeBSD?
  A: The dedicated server should run with the Linux binary emulation
     (sorry, guys, I tried, but it was non-trivial to build a native
     executable at this point in time). The client would probably run
     under the binary emulation, too, but I am not aware of any
     functional 3D drivers that can support this game. Reports of success
     and failure are welcome, though. I'll be happy to talk with any
     vendors that are interested in FreeBSD 3D support, but I wouldn't
     hold my breath at this moment in time if I were you.

  Q: Can you port the server/client to Sparc/MIPS/Alpha/ARM/my toaster?
  A: This would require time, money, and permission from Epic. Not to
     mention 3D drivers if you want the client. Nothing is impossible,
     but the likelihood is low. Please don't send me any signed
     petitions, either.

  Q: Can I get a port to BeOS/AtheOS/OS2 Warp/Windows for Workgroups 3.0?
  A: See last question.

  Q: What's the minimum system I need to play this on?
  A: I develop (and play) on a 800MHz Pentium 3 with a GeForce 2 Ultra. I
     wouldn't want to play on less, but with this setup, the game gets a
     respectable framerate (the worst is about 15-20 FPS, but on most
     scenes, we're talking about 25 to 40 FPS). The game is largely
     single threaded, but Ogg Vorbis decoding is done in a separate
     thread, OpenAL mixes in another thread, and (if you use the SDL
     audio target) writes to the audio device will use yet another
     thread...which means you can get a speed boost from an SMP box
     (currently, this is noticable: run the game with -nosound for a
     framerate boost on a Uniprocessor box to see what I mean. OpenAL and
     Ogg Vorbis optimization patches are VERY welcome). Generally, you
     should put more CPU and (more importantly) more graphics hardware in
     your box. The absolute low-end is probably a 600 MHz CPU and a
     GeForce 1 with the detail and resolution turned _all_ the way down
     (and I wouldn't call that a good gaming experience). Reports of
     success and failure, and specific benchmarks, are more than welcome.

  Q: Does this run faster/slower on Windows/Linux?
  A: The speeds are comparable. I haven't done actual benchmarks, as it's
     another Apple/Orange comparison. Kernels, drivers, Direct3D/OpenGL
     versions make this a largely debatable field anyhow. Run the game on
     the platform that works best for you: that's why we ported the game,
     after all.

  Q: I want to run WebAdmin on port 80, the standard http port, but I
     need to be root to bind to that port! Should I run the game as root?
  A: No. Running anything you don't have to as root is a BAD idea.
     Instead, use the ip_passthru.pl script in the "extras" directory
     where you installed the game. This small piece of code runs as root,
     binds to port 80 (or whatever), and then immediately drops root
     privs. When connections come in on port 80, this passes them
     through to WebAdmin on an alternate port. WebAdmin always gives
     back URLs with the correct port, so the ip_passthru script is
     only used for initial connections and requests. Please read the
     comments at the top of the file for more information. That being
     said, the game _can_ run as root, but you do so at your own risk.

  Q: I'm getting a lot of latency in sound effects, and I'm running the
     Esound daemon (which Gnome tends to enable) or the ARTS daemon
     (which KDE tends to enable).
  A: Turn off sound daemons! They are fine for one-shot sound effects
     in your window manager, but they are detrimental to realtime video
     games. You will get noticible sound latency and probably a dramatic
     decrease in framerate while using them.

  Q: I'm an ALSA user...will the game work with my sound card?
  A: We have a Linux laptop here that had awful trouble with OpenAL's
     "native" audio driver. Use SDL for audio output instead; the
     included version has ALSA support built in.

  Q: I have a Radeon X server from Xi Graphics; will I have problems?
  A: As of September 13th, 2002, Xi has released drivers that work with
     UT2003 on Linux. They have S3TC support. These drivers (Summit 2.2)
     do not have the VAR/VAO extensions, so you will have a performance
     decrease. We are working with XiG to resolve this problem. XiG
     reports that the game _is_ currently playable if you've got lots of
     raw CPU power, however, and will improve in the future. The included
     version of SDL is compiled with XME support, too, so the existing
     ut2003 binaries should be able to change resolutions in fullscreen
     mode with the XiG servers out of the box.

  Q: I have a Radeon card and the FireGL drivers; will I have problems?
  A: Currently, yes. These drivers don't have S3TC support at this time.
     We are working with ATI, and these problems will be resolved in a
     future release of their drivers.

  Q: I have a PowerVR Kyro card; will I have problems?
  A: Currently, yes. These drivers (beta3) _do_ have S3TC support, but
     they crash at startup. We are working with PowerVR, and these
     problems will be resolved in the next release of their drivers.

  Q: Are you really "working with" all these hardware vendors?
  A: Yes.

  Q: I have more questions!
  A: Ask on the mailing list (see above). Do not report bugs to the
     mailing list if you are expecting a fix. Did I mention that already?

  Q: So, wait, where can I report bugs, again?
  A: https://bugzilla.icculus.org/

  Q: Who are you?
  A: My name's Ryan.



SPECIAL THANKS:
    - Daniel Vogel: for initial Unix work and a lot of direction.
    - Matt Matthews: for forging onward, despite broken screenshot code.
    - Joe Valenzuela: for last-minute pitch patches and on-call bugfixing.
    - Stphane Peter: for lots of installer work on a moment's notice.
    - James Golding and Piercarlo Grandi: for Karma help.
    - Andy Mecham: for testing and moving a pool table simultaneously.
    - Sam Lantinga and the other SDL developers.
    - Creative Labs and the other OpenAL developers.
    - xiph.org and the other Ogg Vorbis developers.
    - Jon Trulson: for putting up with my crap.
    - Nicolas Thibieroz: for unexpected screenshots.
    - Glen Miner: for the SSH tunnel.
    - Jack Porter: for the obnoxious passwords.
    - Mike Capps: for saving me two cross-country flights.
    - Anne Dube: for hotel reservations.
    - Mark Rein: for supporting this port in many ways.
    - Epic Games: for the free food.



COPYRIGHT INFORMATION:

Unreal Tournament 2003 is Copyright (c) 2002 Epic Games, Inc. Raleigh,
N.C. USA. Unreal and the Unreal logo are registered trademarks of Epic
Games, Inc. ALL RIGHTS RESERVED. All other trademarks and trade names are
the property of their respective owners. Unreal Tournament 2003 was
created by Epic Games and Digital Extremes. Manufactured and marketed by
Infogrames, Inc, New York, New York, a subsidiary of Infogrames
Entertainment, S.A., under license from Epic Games, Inc.

MathEngine and Karma and the MathEngine and Karma logos are registered
trade marks or trade marks of MathEngine PLC, used under license.


The Linux game client makes use of the Linux reference implmentation of

  OpenAL (http://opensource.creative.com/)
    (copyright Creative Labs, Loki Software, inc, and others)

     and

  Simple Directmedia Layer (http://www.libsdl.org/).
    (copyright Sam Lantinga and others)


Both of these libraries fall under the GNU Library General Public License
(LGPL) version 2, a copy of which is supplied below. Please note that this
license ONLY covers the OpenAL and SDL portions of this software.


The Linux installer (loki_setup) and the autoupdate tools (loki_update)
 are provided under the GNU General Public License (GPL) version 2. The
 source can be found at http://icculus.org/ and the license is included
 below. These tools are copyright (c) Loki Software, inc and others.
 Please note that this license applies to the setup/update tools ONLY.


The game also makes use of Ogg Vorbis (http://www.xiph.org/ogg/vorbis/)
 and zlib (http://www.gzip.org/zlib/). Ogg Vorbis uses the following
 license:

    Copyright (c) 2001, Xiphophorus

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

    - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    - Neither the name of the Xiphophorus nor the names of its contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
    A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR
    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
    EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
    NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


zlib contains the following license:

   Copyright notice:

    (C) 1995-2002 Jean-loup Gailly and Mark Adler

     This software is provided 'as-is', without any express or implied
     warranty.  In no event will the authors be held liable for any damages
     arising from the use of this software.

     Permission is granted to anyone to use this software for any purpose,
     including commercial applications, and to alter it and redistribute it
     freely, subject to the following restrictions:

     1. The origin of this software must not be misrepresented; you must not
        claim that you wrote the original software. If you use this software
        in a product, an acknowledgment in the product documentation would be
        appreciated but is not required.
     2. Altered source versions must be plainly marked as such, and must not be
        misrepresented as being the original software.
     3. This notice may not be removed or altered from any source distribution.

     Jean-loup Gailly        Mark Adler
     jloup@gzip.org          madler@alumni.caltech.edu

   If you use the zlib library in a product, we would appreciate *not*
   receiving lengthy legal documents to sign. The sources are provided
   for free but without warranty of any kind.  The library has been
   entirely written by Jean-loup Gailly and Mark Adler; it does not
   include third-party code.

   If you redistribute modified sources, we would appreciate that you include
   in the file ChangeLog history information documenting your changes.


(SDL and OpenAL license:)


		  GNU LIBRARY GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1991 Free Software Foundation, Inc.
    		    59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

[This is the first released version of the library GPL.  It is
 numbered 2 because it goes with version 2 of the ordinary GPL.]

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
Licenses are intended to guarantee your freedom to share and change
free software--to make sure the software is free for all its users.

  This license, the Library General Public License, applies to some
specially designated Free Software Foundation software, and to any
other libraries whose authors decide to use it.  You can use it for
your libraries, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if
you distribute copies of the library, or if you modify it.

  For example, if you distribute copies of the library, whether gratis
or for a fee, you must give the recipients all the rights that we gave
you.  You must make sure that they, too, receive or can get the source
code.  If you link a program with the library, you must provide
complete object files to the recipients so that they can relink them
with the library, after making changes to the library and recompiling
it.  And you must show them these terms so they know their rights.

  Our method of protecting your rights has two steps: (1) copyright
the library, and (2) offer you this license which gives you legal
permission to copy, distribute and/or modify the library.

  Also, for each distributor's protection, we want to make certain
that everyone understands that there is no warranty for this free
library.  If the library is modified by someone else and passed on, we
want its recipients to know that what they have is not the original
version, so that any problems introduced by others will not reflect on
the original authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that companies distributing free
software will individually obtain patent licenses, thus in effect
transforming the program into proprietary software.  To prevent this,
we have made it clear that any patent must be licensed for everyone's
free use or not licensed at all.

  Most GNU software, including some libraries, is covered by the ordinary
GNU General Public License, which was designed for utility programs.  This
license, the GNU Library General Public License, applies to certain
designated libraries.  This license is quite different from the ordinary
one; be sure to read it in full, and don't assume that anything in it is
the same as in the ordinary license.

  The reason we have a separate public license for some libraries is that
they blur the distinction we usually make between modifying or adding to a
program and simply using it.  Linking a program with a library, without
changing the library, is in some sense simply using the library, and is
analogous to running a utility program or application program.  However, in
a textual and legal sense, the linked executable is a combined work, a
derivative of the original library, and the ordinary General Public License
treats it as such.

  Because of this blurred distinction, using the ordinary General
Public License for libraries did not effectively promote software
sharing, because most developers did not use the libraries.  We
concluded that weaker conditions might promote sharing better.

  However, unrestricted linking of non-free programs would deprive the
users of those programs of all benefit from the free status of the
libraries themselves.  This Library General Public License is intended to
permit developers of non-free programs to use free libraries, while
preserving your freedom as a user of such programs to change the free
libraries that are incorporated in them.  (We have not seen how to achieve
this as regards changes in header files, but we have achieved it as regards
changes in the actual functions of the Library.)  The hope is that this
will lead to faster development of free libraries.

  The precise terms and conditions for copying, distribution and
modification follow.  Pay close attention to the difference between a
"work based on the library" and a "work that uses the library".  The
former contains code derived from the library, while the latter only
works together with the library.

  Note that it is possible for a library to be covered by the ordinary
General Public License rather than by this special one.

		  GNU LIBRARY GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License Agreement applies to any software library which
contains a notice placed by the copyright holder or other authorized
party saying it may be distributed under the terms of this Library
General Public License (also called "this License").  Each licensee is
addressed as "you".

  A "library" means a collection of software functions and/or data
prepared so as to be conveniently linked with application programs
(which use some of those functions and data) to form executables.

  The "Library", below, refers to any such software library or work
which has been distributed under these terms.  A "work based on the
Library" means either the Library or any derivative work under
copyright law: that is to say, a work containing the Library or a
portion of it, either verbatim or with modifications and/or translated
straightforwardly into another language.  (Hereinafter, translation is
included without limitation in the term "modification".)

  "Source code" for a work means the preferred form of the work for
making modifications to it.  For a library, complete source code means
all the source code for all modules it contains, plus any associated
interface definition files, plus the scripts used to control compilation
and installation of the library.

  Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running a program using the Library is not restricted, and output from
such a program is covered only if its contents constitute a work based
on the Library (independent of the use of the Library in a tool for
writing it).  Whether that is true depends on what the Library does
and what the program that uses the Library does.
  
  1. You may copy and distribute verbatim copies of the Library's
complete source code as you receive it, in any medium, provided that
you conspicuously and appropriately publish on each copy an
appropriate copyright notice and disclaimer of warranty; keep intact
all the notices that refer to this License and to the absence of any
warranty; and distribute a copy of this License along with the
Library.

  You may charge a fee for the physical act of transferring a copy,
and you may at your option offer warranty protection in exchange for a
fee.

  2. You may modify your copy or copies of the Library or any portion
of it, thus forming a work based on the Library, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) The modified work must itself be a software library.

    b) You must cause the files modified to carry prominent notices
    stating that you changed the files and the date of any change.

    c) You must cause the whole of the work to be licensed at no
    charge to all third parties under the terms of this License.

    d) If a facility in the modified Library refers to a function or a
    table of data to be supplied by an application program that uses
    the facility, other than as an argument passed when the facility
    is invoked, then you must make a good faith effort to ensure that,
    in the event an application does not supply such function or
    table, the facility still operates, and performs whatever part of
    its purpose remains meaningful.

    (For example, a function in a library to compute square roots has
    a purpose that is entirely well-defined independent of the
    application.  Therefore, Subsection 2d requires that any
    application-supplied function or table used by this function must
    be optional: if the application does not supply it, the square
    root function must still compute square roots.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Library,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Library, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote
it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Library.

In addition, mere aggregation of another work not based on the Library
with the Library (or with a work based on the Library) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may opt to apply the terms of the ordinary GNU General Public
License instead of this License to a given copy of the Library.  To do
this, you must alter all the notices that refer to this License, so
that they refer to the ordinary GNU General Public License, version 2,
instead of to this License.  (If a newer version than version 2 of the
ordinary GNU General Public License has appeared, then you can specify
that version instead if you wish.)  Do not make any other change in
these notices.

  Once this change is made in a given copy, it is irreversible for
that copy, so the ordinary GNU General Public License applies to all
subsequent copies and derivative works made from that copy.

  This option is useful when you wish to copy part of the code of
the Library into a program that is not a library.

  4. You may copy and distribute the Library (or a portion or
derivative of it, under Section 2) in object code or executable form
under the terms of Sections 1 and 2 above provided that you accompany
it with the complete corresponding machine-readable source code, which
must be distributed under the terms of Sections 1 and 2 above on a
medium customarily used for software interchange.

  If distribution of object code is made by offering access to copy
from a designated place, then offering equivalent access to copy the
source code from the same place satisfies the requirement to
distribute the source code, even though third parties are not
compelled to copy the source along with the object code.

  5. A program that contains no derivative of any portion of the
Library, but is designed to work with the Library by being compiled or
linked with it, is called a "work that uses the Library".  Such a
work, in isolation, is not a derivative work of the Library, and
therefore falls outside the scope of this License.

  However, linking a "work that uses the Library" with the Library
creates an executable that is a derivative of the Library (because it
contains portions of the Library), rather than a "work that uses the
library".  The executable is therefore covered by this License.
Section 6 states terms for distribution of such executables.

  When a "work that uses the Library" uses material from a header file
that is part of the Library, the object code for the work may be a
derivative work of the Library even though the source code is not.
Whether this is true is especially significant if the work can be
linked without the Library, or if the work is itself a library.  The
threshold for this to be true is not precisely defined by law.

  If such an object file uses only numerical parameters, data
structure layouts and accessors, and small macros and small inline
functions (ten lines or less in length), then the use of the object
file is unrestricted, regardless of whether it is legally a derivative
work.  (Executables containing this object code plus portions of the
Library will still fall under Section 6.)

  Otherwise, if the work is a derivative of the Library, you may
distribute the object code for the work under the terms of Section 6.
Any executables containing that work also fall under Section 6,
whether or not they are linked directly with the Library itself.

  6. As an exception to the Sections above, you may also compile or
link a "work that uses the Library" with the Library to produce a
work containing portions of the Library, and distribute that work
under terms of your choice, provided that the terms permit
modification of the work for the customer's own use and reverse
engineering for debugging such modifications.

  You must give prominent notice with each copy of the work that the
Library is used in it and that the Library and its use are covered by
this License.  You must supply a copy of this License.  If the work
during execution displays copyright notices, you must include the
copyright notice for the Library among them, as well as a reference
directing the user to the copy of this License.  Also, you must do one
of these things:

    a) Accompany the work with the complete corresponding
    machine-readable source code for the Library including whatever
    changes were used in the work (which must be distributed under
    Sections 1 and 2 above); and, if the work is an executable linked
    with the Library, with the complete machine-readable "work that
    uses the Library", as object code and/or source code, so that the
    user can modify the Library and then relink to produce a modified
    executable containing the modified Library.  (It is understood
    that the user who changes the contents of definitions files in the
    Library will not necessarily be able to recompile the application
    to use the modified definitions.)

    b) Accompany the work with a written offer, valid for at
    least three years, to give the same user the materials
    specified in Subsection 6a, above, for a charge no more
    than the cost of performing this distribution.

    c) If distribution of the work is made by offering access to copy
    from a designated place, offer equivalent access to copy the above
    specified materials from the same place.

    d) Verify that the user has already received a copy of these
    materials or that you have already sent this user a copy.

  For an executable, the required form of the "work that uses the
Library" must include any data and utility programs needed for
reproducing the executable from it.  However, as a special exception,
the source code distributed need not include anything that is normally
distributed (in either source or binary form) with the major
components (compiler, kernel, and so on) of the operating system on
which the executable runs, unless that component itself accompanies
the executable.

  It may happen that this requirement contradicts the license
restrictions of other proprietary libraries that do not normally
accompany the operating system.  Such a contradiction means you cannot
use both them and the Library together in an executable that you
distribute.

  7. You may place library facilities that are a work based on the
Library side-by-side in a single library together with other library
facilities not covered by this License, and distribute such a combined
library, provided that the separate distribution of the work based on
the Library and of the other library facilities is otherwise
permitted, and provided that you do these two things:

    a) Accompany the combined library with a copy of the same work
    based on the Library, uncombined with any other library
    facilities.  This must be distributed under the terms of the
    Sections above.

    b) Give prominent notice with the combined library of the fact
    that part of it is a work based on the Library, and explaining
    where to find the accompanying uncombined form of the same work.

  8. You may not copy, modify, sublicense, link with, or distribute
the Library except as expressly provided under this License.  Any
attempt otherwise to copy, modify, sublicense, link with, or
distribute the Library is void, and will automatically terminate your
rights under this License.  However, parties who have received copies,
or rights, from you under this License will not have their licenses
terminated so long as such parties remain in full compliance.

  9. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Library or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Library (or any work based on the
Library), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Library or works based on it.

  10. Each time you redistribute the Library (or any work based on the
Library), the recipient automatically receives a license from the
original licensor to copy, distribute, link with or modify the Library
subject to these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  11. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Library at all.  For example, if a patent
license would not permit royalty-free redistribution of the Library by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Library.

If any portion of this section is held invalid or unenforceable under any
particular circumstance, the balance of the section is intended to apply,
and the section as a whole is intended to apply in other circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  12. If the distribution and/or use of the Library is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Library under this License may add
an explicit geographical distribution limitation excluding those countries,
so that distribution is permitted only in or among countries not thus
excluded.  In such case, this License incorporates the limitation as if
written in the body of this License.

  13. The Free Software Foundation may publish revised and/or new
versions of the Library General Public License from time to time.
Such new versions will be similar in spirit to the present version,
but may differ in detail to address new problems or concerns.

Each version is given a distinguishing version number.  If the Library
specifies a version number of this License which applies to it and
"any later version", you have the option of following the terms and
conditions either of that version or of any later version published by
the Free Software Foundation.  If the Library does not specify a
license version number, you may choose any version ever published by
the Free Software Foundation.

  14. If you wish to incorporate parts of the Library into other free
programs whose distribution conditions are incompatible with these,
write to the author to ask for permission.  For software which is
copyrighted by the Free Software Foundation, write to the Free
Software Foundation; we sometimes make exceptions for this.  Our
decision will be guided by the two goals of preserving the free status
of all derivatives of our free software and of promoting the sharing
and reuse of software generally.

			    NO WARRANTY

  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO
WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.
EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR
OTHER PARTIES PROVIDE THE LIBRARY "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME
THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU
FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR
CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

		     END OF TERMS AND CONDITIONS





(loki_setup, loki_update license:)

		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 		59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	Appendix: How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 19yy  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) 19yy name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


/* end of README.linux ... */

                                                                                                         System/                                                                                             0040777 0001750 0000144 00000000000 07542467526 011761  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  System/Default.ini                                                                                  0100644 0001750 0000144 00000025452 07542467526 014047  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  [URL]
Protocol=unreal
ProtocolDescription=Unreal Protocol
Name=Player
Map=Index.ut2
LocalMap=NvidiaLogo.ut2
NetBrowseMap=Entry.ut2
Host=
Portal=
MapExt=ut2
EXEName=UT2003.exe
SaveExt=usa
Port=7777
Class=Engine.Pawn
Character=Gorge

[FirstRun]
FirstRun=0

[Engine.Engine]
;RenderDevice=D3DDrv.D3DRenderDevice
;RenderDevice=Engine.NullRenderDevice
RenderDevice=OpenGLDrv.OpenGLRenderDevice
AudioDevice=ALAudio.ALAudioSubsystem
NetworkDevice=IpDrv.TcpNetDriver
DemoRecordingDevice=Engine.DemoRecDriver
Console=XInterface.extendedconsole
GUIController=XInterface.GUIController
Language=int
Product=UT2003
GameEngine=Engine.GameEngine
EditorEngine=Editor.EditorEngine
DefaultGame=XGame.XDeathmatch
DefaultServerGame=XGame.XDeathmatch
;ViewportManager=WinDrv.WindowsClient
ViewportManager=SDLDrv.SDLClient
Render=Render.Render
Input=Engine.Input
Canvas=Engine.Canvas

[Core.System]
PurgeCacheDays=30
SavePath=../Save
CachePath=../Cache
CacheExt=.uxx
Paths=../System/*.u
Paths=../Maps/*.ut2
Paths=../Textures/*.utx
Paths=../Sounds/*.uax
Paths=../Music/*.umx
Paths=../StaticMeshes/*.usx
Paths=../Animations/*.ukx
Paths=../Saves/*.uvx
Suppress=DevLoad
Suppress=DevSave
Suppress=DevNetTraffic
Suppress=DevGarbage
Suppress=DevKill
Suppress=DevReplace
Suppress=DevCompile
Suppress=DevBind
Suppress=DevBsp

[Engine.GameEngine]
CacheSizeMegs=32
UseSound=True
ServerActors=IpDrv.MasterServerUplink
ServerActors=UWeb.WebServer
ServerPackages=Core
ServerPackages=Engine
ServerPackages=Fire
ServerPackages=Editor
ServerPackages=IpDrv
ServerPackages=UWeb
ServerPackages=GamePlay
ServerPackages=UnrealGame
ServerPackages=XEffects
ServerPackages=XPickups
ServerPackages=XGame
ServerPackages=XWeapons
ServerPackages=XInterface
ServerPackages=Vehicles
ServerPackages=TeamSymbols_UT2003
MainMenuClass=XInterface.UT2MainMenu
ConnectingMenuClass=XInterface.MenuConnecting
DisconnectMenuClass=XInterface.UT2NetworkStatusMsg
UseStaticMeshBatching=True

[WinDrv.WindowsClient]
WindowedViewportX=640
WindowedViewportY=480
FullscreenViewportX=800
FullscreenViewportY=600
MenuViewportX=640
MenuViewportY=480
Brightness=0.800000
Contrast=0.700000
Gamma=0.800000
UseJoystick=False
CaptureMouse=True
StartupFullscreen=True
ScreenFlashes=True
NoLighting=False
MinDesiredFrameRate=35.000000
Decals=True
Coronas=True
DecoLayers=True
Projectors=True
NoDynamicLights=False
ReportDynamicUploads=False
TextureDetailInterface=Normal
TextureDetailTerrain=Normal
TextureDetailWeaponSkin=Normal
TextureDetailPlayerSkin=Normal
TextureDetailWorld=Normal
TextureDetailRenderMap=Normal
TextureDetailLightmap=UltraHigh
TextureMaxLOD=0
TextureMinLOD=0
NoFractalAnim=False
ScaleHUDX=0.0

[SDLDrv.SDLClient]
WindowedViewportX=640
WindowedViewportY=480
FullscreenViewportX=800
FullscreenViewportY=600
MenuViewportX=640
MenuViewportY=480
Brightness=0.800000
Contrast=0.700000
Gamma=0.800000
UseJoystick=False
JoystickNumber=0
IgnoreHat=False
JoystickHatNumber=0
CaptureMouse=True
StartupFullscreen=True
ScreenFlashes=True
NoLighting=False
MinDesiredFrameRate=35.000000
Decals=True
Coronas=True
DecoLayers=True
Projectors=True
NoDynamicLights=False
ReportDynamicUploads=False
TextureDetailInterface=Normal
TextureDetailTerrain=Normal
TextureDetailWeaponSkin=Normal
TextureDetailPlayerSkin=Normal
TextureDetailWorld=Normal
TextureDetailRenderMap=Normal
TextureDetailLightmap=UltraHigh
TextureMaxLOD=0
TextureMinLOD=0
NoFractalAnim=False

[Engine.Player]
ConfiguredInternetSpeed=2600
ConfiguredLanSpeed=20000

[ALAudio.ALAudioSubsystem]
UseEAX=False
Use3DSound=False
UseDefaultDriver=True
CompatibilityMode=False
UsePrecache=True
ReverseStereo=false
Channels=32
MusicVolume=0.1
AmbientVolume=0.3
SoundVolume=1.0
DopplerFactor=1.0
Rolloff=0.5
TimeBetweenHWUpdates=15
DisablePitch=False
LowQualitySound=False

[IpDrv.TcpNetDriver]
AllowDownloads=True
ConnectionTimeout=120.0
InitialConnectTimeout=200.0
AckTimeout=1.0
KeepAliveTime=0.2
MaxClientRate=20000
SimLatency=0
RelevantTimeout=5.0
SpawnPrioritySeconds=1.0
ServerTravelPause=4.0
NetServerMaxTickRate=20
LanServerMaxTickRate=35
DownloadManagers=IpDrv.HTTPDownload
DownloadManagers=Engine.ChannelDownload
AllowPlayerPortUnreach=False
LogPortUnreach=True

[IpDrv.HTTPDownload]
RedirectToURL=
ProxyServerHost=
ProxyServerPort=3128
UseCompression=True

[Engine.DemoRecDriver]
DemoSpectatorClass=Engine.DemoRecSpectator
MaxClientRate=25000
ConnectionTimeout=15.0
InitialConnectTimeout=200.0
AckTimeout=1.0
KeepAliveTime=1.0
SimLatency=0
RelevantTimeout=5.0
SpawnPrioritySeconds=1.0
ServerTravelPause=4.0
NetServerMaxTickRate=60
LanServerMaxTickRate=60

[Engine.GameReplicationInfo]
ServerName=Another UT2003 Server
ShortName=UT2 Server
ServerRegion=0
AdminName=
AdminEmail=
MOTDLine1=
MOTDLine2=
MOTDLine3=
MOTDLine4=

[IpServer.UdpServerQuery]
GameName=ut2

[IpDrv.UdpBeacon]
DoBeacon=True
BeaconTime=0.50
BeaconTimeout=5.0
BeaconProduct=ut2

[D3DDrv.D3DRenderDevice]
DetailTextures=True
HighDetailActors=True
SuperHighDetailActors=True
UsePrecaching=True
UseTrilinear=True
AdapterNumber=-1
ReduceMouseLag=True
UseTripleBuffering=False
UseHardwareTL=True
UseHardwareVS=True
UseCubemaps=True
DesiredRefreshRate=60
UseCompressedLightmaps=True
UseStencil=False
Use16bit=False
Use16bitTextures=False
MaxPixelShaderVersion=255
UseVSync=False
LevelOfAnisotropy=1
DetailTexMipBias=0.8
DefaultTexMipBias=-0.5
UseNPatches=False
TesselationFactor=1.0
CheckForOverflow=False

[OpenGLDrv.OpenGLRenderDevice]
DetailTextures=True
HighDetailActors=True
SuperHighDetailActors=True
UsePrecaching=True
UseCompressedLightmaps=True
UseTrilinear=True
UseStencil=False
MaxTextureUnits=8
VARSize=20

[Engine.NullRenderDevice]
DetailTextures=True
HighDetailActors=True
SuperHighDetailActors=True
UsePrecaching=True
UseCompressedLightmaps=True
UseStencil=False

[Editor.EditorEngine]
UseSound=True
CacheSizeMegs=32
GridEnabled=True
SnapVertices=False
SnapDistance=1.000000
GridSize=(X=4.000000,Y=4.000000,Z=4.000000)
RotGridEnabled=True
RotGridSize=(Pitch=1024,Yaw=1024,Roll=1024)
GameCommandLine=-log
FovAngleDegrees=90.000000
GodMode=True
AutoSave=True
AutoSaveTimeMinutes=5
AutoSaveIndex=6
UseAxisIndicator=True
MatineeCurveDetail=0.1
ShowIntWarnings=False
UseSizingBox=True
;RenderDevice=D3DDrv.D3DRenderDevice
AudioDevice=ALAudio.ALAudioSubsystem
NetworkDevice=IpDrv.TcpNetDriver
DemoRecordingDevice=Engine.DemoRecDriver
Console=Engine.Console
Language=ute
AlwaysShowTerrain=False
UseActorRotationGizmo=False
LoadEntirePackageWhenSaving=0
EditPackages=Core
EditPackages=Engine
EditPackages=Fire
EditPackages=Editor
EditPackages=UnrealEd
EditPackages=IpDrv
EditPackages=UWeb
EditPackages=GamePlay
EditPackages=UnrealGame
EditPackages=XGame_rc
EditPackages=XEffects
EditPackages=XWeapons_rc
EditPackages=XPickups_rc
EditPackages=XPickups
EditPackages=XGame
EditPackages=XWeapons
EditPackages=XInterface
EditPackages=XAdmin
EditPackages=XWebAdmin
EditPackages=Vehicles

[UWeb.WebServer]
Applications[0]=xWebAdmin.UTServerAdmin
ApplicationPaths[0]=/ServerAdmin
Applications[1]=xWebAdmin.UTImageServer
ApplicationPaths[1]=/images
DefaultApplication=0
bEnabled=False

[Engine.Console]
ConsoleHotKey=9
TimePerTitle=30.0
TimePerDemo=60.0
TimePerSoak=3600.0
TimeTooIdle=60.0
DemoLevels[0]=DM-Curse3
DemoLevels[1]=DM-Antalus
DemoLevels[2]=CTF-Chrome
DemoLevels[3]=DOM-SunTemple
DemoLevels[4]=BR-Endagra

[Engine.AccessControl]
AdminPassword=
KickToMenu=Xinterface.UT2NetworkStatusMsg
GamePassword=

[Engine.GameInfo]
GoreLevel=0
MaxSpectators=2
MaxPlayers=32
AutoAim=1.000000
GameSpeed=1.000000
bChangeLevels=True
bStartUpLocked=False
bNoBots=False
bAttractAlwaysFirstPerson=False
NumMusicFiles=13
bEnableStatLogging=true
HUDType=Engine.Hud
MaxLives=0
TimeLimit=0
GoalScore=0

[Engine.AmbientSound]
AmbientVolume=0.25

[Engine.LevelInfo]
PhysicsDetailLevel=PDL_Medium
bLowSoundDetail=False
DecalStayScale=1.0
bNeverPrecache=false

[xInterface.Tab_MultiplayerHostMain]
LastGameType=XGame.xDeathmatch
LastMap=DM-Antalus

[xInterface.Tab_InstantActionMain]
LastGameType=XGame.xDeathmatch
LastMap=DM-Antalus
LastBotSkill=1
LastBotCount=4
LastUseMapBots=True
LastUseCustomBots=False

[xInterface.Tab_InstantActionBaseRules]
LastFriendlyFire=0
LastWeaponStay=True
LastTranslocator=False
LastGameSpeed=1.0
LastGoalScore=0
LastTimeLimit=0
LastMaxLives=0

[xInterface.Tab_IADeathMatch]
LastFriendlyFire=0
LastWeaponStay=True
LastTranslocator=False
LastGameSpeed=1.0
LastGoalScore=25
LastTimeLimit=15
LastMaxLives=0
LastAutoAdjustSkill=False

[xInterface.Tab_IATeamDeathMatch]
LastFriendlyFire=0
LastWeaponStay=True
LastTranslocator=False
LastGameSpeed=1.0
LastGoalScore=35
LastTimeLimit=15
LastMaxLives=0
LastAutoAdjustSkill=False

[xInterface.Tab_IACaptureTheFlag]
LastFriendlyFire=0.000000
LastWeaponStay=True
LastTranslocator=True
LastGameSpeed=1.000000
LastGoalScore=3
LastTimeLimit=15
LastMaxLives=0

[xInterface.Tab_IABombingRun]
LastFriendlyFire=0
LastWeaponStay=True
LastTranslocator=True
LastGameSpeed=1.0
LastGoalScore=21
LastTimeLimit=15
LastMaxLives=0

[xInterface.Tab_IADoubleDomination]
LastFriendlyFire=0
LastWeaponStay=True
LastTranslocator=False
LastGameSpeed=1.0
LastGoalScore=3
LastTimeLimit=15
LastMaxLives=0

[xInterface.Tab_InstantActionMutators]
LastActiveMutators=

[xInterface.Tab_MultiplayerHostServerSettings]
bDedicated=False
bLanPlay=False
BotSkill=1
bUseDefaults=False
bUseCustomBots=False
MinPlayers=0
MaxPlayers=16
MaxSpecs=2
AdminName=Admin
AdminPass=
GamePass=
bCollectStats=False
bBalanceTeams=True

[xInterface.ExtendedConsole]
ConsoleHotKey=192
PasswordPromptMenu=XInterface.UT2GetPassword

[XInterface.GUIController]
MenuMouseSens=1.25

[XGame.xDeathMatch]
HUDType=XInterface.HudBDeathMatch
MaxLives=0
TimeLimit=0
GoalScore=25
bTeamScoreRound=False
bPlayersMustBeReady=False
bAllowTaunts=True
bForceRespawn=False
bWeaponStay=false


[XGame.xTeamGame]
HUDType=XInterface.HudBTeamDeathMatch
MaxLives=0
TimeLimit=0
GoalScore=60
bTeamScoreRound=False
bPlayersMustBeReady=False
bAllowTaunts=True
FriendlyFireScale=0
MaxTeamSize=16
bForceRespawn=False
bWeaponStay=true

[XGame.xCTFGame]
HUDType=XInterface.HudBCaptureTheFlag
MaxLives=0
TimeLimit=0
GoalScore=0
bTeamScoreRound=False
bPlayersMustBeReady=False
bAllowTaunts=True
FriendlyFireScale=0
MaxTeamSize=16
bForceRespawn=False
bWeaponStay=true

[XGame.xDoubleDom]
HUDType=XInterface.HudBDoubleDomination
MaxLives=0
TimeLimit=0
GoalScore=3
bTeamScoreRound=False
bPlayersMustBeReady=False
bAllowTaunts=True
TimeToScore=10
TimeDisabled=10
FriendlyFireScale=0
MaxTeamSize=16
bForceRespawn=False
bWeaponStay=true

[XGame.xBombingRun]
HUDType=XInterface.HudBBombingRun
MaxLives=0
TimeLimit=0
GoalScore=15
bTeamScoreRound=False
bPlayersMustBeReady=False
bAllowTaunts=True
FriendlyFireScale=0
MaxTeamSize=16
bForceRespawn=False
bWeaponStay=true

[IpDrv.MasterServerLink]
LANPort=11777
LANServerPort=10777
CurrentMasterServer=0
MasterServerPort[0]=28902
MasterServerAddress[0]=ut2003master1.epicgames.com
MasterServerPort[1]=28902
MasterServerAddress[1]=ut2003master2.epicgames.com
MasterServerPort[2]=0
MasterServerAddress[2]=
MasterServerPort[3]=0
MasterServerAddress[3]=
MasterServerPort[4]=0
MasterServerAddress[4]=

                                                                                                                                                                                                                      System/DefUser.ini                                                                                  0100644 0001750 0000144 00000020002 07542467526 014002  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  [DefaultPlayer]
Name=Player
Class=Engine.Pawn
Character=Gorge
team=255
    
[Engine.Input]
Aliases[0]=(Command="Button bFire | Fire",Alias=Fire)
Aliases[1]=(Command="Button bAltFire | AltFire",Alias=AltFire)
Aliases[2]=(Command="Axis aBaseY  Speed=+300.0",Alias=MoveForward)
Aliases[3]=(Command="Axis aBaseY  Speed=-300.0",Alias=MoveBackward)
Aliases[4]=(Command="Axis aBaseX Speed=-40.0",Alias=TurnLeft)
Aliases[5]=(Command="Axis aBaseX  Speed=+40.0",Alias=TurnRight)
Aliases[6]=(Command="Axis aStrafe Speed=-300.0",Alias=StrafeLeft)
Aliases[7]=(Command="Axis aStrafe Speed=+300.0",Alias=StrafeRight)
Aliases[8]=(Command="Jump | Axis aUp Speed=+300.0",Alias=Jump)
Aliases[9]=(Command="Button bDuck | Axis aUp Speed=-300.0",Alias=Duck)
Aliases[10]=(Command="Button bLook",Alias=Look)
Aliases[11]=(Command="Toggle bLook",Alias=LookToggle)
Aliases[12]=(Command="ActivateItem",Alias=InventoryActivate)
Aliases[13]=(Command="NextItem",Alias=InventoryNext)
Aliases[14]=(Command="PrevItem",Alias=InventoryPrevious)
Aliases[15]=(Command="Axis aLookUp Speed=+25.0",Alias=LookUp)
Aliases[16]=(Command="Axis aLookUp Speed=-25.0",Alias=LookDown)
Aliases[17]=(Command="Button bSnapLevel",Alias=CenterView)
Aliases[18]=(Command="Button bRun",Alias=Walking)
Aliases[19]=(Command="Button bStrafe",Alias=Strafe)
Aliases[20]=(Command="NextWeapon",Alias=NextWeapon)
Aliases[23]=(Command="Button bFreeLook",Alias=FreeLook)
Aliases[24]=(Command="ViewClass Pawn",Alias=ViewTeam)
Aliases[25]=(Command="Button bTurnToNearest",Alias=TurnToNearest)
Aliases[26]=(Command="Button bTurn180",Alias=Turn180)
Aliases[27]=(Command="",Alias=None)
Aliases[28]=(Command="",Alias=None)
Aliases[29]=(Command="",Alias=None)
Aliases[30]=(Command="",Alias=None)
Aliases[31]=(Command="",Alias=None)
Aliases[32]=(Command="",Alias=None)
Aliases[33]=(Command="",Alias=None)
Aliases[34]=(Command="",Alias=None)
Aliases[35]=(Command="",Alias=None)
Aliases[36]=(Command="",Alias=None)
Aliases[37]=(Command="",Alias=None)
Aliases[38]=(Command="",Alias=None)
Aliases[39]=(Command="",Alias=None)

0=SwitchWeapon 0
1=SwitchWeapon 1
2=SwitchWeapon 2
3=SwitchWeapon 3
4=SwitchWeapon 4
5=SwitchWeapon 5
6=SwitchWeapon 6
7=SwitchWeapon 7
8=SwitchWeapon 8
9=SwitchWeapon 9

F1=ShowScores
F2=ShowPersonalStats
F3=ShowObjectives
F4=ToggleBehindView
F5=ToggleFreeCam
F6=ToggleFreeCamZoom
F7=ToggleFreeCamSwivel
F8=
F9=shot
F10=Cancel
F11=
F12=
F13=
F14=
F15=
F16=
F17=
F18=
F19=
F20=
F21=
F22=
F23=
F24=

A=StrafeLeft
B=
C=Duck
D=StrafeRight
E=
F=
G=
H=
I=
j=Taunt pthrust
K=Taunt asssmack
L=Taunt throatcut
M=BasePath 0
N=BasePath 1
O=
P=
Q=SwitchWeapon 10
R=TeamTalk
S=MoveBackward
T=Talk
U=Use
V=SpeechMenuToggle
W=MoveForward
X=ShowVoteMenu
Y=writetolog
Z=Strafe

Alt=
Attn=
Backslash=ThrowWeapon
Backspace=Jump
Cancel=
CapsLock=LookToggle
Comma=StrafeLeft
CrSel=
Ctrl=Jump
Delete=LookUp
Down=MoveBackward
End=CenterView | ACTOR ALIGN SNAPTOFLOOR ALIGN=1
Enter=InventoryActivate
Equals=GrowHUD
Escape=ShowMenu
ErEof=
Execute=
ExSel=
GreySlash=
GreyStar=
Help=
home=
Insert=
LControl=
Left=StrafeLeft
LeftBracket=InventoryPrevious
LShift=
Minus=ShrinkHUD
NoName=
None=
OemClear=
PA1=
PageDown=LookDown
PageUp=
Pause=Pause
Period=StrafeRight
Play=
Print=
PrintScrn=
RControl=
Right=StrafeRight
RightBracket=InventoryNext
RShift=
ScrollLock=
Select=
Semicolon=Taunt gesture_point
Separator=
Shift=Walking
SingleQuote=Strafe
Slash=NextWeapon
Space=Jump
Tab=Type
Tilde=ConsoleToggle
Up=MoveForward
Zoom=

LeftMouse=Fire
MiddleMouse=MoveForward
RightMouse=AltFire
MouseWheelDown=NextWeapon
MouseWheelUp=PrevWeapon
MouseX=Count bXAxis | Axis aMouseX Speed=2.0 
MouseY=Count bYAxis | Axis aMouseY Speed=2.0
MouseZ=

NumLock=
NumPad0=set playercontroller bZeroRoll False | set playercontroller rotation (pitch=0,yaw=0,roll=16384)
NumPad1=set playercontroller bZeroRoll False | set playercontroller rotation (pitch=0,yaw=32768,roll=-16384)
NumPad2=set playercontroller bZeroRoll False | set playercontroller rotation (pitch=0,yaw=16384,roll=32768)
NumPad3=set playercontroller bZeroRoll False | set playercontroller rotation (pitch=0,yaw=-16384,roll=0)
NumPad4=set playercontroller bZeroRoll False | set playercontroller rotation (pitch=16384,yaw=0,roll=16384)
NumPad5=set playercontroller bZeroRoll False | set playercontroller rotation (pitch=-16384,yaw=0,roll=16384)
NumPad6=set playercontroller bZeroRoll True | set playercontroller rotation (pitch=0,yaw=0,roll=0)
NumPad7=StrafeLeft
NumPad8=MoveForward
NumPad9=StrafeRight
NumPadPeriod=

Joy1=Fire
Joy2=Jump
Joy3=AltFire
Joy4=Duck
Joy5=NextWeapon
Joy6=SwitchWeapon 2
Joy7=SwitchWeapon 3
Joy8=SwitchWeapon 4
Joy9=SwitchWeapon 9
Joy10=SwitchWeapon 0
Joy11=InventoryPrevious
Joy12=InventoryActivate
Joy13=InventoryNext
Joy14=
Joy15=
Joy16=
JoyX=Axis aStrafe SpeedBase=32768.0 DeadZone=0.4
JoyY=Axis aBaseY SpeedBase=32768.0 DeadZone=0.4 Invert=-1
JoyZ=
JoyR=
JoyU=
JoyV=Axis aBaseX SpeedBase=2.0 DeadZone=0.4
JoySlider1=Axis aLookUp SpeedBase=2.0 DeadZone=0.4
JoySlider2=

[Engine.PlayerController]
bNeverSwitchOnPickup=false
bNoVoiceMessages=false
bNoVoiceTaunts=false
bNoAutoTaunts=false
bAutoTaunt=false
bNoMatureLanguage=false
AnnouncerVolume=4
DesiredFOV=85.000000
DefaultFOV=85.000000
MaxTimeMargin=1.000000
ngWorldSecret=
bLookUpStairs=False
bSnapToLevel=False
bAlwaysMouseLook=True
bKeyboardLook=True
bAlwaysLevel=False
ngSecretSet=False
EnemyTurnSpeed=45000
InputClass=Class'Engine.PlayerInput'
Handedness=1.000000
TeamBeaconMaxDist=4000.000000
TeamBeaconPlayerInfoMaxDist=1200.000000
TeamBeaconTexture=TeamSymbols.TeamBeaconT
TeamBeaconTeamColors[0]=(B=0,G=0,R=180,A=255)
TeamBeaconTeamColors[1]=(B=200,G=80,R=80,A=255)
TeamBeaconCustomColor=(B=0,G=255,R=255,A=255)
TeamBeaconUseCustomColor=True
MaxResponseTime=0.5

[Engine.PlayerInput]
bInvertMouse=false
MouseSensitivity=3.000000
MouseSmoothingMode=1
MouseSmoothingStrength=+0.3
MouseSamplingTime=+0.008333
bEnableDodging=true

[Engine.Pawn]
Bob=0.0080
bWeaponBob=True

[Engine.HUD]
bHideHUD=false
HudScale=1.0
HudCanvasScale=1.0
bMessageBeep=true
bShowWeaponInfo=true
bShowPersonalInfo=true
bShowPoints=true
bCrosshairShow=true
CrosshairScale=1.0
CrosshairOpacity=1.0
CrosshairStyle=0

[XWeapons.TransLauncher]
ExchangeFireModes=0
Priority=1

[XWeapons.ShieldGun]
ExchangeFireModes=0
Priority=2

[XWeapons.AssaultRifle]
ExchangeFireModes=0
Priority=3

[XWeapons.ShockRifle]
ExchangeFireModes=0
Priority=4

[XWeapons.LinkGun]
ExchangeFireModes=0
Priority=5

[XWeapons.BioRifle]
ExchangeFireModes=0
Priority=6

[XWeapons.Minigun]
ExchangeFireModes=0
Priority=7

[XWeapons.FlakCannon]
ExchangeFireModes=0
Priority=8

[XWeapons.RocketLauncher]
ExchangeFireModes=0
Priority=9

[XWeapons.SniperRifle]
ExchangeFireModes=0
Priority=10

[XWeapons.Painter]
ExchangeFireModes=0
Priority=11

[XWeapons.Redeemer]
ExchangeFireModes=0
Priority=12

[XWeapons.BallLauncher]
ExchangeFireModes=0
Priority=13

[XInterface.MenuInstantAction]
URLOptionsPlayer=
URLOptionsGame=?bAutoNumBots=true?WeaponStay=true
URLOptionsRound=
URLOptionsMutators=
GameType=Class'XGame.xDeathMatch'

[XInterface.MenuMultiPlayerHost]
URLOptionsServer=?Lan?bAutoNumBots=False?MaxPlayers=32?MinPlayers=1
URLOptionsGame=?WeaponStay=true
URLOptionsRound=
URLOptionsMutatorList=
GameType=Class'XGame.xDeathMatch'
URLOptionsMutators=
bDedicatedServer=False

[UnrealGame.UnrealPawn]
bPlayerShadows=True

[XInterface.MapListDeathMatch]
MapNum=0
Maps=DM-Antalus
Maps=DM-Asbestos
Maps=DM-Curse3
Maps=DM-Inferno
Maps=DM-Compressed
Maps=DM-Phobos2
Maps=DM-Plunge
Maps=DM-TokaraForest

[XInterface.MapListTeamDeathMatch]
MapNum=0
Maps=DM-Antalus
Maps=DM-Asbestos
Maps=DM-Curse3
Maps=DM-Inferno
Maps=DM-Compressed
Maps=DM-Phobos2
Maps=DM-Plunge
Maps=DM-TokaraForest

[XInterface.MapListCaptureTheFlag]
MapNum=0
Maps=CTF-Chrome
Maps=CTF-Citadel
Maps=CTF-December
Maps=CTF-Face3
Maps=CTF-Geothermal
Maps=CTF-LavaGiant3
Maps=CTF-LostFaith
Maps=CTF-Magma
Maps=CTF-Orbital2

[XInterface.MapListDoubleDomination]
MapNum=0
Maps=DOM-Core
Maps=DOM-OutRigger
Maps=DOM-Ruination
Maps=DOM-ScorchedEarth
Maps=DOM-SepukkuGorge
Maps=DOM-SunTemple

[XInterface.MapListBombingRun]
MapNum=0
Maps=BR-Anubis
Maps=BR-Disclosure
Maps=BR-Bifrost
Maps=BR-IceFields
Maps=BR-SkyLine
Maps=BR-Slaughterhouse
Maps=BR-TwinTombs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Unreal.xpm                                                                                          0100666 0001750 0000144 00000057545 07537231747 012464  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  /* XPM */
static char * Unreal_xpm[] = {
"45 41 1282 2",
"  	c None",
". 	c #1B160B",
"+ 	c #312C21",
"@ 	c #49443A",
"# 	c #5B564C",
"$ 	c #635E53",
"% 	c #686358",
"& 	c #6B655A",
"* 	c #6B6559",
"= 	c #686256",
"- 	c #645E52",
"; 	c #5D574C",
"> 	c #575146",
", 	c #454035",
"' 	c #2E291E",
") 	c #191509",
"! 	c #1B170C",
"~ 	c #353126",
"{ 	c #4E493E",
"] 	c #625C52",
"^ 	c #746F64",
"/ 	c #857F74",
"( 	c #918B80",
"_ 	c #968F84",
": 	c #999287",
"< 	c #989185",
"[ 	c #948D80",
"} 	c #90887C",
"| 	c #8C8578",
"1 	c #877F73",
"2 	c #847C70",
"3 	c #726B5E",
"4 	c #655E52",
"5 	c #524C40",
"6 	c #3D382C",
"7 	c #252015",
"8 	c #201C11",
"9 	c #3C382D",
"0 	c #5C5649",
"a 	c #776F61",
"b 	c #8A8376",
"c 	c #989186",
"d 	c #A0998D",
"e 	c #9F988C",
"f 	c #9E978B",
"g 	c #9B9487",
"h 	c #979084",
"i 	c #918A7D",
"j 	c #898275",
"k 	c #857D71",
"l 	c #867D71",
"m 	c #857C6F",
"n 	c #867E71",
"o 	c #7F786A",
"p 	c #827B6D",
"q 	c #7B7366",
"r 	c #6D6659",
"s 	c #585347",
"t 	c #3B362B",
"u 	c #1D190E",
"v 	c #1A160B",
"w 	c #322E23",
"x 	c #5F5B51",
"y 	c #979182",
"z 	c #AA9E88",
"A 	c #958973",
"B 	c #837A6A",
"C 	c #878074",
"D 	c #958E82",
"E 	c #9D9589",
"F 	c #A59E92",
"G 	c #A19A8E",
"H 	c #9C9488",
"I 	c #958E81",
"J 	c #8E8679",
"K 	c #8A8276",
"L 	c #8B8376",
"M 	c #8A8275",
"N 	c #847C6F",
"O 	c #7B7466",
"P 	c #746C5E",
"Q 	c #6B6356",
"R 	c #766E60",
"S 	c #8C8375",
"T 	c #877F6F",
"U 	c #4C4638",
"V 	c #1C170C",
"W 	c #141005",
"X 	c #4D483E",
"Y 	c #959085",
"Z 	c #C7C1B7",
"` 	c #C3B393",
" .	c #8E7953",
"..	c #71644C",
"+.	c #777063",
"@.	c #878075",
"#.	c #8B8478",
"$.	c #8D8579",
"%.	c #9E968A",
"&.	c #968E82",
"*.	c #928A7E",
"=.	c #8C8477",
"-.	c #877F72",
";.	c #898074",
">.	c #898174",
",.	c #797164",
"'.	c #6C6456",
").	c #70685A",
"!.	c #7C7365",
"~.	c #887D6B",
"{.	c #92836A",
"].	c #96876B",
"^.	c #8A806D",
"/.	c #4B4539",
"(.	c #847E73",
"_.	c #BFB8AF",
":.	c #DCD6CD",
"<.	c #EADBB8",
"[.	c #9C8045",
"}.	c #71644B",
"|.	c #888276",
"1.	c #9C9589",
"2.	c #989084",
"3.	c #938B7E",
"4.	c #968F82",
"5.	c #8D8578",
"6.	c #888074",
"7.	c #81796C",
"8.	c #80786B",
"9.	c #7E7769",
"0.	c #6E6658",
"a.	c #8D8679",
"b.	c #B1ACA2",
"c.	c #CFC2AD",
"d.	c #C1A97F",
"e.	c #896F42",
"f.	c #584930",
"g.	c #60584A",
"h.	c #565145",
"i.	c #1F1B0F",
"j.	c #171308",
"k.	c #5A564B",
"l.	c #A29E94",
"m.	c #D1CDC6",
"n.	c #EBE5D9",
"o.	c #EEDDBB",
"p.	c #CEA85A",
"q.	c #806A3B",
"r.	c #89806F",
"s.	c #9E978C",
"t.	c #938B7F",
"u.	c #948C80",
"v.	c #958D80",
"w.	c #877E72",
"x.	c #82796D",
"y.	c #81796D",
"z.	c #7D7568",
"A.	c #B9B4AD",
"B.	c #E5E2DF",
"C.	c #ECDDC2",
"D.	c #C3A36A",
"E.	c #7B5E2C",
"F.	c #4F412A",
"G.	c #5D5448",
"H.	c #71685B",
"I.	c #665E50",
"J.	c #938C7F",
"K.	c #4C473B",
"L.	c #1C180D",
"M.	c #1E1A0F",
"N.	c #666156",
"O.	c #ACA9A1",
"P.	c #DCD9D3",
"Q.	c #F0E8D7",
"R.	c #F1DEB7",
"S.	c #E9CD93",
"T.	c #CDA558",
"U.	c #86724A",
"V.	c #908878",
"W.	c #9D968B",
"X.	c #8B8377",
"Y.	c #90877B",
"Z.	c #968D81",
"`.	c #8F877B",
" +	c #857D70",
".+	c #7A7265",
"++	c #9B958A",
"@+	c #D4D0CA",
"#+	c #F0EADC",
"$+	c #F1DFBE",
"%+	c #D1AD69",
"&+	c #87672E",
"*+	c #574629",
"=+	c #584F42",
"-+	c #72695B",
";+	c #5D5547",
">+	c #736B5E",
",+	c #797266",
"'+	c #39352A",
")+	c #201B10",
"!+	c #6B665B",
"~+	c #B0ACA2",
"{+	c #DDD8CD",
"]+	c #F0E5CF",
"^+	c #F2DEB8",
"/+	c #F0D7A5",
"(+	c #EED5A2",
"_+	c #E1C487",
":+	c #9F8C64",
"<+	c #8A8272",
"[+	c #918A7F",
"}+	c #837B6F",
"|+	c #80776B",
"1+	c #8D8477",
"2+	c #8D8577",
"3+	c #7D7569",
"4+	c #746C5F",
"5+	c #7C7568",
"6+	c #A19C92",
"7+	c #D7D2C8",
"8+	c #F3E7CF",
"9+	c #F5E0B7",
"0+	c #DFBB77",
"a+	c #A17A32",
"b+	c #614B25",
"c+	c #524839",
"d+	c #62594D",
"e+	c #6C6355",
"f+	c #554D40",
"g+	c #554F44",
"h+	c #221D12",
"i+	c #120E03",
"j+	c #272217",
"k+	c #B7B1A8",
"l+	c #E0DACD",
"m+	c #F0E2C6",
"n+	c #F1DBAF",
"o+	c #EFD6A3",
"p+	c #F1D9AA",
"q+	c #F2DDB3",
"r+	c #EBD19B",
"s+	c #BFA570",
"t+	c #988A6E",
"u+	c #8E8576",
"v+	c #756D61",
"w+	c #70675B",
"x+	c #786F63",
"y+	c #7F776A",
"z+	c #948871",
"A+	c #988868",
"B+	c #8F826B",
"C+	c #A8A296",
"D+	c #D6D0C3",
"E+	c #F1E1C2",
"F+	c #EFD49E",
"G+	c #EED093",
"H+	c #C9A14F",
"I+	c #795D29",
"J+	c #534731",
"K+	c #544C41",
"L+	c #5F5649",
"M+	c #665D50",
"N+	c #696153",
"O+	c #5B5345",
"P+	c #4C4437",
"Q+	c #665E52",
"R+	c #6D675B",
"S+	c #3D392E",
"T+	c #272318",
"U+	c #6A6559",
"V+	c #C0BBB3",
"W+	c #E3DCD0",
"X+	c #F4E7CB",
"Y+	c #F3DFB5",
"Z+	c #F0D9A8",
"`+	c #F1DBAD",
" @	c #F3DEB5",
".@	c #F2DBAF",
"+@	c #ECD19C",
"@@	c #DABC82",
"#@	c #C2AA7C",
"$@	c #9D8D6F",
"%@	c #776D5C",
"&@	c #60594D",
"*@	c #5F574A",
"=@	c #655D50",
"-@	c #665F52",
";@	c #7B6E56",
">@	c #AF986C",
",@	c #C6B594",
"'@	c #DFD6C2",
")@	c #F0E1C2",
"!@	c #E8CA8D",
"~@	c #E7C278",
"{@	c #E9C783",
"]@	c #B08F42",
"^@	c #635332",
"/@	c #4E4537",
"(@	c #4F473B",
"_@	c #51493C",
":@	c #564E41",
"<@	c #5A5144",
"[@	c #51483B",
"}@	c #463E31",
"|@	c #4A4236",
"1@	c #787165",
"2@	c #565146",
"3@	c #151207",
"4@	c #201C10",
"5@	c #5D584D",
"6@	c #C2BCB3",
"7@	c #EAE7E2",
"8@	c #F8EACD",
"9@	c #F4DEB1",
"0@	c #F5E0B6",
"a@	c #F5E3BD",
"b@	c #F4E2BC",
"c@	c #F0D8A6",
"d@	c #F1D9A7",
"e@	c #EAD2A2",
"f@	c #EACE92",
"g@	c #AE9764",
"h@	c #695C42",
"i@	c #4D463B",
"j@	c #494134",
"k@	c #443B2D",
"l@	c #99896A",
"m@	c #E2D3B1",
"n@	c #F8E6BF",
"o@	c #ECCF98",
"p@	c #E2BC71",
"q@	c #E5BE71",
"r@	c #E4BC6E",
"s@	c #997C3B",
"t@	c #5C5038",
"u@	c #494035",
"v@	c #463D31",
"w@	c #433B2E",
"x@	c #40382B",
"y@	c #3F3629",
"z@	c #42392C",
"A@	c #3D3628",
"B@	c #372F22",
"C@	c #6D6559",
"D@	c #5F5A4F",
"E@	c #242015",
"F@	c #130F04",
"G@	c #484438",
"H@	c #ACA89D",
"I@	c #E6E3DC",
"J@	c #FDF3DF",
"K@	c #F1D8A5",
"L@	c #EAD09B",
"M@	c #EBD6AA",
"N@	c #EFDBB4",
"O@	c #F1DCB1",
"P@	c #F0D8A8",
"Q@	c #F0D5A1",
"R@	c #EFD6A1",
"S@	c #F2D8A5",
"T@	c #ECCD8A",
"U@	c #A58B52",
"V@	c #5F5134",
"W@	c #484237",
"X@	c #3C3426",
"Y@	c #362E21",
"Z@	c #807665",
"`@	c #D5C5A3",
" #	c #F4DBA9",
".#	c #EBCB8C",
"+#	c #E6C077",
"@#	c #E5BB6A",
"##	c #E2B75E",
"$#	c #947841",
"%#	c #574B37",
"&#	c #463E32",
"*#	c #473F32",
"=#	c #383022",
"-#	c #2F271A",
";#	c #352C1F",
">#	c #3D3629",
",#	c #342C1F",
"'#	c #574F43",
")#	c #5A544A",
"!#	c #312D23",
"~#	c #322D22",
"{#	c #868177",
"]#	c #E2DED5",
"^#	c #FDF5E4",
"/#	c #F1D59C",
"(#	c #CFB073",
"_#	c #9A7F4E",
":#	c #907546",
"<#	c #B29560",
"[#	c #DDBF87",
"}#	c #F2D7A3",
"|#	c #F0D8A7",
"1#	c #EDCF92",
"2#	c #EFD297",
"3#	c #EACB86",
"4#	c #A3884F",
"5#	c #5F5034",
"6#	c #484138",
"7#	c #4A4235",
"8#	c #41392B",
"9#	c #393123",
"0#	c #322A1C",
"a#	c #7D786D",
"b#	c #D8D0BC",
"c#	c #F7E6BE",
"d#	c #EFD49D",
"e#	c #EDCD90",
"f#	c #E7C072",
"g#	c #E7BF6C",
"h#	c #947942",
"i#	c #534733",
"j#	c #484034",
"k#	c #342B1D",
"l#	c #31291C",
"m#	c #3E3629",
"n#	c #352C21",
"o#	c #473F33",
"p#	c #534D42",
"q#	c #38342A",
"r#	c #181408",
"s#	c #666155",
"t#	c #C8C2B9",
"u#	c #EDE5D5",
"v#	c #DBC18E",
"w#	c #A98541",
"x#	c #846023",
"y#	c #573E12",
"z#	c #533A12",
"A#	c #81632F",
"B#	c #C2A56C",
"C#	c #EED7AA",
"D#	c #F3DEB4",
"E#	c #EED199",
"F#	c #F2D8A6",
"G#	c #EBCC8A",
"H#	c #A0834A",
"I#	c #58482B",
"J#	c #3F382E",
"K#	c #423A2C",
"L#	c #393022",
"M#	c #362D20",
"N#	c #31281B",
"O#	c #7C7465",
"P#	c #D7D2BF",
"Q#	c #F8ECCC",
"R#	c #F2DBB0",
"S#	c #F0D7A6",
"T#	c #EDCE8C",
"U#	c #937A43",
"V#	c #493F2A",
"W#	c #433B2F",
"X#	c #453C2F",
"Y#	c #3A3224",
"Z#	c #3F3729",
"`#	c #292114",
" $	c #322A1E",
".$	c #40382C",
"+$	c #544E43",
"@$	c #3F3B32",
"#$	c #464135",
"$$	c #9F9A90",
"%$	c #D9D1C4",
"&$	c #CCB998",
"*$	c #906D31",
"=$	c #5F4416",
"-$	c #534020",
";$	c #564B39",
">$	c #837355",
",$	c #C5AE82",
"'$	c #EED7A7",
")$	c #F2DFB5",
"!$	c #EFD299",
"~$	c #F3DCAF",
"{$	c #EDCF91",
"]$	c #9F844B",
"^$	c #534427",
"/$	c #393228",
"($	c #32291C",
"_$	c #362E20",
":$	c #2E2518",
"<$	c #797061",
"[$	c #D6CDB7",
"}$	c #F7E7C1",
"|$	c #F1DAAB",
"1$	c #EFD195",
"2$	c #EFD395",
"3$	c #957C45",
"4$	c #483D28",
"5$	c #3F382C",
"6$	c #40382A",
"7$	c #31291B",
"8$	c #231C0F",
"9$	c #2C2518",
"0$	c #2B2317",
"a$	c #3B3328",
"b$	c #544E44",
"c$	c #413D35",
"d$	c #787266",
"e$	c #CBC4B7",
"f$	c #D6C6A8",
"g$	c #A0814A",
"h$	c #4B3D28",
"i$	c #5D5344",
"j$	c #6E6659",
"k$	c #6C6458",
"l$	c #8B8271",
"m$	c #CABB9D",
"n$	c #F5DFB2",
"o$	c #F0D5A0",
"p$	c #EAC987",
"q$	c #9F8248",
"r$	c #534326",
"s$	c #373126",
"t$	c #3B3225",
"u$	c #2E2619",
"v$	c #372E21",
"w$	c #2A2215",
"x$	c #746B5B",
"y$	c #D4C7AA",
"z$	c #F5DEAD",
"A$	c #ECCD8F",
"B$	c #E6C480",
"C$	c #E8C67E",
"D$	c #947A42",
"E$	c #4A3F2A",
"F$	c #3D352A",
"G$	c #3C3326",
"H$	c #271F11",
"I$	c #1F180B",
"J$	c #251D11",
"K$	c #211A0D",
"L$	c #3A3226",
"M$	c #504A40",
"N$	c #3A362F",
"O$	c #423E33",
"P$	c #A29C90",
"Q$	c #D9CAB0",
"R$	c #BFA371",
"S$	c #7A5B24",
"T$	c #574832",
"U$	c #615A4E",
"V$	c #6F675A",
"W$	c #776E61",
"X$	c #6C6356",
"Y$	c #CCC0A8",
"Z$	c #F8E0AF",
"`$	c #EDCC8B",
" %	c #EED092",
".%	c #E7C173",
"+%	c #9E7F42",
"@%	c #362F24",
"#%	c #393124",
"$%	c #2F2619",
"%%	c #3A3124",
"&%	c #2A2216",
"*%	c #726858",
"=%	c #D2BF9C",
"-%	c #EDCE8F",
";%	c #DCB465",
">%	c #D6B062",
",%	c #D1AC60",
"'%	c #D8AD58",
")%	c #93753B",
"!%	c #4A3E29",
"~%	c #393126",
"{%	c #342B1E",
"]%	c #282012",
"^%	c #231B0E",
"/%	c #241D10",
"(%	c #1D1609",
"_%	c #20180B",
":%	c #191106",
"<%	c #3C352A",
"[%	c #4E483F",
"}%	c #312D26",
"|%	c #120D02",
"1%	c #716B5F",
"2%	c #BEB5A4",
"3%	c #C2AA82",
"4%	c #90703C",
"5%	c #655232",
"6%	c #6C655A",
"7%	c #6D6457",
"8%	c #61584B",
"9%	c #C7B99F",
"0%	c #EDCE91",
"a%	c #DBB15D",
"b%	c #E5C179",
"c%	c #E6C277",
"d%	c #E0B45D",
"e%	c #9B7939",
"f%	c #504023",
"g%	c #332C22",
"h%	c #433A2D",
"i%	c #31291D",
"j%	c #786E5D",
"k%	c #CFB98F",
"l%	c #DDB86E",
"m%	c #C0933A",
"n%	c #B68E3C",
"o%	c #BC9547",
"p%	c #C5973D",
"q%	c #8F6F33",
"r%	c #443822",
"s%	c #312A1E",
"t%	c #241C0F",
"u%	c #1C1307",
"v%	c #1C1407",
"w%	c #120B02",
"x%	c #443E34",
"y%	c #4E4940",
"z%	c #25221C",
"A%	c #968E7D",
"B%	c #BEAD8F",
"C%	c #90754D",
"D%	c #604928",
"E%	c #685F53",
"F%	c #827A6D",
"G%	c #797163",
"H%	c #6A6154",
"I%	c #5F564A",
"J%	c #837A6D",
"K%	c #BEAE90",
"L%	c #CEAD6B",
"M%	c #AD7E20",
"N%	c #CBA24F",
"O%	c #D0A755",
"P%	c #CE9E44",
"Q%	c #93702D",
"R%	c #4C3C1F",
"S%	c #2F281E",
"T%	c #494033",
"U%	c #393125",
"V%	c #807664",
"W%	c #CCB588",
"X%	c #CDA65A",
"Y%	c #A67A20",
"Z%	c #9E7624",
"`%	c #B28C3E",
" &	c #B98B34",
".&	c #8A682A",
"+&	c #3C2F1A",
"@&	c #292113",
"#&	c #231B0D",
"$&	c #20190B",
"%&	c #1F170A",
"&&	c #1A1105",
"*&	c #191104",
"=&	c #100A02",
"-&	c #514B43",
";&	c #4E4942",
">&	c #181610",
",&	c #474238",
"'&	c #AA9C80",
")&	c #978059",
"!&	c #5E4A2C",
"~&	c #554B3B",
"{&	c #766F63",
"]&	c #766E61",
"^&	c #675F51",
"/&	c #60574A",
"(&	c #877D6F",
"_&	c #B8A98D",
":&	c #AA905C",
"<&	c #76520A",
"[&	c #A78239",
"}&	c #A88336",
"|&	c #AE812C",
"1&	c #896423",
"2&	c #4B391B",
"3&	c #292319",
"4&	c #3E3528",
"5&	c #342C20",
"6&	c #7B705A",
"7&	c #C9B284",
"8&	c #CDA75C",
"9&	c #AA7D24",
"0&	c #A67C28",
"a&	c #B48D40",
"b&	c #B7872E",
"c&	c #876223",
"d&	c #3B2D18",
"e&	c #292116",
"f&	c #271E11",
"g&	c #1D1509",
"h&	c #1A1206",
"i&	c #160F02",
"j&	c #120C01",
"k&	c #1A1409",
"l&	c #5D584E",
"m&	c #48453E",
"n&	c #6A665B",
"o&	c #A7936D",
"p&	c #735D36",
"q&	c #534530",
"r&	c #635B50",
"s&	c #6E6558",
"t&	c #5C5446",
"u&	c #62594C",
"v&	c #564E42",
"w&	c #7A6F5D",
"x&	c #AF9F7D",
"y&	c #AF955E",
"z&	c #7A5810",
"A&	c #9D772C",
"B&	c #94702A",
"C&	c #9E7323",
"D&	c #845F1F",
"E&	c #493719",
"F&	c #251F15",
"G&	c #2D2518",
"H&	c #292115",
"I&	c #746851",
"J&	c #CBB385",
"K&	c #DFB86B",
"L&	c #CA9837",
"M&	c #C49231",
"N&	c #BE923C",
"O&	c #BB8A2E",
"P&	c #876121",
"Q&	c #3B2E17",
"R&	c #282115",
"S&	c #271F12",
"T&	c #170F03",
"U&	c #130D01",
"V&	c #0C0600",
"W&	c #312C23",
"X&	c #58534A",
"Y&	c #36332D",
"Z&	c #847D70",
"`&	c #937C55",
" *	c #635234",
".*	c #564C3D",
"+*	c #645C50",
"@*	c #635B4E",
"#*	c #534B3D",
"$*	c #554D3F",
"%*	c #574F41",
"&*	c #483F33",
"**	c #6D6250",
"=*	c #B3A07A",
"-*	c #CAAA69",
";*	c #967025",
">*	c #977229",
",*	c #A27C2E",
"'*	c #AD7E27",
")*	c #8A6522",
"!*	c #503E20",
"~*	c #30281A",
"{*	c #2B2215",
"]*	c #271F14",
"^*	c #72644E",
"/*	c #CBB280",
"(*	c #E8C275",
"_*	c #DDAF55",
":*	c #D8A94D",
"<*	c #D0A145",
"[*	c #D2A143",
"}*	c #886526",
"|*	c #3D311B",
"1*	c #272115",
"2*	c #272013",
"3*	c #1C1409",
"4*	c #110B00",
"5*	c #100B00",
"6*	c #070300",
"7*	c #534E46",
"8*	c #47433B",
"9*	c #1B1813",
"0*	c #8B8373",
"a*	c #746345",
"b*	c #5B4F3A",
"c*	c #5C5347",
"d*	c #5C5346",
"e*	c #5A5245",
"f*	c #4F4639",
"g*	c #4E4538",
"h*	c #453D30",
"i*	c #6F6452",
"j*	c #B5A078",
"k*	c #CEAB66",
"l*	c #A78135",
"m*	c #AC863B",
"n*	c #A77E2B",
"o*	c #B48328",
"p*	c #8C6622",
"q*	c #4F3C1F",
"r*	c #2E271E",
"s*	c #2D2417",
"t*	c #251E12",
"u*	c #6F634C",
"v*	c #CBB17E",
"w*	c #E8C173",
"x*	c #DFB45D",
"y*	c #E1B966",
"z*	c #DFB35A",
"A*	c #DCAA48",
"B*	c #896728",
"C*	c #382C16",
"D*	c #261F13",
"E*	c #2F271B",
"F*	c #2A2217",
"G*	c #150F05",
"H*	c #0D0800",
"I*	c #080500",
"J*	c #1B160F",
"K*	c #635C54",
"L*	c #37342E",
"M*	c #8F8779",
"N*	c #665B49",
"O*	c #584F40",
"P*	c #574F42",
"Q*	c #544C3F",
"R*	c #50473A",
"S*	c #443C2F",
"T*	c #423A2D",
"U*	c #483F32",
"V*	c #736856",
"W*	c #B39E76",
"X*	c #BF9D58",
"Y*	c #A47D30",
"Z*	c #B9903F",
"`*	c #A57B28",
" =	c #B28125",
".=	c #8A631F",
"+=	c #4C391B",
"@=	c #2A231A",
"#=	c #2D2517",
"$=	c #70634B",
"%=	c #CBB07B",
"&=	c #E2BA67",
"*=	c #D8AA4E",
"==	c #E1B864",
"-=	c #E4B860",
";=	c #DFAB46",
">=	c #8A6829",
",=	c #3A2F19",
"'=	c #2F281C",
")=	c #2E271B",
"!=	c #1E180E",
"~=	c #0D0801",
"{=	c #090500",
"]=	c #181206",
"^=	c #564B37",
"/=	c #514A40",
"(=	c #201D19",
"_=	c #928B7E",
":=	c #534B3E",
"<=	c #4C4336",
"[=	c #433B2D",
"}=	c #3F372B",
"|=	c #726754",
"1=	c #AF9A72",
"2=	c #B1904E",
"3=	c #946E23",
"4=	c #B18937",
"5=	c #A37925",
"6=	c #AC7A20",
"7=	c #865E1B",
"8=	c #4B381A",
"9=	c #2A241A",
"0=	c #2C2316",
"a=	c #261F14",
"b=	c #72644C",
"c=	c #CBB07C",
"d=	c #DBB25F",
"e=	c #CA9B3A",
"f=	c #D7AA4E",
"g=	c #E0B256",
"h=	c #E0AA44",
"i=	c #876424",
"j=	c #372B16",
"k=	c #1E170E",
"l=	c #0E0904",
"m=	c #0D0A04",
"n=	c #574628",
"o=	c #655842",
"p=	c #2D2920",
"q=	c #8E867A",
"r=	c #4D4538",
"s=	c #473F31",
"t=	c #443C2E",
"u=	c #3C3427",
"v=	c #3F372A",
"w=	c #3C3428",
"x=	c #6F6450",
"y=	c #AD9870",
"z=	c #AA8B4D",
"A=	c #846018",
"B=	c #A07A2C",
"C=	c #A97F2B",
"D=	c #AD7C21",
"E=	c #855E1B",
"F=	c #4C3A1C",
"G=	c #2D271D",
"H=	c #2C2417",
"I=	c #30281B",
"J=	c #241D12",
"K=	c #73664F",
"L=	c #D5AC5C",
"M=	c #BD8C2A",
"N=	c #C89837",
"O=	c #D6A84A",
"P=	c #E1AD4B",
"Q=	c #856021",
"R=	c #2C1F0C",
"S=	c #100B04",
"T=	c #0C0701",
"U=	c #15110C",
"V=	c #373229",
"W=	c #675A42",
"X=	c #75613E",
"Y=	c #827B70",
"Z=	c #595245",
"`=	c #41392C",
" -	c #3D3528",
".-	c #3D3529",
"+-	c #6A5F4C",
"@-	c #AC9871",
"#-	c #AF8F50",
"$-	c #845F13",
"%-	c #9B7427",
"&-	c #BC923D",
"*-	c #BD8D33",
"=-	c #8E6826",
"--	c #2D2619",
";-	c #2A2214",
">-	c #342D20",
",-	c #8A806E",
"'-	c #D3BB8B",
")-	c #D2A957",
"!-	c #B98722",
"~-	c #C08F2C",
"{-	c #CEA043",
"]-	c #DDB059",
"^-	c #866327",
"/-	c #332611",
"(-	c #1D1915",
"_-	c #2B2823",
":-	c #867963",
"<-	c #887557",
"[-	c #483D2B",
"}-	c #17140E",
"|-	c #797469",
"1-	c #362E22",
"2-	c #332B1E",
"3-	c #383023",
"4-	c #3E372A",
"5-	c #3A3326",
"6-	c #524A3D",
"7-	c #3C3429",
"8-	c #645946",
"9-	c #AE996F",
"0-	c #C19E59",
"a-	c #9F741E",
"b-	c #AE832C",
"c-	c #D4A951",
"d-	c #D0A44B",
"e-	c #A07E3C",
"f-	c #614E2A",
"g-	c #3A3121",
"h-	c #332C1F",
"i-	c #807869",
"j-	c #D0C8BA",
"k-	c #E4CC9A",
"l-	c #D1A64F",
"m-	c #C08F2A",
"n-	c #C39433",
"o-	c #CA9C40",
"p-	c #D0A95A",
"q-	c #8E6E31",
"r-	c #73603A",
"s-	c #7C725F",
"t-	c #A39D90",
"u-	c #BEB29C",
"v-	c #9D8767",
"w-	c #47361B",
"x-	c #25221B",
"y-	c #686257",
"z-	c #5D564A",
"A-	c #261E12",
"B-	c #352D21",
"C-	c #4E4739",
"D-	c #423B30",
"E-	c #2F281D",
"F-	c #615744",
"G-	c #B7A074",
"H-	c #DDB363",
"I-	c #C89229",
"J-	c #CD9932",
"K-	c #E0B55F",
"L-	c #D2A447",
"M-	c #AF8736",
"N-	c #8E7033",
"O-	c #7F693E",
"P-	c #84765A",
"Q-	c #9A9385",
"R-	c #CBC7BD",
"S-	c #F1E8D7",
"T-	c #E9CC91",
"U-	c #DAAA4A",
"V-	c #D09A2F",
"W-	c #CE9B33",
"X-	c #D3A13A",
"Y-	c #D6A645",
"Z-	c #DDB461",
"`-	c #B38933",
" ;	c #D2B578",
".;	c #EAD6AF",
"+;	c #DAC29A",
"@;	c #9C7C4C",
"#;	c #52370F",
"$;	c #2C271D",
"%;	c #3C382E",
"&;	c #706A5E",
"*;	c #413A2E",
"=;	c #221A0E",
"-;	c #2A2317",
";;	c #30281C",
">;	c #2F261A",
",;	c #271F13",
"';	c #4C402B",
");	c #6B5F4A",
"!;	c #ADA494",
"~;	c #E2D1AC",
"{;	c #E2B967",
"];	c #D8A33A",
"^;	c #D2A240",
"/;	c #D19F3A",
"(;	c #CC9D41",
"_;	c #C69F4F",
":;	c #CEAD6A",
"<;	c #DFC58F",
"[;	c #E5CD9B",
"};	c #E2C181",
"|;	c #DFB053",
"1;	c #D09D36",
"2;	c #CF9D39",
"3;	c #CB9935",
"4;	c #C69533",
"5;	c #CF9F3E",
"6;	c #D3A340",
"7;	c #D6A94D",
"8;	c #BA8E3D",
"9;	c #906623",
"0;	c #604217",
"a;	c #2E2516",
"b;	c #19150B",
"c;	c #514A3F",
"d;	c #2C2519",
"e;	c #2B2418",
"f;	c #2C2418",
"g;	c #31291E",
"h;	c #493B24",
"i;	c #85704D",
"j;	c #B59E74",
"k;	c #CDAE71",
"l;	c #DCAE50",
"m;	c #DEAE4C",
"n;	c #CD9A33",
"o;	c #C69432",
"p;	c #CE9F3F",
"q;	c #D3A445",
"r;	c #D7A747",
"s;	c #DCAC4E",
"t;	c #DFB055",
"u;	c #DCAC4D",
"v;	c #D59E30",
"w;	c #CD972C",
"x;	c #9A6F1F",
"y;	c #825D1B",
"z;	c #9C7427",
"A;	c #BD8F34",
"B;	c #BA8D32",
"C;	c #A87D26",
"D;	c #B3862B",
"E;	c #CEA248",
"F;	c #AC8338",
"G;	c #875F1E",
"H;	c #5C3F13",
"I;	c #2E2311",
"J;	c #454138",
"K;	c #5D574D",
"L;	c #443C31",
"M;	c #322B1F",
"N;	c #372D1E",
"O;	c #524126",
"P;	c #735A2E",
"Q;	c #937031",
"R;	c #B28736",
"S;	c #CC9F45",
"T;	c #CA9A3B",
"U;	c #C0902F",
"V;	c #C69636",
"W;	c #CE9E3F",
"X;	c #D5A543",
"Y;	c #D9A743",
"Z;	c #DBA844",
"`;	c #D9A63F",
" >	c #CC9629",
".>	c #A6761E",
"+>	c #6D4A11",
"@>	c #543A0F",
"#>	c #78581D",
"$>	c #A47A2D",
"%>	c #A77F31",
"&>	c #A37A2A",
"*>	c #A07726",
"=>	c #966F2A",
"->	c #78561E",
";>	c #543C16",
">>	c #2D210F",
",>	c #1E1A12",
"'>	c #58524A",
")>	c #5A5349",
"!>	c #322B20",
"~>	c #211A0F",
"{>	c #241D11",
"]>	c #282014",
"^>	c #2A2318",
"/>	c #291F10",
"(>	c #39290F",
"_>	c #573E14",
":>	c #78571E",
"<>	c #946E29",
"[>	c #A27A31",
"}>	c #AD822E",
"|>	c #B68930",
"1>	c #C3973F",
"2>	c #CFA247",
"3>	c #D7A745",
"4>	c #DCAA46",
"5>	c #D4A546",
"6>	c #AD7E29",
"7>	c #764F12",
"8>	c #402A08",
"9>	c #2B1E07",
"0>	c #4A3611",
"a>	c #72541C",
"b>	c #826022",
"c>	c #8C6826",
"d>	c #7E5C1D",
"e>	c #644615",
"f>	c #483313",
"g>	c #271E0E",
"h>	c #37332B",
"i>	c #59544B",
"j>	c #4A443A",
"k>	c #251E13",
"l>	c #221A0F",
"m>	c #241E12",
"n>	c #362A16",
"o>	c #473415",
"p>	c #4E360F",
"q>	c #5C4217",
"r>	c #78581F",
"s>	c #856324",
"t>	c #9A7633",
"u>	c #B38A3D",
"v>	c #C8993F",
"w>	c #CE9D3E",
"x>	c #B88934",
"y>	c #795215",
"z>	c #402806",
"A>	c #1A1102",
"B>	c #100B01",
"C>	c #1E1505",
"D>	c #36270A",
"E>	c #513B13",
"F>	c #684C1F",
"G>	c #583F17",
"H>	c #3E2D11",
"I>	c #21190E",
"J>	c #35322B",
"K>	c #362F26",
"L>	c #272016",
"M>	c #211A0E",
"N>	c #20180C",
"O>	c #30291D",
"P>	c #322B21",
"Q>	c #211807",
"R>	c #251804",
"S>	c #322108",
"T>	c #3A270A",
"U>	c #4F3712",
"V>	c #71521E",
"W>	c #916A28",
"X>	c #9B7027",
"Y>	c #7F5616",
"Z>	c #462D09",
"`>	c #161006",
" ,	c #120E05",
".,	c #191308",
"+,	c #1D170F",
"@,	c #2A241C",
"#,	c #433928",
"$,	c #4D3D24",
"%,	c #372A16",
"&,	c #16130B",
"*,	c #4C473E",
"=,	c #1B1409",
"-,	c #1C1509",
";,	c #332B1F",
">,	c #1E170B",
",,	c #161005",
"',	c #140E04",
"),	c #130D02",
"!,	c #170F02",
"~,	c #201401",
"{,	c #301E03",
"],	c #3E2706",
"^,	c #382407",
"/,	c #1A160E",
"(,	c #231E16",
"_,	c #292419",
":,	c #363025",
"<,	c #6B655D",
"[,	c #6C675E",
"},	c #312D27",
"|,	c #1F1D17",
"1,	c #5F5A53",
"2,	c #787168",
"3,	c #40392F",
"4,	c #1E160C",
"5,	c #130C01",
"6,	c #120B00",
"7,	c #160F03",
"8,	c #181105",
"9,	c #161004",
"0,	c #110C02",
"a,	c #0E0901",
"b,	c #0A0700",
"c,	c #221D15",
"d,	c #4C463C",
"e,	c #756F65",
"f,	c #726D65",
"g,	c #45413B",
"h,	c #14120E",
"i,	c #13120D",
"j,	c #2E2B26",
"k,	c #4A453E",
"l,	c #524C43",
"m,	c #443D34",
"n,	c #312A20",
"o,	c #231C11",
"p,	c #191208",
"q,	c #140D02",
"r,	c #0F0900",
"s,	c #171005",
"t,	c #211B11",
"u,	c #2D281E",
"v,	c #5C554D",
"w,	c #5F5A52",
"x,	c #49453E",
"y,	c #191713",
"z,	c #161410",
"A,	c #201D18",
"B,	c #2C2923",
"C,	c #39342E",
"D,	c #403B34",
"E,	c #433E36",
"F,	c #443E36",
"G,	c #433E35",
"H,	c #443F36",
"I,	c #413C34",
"J,	c #3C3831",
"K,	c #343029",
"L,	c #292520",
"M,	c #151310",
"N,	c #181612",
"O,	c #1E1C17",
"P,	c #201E19",
"Q,	c #221F1A",
"R,	c #211F1A",
"S,	c #211E19",
"T,	c #1A1814",
"U,	c #13110D",
"                                        . + @ # $ % & * = - ; > , ' )                     ",
"                                  ! ~ { ] ^ / ( _ : < [ } | 1 2 3 4 5 6 7                 ",
"                              8 9 0 a b c d e f g h i j k l m n o p q r s t u             ",
"                          v w x y z A B C D E F G H I J K L M N O P Q R S T U V           ",
"                      W 7 X Y Z `  ...+.@.#.$.%.g &.*.=.-.;.>.,.'.).!.~.{.].^./.u         ",
"                      t (._.:.<.[.}.|.1.2.3.*.4.5.n K 6.7.8.9.0.a.b.c.d.e.f.g.N h.i.      ",
"                  j.k.l.m.n.o.p.q.r.s.E t.3.u.E v.w.x.y.z.q L A.B.C.D.E.F.G.H.I.J.K.L.    ",
"                M.N.O.P.Q.R.S.T.U.V.W.2.| X.Y.Z.`. +7.,..+++@+#+$+%+&+*+=+Q -+;+>+,+'+    ",
"              )+!+~+{+]+^+/+(+_+:+<+[+`.}+|+l 1+2+3+4+5+6+7+8+9+0+a+b+c+d+e+0.;+f+3+g+h+  ",
"          i+j+* k+l+m+n+o+p+q+r+s+t+u+2 v+w+x+y+z+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+  ",
"          T+U+V+W+X+Y+Z+`+ @.@+@@@#@$@%@&@*@=@-@;@>@,@'@)@!@~@{@]@^@/@(@_@:@<@[@}@|@1@2@3@",
"        4@5@6@7@8@9@0@a@b@ @c@d@e@f@g@h@i@f+f+j@k@l@m@n@o@p@q@r@s@t@u@v@w@x@y@z@A@B@C@D@E@",
"      F@G@H@I@J@K@L@M@N@O@P@Q@R@S@T@U@V@W@_@P+X@Y@Z@`@ #.#+#@###$#%#&#*#w@=#-#;#>#,#'#)#!#",
"      ~#{#]#^#/#(#_#:#<#[#}#|#1#2#3#4#5#6#7#8#9#0#a#b#c#d#e#f#g#h#i#j#*#X@k#Y@l#m#n#o#p#q#",
"    r#s#t#u#v#w#x#y#z#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O#P#Q#R#S#G+T#U#V#W#X#X@Y#Z#`#,# $.$+$@$",
"    #$$$%$&$*$=$-$J+;$>$,$'$)$!$~${$]$^$/$y@($_$:$<$[$}$p+|$1$2$3$4$5$X#6$9#7$8$9$0$a$b$c$",
"  u d$e$f$g$=$h$i$j$k$l$m$n$/+o$K@p$q$r$s$t$u$v$w$x$y$z$A$.#B$C$D$E$F$G$7$`#H$I$J$K$L$M$N$",
"  O$P$Q$R$S$T$U$V$W$X$K Y$Z$`$!$ %.%+%r$@%#%$%%%&%*%=%-%;%>%,%'%)%!%~%{%]%^%/%(%_%:%<%[%}%",
"|%1%2%3%4%5%6%,.H.7%8%2 9%0%a%b%c%d%e%f%g%t$M#h%i%j%k%l%m%n%o%p%q%r%s%$%H$8$t%u%v%w%x%y%z%",
"h+A%B%C%D%E%F%G%'.H%I%J%K%L%M%N%O%P%Q%R%S%t$G$T%U%V%W%X%Y%Z%`% &.&+&&%@&#&$&%&&&*&=&-&;&>&",
",&'&)&!&~&{&]&H%^&H%/&(&_&:&<&[&}&|&1&2&3&7$l#4&5&6&7&8&9&0&a&b&c&d&e&f&_%g&h&i&j&k&l&m&  ",
"n&o&p&q&r&s&I.t&t&u&v&w&x&y&z&A&B&C&D&E&F&G&w$l#H&I&J&K&L&M&N&O&P&Q&R&S&K$g&T&U&V&W&X&Y&  ",
"Z&`& *.*+*@*g.#*$*%*&***=*-*;*>*,*'*)*!*S%~*{*:$]*^*/*(*_*:*<*[*}*|*1*2*J$3*4*5*6*7*8*9*  ",
"0*a*b*c*/&d*e*f*g*f*h*i*j*k*l*m*n*o*p*q*r*-#s*-#t*u*v*w*x*y*z*A*B*C*D*E*F*G*H*I*J*K*L*    ",
"M*N*O*e*P*Q*R*S*T*U*W#V*W*X*Y*Z*`* =.=+=@=s*#=N#D*$=%=&=*===-=;=>=,='=)=!=~={=]=^=/=(=    ",
"_=Q+f+:=f*<=[=y@G$x@}=|=1=2=3=4=5=6=7=8=9=0=#=N#a=b=c=d=e=f=g=h=i=j=a=k=l=m=R&n=o=p=      ",
"q==@r=j@s=t=u=u=%%v=w=x=y=z=A=B=C=D=E=F=G=:$H=I=J=K=/*L=M=N=O=P=Q=R=S=T=U=V=W=X=6$        ",
"Y=Z=`=m#v=x@ -#%u=T%.-+-@-#-$-%-&-*-=-!*S%--;-7$>-,-'-)-!-~-{-]-^-/-(-_-p#:-<-[-}-        ",
"|-K+1-2-3- -4-5-*#6-7-8-9-0-a-b-c-d-e-f-g-h-l#k@i-j-k-l-m-n-o-p-q-r-s-t-u-v-w-x-          ",
"y-z-5&A-E*5&B-w=C-D-E-F-G-H-I-J-K-L-M-N-O-P-Q-R-S-T-U-V-W-X-Y-Z-`- ;.;+;@;#;$;            ",
"%;&;*;=;-;;;>;,;B-';);!;~;{;];J-^;/;(;_;:;<;[;};|;];1;2;2;3;4;5;6;7;8;9;0;a;              ",
"b;!+c;'=d;e;f;S&g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z;A;B;C;D;E;F;G;H;I;                ",
"  J;K;L;D*t*D*`#M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z;`; >.>+>@>#>$>%>&>*>=>->;>>>                  ",
"  ,>'>)>!>~>{>]>)=^>/>(>_>:><>[>}>|>1>2>3>4>5>6>7>8>9>0>a>b>c>d>e>f>g>                    ",
"    h>i>j>k>l>/%,;D*m>]>n>o>p>q>r>s>t>u>v>w>x>y>z>A>B>C>D>E>F>G>H>I>                      ",
"      J>y%K>L>M>N>8$R&O>P>0$Q>R>S>T>U>V>W>X>Y>Z>`> ,.,+,@,#,$,%,&,                        ",
"        z%*,i@L>=,-,]>;,E*>,]=,,',),!,~,{,],^,/,(,_,:,[%<,[,},                            ",
"          |,1,2,3,4,5,6,6,U&7,8,9,',0,a,b,{={=H*c,d,e,f,g,h,                              ",
"            i,j,k,l,m,n,o,p,q,6,r,q,s,=,t,u,m,v,w,x,j,y,                                  ",
"                z,A,B,C,D,E,F,G,G,G,H,H,I,J,K,L,(=M,                                      ",
"                      N,O,P,Q,Q,Q,R,R,S,O,T,U,                                            "};
                                                                                                                                                           bin/                                                                                                0040777 0001750 0000144 00000000000 07542467526 011245  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  bin/Linux/                                                                                          0040755 0001750 0000144 00000000000 07542467526 012340  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  bin/Linux/x86/                                                                                      0040755 0001750 0000144 00000000000 07542467526 012765  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  bin/ut2003                                                                                          0100755 0001750 0000144 00000002404 07542467526 012121  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  #!/bin/sh
#
# Unreal Tournament 2003 startup script
#

# Function to find the real directory a program resides in.
# Feb. 17, 2000 - Sam Lantinga, Loki Entertainment Software
FindPath()
{
    fullpath="`echo $1 | grep /`"
    if [ "$fullpath" = "" ]; then
        oIFS="$IFS"
        IFS=:
        for path in $PATH
        do if [ -x "$path/$1" ]; then
               if [ "$path" = "" ]; then
                   path="."
               fi
               fullpath="$path/$1"
               break
           fi
        done
        IFS="$oIFS"
    fi
    if [ "$fullpath" = "" ]; then
        fullpath="$1"
    fi

    # Is the sed/ls magic portable?
    if [ -L "$fullpath" ]; then
        #fullpath="`ls -l "$fullpath" | awk '{print $11}'`"
        fullpath=`ls -l "$fullpath" |sed -e 's/.* -> //' |sed -e 's/\*//'`
    fi
    dirname $fullpath
}

# Set the home if not already set.
if [ "${UT2003_DATA_PATH}" = "" ]; then
    UT2003_DATA_PATH="`FindPath $0`/System"
fi

LD_LIBRARY_PATH=.:${UT2003_DATA_PATH}:${LD_LIBRARY_PATH}

export LD_LIBRARY_PATH

# Let's boogie!
if [ -x "${UT2003_DATA_PATH}/ut2003-bin" ]
then
	cd "${UT2003_DATA_PATH}/"
	exec "./ut2003-bin" $*
fi
echo "Couldn't run Unreal Tournament 2003 (ut2003-bin). Is UT2003_DATA_PATH set?"
exit 1

# end of ut2003 ...

                                                                                                                                                                                                                                                            cdkey.sh                                                                                            0100777 0001750 0000144 00000002303 07542317557 012124  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  #!/bin/sh

#trap "" SIGINT

clear

if [ -z $1 ]; then
  echo "no command line argument given"
  exit 1
fi


echo
echo
echo
echo "*************************************************"
echo "*************************************************"
echo "*************************************************"
echo "*************************************************"
echo "  YOUR CD KEY IS NOT CHECKED FOR VALIDITY HERE!"
echo "       MAKE SURE YOU TYPE IT IN CORRECTLY!"
echo "IF YOU CTRL-C OUT OF THIS, THE GAME WILL NOT RUN!"
echo "*************************************************"
echo "*************************************************"
echo "*************************************************"
echo "*************************************************"
echo
echo
echo


while true
do
  echo -n "Please enter your CD key: "
  read CDKEY1
  echo -n "Please reenter your CD key: "
  read CDKEY2

  if [ "$CDKEY1" == "" ]; then
    echo "You entered a blank CD key. Try again."
  else
    if [ "$CDKEY1" == "$CDKEY2" ]; then
      echo "$CDKEY1" | tr a-z A-Z > $1/System/cdkey
      echo "Thank you!"
      sleep 1
      exit 0
    else
      echo "Your CD key entries don't match. Try again."
    fi
  fi

  echo
  echo
done

exit 0

                                                                                                                                                                                                                                                                                                                             eula/                                                                                               0040777 0001750 0000144 00000000000 07542467527 011424  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  eula/License.int                                                                                    0100644 0001750 0000144 00000027235 07542467526 013523  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  END-USER LICENSE AGREEMENT
 
 PLEASE READ CAREFULLY.  BY USING OR INSTALLING THIS SOFTWARE, OR BY
PLACING OR COPYING THIS SOFTWARE ON YOUR COMPUTER HARDWARE, COMPUTER RAM
OR OTHER STORAGE MEDIUM, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF
THIS LICENSE.  IF YOU DO NOT AGREE TO THESE TERMS, PROMPTLY DISCONTINUE
THE INSTALLATION PROCESS AND CEASE ALL USE OF THIS SOFTWARE.
 THIS END-USER LICENSE AGREEMENT SUPERSEDES AND REPLACES ANY END-USER
LICENSE AGREEMENT THAT MAY BE INCLUDED IN THE MANUAL ACCOMPANYING THIS
SOFTWARE.  IN THE EVENT OF ANY CONFLICT BETWEEN THIS LICENSE AND ONE
CONTAINED IN THE MANUAL, THE PROVISIONS OF THIS LICENSE WILL CONTROL.
 
 1.	Thanks.  Congratulations and thank you for licensing our
software.  Were sorry to cramp your style, but out lawyers tell us that
if we want to keep control and ownership of the cool stuff were
developing, we have to make sure you understand and agree that you are
just buying a right to use it and that that right is limited in certain
ways.  So what follows is what you need to know and agree to.  
 
 2.	License.  The software accompanying this license and the related
documentation (the "Software") are licensed for your use and gaming
enjoyment, subject to terms and limitations in this license agreement. 
The license fee you paid gives you the right to use the Software.  If
the Software is configured for loading onto a hard drive, you may only
load the Software onto the hard drive of a single computer and only run
the Software off that hard drive, however you may participate in a
multiplayer configuration (such as in an Internet gaming room) with
other players who also have valid licenses; in other words, your friends
must license their own copies of the Software.	There is an editor
incorporated into the Software which, if you use it, is subject to
Section 10 below.  
 
 3.	Commercial Exploitation. You may not use this game, or any Mods
created for this game or using the tools provided with this game, for
any commercial purposes without the prior written consent of Epic Games
Inc. including, but not limited to, the following rules: 1. If you are
the proprietor of an Internet caf or gaming room, you may operate the
Software in a "pay for play" environment provided that all computers
used have validly licensed Software installed, such Software having been
purchased at a retail store or other similar provider (we do not offer
volume discounts or multi-install licenses).  2. You may not, without
prior written consent from Epic, operate the Software in any gaming
contest where (a) the cash value of all winnings and prizes paid
throughout the entire competition is equal to or greater than
US$5,000.00 OR (b) the name of the event, or any individual contest
therein, incorporates or approximates the name of a company, product or
commercial service OR (c) any company has provided, whether donated or
as sponsorship, prizes, or otherwise,  products or services worth with a
fair market value of over US$5,000.00. 
 
 4.	Use Restrictions.  We want you to enjoy our products for years
to come, and we want to be able to continue to make awesome games, so
you need to be aware that there are some things you cannot do with the
Software.  The Software contains copyrighted material, trade secrets and
other proprietary material.  You may not decompile, modify, reverse
engineer, publicly display, prepare derivative works based on the
Software (except as permitted in Section 10, below), disassemble or
otherwise reproduce the Software.  Except as set forth herein, you may
not rent, sell, lease, barter, sublicense or distribute the Software. 
You may not delete the copyright notices or any other proprietary
legends on the original copy of the Software.  You may not offer the
Software on a pay-per-play basis or otherwise commercially exploit the
Software or use the Software for any commercial purpose except as
described in this agreement.  You may not electronically transmit the
Software from one computer to another or over a network.  You may not
ship or export the Software to any country other than where you bought
it, in violation of the U.S. Export Administration Act (or any other law
governing such matters) and you will not utilize and will not authorize
anyone to utilize the Software in violation of any applicable law.  The
Software may not be downloaded or otherwise exported into (or to a
national or resident of) any country to which the U.S. has embargoed
goods or to anyone or into any country who/which are prohibited by
applicable law from receiving it.
 
 5.	No Cheating.  No one likes cheaters, because they reduce the
quality of play for everyone else.  If you employ any sort of cheat
program or aimbot on the services linked through our master server, we
reserve the right to lock you out of play through our master server on a
world-wide basis.  If you are a proprietor of an Internet caf or gaming
room, you are responsible for policing cheaters in your caf or gaming
room.  If you dont catch them before we do, we reserve the right to
lock out of play any license used by a cheater.
 
 6.	Termination.  This license is effective until one of us
terminates it.	You may terminate this license at any time by destroying
the Software and related documentation.  In the unlikely event that you
are naughty and fail to comply with any provision of this license, this
license will terminate immediately without notice from us.  Upon
termination, you must destroy the Software and related documentation. 
Please dont wait for us to come after you; it would not be pleasant for
either of us.  If we do have to come after you, were going to expect
you to pay us for our troubles, including the cost of our lawyers.
 
 7.	Disclaimer of Warranty on Software.  You are aware and agree
that use of the Software and the media on which it is recorded is at
your sole risk.  The Software, related documentation and the media are
provided "AS IS".  Unless otherwise provided by applicable law,
Infogrames ("Infogrames") warrants to the original purchaser of this
product that the Software storage medium will be free from defects in
material and workmanship under normal use for ninety (90) days from the
date of purchase.  By the way, Infogrames provides this end-user
warranty as the publisher of the Software.  This warranty is void if the
defect has arisen through accident, abuse, neglect or misapplication. 
INFOGRAMES AND EPIC GAMES, INC. ("EPIC") EXPRESSLY DISCLAIM ALL OTHER
WARRANTIES. EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  WE DO NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THE SOFTWARE
WILL MEET YOUR REQUIREMENTS.  NO ORAL OR WRITTEN INFORMATION OR ADVICE
GIVEN BY US OR ANY OF OUR AUTHORIZED REPRESENTATIVES SHALL CREATE A
WARRANTY OR IN ANY WAY INCREASE THE SCOPE OF THIS WARRANTY.  SOME
JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO THE
ABOVE EXCLUSIONS MAY NOT APPLY TO YOU.
 
 8.	Limitation of Liability.  UNDER NO CIRCUMSTANCES, INCLUDING
WITHOUT LIMITATION, NEGLIGENCE, SHALL INFOGRAMES, EPIC OR ANY OF THEIR
RESPECTIVE OFFICERS, EMPLOYEES, DIRECTORS, AGENTS, LICENSEES,
SUBLICENSEES OR ASSIGNS BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
CONSEQUENTIAL DAMAGES THAT RESULT FROM THE USE OR INABILITY TO USE THE
SOFTWARE OR RELATED DOCUMENTATION, EVEN IF SUCH PARTIES HAVE BEEN
ADVISED OF THE POSSIBILITY OF THOSE DAMAGES.  SOME JURISDICTIONS DO NOT
ALLOW THE LIMITATION OR EXCLUSION OF LIABILITY FOR INCIDENTAL OR
CONSEQUENTIAL DAMAGES SO THE ABOVE LIMITATION OR EXCLUSION MAY NOT APPLY
TO YOU.  In no event shall Epic and Infogrames total liability to you
for all damages, losses, and causes of action (whether in contract, tort
or otherwise) exceed the amount paid by you for the Software.
 
 9.	Controlling Law and Severability.  This license is governed by
and construed in accordance with the laws of the State of North
Carolina, USA.	Exclusive venue for all litigation shall be in Wake
County, North Carolina.  If any provision of this license is
unenforceable, the rest of it shall remain in effect.
 
 10.	Complete Agreement.  This license constitutes the entire
agreement between the parties with respect to the use of the Software
and the related documentation.	However, Infogrames and Epic reserve the
right to modify the terms of this license from time to time and will
post notice of material changes somewhere within www.epicgames.com.  
 
 11.	Editor and End-user Mods.
 (a)	The Software includes an editor and associated tools and
utilities (the "UnrealEd").  UnrealEd is a really cool feature which
allows you to modify the Software or to construct new variations for use
with it.  These modifications and variations can be both playable and
non-playable.  UnrealEd is NOT shareware.  You may not freely distribute
it to any BBS, CD, floppy or any other media.  You may not sell it or
repackage it for sale.	
 (b)	Using UnrealEd, you may create modifications or enhancements to
the Software, including the construction of new levels (collectively
referred to as "Mods"), subject to the following restrictions:
 i.	Your Mods must only work with the full, registered copy of the
Software, not independently or with any other software.
 ii.	Your Mods must not contain modifications to any executable
file(s).
 iii.	Your Mods must not contain any libelous, defamatory, or other
illegal material, material that is scandalous or invades the rights of
privacy or publicity of any third party, nor may your Mods contain, or
be used in conjunction with, any trademarks, copyright-protected work,
or other recognizable property of third parties, nor may your Mods be
used by you, or anyone else, for any commercial exploitation including,
but not limited to, advertising or marketing for a company, product or
service.
 iv.	Your Mods shall not be supported by Infogrames, Epic or any of
such parties affiliates and subsidiaries, and if distributed pursuant
to this license your Mods must include a statement to such effect.
 v.	Your Mods must be distributed solely for free, period.	Neither
you, nor any other person or party, may sell them to anyone,
commercially exploit them in any way, or charge anyone for receiving or
using them without prior written consent from Epic Games Inc.  You may
exchange them at no charge among other end-users and distribute them to
others over the Internet, on magazine cover disks, or otherwise for
free.
 vi.	The prohibitions and restrictions in this section apply to
anyone in possession of the Software or any of your Mods.
 
 12.	Copyright.  The Software and all copyrights, trademarks and all
other conceivable intellectual property rights related to the Software
are owned by Infogrames, Epic or such parties licensors and are
protected by United States copyrights laws, international treaty
provisions, an army of clones, and all applicable law, such as the
Lanham Act.  You must treat the Software like any other copyrighted
material, as required by 17 U.S.C. section 101 et seq. and other
applicable law.  Please do not make unauthorized copies.  The program
youve licensed was produced through the efforts of many people who earn
their livelihood from its lawful use.  These people like to eat, so
dont make copies for others who have not paid for the right to use it. 
To report copyright violations to the Software Publishers Association,
call 1-800-388-PIR8 or write:  Software Publishers Association, 1101
Connecticut Ave., Suite 901, Washington, D.C. 20036.
 
 13.	Enjoyment Requirements.  We are aware that there are rumblings
and grumblings within the gaming community about heavy handed, legally
onerous license agreements.  You have our word that this one is as fair
and even handed as it gets and, as you have read this far, you know it
to be true.  Now, be gone from this screen and enjoy the Software,
including the UnrealEd.
                                                                                                                                                                                                                                                                                                                                                                   eula/License.det                                                                                    0100644 0001750 0000144 00000031321 07542467526 013474  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  ENDBENUTZER-LIZENZVEREINBARUNG
 
 DIE FOLGENDE VEREINBARUNG MUSS SORGFLTIG DURCHGELESEN WERDEN.  DIE
INSTALLATION DIESER SOFTWARE AUF EINE FESTPLATTE, DAS LADEN IN DEN
RAM-SPEICHER ODER DAS KOPIEREN AUF EIN ANDERES SPEICHERGERT WIRD ALS
ZUSTIMMUNGSERKLRUNG FR ALLE IN DIESER LIZENZVEREINBARUNG FESTGELEGTEN
BEDINGUNGEN VERSTANDEN.  WENN DER BENUTZER MIT DIESEN BEDINGUNGEN NICHT
EINVERSTANDEN IST, DARF DIE SOFTWARE NICHT INSTALLIERT WERDEN BZW. DIE
VERWENDUNG DER SOFTWARE MUSS SOFORT EINGESTELLT WERDEN.
 
 1.	Zuerst ein Dankeschn.	Wir gratulieren und bedanken uns fr den
Erwerb unserer Softwarelizenz.	Es tut uns leid, dass wir dich mit
diesen Rechtssachen belstigen mssen. Aber unsere Rechtsanwlte sagen
uns, dass wir die Kontrolle und das Eigentumsrecht fr alle coolen
Produkte, die wir entwickeln, nur behalten knnen, wenn wir
sicherstellen, dass die Benutzer unserer Produkte genau verstehen und
zustimmen, dass Sie nur das Recht zur Verwendung erwerben und dass
dieses Recht bestimmten Einschrnkungen unterliegt.  Also los
gehts...Folgendes musst du wissen und damit einverstanden sein.  
 
 2.	Lizenz.  Die dieser Lizenz beiliegende Software sowie die
dazugehrige Dokumentation (die "Software") wird dem Benutzer unter
Lizenz fr die Verwendung und sein absolutes Spielvergngen unter den in
dieser Lizenzvereinbarung festgelegten Bedingungen und Einschrnkungen
zur Verfgung gestellt.  Durch die Bezahlung der Lizenzgebhr wird das
Recht zur Verwendung der Software erworben.  Wenn die Software fr das
Laden auf eine Festplatte konfiguriert ist, darf sie nur auf die
Festplatte eines einzelnen Computers geladen und von dieser Festplatte
ausgefhrt werden. Bei einer Multispielerkonfiguration (z.B. in einem
Internet Gaming Room) ist das Spielen mit anderen Spielern, die eine
gltige Lizenz haben, erlaubt; d.h. deine Freunde mssen ihre eigenen
Lizenzen fr ihre Softwarekopien haben.  In die Software ist ein
Editor-Programm integriert, das gem der Bestimmungen in Abschnitt 8
unten verwendet werden darf.  
 
 3.	Gewerbliche Nutzung. Dieses Spiel und alle dafr erzeugten Mods
sowie die im Spiel enthaltenen Tools drfen ohne die vorherige
schriftliche Genehmigung von Epic Games, Inc. nicht fr gewerbliche
Zwecke, d.h. gegen Entgelt, genutzt werden. Die Verwendung unterliegt
folgenden Bestimmungen: 1. Ein Eigentmer eines Internet Cafs oder
Gaming Rooms darf die Software nur dann in einer "Pay-per-Play"-Umgebung
verwenden, wenn fr die Software auf allen verwendeten Computern eine
gltige Lizenz erworben wurde und die Software von einem Einzelhandels-
oder hnlichem Geschft gekauft wurde (wir bieten keinen Mengenrabatt
oder Mehrplatzlizenzen an).  2. Ohne vorherige schriftliche Genehmigung
von Epic darf die Software nicht in einem Spielewettbewerb verwendet
werden, wenn (a) die im gesamten Wettbewerb ausbezahlten Preise einen
Betrag von 5000 USD oder mehr ergeben ODER (b) der Name der
Veranstaltung bzw. ein Einzelwettbewerb im Rahmen der
Gesamtveranstaltung den Namen einer Firma, eines Produkts oder eines
gewerblichen Dienstes beinhaltet oder andeutet ODER (c) eine Firma
Preise, Produkte oder Dienste im Marktpreiswert von ber 5000 USD
bereitstellt, spendet oder als Sponsor zur Verfgung stellt. 
 
 4.	Einschrnkungen.  Wir mchten, dass du viele Jahre lang Freude
an unseren Produkten haben wirst, und dass wir weiterhin begeisternde
Spiele fr dich entwickeln knnen. Deshalb ist es wichtig, dass du ber
bestimmte Einschrnkungen bei der Verwendung dieser Software Bescheid
weit.	Die Software enthlt urheberrechtlich geschtztes Material,
Handelsgeheimnisse und anderes eigentumsrechtlich geschtztes Material. 
Die Software darf nicht dekompiliert, modifiziert, rckentwickelt,
ffentlich ausgestellt, zerlegt oder fr die Anfertigung von
abgeleiteten Produkten verwendet werden (auer in dem in Abschnitt 8
unten beschriebenen Rahmen).  Auer unter den hier festgelegten
Bedingungen darf die Software nicht vermietet, verkauft oder unter einem
Leasing-, Barter- oder Unterlizenzabkommen weitergeben oder verteilt
werden.  Die Copyright-Hinweise oder andere eigentumsrechtliche Hinweise
auf der Originalsoftware drfen nicht entfernt werden.	Die Software
darf nicht gegen Bezahlung pro Spiel angeboten bzw. anderweitig fr
kommerzielle Zwecke genutzt oder verwendet werden, auer in dem in
dieser Vereinbarung beschriebenen Rahmen.  Die Software darf nicht von
einem Computer auf einen anderen bzw. ber ein Netzwerk elektronisch
bertragen werden.  Die Software darf nicht in ein anderes Land
verschickt oder exportiert werden, da dies eine Verletzung des
US-Exportgesetzes (und der Exportgesetze anderer Lnder) darstellt. Auch
eine gesetzeswidrige Verwendung der Software bzw. die Zulassung einer
gesetzeswidrigen Verwendung ist ebenfalls verboten.  Die Software darf
nicht per Download oder anderweitigen Methoden in ein Land exportiert
(oder einem Bewohner des Landes bergeben werden), das einem US-Embargo
unterliegt, oder Personen bergeben werden, die nach den anwendbaren
Gesetzen nicht zur Entgegennahme des Produktes berechtigt sind.
 
 5.	Laufzeit.  Diese Lizenz bleibt in Kraft, bis sie vom Benutzer
oder von uns gekndigt wird.  Benutzer knnen diese Lizenzvereinbarung
jederzeit kndigen, indem sie die Software und die dazugehrige
Dokumentation vernichten.  In dem unwahrscheinlichen Fall, dass du die
Bedingungen dieser Lizenzvereinbarung nicht befolgst, ist diese Lizenz
ohne Mitteilung unsererseits sofort ungltig.  Im Kndigungsfall oder
wenn die Lizenz ungltig wird, muss die Software einschlielich der
dazugehrigen Dokumentation vernichtet werden.	Warte bitte nicht, bis
wir dieser Sache nachgehen mssen, denn das wre fr uns beide sehr
unangenehm.  Sollte dies jedoch der Fall sein, erwarten wir natrlich
eine Entschdigung fr unseren Aufwand und unsere Rechtskosten von dir.
 
 6.	Haftungsausschluss zur Software.  Benutzer wissen und stimmen
zu, dass sie diese Software und die Datentrger auf eigenes Risiko
verwenden.  Die Software, die dazugehrige Dokumentation und der
Datentrger werden so wie sie sind zur Verfgung gestellt.  Wenn nicht
anderweitig durch anwendbares Recht vorgeschrieben, gewhrt Infogrames
("Infogrames") dem Erstkufer dieses Produkts eine neunzigtgige (90)
Garantie ab Kaufdatum. Diese Garantie deckt Material- und
Verarbeitungsfehler des Datentrgers der Software.  brigens, Infogrames
bietet diese Garantie fr den Endbenutzer als Herausgeber der Software. 
Diese Garantie deckt keine Defekte, die durch Unfall, Missbrauch,
Vernachlssigung oder falsche Anwendung entstanden sind.  INFOGRAMES
(UNSER HERAUSGEBER) UND EPIC GAMES, INC. ("EPIC") GEBEN KEINE WEITERE
GEWHR. ALLE AUSDRCKLICHEN ODER STILLSCHWEIGENDEN ZUSAGEN, U.A. ZUSAGEN
IN BEZUG AUF DIE MARKTGNGIGKEIT ODER EIGNUNG FR EINEN BESTIMMTEN ZWECK
SIND AUSGESCHLOSSEN.  WIR GEBEN KEINE GEWHR, DASS DIE IN DER SOFTWARE
ENTHALTENEN FUNKTIONEN DIE GEWNSCHTEN ANFORDERUNGEN ERFLLEN. 
MNDLICHE ODER SCHRIFTLICHE INFORMATIONEN ODER RATSCHLGE VON UNS ODER
VON UNSEREN AUTORISIERTEN VERTRETERN GELTEN NICHT ALS GEWHR ODER
ERWEITERUNG DIESER GEWHRLEISTUNG.  IN BESTIMMTEN LNDERN IST DER
AUSSCHLUSS VON STILLSCHWEIGENDEN ZUSAGEN RECHTSWIDRIG. IN SOLCHEN FLLEN
HABEN DIE OBIGEN AUSSCHLSSE KEINE GLTIGKEIT.
 
 7.	Haftungsbeschrnkung.  INFOGRAMES, EPIC BZW. DEREN
FHRUNGSKRFTE, MITARBEITER, DIREKTOREN, VERTRETER, LIZENZNEHMER,
SUBLIZENZNEHMER ODER RECHTSNACHFOLGER HAFTEN IN KEINEM FALL, AUCH NICHT
BEI FAHRLSSIGEM VERSCHULDEN, FR NEBEN-, SONDER- ODER FOLGESCHDEN, DIE
AUS DER VERWENDUNG DER SOFTWARE ODER DOKUMENTATION ENTSTEHEN, AUCH WENN
DIE PARTEIEN BER DIE MGLICHKEIT SOLCHER SCHDEN INFORMIERT SIND.  IN
BESTIMMTEN LNDERN IST DIE BESCHRNKUNG ODER DER AUSSCHLUSS DER HAFTUNG
FR NEBEN- ODER FOLGESCHDEN GESETZESWIDRIG. IN SOLCHEN FLLEN HABEN
OBIGE BESCHRNKUNGEN ODER AUSSCHLSSE KEINE GLTIGKEIT.  Unsere Haftung
fr Schden, Verluste und Klagegrnde (ob vertraglich oder deliktisch)
ist in jedem Fall auf den fr die Software bezahlten Betrag beschrnkt.
 
 8.	Gerichtsstand und Teilgltigkeit.  Diese Lizenz unterliegt dem
Recht des US-Bundesstaates North Carolina.  Ausschlielicher
Gerichtsstand fr alle Streitsachen ist Wake County, North Carolina. 
Soweit Teile dieser Vereinbarung unwirksam oder undurchsetzbar sind oder
werden, wird die Wirksamkeit oder Durchsetzbarkeit der brigen
Bestimmungen dieser Lizenzvereinbarung hiervon nicht berhrt.
 
 9.	Gesamtheit der Vereinbarung.  Diese Lizenz stellt die gesamte
Vereinbarung zwischen den Parteien in Bezug auf die Verwendung der
Software und der dazugehrigen Dokumentation dar.  Infogrames und Epic
behalten sich jedoch das Recht vor, die Bedingungen dieser Lizenz von
Zeit zu Zeit zu ndern. Wesentliche nderungen werden auf der Website
www.epicgames.com bekannt gegeben.  
 
 10.	Editor und Endbenutzer-Mods.
 (a)	Die Software beinhaltet ein Editor-Programm und die
dazugehrigen Tools und Dienstprogramme ("UnrealEd").  UnrealEd ist ein
wirklich cooles Programm, mit dem du die Software modifizieren oder neue
Variationen zur Verwendung mit der Software erstellen kannst.  Diese
Mods (Modifikationen) und Variationen knnen spielbar und nicht spielbar
ausgefhrt werden.  UnrealEd ist KEINE Shareware.  Dieses Programm darf
nicht auf Bulletinboards, CDs, Disketten oder sonstigen Datentrgern
verteilt werden.  Es darf auch nicht verkauft oder fr den Verkauf neu
verpackt werden.  
 (b)	Mit UnrealEd drfen Modifikationen oder Verbesserungen zur
Software erstellt und neue Ebenen konstruiert werden (kollektiv als
"Mods" bezeichnet), vorausgesetzt die folgenden Einschrnkungen werden
befolgt:
 i.	Die erzeugten Mods drfen nur mit der kompletten, registrierten
Originalsoftware funktionsfhig sein; sie drfen nicht unabhngig oder
mit anderer Software funktionieren.
 ii.	Die Mods drfen keine nderungen an ausfhrbaren Dateien
enthalten.
 iii.	Die Mods drfen kein verleumderisches, diffamierendes oder
illegales bzw. skandalses oder private oder ffentliche Rechte Dritter
verletzendes Material enthalten; sie drfen keine Marken,
urheberrechtlich geschtztes Material oder anderes Eigentum Dritter
enthalten oder in Verbindung damit verwendet werden; die Mods drfen
weder vom Benutzer noch von anderen Personen fr gewerbliche Zwecke
verwendet werden, u.a. auch nicht fr: (a) Werbungs- oder
Marketingzwecke fr eine Firma, ein Produkt oder eine Dienstleistung.
 iv.	Ihre Mods werden von Infogrames, Epic oder deren Tochter- und
Verbundgesellschaften nicht untersttzt, und falls die Mods den
Bedingungen dieser Lizenzvereinbarung entsprechend verteilt werden,
mssen sie einen entsprechenden Hinweis enthalten.
 v.	Jegliche Mods drfen nur vllig kostenlos verteilt werden. 
Weder der Benutzer noch irgendeine andere Person oder Partei darf die
Mods verkaufen, gewerblich nutzen oder diese gegen Entgelt einer anderen
Person berlassen bzw. von dieser verwenden lassen, ohne vorher die
schriftliche Genehmigung von Epic Games Inc. zu erhalten.  Die Mods
drfen nur kostenlos unter Endbenutzern ausgetauscht, ber das Internet,
als Zeitschriftbeilagen oder anderweitig kostenlos verteilt werden.
 vi.	Die in diesem Abschnitt festgelegten Verbote und Einschrnkungen
gelten fr jede Person, die im Besitz der Software oder einer der Mods
ist.
 
 11.	Urheberrechte.	Die Software und alle Urheberrechte, Marken
sowie andere geistigen Eigentumsrechte zur Software sind Eigentum von
Infogrames, Epic bzw. deren Lizenzgebern und sind durch
US-Urheberrechte, internationale Abkommen, eine Armee von Klonen und
alle anwendbaren Gesetze, z.B. durch den Lanham Act, geschtzt.  Die
Software muss wie jedes andere urheberrechtlich geschtzte Material
gem 17 U.S.C., Abschnitt 101 et seq. sowie anderen anwendbaren
Gesetzen behandelt werden.  Bitte keine unberechtigten Kopien der
Software herstellen.  Dieses Programm wurde durch die harte Arbeit
vieler Menschen produziert - Menschen, die ihren Lebensunterhalt aus dem
Erls der rechtsmigen Verwendung der Software erwerben.  Diese Leute
knnen kein Geld verdienen, wenn du Kopien fr andere Personen, die
nicht fr das Nutzungsrecht bezahlt haben, herstellst.	Wenn du
Verletzungen des Urheberrechts beobachtest, solltest du diese
telefonisch der Software Publishers Association unter der Nummer
1?800?388?PIR8 melden. Wenn du lieber schreibst, melde solche
Verletzungen bitte an folgende Adresse:  Software Publishers
Association, 1101 Connecticut Ave., Suite 901, Washington, D.C. 20036.
 
 12.	Vergngungspflicht.  Wir wissen, dass niemand unter den
Spielefans die schwerflligen und lstigen Lizenzvereinbarungen mag. 
Wir versprechen, dass diese Vereinbarung so fair und unkompliziert ist,
wie es nur geht. Da du diese Vereinbarung nun gelesen hast, weit du,
dass es stimmt.  Also verlasse diese Seite so schnell wie mglich, damit
du endlich deinen Spa mit der Software und UnrealEd haben kannst.
 
 Hinweis: Die Lizenzvereinbarung betrifft nur die amerikanischen
Verbraucher.                                                                                                                                                                                                                                                                                                               eula/License.est                                                                                    0100644 0001750 0000144 00000031556 07542467527 013526  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  CONTRATO DE LICENCIA PARA USUARIOS FINALES
 
 LEA DETENIDAMENTE ESTE CONTRATO. AL USAR O INSTALAR ESTE SOFTWARE, O
BIEN INSTALARLO O COPIARLO EN EL HARDWARE, RAM U OTRO TIPO DE
ALMACENAMIENTO INTERMEDIO DE SU PC, USTED ACEPTA Y SE SOMETE A LAS
CLUSULAS DE LA PRESENTE LICENCIA.  SI NO ACEPTA ESTAS CLUSULAS DETENGA
DE INMEDIATO EL PROCESO DE INSTALACIN Y  SUSPENDA CUALQUIER USO DE ESTE
SOFTWARE.
 
 1.	Gracias - Lo felicitamos y le agradecemos por adquirir la
licencia de nuestro software. Le pedimos disculpas por acotar su
ingenio, pero nuestros abogados nos dicen que si pretendemos mantener el
control y la propiedad de este fabuloso producto -que estamos
desarrollando- debemos asegurarnos de que usted entienda y acepte que
slo se le otorga un derecho de uso y que ste est limitado en algunos
aspectos.  Por lo tanto a continuacin detallamos lo que es necesario
que sepa y acepte.
 
 2.	Contrato de licencia -	Se le otorga licencia sobre el software
que acompaa este contrato y sobre la documentacin relacionada
(Software), para que pueda utilizar y disfrutar el juego respetando las
condiciones y limitaciones del presente contrato. El pago del valor de
la licencia le otorga el derecho de uso del Software. Si el software
est configurado para cargarlo en una unidad de disco duro, usted puede
cargarlo solamente en una computadora y ejecutarlo solamente desde esa
unidad. Sin embargo puede participar en una configuracin de jugadores
mltiples (como por ejemplo en un saln de juegos de Internet) con otros
jugadores que tambin posean licencias vlidas, es decir, sus amigos
debern obtener sus propias licencias de las copias del Software. Existe
un editor incorporado en el Software. Si lo utiliza deber hacerlo de
acuerdo con el punto 8.  
 
 3.	Explotacin comercial - No podr usar este juego ni ninguno de
los "Mods" creados para l o que utilicen las herramientas provistas con
este juego, con ningn propsito comercial sin previo consentimiento
escrito de Epic Games Inc., incluyendo pero sin limitarse a las
siguientes reglas: 1. Si usted es propietario de un Caf Internet o de
un local de juegos podr operar el Software en un entorno de
"pago-por-juego" con la condicin de que todas las computadoras
utilizadas posean un Software instalado con licencia vlida. Dicho
Software debe ser adquirido en un comercio minorista o proveedor similar
(nosotros no ofrecemos descuentos por volumen o licencias de instalacin
mltiple).  2. No podr, sin consentimiento previo por escrito de Epic,
operar el Software en ningn concurso en el cual (a) el valor en
efectivo de la totalidad de los premios pagados durante toda la
competencia sea igual o mayor a 5.000 dlares estadounidenses, O BIEN
(b) el nombre del evento o de cualquier concurso individual que sea
parte de aqul incluya o se asemeje al de una compaa, producto o
servicio comercial, O BIEN (c) cualquier compaa haya provisto ya sea
por donacin o como patrocinador, premios, productos o servicios
valuados a un precio justo de mercado superior a los 5.000 dlares
estadounidenses. 
 
 4.	Restricciones -  Deseamos que disfrute de nuestros productos
durante mucho tiempo y queremos poder seguir envindole juegos
fantsticos, por lo tanto debe tener en cuenta que hay ciertas cosas que
no puede hacer con el Software.  ste contiene material con derechos de
autor, secretos de comercializacin y material de uso exclusivo. El
Software no puede ser descompilado ni modificado, no se le puede aplicar
ingeniera inversa, ni realizar con l demostraciones pblicas, ni
tampoco trabajos secundarios que lo tengan como base (excepto lo que se
autoriza ms adelante en el punto 8), tampoco se lo puede desensamblar
ni reproducir de ninguna otra forma. Excepto lo establecido en el
presente, el Software no podr ser alquilado, vendido, dado en arriendo
o trueque ni distribuido, ni se otorgarn licencias sobre l. No deben
eliminarse las notas de derechos de autor ni cualesquiera otras leyendas
relativas al uso exclusivo incluidas en la copia original del Software. 
Tampoco se podr ofrecer el Software sobre la base de pago-por-uso ni
explotarlo comercialmente ni utilizarlo con cualquier tipo de propsito
comercial excepto como se describe en este contrato. No se debe
transmitir el Software electrnicamente de una computadora a otra ni a
travs de una red. El Software no se puede enviar o exportar a ningn
pas que no sea aqul donde fue comprado sin incurrir en violacin a la
Ley de exportacin de los EE.UU. (o cualquier otra ley que rija dichos
temas) y usted no podr utilizar ni autorizar a nadie a utilizar el
Software violando ninguna de las leyes aplicables. No est permitido
descargar ni exportar el Software a ningn pas al cual los EE.UU. hayan
impuesto un embargo de productos (ni a ningn ciudadano nativo o
residente de dicho pas) ni a ninguna persona o pas a quienes la ley
aplicable les impida recibirlo.
 
 5.	Terminacin -  La presente licencia permanecer en vigencia
hasta que uno de nosotros la d por terminada.	Usted la podr dar por
terminada en cualquier momento, para ello destruya el Software y la
documentacin relacionada.  En el caso poco probable de que usted tenga
la picarda de no cumplir con cualquiera de las disposiciones de esta
licencia, ella se extinguir inmediatamente sin necesidad de previo
aviso de nuestra parte.  Una vez terminada la licencia, deber destruir
el Software como as tambin la documentacin relacionada.  No iremos
tras usted ya que no sera agradable para ninguno de nosotros. Pero si
nos vemos obligados a hacerlo, tenga en cuenta que esperamos que nos
pague por las molestias que debamos tomarnos, incluidos los honorarios
de nuestros abogados.
 
 6.	Declinacin de garanta sobre el software -  Usted est
plenamente consciente y acepta que el uso del Software y de los medios
en los que lo grabe son de su exclusiva responsabilidad.  El Software,
la documentacin relacionada y los medios se proveen "TAL COMO ESTN". 
A menos que en las leyes aplicables se estipule lo contrario, Infogrames
("Infogrames") le garantiza al comprador original de este producto que
el medio de almacenamiento del Software no tendr defectos de material
ni de mano de obra durante (90) noventa das desde la fecha de
adquisicin, siempre que se lo utilice en condiciones normales.
Infogrames brinda esta garanta para el usuario final en calidad de
editor del Software. Esta garanta no ser vlida si el defecto surge
por accidente, abuso, negligencia o mal uso. INFOGRAMES Y EPIC GAMES,
INC. ("EPIC") NIEGAN EN FORMA EXPRESA TODO OTRO TIPO DE GARANTAS
EXPRESAS O IMPLCITAS, INCLUYENDO PERO SIN LIMITARSE A LAS GARANTAS DE
COMERCIABILIDAD E IDONEIDAD PARA UN PROPSITO DADO.   NO GARANTIZAMOS
QUE LAS FUNCIONES CONTENIDAS EN EL SOFTWARE SATISFAGAN SUS
REQUERIMIENTOS.   NINGUNA INFORMACIN O AVISO ORAL O ESCRITO ENTREGADO
POR NOSOTROS O CUALQUIERA DE NUESTROS REPRESENTANTES AUTORIZADOS
CONSTITUIR  GARANTA ALGUNA, NI BAJO NINGUNA CIRCUNSTANCIA AMPLIAR EL
ALCANCE DE LA PRESENTE.  EN CIERTAS JURISDICCIONES NO SE PERMITE LA
EXCLUSIN DE GARANTAS IMPLCITAS POR LO TANTO LAS EXCLUSIONES
PRECEDENTES PUEDEN NO SER APLICABLES EN SU CASO.
 
 7.	Limitacin de responsabilidades -  BAJO NINGUNA CIRCUNSTANCIA,
INCLUYENDO PERO SIN LIMITARSE A, NEGLIGENCIA, INFOGRAMES, EPIC O
CUALQUIERA DE SUS FUNCIONARIOS, EMPLEADOS, DIRECTORES, REPRESENTANTES
TITULARES DE LA LICENCIA, SUBTITULARES DE LA LICENCIA O CESIONARIOS,
SERN RESPONSABLES DE NINGN TIPO DE DAOS Y PERJUICIOS INDIRECTOS,
ESPECIALES O EMERGENTES, RESULTANTES DEL USO O DE LA INCAPACIDAD DE
UTILIZAR EL SOFTWARE O LA DOCUMENTACIN RELACIONADA, AN EN EL CASO DE
QUE ESAS PARTES HAYAN SIDO NOTIFICADAS SOBRE LA POSIBILIDAD DE DICHOS
DAOS.	EN ALGUNAS JURISDICCIONES NO SE PERMITE LA LIMITACIN O
EXCLUSIN DE RESPONSABILIDADES POR DAOS Y PERJUICIOS INDIRECTOS O
EMERGENTES. POR LO TANTO LA LIMITACIN O EXCLUSIN PRECEDENTE PUEDE NO
SER APLICABLE EN SU CASO.  En ningn caso nuestra responsabilidad total
frente a usted por todos los daos y perjuicios, prdidas y derechos de
accin (ya sea contractual, por daos o de otro tipo) exceder el monto
que se pag por el Software.
 
 8.	Ley aplicable y divisibilidad -  La presente licencia se regir
e interpretar de acuerdo con las leyes del estado de Carolina del
Norte, EE.UU.	La jurisdiccin exclusiva para todas las acciones
judiciales ser la del condado de Wake, Carolina del Norte.  En el caso
de que alguna de las disposiciones de esta licencia fuese declarada
ilegal por algn tribunal competente, el resto de las disposiciones no
se vern afectadas y permanecern vigentes. 
 
 9.	Totalidad de lo convenido entre las partes -  Esta licencia
constituye el acuerdo total entre las partes en lo que se refiere al uso
del Software y la documentacin relacionada.  Sin  embargo, Infogrames y
Epic se reservan el derecho de modificar las clusulas de esta licencia
oportunamente y notificarn dichos cambios en algn sector del sitio Web
www.epicgames.com.  
 
 10.	Editor y Mods para el usuario final
 (a)	El Software incluye un editor, herramientas asociadas y
utilidades ("UnrealEd"). UnrealEd es una funcin realmente increble que
permite modificar el Software o construir nuevas variaciones que se
pueden usar con l.  Tanto las modificaciones como las variaciones
pueden ser para jugar o no.  UnrealEd NO es shareware (un programa
compartido).  Usted no lo puede distribuir libremente a ningn BBS
(tablero de anuncios electrnico), CD, disquete o cualquier otro tipo de
medios.  Tampoco lo puede vender o volver a empacar con el objeto de
venderlo.  
 (b)	Mediante el uso de UnrealEd, usted puede crear modificaciones o
mejorar el Software, lo que incluye la construccin de nuevos niveles
("Mods") de acuerdo con las siguientes restricciones:
 i.	Los Mods que usted cree slo debern funcionar con la copia
completa y registrada del Software, no lo debern hacer
independientemente o con otro software.
 ii.	Los Mods tampoco debern contener modificaciones que afecten a
ninguno de los archivos ejecutables.
 iii.	Los Mods no debern contener material difamatorio, ni
calumnioso, ni otro material ilegal que pueda considerarse escandaloso o
que invada los derechos de privacidad o publicidad de un tercero.
Tampoco pueden contener o ser usados en combinacin con ninguna marca
registrada, trabajo protegido por derechos de autor u otra propiedad de
terceros fcilmente reconocible. Tampoco le est permitido a usted ni a
ninguna otra persona usar los Mods con fines comerciales incluyendo pero
sin limitarse a:  (a) publicidad o comercializacin de una compaa,
producto o servicio.
 iv.	Los Mods no tendrn el respaldo de Infogrames, Epic ni sus
empresas  afiliadas y subsidiarias, y en el caso de que se distribuyan
de acuerdo con esta licencia, los Mods debern incluir una declaracin
sobre dicha condicin.
 v.	Los Mods se deben distribuir pura y exclusivamente en forma
gratuita.  Ni usted ni otra persona o parte puede venderlos a nadie, ni
explotarlos comercialmente de ninguna manera o exigirle pago a alguien
por recibirlos o usarlos, sin consentimiento previo y por escrito de
Epic Games Inc. Puede intercambiarlos sin cargo con otros usuarios
finales y distribuirlos a otros usuarios a travs de la Internet, o en
los CD que se obsequian con revistas u otros medios. 
 vi.	Las prohibiciones y restricciones contenidas en esta seccin se
aplican a toda persona que posea el Software o cualquiera de los Mods
creados por usted.
 
 11.	Derechos de autor -  El Software y todos los derechos de autor,
marcas comerciales y todos los derechos de propiedad intelectual que
existan en relacin con el Software, son propiedad de Infogrames, Epic o
sus otorgantes de licencia y estn protegidos por las leyes de derechos
de autor, las disposiciones de los tratados internacionales, un ejrcito
de clones y toda las leyes pertinentes, como por ejemplo la ley Lanham. 
Deber tratar el Software como a cualquier otro material con derechos de
autor como lo establece el artculo 101 et seq del ttulo 17 del Cdigo
de los EE.UU. (U.S.C.) y otras leyes aplicables.  No realice copias no
autorizadas.  Este programa para el cual se le otorga licencia es el
producto del esfuerzo de mucha gente que se gana el sustento gracias al
uso legal del producto.   A estas personas les encanta comer, entonces
no realice copias para quienes no han pagado el derecho a utilizarlo. 
Si desea informar a la Software Publishers Association sobre violaciones
a los derechos de autor, llame al 1?800?388?PIR8 o escriba a   Software
Publishers Association, 1101 Connecticut Ave., Suite 901, Washington,
D.C. 20036.
 
 12.	Requisitos para disfrutar del producto -  Sabemos que hay
descontento y quejas dentro de la comunidad de usuarios de juegos sobre
los estrictos contratos de licencia onerosos.  Le damos nuestra palabra
de que este contrato es lo ms justo y equitativo posible y dado que
usted ley TODO hasta aqu, ya sabe que no le mentimos. Ahora, retrese
de esta pantalla y disfrute del Software, incluyendo el UnrealEd!
 
 
 
 
 NB: El contrato de licencia se aplica slo a los usuarios americanos.                                                                                                                                                  eula/License.frt                                                                                    0100644 0001750 0000144 00000031465 07542467527 013525  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  CONTRAT DE LICENCE D'UTILISATION
 
 VEUILLEZ LIRE CE CONTRAT ATTENTIVEMENT. L'UTILISATION OU L'INSTALLATION
DE CE LOGICIEL, OU SON PLACEMENT OU SA COPIE SUR LE DISQUE DUR DE VOTRE
ORDINATEUR, DANS LA MMOIRE VIVE (RAM) OU AUTRE SUPPORT DE STOCKAGE,
VOUS ENGAGE A RESPECTER LES TERMES DE CETTE LICENCE. SI VOUS CONTESTEZ
CES TERMES, ARRTEZ IMMEDIATEMENT LE PROCESSUS D'INSTALLATION ET CESSEZ
TOUTE UTILISATION DE CE LOGICIEL.
 
 1.	Merci. Flicitations et remerciements pour la licence de ce
logiciel. Nous sommes dsols de peut-tre vous dranger, mais nos
avocats nous disent que si nous voulons conserver le contrle et la
proprit du super programme que nous dveloppons, nous devons tre srs
que vous comprenez et acceptez le fait que cette licence vous donne
seulement le droit de l'utiliser, et que ce droit est limit. Donc, les
paragraphes ci-aprs noncent ce que vous devez savoir et accepter.   
 
 2.	Licence. Le logiciel et la documentation qui accompagnent cette
licence (le logiciel) font l'objet d'une licence qui vous autorise 
l'utiliser et  profiter des jeux, sous rserve des termes et
limitations noncs dans le prsent contrat. La redevance que vous avez
paye pour cette licence vous donne le droit d'utiliser le logiciel. Si
le logiciel est configur pour tre tlcharg sur un disque dur, vous
ne pouvez le faire que sur le disque dur d'un seul ordinateur et ne
l'exploiter qu' partir de ce mme disque dur ; vous pouvez toutefois
participer  une configuration pour plusieurs joueurs (comme une salle
de jeux Internet) avec d'autres participants titulaires eux aussi de
licences valides ; autrement dit, vos amis doivent obtenir une licence
pour leurs propres copies de ce logiciel. Le logiciel comprend un
diteur qui, si vous l'utilisez, est soumis aux conditions nonces dans
la Section 8 ci-aprs.	
 
 3.	Exploitation commerciale. Vous ne pouvez utiliser ce jeu, ni
aucune des modifications (modifs) cres pour ce jeu ou les outils
fournis pour ce jeu,  des fins commerciales sans l'autorisation crite
pralable d'Epic Games Inc., en ce compris, mais sans caractre
limitatif, les rgles suivantes : 1. Si vous tes  propritaire d'un
caf ou d'une salle de jeux Internet, vous pouvez exploiter le logiciel
sur la base de  payer pour jouer ,  condition que tous les
ordinateurs utiliss contiennent un logiciel couvert par une licence
valide, ledit logiciel ayant t achet dans un magasin de dtail ou
chez un fournisseur similaire (nous n'offrons pas de rabais pour achats
groups ou licences d'installation multiples). 2. Il vous est interdit,
sans le consentement pralable crit d'Epic, d'utiliser le logiciel pour
des concours de jeu o (a) la valeur en espces de tous les gains et
prix pays pendant tout le concours est suprieure ou gale  5 000
dollars amricains ($US) OU (b) le nom de l'vnement, ou de tout
concours individuel s'y droulant, contient ou fait penser au nom d'une
entreprise, d'un produit ou d'un service commercial OU (c) une
entreprise a fourni, sous forme de donation ou parrainage, des prix,
produits ou services d'une valeur marchande dpassant 5 000 $US. 
 
 4.	Restrictions d'utilisation. Notre intention est de vous divertir
pendant de longues annes avec nos produits et de continuer  vous
envoyer des jeux sortant de l'ordinaire ; vous devez donc savoir ce que
vous ne devez pas faire avec le logiciel. Le logiciel contient des
lments protgs par droits d'auteur, des secrets commerciaux et autres
lments d'exclusivit. Il vous est interdit de dcomposer, modifier,
dsosser, afficher publiquement, crer des documents inspirs du
logiciel (sauf ce que permet la Section 8 ci-aprs), dmonter ou
autrement reproduire le logiciel. Exception faite des cas spcifis aux
prsentes, vous ne devez pas louer, vendre, cder en leasing, accorder
une sous-licence ni distribuer le logiciel. Vous ne devez pas supprimer
les avis de droits d'auteur ou autres lgendes d'exclusivit figurant
sur l'original du logiciel. Vous ne devez pas offrir le logiciel sur une
base d'un paiement  la pice ou par ailleurs l'exploiter sur une base
mercantile ou l'utiliser  des fins commerciales   sauf comme dcrit
dans ce contrat. Vous ne devez pas transmettre lectroniquement le
logiciel d'un ordinateur  un autre ou sur un rseau. Il vous est
interdit d'expdier ou d'exporter le logiciel vers tout pays autre que
celui o vous l'avez achet, sou peine d'infraction  l'U.S.
Administration Exportation Act (loi amricaine sur l'administration des
exportations) ou  toute autre loi rgissant ce secteur, et vous
n'utiliserez ni n'autoriserez quiconque  utiliser le logiciel
contrairement aux lois en vigueur. Le logiciel ne doit pas tre
tlcharg ou autrement export dans (ou au profit d'un citoyen ou
rsident de) tout pays sous embargo commercial des tats-Unis, ou au
profit de quiconque ou d'un pays non autoris comme bnficiaire selon
les lois en vigueur. 
 
 5.	Rsiliation. Cette licence a force de droit jusqu' sa
rsiliation par l'un d'entre nous. Vous pouvez rsilier cette licence 
tout moment en dtruisant le logiciel et sa documentation. Dans le cas
peu probable o par espiglerie vous ne vous conformeriez pas  l'une
quelconque des dispositions de cette licence, cette dernire serait
immdiatement rsilie sans notification de notre part. Ds la
rsiliation, vous devrez dtruire le logiciel et sa documentation. Nous
vous demandons de ne pas attendre que nous vous poursuivions - cela
serait aussi dsagrable pour vous que pour nous. Si nous devions vous
poursuivre, il vous faudrait payer pour tous nos ennuis, y compris les
frais de nos avocats.
 
 6.	Dsistement de garantie du logiciel. Vous devez savoir et
convenir que l'utilisation du logiciel et de ses supports
d'enregistrement est entirement  vos risques. Le logiciel, la
documentation et les supports sont livrs  TELS QUELS . Sauf
indication contraire par une loi en vigueur, Infogrames ( Inforames )
garantit  l'acheteur initial de ce produit que le support de stockage
du logiciel restera sans dfaut de matriau et de fabrication - sous
conditions normales d'utilisation - pendant quatre vingt dix (90) jours
 compter de la date d'achat.   ce propos, Infogrames offre cette
garantie  l'utilisateur en tant qu'diteur du logiciel. Cette garantie
est annule si la dfectuosit provient d'un accident, d'un abus, d'une
ngligence ou d'une mauvaise application. INFOGRAMES ET EPIC GAMES, INC.
(EPIC) DCLINENT EXPRESSMENT TOUTES AUTRES GARANTIES EXPRESSES OU
TACITES, NOTAMMENT, MAIS SANS CARACTRE LIMITATIF, LES GARANTIES TACITES
DE VALEUR MARCHANDE ET D'ADQUATION  DES FINS PARTICULIRES. NOUS NE	
	GARANTISSONS PAS QUE LES FONCTIONS CONTENUES DANS LE LOGICIEL
RPONDRONT  VOS BESOINS. AUCUNE INFORMATION VERBALE OU CRITE NI AUCUN
CONSEIL DONN PAR NOUS OU L'UN QUELCONQUE DE NOS REPRSENTANTS AGRS NE
DONNERA LIEU   UNE GARANTIE OU, D'UNE MANIRE OU D'UNE AUTRE,
N'AUGMENTERA LA PORTE DE CETTE GARANTIE. TANT DONN QUE CERTAINES
JURIDICTIONS N'AUTORISENT PAS L'EXCLUSION DE GARANTIES TACITES, LES
EXCLUSIONS CI-DESSUS PEUVENT NE PAS VOUS CONCERNER. 
 
 7.	Limitation de responsabilit. EN AUCUNE CIRCONSTANCE, EN CE
COMPRIS SANS LIMITATION LA NGLIGENCE, INFOGRAMES, EPIC OU L'UN
QUELCONQUE DE LEURS CADRES, EMPLOYS, DIRECTEURS, AGENTS, TITULAIRES DE
LICENCES, TITULAIRES DE SOUS-LICENCES OU AYANTS DROIT, NE SAURAIENT TRE
TENUS RESPONSABLES  DES DOMMAGES ACCIDENTELS, SPCIAUX OU CONSCUTIFS
RSULTANT DE L'UTILISATION OU DE L'INCAPACIT D'UTILISER LE LOGICIEL OU
SA DOCUMENTATION, MME SI LES PARTIES ONT T INFORMES DE LA
POSSIBILIT DE CES DOMMAGES. TANT DONN QUE CERTAINES JURIDICTIONS
N'AUTORISENT PAS LA LIMITATION OU L'EXCLUSION DE RESPONSABILIT EN
MATIRE DE DOMMAGES ACCIDENTELS OU CONSCUTIFS, LA LIMITATION OU
L'EXCLUSION CI-DESSUS PEUT NE PAS VOUS CONCERNER. En aucun cas notre
responsabilit entire envers vous pour tous dommages, pertes et causes
d'action en justice (par suite de contrat, dlit civil ou autrement) ne
saurait excder le montant que vous avez pay pour le logiciel.
 
 8.	Lgislation et dissociation. Cette licence est rgie et
interprte conformment aux lois de l'tat de Caroline du Nord,
tats-Unis d'Amrique. Les poursuites ne pourront avoir lieu que dans le
comt de Wake, Caroline du Nord. Au cas o une disposition quelconque de
cette licence s'avrerait non excutoire, les autres dispositions du
contrat resteraient en vigueur.
 
 9.	Accord complet. Ce contrat de licence reprsente l'accord
complet entre les parties en ce qui concerne l'utilisation du logiciel
et de sa documentation. Toutefois, Infogrames et Epic se rservent le
droit d'en modifier les termes de temps  autre et afficheront une
notification des changements apports sur le site www.epicgames.com. 
 
 10.	diteur et modifications par les utilisateurs 
 (a)	Le logiciel contient un diteur et des outils et utilitaires y
associs (le  UnrealEd ).  UnrealEd est une caractristique trs
agrable qui vous permet de modifier le logiciel ou de construire de
nouvelles variantes  utiliser avec lui. Ces modifications et variantes
peuvent tre jouables et non jouables. UnrealEd NE DOIT PAS tre
diffus. Il vous est interdit de le distribuer librement  l'aide d'un
babillard lectronique, de disques compacts, de disquettes ou autres
supports. Vous ne devez pas le vendre ni le reconditionner pour la
vente.	
 (b)	 l'aide d'UnrealEd, vous pouvez apporter des modifications ou
amliorations au logiciel, notamment la mise en place de nouveaux
niveaux (le tout collectivement dsign sous l'appellation de  modifs
), sous rserve des restrictions suivantes :
 i.	Vos modifs doivent fonctionner uniquement avec la copie complte
et enregistre du logiciel, et non pas indpendamment ou avec un autre
logiciel. 
 ii.	Vos modifs ne doivent contenir aucune modification de fichiers
excutables.
 iii.	Vos modifs ne doivent pas contenir de documents diffamatoires,
diffamants ou autres documents illicites ou scandaleux susceptibles
d'empiter sur la vie prive ou les droits de publicit d'une tierce
partie ; elles ne doivent pas non plus contenir (ni tre utilises
conjointement avec) des marques de commerce, des matriels protgs par
des droits d'auteur ou toute autre proprit reconnue appartenir  des
tiers. Vos modifs ne doivent pas non plus tre utilises, par vous ou
quelqu'un d'autre, en vue d'une exploitation commerciale, notamment,
mais sans caractre limitatif, pour la publicit ou la commercialisation
pour une entreprise, un produit ou un service. 
 iv.	Vos modifs n'auront pas le soutien d'Infogrames, d'Epic ou de
leurs affilis et filiales, et en cas de distribution en vertu de la
prsente licence, vos modifs devront inclure une observation  cet
effet.
 v.	Vos modifs ne peuvent tre distribues que gratuitement. Ni
vous, ni personne d'autre ne peut les vendre  qui que ce soit, les
exploiter commercialement d'une faon ou d'une autre, ou facturer
quelqu'un pour les recevoir ou les utiliser, sans l'autorisation
pralable crite d'Epic Games Inc. Vous pouvez les partager gratuitement
avec d'autres utilisateurs et les distribuer sur l'Internet, au moyen de
disques de couverture de magazines ou autrement,  titre gratuit.
 vi.	Les interdictions et restrictions contenues dans cette section
s'appliquent  quiconque en possession du logiciel ou de l'une
quelconque de vos modifs.
 
 11.	Droits d'auteur. Le logiciel et tous les droits d'auteur,
marques de commerce et autres droits de proprit intellectuelle
concernant le logiciel sont la proprit d'Infogrames, d'Epic ou de
concdants desdites parties, et sont protgs par les lois des
tats-Unis sur les droits d'auteur, les dispositions de traits
internationaux, une flope de cones  et toutes les lois en vigueur,
telles que la loi Lanham. Vous devez traiter le logiciel comme toute
autre matriel protg par un droit d'auteur, comme l'exige le Code U.S.
17, section 101 et seq. et toute autre loi en vigueur. Nous vous
demandons de ne pas faire de copies sans autorisation. Le programme dont
vous dtenez la licence d'utilisation est le rsultat des efforts de
nombreuses personnes qui gagnent leur vie grce  son utilisation
lgale. Ces personnes ont besoin de faire face  leur budget - aussi ne
faites pas de copies pour ceux qui n'ont pas pay le droit
d'utilisation. Pour signaler des infractions aux droits d'auteur 
Software Publishers Association (Association des diteurs de logiciels),
appelez le 1?800?388?PIR8 ou crivez  Software Publishers Association,
1101 Connecticut Ave., Suite 901, Washington, D.C. 20036, U.S.A.
 
 12.	Amusement obligatoire. Nous savons que la communaut des jeux
rle  propos de contrats de licence rigoureux et lgalement onreux.
Vous avez notre parole que le prsent contrat est aussi impartial que
possible et, maintenant que vous l'avez lu jusqu'ici, vous savez que
c'est la vrit. Il est temps de quitter cet cran et de vous amuser
avec le logiciel et UnrealEd.
 
 13.	La proposition de contrat de Licence ne s'applique qu'aux
consommateurs Amricains.                                                                                                                                                                                                           eula/License.itt                                                                                    0100644 0001750 0000144 00000032625 07542467527 013531  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  CONTRATTO DI LICENZA PER L'UTENTE FINALE
 
 VI PREGHIAMO DI LEGGERE ATTENTAMENTE. L'UTILIZZO O L'INSTALLAZIONE DEL
PRESENTE SOFTWARE, OPPURE LA SUA MEMORIZZAZIONE O COPIA NELL'HARDWARE,
NELLA RAM O IN QUALSIASI SUPPORTO INFORMATICO DEL VOSTRO COMPUTER,
COMPORTANO L'ACCETTAZIONE DEI TERMINI DI QUESTA LICENZA. COLORO CHE NON
ACCETTASSERO TALI TERMINI, SONO INVITATI AD INTERROMPERE IMMEDIATAMENTE
LA PROCEDURA D'INSTALLAZIONE E QUALSIASI ALTRA FORMA DI UTILIZZO DI
QUESTO SOFTWARE.
 
 1. Ringraziamento.  Congratulazioni e grazie per usare il nostro
software. Ci scusiamo per i limiti un po' invadenti che vi imponiamo, ma
i nostri avvocati ci hanno ricordato che, se vogliamo mantenere la
titolarit dei diritti relativi ai prodotti da sballo da noi sviluppati,
dobbiamo soffermarci un attimino su questo punto ed essere sicuri che
abbiate capito e che siate d'accordo che state acquisendo soltanto il
diritto d'uso di tale prodotto e che, per di pi, tale diritto 
limitato sotto alcuni punti di vista. Ecco pertanto quello che dovete
sapere e le condizioni da accettare.  
 
 2. Licenza.  Il software che accompagna la presente licenza e la
documentazione annessa (da qui in poi collettivamente definiti
Software) vengono concessi per uso personale e di svago, sempre
secondo le restrizioni ed i termini qui contenuti. L'importo pagato per
la licenza rappresenta il corrispettivo per il diritto di utilizzo del
Software. Qualora il Software fosse configurato in modo da essere
memorizzato su un disco rigido, potrete installare il programma stesso
su un solo computer ed eseguirlo esclusivamente da quella postazione. 
comunque possibile utilizzare il Software in ambienti multigiocatore
(come nelle sale giochi virtuali su Internet), interagendo con altri
utenti dotati di una licenza valida; in altre parole, anche i vostri
amici dovranno avere la loro licenza. Allegato al Software c' un editor
del programma, il cui utilizzo  disciplinato dall'articolo 8 (vd.
sotto).  
 
 3. Sfruttamento commerciale.  vietato utilizzare questo gioco, o
qualsiasi Mods creato per esso, anche utilizzando gli strumenti di
sviluppo in dotazione, per qualsiasi scopo commerciale o di lucro senza
il consenso preventivo espresso per iscritto dalla Epic Games Inc. ed in
osservanza, tra l'altro, delle seguenti condizioni: 1. A coloro che
fossero titolari di un Internet-caff o di una sala giochi, viene
consentito utilizzare il Software nella formula gioco a pagamento a
condizione che su tutti i computer usati sia validamente installata
l'apposita licenza per il Software, acquistata presso un negozio al
dettaglio o presso un fornitore analogo (attenzione, noi non offriamo
sconti quantit o licenze multiuso). 2. Senza il consenso preventivo
espresso per iscritto dalla Epic,  assolutamente vietato utilizzare il
Software per qualsiasi concorso nel caso in cui: (a) il montepremi in
denaro liquido per tutti i vincitori ed i vari premi pagati per tutta la
durata del torneo sia uguale o superiore a USD 5.000 OPPURE (b) il nome
del concorso, o di qualsiasi partita prevista da tale concorso,
incorpori o richiami un marchio aziendale, il nome di un prodotto o di
un servizio commerciale OPPURE (c) un'azienda abbia fornito, a titolo di
donazione o di sponsorizzazione, premi, prodotti o servizi per un
controvalore di mercato superiore a USD 5.000. 
 
 4. Restrizioni d'uso.	Desideriamo che vi divertiate usando i nostri
prodotti anche in futuro, e vogliamo poter continuare ad offrirvi giochi
mozzafiato anche per gli anni a venire. A tal proposito, tenete presente
che ci sono cose che non potete fare con questo software. Esso, infatti,
contiene materiale coperto da copyright, segreti industriali ed altri
diritti intellettuali di propriet riservata. Al fine di proteggerli,
viene fatto divieto di decompilare, modificare, eseguire
ingegnerizzazione inversa, esporre al pubblico, preparare prodotti
derivati o comunque di trasformazione del Software (ad eccezione di
quanto indicato nell'art. 8 -vd. sotto). Fatte salve le eccezioni qui
specificate, viene anche fatto divieto di noleggiare, vendere,
affittare, concedere eventuali sublicenze o distribuire il Software,
ovvero di cancellare gli avvisi di copyright o qualsiasi altra
indicazione della titolarit dei diritti esclusivi di privativa che si
trovano sulla copia originale dello stesso. Salvo i casi espressamente
contemplati nel presente accordo, viene fatto assoluto divieto di
offrire l'uso del Software dietro corrispettivo, o comunque a scopi
commerciali o di lucro.  vietato trasferire elettronicamente il
Software da un computer all'altro o tramite un collegamento di rete. 
vietato spedirlo o esportarlo in altri Paesi diversi da quello in cui 
stato acquistato, in violazione delle leggi statunitensi vigenti in
materia di esportazione (o di qualsiasi altra normativa in vigore). Non
 inoltre possibile utilizzare, o autorizzare l'utilizzo a chicchessia
del Software, in violazione di qualsiasi legislazione vigente.  vietato
scaricare via Internet o trasferire con altri mezzi il Software in
qualsiasi Paese (o a qualsiasi cittadino o residente di tali paesi)
destinatario di sanzioni economiche, di embargo o di altri provvedimenti
simili emanati dagli Stati Uniti d'America. 
 
 5. Revoca e recesso.  La presente licenza rimane valida fino
all'eventuale revoca/recesso di una delle parti. L'utente potr recedere
dalla licenza in qualsiasi momento, semplicemente distruggendo il
Software e la documentazione annessa.  Se invece fate i cattivi e non
rispettate le condizioni ed i termini qui indicati, la presente licenza
dovr ritenersi tacitamente revocata da parte nostra. Qualora ci
accadesse, sar obbligatorio distruggere il Software e la documentazione
annessa. Vi preghiamo di non aspettare il nostro intervento per farlo;
non sarebbe un'esperienza piacevole per nessuno di noi. Se ci
costringete ad intervenire, saremo costretti a chiedere il risarcimento
di tutti i danni morali e materiali, comprese le spese per gli avvocati.
 
 6. Limitazione del diritto di garanzia sul software.  L'utente assume a
proprio carico tutti i rischi derivanti dall'uso del Software e del
supporto informatico sul quale  memorizzato. Il Software, la
documentazione annessa ed il suo supporto informatico sono forniti nello
stato in cui si trovano. Fatte salve le disposizioni inderogabili in
materia, la Infogrames (Infogrames) garantisce all'acquirente
originario di questo prodotto che, in condizioni di normale utilizzo, il
supporto informatico sul quale il Software  memorizzato  esente da
difetti nei materiali e di manodopera per un periodo di 90 (novanta)
giorni dalla data di acquisto. In ogni caso, la Infogrames garantisce
questo prodotto all'utente finale in qualit di casa editrice del
Software. La presente garanzia dovr considerarsi decaduta qualora
l'eventuale malfunzionamento del prodotto derivasse da eventi
accidentali, abusi, trascuranza o applicazione erronea. LA INFOGRAMES E
LA EPIC GAMES, INC. (EPIC) NON RILASCIANO NESSUN'ALTRA GARANZI
 A, N TACITA N ESPLICITA, COMPRESE, FRA L'ALTRO, QUELLE SULLA
COMMERCIABILIT DEL PRODOTTO O SULLA SUA IDONEIT AD UN IMPIEGO
PARTICOLARE. PER DIRLA IN BREVE, NON GARANTIAMO CHE LE FUNZIONALIT
CONTENUTE NEL SOFTWARE SODDISFERANNO LE VOSTRE ASPETTATIVE.  NESSUNA
DICHIARAZIONE SCRITTA O ORALE RILASCIATA DA NOI O DA UN NOSTRO
RAPPRESENTANTE UFFICIALE POTR ESSERE INTERPRETATA COME ULTERIORE
GARANZIA O ULTERIORE ESTENSIONE DEL DIRITTO DI GARANZIA. ALCUNI PAESI O
STATI NON PERMETTONO L'ESCLUSIONE DI GARANZIE IMPLICITE, E PERTANTO LA
PRESENTE CLAUSOLA POTREBBE NON RIFERIRSI AL CASO IN QUESTIONE.
 
 7. Limitazione di responsabilit.  IN NESSUN CASO, COMPRESO, FRA
L'ALTRO LA COLPA GRAVE, LA INFOGRAMES, LA EPIC E QUALSIASI ALTRA PERSONA
FISICA O GIURIDICA FACENTE LE LORO VECI, QUALI AMMINISTRATORI,
DIPENDENTI, DIRETTORI, AGENTI, LICENZIATARI, SUBLICENZIATARI O
MANDATARI, RISPONDERANNO DEI DANNI INDIRETTI E INCIDENTALI DERIVANTI
DALL'UTILIZZO OVVERO DAL MANCATO UTILIZZO DEL SOFTWARE O DELLA
DOCUMENTAZIONE ANNESSA. TALE ESCLUSIONE RIGUARDA ANCHE I CASI IN CUI LA
POSSIBILIT DEL VERIFICARSI DI TALE EVENTO FOSSE STATA PRECEDENTEMENTE
NOTIFICATA ALLE PARTI DI CUI SOPRA. ALCUNI PAESI O STATI NON PERMETTONO
L'ESCLUSIONE DEL RISARCIMENTO DEI DANNI INDIRETTI E INCIDENTALI, E
PERTANTO LA PRESENTE CLAUSOLA POTREBBE NON RIFERIRSI AL CASO IN
QUESTIONE. In nessun caso, la nostra responsabilit patrimoniale per
tutte le perdite e per tutti i danni derivanti da nostra inadempienza
(sia essa contrattuale, extracontrattuale, colposa o dolosa) potr
eccedere la somma pagata per il software.
 
 8. Giurisdizione e foro competente.  La presente licenza  stata
stilata e stipulata secondo le leggi vigenti in materia nello stato
della Carolina del Nord (U.S.A.). Sar il tribunale della contea di
Wake, nella Carolina del Nord, il foro competente per le eventuali
controversie da essa derivanti.  Anche nei casi in cui una delle varie
clausole in essa contenute non fosse valida, tutte le altre dovranno
essere considerate valide a tutti gli effetti.
 
 9. Accordo completo.  Per quello che riguarda l'utilizzo del Software e
della documentazione annessa, la presente licenza rappresenta l'intero
accordo tra le parti. La Infogrames e la Epic, tuttavia, si riservano il
diritto di modificare periodicamente i termini e le clausole in essa
contenuti, notificando tutti gli interessati a mezzo di avvisi pubblici
sul sito Internet www.epicgames.com.  
 
 10. Programma editor e Mods dell'utente finale.
 (a) Il Software include un programma di editor con associata una serie
di strumenti ed utility (denominata UnrealEd). UnrealEd  un insieme
di funzionalit da sballo per modificare il Software o realizzare nuove
variazioni da utilizzare con esso. Tali modifiche possono o meno essere
giocabili. Attenzione! UnrealEd NON  un programma shareware.  vietata
la sua distribuzione libera tramite qualsiasi bacheca elettronica, CD,
floppy o qualsiasi altro supporto informatico.  inoltre vietata la sua
rivendita o il suo reimballaggio a tali fini.  
 (b) Utilizzando UnrealEd  possibile modificare o persino migliorare il
Software, costruendo, ad esempio, nuovi livelli (definiti
collettivamente Mods), osservando sempre le seguenti limitazioni:
 i. I "Mods" devono funzionare solo con la copia completa e registrata,
non in forma autonoma o congiuntamente ad altri programmi.
 ii. I Mods creati non devono apportare modifiche a nessun file
eseguibile.
 iii. I Mods creati non devono contenere materiale diffamatorio,
denigratorio, illegale, scandaloso o comunque violare i diritti di
privacy o di pubblicit di terzi.  fatto inoltre divieto di inserire o
di utilizzare marchi registrati, opere protette da copyright o qualsiasi
altra opera d'ingegno chiaramente di propriet di terzi. Infine, 
vietato utilizzare i Mods, sia personalmente che a mezzo di altre
persone, per qualsiasi sfruttamento commerciale, compresi, tra gli
altri, i casi: (a) di pubblicit o di marketing per una determinata
azienda, prodotto o servizio.
 iv. I Mods creati non godranno di supporto da parte della Infogrames,
della Epic o dei loro eventuali aventi causa. Se distribuiti secondo la
presente licenza, i Mods creati dovranno riportare una dicitura che
renda nota tale limitazione.
 v. L'eventuale distribuzione dei Mods creati dovr avvenire soltanto
a titolo gratuito, sia chiaro.  fatto assoluto divieto a chiunque di
venderli, di sfruttarli commercialmente o a fini di lucro, oppure di
cederli in uso sempre a titolo oneroso	senza il consenso preventivo
espresso per iscritto dalla Epic Games Inc.  comunque possibile
scambiarli gratuitamente con altri utenti finali, distribuirli tramite
Internet oppure allegarli a giornali o a riviste, sempre, per, a titolo
gratuito.
 vi. I divieti e le restrizioni contenuti in questa clausola sono
applicabili a tutti coloro che possiedono il Software o i Mods.
 
 11. Copyright.  Questo Software ed i relativi copyright, marchi di
fabbrica e tutti gli altri diritti di propriet intellettuale ad esso
correlati, appartengono alla Infogrames, alla Epic o ai loro eventuali
aventi causa. Tali diritti sono tutelati e protetti dalle leggi degli
Stati Uniti, da trattati e da convenzioni internazionali in materia di
copia e riproduzione, tipo il Lanham Act.  obbligatorio trattare il
Software alla pari di qualsiasi altro materiale protetto da copyright,
ai sensi del libro 17 del Codice Commerciale degli U.S.A, articolo 101 e
seguenti e delle altre leggi in materia. Per piacere, non fatene copie
illegali. Il programma oggetto della presente licenza  frutto degli
sforzi di molte persone che si guadagnano da vivere grazie a coloro che
lo utilizzano legittimamente. Questa gente deve pur mangiare, perci non
copiatelo per coloro che non hanno pagato per avere il diritto di
utilizzarlo. Per denunciare alla Software Publishers Association casi di
pirateria e di violazione dei copyright, chiamate il numero
1-800-388-PIR8 o scrivete a: Software Publishers Association, 1101
Connecticut Ave., Suite 901, Washington, D.C. 20036 (USA).
 
 12. Requisiti per divertirsi.	Sappiamo bene che in giro, tra la
comunit dei giocatori pi accaniti e nel mercato dei videogiochi, ci
sono un sacco di contratti di licenza con molti panegirici e clausole
orripilanti. Vi diamo la nostra parola che questo  un contratto onesto
ed il pi equo possibile per entrambe le parti: avendolo letto, vi
sarete certamente resi conto che  vero! Ora, non perdete tempo: uscite
da questa schermata e divertitevi con il nostro Software e l'allegato
programma UnrealEd.
 
 13. Il contratto di licenza  valido solo per gli utenti americani.                                                                                                           postinstall.sh                                                                                      0100777 0001750 0000144 00000000303 07542334360 013366  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  #!/bin/sh

xterm -e sh ./cdkey.sh $SETUP_INSTALLPATH || /usr/X11R6/bin/xterm -e sh ./cdkey.sh $SETUP_INSTALLPATH || sh ./cdkey.sh $SETUP_INSTALLPATH || exit 1
exit 0

# end of preinstall.sh





                                                                                                                                                                                                                                                                                                                             preuninstall.sh                                                                                     0100777 0001750 0000144 00000000050 07542314345 013532  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  
rm -f $SETUP_INSTALLPATH/System/cdkey

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        setup.data/                                                                                         0040777 0001750 0000144 00000000000 07542043303 012524  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  setup.data/bin/                                                                                     0040777 0001750 0000144 00000000000 07537165122 013304  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  setup.data/bin/Linux/                                                                               0040777 0001750 0000144 00000000000 07537165135 014407  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  setup.data/bin/Linux/x86/                                                                           0040777 0001750 0000144 00000000000 07542040374 015025  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  setup.data/bin/Linux/x86/setup                                                                      0100777 0001750 0000144 00003210620 07542466464 016130  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  ELF              4   
     4    (            ,P ,P          @P @@B                                      GNU                US    [s     t.   °
 ]             1^PTRh1hQVh '8 U=H u>DPD СD8 u    t
h~H   ]Ív U]ÉU    th`"h_~]Ív U]ÐUj$ tEB    B    Љ]ÐU   WVS}UEPRh     V    E;r  PV  P9  j$ Ãuwtt   t   u@@)@P# uS,K (VP3V C     u_GX_1[^_]UVS]tHh2EP ƃu)[tVP [uVQ 1e[^]ÉUVSut5~ t&^CFPcJ SZJ  ~ uڃVHJ e[^]ÐUEPLuM=x" t
	9|"t#jh
2j 8O x"	|"x"P$Py ]ÐULP(]U   SUEPRh     S Sh2j LP]U   SUEPRh     S] Sh2jLPR]U   SUEPRh     S Sh2jLP]U   SUEPRh     S Sh2jLP]U   SUEPRh     S LSh2jP k U   SUEPRh     S]  et
jS$PS   ]ÐUSj  Ãt.EP*S EPS CPCP؋]]Ív U=P ]UWVS}1h 2h"2X Ãt8W PAR u
   v S uӃSs e[^_]Ív UVSuEPV0R >/ultzt8#t+C8#t&C8#t!Ctt   t
   uCC&    FK9v;/u j V |܍e[^]Ív USP   P=" t
	9"t#jh,2j K "	""P	jCPhA2j Y   tQCPP=" t
	9"t#jh`2j 7K "	""PPE CPE ؋[ PE P    ]]Ív U\  WVSEǅ    ǅ    8/  PSdP މtt   t
   uFFv N9v>/u     j SK |ɀ    EPSz th2 1   EĉEЉÉƋ㉅É}  [^_]ÐU<  WVSǅ    h 2h2ؿ ,     2   B tƿ2       PN ÃBPN ƃSunjSh2j V  uXVSPS=" t
	9"t#jh2j rH "	""PSC VB  P~ R h 2h"2艾   U  v P PM BPSvM ޿2   1t߅   h2BPR t%PS!M j,ScK t  h2BPBR t%PVL j,V K t  jh2V&O uQ PVt t:2    u'BPL UPϸ t
RB [^_]Ív UVS]u   ؃t1}%}KP@ KP@ K7DP@ DP@ DP{@ Pi@ ue[^]ÐUl  WVSEǅ    ǅ    0P  tv j S$  [uU0P     h2f ƃu~j
h2PtV tt   t   uAA: t5L	BA: u WUf ƃtLCPVh2h  P  j Rz uVS#  [ t   S1;   U0P  Ptk<     &    CP/Ph2h  VQ  j Vá u/PS/#  [u;mPR![^_]ÉU  WVSE1pEPE0P  t'PEPH u
sCu\[uم   tH=" t
	9"t#jh 3j B "	""Fv 맃=" t
	9"t#jh@3j uB "	""xVSh    S j S eЃ u	褎  1
[^_]ÐUh~3c Tu.h3c Tuh3{c TTP=" t
	9"t#jh3j A "	""P~]ÉUWVS]t?Tt<uBt,ֿ3    tSRIL ;Tu   ޿3    t1e[^_]Ív UWVSu   uFu
FuF   E    VF ǉj W& UP  PVF tsj VD ÅűUP  PVE uE   W: E   e[^_]ÐUUt?uBu
BuBtEP  PRzE t1   ]Ív U,WVSUE     uBu
BuB  E P     RzE E܃j-RC ƅt FU P  `PEPD    C  3E    E    fE3EEjj PM ]SEPEPh3V  Eu
BuBu*E$P  E9|?   UE9(P     %ֿ3    uUE9$P     E    }ֿ3    uUE9$P  uԋE9(P  tOǉR=" t
	9"t#jh3j > "	""PE܃P8 &    E    Ee[^_]ÐUWVSXEj/URF uEj.PA u     }    UE       u  PEPVH    Ӄtzt8#t+C8#t&C8#t!Ctt   t
   uCC)ӋU:>  ʉȃtzt80t-@80t(@80t#@tt   t   u@@)9#UEU;  ,E@E1e[^_]Ív UVSu]j ¡X2ZBX  u   Ѝe[^]UVSX1t%  tƉ؋[P6 uۉe[^]UWVS}5X=" t
	9"t#jh 4j ; "	""PW E     P   PP=" t
	9"t#jh 4j 0; "	""PWv  ~ uK=" t
	9"t#jh`4j : "	""PW%   P=" t
	9"t#jh4j : "	""PW 1ۃ;  s%  Ph4W C;  rۃh4W ve[^_]Ív US=\ t\j P; u]   ]ÐUWVSEP? 1h4SD 1t"  Xh4VGJ u   ;/   th4V J    j/Sj= t  j:SU= t  @j j
j PN] fuP   S EuVS  t(S t^AAPRV:J ff}fE j jj蛱 Ã|#jEPS |
S 1e[^_]UVSj ƃuU=" t
	9"t#jh4j +8 "	""P1y  &    ]S蔖 }]=" t
	9"t#jh 5j 7 "	""PnVU2 1      EF] ttz   t& =" t
	9"t#jh(5j F7 "	""PEP} C Pn Fat& EPT EP }jhF5t& jhH5CPm j PY CP ~ }VJ1 1e[^]ÐU   WVS1    uEPЃxjSE Sj j VUB@Pݧ  1ۃu*jwPUBP苓 u
wy؉؍X[^_]ÉUS]CP2 jPQ  j 4Z Sg0 ]]ÐUEh`5P  @,P萟 uh5]Ív UEhi5P  @,P` uh5]Ív UEhn5P  @,P0 ]UEhx5P  @,P ux5]Ív UEh5P  @,Pܞ u5]Ív UEh5P  @,P謞 ]UEh5P  @,P舞 ]UEh5P  @,Pd th5PD u   t& 1]ÉUEh5P  @,P th5PD u   1]ÉUEh5P  @,PН th5PkD u   1]ÉUEh5P  @,P舝 th5P#D u   1]ÉUEh5P  @,P@ th5PC u   1]ÉUEh5P  @,P ]UEh5P  @,P̜ th5P= t   1]ÉU0  WVS} /  h5EP} ƃ   5       Ur     h5V- ~   h  WPC  W So  /t=SEPh6h  RJ  Pxz  QSez  t%vXURUBPt	   E@E1[^_]Ul  WVSuǅ    ~W S~ u@= # t
	9#t jh 6j 0  #	# #  8P  uTV  =# t
	9#t jh`6j 0 #	##C  XW9vG=# t
	9#t jh6j 00 #	##  &    P Pj( uR%   = @  t@=# t
	9#t jh6j / #	##u  j P融 }G= # t
	9$#t jh 7j `/  #	$# #  &    FP  S4 uF=(# t
	9,#t jh@7j . (#	,#(#       VP  @,@P6tC=0# t
	94#t jh7j . 0#	4#0#\       tSjS| }A=8# t
	9<#t jh7j >. 8#	<#8#[^_]ÐUEh7P  @,P  ]UEh5P  @,Pܗ u7]Ív UWVSE    h8UP  @,P袗 Et-h    Ph@CE6 E   h 8&UP  @,X   t& s(8       ho8S* P tp}uh8jCPUP  PTt Et8@C @Cuv =@C uh    WV>  uE   [O} tIh@CE0  Ph6h    h@#  jh@#b u@#	&    1e[^_]UWVSh8UP  @,P! E    u#@READfDMEF 4&    h    Ph@4 E   h8~UP  @,X   s(8       ho8S膕 P tm}uh 9jCPUP  Pr Et5@ @u=@ uh    WV<  uE   [R} tHh@E0  Ph6h    h@cS  jh@c u
@c    1e[^_]UWVSUP  @,X   t& s(O9       ho8SZ P t}jCPUP  Pq Et[@ 8 tHh    h@EP;  h@h@-  hZ9h@- E8 u@
[B1e[^_]ÉUWVSEP  @,1ҋ@t"n5t& p(߹
    uB@u[^_]ÉU   WVSUǅ    P  @,X   s(5       jCPUP  Pwp  t,ƅ    uh    VW:  uVh\9S Pha9S诒 PEP  t[K[^_]Ív UEhd9P  @,PT ]UEhq9P  @,P0 ]UEhu9P  @,P 1҅t <tt<yu   Љ]ÐUWVSEh9P  @,P͑ ǃ  h   ƃfileF:// tzt8"t+B8"t&B8"t!Btt   t
   uBB)  )Ptzt80t-@80t(@80t#@tt   t   u@@Pޅ h9V*  tzt80t-@80t(@80t#@tt   t   u@@))SWV]. e[^_]Ív UEh9P  @,P| u9]Ív UEh9P  @,PL u9]Ív UEh9P  @,P ]UEh9P  @,P ]UEh9P  @,Pԏ ]UEh9P  @,P谏 ]UEh9P  @,P茏 ]UEh9P  @,Ph uh5]Ív UUEPP  @,P9 ]ÐUWVShTP  Z ǃuU=@ t
	9Dt#jh :j $ @	D@P$P 1[  hTP  W24 EP[ P  uW  1       WWG WGWG 趉 P   P  (P  P$P  P (P   P  P$P  P P=H t
	9Lt#jh :j # H	LHPǇ0P      P!H @P  ǇDP      Ǉ<P       h  0  PD WHP   WPWPPh6h  _S赻 0  Ejh@:Py4 Ƈ    S( ƃSVW^	  V u =l th  EPS+ =p t} t
h  E$Wth  WPVB+ } th  EP@  P!+ Ƈ@   @P  t-P~X l   h     PS* WÃtJ@P  t@SPxX DP  tǇDP      GPS@P  PGZ DP  Wit"WVPWLP   t& ǇLP      3  uj P  @,PW#  e[^_]UWVS]uVS& t<VS?, 9u.tt   t   u@@)D؍e[^_]ÐUVSuj ÃtHEP& CEP& EP& CC    0P  C0P  ؍e[^]Ív UVS]ut(CP tV>& CC    e[^]ÐUVSuj_ Ãt<EP% EP% CECC    <P  C<P  ؍e[^]Ív UVSuuR=P t
	9Tt#jh`:j  P	TPP$Pȷ /= j  ÃtAEP@% C    C    C    C    C    C    FC^؍e[^]UWVS}uj 3 Ãt^EPEPP$ |   CjP7. GCtV$ CC    _G=X t
	9\t#jh:j V X	\XPA؍e[^_]ÐUVSujc ÃtBEP$ EP# SEC; t
t	FC^ECG=` t
	9dt#jh:j  `	d`Pe[^]UVSuj Ãt.EPR# tc} tFC^RFC^G=h t
	9lt#jh:j  h	lhPe[^]UWVS}uGPVT"    j Ãt*VWMP" tUUBCZG=p t
	9tt#jh:j R p	tpP=e[^_]Ív UWVS}u](jX %  ErEBEBE MBE$BABQ  PuCPuCPuSt%AuCu
CuC   uH=x t
	9|t#jh:j N x	|x      ug   uCu
CuC   uCu
CuCB  =e 5     v = t
	9t#jh ;j  	]Au
CuC   = t
	9t#jh`;j 7 	P"   t& ty    up   V  Ph6h     Pl G= t
	9t#jh:j  	Pe[^_]ÐU  WVSu} >~  Ft</ue tPW    &    = t
	9t#jh;j  	   1ҍ t</tي
FBt</u Sj8 t@PW Lt& S= t
	9t#jh <j  	P0VW; [^_]ÉUEMPRQP]ÉUEM  RQP]Ív UWVS]$<s(׹   1tUuEPh5S } t5[t.s(}    uEPEPSEP[uҍe[^_]ÐU   WVS]ǅ       S(ֿ$<   1tօ   jCPUP  P^ ƅ   &      uh    VW(  uEPVd u^jh5SURBt& +<
    tֿn5
    uEPCPUR[[^_]ÐUUEPP  @,@PR]ÐU@  WVSUP  @,X  t& s(5<      ho8S Pa   h=<S PEP `  hB<S PURY :  hG<Sy PEP   hN<SV uO= t
	9t#jh`<j  	P    j PUR      jCPUP  P6\ tlƅ   8 tM &    h    VPS&  VSQ  hZ9S@ 8 ujW e1[5   [^_]Ív UWVS}]uE    jGPUP  Pa[ E } f  uv ; uEPSV%  u}  Ur(o8    	  ho8R} ƃuL= t
	9t#jh<j L 	P7   V   jUBPUP  PsZ Et" u; ubEPSV$  uKV= t
	9t#jh<j  	POURUH= t
	9t#jh@=j F 	P؍e[^_]ÐUWVS]hg=S|  t&h    Ph h=[   v s(g=    uoho8S{ P% tQjCPUP  PX Et/ u= uh    hV#  u݋[r1= te[^_]UVSu0P   t]t& 0P  C0P  CP P C P CPw  Sk 0P   ue[^]ÉUWVSE<P     v U<P  G<P   2  t& wFG~ tI^CFP
 S
  ~ u ^CFP
 S
  ~ uڃ~ t=VBFR
 ~ u ^CFP
 Sz
  ~ uڃ~ tZv ^CFPT
 SK
  ~ u/^CFP,
 CP 
  S
 ~ uˋP 
 V	   P	 GP	  W	 E<P   |URULP  tPEP	 e[^_]ÉUWVS}WujGPh=WgP  @,pVWC  8P  EP_SVW8   ,P  t1FVW  tWƃt(WuEPj jj SVW%   W6ƃt(WuEPj jj SVW%   h=WkuW  WW   t   Ѝe[^_]ÐU  WVS}W\t$4P   tj W>PWX  _SU  tS  <P      p  4P   t^tj PW  [u^tfPv }MP=# t
	9#t#jh=j p #	##P[u^thPuv }MP=# t
	9#t#jh=j  #	##P謽[u4P   t^tj PW  [u^tYCPCPP=# t
	9#t#jh >j y #	##P$[uvi@AWPPh6h  P薣 0PS  tgPt }QP=# t
	9#t#jh=j 
 #	##PQWt$4P   tj WPWq  I  [^_]UWVS}]u P  t`h5
v h5P0P  ȅtBP  PCPV@ PV@ PCPPh@>W% 0jj Wq e[^_]Ív UL  WVSUǅ    DP  t@P  aUP- uSMAPAPȃPP6 E@   t@  PRo;  	  M <P    z   MDP   ubPP>? u%BPPQA x tR}@ EP  IH  PQzD u!PQE XtT{ u{ uj PRO (    CP!k PPQN  [uX          Pj P PRN  th  PF L P= $ t
	9$t#jh?j   $	$ $P躸[dYt%&    j PPM [u⋕Zt-t& CPCPCPPQQ [ u؋x   ?   󥤃S%x ƃ}J=$ t
	9$t#jh?j  $	$$Ph?V$ ƃ   PURVh?V  Yt t& Ph?V [uh?V۝ h  V Pb  V Ph?h  Q  PRj QS P$o  QR=$ t
	9$t#jh @j  $	$$P蹶y   ?   󥤃S[v ƃ}J=$ t
	9$t#jh?j H $	$$P3h?VZ ƃ   PURVhU@VO  YtPh?V. [uh_@V V  Phi@h  Q PRjQKR  Pym U&    R= $ t
	9$$t#jh@j   $	$$ $P
I  @=t th@h@jR'P Q9 EP tPR9 MQYW  ?   󥤃St ƃ}J=($ t
	9,$t#jh?j   ($	,$($Ph?V ǃ   j EPP^ RMQWU ~=h  PV^ ~WPjRB σV^ h  WЧ P] W螚  Qh Aj P-O R"k  MQ3W  ?   󥤃Sr ƃ}J=0$ t
	94$t#jh?j   0$	4$0$P}h?V褚 ǃ   j EPP=] RMQW ~=h  PV] ~WPjRԞ σVF] h  Wb P\ W0  QhAjPM Ri  	e P#e Ph Ah  Q  h?APRQ Q?2 SUPe P=8$ t
	9<$t#jhQAj  8$	<$8$P[^_]ÐUWVSu}1ۋLP  t/P4tVh    VÃtWS׉ƃ}HS=@$ t
	9D$t#jhnAj O @$	D$@$Pe[^_]ÉUVSu1  uVtjPV
  É؍e[^]ÐUVSu1v  uVtjPV	  É؍e[^]ÐUWVSEE   X      S(ֿ$<   1tօ  h5S^g    N<Ɖ׹       RS0g t<j PEP&	  E5} t9Ph5S5i y   =H$ t
	9L$t#jhAj  H$	L$H$P螮h9h5Sh  ƿ5    uE    j SUR} tQ} tVIt& n5
    uj SEP v ֿ+<
    ujSURZ[pe[^_]ÉU  SU    tMtE   t<    t3HP  P   PhAh   S  S# 	   ]ÉU\  WVSǅ_    ǅ_    1}t;r}tP}    ǅAǅAǅ      ǅAǅ    k  t& hA t,PhAh   SU    t& ǅA   hBD t-PhAh   S    v B   *B@CB@VB@lB@           hBhB貜 ÃtD VhBS謒 thBV    S茢 BGBGCG)CD    	1  Eƅ؟ Pt\EPRh8Ch  ؿSܑ  hBSߛ Ãt!Sh  ؟P
 Sܡ  U<P    v _I_  _xZ   E   ;  _ "   __P_PMQj_PV    ؟ t&h  ؟PoS U*o PuVh6h  S裐  GPRh6h  _S耐  }   jh>CU *  GP_RhTCh  ؏S5  h?SD ƃt{_QoPGuUBPMGuPGuYCPRh`CV諏  V諐 j S_PUR(_ǅ_      S=P$ t
	9T$t#jhCj  P$	T$P$  GuYCP_QhDh  ؏S,  SEP-  _ڋ
tt   t   uBB)ھ  )PGPS }u=_ڋtt   t
   uBB)ډ)Ph	D=t& _ڋ
tt   t   uBB)ډ)PhDS h?S` ƃ   }uhDV _PoRGuMAPGuUPh5}u-DPh@DV訍  V討 j S_QEP%U_  P  u$P  	(P  ~u}_cS=X$ t
	9\$t#jhCj  X$	\$X$Pl__9 _@_~_R_P} u(_ ~jj h@MQc  t   }u%_ ~j j hDEP5  t   __[^_]U0  WVSƅ  jEPQ uVh   SR ډtt   t
   uBB)ڸ  )Ph9S) uVhDh   Sً S e ǃ }!hDh  S讋 Sd ǃ   h?W5 Ã   UR PU P  t`h5h5PE0P  ȅtBPE  PRUBPPhDS 0h  S P"O Sɋ  } | EPhEh   SƊ t& h  R S jP PUR1   ƃWOO  P[ [^_]ÉUWVSu}E     Ã      V EtW EE    E    EPV_ } t$hE9 VhE$P虉  EP tEP j     hE _u+dtUR&    h'  b jVSD tEu
%   EE   Ee[^_]ÐUS]x	~h F$P Ph  E`$PxO SN  }"  P PSh"F$Po ]]Ux~-HxE`$PN }
h7F踈 ]ÐUWVS]uj ǃS V GG=e[^_]US= tBX P @P  P u]]Ív UWVS}1tZPW u>tCFCP CPv  Sj    ދ[u1e[^_]ÉUVSutCPV"[ue[^]Ív U= ]UUM    Bt<}u]UWVSUE    E    u
E  1  À; t@	C; t
DB uu   t& u} t]E    }    ;$   {{   EP{WG}    } tUR( jEPk EE)؃PWEP  h`FUR EP  uh`Fj  t	UBUÊCFu} t
t
t+E;E} tEPx ;uv@		v N;uvFDB u UEtzt8"t+B8"t&B8"t!Btt   t
   uBB+UЍe[^_]U0  WVSu]ǅ    } tj/S{ t@PEPhbFEP裄 = tURu1  t& t SVhbFh   SA  S Sl ރVEP*.     h   SVZU |C URSEPj,  }  {  h ejdjdUREPU ]  v SEP=X t
	9\t#jhFj  X	\XP蜜	  hFVUR#  ƃu
   hFEPUR#  uVEPc*      <U4P  }  t'h eFPPUREPU ҃ t2Vh    WEP'  ÃtRSWEP(  9t}$ tBpU$PUR)  VEP)  [^_]Ív U<  WVS}ǅ    WhFh   V Sj jV     u[V P uBWEPhbFh  V躁  VEPj   h  VEP+   Qv 1;sD    EPEPj EPEPPEP    tC;rP#' IW=` t
	9dt#jhFj u `	d`P [^_]ÐUl  WVS]}u ǅ    PSjC?    %   = @  uVEPURWSEP/JS$tVURh eWSUR  j VEP PWSEPURKtWO&    S=h t
	9lt#jhFj U h	lhP [^_]ÐU<0  WVSǅ      }   EPUR裣u1  URPhbFVr V= Sj jW= uX1;s=E$PU REPVURPEP1 tC;rÃR$ HW=p t
	9tt#jh Gj # p	tpPΗ   EPiSj jWl  uY1;s>U$RE PURj EPPUR_ tC;rP# HW=x t
	9|t#jhFj Q x	|xP(} t#h     WEP[^_]U   WVS}uǅ    t WVh4Gh   SE}  WhKGh   S)} jSB uhSh_Gh   S| S  uAt	WVhuG	WhGEP| jEP=B u
ǅ    u
WEP [^_]ÐUP  WVShGEPM ǅ    thGP| ǅ    hGURM thGS3 uEP  hGUR\M thGS uEP  hGURM hG]SM ǅ    ǅ     |  v    ǅ    h  URSa h   Vh eK  eȉʃtzt8"t+B8"t&B8"t!Btt   t
   uBB)ʸ   )PhGQ  t h  SS +VPRhGh  SXz      j/S ƃ    tt   t
   uBB)ڻ  )PhGP tt   t   u@@))SSR /}   EPUR荝ƃu1  􍝨SVhbFh  S8y } WSj7 uCV|PRP]SjPR|SVEP   C  RPVhGh  Sx  WSj>7 ug􍕨RPhGh  Svx  V|RSP]SjPR|SVEPF      R= t
	9t#jhFj o 	PS= t
	9t#jhFj  	PI  P= t
	9t#jhFj  	PvR= t
	9t#jhFj z 	P襐4  ]SPjs5 uLj |RS4PEPjRS|Pj UR   &     :  􍅨PRhGh  PLv  SRj4 uSj |SPPURjSP|Rj ]S0,  P= t
	9t#jhFj  	PǎR= t
	9t#jhFj  	P  S= t
	9t#jhFj x 	P#P= t
	9t#jhFj ' 	PR   t& jVhG0    EPW xtt   t   uBBt)   v 1:tBAtt   t   u@@)9vȃhGP$ ƅ RS  u
    hGEP
E h  SEP   U    t@t<V  PhbFh  S/s  SSEP  hGURD PhH]SoD PhHS]D PhHSKD PhHS9D PVP|PEP@} t#h  VEP"X[^_]Ív UVSu]= uYtYh ej j = t
	9t#jhHj ~ 	PVӃ u1jEPVee[^]U,   WVSEp($H    uSj@PUP  P}  h   SP SP|Eǅ    @  t& h+HURB h0HEPB  h8HUR~B    1ۃuEPڣtUh@HEP;B tP論ǃ u
Ueh   VP /t6VEPhbFh   SHp  SV{     u
ǅEH  hGEP~A PURl   hGEPUA PUR   hGHEP,A PUR> g  ENH   P(1tօ   jUB@PUP  P: h   h eP{E PURSPRPjUBPUP  P PEP6RTH    uWURPPjUBPUP  P PEPUR t_W&    ֿ[H    u=EPPjUBPUP  P, PEPUR E@E[^_]U  WVSǅ    } R  E$H   P(1tօE  hbHUR4? ƃ  G      hjHEP? Ãt]UR贠t5j ShrHPP>  huHm       hH蛆p  h+HEP> uU$h   SPEPPUREPtUREPUBPEP      H
    u UREPUBPEPK  ֿH
      hHUR= ƃuJ= t
	9t#jhHj d 	POhIEPC= ÃuJ= t
	9t#jh Ij   	PhGUR< PEPʑ    hGUR< PEPm twhGHUR< PEP蠒 tRhJIURl< PSVEPUREPUBPEP tURU[^_]Ív Ul@  WVSEǅ    g  PEPz   1q  VUP  PP  PPhRIh    Sj } WSj( t;VUP  PPhGh    Si  WSj_( u	U}    h    VEPD   VUP  PP  PhGh    SRi } WSj' t4VUP  PhGh    Si  WSj' u	E} t#h    VEP&V[^_]U<   WVSE1+  PEP辌u
1          t& SURPhbIh  WQh  Sj jW=    1;s`P֑tPEP  PUR  tC;rP
 t& 1} 
  h   SEP       SURhbFh  WXg  Sj jWD u}1;sav PސtPEP  PUR  tC;rP } t#h   SEP'[^_]UVSu]h@HS7 t5P\t%jCPP  P( PhEHj Vr1e[^]ÐUWVS]E   E    hkIS|7 ƃ   j j
j V Utzt8&t+F8&t&F8&t!Ftt   t
   uFFF+w!$I
UhU^UV  wNC(P= t
	9t#jhIj  	PU~h@HS6 tPE} i  [^  h0HSR6 Eh8HSA6 E uEP觗tUU} uEEH}    hGS5 PEP    hGS5 PUR舋    hGHS5 PEP躋    C(ƿNH    u-jCPUP  P PEPUREP=ƿTH    u/jCPUP  P PEPURE [Ee[^_]ÉUWVSE    }   E$H   X(1tڅughbHUR4 ƃU  G    @  EPURUEBPEPjE   v ֿH
    uUBPEP6   t& ֿH
       hGUR3 PEP    hGUR3 PEP膉 twhGHUR3 PEP蹉 tRUBPEP7޿TJ    t޿[J    uUREPBEURUYEe[^_]ÉUWVS]E    t4s(TH    uECPEPE[űEe[^_]ÐU  WVS}Eh  P SY E  t&v >/u h  SW1  /F> uݍ[^_]U  WVS}h  EP S E  t&v >/u h  SW
  /F> u݋EPEPW
  [^_]Ív UdSjt ÃuR= t
	9t#jhdJj x 	P#y1M&    jtS ECECECE CEPEPjF uEԉC؋]]Ív UlWVSjt9 ÃuF= t
	9t#jhdJj  	S  jtS# EP u[SEPV  = t
	9t#jhdJj A 	  t& E C<r  hrJEPb CuZSEP  EP= t
	9t#jhuJj  	P  PjjuVMc    `J       jjCPm CPm CC Pm CCCPpm CCC PUm 	CCPc^ C     hrJEPJ C5CP(n CPHk E PRj EԃC{ uf{ u`{ uZSEPd  EP=  t
	9t#jhJj K  	    Cp      v EPEP`EP= t
	9t#jhJj  	P
uhJEPa` C ugC    SEP{  EP= t
	9t#jhJj b 	P
u1'j EP|PEP+CpCP ؍e[^_]UVSuUM1ۀzru-BtPQjV` _BtVQVPK G= t
	9t#jhJj  	PKt؍e[^]U   WVS}]u)Åt$V=    ~    P PW-u֍[^_]ÐUS]{rux.    t$CuVC   jjPO    CtP(j v CtPL uVjjPbi G=  t
	9$t#jhJj v  	$ P!s]]ÉUWVSu]U1{w   CtPRjV` CtRVPK ǃLP=( t
	9,t#jh
Kj  (	,(Pr_{WVCP! Lt& =0 t
	94t#jhKj v 0	40P!re[^_]ÐUM   QtRjf y t
j $O ]US]  CtdPfY    {w   P=8 t
	9<t#jh
Kj 贿 8	<8aCtcPCO tS{wuMP=@ t
	9Dt#jh
Kj Q @	D@Pp{p t*CP  SpC,BC0BC4BC8BP讹 S襹 ]1]UlWVS}]WS=H t
	9Lt#jh@Kj 詾 H	LHPoSEPE PSj u{E%   =   ulSn( }\  P PS=P t
	9Tt#jhKj  P	TPPo SW' ƃ}[}  PQ PS=X t
	9\t#jhKj 蜽 X	\XPGoWS|PEPle[^_]UhUEPRj uE%   =   u   1]U`VS]1EPSj< uE%   = @     S=` t
	9dt#jhKj Ǽ `	d`PmEPS} ƃ }d?  tkP PS=h t
	9lt#jhKj S h	lhPmt& S|PEP=e[^]ÉUWVS}]S=p t
	9tt#jhKj ֻ p	tpPmSWE PS ƃ}fA  tlP
 PS=x t
	9|t#jhKj U x	|xP m    hKS|PWe[^_]ÉUWVS}]S= t
	9t#jhKj ֺ 	PlSWEUEU EPEPSjP ƃ}g2  tmP PS= t
	9t#jhKj F 	Pk&    hKS|PWe[^_]ÉUVSuEPV Ã}Y脠  PX PV= t
	9t#jh Lj 裹 	PNk؍e[^]Ív Ul  WVSEPEPj   E%   = @     EP+ ǃtb1:x.t4PEPhDLh  SQ  SEPotƃW uWE [  EP= t
	9t#jhJLj 蒸 	Pi  =   u	u   hrJEPT Ã   SjjVU uj`J    uYjjS_ SR`  S>` 	S-` 	 S` 	ƃuԃS#Q LEP= t
	9t#jhJLj 肷 	Ph[^_]ÉUhUEPRjl ]UlWVSEE    P Ɖtzt8#t+C8#t&C8#t!Ctt   t
   uCC}WVj
 u,E%   = @  ujV u"E    j/V ÃuV( Ee[^_]ÐUl  WVSǅ    h`L Ã 
 /  ƅ  j:S1 ƅu?؉ރtzt8&t+F8&t&F8&t!Ftt   t
   uFF;~u9heLd theLP jLPW_ CC9v#)PSW5 hlLWD hnLW3 EPW&  jWH u1PWjO u%   =   u^> [^_]ÐU@  WVS|8N!   ǅxhNZ |hN< ƃu:11G
w'|;|uD+Ptԋt+t!MQQVSL S~ xxX[^_]ÐUtP\w{hdEPu UjjB dtP҃Pj ]Ív Uj]UEhQP= t
	9t#jhNj ; 	PK ]ÉU$  WVSǅ    ǅQ   ǅ    ƅ  ƅ  jQ hQj肙  hQhQ
 hQp  p       $TPP   PP6K j P[     L  Pttj j
j P7 ƃ)  = t
	9t#jh Rj ϱ 	P$PJ       1   h@RJ j ! h  PPP6 l      t& h  PPW p   ]POja áPP CUPkj u t& hQEPUR /vu$PtVaPWRPM ueR= t
	9t#jhpRj 4 	P$PuH j &    1^ޅthdЃt uW= t
	9t#jhRj 詯 	P$PG j 1ۃhLj hLj  hLj 1 t  C
w$0UP迅ƃ= PEPURPdЉÃu   P>{t` tW ej= t
	9t#jhRj 蕮 	Pл'@P   taPxztQ ej= t
	9t#jhRj   	P  Pxh  P5~R ej= t
	9t#jh@Sj 衭 	P   @P      DP      PxP= t
	9t#jhSj 0 	Ph    SE  jS eл	   @P= t
	9t#jh Tj ¬ 	Ph    S)E jS eл	    :Pw   PH~uJ= t
	9t#jh@Tj ' 	P^P}PBPPR P4fPRvh u 	   l~PePeu
7*ËPPuMP= t
	9t#jhTj ( 	P\[u   &    Pd   Pd       Pd~   PdlPgdPP軛á P耬Pe PePI        etP҃ǅ   CP舤 S  = u҃W1[^_]ÐUVSEu]PhdUA gUt> tPhhUA  PD  PEPS,E tXډ؃tzt80t-@80t(@80t#@tt   t   u@@@ ; ut
VS譮 e[^]ÐU   VS]Eƅ  t	ta     
  h     Pƃ=  t
	9t#jhoUj e  	 Lh     Pƃ= t
	9t#jhsUj  	PSY   S= t
	9t#jhwUj ŧ 	P @ PO       S= t
	9t#jhUj b 	P$P? ]jjPj ! PV' u   .jjPj  PV t1[^]Ív U   VS]Eƅ  tW   h     Pƃ=0 t
	94t#jhUj r 0	40Lh     Pƃ=8 t
	9<t#jhUj $ 8	<8PSfYS=@ t
	9Dt#jhUj ե @	D@P$P> }   jjPj 葥 PV藶 u   NjjPj b PVh u1"jhUVM t	   [^]Ív UEPhU}= j =X t
	9\t#jhUj ֤ X	\XP]ÐU@  WVSǅ   hUEP PUgUR~c tJhUEPn PUR%d t%hUEPI PURXd u
   	  E@P     P{   } tURU@P  Pk  U@P  PG  Ã   j j EPUR膏PS      E@E  v UU   B( uj REPUR@ƿU
    u+EXt& [tjSUREPeuURUuK  hVEP S  h     PUREP討P=` t
	9dt#jh Vj 蠢 `	d`P:            h     PUREP7P=h t
	9lt#jh@Vj / h	lhPh     S:  hLVUR t ƿTV   1t   t1EPUR蝏ǃtVSt& VSƃt   I  t& j hTVEPURTEPURU8P  E @Et~v UU   B( uj REPURS@ƿU
    u+EXt& [tjSUREPuURUu}    ǅ       tWhUB=p t
	9tt#jhYVj c p	tpP8 EPUREPURzjhlVEPUR[^_]ÐUVS]DP   t`SjPCP=x t
	9|t#jhVj 踟 x	|xP8  T    CP= t
	9t#jhVj b 	P7 hV7 P  PP  P= t
	9t#jh Wj  	PU7 = t
	9t#jh@Wj 谞 	P7 hV6  Sp   t   P  @,@PSo8P  e[^]ÉU  S]j	 SapPhh|Wh    S6 @SE j= t
	9t#jhWj Ɲ 	P	   u   Љ]ÉU  WVS}W@qƃ   V= t
	9t#jhWj ? 	Ph    S5 jS; u(Vhh|Wh   Sz5  S. Wiu   &       [^_]ÉU  WVSǅ    = tMEPyi
  UP  @,@PRI
  E,P  
      URh =  Uǅ   P  @,@RfPhU_4      &    p(U    uzj j PUR腇PPhW4  hLVR ƃt1TV    u PhWh  R3 @Uh  RR= t
	9t#jh Xj  	P4`   <qR  <QJ  j j
j PѾ Ã   ;   UP  @,@ǅ     p(U    u69uj hTVt& j hlVPUR@u?   -      Ut& =l uhh  PR= t
	9t#jh@Xj 荙 	Put  P= t
	9t#jhcXj . 	P1 RPȞ REP薀RPTL j R }J u
Bt0j/P tj/RΡ @ P(ucR= t
	9t#jh~Xj   	P{0 =l -  ƅ  =p    EPd]  <  URdtSj= t
	9t#jhXj s 	Pt1]     h  PS= t
	9t#jh Yj  	PJumuE  PÃ= t
	9t#jh<Yj 詖 	P/ SRI PUR7~PS uO= t
	9t#jh`Yj  	Pz. 4  U   tojS }]S= t
	9t#jh~Xj 豕 	P. =p   Eǀ8P      P  @,@  U   P(1tօuj Rj EPr  U
    u.Zm  jSj EP:[uP  ֿY
    9  hUR PEPS 
  hUR PEPOT    hURi PEP{T    hYR@ t_hYP" P= t
	9t#jhYj  	PE,  Zt.j ShYP PUR[uҋ@URd`u{UP  @,@PR8t[j= t
	9t#jh Zj  	P,u
E,P  R=  t
	9t#jh-Zj 蹒  	 P+ U8P  @PPGP= t
	9t#jh@Zj N 	P* hV*  j= t
	9t#jhkZj  	Pu
ǅ       [^_]Ív U,WVS}u]Sh tah   Sh: S= t
	9t#jh}Zj < 	P) tXtTEP1҉EUmEUmZ}fUf fUm]EmPhZ&    EPhZ') 9u Pj
x9  P+    e[^_]UhV( =  t
	9$t#jhZj 8  	$ P( ]Ív UVSuhVt( =( t
	9,t#jhZj Ϗ (	,(P*( 	                 j=0 t
	94t#jhZj d 0	40Pwu_   e uQ=8 t
	9<t#jh [j 
 8	<8Pt	   ؍e[^]ÐU   SEP~]ÃP=@ t
	9Dt#jh[j 膎 @	D@PtgtcS=H t
	9Lt#jh[j ( H	LHPh     S& jS$      ]ÉUWVS]STXP=P t
	9Tt#jh@\j 蜍 P	TPP%  SetPhUC=X t
	9\t#jh`\j 6 X	\XP% j StfƿTV    tQj=` t
	9dt#jh\j 辌 `	d`Puh@S词   e[^_]US]j uT=h t
	9lt#jh\j 7 h	lhP$Px$ 1   h]谭 tHуtzt8(t-@8(t(@8(t#@tt   t   u@@)=  v	]Rhl 3C4C5Ct6C|ACBC P*C$DEC(CCLDC    C,    C0       ]]ÉU1]ÐUU   : tB<
uA    ȉ]ÉU=|  y  ]US]} Pj2SPSh ]菞  ]]U   VSuDP   t*V=UPFPh(]h    h" 0FPh=]h    h" 4f   Pf    Tf(P  P$P  P P   PP  PP  Ph`]h     St"  jj2jShhU  P  @, @PV˾8P  V[u   
t&    [^]Ív UEjjP[Ph]h  [jh]`t   ]Ív U  VSuV\Ã   0  щЃtzt8(t-@8(t(@8(t#@tt   t   u@@)Ѝ\Sh]h    S/! jS ujjVK\Ph^h  VUu      [^]ÐU!  WVSEǅ|    ǅx     @t lhdt   h^tP tp^   B(    M@P   tnQ}_u^} tEPU@P  P  t& M@P  P޽  Ãt!j j tPURsPS   tx|Ǆ ^AA|j j REPrP + ||(  ƿ(^
       tx|Ǆ ^AA|j j REPNrPe + |Ǆ !^tB|QEPt| B|   &    ƿ2^
       tx|Ǆ <^A|hF^R | BB|p t$p^   !^1tt$^ltPUR7s|lA|xtItt
x)UBPhK^h    hQ dP} PlRxQQqgfff)RxPh`^hR  @t1  x   x1ۉ|^   B( uUd< t6j h^RUR,lPMQ茶U 8P     j h^RMQkqƿ(^
    ud< t
jRUR@t& p(2^
    u-d< t!jPhF^P PMQC|   H[^_]Ív Ul0  WVSǅ    =   DEPO   UP  @,XEt|v s(^    uXj j SURnh^S ƃ t^    u
Xf[uPRR
qgfff)RPh^h^}:     +  Uǅ    =l uEj Rj2j
h^h_.   |h  h`fS薊 t& PSz ߃WURLiPW5 j W }8uGt$j/W贊 tj/W袊 @ W   Wh_h    R jtt   t   u@@+Pj
Ph2_`L  0{=l   iv ƅ =p    URxM]     EP|Mtjh`_^t1]  tT.j Sj2j
h_h_,   h  h`fW迈 ]  SW誅 WURgPSG u jj(j
h `h`8K     U   tdjS }RSh_h    P jj2j
Rh`J  0=p    t& Eǀ8P      j P  @,Pj URǅ   EPKuAUP  @,@PR袵t!jh`u
E,P   s=URkKu*UP  @,@PR?t
E,P  Xf    ;j 
qgfff)Rj
^     [^_]U,  WVSu}]She th   Sh苆       1҉߭߭`ٽff
 f٭۝٭Sh`h   S VSh`膎  jdEPh`q     [^_]Ív Ur  ]ÐUS]j j-jh ah%a]H   S]]ÉUWVS]SVƿ^    tjh@auh@Sw}   e[^_]UVS]	     2    t'    tjha%u   j j-jhahaG  e[^]Ív U<   WVS]}Pb   SlJǃtE$^E!^CPhK^h    V Pj EPjjqgfff)Rj	hbVE  @t@t,t(Whbh    V jV   
t&    [^_]ÉUS]Qm  taHCICICOC(UC<VC <HC$xVC(VC,,VCLWC    C0       1[]Ð$U<WVS^ u}ș)щșEPWEPUR>e[^_]ÉU   ]U   ]Ë$US UEPRZ]]Ë$U   WVS Etzt8"t+B8"t&B8"t!Btt   t
   uBB+UB0ǅ$    ǅ<    Hj@PΈ E \  Uǅ4    RjuVEP <j@PV4 tj@PV    U}24Rjh PUR蚵<hE |PxPtPpPlPhPdP`P\PXPTPPPLPAP P P/      jEAPVN    URjF PURݴ<FE dPxP`PDP\PXPTPPPLP@PPAP PY @҉lDAhEp҉t@UP  t    9T t*j{APj w P     T P P)EtPq 0xPJ UERP| APEPz EPxP0EPURx<x< j
AP0EP~   j<VEPURP%   = @  u4EPEPbP%  PEPURθ   =   u*膇u!P%  PEPEP貹  P%   = `  u;Ju2ptRPP%  `PEPURKt& P%   =    uBu9ptRPP%   PEPEP 2  P%   =   u
詆  P%   =   uk芆ubd@PH URdPWEP諱d<8 E PWUR賵WFo        t/EPWuEPdPURձ[  APEPE1P/8  d,  8<PWREP蟲(),4    |    1
DDDDDDDDD	D
DDD
DDƃ  ~U(4P  } t)URdP+,PEPEPU҃ tC, t:EP,=    v    PHREPǃ4 tg|t]9tYEPX  t    9\ t*jAPj yr X     \ X P$d8$PURP%  PEP  -&    EPdPUR聯d<j<PUREPxUREPuUREP莱Et	PKl $[^_]Ë$UVS uUAPRVRu	1t& EPEPEPRVfe[^]ÐU   ]U   ]Ë$UWVS }uVAP!VWX e[^_]Ð$U,"  WVSû uEPVAP!ǅ    BPVURp   i  t& p    PURBPh     W  PBVdP PV|P   y  	 <2g  t <0t  &    <5o    v t7 RTu!WPEPϬ  ǅ    BP R}Wǃ  r  wWPPUR蛭U4P  )} t,EPRP REPU҃ t1N~*Ph   REPh=   ]WUREP W        WPEP:      PWUR踥   v PWp  t    9t t*j0BPj m p     t p PWPh   R}WaNڋR}Wu<Ph    RW   PURڬ[^_]ÐU   ]U   ]Ë$USø UEPR]]Ð$U<D  WVSÃ Eǅ    P V r j/Vu t   PPPURpBPh    V  j VEP xt􍃘CPR}WCVh    P2  tt   t   u@@@   PURCP PUR: Իػu P2 \  R PEPCPh    Rk  tt   t   u@@@  CP PUR茣  PԻRػPh    R  tt   t   u@@@   P. REPE  Rh     WEPĦƃ~eRVWEPi9tCPU4P  } t%EPRPUREPU҃ PURXPURPUR
 PԻRػPh    R ܻ tt   t   u@@@   P [^_]ÐUWVSu}Fj EPV蚐 1ۃ;}j VNb C;|顬PURVc t
t& F    } tX   PEf=u@fPV螱 Fj Va  tFU8 tK PVa t FU@P)ЃPhJfV# PEPV艏 tFUBPtVH)RhJfVʰ tUBP(t  e[^_]ÉU   WVSEE    E    E    E    E    PAn  E1  EEPl  E uj   =<f t   PU RMQ m  P
Ѓ}   PjEP]SuV}We  E PEPSl  !jPEPEPURMQLe   EPEP}k  EPEPk  ]$E P9 EЃuh`fj  u}E    Nu9}   E      } ~tEhfE  P.v UЋ]
      E   9]   hfE =<f tE  Pu UMЅÃ]hfM VCD9=<f tЋ Pu UЅ] E9]suEu9~EԋEPl  ƋEPl  Ã VSEPEP$p  EăSV.   PPEPEPj j }W4f   Wm  EPWl  GE PEPURW]  EH
} tU:G})ʉJUD2PDPQEPMQ%p  E PPPEP]SWuVze  E11u 9  <fuuE   E   E   E   E EtE E tzt8*t-B8*t(B8*t#B
tt   t   uBB)9WE EtE E tzt81t-A81t(A81t#Att   t   uAA)υtEE     E E tzt8*t-B8*t(B8*t#B
tt   t   uBB)9at
EE E E tzt81t-A81t(A81t#Att   t   uAA)v U΃EEEEEEE9U\>9~jUE
f}f]f f]m]Mm9~6uEɉEE}fuf fum]Em9}؉)>)D0}E    9}  1ۉ~y   ~l~#jj UЋPE PMQ4 E} PuV}ЋP=<f t
E E PEP E} PURMЋP=<f t
E E PuV}ԃ E9}   &    } PEPUЋP=<f tEE v E PMQQU BPRuЍKP=<f t
E E P}WU PRuЍKP=<f t
E E P}WU PRuЍK$P=<f t
E E P}WEԃ 0E9EUR蛩 j PMQPEP]SuV(  E0E@PVEP} Pj }Wu  E Pj j EPj EPW<z   j
WZ } 
  UăR)  Ã   } tM9    E} t
][]}$uSU؋uU܃< jMQP=<f t
E 	] RPuV=   t& E؋UE܉E<   ME    9M}ȃ~,t@~#~
    E   ]u    C]EUЋM    @E9}2]uЋE    D    D    D    ]9|΋UM   ]E    9]  u؋]؍v4    E} ~tYE܃9EPj U؋MЋPE =<f tE PEPUԃ E   9U   t& M܃9MPEPE؋UEPE =<f tE PMQU C|B;UPRMU؋PU D2=<f t|PMQhEԃ  E9E_U  &    E   +M؉M   E   +M؉M  EE    E܍HE;M}p   u=L	}I<    <fE}  wU4L	L	ރ} tE E   ;4]A;M|}   u19ul   }L	E<f1Ut& }  wEL	4L	ރ} tE E   ;4A;M~} P  90~C;E
E   E} *  E     tj6-   +                   S  tJR  tl       [  th  t   U؉U]   E؋M@M)E   } t	E    x} WEԋu9~؉E[U܋EU+EHE9~GUB    }O}} u/} #&    E܋U@E9UE    } >  M9M} t];E} t
uvu} |E9ED  }   }~dj j U؋MЋP=<f t
E ]؋u [P}W* jW jW警  j W M؃jj U؋MЋP=<f t
E ]؋u [P}WE؃ E܉E8  U9U   }~kj EHPU؋MUDPB=<f t
E ] @PuV] jVO jV  j V6 E؃jEHPU؋}UԋDPB=<f tE 
t& U @PMQ]؃ ]܉]b  } }uuE    !&    }ԋEԋU)EMO}܍TU؋]؋uE    ]܉]9u  }؍4    Eԉ} ~tXE܃9EPj U؋MЋPE =<f tE P}W/Eԃ E   9E   v U܃9UPMQ}ЋEȋPE =<f tE PEPU B;UPR}U؍KPU D2=<f tPMQ}ԃ  E9}jEP螠 EE@PUREPM9MP]SuVHl  0Uj EPUMЋP=<f t
E ]u [PEPUU܃ jQ]ЋUʋP=<f tE 
t& u RPEPU RΟ MQW]SM}  Sa   $  }\
t7
	tPt~v        t!\&    E   EE@E   R=@f uuEPj EPURj EPMQ0p   EE   t& ]ăS^  }    uE    9u   ~Dtg~;~}ЋU(? 
E   ]uЋ}(< C]M]Ћu(< ǋE<AM9}ht& UMЋ](< ƃ4B< ǃ<U< U]Ћu(< ǋE<E9E|UЃRM Eȍh[^_]U<WVSEE   E   E    E    EPZ  qq  E؃WY   }   
q5˅tKUЃtzt80t-@80t(@80t#@tt   t   u@@+E~JUЃtzt80t-@80t(@80t#@tt   t   u@@+E   ,ft+
hn9|
   9   UЃtzt80t-@80t(@80t#@tt   t   u@@+E~JUЃtzt80t-@80t(@80t#@tt   t   u@@+E   t& ؅tt+hnPjEPEPWEPjjEPEPWUR^P   EPEPV  EPEPV  E PX  ƋEPY  Ã VSEPEP~\  E܃SVq   PPEPEPj j EPR  U܃ R[Y  EPURX  U܉BE PEPWR>J  EPU} tUSU+UUji}WjNVCS   PPWjVSEPQ   } u	`f URh`fU j
EP }  } tAUE    REPURw EPj EPURj EPEP+k  0} uU܃R  E}u[EPUREPh`f  t>EUPREPUREPPEPh`fUR  E    06E؃PURl  Ã|&E܃PjY  11  '      }  G}     }
   }	   }    }  tr&    }c  t/}  tR}a  t8}i  t
}o  o}o  E}c  uHEUE   fUE   fTU=@f DE
v E܃PTX  1} ~t& U܃R4X  e[^_]ÐUWVS]U}؉ރtzt8&t+F8&t&F8&t!Ftt   t
   uFF)E     +   tL  &    }      tJ
  t.j    tEJ     Q  EE  t&   H|  9r  @j  :`  GN9P  F)ʃ9}t0~~	DDADA9  t& DQDQDQD9~      Ntz92~2
9   F)ʃ9}t*~~DADADA9   DQDQDQD9~X     M   >@	Dx@t2  #N;
~DI;
t& \ E    E[^_]UWVSU} }$ t3}(   EPUREPs UR)   t& Eƃtzt8&t+F8&t&F8&t!Ftt   t
   uFF+uG)y1ۋE)ډUUBEPUREPr (  ؃t~}O}&9}U    PEPD CO9}	U    PEPC CO9}	U    PEPC CO   9}	U    PEPC C9}	U    PEPC C9}
U	t&     PEP]C C9}	U    PEP8C _EEPUREPFq URZ e[^_]UWVSu}Fj WV
q 1ۃ;}j VB C;|顼PWVp } tFU PV{B } t FU@P)ЃPhfV PWVbp  } t	FUBPtVH)RhfV蟑 } tUBPT  e[^_]ÐU   WVSE    E       =<f t   PE PZT  EEE    P O  Eă e  UĉERM  Euh   =<f t   PM Q]SM  
}   PjEP]SuVEPAF  U REPSUM  !jPEPEPMQ]S
F   EPEP;L  EPEPWL  uEu܃ 9~E܋EPN  ǋEPN  ƃ WVEPEPR  ẼVW
   PPEPEPj j EP*H  Ũ RN  MQ]SN  CE PEPEPS?  EH
} tUC])ʉJUD:PD3PQEPMQR  Eȡ PPPEP]SuVEPgG  E    E    1 ;}  5<fE   E   }}t	E EU ? tzt8*t-B8*t(B8*t#B
tt   t   uBB)9U]t	E EM  tzt81t-A81t(A81t#Att   t   uAA)v MԉMԅtE E	U C tzt8*t-B8*t(B8*t#B
tt   t   uBB)9U\tE E	M C tzt81t-A81t(A81t#Att   t   uAA)MЉMЃEEEEG;}bUЃU9~oEE
f}f]f f]m]Mm9M~5EɉUEM}fuf fum]Um9}U؋UԉE)U+E+EԉMԍD]9]|
uF)މuK]E1E܉E;}  uUR    E} ~{   ~n~7;}Pj E =<f tE PMQz   ;}PWE =<f tE PEPDG;}PWE =<f tE PURG;}   ;}PWE =<f tE PMQG;ERPU KD2=<f tPMQG;ERPU KD2=<f tPMQsG;ERPU K$D2=<f tPMQA 0;}-]ȃS jPuVPEPEPUR
  E0E@PMQE@P9uP]SuV@W  E Pj j EPj EPV_\   j
V} }	  ŨR  ME1MM;}/  Ã뀉]L	uvt]<fEE܃} ~
tV    }  wUMڋE} tE t
t& u Ƌ  ;   t   }  wEUMڋE} tE tu Ƌ  ;tat|G}  wUuMڋE} tE |u Ƌ  ;ttG;}_ME    A;M"  E耉EL	UIt<fE])ȨtK}  wu]U} tE t	v u ΋  ;  t   }  wEU]L	} t
E tu ΋  ;n  tpA}  wUu]L	} tpE u ΋  ;  tA;MY}   E19E   UꀉUL	]<f1Et& }  wU]x    ]쉝xL	} tE 
t& ] ˋ  x;tnA;M~} k  }9}0~E;E	E   ǃ} A  E   }     Y}-   .}+      E   +}E   +}}     }        }S  tE}R  tj   t& }[  t}h  t   }   E}@)~t& } t
1p    } E܋u9~Nt& UEU+Ex9~73}O} u)} v }EGH9EqE    } Q  ;}U} tU} tMq|	;}     }~Uj j =<f t]u [	UM P]SvjSۉ  jSi j S  Mjj =<f tuU v   M]    ;}   }~aj GPMD=<f t] @u PEPjURB  jMQ͈ j ]S#  EjEHPuU܍D2=<f tM @] PuVxEUEEJU  }}E    M܋]IM+}܍\]uE1uuHE;}  uUR    E} ~{   ~n~7;}Pj E =<f tE PMQ   ;}PWE =<f tE PEPG;}PWE =<f tE PUR_G;}   ;}PWE =<f tE PMQ$G;ERPU KD2=<f tPMQG;ERPU KD2=<f tPMQG;ERPU K$D2=<f tPMQ 0;}-]ȃS
 EE@PuVE@PE9EPURMQN  0j EP=<f tUM Rv UM PEP}jREЃ=<f tM @U PMQEȃ P] VSUR_ M̃ Q 
}  3}     }
   }	   } t{}O  t6}a  tb}C  t6}c  t;}o  t2    ]̃SA  E   ũVA  z}o  E=@f uuEPj EPURj EPMQyR   #]̃SDA  } uEt& ũV$A  X[^_]ÐUUv @t;Pu]UEU]UVS]Mu U UUډS
E9~ș
v    u	5 [^]ÉUS= t"t& XP70 u]]Ív US]SuDj t4EBEBEEBZB]]Ív UMU@t;H|;H};|;P}]ÐU$S]    S!  =  u?EPZ t!EPEPt
@   
9 t]؉]ÐU,WVSEP;  ER  EEU1EUEEUUEPK:  1}u   P}PUREPUREP3  E PEPN9  EPEPj9  E P;  ƋEP;  Ã t/EPEPW' VSWp  P} VSEPEP
?  ǃSVPPEPEPj j W5  U0RW;  GEPEPEPW,   }    W;  j
jjEEPEP]E0Pj j URj E1PWbN   W| v WÃtA~# t:  u#  EUEU5
tt
   W| W<  1ue[^_]ÐUWVSE}]SW(  P͏ ƃuFtt-9    t,hf6  hf6  Wh gy6  e[^_]ÐUEjj Pj]ÉUVSuV ÃuVh g%6  ؍e[^]ÉUWVSu]E    CPESP(  P膎 0   :  U =Pf   =4f th@g5  =Pf   14  }0  9E  E}    
     ~GM<	utnE)Ӊ4  %<
uǆ4            ǆ4     EUM<	u&4  tn)EЙ})UM쉎4  <
u4  P4  4  EMU
<	u&4  tn)EЙ})UM쉎4  #<
u4  P4      4  ME9Ma  UM<	u&4  tn)EЙ})U]쉞4  <
u4  P4  4  MUD
<	u,4  
tn)ЙM)U]쉞4  #    <
u4  P4  4  MUD
<	u&4  
tn)ЙM)U]쉞4  <
u4  P4  4  MUD
<	u&4  
tn)ЙM)U]쉞4  $<
u4  P4  
&    4  ME9M8  94     @           =4f   14  }0  94           ~DE8
uǆ4        (U;xn~ǆ4        ǆ4     EEU<
u4  P4  +t& 4  );xn~B4  B4  EEU<
u4  P4  .&    4  );xn~B4  B4  E9M'  EU<
u4  P4  &4  );xn~
B4  B4  EU|
u4  P4  &4  );xn~
B4  B4  EU|
u4  P4  )4  );xn~B4  B4  EU|
u4  P4  &4  );xn~
B4  B4  E9M8  94  |   @   tǆ@      P  P& 4  8  @PP  4@   tǆ@      CPP  0  4  E    M1;0  )  EMAM	   =Pf    Utn)Й)Ѕ   ؃tH})}P  M AMJP  M AMJP  M AMJ   P  M P  D P  D P  D MuOt& 
u}/    =4f t!E);xn~P  M
AMGP  MAME;0  P  U 4  u
hg.  e[^_]ÉUWVS}=Pf u   EPEj U+0  PRH GPEWPU(  P貆  uhg-  1ۉ]19}A5tnU<	u+E)<
uC]t& CA9}} t9|ǉ˃j EPUR؍e[^_]UVS]1D  5  D$L  F        uƃ$     L  P  L  <
tHuS;,  }h (  SǃL      븃D   u
ǃD     C$    D   uL  e[^]USE]PSP2 ]]ÉUWVSuǆ<      D      L   usVË0  9     9}j j VB+0  jPV,   h (  Vj SVL   L  BL  P  |
thg+  1;}   L      V4Ë0  9~e   9}j j V+0  &    jPVr   h (  V0j SVL   t& ǆ<     4t& L  BL  P  |
FG;}<L  e[^_]ÉUWVSu}V<ʃtzt80t-@80t(@80t#@tt   t   u@@)ȋV 9}Aȉ˃tzt8#t+C8#t&C8#t!Ctt   t
   uCC
j EPFPyM j FP7  ډ؃tzt80t-@80t(@80t#@tt   t   u@@)؍W9}A؉ڃtzt8"t+B8"t&B8"t!Btt   t
   uBB)RSFP( VtB)ǉ   ؃t?}&}j R^ Kj FPL Kj FP: KtIj FP& j FP j FP j FP ue[^_]ÐUWVS]1H  1;}~  E} ~n   ~a~.EPj SH  D      !ƿ   URWSguH  D   t	u   GEPWS9uH  D   t	u   G;}   t& URWSuH  D   t	u   UGRPSuH  D   t	u   UGRPSuH  D   t	u   UGRPSnuH  D   t	u   ;}7CPl e[^_]ÐUWVS]}SơG,   t2jL  PSX+0  kd,  &    d   EPEPWI ShgWYk e[^_]Ív UWVSU4UE    E       = tjjVSEP$   PPjjVSUR#  UB FPSR2I jhgEP% UCF  t& u0EP 
  EuS}
uU: t1AWEPEPURtWj jVSPEPEPURZ10닍e[^_]ÐU  WVSuǅ    ǅ   jjEPEPVEP  E PEP%  EPEP%  ƅ  hT  Ss/ ǅ   ǅ   ǅ    =  j V| uVhgl$  jj Pjj j PQExn h (  PEP/'  ǋE P^'  WVEPEP*   VWGPFPEPEPPE+  0jj jEPEPj j { PPEPEPj j P}    PG'  EPP&  E Pj j Pj EPP9   Ph ǅ t ǅ t@PEPEPP  j
P      }jjPk jPk  j Pk EPEPP? Pg        jP~k jP	k  j PYk Eǅ    119   u,EPj PP?g  􍅨Pu t	u   EF9| EPEPP^EPEPPPPPP7D  PEf ǅ    ǅ    PËPSi9   u
   g{     B  W   
  y  j  t& 0  /  L  &    ?  7  K  'H  Gq    J'    N  L    t& b      D  Hli  j  x  h        X  nO    S  q    tG  R    R  h     [     3  E  '  ,     ǅ   􍅨Pwǃ;~*j j Ph (  P ǅ    ǅ     &    ǅ   􍅨Pǃ;}-jh Pdh (  P$ E  v  (  @PPlǅ   {     EM     ǅ    ǅǅ        ǅ    ǅ         w  0uǅ       H   =  D  @   v ǅ    /tnu
ǅ    t   
   ntNu uj]   EPEPPP'u7PPPǅ   u  􍅨P+ t	H@PPi tA&    VP    t4jPVPuo t̅ub j WP{h (  P; P	t& jPBǅ    1UP   P  P1s 1uh[^_]ÐUE f fj
@Px ]US]CtPޮ CP   f9u ft
9uS ]]ÐU   WVSE@P蝻 1    ]4    ׃<ǅx    x@'  ǅt    Pj j SBPa u<t&    tX[^_]ÐUWVS} ftF    3S-t!WEPSCЃuSuǸ   1e[^_]US]jtC@Pj Sp tCPtPS; S_^  諌 ]]UWVSuuE    = f tj
Vr v Vg% ǃ	tmtF      jtF@Pj V0p  	P~]         EPW   /     ft.ftÉfutsVAft0EPWSCЃu"Sf    uE   } e[^_]ÉUj 5 UVSu f,  x t P fu= f    P^\  P` $ PO *8 Ãt1P]8 8 ÅtG~%Sh
h$P $P  uV6 9uEP8 =0f uhj) hj) hj) Vjh  耿  = f u܍e[^]ÐUS=Tf @  Bjj R9 jTfPP TfщЃtzt8(t-@8(t(@8(t#@tt   t   u@@)Ћq1ۃ ht& j P\
 TfщЃtzt8(t-@8(t(@8(t#@tt   t   u@@)ЋqC)9|jjP#8 q1ۃ$&    dpPP	 qC9|ܡPNZ ]]Ív UWVSuEF1;]   &    j SV7 {}    ]؃t9}#}j V?	 Kj V0	 Kj V!	 Kt=j V	 j V	 j V j V uÉ;]WjtF@Pj Vk e[^_]ÉUPqPqPP]ÐUU$PR  ]US$P Pw  t$$Pƴ Pu Ã     P袴 Pw  t  P脴 Pu Ã uCPd Pvw  t PF PHu Ã u hS!  EEPSj ]]ÉUWVSE    nP Pv  ]   j S   P諳 Puk  |qh)hP@ nPh)hEP$ =ƃ %   PS tj P9 P k jS&|<h+hP车 $tPRj mJ u1   + p         twh-hP@ tbp$   tTh-h$  P t9hj p$  P hj p   P  jP觻 > U j j!2     = u	= t!   <f      e[^_]Ív UWVS     1ۿ$1(P7PCP" V(PPCP V(PPCP V$(PPCP V0(PPCP <T1ۿ,t& 4    K[< t    ˃~Սe[^_]Ív U= t)    j j 0   P` ]UUщЃtzt8(t-@8(t(@8(t#@tt   t   u@@)ЋU)Hy1]UWVSuE   ^1    N

     ;U   E}~Zta~Q~& u
{ tEމCB<
      ; u
{ tEމCB<
      ; uo`t& ; u
{ tEމCB<
tnt\< u
{ tEމCB<
tQt?< u
{ tEމCB<
t4t"< u
{ tEމCB<
tt;U|<
t< tu+Ev G79r|> u	O|> tEE8u;UuUރ}    ]9   )؃9}6tE~-~PECP PUCR PECO    PUR CPEP CPUR CPEPm 9rU:uE; u    C; t;
uC؍e[^_]UWVS]E}E      E   E} t	E   1h   E   ;
u39}G{ tF} tjVUR. C;
u"9|t& } tjVEP. ; t5EPURSEPÃ; tF} tjVUR. E;E}EE9	; T} tE0} tEUe[^_]US]MUEj j PRQS]]ÉU<WVStq&    qJUt=q&    =q}dnEuV]SREPURj GEEؙ}EEEɃ UEuQE4h}fUf fUm]}mVSWEPURj EEEE ]E  ;}  E)      ~B
   VSWUREPj vE}EE ]E]  VSWUREPj =E}EE ]E$  VSWUREPj E}EEE E   ;}   v GVSPUREPj E}EEEɃ UE   GVSPUREPj E}EE ]EunGVSPUREPj NE}EE ]Eu9VSWUREPj E}EE ]EUEUEe[^_]ÉU,WVSU},f   thn   t
lntCЉփtzt8&t+F8&t&F8&t!Ftt   t
   uFF)1E EU} uu	E ? uU = tqA)U
q)ȉE? 
  }    ]9}j
UR8    UЃtzt80t-@80t(@80t#@tt   t   u@@+Edn1҉EUm}fUf fUm]Em9}؃WURPI&    WEPUR{>= tCq)
t& q)؉ÃWURSEPURj  97}WEPVUREPj 7U9}} u} tUE} ~UE} ~Ee[^_]ÉUWVS]M}uUEPRVWQS= tq9;q~q= ttqP9q9~tHe[^_]Ív UWVSUu1ۅtGЉуtzt8!t+A8!t&A8!t!Att   t
   uAA)щME    h8hVk EuVh@h  E8tU:uHq= tH=,f t+lnMq= t=,f t+hnUM9 tzE8 trUR蜘   &    1{ 	u=Pf ttn)FUR= Ã
tMQ t;u~uEP tUCÃ= tqP9|q9}= t	HMUM]9}ً5tqP9|q9}t&    E9}؋MEP膗 e[^_]UWVS]E    tCEC    1;}  EPEPS% 1GE;u   EHEuuE Pp       EH9uuE Tp   v u;uuELpq9u;uuEHpZuE dpF9uEdp4uE p";uuEp&    E PS F;u%};}ECe[^_]UWVSu}X
 m  FEP]SV$ ]G}    ]؃ta}=}Vd %   PV;  KVd %   PV  KVd %   PV  KtrVdd %   PV  VId %   PV  V.d %   PV  Vd %   PV  uEKEEPSV# Vc %   PV[ 0Vc %   PV@ E C@9|VE e[^_]ÐUS]$Pj
赡 EP$SP( $ Pj
菡 EPs$ P"  P  jG v U=(f t  (f    ]ÉU=Df tEPEPhih fP轒 ]ÐUWVS}u=Lf teqq99~RSVWhh>t& 
t/B9C9~!ЅtP؅tHPVWhhe[^_]ÐUE=Pf t  j	P u]Ív USME]q= tJ=,f t+ln+~9~ []ÐUWVSEE1119   Ev Utzt81t-A81t(A81t#Att   t   uAA)9~΋UDtzt81t-A81t(A81t#Att   t   uAA)9~];]U7[^_]Ív UVS]ډ؃tzt80t-@80t(@80t#@tt   t   u@@)@Pl ƃSV e[^]ÉUE=,fuhn&= tqq)]UE=,fuln$= t	q@q)]ÉUS]Ut:CRh)iRt
C@v PIPj S1A ]]ÉUWVSutFx&    t	FXFj CPV ppPV  ]   _ ؃tG}-}dpPV _dpPV KdpPVn KtMdpPVY dpPVG dpPV5 dpPV# uFtpPV jEPV)     ؃t;}%}j V _j V Kj V Kt=j V j V j V} j Vo uÍe[^_]ÐUWVS= f t2jtB@Pj R!R P?  f1   3E9CuBCtP. CP u5ft& 7S} SStjB@Pj RQ CP=?  jStB@Pj RpQ CP?  ߉UPm e[^_]ÉUWVS}jjH ƃ= t7EPE@PWEP6 ÃtWEPj j SA ^EPEPWEP5 ÃuWEPEPEPh@i f^5fjS蠣 ؍e[^_]UWVSEu}WURVURP7 Ã uVEPWURhi+ jSA ؍e[^_]ÐUWVS]}=Xf t51; t.t& PXfP ut& F; u1e[^_]Ív US]=<f t]tY Bj qHPR PS  SqPhiP*< P= ]]ÐUS]U1<
t< t
AJ9u1[]UWVSuhiV. E>    &    ;	u } tX;\u${nu
F؀; u@8 t8
uWXR<
uH=4f t

<t& VW6u! < uVWuFCCF; n e[^_]ÐUS]t,CCHPCLPEPW S;  
j ]]ÐUS]S) t1&Sh   EP辌 Ãt	S؋]]Ív UUE    Ej j
PR Et8 t@	DP t|   1]U  WVS]UEMQPR   Y  v jhiV`   nPVL  ƅ  V;tj j
j V E V S    jhiV    tt   t
   uBB)tt   t   u@@)  w
VS nPP	T"VCtj j
j V EMQSEP1   nPV b  1[^_]Ív UWVS]u}P PP0P4Pj j PB0SPB0P4PVR PP0Pjj4PP j4PP B01ۃj P 0C9|B00P4PR WhiP6 
0ϺQ)(B    j4PR- 1ۃ;(})POU PP  C;(|סP	7 e[^_]Ív UVSu]
qq)ى
(),054QRSV	e[^]Ív UtP    ]ÐU,WVSEUUPE
  EEU11EUEEUUEPjjUREPUREPE0PEP EPEP<E P}EEPÃ tIEPEPW URSW'  P5 +&    W  EPSEPEPǃPPEPEPj j W WURWKGE PEPEPWEPj UREPj EPWR  0   W譵UƃRV  Ã 1  *  }Q
   	tA밃    tu렁  ty
a  t댁     x:t& } EEPj EPURj EPW   <  EWSE$EUEUW/e[^_]UWVS]uEtEt{VEPSu } t,CToPS! jhiSE  CjdpPS' VEPS } t-CXoPS jhiS  CjdpPS WEPS S2 e[^_]ÐUWVSu]}tzt8"t+B8"t&B8"t!Btt   t
   uBB)9}a)Љ)hiRhiV蠀 tzt8&t+F8&t&F8&t!Ftt   t
   uFFWShiVS e[^_]ÐUWVSu}]t
E	Ut
E	UEPURV tFjhiVX 1? u@<8 tUVUU   ؃t9}#}j V Kj V Kj V Kt=j V j V j V j V u1ۀ? t<@	;DPtEFUUEF;PVC C<; uċUVjhiVW E@PEPVE e[^_]Ív UU1ɋAuȉ]UWVSu}        E1ۃ8 tk} t
   QUtzt81t-A81t(A81t#Att   t   uAA);~EC< uЃ   )9}} u[^_]ÐUWVS]uSǍEPEPj S"EMxE)_șE_ș   UUE҉E\ؙËE1> ~e[^_]ÐUWVS   EE}uCEPWVSEP0 tq9~ËE;~e[^_]U,WVS}tGPtG
PEtEEtWUEPEPEPUR} tE,&    EPEPEPE PURlEE E@Pڶ U1ۃ:    UPEPVStzt80t-@80t(@80t#@tt   t   u@@)PjEPUR設019]t
u} }   PEPURVWD 9]u#EtEEtWU} tEU E9U!v EU E9UEC< 	UREPW
 W,  V e[^_]UWVSu]F=   wmtiE    W: tO
@	   DAt39t"Dqt+  w
L	v 9uEt& B: uEu[^_]ÉU88i<    ]UDDiH    ]UPPi   =@f uTi       ]ÉU\\i`id    ]ÐUSEj/P[ XhjS   ؋]]Ív USE]U8/uRPS     PE   Ph"jRS'y ؋]]ÉUWVS]u   VS t<VS| 9u.tt   t   u@@)D؍e[^_]ÉUWVSE1۾8 tmt& 1PU1ҍt& 8u-t*  w"t& FCAt  v	G~u  w FCE8 u  w [^_]UUEj@PP& ]Ív UUMA(    tB(uJ(
]ÉUhFj  uWj]U  SPLE  PhYjh   Sqw  h:j jS_	 u(=: t::    Pv 1]U:;:s :P:Y	&    1]ÉUWVSMu]}UE<*u*AFJU8JUKt1@	Pu}.uAFKt@	Pu9.t UtAGJtu [^_]ÐUWVS}]M~F7> t?@	DPt0&    CPI~րx tP@	DPu [^_]ÐUVS]j j
j P ơ@	DPtȍQP@	DPue[^]UL  WVSh    Ph   ]SEP] h    Ph   VEPmE1u 8   À    @	Pt
DBu   DB   DBt2EPÃEP 9tc       j VEPKj SEP6 SV tSV [E8.u@EE8.u@EuEÀ; tEƀ> 
E@	 DBtE DBu   [^_]ÉU,  WVSj/E1Px tURi ǃ   PA  PhYjh   Vs  hj jV ugt^1C9sLPPEP  uѡPhujh  V8s V ǃ u1  h@  έ 8ǂ@      h|jG,PiD ƃ j@VP hjG,P;D ƃt"h   VDP t& @D hjG,PC ƃh  V   S hjG,PC ƃth  V0  P^ fǂ0  . hjG,PyC ƃh  V  P E8/uh  P   P ,PShjh     Pq  hjG,PB ƍPPhjVq  u$ ~PRhj$Pp ǂ@      ǂ@      G,@      p(Ck
    ]  j$脫 Ph|jPB P BhMkPA P BhjPA ƃtV B
@    hUkR{A ƃ1t	>yBt@  B    B    @  B @  R
  ]k   B(   j Ph|jP@ P BB    BBPRE  j,肩 ÃCjP dk   P( uEhikP@ 1Q  P9  CBCBC BC$'  ֿmk
   1tu
     ֿwk    u
      ֿk    u
      ֿk    u
      v uBu
BuBu   &    ֿk    u`hk   R> ƃtCPV\ u	C    $PV= uC      S{hkP> ƃt>yu	C   C    hkPT> ƃtCPhkVl t& C  RPƃV CPSR   ƿk       j, ËC   hkP= ƃ tAPV uC    "t& PV uC   RPP CBC(Z@Rn[^_]Ív U,   WVS8  Phkh   S k h  Sb/  ډtt   t
   uBB)ڸ  )PhkS h  S/ ډtt   t
   uBB)ڸ  )PhkS ڋtt   t
   uBB)ڸ  )PPSo h  S~. EPhkh   Vj  h  VS. hk ǃ u
1X      ڋtt   t
   uBB)ڸ  )PhkS ڋtt   t
   uBB)ڸ  )PEPS ڋtt   t
   uBB)ڸ  )PhjSK tt   t
   uBB)  )PhkV tt   t
   uBB)  )PEPV tt   t
   uBB)  )PhjV S9 SV}9  }Shk$Pg EPhkh  Vh h  VM,  h@  詢 Ɖ>ǆ@     ǆ@      ǆ@      j hlj W G, j@EPFP EPh|jG,PL; } t3h   EPFDP EPhjG,P; FD j jhjh  S5g  ShjG,P: h  EP   PE EPhjG,P: h  EP  P fǆ0  . EPhjG,Pq: EPEPhjh     Pf [^_]ÐUVS]uh  V   P Vhj@,P: ǃ@     e[^]Ív UVS]uh  V0  PM Vhj@,P9 ǃ@     e[^]Ív UVS]uh  V  P Vhj@,Pf9 ǃ@     e[^]Ív UWVSE@   t PE   PI U@  U   EU@ EztMGEwt!^(FPI V@ ރ uߋGP+ W" } uUrt'    ^(FP V ރ uߋUBP UBP U BP EP UU "EP 1e[^_]ÉU  WVSE@       E       Xt:CPPhlh  Vc  Vc5 [(űptN^t@{u-CPPhlh  Wc  W5 [(uƋvu@ GE   P4 ]   Shkh  P&c  P4 }h@l`c Shkh  Pb P4  }hl#c Sg4 }hlc EPPO0  Phlh  Ptb  P3 EP1[^_]Ív UE]Ív UE]@  UU1tB ]ÐUE]@  UVSEu@  tVCP u	[ u1e[^]ÉUE]@Ív UE]@Ív UWVU@t/p( m    uPBPWt& @u1e^_]ÉUWVSUBǀ@     Xt2s( m    uS S   [u΃} tEP:Ph mj UPO e[^_]ÐUVSE1PR  S  ƃSI  Ãue[^]ÐUE]@Ív UVSu^@   t(j hUk@   P4 @  @    hmhUkP3 @  ǃ@     e[^]Ív UWVS}j hCkj @,P` ƃ   j$艚 ËE3{P' UCR CC    @   ESǇ@     Ph|jV*3 URhMkV3  { thmhUkV2 @  C    C    @  C @  t& 1e[^_]U  WVSUǅ    P ]P C P CP C P s   F^tm t& S({u2CPUB   Phlh  WN^  W/ CP[ SR  uFP9 V0  ]]st` &    ^(FPUB   Phlh  W]  W>/ FPʿ  V辿 ރu]C@  t;;Mu) tUB C EP@ @  I uŋUBǀ@     RQ [^_]UVSu]ShjP0 FP  tSQ FF    e[^]UVS]uVhMkPm0 CPɾ  V CCǀ@     e[^]UUBuB  ]Ív UE]@Ív UU1tB]ÐUVSEuXt&&    VCP u	[u1e[^]ÉUE]@Ív UlWVSE1P  Ãt8}S[  WPjH uuԃS  Ãủe[^_]UWVS}j h]kj P ƃu
1]    j ËE3{P CGCC    G_ǀ@     EPh|jV. ؍e[^_]Ív U  WVSuǅ    P P F Pּ ^ti C({u2CPF@   Phlh  WlZ  W+ CPy Sp  uFHt79u% tFBt& VFBIuʋF@ǀ@     V	 [^_]UE]@Ív UU1tB(]ÐUVSEuXt"CPV uv [(u1e[^]ÉUE]@Ív UUBv(h  hBPB@@Pt& B]ÐUE]@Ív U VSuEFPhmj]SX ShkP, F@e؋@ǀ@     [^]ÐUE]@Ív US]ECmtmRhkP9, C@@ǀ@     ]]Ív UE]@Ív UE@]@UE@@]@ÐUU1z uB]Ív U  WVSuǅ    ^tc Cwh  CPW
 h  WCPF@PM VFPCPRE[(u[^_]ÉUWVS} tnE@  tawtSt& ^t@Cv.CPEPEPP uv [(uvu u1e[^_]Ív U   WVS]h  VEPUB@PVEPVj }1"  j,P ǋEP GGjPo E%   =      G    tURgt& E8/ujxSP<URUBx@   Ph"jh  VU  jxSV!  EP-Phdkj UPB  ShikPr) S   GBGBG BG$   = @  u!EG   PPhmk   v =   uyEG   PPhwkj UP  h  xSVy& }Vh m$PT D   ShKm*  &    =   u0EG   PPhkj UP/     = `  u5EG   PPhkj UP  hPmP=    t    G   1   EG   PPhkj UP  hemhkP' EȋU%   PhVmj
]SS  ShYmP' EPhVmj
SS  Sh_mPu' EG    G  GPWUB@ǀ@     X[^_]Ív U<   WVSU]B  $m&    t3Sc  Shik}P&    UB8/ujSP9P}G @   Ph"jh  VR  jSVM  ShikUPZ& S  u¹   1t tjEP}GBGBG BG$UB   }G8/u*h   SPp# ǃ}qUBPNP}G@   Ph"jh  VQ  h   SV# ǃ}Vhjm$PqQ | ShKmUP>% }G@ǀ@     E[^_]Ív UWVS]}WC@PƃVS} tURPS7    C@PWtP  EPVSe[^_]ÐU   WVSh   SUBPB@@P>uFT  $mj  P &  jW R  hikuP!    j PWٿ    t& P Rj   hKmuPj!   h  S P! | RS裼 [     S  P Vj "  hkUP  	  Pm    u%   = `  uem    u%   =    \hYmUPd  t5j j
j VM 9h_mUP  tBj j
j V
 9t)t& j  P }   t& 1h[^_]ÐUVS]uP P(  9uC(R(t9Z(uC(B(CP S e[^]US]EPC@PPS u CPRSC@ǀ@     1]]ÉUSUt*Zt#CPRC@ǀ@     1]]UWVSu]j,Ǉ ǋEPQPhkj Pi 0ShMkP  EPhVmj
]SL  ShmPq  m} tmPhmPM  EwP GG   FG(F~e؋@ǀ@     1[^_]UEǀ@     ]Ív U  WVS}WE   Phlh   SK  hmS
P Ãu1   j,菆 ƃhmSK E PhmSK h  SY P  ShL WPhkj EP M0PhkR Eǀ@     W襸 MFF   N[^_]ÉUVSu]MUFPRQSPuB    FB(V1e[^]ÐUVSu]MFU@PRQSPkurFB(V1e[^]Ív UlWVS}]EEPSj    Eԃ@P ƃhmSGN Ã tXSjEPVAO SJ E0 G PVEPEPP tB    GB(WE    V Ee[^_]UlWVS}]EEPSj+    Eԃ@P/ ƃhmSM Ã tWSjEPV}N S$J E0 G @PVEPEPP tzGB(WE    V" Ee[^_]ÐU  WVS}Eǅ    P G   Phlh  SH  jS u*S }hmH ǅ   _tA&    EPCPP uGPSGǀ@     a[(uƋwtM^t?EPCP u!FPSGǀ@     t& [(uvu[^_]ÐU  SEu17v PE   Ph nh   S}G  S1    ]ÉUWVSE1Xt'U9SuCPUBPxǃ[(uًEpt>^t0v {u U9SuCPUBP7ǃ[(uӋvue[^_]UlWVSjh#nh*蓿 h* ǃ}
h;n   j EP
 ƃ|vEPVj7 EԃP ËEԃPSV8 Eԃ PSWW SV  V
 h  WD
  W
 *hCnSF 1e[^_]Ív U|   WVS  ǅ      PhHnh   SE h  S	  Y  Phbnh  SE h  S	  hkS走 h  VS胴 h  S	 hkS聰 h    PSJ h  SY	 hynSH j Sj
 A  Shnh   SD hmSN ƃ    􍅤PPPhnVD  VT EPǃ t	W
    EPhnh  SLD hmSON ƃtn􍅘PPPhnV;D  V;T 9|"u*9|u9}
ǅ   t,WG hnD 
ǅ      SEPj hnEP~G ǃ   hn P]G ƃthP} WPjSCH  VPjSPI S  h  VP P
 VC   Phn$PB WC t& EPhn$P]B hn ƃ  }   V  Phnh   PBB  h   P{ ho Pd h   PM VEPh oh   PA 0j PK tDVEPh`oh   PA  j P 
t&       P Pj hn PdE ǃ   V  Phoh   PA  hn P E ƃtLP{ WPjSF  VPjSG S  VA WA EPOƍ   Phoh   Pt@  hm P}D ÃtD􍆾   Pj jh pS@  h  S'N PN S@ v  Phr$P? 1x[^_]ÐUE #Eg@@ܺ@vT2@    @T    ]ÐU\WVSEu}HMX@E   3E#E3EExj׹   UEM1!1EčV   ȉЉE3E#E3EEȍp $   ]EM1!1E̍νȹ   ؉E3E#E3EEЍ|   UEM1!1Eԍ*ƇGȉЉE3E#E3EE؍F0   ]EM1!1E܍Fȹ   ؉E3E#E3EEؘi   UEM1!1E䍌DȉЉE3E#E3EE荜[   ]EM1!1E썌\ȹ   ؉E3E#E3EE"k   UEM1!1EqȉЉEЋ}3E#E3ECy   ]EM1!1E!Iȹ   ؉E1#E1Ečb%   UЋM3E!3EE؍@@ȹ	   ЉE1#E1E썜QZ^&   ]؋M3E!3EEǶȹ   ؉E1#E1Eԍ]/ֹ   UЋM3E!3EE荌SDȹ	   ЉE1#E1Eع   ]؋M3E!3EEЍȹ   ؉E1#E1E䍔!   UЋM3E!3E7Éȹ	   ЉE1#E1E̍
   ]؋M3E!3EEZEȹ   ؉E1#E1E㩹   UЋM3E!3EEȍȹ	   ЉE1#E1E܍og   ]؋M3E!3EEL*ȹ   ؉E13EEԍB9   UЋM3E1Eqȹ   ЉE13EE썜"am   ]؋M3E18ȹ   ؉E13EEčD꾤   UЋM3E1EЍKȹ   ЉE13EE܍`K   ]؋M3E1E荌pȹ   ؉E13EE~(   UЋM3E1E'ȹ   ЉE13EE̍0Թ   ]؋M3E1E؍ȹ   ؉E13EE䍔9ٹ   UЋM3E1Eȹ   ЉE13EE|   ]؋M3E1EȍeVĉȹ   ؉EEE1ED")   U؋M	3EE܍*Cȹ
   ЉEEE1#   ]ЋM	3EEԍ9   ȉ؉EEE1EY[e   U؋M	3EE̍ȹ
   ЉEEE1E荜}   ]ЋM	3EEč]ȉ؉EEE1EO~o   U؋M	3EE,ȹ
   ЉEEE1E؍C   ]ЋM	3EENȉ؉EEE1EЍ~S   U؋M	3EE썌5:ȹ
   ЉEEE1Eȍ*   ]ЋM	3EE䍌ӆȉ؋MAYEA[^_]Ív UWVSu}]~T@uFPVFT    F   VTtTt?N
GFTKtVT?~j j VtHWVJFT    F@?wޅtVT?N
GFTKtVT?~e[^_]ÐU,WVS]j j SC9ST։9sG9sGǃ7`CCTSTEumumum}m}m}mCE7   Ev  CTST7~CCTSTEumumum}m}m}mCE?E&     CTST?~j j Sj8UR胬 CLUSMECNUSOCPUSQECRUSSEPSCCUCBCBe[^_]ÉUWVS}11Ҿ ;92B9$2BA~Ƃ ;  ;[^_]UWVS}rfErE11ۍEE    ;EC;Ej jj ECP# !;F~Ը!;e[^_]ÐUl  WVS]} thrS  ƃt􍝨SI PSPh   SV$ uփ􍅨P/V*    hrS7 ƃuS4 􍝨S PSP Vh   jS8 u׃􍅨PV(4  WPEPl 1[^_]ÐUhr ur]Uh@;譾 @;]U  WVShrۻ ui1 F    ;tj P uߋ;t3Ph sh    Sl2 S# u#s
-s7s[^_]ÉU= u) P/ t@P| = u h=s u
Bs]ÉU  WVSE}hCsP5     E     tVh    P4 ʃtV9 tۋ@	DC tB: uÅt59 t0@	A9 t"DBt9 tWURhEsQe1 V1 [^_]U  WVSE1hCsP
5 ƃtC URP_ t   Vh   S4 u΃V1 [^_]ÉUVSu]j ht uSVht      v j h-t uSVh-t[      j h?t uSVh?t+      j hSta uSVhSt   ht& j hgt1 uSVhgt   8t& h~thtru1v SVht   e[^]ÐUSMh)ڃtjRht$P. j! Q)ڃl~jlRh u$P. ]]Ív UWVS]t{ tCtRu
Qv +PR ~)KK EPPZ 3FS 9t{CF)׉Sȍe[^_]UWVSut^tFtJu`)   9Av1Pz uz u: uz uz |ߋEPP ËAV 9t~FA)׉V؍e[^_]UVS]ts{ tmCtfRt_+=   ~PRa ~)CC Bx   w.h  R0 AS 9tsCA)։Se[^]Ív UVS]uC,9C(|: S,PC0P(s C0uh<u$P, 1v S(C04C(s$C(e[^]ÐUMA(12v PQ(~A0DA$A$    Q(A0    ȉ]ÐUVS]uC<9C8|7 S<PC@Ptr C@uh<u$P, 1S8C@4C8s4C8e[^]UMA812v PQ8~A@DA4A4    Q8A@    ȉ]ÐUVS]u   9   |@    P   Pq    uh<u$PH+ 1!      4         e[^]ÉUM   1BP   ~   D   ǁ                 ȉ]ÉUS]{(u1]t& S Pn   S$B 8 u#h   RJS{| tC|
C$@ ]]UEt
PEP&]ÉUS]thCtPZ CtPG S$tCt	P҃tP: j(jSZ S ]]Ív US]j(xd u-CT   tPXth`uCPCT   1E@    @    @    @    @   @        @$    @     @    ]]UVS]uu.CT   tPXthuCPCT      ~    H   $vCT      PX   hu\SFPFP    v    PX   FPh v CT   tsPXtlFPh`vCPXt& CT   tFPXt?FPhvCP+SOtFBFBFBFB1e[^]ÉUVSMut.QÃt>ssV9   C*    AT   tPXthvAP1e[^]Ív U  WVS1}    j EP2 ƃ   UB$t?@t8URPhwS>' j S
 ƃ tS! ǃuIU   t8URPhwS& j S
 ƃ tIS ǃt7uEP ǃURÃut	W計 1KEP C{3F CFU C    utWP  U   ؍[^_]UWVS]jh` ǃuh w$P% j` C0C(    C,   C$    C    C    CCX    C\    C     C`    Cx    C|    ǃ       j(6` C@C8    C<
   C4     j(`    ǃ       ǃ   
   ǃ       u
 ;    [C    C   Cd   Sh   [ltCp<CtCp    Ct    CCD    ǃ       ǃ       CT    CHP e[^_]US]   PSuPm Su䋃   tPG C@tP4 C0tP! CtP CtP t= tP    tP̅ S ]]ÐUSh   8^ ÃtSF(    h`w$P!# hw# 1]]Ív US]CHP: S]]ÉUVS]1C|tC|      C$P:&i  z#_  zxU     A  t& t/Wt& C$@ /~Dt9~9&    C$@ 9$t	t  C$@ t   t
`Uv C$@ `~Dtf~9&    C$@ f$t	t   C$@ t   t
@Sv C$@ @~BtF~7&    C$@ F"t	tFv C$@ t4CT   tPXthwCP҃C    1   {| tC|       S$B8 u h   RS:HS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
	  C$@8&uSr  K|t;t& C$@8;C|    C|t
&t  A8&  Ax#     AO      t/Ut& C$@ /~Bt9~7&    C$@ 9" ttEC$@ t4CT   tPXthwCP҃C    1   {| tC|       S$B8 u h   RSzHS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSM  C$@8&uS  C|t;v C$@8;C|t
;tOv C$@8;uAC$   @3&    CT   tPXth xCP҃C    F=  v)	t$
t
t  =  v
  = w,CT	   tPXtVh@xCPC    1e[^]UWVS}1҃}   M  Ɗ&   N#u~~xux;   C<	wÍTI&    C<wÍT/C<vGT   tvPXtohw\ÍTF;udt& &uc#u^pX;tPC<	wÍTP0GT   tPXthwGP҃G    1F;u;u+F(GT   t~PXtwh xGPgt& E0B=  v)	t$
t
t  =  v
  = w0t& GT	   tHXtRh@xGPG    1e[^_]ÉUWVS]1{| `  S$B8&Q  h   RS$B8 u!h   RSS|t
&t  v C$@8&   C$@x#   Cx@  $yCT
   N  PXC  hcx0  t& CT   !  PX  hsx  &    CT      PX   hx   &    CT
      PX   hx   &    SC|  Cx@   $$zCT   tpPXtihxYCT   tRPXtKhx;CT   t4PXt-hxCT   tPXth yCPC    b  tC|       S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uS  C$@8&uS2SH  ƃu5CT   tPXth)yCPC    C|&   `  V  C$@<;t;CT   tPXth`yCP҃C    C|&      V>     @Љ   V$  C$ PBPtPtVCP҉ǃuIV ǃu7CT   tPXtVhyCP҃C    Ht& ?u-CT   tPXtVhyCP҃C    ?uG C|Vz %t& WSPS\ Vy e[^_]ÉUWVS]1{|   C$@8%z  Cx@   $h{CT   u  PXj  h`zW  CT   L  PXA  htz.  &    CT     PX  hz   &    {` u
{(  {| tC|       S$B8 u#h   R]SKv S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSSG  ƃu5CT   tPXthzCPC      &    S|t
;t  C$@8;x  tC|       S$B8 u%h   R?SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uStP`tVCP҉ǃu_{t{X u+{\ u%   PX   Vhz   tPTtVhzCP҃Cd    lwWS8PS It& t7PXt0Vh {CT   tPXth@{CP҃C    V;v e[^_]ÐU,WVSEEE  EUUMME    PN Eu
h{U}z| tR|h{ 1  MA$@E9E    &5  MA$@x#uQQGEp  E  EP EN  Uz tdp> t>EFG+]9~MɉMQEPY E5뽋UBPJ  MLM  UBP,  MËEDIME&EG+u)؃9~6U҉URMQX E
UKBUG;Gb  %u[EtU}   MQ EP)Uz| [  B$@8 L  z(A  &    EGE+]9~'MɉMQEPW EߋUz| tB|       MQ$B8 u#h   REPxIMQ$B8
uBA$@   BUB$@   R$B8 uh   RMA$@8%uQGUB$@8&uRMy| tQ|UB$@M9Ms:Ut:Ut
:Ut( Ee[^_]ÉUWVSUUE  UEEEER"K Eu h{
h{ 1  E}  &'  x#u#EPEP  G  E   EPUR Ã  Ex tT[; q  ECG+u9~'U҉UREPU E8; u)  CP  [Ɖ]&EG+])9~;U҉UREP]U Et& UNBUG;G       %unEthEPEPi Ã   [; tECG+u9~'U҉UREPT EH; u<EG+]9~'U҉UREPT EEEt:Ut:Ut
:Ut Ee[^_]ÐUS]E@  $CT   tPXth{CPC    z  CT    g  PX\  h |%  &    CT    7  PX,  h`|  &    CT      PX  h|  &    CT      PX  h|  &    CT      PX  h }e  &    CT    w  PXl  h`}5  &    CT    G  PX<  h}  &    CT      PX  h}  &    CT      PX  h ~  &    CT      PX  h`~u  &    CT      PX|  h~E  &    CT    W  PXL  h~  &    CT    '  PX  h    &    CT       PX   h`   &    CT       PX   h   &    CT       PX   hXCT    tuPXtnh :CT    tWPXtPh`CT    t9PXt2hCP"CT    tPXthCPҋ]]ÐUWVS}} tC|?wVD ÃtWEPS  Vh`$P	 1e[^_]Ív UMʅu1(t& B<w<	t<
t<
t)RQa]ÐUWVS}ut-|)^SED uSh`$P@	 119}
:
B9| ȍe[^_]ÐUUЅu1: t@8 u)PRm]ÐUS]Muu1@9&    u   't& )ACu; t9 u)[]ÐUVS]Mu~&utB&    u   0t& 1')ACuN~; t9 u)[^]Ív UEUu	18t@8 u1]Ív UWVS]}t8t4W   ƃu 8uVWS2tC; u1e[^_]ÐUSEM]t,|(|$19}8 t@B9|8 tSPD1]]Ív UU1t: t
v B@: u]ÐUWVSu}    } x   uEPURdVEEEGWV3M Ã t&UURURP E t& Wh$P e[^_]USE]مt7uS(Aw	t
t
t)QSP]]Ív UVS]uM19}!t& 2< t<	t<
t<
   B9|St C4@(PR]J    tp    ugS|t
<u[    C$@8<uHK4tAy u"t<t
C$@8<uC$@x/tQ u
C4x4 t+1,P uC4@t
P uո   e[^]UVSu]Fu/CT   tPXtFPhCPC    BP~VSPStRDtPFPCPҍe[^]ÐU  WVS]1C|t@~8v C$@1 @~#S|t
Z1  C$@ Z  t	`~6C$@ `~$tz   t& C$@ z   t
   ~7C$@ =   ~%t
      C$@ =      t
   ~0C$@ =   ~t
   qC$@ =   ~at   ~3C$@ =   ~ t   4C$@ =   ~"t_ut& C$@8_t1    v C$@8  F{| tC|v C$@ :{| tC|       v S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2    h $P    v C$@8  {| tC|       S$B8 u$h   RSLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RPC$@8%uSC$@8&uSBS|t@/C$@ @~!tZC$@ Z	t`1C$@ `~#t
zC$@ zt
   6C$@ =   ~&t   C$@ =   t
   6C$@ =   ~&t   [C$@ =   Et
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.t-C$@8-t
_sC$@8_`I   L  S|t@/C$@ @~!tZC$@ Zt`2C$@ `~$tzv C$@ zt
   6C$@ =   ~&t   C$@ =   yt
   6C$@ =   ~&t   KC$@ =   5t
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.t-C$@8-pt
_cC$@8_P9   <VW#[^_]ÉUVS]u    SsC|t:t   C$@8:   {| tC|       S$B8 u"h   R
SJS$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2SЍe[^]ÐUVSMu    ;xu%{mu{lu{:uS.  t& B<v'B<v B@<vB(<vw
_t1   YCB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀt)PQ>;:   CB<vB<vB@<vB(<v
w_uVٍYCB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀt)SQȍe[^]ÉUS]1ɋC|txt;  &    C$@8x%  S$Bxm  xl  xn  xs      BC|t:t   &    C$@8:   {| tC|       S$B8 u$h   RS>Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
C$@8&uSrS]ȉ]Ív UWVS}E    Ed   jd(4 Eujdh8  v W|t
"t  G$@8"  | tG|       W$B8 u#h   RW
Kv W$B8
uBG$@   	    BG$@W$   B8 uh   RPG$@8%uWG$@8&uWBW|    &    uF;u|#EEPURf> Et  EUu| tG|           W$B8 u%h   RWMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R@G$@8%uWG$@8&uW2W|t_|G$@w	t

t
u	""    W$B8 u h   RWBW$B8
uBG$@   BG$@W$   B8 uh   R`G$@8%uWG$@8&U  WNG  t't8  G$@8''  | tG|       W$B8 u$h   RW>Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uW
G$@8&uWrW|    &    uF;u|#U҉UREP; E  UEu| tG|           W$B8 u%h   RW/Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   RpG$@8%uWG$@8&uWbW|t_|G$@w	t

t
u	't'u
=G$@8't2GT"   tPXtEPhmGPG       tG|       W$B8 u#h   RW{v W$B8
uEBG$@   9    UR&    EPhR$Pm 1^t& BG$@W$   B8 uh   RG$@8%uWG$@8&u	WEe[^_]ÐUWVS]11   &    C$@8
?  {| tC|       S$B8 u$h   R~SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSHS|t &C$@8 t	C$@8	t
C$@8
C|t
  C$@8
  &    C$@ =    t
 ~  C$@ = k  t
>u]  C$@8>N  t
nt  C$@8n  K$Axs     A   C$@8
<  {| tC|       S$B8 u!h   RS+IS$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t 9t& C$@8 #t
	C$@8	t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R躿S   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R^SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SF   C$@8
>  {| tC|       S$B8 u#h   R=SKv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S蝿{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
t  C$@8
`  &    tht  C$@8h  K$Axr  xe  xf     A   C$@8
<  {| tC|       S$B8 u!h   R˺S+IS$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t 9t& C$@8 #t
	C$@8	t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R躸S   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R^S辻Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S轺{| uC$@8 u{(݋C$@8%uSC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SF   C$@8
>  {| tC|       S$B8 u#h   R=S蝹Kv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S蝸{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
t  C$@8
`  &    tpt  C$@8p  K$Axr  xe  xf  xi  xx     A   C$@8
8  {| tC|       S$B8 u h   R跳SES$B8
uBC$@   v BC$@S$   B8 uh   R`C$@8%uSC$@8&uSRS|t =t& C$@8 't
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R誱S
   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   RNS讴Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S譳{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
S6   C$@8
>  {| tC|       S$B8 u#h   R-S荲Kv S$B8
uBC$@   	    BC$@S$   B8 uh   RЮC$@8%uS]C$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S荱{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
d  C$@8
P  &    tAt  C$@8A  K$AxS     A   C$@8
?  {| tC|       S$B8 u$h   RάS.Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t 6t& C$@8  t
	C$@8	 t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uS蘽S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R躪S   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R^S辭Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S转{| uC$@8 u{(݋C$@8%uSÿC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SF   C$@8
>  {| tC|       S$B8 u#h   R=S蝫Kv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSҹS|t 7t& C$@8 !t
	C$@8	t
C$@8

S蝪{| uC$@8 u{(݋C$@8%uS製C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
t  C$@8
`  &    t?tet& C$@8?uUS$Bx>uI{| u{8 u#h   RSx   S$B8
      &    1utPXthCP҃CT#   C    {| tC|       S$B8 u!h   R若SIS$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uS轻C$@8&uS"S|t4C$@ ~&t  tC$@ =  ^t	Q    C$@8	:t
-C$@8
t


C$@8
t
  9v C$@ =  ~&t  C$@ =  r  zt& @BS$B <w<	t<
t<
uB8>u܃{| tC|       S$B8 u h   R詣S	GS$B8
uBC$@   t& BC$@S$   B8 uh   RPC$@8%uSݹC$@8&uSBtV3 t	W3 e[^_]U  WVS]h   C$PآS$B18 u!h   R躢SS|t@~5C$@ @~$tZL  t& C$@ Z6  t
`~7v C$@ `~$tz  t& C$@ z   t
   ~7C$@ =   ~%t
      C$@ =      t
   ~3C$@ =   ~!t
      C$@ =   ~tt
   ~0C$@ =   ~t
   HC$@ =   ~8t_u-t& C$@8_tt:u
C$@8:t1  }   C$@>F  ~hh$P) C$HFB<vB<vB@<vB(<vwۍB<	vԀ.tπ-tʀ_tŀ:ttyv C$@B<oB<dB@<YB(<NEB<	:.1-(_:
VW0[^_]Ív U  WVSuh   F$PV$B18 u!h   RڟV:~| t	^|t& F$@Sv0C<v)C@<v"C(<vw_t:t1  t& ?  G~| tF|       v V$B8 u%h   R/V菢Mt& V$B8
uBF$@   	    BF$@V$   B8 uh   RОF$@8%uV]F$@8&uV°~| t^|F$@S  U  h $P    ~| tF|       V$B8 u h   R7V藡EV$B8
uBF$@   v BF$@V$   B8 uh   RF$@8%uVmF$@8&uVү~| t^|F$@C</C<$C@<C(<C<	.-_:pt& C<C@<C(<C<	.z-q_h:_VWP[^_]UVSut7t1ÉيB<v+B<v$B@<vB(<vw_t:t1RAB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀ:tt)QSe[^]Ív U  WVS]h   C$P؛S$B18 u!h   R躛S  t& C$@8  F{| tC|v C$@ :{| tC|       v S$B8 u%h   R?S蟞Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSҬ    h`$P    v C$@8  {| tC|       S$B8 u$h   RNS讝Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t@/C$@ @~!tZC$@ Z	t`1C$@ `~#t
zC$@ zt
   6C$@ =   ~&t   C$@ =   t
   6C$@ =   ~&t   [C$@ =   Et
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.t-C$@8-t
_sC$@8_`t
:SC$@8:@)   ,  S|t@/C$@ @~!tZC$@ Zt`2C$@ `~$tzv C$@ zt
   6C$@ =   ~&t   oC$@ =   Yt
   6C$@ =   ~&t   +C$@ =   t
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.ot-bC$@8-Pt
_CC$@8_0t
:#C$@8:   VW胹[^_]ÉU,WVS}E    Ed   E    G|t"tt& G$@8"uE"PG|t'tG$@8'uE'0GT$   tPXthGPG    1  jd Eujdh8  G$Gx   Eh   P虔W$B8 u!h   R}Wݗ| tG|       W$B8 u%h   R?W蟗Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWmG$@8&uWҥ| k  k  E@;u|#U҉UREP E  UEu| tG|       W$B8 u!h   R;W蛖IW$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWmG$@8&uWҤ	W| t_|G$@ u(ֈÄuSh   G$PoW$B8 u!h   RSW賕| t_|G$@w	t

t
u:]pU9W$dEU :]t.GT%   tPXthGPG      | tG|       W$B8 u"h   R蜑
WJW$B8
uBG$@   	    BG$@W$   B8 uh   R@G$@8%uWͧG$@8&uW2j j j jEPW辮E } t&EU(URhR$P 1EP<! Ee[^_]Ív UWVSUB$P,MQ$B8 u$h   Ru]SғEP|t
"t   v MA$@8"   ]Cx   E"{| tC|      EP$B8 u#h   RURWHMQ$B8
uBA$@   B]C$@S$   B8 uh   R蝏UB$@8%uR'MA$@8&6  Q   t
't   ]C$@8'   EE'@x   x| t@|       MQ$B8 u#h   R	]SfKEP$B8
uBUB$@   BMA$@Q$   B8 uh   R詎]C$@8%uS3UB$@8&uFR蕠8MAT'   tPXthǃAPҋ]C    1V  Ed   jd; Eu
h   E}x| t@|s  t& UB$_  t& <&  MA$@x#uQG  ]S  Ã  Ex tVs>   EFG+]9~'U҉URMQ E  ߀> u  t& CP[Ɖ]&EG+])9~6EEPUR E  
MNAMG;G7  < t<
t<
t<	u% EG+]9~KEEPUR"EG+]9~'MɉMQEP  E  ߋUz| tB|       MQ$B8 u#h   R9]S薏KEP$B8
uBUB$@   BMA$@Q$   B8 uh   Rً]C$@8%uScUB$@8&uRŝMy| tA|]C$@ :Et<<t UB|t<tBMA$@8<u4]tPXth CPҋE@T&   @    ;  ]MS|t9uM    ]C$@ 9t7UtPXthPMAPҋ]CT(   C       tE@|           MQ$B8 u#h   R茊]S\EP$B8
u#BUB$@   h{ 1bBMA$@Q$   B8 uh   R]C$@8%uS襠UB$@8&u	REe[^_]ÉUWVS}E    Ed   G$PJW$B8 u!h   R薉WW|t
"t   G$@8"   tG|       W$B8 u h   R:W蚌HW$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWmG$@8&uWҚE"  t
't   G$@8'   t
G|       W$B8 u%h   R_W迋Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R G$@8%uW荞G$@8&uWE'1tPXthGPGT+   G    1  jd Eujdh8  |     uF;u|#EEPUR EB  EUu| tG|       t& W$B8 u%h   RW_Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R蠆G$@8%uW-G$@8&uW蒘| t_|G$@   h   G$PCW$B8 u!h   R'W臉G$P蠆W$B8 u!h   RWL| t_|    G$@w	t

t
u	:]=EU w=	t8
t3
t.tPXthGPGT,   G       | tG|       W$B8 u"h   R,
W茈jW$B8
u5BG$@   )    EPhR$P
 1^t& BG$@W$   B8 uh   R谄G$@8%uW=G$@8&u	W袖Ee[^_]ÐUWVS}E    Ed   G$PW$B8 u!h   R2W蒇W|t"t       G$@8"   t
G|       W$B8 u%h   RσW/Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   RpG$@8%uWG$@8&uWbE"  t
't   G$@8'   t
G|       W$B8 u%h   RWOMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R萂G$@8%uWG$@8&uW肔E'1tPXthGPGT+   G    1  jd2 Eujdh8I  |     :]  E@;u|#EEPURI E  EUu| tG|       W$B8 u h   R舁WFW$B8
uBG$@   t& BG$@W$   B8 uh   R0G$@8%uW轗G$@8&uW"| t_|G$@   h   G$PӀW$B8 u!h   R跀WG$P0W$B8 u!h   R|W܃| t_|    G$@ Q
H
?C<4C<)C<	-'()+,./:=?;!*#@$_|%sEU :]t2tPXthGPGT,   G       t& | tG|       W$B8 u#h   R~W]kv W$B8
u5BG$@   )    EPhR$Pݬ 1^t& BG$@W$   B8 uh   R~G$@8%uW
G$@8&u	WrEe[^_]ÐU  WVS]C$P~S$B18 u!h   R~SkS|    <]uCC$@x]u7x>u1}   tzX thCPBTЃCT>   Gփ{| tC|v C$@   uH; tAWVSQtzH t'WVCPBHzD tWVCPBDЃ1{| tC|       v S$B8 u%h   R|S_Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R|C$@8%uS-C$@8&uS蒎S|tC|C$@ <<u<u)<&u&u <Y<	Q<
I<
AtK; tFWVStzH t&WVCPBHzD tWVCPBDЍ[^_]ÐUVS]C$PM|S$B18 u!h   R{S~S|t
StB  C$@8S3  K$AxY#  xS  xT  xE  xM     AC|t
 ua  C$@8 R  S|t
	uA  C$@8	2  t

u$  C$@8
  C|t

u  C$@8
   tPXth CP҃CTA   C       C$@8
:  {| tC|       S$B8 u h   R9zS}GS$B8
uBC$@   t& BC$@S$   B8 uh   RyC$@8%uSmC$@8&uSҋS|t ;t& C$@8 %t
	C$@8	t
C$@8

S|{| uC$@8 u{(݋C$@8%uS裏C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
Sƃ    PX  h@  t
Pt  C$@8P  S$BxU  xB  xL  xI  xC~     BC|t
 ua  C$@8 R  S|t
	uA  C$@8	2  t

u$  C$@8
  C|t

u  C$@8
   tPXthCP҃CTA   C       C$@8
:  {| tC|       S$B8 u h   RvSIzGS$B8
uBC$@   t& BC$@S$   B8 uh   RvC$@8%uSC$@8&uS肈S|t ;t& C$@8 %t
	C$@8	t
C$@8

SMy{| uC$@8 u{(݋C$@8%uSSC$@8&uS踇S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SEu,tPXthCP҃CTG   C    }    S|t
 u  v C$@8   t
	u  v C$@8	  t
u  v C$@8
  C|t

uy  C$@8
j  tPXthCP҃CTA   C    9  h   C$PtS$B8 uh   Rs	SKwC$P< t<	t<
t<
uB< t<	t<
t<
t1K  C$@8
>  {| tC|       S$B8 u#h   RmsSvKv S$B8
uBC$@   	    BC$@S$   B8 uh   RsC$@8%uS蝉C$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

Su{| uC$@8 u{(݋C$@8%uSӈC$@8&uS8S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
Sƃu)tPXth CPCTF   C    e[^]Ív UWVSuE    Ed   F|t<  F$F$P:<  Pz!  z-  z-  VxUFx   PsqV$B8 u!h   RpVtF$   @jd Eujdh8$P衞   ~| tF|F$@ E~| tF|       V$B8 u%h   R/pVsMt& V$B8
uBF$@   	    BF$@V$   B8 uh   RoF$@8%uV]F$@8&uV~| tV|UF$@ E~| tF|       V$B8 u!h   R[oVrIV$B8
uBF$@   	    BF$@V$   B8 uh   R oF$@8%uV荅F$@8&uV~|     }-u2}-u,tPXth`FP҃FTP   F    E@;}|#MɉMQEP ER  MEU}UU]~| tF|       V$B8 u h   RnVwqEV$B8
uBF$@   v BF$@V$   B8 uh   RmF$@8%uVMF$@8&uV~| t^|F$@   F$P nV$B8 u!h   RLmVph   F$P(mV$B8 u!h   RmVlp~| t^|    F$@w	t

t
u>}-1}-ME w>	t9
t4
t/tPXtQhFPFT-   F       ~| tF|       V$B8 u h   R7lVoVV$B8
u#BF$@   v URhRwBF$@V$   B8 uh   RkF$@8%uV\F$@8&uV}tPPtEPFP҃UR MNxe[^_]ÐUWVS}W7ƃtk<xt<XuaF<mt<MuVF<lt<LuK= t PVPt*; utPTthGPGT@   e[^_]Ív UWVSuE    Ed   F|t
<t  F$@8<  V$Bx?  FxEFx      BF$PjV$B8 u!h   RBjVmVEP  jd" Eujdh8$P K  ~| t
^|
t& F$@   	  
  
   tPXtEPh FP҃FTA   F       F$@8
>  ~| tF|       V$B8 u#h   R=iVlKv V$B8
uBF$@   	    BF$@V$   B8 uh   RhF$@8%uVmF$@8&uVzV|t 7t& F$@8 !t
	F$@8	t
F$@8

Vk~| uF$@8 u~(݋F$@8%uV~F$@8&uVzV|t &F$@8 t	F$@8	t
F$@8
t
F$@8
    t& E@;}|#U҉UREP EB  UE}~| tF|       t& V$B8 u%h   RfVOjMt& V$B8
uBF$@   	    BF$@V$   B8 uh   RfF$@8%uV}F$@8&uVx~| t^|F$@   F$PfV$B8 u!h   RfV|ih   F$PeV$B8 u!h   ReV<i~| t^|    F$@w	t

t
u?;F$@x>+UE wA	t<
t7
t2tPXtEPh`FP҃FT/   F    /F$   @tPLtEPEPFP҃URx EPl KURhR$P EFx0tPXthFPFT.   F    UVxe[^_]Ív UWVS]C|t<t	  &    C$@8<	  S$Bx!	  xN	  xO	  xT	  xAx	  xTn	  xId	  xOZ	  x	NP	  RdS$B8 u!h   RcS4gC$   
@
C|t
 uS  C$@8 D  S|t
	u3  C$@8	$  t

u  C$@8
  t

u   C$@8
     PX  h  C$@8
>  {| tC|       S$B8 u#h   RbS=fKv S$B8
uBC$@   	    BC$@S$   B8 uh   RbC$@8%uS
yC$@8&uSrtS|t 7t& C$@8 !t
	C$@8	t
C$@8

S=e{| uC$@8 u{(݋C$@8%uSCxC$@8&uSsS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
Sǃu/tPXthÇCPCT0   C       S|t
 u   C$@8 ttt	u
iC$@8	t^t

uSv C$@8
tEt
u
:C$@8
t/tPXth CPCTA   C      u   C$@8
G  {| tC|       &    S$B8 u%h   R_SOcMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R_C$@8%uSvC$@8&uSqS|t .t& C$@8 t
	C$@8	t
C$@8

SMb{| uC$@8 u{(݋C$@8%uSSuC$@8&uSpS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
jVS?   C$@8
;  {| tC|       S$B8 u h   R]S*aHS$B8
uBC$@   	    BC$@S$   B8 uh   Rp]C$@8%uSsC$@8&uSboS|t :t& C$@8 $t
	C$@8	t
C$@8

S-`{| uC$@8 u{(݋C$@8%uS3sC$@8&uSnS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
>t   v C$@8>   t
C|       S$B8 u%h   R[S_Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RP[C$@8%uSqC$@8&uSBmtDPt=VEPWCP҃,tPXth@CP҃CT1   C    WL tV< Et	P) e[^_]Ív UWVS]E    1}}}}h   C$PjZS$B8 u!h   RNZS]C|t<t  C$@8<z  S$Bx!j  xE`  xNV  xTL  xIB  xT8  xY.  Cx
   RUZS$B8 u!h   RYS]C$   @C|t up  &    C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RXS[Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0XC$@8%uSnC$@8&uS"jS|t 6t& C$@8  t
	C$@8	 t
C$@8

SZ{| uC$@8 u{(݋C$@8%uSmC$@8&uSXiS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
%t  v C$@8%  {| tC|       S$B8 u$h   RnVSYLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RVC$@8%uSlC$@8&uShS|t uo      C$@8 Z  t
	uL  v C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RTSNXLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RTC$@8%uSkC$@8&uSfS|t 6t& C$@8  t
	C$@8	 t
C$@8

SMW{| uC$@8 u{(݋C$@8%uSSjC$@8&uSeS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
E   Sƃu.tPXthCPCTD   C    3  S|t
 ub  C$@8 S  t
	uE  C$@8	6  t

u(  C$@8
  C|t

u  C$@8
   tPXthCP҃CTA   C       C$@8
>  {| tC|       S$B8 u#h   RQSMUKv S$B8
uBC$@   	    BC$@S$   B8 uh   RQC$@8%uShC$@8&uScS|t 7t& C$@8 !t
	C$@8	t
C$@8

SMT{| uC$@8 u{(݋C$@8%uSSgC$@8&uSbS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
}    t"t)C$@8"tC|t
't!v C$@8'uEPSdE} t,  P  EPj j j)  t& jEPSǃ    P  j WEPj  t
"t0v C$@8"t C|t'tL&    C$@8'u:EPS褹Ea  PV  EPj j jo  jEPSǋC|t>u      C$@8>z  S|t
 ui  C$@8 Z  t
	uL  v C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXth CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RMSQLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`MC$@8%uScC$@8&uSR_S|t 6t& C$@8  t
	C$@8	 t
C$@8

SP{| uC$@8 u{(݋C$@8%uS#cC$@8&uS^S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
C|t
NtC  C$@8N4  S$BxD$  xA  xT  xA     BC|t up  &    C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXth?CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RJSMLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@JC$@8%uS`C$@8&uS2\S|t 6t& C$@8  t
	C$@8	 t
C$@8

SL{| uC$@8 u{(݋C$@8%uS`C$@8&uSh[S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
S覨E  P(  EPWEP!   P   j WEPjVCP҃    C$@8
<  {| tC|       S$B8 u!h   R+HSKIS$B8
uBC$@   	    BC$@S$   B8 uh   RGC$@8%uS]^C$@8&uSYS|t 9t& C$@8 #t
	C$@8	t
C$@8

SJ{| uC$@8 u{(݋C$@8%uS]C$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
>uF    C$@8>t5tPXtVh`CP҃CT%   C       v tC|       S$B8 u%h   RES?IMt& S$B8
uBC$@   	    BC$@S$   B8 uh   REC$@8%uS
\C$@8&uSrW} tP1Ƀ} tt!P`	tPtVCP҉ty uEAEP| tVl } tEPW tWG EtP4 } tEP e[^_]ÐUWVS]}    C|t#t
YC$@8#uNS$BxRuBxEu<xQu6xUu0xIu*xRu$xEuxDu   	B	     v S|t	#tRC$@8#uEK$AxIu9xMu3xPu-xLu'xIu!xEuxDu   A   t     t
#t  C$@8#
  S$BxF  xI  xX  xE  xD     BC|   t un  t& C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   R^BSELt& S$B8
uBC$@   	    BC$@S$   B8 uh   R BC$@8%uSXC$@8&uSSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SD{| uC$@8 u{(݋C$@8%uSWC$@8&uS(SS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SԯCx   u*tPXthCPC        e[^_]ÉUWVS}E    E    G|t(uG$Et& G$P:(t5tPXth GPGT0   G    1N  t& PW@W$B8 u!h   R?WC| uWW$B8 u'h   Rq?WB   t& W$B8
t`sv G$@8
?  | tG|       W$B8 u$h   R?WnBLt& W$B8
uBG$@   	    BG$@W$   B8 uh   R>G$@8%uW=UG$@8&uWPW|t 6t& G$@8  t
	G$@8	 t
G$@8

WmA| uG$@8 u(݋G$@8%uWsTG$@8&uWOW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
Wƃu/tPXth@GPGTD   G    w  V ÃVd  W  } u]]   E]   v G$@8
?  | tG|       W$B8 u$h   R~<W?Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   R <G$@8%uWRG$@8&uWNW|t 6t& G$@8  t
	G$@8	 t
G$@8

W>| uG$@8 u(݋G$@8%uWQG$@8&uWHMW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
t
|G$@8|t
)uF    G$@8)t5tPXthGPGT1   G       &    tG|       W$B8 u%h   R:Wo=Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R9G$@8%uW=PG$@8&u	WKEe[^_]ÐUWVS}E    E    G|t(uG$AG$P:(t5tPXthGPGT2   G    1N  t& P9W$B8 u!h   R8WC<| uWW$B8 u'h   R8W<   t& W$B8
t`sv G$@8
?  | tG|       W$B8 u$h   RN8W;Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   R7G$@8%uW}NG$@8&uWIW|t 6t& G$@8  t
	G$@8	 t
G$@8

W:| uG$@8 u(݋G$@8%uWMG$@8&uWIW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
Wxƃu/tPXth GPGTC   G    w  V7 ÃV  W  } u]]   E]   v G$@8
?  | tG|       W$B8 u$h   R5W9Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   R`5G$@8%uWKG$@8&uWRGW|t 6t& G$@8  t
	G$@8	 t
G$@8

W8| uG$@8 u(݋G$@8%uW#KG$@8&uWFW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
t
|G$@8|t
)uF    G$@8)t5tPXth@GPGT3   G       &    tG|       W$B8 u%h   RO3W6Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R2G$@8%uW}IG$@8&u	WDEe[^_]ÐUVS]uC|t
NtB  C$@8N3  S$BxO#  xT  xA  xT  xI  xO  xN     BC|t uo      C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  t

u  v C$@8
   tPXthCPCTA   C    C  v C$@8
?  {| tC|       S$B8 u$h   R>1S4Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSmGC$@8&uSBS|t 6t& C$@8  t
	C$@8	 t
C$@8

S3{| uC$@8 u{(݋C$@8%uSFC$@8&uSBS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
S(t"
   St	   t& 1e[^]ÐUS]C$P/S$B8 u!h   R.SZ2K|tCtAC$@8Cu5S$BxDu)xAu#xTuxAu   B   V  tItIt& C$@8Iu9S$BxDu-xRu'xEu!xFuxSu   B      tItAC$@8Iu5S$BxDu)xRu#xEuxFu   B     tIt5t& C$@8Iu%S$BxDu   B   x  t& tEtIt& C$@8Eu9S$BxNu-xTu'xIu!xTuxYu   B      tEtQC$@8EuES$BxNu9xTu3xIu-xTu'xIu!xEuxSu   B      tNtUt& C$@8NuES$BxMu9xTu3xOu-xKu'xEu!xNuxSu   B   gv tNtLt& C$@8Nu<S$BxMu0xTu*xOu$xKuxEuxNu   B   
EPS]]ÐUWVS]C|t<t  &    C$@8<  S$Bx!  xA  xT  xT  xL  xI  xS  xT     	B	C|t
 uh  C$@8 Y  K|t
	uH  C$@8	9  t
u+  C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   R*S.Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`*C$@8%uS@C$@8&uSR<K|t 6t& C$@8  t
	C$@8	 t
C$@8

S-{| uC$@8 u{(݋C$@8%uS#@C$@8&uS;K|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SȈE   tPXthCPCTD   C    q
  C$@8
;  {| tC|       S$B8 u h   Rj(S+HS$B8
uBC$@   	    BC$@S$   B8 uh   R(C$@8%uS>C$@8&uS:K|t :t& C$@8 $t
	C$@8	t
C$@8

S*{| uC$@8 u{(݋C$@8%uS=C$@8&uS89K|t &C$@8 t	C$@8	t
C$@8
C|t
o
  C$@8
[
  &    C$@EE    E    SPǃu7tPXth CP҃CTD   C    
      h   C$P&S$B8 u!h   R%S[)K|t
 u   C$@8 ttt	u
iC$@8	t^t

uSv C$@8
tEC|t
u7&    C$@8
t%X  PXM  h 7  v u   C$@8
G  {| tC|       &    S$B8 u%h   R%So(Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R$C$@8%uS=;C$@8&uS6K|t .t& C$@8 t
	C$@8	t
C$@8

Sm'{| uC$@8 u{(݋C$@8%uSs:C$@8&uS5K|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
VSE  h   C$P#S$B8 u!h   R"SR&K|t u
yC$@8 tnt
	ucv C$@8	tUt
u
JC$@8
t?C|t
u1C$@8
t%X  PXM  h`7  v u   C$@8
G  {| tC|       &    S$B8 u%h   R"So%Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R!C$@8%uS=8C$@8&uS3K|t .t& C$@8 t
	C$@8	t
C$@8

Sm${| uC$@8 u{(݋C$@8%uSs7C$@8&uS2K|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
VSƃ
  h   C$P C$P: u!h   PSS#K|t>uC$  t& C$P:>  t
 ul  v C$@8 Z  t
	uL  v C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C      C$@8
?  {| tC|       S$B8 u$h   RS."Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uS4C$@8&uSb0K|t 6t& C$@8  t
	C$@8	 t
C$@8

S-!{| uC$@8 u{(݋C$@8%uS34C$@8&uS/K|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
U;Pu*tPXthCP҃CT      t%P tEPEPVEPWEPCP҃ tW
 EtP h   C$PcS$B8 u!h   RGSC|t>C$@8>K|t
>t   C$@8>   tC|       S$B8 u h   RS*HS$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uS1C$@8&uSb-UR賫 e[^_]ÐUWVSuE    E    h   F$PV$B18 u!h   RV?F|t
#t  v F$@8#  V$BxP  xCw  xDm  xAc  xTY  xAO     B   F$@8
>  ~| tF|       V$B8 u#h   RV}Kv V$B8
uBF$@   	    BF$@V$   B8 uh   RF$@8%uVM0F$@8&uV+V|t 7t& F$@8 !t
	F$@8	t
F$@8

V}~| uF$@8 u~(݋F$@8%uV/F$@8&uV*V|t &F$@8 t	F$@8	t
F$@8
F|t
F$F$P:
PV$B8 u!h   RVV|t
)t  v F$@8)  t
F|       V$B8 u%h   RVMt& V$B8
uBF$@   	    BF$@V$   B8 uh   R`F$@8%uV-F$@8&uVR)jj g EF|t*t  t& F$@8*
  E@   ~| tF|      t& V$B8 u%h   RVMt& V$B8
uBF$@   	    BF$@V$   B8 uh   R`F$@8%uV,F$@8&H  VN(:  t(t6t& F$@8(t$t|t  &    F$@8|  jj Uf EE  1  tF|       V$B8 u"h   R
VJV$B8
uBF$@   	    BF$@V$   B8 uh   R@F$@8%uV+F$@8&uV2'u+jj we E%UPEE  jj Le ÃjW4e CUZ]W'     &    F$@8
?  ~| tF|       V$B8 u$h   R^VLt& V$B8
uBF$@   	    BF$@V$   B8 uh   R F$@8%uV*F$@8&uV%V|t 6t& F$@8  t
	F$@8	 t
F$@8

V~| uF$@8 u~(݋F$@8%uV)F$@8&uV(%V|t &F$@8 t	F$@8	t
F$@8
t
F$@8
Vhrǃ  tPXth FP҃FTD   F    EP  v F$@8
?  ~| tF|       V$B8 u$h   RV^Lt& V$B8
uBF$@   	    BF$@V$   B8 uh   RF$@8%uV-(F$@8&uV#V|t 6t& F$@8  t
	F$@8	 t
F$@8

V]~| uF$@8 u~(݋F$@8%uVc'F$@8&uV"V|t &F$@8 t	F$@8	t
F$@8
F|t
F$F$P:
h   PV$B8 u!h   RVZV|t|F$@8|t
)tSv F$@8)uEF$@x*u9tjW
` UBW E@   F$   @ztW۟ tPXth`FP҃FT4   F    UR` Ov tPXthFPFTE   F    Ee[^_]ÉUWVS]E    E    C$@8
;  {| tC|       S$B8 u h   RSHS$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uS$C$@8&uS" S|t :t& C$@8 $t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 u!h   RSC|t
(t  C$@8(  {| uPS$B8 u#h   R8S   S$B8
t[nC$@8
=  {| tC|       S$B8 u"h   R
S<JS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
"C$@8&uSrS|t 8t& C$@8 "t
	C$@8	t
C$@8

S={| uC$@8 u{(݋C$@8%uSC!C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
Sǉ}   C$@8
;  {| tC|       S$B8 u h   R	S
HS$B8
uBC$@   	    BC$@S$   B8 uh   R`	C$@8%uSC$@8&uSRS|t :t& C$@8 $t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 e  h   RL  S;  t& Swgƃ  jVW ǉ}h   C$PaS$B 8 u!h   RES
S|t?t
`C$@8?uUG   {|    S$B8 u%h   RSO
  S$B8
      t*tGC$@8*u;G   {| u[S$B8 uh   RS	   C|t
+t   C$@8+   G   {| t
C|       S$B8 u%h   RS	Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uSt& G   V h   C$PgS$B 8    h   RG   S       C$@8
?  {| tC|       S$B8 u$h   RSNLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SM{| uC$@8 u{(݋C$@8%uSSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
P
  t
,t`  C$@8,Q  } utC|E_C$@ ERMt9uBC$@ 9t3tPXtQh CP҃CTB   C    Q  tC|       S$B8 u%h   ROSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSjj +R   } <  A  t|tC  C$@8|2  } utC|E2C$@ E%Mt
9C$@ 9tC|       S$B8 u"h   R
SlJS$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uS=C$@8&uSjj P @  } u
xǉ}BUBUPE1tPXth`CP҃C    CT7   
  h   C$P S$B8    h   R   SA   t& C$@8
?  {| tC|       S$B8 u$h   RSLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSC$@8&uS"S|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 u!h   RS C|t
(t  C$@8(  {| uPS$B8 u#h   R8S    S$B8
t[nC$@8
=  {| tC|       S$B8 u"h   R
S< JS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
C$@8&uSrS|t 8t& C$@8 "t
	C$@8	t
C$@8

S={| uC$@8 u{(݋C$@8%uSCC$@8&uS
S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SE   C$@8
=  {| tC|       S$B8 u"h   R
SJS$B8
uBC$@   	    BC$@S$   B8 uh   R`C$@8%uSC$@8&uSRS|t 8t& C$@8 "t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
  C$@8
p  &    SXƃu0tPXthCPCT6   C    1  jVI EV C| t
?tj    C$@8?uYE@   {| &  S$B8 u&h   R0S{  v S$B8
,  <  C|t*t
NC$@8*uCUB   {|    S$B8 uh   RS	  C|t	+tSC$@8+uFE@   {| uZS$B8 Vh   R`=S   UB      C$@8
?  {| tC|       S$B8 u$h   RS^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS-
C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S]{| uC$@8 u{(݋C$@8%uScC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 u!h   RSZS|t)C$@8)} t} t	UEP{| tC|       &    S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uS
C$@8&uSS|t?t
ZC$@8?uOG   {| I  S$B8 u#h   RS   S$B8
to   t*t   C$@8*   G   {|    S$B8 u%h   R?SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSm	C$@8&   S   t+t   C$@8+   G   {| tC|       S$B8 u h   RWSUS$B8
u"BC$@   v WC 1[v BC$@S$   B8 uh   RC$@8%uS}C$@8&u	Se[^_]ÉUWVS]E     C|t(u
>C$@8(t3tPXthCPCT6   C      {| tC|       S$B8 u h   R(SFS$B8
uBC$@   t& BC$@S$   B8 uh   RC$@8%uS]C$@8&uSh   C$PS$B8    h   Rn   S   C$@8
<  {| tC|       S$B8 u!h   RS{IS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uSS|t 9t& C$@8 #t
	C$@8	t
C$@8

S}{| uC$@8 u{(݋C$@8%uSC$@8&uS S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
C|t
#tSv C$@8#uEC$@xPu9xCu3xDu-xAu'xTu!xAuSƿ          Sƿ      C$@8
:  {| tC|       S$B8 u h   RSGS$B8
uBC$@   t& BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2S|t ;t& C$@8 %t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uShS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
E0e[^_]UWVS]E    h   C$PS$B8 u!h   RsSC|t<t<
  &    C$@8<&
  S$Bx!
  xE
  xL
  xE  xM  xE  xN  xT     	B	C|t
 uh  C$@8 Y  S|t
	uH  C$@8	9  t
u+  C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RSNLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SM{| uC$@8 u{(݋C$@8%uSSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SGƃu3tPXth CPCTD   C    	  S|t
 ud  C$@8 U  t
	uG  C$@8	8  t
u*  C$@8
  C|t

u	  C$@8
   tPXth@CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RSNLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SM{| uC$@8 u{(݋C$@8%uSSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
EtF    C$@8Eu5K$AxMu)xPu#xTuxYu   A     tAt7t& C$@8Au'K$AxNuxYu   A     t
(t#v C$@8(uEPVSV  t%tEt& C$@8%u5{` u/{(u)tPXthCP҃CT   'tPXthCP҃CT6   C    VKt C$@8
=  {| tC|       S$B8 u"h   R
SJS$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSC$@8&uS"S|t 8t& C$@8 "t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
{|   C$@8    {(   S{|    C$@8    {(   C$@8
;  {| tC|       S$B8 u h   R*SHS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS]C$@8&uSS|t :t& C$@8 $t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
>uF    C$@8>t5tPXth CP҃CTI   C       t& tC|       S$B8 u%h   RS?Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
C$@8&uSrtP$tEPWVCP҃EtP/ t	Vn e[^_]Ív US]h   C$PS$B8 u!h   RS-SSl S Sy SrS.l {` u{(u	S&  Cx   ]]UVS]C$   @C|t uo      C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXth.CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RNSLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SRL  ƃuhJlƃVCVj C| t u   C$@8 t|S|t	un&    C$@8	t\t
u
QC$@8
tFC|t
u8C$@8
t,tPXthNCP҃CTA   C    SW     C$@8
8  {| tC|       S$B8 u h   RWSES$B8
uBC$@   v BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t =t& C$@8 't
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
?t-    C$@8?uK$Ax>u   A  t
>t   C$@8>   tPXthCP҃CT9   C    {|    S$B8 u h   RSECS$B8
uBC$@   BC$@S$   B8 uh   RC$@8%uSC$@8&  S~  tPXthCP҃CT9   C    @BS$B <w<	t<
t<
uB8>u܃{| tC|       S$B8 u h   RS9GS$B8
uBC$@   t& BC$@S$   B8 uh   RC$@8%uS
C$@8&u	Sre[^]Ív US]h  PT]  h CPG  ]uK$:]uAx]u
x>D  {| tC|           S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`C$@8%uSC$@8&uSR	S{| u*C$@ uJ{(܄u@h   C$PS$B8 u!h   RS;C|C$P: {| uA8 u8Q-S$B8 u!h   RyS{| u8C$@8 u-tPXth@CPCT;   C    C$   @]]Ív UWVS]h   C$PS$B8 u!h   RS7C|t<t
EC$@8<u:C$@x?u.xxu(xmu"xluS,tPb { uhJJ  CtSz  uEPEPj R蛨  Cx   C`     C$@8
  C$px t<t(><u#Ax!ux[uSO      t tS
t& A8 tDt	t;A8	t1t
t(A8
tt
t   t& A8
   {| tC|       S$B8 u%h   ROSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&u?S1C|t%t
C$@8%uS^
  
t& SK$SK${| uA8 u{(9qu7;y u2tPXthCP҃C    CT<      S|t	<tC$@8<uC$@x?t<t
C$@8<uC$@x!t C$@8 t
	C$@8	t
vC$@8
cL
R{| uC$@8 t)tPXthCPCT<   C    e[^_]UWVS}G|t&*  G$@8&  (~JfE  E&tPDtjEPGP҃|&u
G|       G$   @   G$@x#u7WEffE   PD   jEP3W   tvHtE8t@tR@t uQGPK tPW4PW.t& Xt#7t~D tSPSGPFDЍe[^_]UWVS]h   C$PS$B18 u!h   RSS|t
&t  C$@8&  tC|       S$B8 u#h   R=SKv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSS,ƃu5tPXthCPCTD   C      &    S|t
;tc  C$@8;T  tC|       S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uSt(PtVCP҉ǃuzV2k ǃuh{t{X u1{\ u+tPXtVhCP҃CT   Q  tPTtVhCP҃CT   -  u+tPXtVhyCP҃CT      {x   u,tPXtVh CP҃CT      t\hKGPtDGt=j<Pft+tPXtVh`CP҃CT&   \v Y|TtPXtVhCP҃CT   %tPXthCP҃CT   C    V?Z e[^_]Ív UWVS]uh   C$PS$B18 u!h   RrStu
1      E8&  @EEPS,ƃu.tPXthCPCTD   C      S|t
;t_  C$@8;P  tC|       S$B8 u!h   RSIS$B8
uBC$@   	    BC$@S$   B8 uh   RPC$@8%uSC$@8&uSBt(PtVCP҉ǃuzVg ǃuh{t{X u1{\ u+tPXtVhCP҃CT   Q  tPTtVhCP҃CT   -  u+tPXtVhyCP҃CT      {x   u,tPXtVh CP҃CT      t\hKGPGtDGt=j<Pt+tPXtVh`CP҃CT&   \v Y|TtPXtVhCP҃CT   %tPXthCP҃CT   C    VV e[^_]Ív UWVS]1C|t
%t  C$@8%  {| tC|       S$B8 u h   RSGES$B8
uBC$@   v BC$@S$   B8 uh   RC$@8%uSC$@8&uSS>%ƃu5tPXthCPCTD   C      &    S|t
;t  C$@8;  tC|       S$B8 u%h   RS/Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbtP`tVCP҉ǃuo{t{X u;{\ u5tPXtVhzCP҃CT   C    p    tPTtVhzCP҃Cd    Bv!t2PTt+Vh CP҃WSPSY C\   ,tPXth`CP҃CT   C    VS e[^_]ÉUWVS]1} t	Uu1i  E8%S  @EEPSC&ƃu2tPXthCPCTD   C      t& E8;   @EtP`tVCP҉ǃup{t{X u5{\ u/tPXtVhzCP҃CT   C    XtPTtVhzCP҃Cd    0&    vtPTtVh CP҃C\   ,tPXthCP҃CT   C    V!R EUe[^_]ÐUWVS]E    C$u   	@	   C$@8
:  {| tC|       S$B8 u h   R)SGS$B8
uBC$@   t& BC$@S$   B8 uh   RC$@8%uS]C$@8&uSS|t ;t& C$@8 %t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
S6ǃ  tPXth CP҃C    CTD      C$@8
G  {| tC|       &    S$B8 u%h   RϾS/Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t .t& C$@8 t
	C$@8	t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
jVSAƃu
}    CX      t& C$@8
?  {| tC|       S$B8 u$h   R莼SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSC$@8&uS"S|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
ttVEPWCP҃tVK EtPJ tWJ C|t[  C$@8[  C|t	>u9C$@8>t,tPXth`CP҃C    CT=   {| tC|       &    S$B8 u%h   RϹS/Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&u	Sbe[^_]UWVS]C|t
[tl  v C$@8[Z  Cx   {| tC|    H  S$B8 u h   R׸S7ES$B8
uBC$@   v BC$@S$   B8 uh   R耸C$@8%uS
C$@8&  Sn  C$px    C$@8
?  {| tC|       S$B8 u$h   RS^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R蠷C$@8%uS-C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S]{| uC$@8 u{(݋C$@8%uScC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SSS$ t& SoS${| uB8 u{(9ru8;z u3tPXthCP҃C    CT   &t& C|t]RC$@8]AC|t
]t   C$@8]   {| tC|       S$B8 u"h   R<
S蜸JS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSC|t>u
7C$@8>t,tPXth`CP҃C    CT=   {| tC|       S$B8 u%h   R?S蟷Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&u	Se[^_]UWVS]}    Srƃ   tPXthCPC    CTD   1  t& C$@8
?  {| tC|       S$B8 u$h   RSnLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R谲C$@8%uS=C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

Sm{| uC$@8 u{(݋C$@8%uSsC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=tt  v C$@8=b  {| uPS$B8 u#h   RSZ   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R螰SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2S|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uShS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SCx   /tPXtVhCPCT)   C    1e[^_]ÉU,WVSuE    E    E    F|t<  F$@8<   ~| tF|       V$B8 u!h   RVkIV$B8
uBF$@   	    BF$@V$   B8 uh   R谭F$@8%uV=F$@8&uV袿V^
E	  tPXth FPFTD   F    1  Sh`k  F$@8
?  ~| tF|       V$B8 u$h   RVNLt& V$B8
uBF$@   	    BF$@V$   B8 uh   R萬F$@8%uVF$@8&uV肾V|t 6t& F$@8  t
	F$@8	 t
F$@8

VM~| uF$@8 u~(݋F$@8%uVSF$@8&uV踽V|t &F$@8 t	F$@8	t
F$@8
F|t
N$,  F$P:
  F$@ =  6  t
 ~%  F$@ =   t
>u  F$@8>  t
N$/u
F$P:/u
Ax>  AEI MEPVǃ  }   1;]}iWUPuJtPXtWhHFP҃F    FT*   W: EPz:  s  ;]|} u<E
   j( EuTj(h`$P p&    E;E~(MɉMSEP E=UM<EBBU    D       t& F$@8
?  ~| tF|       V$B8 u$h   RVnLt& V$B8
uBF$@   	    BF$@V$   B8 uh   R谨F$@8%uV=F$@8&uV袺V|t 6t& F$@8  t
	F$@8	 t
F$@8

Vm~| uF$@8 u~(݋F$@8%uVsF$@8&uVعV|t &F$@8 t	F$@8	t
F$@8
t
N$F$P:
E;A u9U;Qu1tPXthFP҃FT   F    6  h   QV$B8 u!h   RʦV*V|t5F$@ ~&t  F$@ =  t	F$@8	t
zF$@8
it
\F$@8
Jt
  9v F$@ =  ~&t  F$@ =    tP8tMQEPFP҃} t+1;]}UP6 C;]|MQ5 Ee[^_]Ív UVS]h   C$P@S$B8 u!h   R$S脨C|t
<uK$
C$P:<u	Ax/t2tPXthCPC    CTJ   k  t&    ASƃh   C$P葤S$B 8    h   Rq   Sͧ   C$@8
?  {| tC|       S$B8 u$h   RS~Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uS貵S|t 6t& C$@8  t
	C$@8	 t
C$@8

S}{| uC$@8 u{(݋C$@8%uS胹C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
~<    C$@ ~&t     C$@ =     t
	u   C$@8	   t
u   C$@8
   t

u   v C$@8
   t
  ~5v C$@ =  ~ t  RC$@ =  ~@t  ~OC$@ =  ~;t /C$@ = t>uEt& C$@8>t5tPXthCP҃CTI   C       t& tC|       S$B8 u%h   R诠SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RPC$@8%uSݶC$@8&uSBt   tPVKtltXPXхtOt   t+VPh CP/   tPh,CPh`SR@XЃCTL   C    tP<t
VCP҃tV/ Sut	P/ e[^]UWVS}E    Ed   W$B8<  x!  x[  xC  xD  xA{  xTq  xAg  x[]     	B	G|Gx   t~?t& G$@1 ~(W|t
  !  G$@ =  
  t
	u   G$@8	   t

u   G$@8
   t

u   G$@8
   t
  ~6v G$@ =  ~!t
     G$@ =  ~tt  ~3G$@ =  ~ t GG$@ = ~5tPXthGPG    GT?   Gx     tG|
G$@ E| tG|       v W$B8 u%h   RWMt& W$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWMG$@8&uW貮W|t~5G$@ ~%t
    G$@ =    t
	u   G$@8	   t

u   G$@8
   t

u   G$@8
   t  ~4G$@ =  ~!t
     G$@ =  ~tt  ~3G$@ =  ~ t GG$@ = ~5tPXthGPGT?   G    Gx     tW|UG$@ E| tG|       W$B8 u%h   RW_Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R蠚G$@8%uW-G$@8&uW蒬| t_|G$@jdf E(  jdh8)  E@;u|#MɉMQEP E  MEUuUU]| tG|       t& W$B8 u%h   R这WMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R`G$@8%uWG$@8&uWR| t_|G$@w	t

t
u}]}]>ME G|Gx   t~<G$@1 ~(W|t
  .  G$@ =    t
	u  G$@8	   t

u   G$@8
   t

u   G$@8
   t
  ~:v G$@ =  ~%t
     G$@ =  }   t
  ~0G$@ =  ~t
 QG$@ = ~AtPXtMQhGP҃GT?   G    EP'   tG|       W$B8 u#h   RMW譚kv W$B8
u5BG$@   )    URhR$P-    t& BG$@W$   B8 uh   RЖG$@8%uW]G$@8&uW¨tPdtMQEPGP҃UR& e[^_]UWVS]h   C$PKS$B8 u!h   R/S菙S$K|  rz C|E   ><u~?uS+      B8<u<x!u6x[u0xCu*xDu$xAuxTuxAux[uSSlu\B8<u$x!ux-ux-uS!$Cx   ;{| u*C$@ <uS+  &uSj Sh   C$PS$B8 u!h   RS]{| uC$@8 u{(݋C$P_S$B8 u!h   R諔SC$K|;z u8;ru3E9u+tPXth CPCT   C    (t<5B8<'Bx/e[^_]ÐU,WVS]S$BE{D t+BB EBESuƃ  VSb{4{h t){ t#Ctt;x,uPClPG !CdS|t/t
MC$@8/uBK$Ax>u6   AtP<t
VCP҃Sb  t
>t   C$@8>   {| tC|    F  S$B8 u$h   RS^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R蠒C$@8%uS-C$@8&   S莤   tPXtMQh@CP҃C    CTI   SqS8 tP"   {D   C$PH)щP U@E}EPSb    S`C|t	~:C$@1 ~(S|t
  N  C$@ =  :  t	u,  &    C$@8	  t
u  v C$@8
   t

u   v C$@8
   t
  ~:v C$@ =  ~%t
     C$@ =     t
  ~0C$@ =  ~t
 dC$@ = ~TtPXtEPhCP҃C    CTM   S袒Si tJP  ?St/{D t)C$PH)щP U@E}EPS,a  e[^_]ÉUWVS}E    E
   j
 Euj
h8$    |   _|  EPhR$P軽 1`  E@;u|U҉UREP EtUEu| t	G|    닋W$B8 u h   R*W芒HW$B8
uBG$@   	    BG$@W$   B8 uh   RЎG$@8%uW]G$@8&W辠G$@w	t

t
uEC<C<C<	_.:-UE Ee[^_]ÉUWVS]1C|tvt  t& C$@8v  S$Bxe  xr  xs  xi  xoz  xnp     B   C$@8
>  {| tC|       S$B8 u#h   R]S轐Kv S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uS荣C$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S轏{| uC$@8 u{(݋C$@8%uSâC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=uF    C$@8=t5tPXthCPC    CTK   1  t& {| uPS$B8 u#h   RSy   S$B8
t\oC$@8
>  {| tC|       S$B8 u#h   R轊SKv S$B8
uBC$@   	    BC$@S$   B8 uh   R`C$@8%uSC$@8&uSRS|t 7t& C$@8 !t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uS舛S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
"t  v C$@8"q  t
C|       S$B8 u%h   R蟈SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uS͞C$@8&uS2C$pSǋC|t"uEt& C$@8"t5tPXtVhCPC    CT"   w      {|   S$B8 u#h   R腇S  S$B8
    t& t't  C$@8'  t
C|       S$B8 u%h   RSoMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R谆C$@8%uS=C$@8&uS袘C$pSxǋC|t'uEt& C$@8't5tPXtVhCPCT"   C           {| tC|       S$B8 u#h   RSMKv S$B8
uBC$@   	    BC$@S$   B8 uh   R萅C$@8%uSC$@8&u4S肗)tPXth CPC    CT!   e[^_]Ív UWVS}E    E
   | t_|G$@C<vC<  j
 Euj
h8  EE   | tG|       W$B8 u%h   R菄WMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R0G$@8%uW轚G$@8&uW"|     E@;u|#U҉UREPL E  UEu| tG|       W$B8 u!h   R苃WIW$B8
uBG$@   	    BG$@W$   B8 uh   R0G$@8%uW轙G$@8&uW"| t_|G$@   G$PpW$B8 u!h   R輂Wh   G$P蘂W$B8 u!h   R|W܅| t_|    G$@w	t

t
u<C<AC<6C<	+."_-UE EURhR$P	 1-tPXth'GPG    GTO   Ee[^_]ÉUWVS]1   t& C$@8
?  {| tC|       S$B8 u$h   RNS讄Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S譃{| uC$@8 u{(݋C$@8%uS賖C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
et  v C$@8e  S$Bxn  xc  xo  xdz  xip  xnf  xg\     B   t& C$@8
?  {| tC|       S$B8 u$h   R~SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`~C$@8%uSC$@8&uSRS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uS舏S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=uF    C$@8=t5tPXth`CPC    CTK   1  t& {| uPS$B8 u#h   Ry|S   S$B8
t\oC$@8
>  {| tC|       S$B8 u#h   R|S}Kv S$B8
uBC$@   	    BC$@S$   B8 uh   R{C$@8%uSMC$@8&uS貍S|t 7t& C$@8 !t
	C$@8	t
C$@8

S}~{| uC$@8 u{(݋C$@8%uS胑C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
"tS  v C$@8"A  t
C|       S$B8 u%h   RyS_}Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RyC$@8%uS-C$@8&uS蒋C$pS8ǋC|t"n  C$@8"\  {|   S$B8 u#h   RySv|  S$B8
    t& t't  C$@8'  t
C|       S$B8 u%h   RxS{Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@xC$@8%uS͎C$@8&uS2C$pSǋC|t'uEt& C$@8't5tPXtVhCPC    CT"          {| tC|       S$B8 u#h   R}wSzKv S$B8
uBC$@   	    BC$@S$   B8 uh   R wC$@8%uS譍C$@8&uJS?t"t
4C$@8"u)tPXthCPC    CT!   e[^_]ÐUVS]   &    C$@8
?  {| tC|       S$B8 u$h   RNvSyLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RuC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

Sx{| uC$@8 u{(݋C$@8%uS賋C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
st
  v C$@8s	  S$Bxt	  xa	  xn	  xd	  xa	  xl	  xo	  xn	  x	e	     
B
   C$@8
?  {| tC|       S$B8 u$h   RsSwLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RPsC$@8%uS݉C$@8&uSBS|t 6t& C$@8  t
	C$@8	 t
C$@8

S
v{| uC$@8 u{(݋C$@8%uSC$@8&uSxS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=uF    C$@8=t5tPXthCPCTK   C    %  {| uPS$B8 u#h   RiqSt   S$B8
t\oC$@8
>  {| tC|       S$B8 u#h   R
qSmtKv S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uS=C$@8&uS袂S|t 7t& C$@8 !t
	C$@8	t
C$@8

Sms{| uC$@8 u{(݋C$@8%uSsC$@8&uS؁S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
't  v C$@8'  {| tC|       S$B8 u$h   RnSNrLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RnC$@8%uSC$@8&uS肀C|tnt
)C$@8nuS$Bxou1   Bov C|t	yt2C$@8yu%S$Bxeuxsu      B-tPXth CP҃CTN   C    S|t
'uF    C$@8't5tPXthGCPCT"   C      &      S$B8 u#h   RGmSpr  S$B8
&  6      t"tz  C$@8"i  {| tC|       S$B8 u$h   RlS.pLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RplC$@8%uSC$@8&uSb~C|tnt
)C$@8nuS$Bxou1   Bov C|t	yt2C$@8yu%S$Bxeuxsu      B-tPXth CP҃CTN   C    S|t
"uF    C$@8"t5tPXthGCPC    CT"      &    tC|       S$B8 u%h   RkSnMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RjC$@8%uSMC$@8&u4S|)tPXthZCPC    CT!   e[^]UVS]C$   @C|t
 uc  C$@8 T  S|t
	uC  C$@8	4  t

u&  C$@8
  C|t

u  C$@8
   tPXthvCP҃CTA   C       C$@8
<  {| tC|       S$B8 u!h   R[iSlIS$B8
uBC$@   	    BC$@S$   B8 uh   R iC$@8%uSC$@8&uSzS|t 9t& C$@8 #t
	C$@8	t
C$@8

Sk{| uC$@8 u{(݋C$@8%uS~C$@8&uS(zS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SbƃuhJ|ƃVƋCV C| t u   C$@8    S|t
	u   C$@8	   t
u}    C$@8
tlt
u
aC$@8
tVt?tt& C$@8?uS$Bx>   tPXthCP҃CTA   C    SC  S|t u  C$@8   t
	u  v C$@8	z  t
ul  v C$@8
Z  t

uL  v C$@8
:  t
?t-    C$@8?uS$Bx>u   B  tPXthCP҃C    CTA      C$@8
G  {| tC|       &    S$B8 u%h   R?eShMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RdC$@8%uSm{C$@8&uSvS|t .t& C$@8 t
	C$@8	t
C$@8

Sg{| uC$@8 u{(݋C$@8%uSzC$@8&uSvS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SC   C$@8
=  {| tC|       S$B8 u"h   Rc
S|fJS$B8
uBC$@   	    BC$@S$   B8 uh   RbC$@8%uSMyC$@8&uStS|t 8t& C$@8 "t
	C$@8	t
C$@8

S}e{| uC$@8 u{(݋C$@8%uSxC$@8&uSsS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
?t-    C$@8?uK$Ax>u   A  t
>t   C$@8>   tPXthCP҃C    CT9   {|    S$B8 u h   R`SdCS$B8
uBC$@   BC$@S$   B8 uh   RP`C$@8%uSvC$@8&  S>r  tPXthCP҃C    CT9   @BS$B <w<	t<
t<
uB8>u܃{| tC|       S$B8 u h   R_SbGS$B8
uBC$@   t& BC$@S$   B8 uh   R@_C$@8%uSuC$@8&u	S2qe[^]ÐUS]u  C$@8
1  t
<t+    C$@8<uC$@x?uS,  t taC$@8 tTt	tKC$@8	t>t
t5t& C$@8
t$t
t   &    C$@8
   {| tC|       S$B8 u$h   R^S~aLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R]C$@8%uSMtC$@8&uSo	S7S|t<t
C$@8<uC$@x?rt<t
'C$@8<uC$@x!ux-u
x-@t
 3C$@8  t
	C$@8	 t
C$@8

]]ÐUS]  h   C$P\S$B8 u!h   Rt\S_tP,th CP҃S|t t^C$@8 tQt	tH&    C$@8	t4t
t+C$@8
tt
tP  C$@8
@  tPXthCP҃CT   C       C$@8
?  {| tC|       S$B8 u$h   Rn[S^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R[C$@8%uSqC$@8&uSmS|t 6t& C$@8  t
	C$@8	 t
C$@8

S]{| uC$@8 u{(݋C$@8%uSpC$@8&uS8lS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
{| u7C$@8 u,tPXthCP҃CT   C    h   C$PKYS$B8 u!h   R/YS\C|t
<t  v C$@8<q  C$@x?a  xxW  xmM  xlC  @< t<	t<
t<
,  SO   C$@8
=  {| tC|       S$B8 u"h   RlX
S[JS$B8
uBC$@   	    BC$@S$   B8 uh   RXC$@8%uSnC$@8&uSjS|t 8t& C$@8 "t
	C$@8	t
C$@8

SZ{| uC$@8 u{(݋C$@8%uSmC$@8&uS8iS|t &C$@8 t	C$@8	t
C$@8
C|t
  C$@8
  &    C|t
<tr  C$@8<c  C$@x?S  xXI  xM?  xL5  @< t<	t<
t<
  S   C$@8
<  {| tC|       S$B8 u!h   RUS;YIS$B8
uBC$@   	    BC$@S$   B8 uh   RUC$@8%uS
lC$@8&uSrgS|t 9t& C$@8 #t
	C$@8	t
C$@8

S=X{| uC$@8 u{(݋C$@8%uSCkC$@8&uSfS|t &C$@8 t	C$@8	t
C$@8
C|t
$C$@8
hJyCtP0tCP҃h   C$PSS$B8 u!h   RSSWSh   C$PSS$B 8 u!h   RcSSVC|t<t   &    C$@8<   C$@x!uvxDupxOujxCudxTu^xYuXxPuRxEuLS^C|t[tC$@8[uCx   S腙Cx   Sh   C$PRS$B8 u!h   RzRSUC|t<uAC$@8<t5tPXth CP҃CT   C    g&    Cx   SCx
   S {| uC$@8 t,tPXthCP҃C    CT   CxtP4t	CP҃{ t1]]ÐUWVS}EEMM]]G$E   MqQ)      9~]u
Cv A@} t^} tXHUt& ]8
uH} t]8\u9]8\u0} t	]8\uǇ       MAY)É)B9|   [^_]ÐU,WVS}E    t& w|G$Eu,@WSw|W$UuB8 u(ك} 3  M	Mu!]CSU܋K+U)ыU܉M"v EMXQI)ȋ[)É]Љʃ}   _xCZ$Лv  t	t
t	
  t6P,th GP҃tPXthGP҃GT   G    ]C   v G$@8
?  | tG|       W$B8 u$h   R.OWRLt& W$B8
uBG$@   	    BG$@W$   B8 uh   RNG$@8%uW]eG$@8&uW`w|t 6t& G$@8  t
	G$@8	 t
G$@8

WQ| uG$@8 u(݋G$@8%uWdG$@8&uW_w|t &G$@8 t	G$@8	t
G$@8
t
G$@8
]]uSs+C)Ɖuv HE]PI+C)MЃ}  XuRt6P,th GP҃tPXthGP҃GT   G    
  <   ?   }  } uj j>j?Wm  tP,th GP҃uFxxuLxmuFxlu@@< t<	t<
t<
u-EW.tP,th GP҃hJqGtP0tGP҃Gx   IG$@8
8  | tG|       W$B8 u h   RKWNEW$B8
uBG$@   v BG$@W$   B8 uh   R@KG$@8%uWaG$@8&uW2]w|t =t& G$@8 't
	G$@8	t
G$@8

WM| uG$@8 u(݋G$@8%uWaG$@8&uWh\w|t &G$@8 t	G$@8	t
G$@8
t
G$@8
UuMRЋY+A)É]v uHVI+F)MЃ}t  X<%  ?l  !uBx-u<x-u6} uj>j-j-W/  WGx   <
  !   xD   xOu~xCuxxTurxYulxPufxEu`} uj j j>WR
  W6G|t[t
G$@8[uGx   Gx   t& <,
  !#
  }Z
  
  G$@8
>  | tG|       W$B8 u#h   R-HWKKv W$B8
uBG$@   	    BG$@W$   B8 uh   RGG$@8%uW]^G$@8&uWYw|t 7t& G$@8 !t
	G$@8	t
G$@8

WJ| uG$@8 u(݋G$@8%uW]G$@8&uWXw|t &G$@8 t	G$@8	t
G$@8
t
G$@8
UuMRЋY+A)É]v uHVI+F)MЃ}  X<  ?u.} uj j>j?Wm
  WM!uHx-uBx-u<} uj>j-j-W.
  WNGx   &    <,  !#  }Z
    G$@8
>  | tG|       W$B8 u#h   R-EWHKv W$B8
uBG$@   	    BG$@W$   B8 uh   RDG$@8%uW][G$@8&uWVw|t 7t& G$@8 !t
	G$@8	t
G$@8

WG| uG$@8 u(݋G$@8%uWZG$@8&uWUw|t &G$@8 t	G$@8	t
G$@8
t
G$@8
UuMRЋY+A)É]v uHVI+F)MЃ}  X<   ?u+} uj j>j?Wm  W:v !uAx-u;x-u5} uj>j-j-W1  WQGx
   
<u!u
}l  tPXthGP҃G    GT   w    },  8<t1tPXth GP҃GT   G    2} uj j j>Wr  WjÃu1Gx  P4  GP  &    SfPW!D h t, t&WtG4t;B,uRGlP  !Gdw|t/t
zG$@8/uoW$Bx>uc   BtP<t
SGP҃S WD tPt     `    &    t>t   G$@8>   | tG|       W$B8 u$h   R@WCLt& W$B8
uBG$@   	    BG$@W$   B8 uh   R0@G$@8%uWVG$@8&u]W"ROtPXtSh`GP҃G    GTI   WBWB tP1 S% ]  t2fE  G|EtPDtjEPGP҃G|    }N  UBX<  ?u/} uj j>j?W  WUE  t& !u>x-u8x-u2} uj>j-j-Wq  WGx      <   x!uNx[uHw$NyCu<xDu6yAu0xTu*yAu$x[u   	F	Gx   &    <u,!u
}R  /uGx	   Gx   &u*} uj j j;W  WnC(u&}  } uj j j<Ws  Ǉ       j W蓿| BG$@8 3()WA| G$@8 (j>j]j]WÃ}T}  M  tPdth  MAPGPҋG$     @  Ǉ         t~PdtSuFPGP҃   ؉   G$XXǇ       Gx   8}  } uj j j>W   W4    uGx
   E )Љ}1V     9~MA@9syME} tE8u_E Y<"uE"L<'uE'B<]u=uFJ@9s3|]u"19s!uFӋp;>t*CA9rB;Ur}          t& WwGx   Ǉ       h>t& h0    h $Pi Gx   h`$Poi Gx   h$PMi Gx   Ee[^_]ÐUEj PP]UWVS} ~|} tvEH$tl9tfxxtyWAq)ƃ+URMQW%Q  EP$@ZUB$pp} uB$ @xPv&MQEPUzxtMQR} tnUBxtY
t2tPXthMAP҃E@    @T   UzxttP4tMAPҋE@xUe[^_]BTUWVSu1} t}~EPF  PM  Eu1=  DDÅuURCt& t`= tP jhY ǉ;u"MQ S 1          } tEC} uǃ       URVR     S\=ǃuSB1z    } u
G    MQd GE@ GUB GWS9} ~%} tC$t8 tMQUR PN  ؍e[^_]ÉUWVS}BƅtEV<Ãt*W  PV4X{{ SV9VA1e[^_]UWVS}EtP|Ãu1Xt	;C    S{ u} t
st& C1P  st    S)Ae[^_]ÐUEj Pj ^]ÉUWVS}E    1} uthAÅt]} ttPi EC    tPtWEPCP҉ƃu} t    Sy@1   VSv:C$@P'   PSV~ uWZFF   F   C$@FC$@FF$    WURScCt2{ tP U@     E    CP  C    } t    S?Ee[^_]Ív UUEPRj ]UWVSu}tt	3t& K@Åu
   } uhJL
  C} ttP EECWS9} tEPSOUS裞{Tu&} t    CP
  S>e[^_]Ív U]ÐU]ÐUEjPj ]ÉUWVSj EPI  ǃt&C?ƅtV8Ãu
V2>1[EP C;G CG CSVP5    uEPM      u
t   e[^_]ÐUWVS}E1P6Ãu1   ttP3 ;C        u4uEPL  ƃ    utVW   S{ u} t
st& C1P  st    S<e[^_]ÐUEj Pj ]ÉUEjPj ]ÉUWVS}E<8 uy=ƅtnV;7ÃtSC    C   C       C     W'  PVR{{C$     SV3V&<1e[^_]ÉUWVS}UEPRHÃu1Xt	;C    SQ{ u} t
st& C1Pv
  st    S;e[^_]ÐUUEj PRj ]]ÐUUEjPRj A]ÐUWVSu}V5Ãuhw` V 2V^<tW CECCSV92e[^_]Ív UWVS}E1PJÃu	Z= tPF Et{S{ uCTtƃ} t    SZ:e[^_]ÉUWVS}UE1PRzÃu=;ECS{ uCTtƅt    S9e[^_]Ív UY    ]UVS]uVCHPq   SP94t1v Ѝe[^]ÐUE@         @    ]ÉUS]CtP S]]Ív UWVS}EE       1ҋH9w=puu)D9u	E   9sJZ9w} tɅtMA9xsB[^_]UWVSUPEHP^MÃ;YLs'IPu    9u<      uFLVH@9vnVPu
Pp PRʢ u/UtPXthMAPҋuFT   pUBPBHM4    ALu9t)9v#MǃyPJw   9wEu؍<    ~Pu   uFLe[^_]UEЉ]ÐUE
Љ]ÐUE]ÐU]UMtGA(t@y, t:: t    B   : uB   A,@0Q,A(B0A(    ]Ív UWVS]}u	1   jҕ ƃuh $PZ 1   v F   WPF} tEPPFF        tkC0us0_v ËF{ ut9PCPpQt%0F{ utPCPKQu
V   1	; uˉ3e[^_]UWVSu}EP  tWVP       j貔 Ãuh@$PY cC   tVOCC    tWOC
v C        } tUB(uZ(	 8 u1e[^_]ÐUUtEB,]US]t?CtP^ CtPK jjS S/ ]]USEtP؃u]]ÐUWVSu}t~$ t1   t& jb Ãuh`$P^X 1   v tWN    } tEPhNCC    } tEPGNCC    C    C    C    C    t^$؍e[^_]UWVSu}t
~  t1   j芒 Ãuh`$PW 1~tWM    } tEPMCC    } tEPuMCC    C    C    C    C    t^ ؍e[^_]ÉUS]   tP+ CtP CtP CtP~  CtP_  CtPL  CtPi  jjS S蝸 ]]ÉUVSu   j8 ÃtjC	   VJLCC    C,    C     C$    C(    C    CCC0    C4        C    h{$PU 1e[^]ÉUS]   CtP· CtP请 CtP蜷 C,tPQ  C tP*C$tPC(tP(C0tP!  C4tPƕ  j8jSf S ]]Ív UWVS]E    1u1  ـ9   E9Ey  t& ;&W  9tQtu)PQW>  3t& )PQEP  i  uEGxǍKˊI  
C:  +E;E};u; "  +E;E  9   )PQIƃVEP   t58u0u@PEPq  EǃW@PWV  EVEPH  u   V蠵    v uE
&    GxǃVw Kt& C; t+E;E9t>tu)SQW  %)SQEP  tuEGxEe[^_]ÐUWVS]E    1u1  ڀ: K  ;&7  9tQtu)PRWN  3t& )PREP  =  uEGxǍSӊC  <;u;   9   )PRGƃVEP   t78u2u@PEP
  EǃZ@PW  FVEPy	  u   Vѳ ~   t& uE
&    GxǃV觳 St& C; 9t<tu)SRW  #)SREP
  tuEGxEe[^_]ÐUWVSu1u1   EEFuR} tF4PWJ   F4PEPA  Ã   SWIǃSϲ        } t5F(PEP  t@PWIVF4PWIGE&fEfEjEPWHǋF(PWpIǋEE;@  jPWHǃve[^_]UWVS}uu1   j 萊 Ãuh$PO 1   C   {C    VEC} t0EPGP  ƃVGPC V脱 C        C    C    tG$u_$@x uX    C    ؍e[^_]ÉUWVSu}u1   j 蠉 Ãuh$PN 1   C   sECWDC} tEPFPC
    C        C    C    tF$u
^$t& @x uX؍e[^_]UWVSu}u1~   j Ј Ãuh$PM 1Tt& C   C    VCCtWEPCC        C    C    ؍e[^_]ÉUSEt    XP   ؃u]]US]tnCt(SP@P虊  tSC@Pf  CtP? CtP
  j jSh S ]]ÐUEtVPuh$PL :&    J$9u(AB$Q
BAR*1Q9tхu]UWVSu}u1   j8 Ãuh$PL 1   C   C    C    C    C    C    C     C$    V BC(C,    C0    tWAC4
    C4        C    ؍e[^_]UVSu   j8? ÃtjC   C    C    C    C    C    C     C$    VMAC(EC,C0    C4        C    h$PJ 1e[^]ÉUWVS}UEuPR1Ãt4{t-VWCuC     &    @x uC ؍e[^_]UWVS}UEuPRÃt-{t&VW  CuC     @x uC ؍e[^_]Ív Uj8Є tkB   EBB    B    B    B    B     B$    B(    B,    B0    B4        B    &    h $PaI 1]Ív UVSuj8+ ÃuhC$P'I 1   C    C    C    C    C    C     C$    C   h?C(C,    C0    tV>C4C4        C    ؍e[^]ÐUS]MEUt"tuRPC,PRPQCPu11v B   ZCB{ u
St& C PBS Ћ]]Ív UWVS}uj8 ÃuhC$PG 1   C   {C    C    C    C    C     C$    >&u3FVE@|;uHPVd=PVV=
t& V=C(C(C,    C0    PWz  t@C4C4        C    ؍e[^_]ÉUEPtEBЉ]UVSuj8ˁ ÃuhC$PF 1   C    C    C    C    C    C     C$    C   h<C(C,    C0    tEPV2<C4C4        C    ؍e[^]ÉUUEPR"tEBЉ]UVSuj8ۀ Ãuh`$PE 1   C    C    C    C    C    C     C$    C   h;C(C,    C0    tV;C4C4        C    ؍e[^]ÐUVSuj8 Ãuh$PE 1   C   C    C    C    C    C    C     C$    h;C(C,    C0    tEPV~:C4C4        C    ؍e[^]ÉUEPbtEBЉ]US]MEUt"tuRPC,PRPQCPau15&    B   ZCB{ u
St& C PBS Ћ]]Ív UVSu]tu1<S  FCFCsFC^CtXCt9puX؍e[^]ÐUVSu]tu1<SU  FCFCsFC^CtXCt9p uX ؍e[^]ÐUVS]utu1XCtx t@ t
x u	[{ uV  ~ uCFC^F    Fstp e[^]ÐUVS]utu1}   ^CFC4tNPCPJt:SPtBCx tt& @x uC C4P耤 C4    { us    C pFs e[^]ÐUEt@ 1]Ív USEtXP   ؃u]]US]   CC    C    C    C    tPC$tP{tC4tP袣 C(tP菣 C0tPTj8jS踷 S` ]]ÐUMtSQt9JuABQt9J uAB QtABQtABA    A    A    ]Ív UVS]uu
1v    uSs_VgCFCFCFtpCFtpFt9XupF9X up C    C    C    ؍e[^]Ív UUt;Btt,BPBPj t& BPBPj 1]ÉUWVS]11t SuƉƋue[^_]UWVS}ut/Vtj FPBPj FPj 3Ãu1@Ftt@PWGP  CC    FtP  C؍e[^_]UWVS]11t,SEPOuƉ    FƋ[uԉe[^_]UWVSu}u1  j8`y Ãuh$P\> 1  FCEC{C    C    C    C     C$    F(tPR4C(
    C(    C,    C0    F4t~tP4C4C4        C    t
SW}    F0tPC0F,td@PSUR	  uGF,@PVFP	  t-JR؃{ t	@x uQRPv S,F$tPS(C$FtSURP1   CtCuC     @x uC ؍e[^_]ÉUWVS]11tAjEPEPS} uuu
@    ƉFpƋ[ue[^_]Ív UUEPj j R]ÐUEj j Pj]ÉUVSutFPFPPj _Ãu
1]    FtP8  CFtPu  CFtPe  CFtPn  C؍e[^]UVSutFP9Ãu1   t& FtP CFtP~1CFCFC} tBF tPC F(tPHC(F,tj SP#C,؍e[^]ÐUEu
1    @,t
xt@u]USEUu1?v X,[t
{uuuP,RQM
v RS؋]]ÐUUt"BHw$EPhR
  ]ÐUS]thS  u	[u1]]ÐUVS]ut3t/CHw$ C(tP V/C(e[^]ÉUSE]u	u  uC  x
   X,   {t[   hTPY0tHhYC(PA0t0h^C(P)0thcC(P0u[YhhC(P/thmC(P/u)hrS[
  uEhwSF
  5t& tC((1h|S
  u	[u1]]UUtmBHwd$jBPBJtjBPAP,6jBPj "B4ut& B4tP$.1]UVS]u   CH   $C4tP C4    CtPVCPCtjuC     ]@x uC OC4tP蘙 CtPMC    C     tVS-C4C4    e[^]ÉUWVS]u}   CH   $C4tP C4    CtPWVCPCtouC     b@x uC TC4tP赘 CtPjC     C    tWV,C4
    C4    e[^_]Ív UWVSu]      FH   $$1~ t~ QF4tJPFPFtu
F     
@x uF F4P ~ F4    SEPzÃt?SVt.G9u'PW[   } tSEPF4P-F4e[^_]UVSu]ttS-PSVe[^]ÐUVS]uu6t.{u(~u"F4PSV V؍e[^]Ív UWVS1}E
   }    Ep0   u-E@P8o ǃu
h`eE    1C;]}%V@9tiPR*+uVt& E9E|8E@PW9z ǃuh$P3 13t& E4@E    6EE@E$e[^_]UWVSu};&    ^0t*Cuu$tWPh*tu֋vu1e[^_]UWVS}}   } t|w0tnFta} t[URP
*uG9}t9EX0tCu~ t+VtRP)tut& 6uu1e[^_]Ív U<WVS}   } t!tGPEPEP)tq1mGPh]S{2 SEPE*      VGPhSP2 SEPEFPn uσEPGPEPe[^_]ÐUWVSuE    E    E    E    B  ~, 5  } u7E
   j(kl EO  j(Sl EP  1;U})MF,9uMB;U}M9uMF,;U   F,PEPURǃ   M9M}EESUR1w Eu#h$P0 MQ  t& SEPv Euh$P0 UR  ME<F,UAM~,N$M  v Ex   } upE
   j(k Eu"h$P0   t& j(j Euh$P/ UR   1;U}-MAM9u	MB;U}M9uMF,;U   UBPMQEPǃ   U9U   MɉMSEPu Euh$P-/ UR1SMQgu Eu)h$P. EPB    UM<UMBUAMMyE@E]Fu;uFt";ut&Ft;utFu~ u1;u11e[^_]ÉUWVSu}      ^$t6WCP9%ujCPFPt_n[uʃ= t\^tUS tNWF(PRp  uS$tWF(PRp  t@P#h#1e[^_]Ív UWVS}_$}    EPW
9  t& URCP\$uiCu%G,tUR@P7$tCt=UR@P$u&jCPGP      t& [u=    w   V    EPG(PRo  ÃuV$tEPG(PRo  ÃCtFPWVt4UR@P^#uCPs"hd"1e[^_]ÉUWVSEu}X$tu&    VCP"uSCtPC    t1WUBPV  ƃVUBPC V [uWVEPÍe[^_]UEtxt1	t&    ]Ív UEt
xu@4u1&: t<
t<
t<	t< uB: u   ]Ív US]t"CwEPEPC4P#C4]]ÐUSje Ãuh $P* Tt& C    C  Ch  Ye t  h $PN* S虌 1]]UVSuje Ãuh $P* 1pv C    Ct
st& C    Ct7Pd u h $P) S 1
      ؍e[^]ÉUUtEB]US]t@t!h  jP P蚋 jjS֟ S~ ]]Ív UE@    PRj P蟟 ]Ív UVSu]u13F9w')؉FPPR F 
t& e[^]ÉUEUt
u
1    u PBPjQ. ]ÉUEt
     1]ÉUEt@1]Ív UVSuUӋFt 9s   aFu9~9    Z
uSb 
SP&n t^   h@$P' 1e[^]ÐUWVSu}]         }W  t& 19}? tt& @9}<8 u9}ÃuÅ~RF;Fv'PVuh@$P' SWFP VډV e[^_]UEtjPEP]UVSuEtKÀ; tDF
;Fr&PVZuh`$Pt& V
FC; ue[^]ÉUUEPRb]ÉUUEPRf]ÉUVSu]j"St9j'ShV$SV hV	)hVSV hVe[^]ÐUVSu]tm{ughV2{ thVCPV* { thVCPV hVe[^]UVSu]tSVZue[^]UVSu]t^{uX{ t&hVtCPVK     hVNhV=CPVLe[^]Ív UVSu]t    SVbue[^]UVSEuX   hVPV { t(hVCPV hŠ{ thǠVxCPV { u&{ u { u{ uhРVB~   hӠV.Ct
PV  Ct
PV]  Ct
PVN  Ct
PVW  hנVhРVe[^]ÉUVSu]   hŠVCt"@tPVYh٠Vg CPV;j CPEPÃ t&hV.SV@ S褄 h۠Ve[^]Ív UWVS}u]tSVW'[ue[^_]Ív UWVS}utpt& } t.= t%~u} ~]hߠW~KuEPEPVEPW.    } thWKvue[^_]Ív UWVSu}  Gu=G4  PEP٘  Ã  SVSi   uY4   hVG(PV 4 thŠVG4PVn h^  u94 i  hV]G4PV4 h$  t& u+hV)G(PV  h   u2hVG4t
PVh   }u WRtBtuE    hVG,t"@tPVjh٠Vx G(PVLG0t
PV0G$tPEPV@4 u' u!= uhV  t& h
VG4t,PEPÖ  ÃtSVSW   tk} thVEP} |E@PGPEPV = t#} t} ~]hߠV]KuhVIG,t"@tPVh٠V  G(PVh
Ve[^_]UWVSu}tQPÅtFt~
uWVS}  t& jj WVSy SEP1STe[^_]ÉUWVS}hWnUBtPWshWGEx t!h$W-UBPW9 UBtth/v h@WhWEx  t
PWUr,t^= tB(PWt& EP`t-jj SURWC hWf[uӍe[^_]ÉUWVSu}} tÅu        5    EPSCPPC Se[^_]Ív UEt
@
t& ]Ív UUEt}	B    	~	B	   B]ÐU]UE}    	~	   ]ÉUVSut.Åt#VSSEP Se[^]ÉUWVS}]E    ]ƅu1   t& SVJ{ }CSBwJRhR]S  ӉuGuRj     SWv E} u*hXW Ãu6VIv FPPEP ǋEP VSǃSH  Ve[^_]USjT Ãuh`$P ZjS Ct6@    EP  CCC    C    &    S{ 1]]ÉUS]CtPC    CtP CtP  CtP;  C|P jh   S谏 SX{ ]]ÐUWVS]11}t+jhS豈 uj S  ǃu~1   jhS uS9  EuM͍v uCu!hP& P= hS ƃtEPÃts{ECjS  ؍e[^_]US]u1EPt]]ÐUS]}1EPtX]]ÉUWVS]}1   Ex t{<]   W`R ƃu+h$P\ j y T&    UBSURWV@Љ3 SVUBPw Vcy SEPUBPU؍e[^_]ÐUWVSE]p  
t  EPBR)Ѕ h$P 1      9~ÃCPjQ ǃuh$Pf R  UBtSWP?  lUBt
SWP+7  TUtPSjWv ?t& Ex t
SWVP %UB}h j    SWP ÃuWx 1   }hG; 8Ex tw]   URyP ƃu$h$Pu Ww [UBSWURV@Љ3 SVUBP Vw ; SWUBPtW`w ؍e[^_]UUz uz u: uz uz |EPR	&    1]ÉU  WVSE1u1   h  P S E ؉tt   t   u@@9v8/tH9v8/u8/u9uƅ !v   h   S tE S詁 ǉ[^_]UWVSu]u%tPTtEPh`S13t& VSfǃut@TtVh`SЉe[^_]UE]ÐU]UMUEPRQЉ]ÐU= um= uZ<P   ha u<hM tPI  h. t	P*     ]Ut	P u     ]ÉU  WVSuU1tPt E8UBtPt E@    UBtPt E@    n  ƅ  > ^   ڍ&    >:u~/u
~/   FG> u߀> %   ڊ<:uj R] UBDBЉF<	vჽ tUB</tFtGF</t9u3v </tu R~ UBFGf    > uKj
L tcjhP Q  S~ U1v 1ƅ  ڐt& FG> u SW~ UB[^_]U  WVS]11tPr ==< t
<       ƅ     <:u{/u{/u
ƅ  . CF   <:u{/u߀{/u 1;    ƅ   ʊ<:uR Ru} 
|BC<	vt=<</tBt>&    C</t0u*v </tu R} t& CF끍[^_]USjD7J Ãt2jDSg CP   C8    EPSt& 1]]Ív US]   CtP:q tP(q CtPq CtPq C tPp C<tPp C@tPp CC   |PW CSp ]]ÐUS]CtWSщЃtzt8(t-@8(t(@8(t#@tt   t   u@@)PRCP( C4]]ÉU   WVSuF  Eh~  u+h  H F    F0  F,F$F(N V,   9v F())ЃPRQu )^,)^$)^(^ ~0N(   9sh)ىtV$)ډpN,)ىl?F0PSYS F uF4   tV(pN$lF,h   F(PFP F4~F(y&    tlu
Z 8u]ǅx
   x1C    hVhЃSj j QF@P  ~F1H[^_]ÐU  WVSu ߋF(9F,u!V,u9u19 +t& F, F,<
u <
tG)=  ~E SPy [^_]Ív UVSu]  jhSZ{ uv1ɃC<	v;.uC<	vt& < t
<	  C< t<	t<	  LBCB<	vt t		~  N8v  j
hǢSz u,V<
C< t<	t   Rm    jhբSz u#~<   t& C< t<	tnv j
hSPz u
~<    C< t<	t8jhSz u6~<    &    C< t<	tSw F<}   t& j	hSy u)V@	C< t<	tt>R l 0v j	hSy u"	~@ uC< t<	tS*w F@e[^]ÉU   WVSjjj Ã   j jS tPjS     EEEfE ffEjEPS ǃu@W 8sthn	 aǅh<   hd1҉P    pكdPj Vj CP ǃ tuSr ؍H[^_]UWVSE}P1 ƃu:t& F1ۃ8 t'     WPuFC< u߸e[^_]U  WVSǅ    1} tEuUR\SHSi 1ۃ t    t(P^  Si   JuR  v t<PRFPQ}P  B= t^RPt) APAPRAPh S T FPFPFPh`S ,t&  BPBPhh   S  ؃Ps AAA   QF       SPhtSPh RÃt!t; uA,A$Sh ~@ twF8=+  ~m=  fPuꃽ	4B@Ps ÃQPV91'} tB<tPr M[^_]ÐUWVSu}]tu
Ev 1:F,V()9}VuF,V()9}ӃSPW} ^,؍e[^_]UEt	Pz]ÉU<N  WVSǅܱ    1ۃ} u
1  v } uE} t	E     uURرSرSYf 1ۃ رt    t-رPiSf [t& رQuQرFPR.}Vvt& رB}    } u]} t	Mu(رFPFPEPh  v PرBPBPMQh   } t	uu+EPرBPBPMQh    uVPرBPBPMQh@z   Etzt8"t+B8"t&B8"t!Btt   t
   uBB+U} up} t	uu5EPRرBPBPMQhh N  SD     uVRPرBPBPMQhnt& } t	uu1EPMQRرFPFPEPh 0    MQuVRPرBPBPMQh`h N  S 0Shr Sn رFFF   VF      2SرPptSh SGc رRÃt!t; uرA,A$Sc رV@   F8=+     =     Rh  رPuꃽܱ	9رܱB@Pm رÃQ)t& رV
h  } t)رB<tPm M	u    رB<tPB8Ph رA8Ph! ر[^_]ÐU  WVSE]URPuƃu   uCtHh  jAS ǃ}1V} tUtP[a E     1 PSW3 h   SV܃V-W 1[^_]ÐU  WVS}UuzuBt+jAR ƃ}WF&    1     PSV h   SW܃W1[^_]UEt
@8
t& ]ÐU=    jdh<    h@     hI߆ uhSˆ tP;  h]諆 tPj hl膆 tPj    ]Ív UtPP_     tP1_     tP_     <     ]Ív UWVS]u}tP^ tP^ tP^ tSi tVi tWi EEe[^_]ÐU  WVSuU1tP^ E8UBtP^ E@    UBtP] E@    f  ƅ  > V   ڀ>:u~/u
~/   FG> u߀> $   ڊ<:ui Rh UBDBЉF<	vჽ tUB</tFtGF</t9u3v </tu RKh UBFGg    > uKjm5 tcjhPzs Q  Sg U1v 1ƅ  ڐt& FG> u Sg UB[^_]U  WVS}]1ɉr  j  ? a   W  ƅ  ; G   ;:u;{/u5{/u/ RPf    1Ƀ&    CA ; u;    1 <:ui RGPhf    ODBЉC<	v9   W</tDt@C</t9u3v </tu RGPe uPW1CAbtRZ G    ; u+jv3 t>jhPq ,)1ƅ  CA; u1 Ve G1[^_]Ív U  WVS]11tPcZ == t
       ƅ     <:u{/u{/u	ƅ  - CF   <:u{/u߀{/u 1;    ƅ   ʐt& <:uN Rd     |BC<	vt=</t4t0C</t)u#</tu Rd CF뉍[^_]UVSuhL  1 Ãu1Q&    hL  Sm C   C(   C8    ǃ@      ǃD      t
VS؍e[^]ÐUS]tvCtPX tPX CtPX C,C(   |P C,ǃ@  ǃD  S@X ]]ÐUM}B<	w"PA<	wTBA<	v1TPЀy-uډЉ]Ív US]@        D  =      9   ~-)PD<PC<PWk @  )D  ǃ@         +D  u1Uj P@  <PC,PE |D  D  D< &    C,PĹ C,]]ÐUWVS}EWD   uu
   @  <8D  <489su)PSWo~9EC)H  9s;
tC9s;
u;
uC;
u0C-    C9s
<
u9rD  @  S<
tC뇃} BC)@  EQE)Ѝe[^_]Ív UEP]ÉU   WVSu1xxC    UtV,tЃSj j QF,@P  tu1	VtX[^_]Ív U   VSuFuht& Phh   8S	 j PRF,P7 |1([^]ÐU   VSuFuh<h	v Phh   8S j PRF,P |1([^]ÐU   VSuhh   8S] j PSF,P 1([^]ÉU  WVS}  W  tPRv ƃr  _jSh fG FOFPRQj = tGu   ffGj jj G,  jSP=   Wƃ  = >     Phh  pS* j PSG,P] ƃ   W'ƃF\  $,= t_t
Pht& h<hh  S j PSG,P ƃ[  Wƃ  tq    GPhh  pSU j PSG,P ƃ    WRƃu   	  =r  Wu%GPhȦh  pS '    GPRhܦh  pS  j PSG,P ƃ|fWƍFw     t& Guh<hPhh  S\ j PSG,P ƃ}G,P G,   W@ƍFvwWƃ|dWƃFwN$HWƃ|4WƃFw$dh $Pq G,P^ G,1X[^_]ÐUWVSu}LtBj 2ÃV[ Ct{S|Sz1e[^_]ÉU  VSuEPhh  pS j PSF,P  |.Vu&    u   t& 1X[^]ÉU  WVSujjj F0}h$P* ǅ   jS8d fǅ ~(   hҧh   8S	 j PSF,P< Ã b  VÃt&v  F0P藱 F0F(    H  <0BЍ ,($ 
&    AB<	vuPPPWS Sh٧Qi  t'h$P F0     1ҍ0B~04f
PPF0Pm b  h $Pc -  WSF0PV fǅ
  PSF0P  }hD$P    WSF0P jF0P  }'
fPh[$P    P
PBPBPBPPhxh   8S E 0j PSF,P Ã}F0PQ F09    VÃtF0P! F0v F0[^_]U  WVSE@0P߮ B0ǅ   1q]    ߉R,Ѓ     󫋽W,ЃWQj SB,@P  }&A,P. G,ot=PWtRB,P A,.h$P G,P购 G,1[^_]ÉU   WVSuǅ<    1840,jhĨV7X u7^~ u&    C; tC<	vC< t<
t<
t4  <+  C< t<
t<
t  1< t \	
BC  < uƅf ; uC; te  ,DBЉ,C<	v; uC; t/  1< t P	
BC
  < u捅P ; ut& C; t  1< t$Dt& 	
BC  < u捅D ; u
&    C; t  0DBЉ0C<	v; uC; t_  1< t @
BC=  < u捅@ ; ut& C; t  4DBЉ4C<	v; uC; t   K   S   :t :uc8DBЉ8C<	v;:uC<	w=|BC<	v(    <DBЉ<C<	vC; ttH1<
t*<
t&hv    
BCt <
t<
u㍅h 
t
t1f&    C<
t<
t} tJW8P4R@P<R,P0RDPPR\PQEPE)؍[^_]U,  WVS]ǅ    uGUBPR%  MQ0UB0  hʨHt& ;/tMAPQ   EPUB0|  ShԨh  SK j QPUB,Pf Ã} MA0Pި E@0  URÃtJMA0P訨 E@0ۉ  t& UB0P聨 MA0  |    ǅ   @    1MQ0Ѓ1MQ0ЃPQj PUB0@P Ã u@MQ	Ã   UB0P| MA0      +P*PMA0Pd Ƅ( 1URMQ/Pi߃݋)S/PPW  UR1[^_]ÐU<  WVS}} u u
   v WG0   hh,  S j PSG,P ƃ }G0P- G0   Wgƃum} uGEPhh,  S j PSG,PL ƃ}G0Pǥ G03WƃuG0    G0P蔥 G0މ[^_]U  WVSuEǅt    u~ t@} t:PV}3'tPWMQEЋF0P F0   xlpt& lǅx   @        1V0pЃxPj j QF0@P  ku2VUuSF0Pm F01Rh    WF0Ph tPWEPMуt )VX[^_]Ív UVSuU]tF0|u(1 SRP Ã	V؍e[^]US]t^jSheN uGSÃt5SS|CPS|t& S1]]ÉUS]uQ&    C0|P  C0{, |SC,Pۢ C, S\1]]ÐUWVS}utw
t4v w,u5h t'h@$Ph Vht& j2 Ãuh$P. 1=    3C   tWNCt& C    C    C    ؍e[^_]Ív UVSuu1`PFP
Ãuh $P 11FCFtPCFtPC؍e[^]US]tRCtPCtPCtPt> jjSR SX> ]]ÐUWVS]u}  th'S蘵t8wt      t3      h)S[   FPS-   Vwj	t& j RS\h1SF8ujPS4   &    j PSvVwjj RSh5S諴F8ujPS*    j PSPh@$P thhSSFtv8tt ,hjt& hlShnSe[^_]UWVS]u}\  th'SE t5wt       t0tv   h)SRE    FPS@E    Vwj&    j RS\h1SE F8uKjIVwjj RSh5SD F8ujj PSthhSD Ftv=tt%1v hj    hlSRD hnSBD e[^_]USj Ãujh$P 1$t& C        h   R C؋]]ÉUWVS}} u
h  } uh      t.w	tet1tFWt& } t[h \  } tHh`I  } u5h6  &    } uh  Wh   EXu%UBÅuh`   &    19}QCMQ Pou.}    EP   MQh P   F9|C9|  SPCPN CtWj ƃtDCM4~Q
EPUF RMQB  Fh$P 1e[^_]ÉUS]t:CPtP8 jjSL S8 ]]ÐUVSut51;}v FPC;|FPE8 V<8 e[^]Ív UWVSj ǃuh $P 1   UBPz GuKh $Pu W&h $P\ W7 G P7 1   UBGE    9E}mj ÃtGUUBU4FCtP'    FPCC    EE;|e[^_]Ív UWVSu} d  E1;8W  UBCtRw
t  v tn      h&VPV h1V   h&VۭPV賭 h:V辭   h&V諭PV胭 hAV莭jCPV hCVngh&V^PV6 hAVAjCPVn hCV!v CPh`$P= EG;8e[^_]UVSuj
 Ãujh$P 1(tV C&    C        ؍e[^]US]t>tPCtP4 jjSI S4 ]]ÐUVSuu1-FP$Ët
P    ؍e[^]Ív UVSu]t@CPV詫; uhhV诫h5V螫PVe[^]ÐUSj Ãujh$P 1C        h   [ C؋]]Ív UWVSE1uh t& } uh`$P+ 1Kv Xu	1=t& 1;;}0EPC PuCxC<F;3|Љe[^_]ÉUWVS}1} u1Kt& EXt;    {u(F~"tWtCPMPhP҃[uˉe[^_]Ív UWVS} u
h  } u
h   } u
h`  }
w}sEPhr  }  tMU RMQ#  u6} t)EPtM QEPMQhMP҃ E     Epu UBƅuh    EPMQPE1;>   F} t{ tx{ upEPCPRuYURP<uCEtPCP!u(} t"MQtEPMQh`MP҃G;>mF9|  VPFP Ftj 	 Ãuh$P 1   FMKECEUCRECE$C}  tM QtCC    EPUR  ǃtF}u7Wj +t%} tMQtEPMQhMPҋGC_؍e[^_]US]twCtPtP/ CtP/ CtP/ CtP/ j jSC S/ ]]UVSut51;}v FPMC;|FPE/ V</ e[^]Ív UWVSj ǃuh$P 19  UBPz GuKh$Pu W&h$P\ W. G P. 1   UBGE    9E   UBU4j  ÃtGUFCFCFPxCtP    FtPC	C    FtPCC    EE;Oe[^_]Ív UWVS]}   E1;8  UB4hSPSƤ hASѤFPS訤V B	   $hS蝤   hS芤   hSw       h%S^   h-SKqh5S;ah?S+QhHSAhRv hUSFPS
 Rh$P FtwtU<tt"0hS誣4hS蚣$hǱS芣Ph$P ~ thAS]FPSl hCS?EG;8+e[^_]ÉUSj3 Ãujh@$P- 1$t& C        h    C؋]]ÉUWVSu}u
h   uh   &    } u} uh $P ^u:FÅu
h@   19};t& CW PzuWh$PG F9|ɋC9|  SPCPp Ctj ƃuh$P 1YC4W} tEPFF    } tURFF    e[^_]ÐUS]tQtP) CtP) CtP) jjS= S}) ]]ÉUVSut91;}&    FPmC;|FP5) V,) e[^]Ív UWVSj ǃuh $P 1  UBPj GuKh $Pe W&h $PL W( G P( 1   UBGE    9E   j  ÃtGUUBU4tP    FtPCC    FtPݻCC    EE;oe[^_]Ív UWVSu}    E1;8   UBh'VPV֞ { t.h3V۞CPV { t(hAh<V譞CPV脞 hEV菞EG;8ke[^_]ÉUSj Ãujh`$P} 1$t& C        h   B C؋]]ÉUWVS}uu
h  } uh   t& } u
h´   ^0uIF0Åu
h   19}Mv CUR@Pֺu&   W   EPhPwF9|C9|  SPCP	 Ct6jA ƃt#C4EP|UFVh$P 1e[^_]ÉUS]t,CtPB% jjS~9 S&% ]]Ív UVSut21;}FPC;|FP$ V$ e[^]ÉUWVS]}u      S u7{$ u1V<It<i   B<Dt<d   z }      x{
u2FPh2tۋFPh5tAv t:FPG(PR  uS$tFPG(PR  txt1e[^_]ÉUWVSE}t^tZH0u6Qt& K)P    QTRAPj7 1(    19}qt& 9xtB9|e[^_]UWVSEuh:$P Q} u
hQx0u
8    C/1;7}'t& GEPCPƷtF;7|1e[^_]ÉUSjk Ãujh$Pe 1C        h   / C؋]]Ív UWVSu}uh   t& u
hǵ   } u
h   ^4uPF4Åu
h eC9|  SPCP Ct6j ƃt#C4WƵFEFv hC$Pa 1e[^_]ÐUS]t,CtP! jjS5 Sn! ]]Ív UVSut91;}&    FPC;|FP%! V! e[^]Ív UWVS]}u{  u{$ tJFPG(PC P  uS$tFPG(PR  txu
       1e[^_]UWVSE}t^tZH4u6Qt& K)P    QTRAP4 1(    19}qt& 9xtB9|e[^_]UWVSEuh]$P襽 Q} u
hux4u
8    C/1;7}'t& GEPCPvtF;7|1e[^_]ÉUWVSEtAxu
8&    /1;7}'    GEPPtF;7|1e[^_]Ív UWVSEtXxu
O&    F1;7}>    GEPCP足uURP蠳tF;7|1e[^_]UWVSEt=xu	4v /1;7}'    GEPPGtF;7|1e[^_]Ív UWVS}]utC uQVPvu;S$t
VR^u#tWtVhP1       e[^_]ÐUVS]ut-C t&VP-uS$t
VRu@rv
u1	t&    e[^]ÉUE   B<v(B<v!B@<vB(<vw_t	:tQAB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀ:ttu   1]ÉUSEY  ÊB<v/B<v(B@<v!B(<vw_t:t%  t& CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt   t&  t	t

t
uC< t<	t<
t<
tB<v'B<v B@<vB(<vw
_t:u|CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt n	Q
H
?u   t& 1[]ÐUE   B<v@B<v9B@<v2B(<v+w&B<	v.t-t_t:ttSv AB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀ:ttu   1]ÉUSE  ÊB<v@B<v9B@<v2B(<v+w&B<	v.t-t_t:tt5  CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt   v  t	t

t
uC< t<	t<
t<
tB<vAB<v:B@<v3B(<v,w'B<	v .t-t_t:tu|t& CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt T	7
.
%u   1[]Ív U   ]UUEH	wB$R5Rw*t& Rt& R_
t&    ]Ív UWVS}]E   } t	Ex  u1   u
      Ct;PCPRƃutWtPCPhP҃uC   St.t)tWtPCPh P҃E    CuOEP$tE1PRItPj ƃ~tWtCPPhPҋEe[^_]ÐUWVSE   } t	Ex  u1  } u
     Uz   z   8   p_YC   8   V@Pu.} t!MQtVMPhMP҃E    [tG;uVCP蕫u.} t!EPtVMPhMP҃E    t?uG4UPMA Pt5;Et0} t#EPtMPhMP҃E    UPMA$Pt5;Et0} t#EPtMPhMP҃E    EPUR~E    Ee[^_]ÉUWVS}E   }    EH    } t{]S(tq} tk]CtaPRQ*ƃuTEP$tMAP]C(PR ƃu*tWtMA(P]CPh P1  EPFPu-t"WtMA(P]CPh`P҃E    ~uEPURMQW	~u]SEPURW~
   ^MQUB PuRMQUB$Pu8t)Wt"MA(PMAPEPhP҃ E    tURCP¨u4t)Wt"MA(P]CPEPhP҃ E    ~	uX^tURCPdu4t)Wt"MA(P]CPEPh@P҃ E    ~uHURFPt1t&WtFPMA(P]CPhPE    Ee[^_]UWVSu}t"t'Ctu
Cv t   t9w
t      tR      {      v    GPC(P4Ѓu@   GPVEP   tktaGPVEP^   tLt=AGPVEP@   t+tGPVEP!   tu1   e[^_]ÐUWVS]}   t& t#Btu
B捶       WSEPg   WtCwtzt=t@nu=   B   Bvqu<3hu/u31[    3WSEPtt83t*Btu
B捶    t	t&    e[^_]ÐUWVSu]}   th'V [tYCHwI$عC(Ph˹    hѹVR { thAV; [uthhV e[^_]ÐU  WVS]ǅ@   G  S <  } 2  EHA  $t& } 
  MQ  h   Ex t%}   MQ  hE  Ex$ t%}   MQ  h`  Ex, t&}   MQr  h`  Ex4 u'} Q  MQC  h1           }   EP  h     }    MQ   h@   t& }    EP   h    }    MQ   h   t& } t~EPttQh dv MA(tZPR<ǃuSS$tMA(PRǃu3} t!EPtMA(PhMP1  t& G  w
t  tS@    t& Ex   }   MQ  @(PhP҃  UBD  Dx   p(_Wt& u0Ct8uV@P~tO)u	t8th$P< 'v [t!uVCP/u܅u2} t"MQtMA(PVh@MP҃ǅ@    D@D#   U_BDSDPMQ+@t	D tnƅ jSV0ƅH jEPHS } t&MQtSVMA(PhMP҃ ǅ@    wm  ~X  EX$tgFPCPuIV'  CuMA,u})1%t& R@P迟      [uuyVu<}    EP   FPMA(PhMP҃   t& }    EH   FPRUB(Ph UPau)} tZMQtPFPFPMA(Ph@,u2} t,EPt"FPFPMA(PhMP҃ v@([^_]UWVSu}u1   G t8 utVthPӃWklÃtC(utVth	P렐t& PG  Pt^h%G  Puh*C(Pt,KV@G  PC(Ph@P'   e[^_]ÐUWVS} t} t	Ex  u1   &    EPEPEPǋEp$tFj FPEP@UÃSVEPEPEP!ǃ0tSV vuEXtSEPEPM[!ǃue[^_]ÐUWVS}E   } uh$P蘥 1kEX4t^1;3}XC@PEPVu6t+Wt$C@PC@@PhP҃E    F;3|Ee[^_]Ív UWVS}uEtXtTV$UF$VWcÃt2VjPVWBÃ VW!ËEF$v UV$1e[^_]ÉUWVSu}F u~$ ur   Pux t`~$ uZR@Po@F$uCN AttsWtlPh P\tXWtQAPh P>VW|t-V iPVW]Ã VW!Ét& 1e[^_]UWVS}u]t
} tu
   9   tiw
t"                19}$UPh)b   C;|܋M)x    19}UPGP#tRC;|GM>SVEPGPSVURGP
SVMQGPSVEPGPe[^_]ÉU,  WVSǅ    } u} ta} t[} ~U]ǅ    u]{G(PG@ Pƃu/Wz$ tG(PB$Pƃu
  v ǅ    } tE@ǅ    } tUROG h)j GVCMBEzJBtQ	W} tMA	W h   P SFPǅ    9   ǅ    
 B(WGPj ft^1ۋFC;}$MP PޗuӋ
 ME9};W} tMA} tUJGW [^_]ÐU1]Ív UE@$]@UE@$]@UE@$]@UE@]xÐUE@]x  ÐUE@]x$ ÐUWVSE}WURPUBPG} u^  Exh Q  x G  x =  E    1{Å%  U   t    uPV   tPtWEPCP҉ƃuSz   &    VStC$@P7    PS躐~ uWܔFF   F   C$@FC$@FF$    WURS%Ct2{ tP U@     E    CPHC    SyUBUP$e[^_]ÉUEUMPRQz]ÉUUEPBP  ]Ív UUEPBP  ]Ív UWVS}u]MUEPRQSVGP  e[^_]ÉUWVS}u]MUE PRQSVEPG_l@ PS uGd    h t! tWtz  tPRS!Gde[^_]ÐUVS]MUEPRQCsl@ PVr uCd    {h t!{ tStz  tPRVT!Cde[^]UVS]MUEPRQCsl@ PVj uCd    {h t!{ tStz  tPRV`!Cde[^]UVS]u{h t'{ t!Ctx  tVPClP!CdVEPEPjEPCP6  e[^]ÐU]ÐUVSuFPiEÉ^t&FtP͑Ct& C    FCe[^]ÉUS]{h t#{ tCtx  tPClPx!Cd]]ÉUWVSuUEPRǃ} u@?xu5mu/lu)nu#su uj EPF4P?L} tyE8xuTxmuNxluHxnuBxsu<x u6WEPF4P?EP  4  W &  EtPF4PFPf1j WPF4PeKÃt:~ u~  uEPFPlG    EPFPRC~h t4~ t.Vt'z  t!EPSF4PRFlPk!Fd `v SF4PFP7tSEPFPFlPN.t& SF4PFPtSEPFPFlP2tW Et	P e[^_]ÐUWVSuF4E~h tGFx$ u>@ tx u1x u+x u%x uVpth@FlP҃Fh    EPEP詜Ej Rj FPMǃ I  FP,ux,	} uUWV;l} t%MyuWQU
WEPDU}    U   R*8xuxmuxluRPVMCCtu΃} tAU   R*8xuxmuxltRPVMCCtu΋EPWFP.du} tEPEPFP
dPWP>EtP } tUR e[^_]ÉU VS]s4t-{D t'C$PH)щM@EuEPS:{h t'{ t!Ctx  tVPClPZ!CdSje[^]ÉUS]EPCPNPC4PT]]ÉUWVSU}uB4tgPTÃuVWUB4P\`B    SjtVWSIkv VWBOÃSUB4PSe[^_]ÉU]ÐUVSuUE^4PRItCFBFH,u	P,
t& u˅t {uRSSt& RSRe[^]ÐUMUEPRAPw;]Ív UVS]uVC4PCPau&S8~C@DtVPCPaQC4P;e[^]UE@4]@,UWVSu}^4u2C,   H   twPXtpQC(PhVaC,t@utMPXtFWC(PhV7PW袋t/tPXtWC,@PC(Ph VF    	   1e[^_]ÐUMUEPRA4P9]Ív UVSuE^4PFPOt=VJ,u	B,
t& u˅t {uPS*Qt& PSPe[^]ÐUWVS]}uC4PQtxuVWPzht& VWCP"NPC4PPe[^_]Ív U $(,048@D<H\LPTXH\,`dhhlpphtx|]ÐU                                             H,        h    h]ÐUS]tlCtPj CtPW CtPD CtP1 CtP j jSZ ]]Ív UWVSEu1;8}]&    UZVCP蔇u/Ew         MG;9|UB9|5 JPBPn UBuh~萐    MYV+C1> t@F> uCE} tURCC    } tMQۅCC    } t"EP"CPURFCC    C    MC    e[^_]U   WVS=0      01ẺEE͉EEEEE    MFŪt
v CAuMEtt& CAuEPj j jEP0P vh[^_]ÐU0tPt  0    ]ÉUWVS}=0 u01;0}1&    XWCP7u0F;0|1e[^_]ÉUS]C$uh$P؍ 3Pu
l  C$PEPEPEPEPEPR]]US]u
hC uh $Pj 5t& Pu
  C PEPEPEPEPEPR]]UWVSUB t?xt81;7}2_wEPCP   F;7|΋UB$   xt41;7}._wEPCP赃tKF;7|ҋUB$tHxtA1;7};    _wEPCPju
v F;7|1e[^_]Ív UWVSE@$t?xt81;7}2_vEPCPuF;7|1e[^_]ÉUWVSUB t?xt81;7}2_vEPCP覂   F;7|΋UB$t>xt71;7}1v _vEPCPZtHF;7|҃=0 u=01;7}2_vURCPuF;7|1e[^_]ÉU44P8P 8t1&    h~# ]ÉU,WVS]}58E    =< t3h`$PT h$PA <     u1  t& t
{
E=8   4  h   8uhb 1i  Q  t& 4+89~
58ފ<u&FlFtF;   t& >u&FgFtF;v&u&FaFmFpF;\"u&FqFuFoFtF;>'u} u&FaFpFoFsF;B<_v
t

t	uFOy}/Phj	]S ڃO} tSBF: uFB<v

tOv2Phj	]SÈ ڃO} tt& BF: uπ?  8e[^_]U,WVSE}E    u1  &    t
x
EE  EP Eu"hh~{ 1  t& u? j  t& E+]9~#EEPEP  Etފ<u&FlFtF;   v >u&FgFtF;v&u&FaFmFpF;\"u&FqFuFoFtF;>'u} u&FaFpFoFsF;B<_v
t

t	uFOy}/Phj	]S ڃO} tSBF: uFB<v

tOv2Phj	]SÆ ڃO} tt& BF: uπ?  Ee[^_]ÉUSj3 Ãujh $P- 1$t& C        h    C؋]]ÉUVSut71;}v FPC;|FP V
 e[^]ÐUWVSj ǃuh@$P} 1*  UBPJ Gu$h@$PE W 1   UBGE    9E   v EÉƋEp_FCFtP'{CC    FtP{CC    FtPzCC    FtPzCC    FtPzCC    EU;:e[^_]ÉUWVSu}   E1;8  EXBp  $hgV]CPV] hqV]CuCPV]hsVq]$  hgV^]CPV5] { t,hvV:]CPVI] hqt& hV]CPV] hsV\  hgV\CPV\ { t+hvV\CPV\ hqv hV\CPV\ { t(hVj\CuCPV7\hsVB\   hV.\CPV\ hqV\CuCPV\hsV[   &    hV[CPV[ { t,hvV[CPV[ hqt& hV~[CPV[ hsV`[Rh$P老 EG;8Te[^_]ÐUWVSU]Uu}9s=C|	9s)v 9sB9r&    ?ɀ
B9r+U[^_]Ív UWVSM]M}u9sDC|
9sAt& $<u9s9r$?CA¸v +M[^_]UWVS]uE]}E9   %   =   u0;usv%   =   ub  
  	ʁ   9sGv  wCK  wC   C   9r#t& $?C;uL+][^_]Ív UWVS]uE؉EE]uE;u   Fwo   v1   w
у   1   wу      v
   у   ;usq%   F=   u_?	Ouށ  w;]sGfc     w.S;Us&  
fӉȀf'v +][^_]ÐUE8 ux ux ux<u
      <u"x ux ux u          u<Hux<ux u
      u<ux ux u
   ev u
xu   Pu
xu   >Luxouxu
xu    <ux?uxxu
xmu   1]ÉU  WVS]
L	1҉Ǎv :t	B  ~鋵2  u1D      t    u
     v     t    u     t&     t2)    t/    u
	   p  4    t2D    tJ    u         O    t2Z    tf    u

     r    t2}    t    u   k          u
   B      u

         u      &        u
          u
          u      &        u   e    u   E
    u   %    t	   [^_]U  WVSuuh &    L	1ҍ2:t	B  ~
 Q, ƅt3je Ãt ECEC3S  t& h@$PAy 1[^_]ÉU=@ uVh    @uh$Px (j j hhh hO]Ív U=@ tp9HD¡@t% P D@P  D@P @    D    H    ]ÐUS]=@ uuh1    D1~-h $Pw h=h`$Pw @D]]Ív U=@ u1]ÉU  WVSu=@ u[t> uHr&    @a    L	1ۍ3;t	C  ~ 1;D}$@ PVG tC;D|1[^_]ÐUEt:Pt@PRh$Pv t& @Ph$Pv ]ÐUWVS}    EXx    K9v
<
t<
t   	KFO9v
<
t<
u<
t<
uC1t=<
t9<
t5    Ph$CPv Ft
<
t	<
tN~уh$Pu EXv K<
t<
t9t(   h$Pu G9tFO~݃h$Pu e[^_]UVSE1X$t{ uP(~	@0ދ\Shh$PIu E PEP$P
 S t(V#h$Pu  VPe[^]Ív UVSE1X$t{ uP(~	@0ދ\Sh$Pt E PEP$P
 S t(Vh$P`t  Ve[^]Ív USEX${ uP(~@0\S)h$P
t E PEP$Pm	 S@]]ÐUSEX${ uP(~@0\Sh$Ps E PEP$P	 S]]ÐUVSEuX uh$PLs    v hVLPVL { t.h
VLCPVL { t.h{ thVLCPVL h!VLe[^]UVSu]uh@$Pr mhVKLCPV"L j CPEPu!Ãt&haVLSV$L S hcVKe[^]Ív UWVS}u]uh$Pq SVW*[ue[^_]ÉUWVS}u]uh$Pq SVW   [ue[^_]ÉUWVS}uuh$PZq   F
uVW    uDF4  PEPÃ|  SWJST d  &    u;~4 N  hWJF4PWvJ h
      u+hWiJF(PW@J h	   F(P  ÃhW0JF( PWJF$tPEPW(t{ th
WIFH~4 us~ umt{ uhWIF(PWI h
WIF6  @*  !  hWrI  h
W^IF4t,PEP#ÃtSWIS  Ft]Ptt;F thWIFPEPWYV Btt9VthWHVEP'  u/hWHF(PWyH h
WHFt@tthW_He[^_]ÐUSCÅt*EPEPSSEPE SD]]ÐUWVS]u{C
   {  tSVh VGC,tPSV.hVG{e[^_]UWVSu}} tBÅu        2EPSYCjjS( S e[^_]ÉUVSut.BÅt#VSSEPD SCe[^]ÉUWVSRBƅu1QEPVhEP>q Ã t%VS;DǃSm  VPCe[^_]ÐUVS]uC<9C8|: S<PC@Pز C@uh$Pkl 1v S8C@4C8s4C8e[^]ÐUMA8|
PQ8}1)~A@DA4A4    Q8A@    ȉ]UVS]u   9   |@    P   P    uh$Pk 1!      4         e[^]ÉUM   |
P   }1;v ~   D   
ǁ                 ȉ]UWVS1ۃ= ubc   >     Iy1Ҿ21Ʌt<<`=A< t&    C< uC    <2 tb~[^_]ÉUWVS1L]1v U2PEPauGZv1e[^_]UWVS}= u1Cc4`=tbWP)au܉-@< t9֍    &    EP3P`u	   
< u1e[^_]Ív UVS]u<tP<t   PCP҃StP    tPV ue[^]UWVS}u]t(C(PV1`t>VC(Pt
   %v [tSVWu݋[u1e[^_]UWVS}uu   (^tv SF(PWZuڋ[u1e[^_]UWVSu}   v K      PWb_u      Pt0xt*tPXt   PWhFP҃F    tP<t   PFP҃VWtP    PW^ce[^_]Ív UWVS11ۋPEP^uG   v1e[^_]ÐUWVSUUE   UEEEEE    E    R Eu"h
t& hsg 1  }1;E    R<&  z#uUR"  GE  EPEPZ  }   t~   ~V&uB&    E+]9~'U҉UREP萬 E>ߊFG> u;G; EG+]9~'U҉UREPD EߋEP~^UTEUP     t& EGE+]9~'EEPURګ EߋEP$B8 u&j2R37UR:N    EP$B8
uBUB$@   BUB$@   R$B8 uj2R6E9EsEP$B :Et:Et	:E Ee[^_]Ív US]E@  $$tPXthCPC      &      PXz  h@J  c  PXX  h(  A  PX6  h    PX  h     PX  h@        PX  h    PX  hx    PX  h V  o  PXd  h@4  M  PXB  h      %  PX  h     PX   h       PX   h@      PX   h      PX   he~   PXtwh JtgPXt`h@3&    tIPXtBht2PXt+hCPtPXth CPҋ]]ÉUS]thCtP CtP S$tCt	P҃tPGj(jS S ]]Ív US]j(0 u-CT   tPXthCPCT   1E@    @    @    @    @   @        @$    @     @    ]]UVS]uM19}2< t<	t<
t<
u0B9|C$@8<u C4tPuC4x4 t1    P4u   e[^]ÐUVSu]Fu/tPXtFPhCPC    .&    PXtRDtPFPCPҍe[^]UWVSu}j8裚 Ãuh$P_ 1   t& j8S C
   C    C     uuh h`hS
VWhSyC    C,    C$    C(    C    C   C    C0    C4        C    ؍e[^_]ÐU|WVSuF$@1B<v+B<v$B@<vB(<vw_t:t1   EEc   F$PÊ
Qv1A<vA@<vA(<vwA<	   CB<wF$@U  EV$BG8 uj2R/VW3FV$B8
uBF$@   v BF$@V$   B8 8j2R/%WURSx[^_]ÐU  WVS]j2C$P_/C$@1B<v&B<vB@<vB(<vw_t1    S$B >BF8 uj2R.SY2DS$B8
uBC$@   t& BC$@S$   B8 uj2R.     h$P\ n&    S$B8 uj2Rb.S1?S$B8
uBC$@   BC$@S$   B8 uj2R.C$@B<vB<vB@<uB(<jaB<	V.M-D_;:2)|&    C$@B<mB<bB@<WB(<LCB<	8./-&_:VW!Q[^_]UWVSE   UEEE    R Eu%h&    hs[ 1j  EP$B} N  <  } u%B < 5  <	-  <
%  <
  R<&8  z#uUR  G  EPEP*  } uE&EG+]9  U҉UREP} E+t  t~   ~`&uA    E+]9~'U҉UREP  EߊFG> uEP     EG+]9~'U҉UREPɟ EwߋEP读    EG+]9~'U҉UREP} E+ߋEP$B8 u j2R*UR3.HEP$B8
uBUB$@   BUB$@   R$B8 uj2Ry*UB$@8 tEP$B :Et<> Ee[^_]U  WVS]1j2C$P!*{  S$B >BF8 uj2R)ST-?S$B8
uBC$@   BC$@S$   B8 uj2R)     h $PW n&    S$B8 uj2Rb)S,?S$B8
uBC$@   BC$@S$   B8 uj2R)C$@B<vB<vB@<uB(<jaB<	V.M-D_;:2)|&    C$@B<rB<gB@<\B(<QHB<	=.4-+_":VW!L[^_]UWVS]}E        S$B8&-  BC$@S$   B8 uj2R'S4ƃu'tPXthRCPC       j2C$Pr'C$@8;   7VE   S$B8 u$j2R1'S*k&    S$B8
uBC$@   	    BC$@S$   B8 u*j2R&tPXthCP҉7Ee[^_]Ív UVS]S$B <"uiBC$@S$   B8 uj2Rh&j"SNS$ƋB8"      PX   h   <'   BC$@S$   B8 uj2R%j'SS$ƋB8'ttjPXtchSBC$@S$   B8 uFj2R%9v j Sƃu"tPXthCPC    e[^]Ív UWVS]S$B1 <">  BC$@S$   B8 uj2R%C$pfuj2R$SW(BS$B8
uBC$@   v BC$@S$   B8 uj2R$S$B <w<	t<
t<
u
B <"uB <w.<	t*<
t&<
t"  PX  h  B)PV=HS$ǋB8 uj2R$L  S$B8
S  c  v <'  BC$@S$   B8 uj2R#C$ppu$j2R#S'L&    S$B8
uBC$@   	    BC$@S$   B8 uj2RS#S$B <w<	t<
t<
u
B <'kB <w.<	t*<
t&<
t"   PX   h   B)PVFS$ǋB8 uj2R"S*&iS$B8
uBC$@   	    BC$@S$   B8 u/j2Rs""tPXth CPC    e[^_]Ív UWVS]E    S$B <"  BC$@S$   B8 uj2R!C$xot& S$B8 uj2R!S2%?S$B8
uBC$@   BC$@S$   B8 uj2R!C$H t
t
{B<pB<eB<	Z-Q'H(?)6+-,$./:	= ?;!*#@$_%"t"B  PX7  h$  )QWlDES$B8 uj2RH   S$B8
    <'  BC$@S$   B8 uj2RS$z֊A<   F <'   uj2VS'#BS$B8
uBC$@   v BC$@S$   B8 uj2RsC$PƊ
QwA<lA@<aA(<VMFB<v<B<v5B@<v.B(<v'w"   PX   h   F)PWBES$B8 u j2RS"lv S$B8
uBC$@   	    BC$@S$   B8 u/j2Rc"tPXth CPC    Ee[^_]ÉUWVS}E    Ed   jd  Eujdh8  G$P   tPXth`GP҃G    E@;u|#EEPUR E+  EUuW$B8 u$j2RqW L&    W$B8
uBG$@   	    BG$@W$   B8 uj2RW$BЀw	t

t
u4<t/&t*]@x]x>} } uEP,    ? tyUREPWtBzH tYEPEPGPBH@    URh$P}J 2&    zD tEPEPGPBDЃUR蝬 e[^_]Ív UWVS]E    {$wL	<S{  F<Ym  F<S_  F<TQ  F<EC  F<M5     GC$@ < t?<	   <
   <
   tPXthCP҃C    wS$B8 u$j2R1SL&    S$B8
uBC$@   	    BC$@S$   B8 uj2RC$@ < y<	q<
i<
aSKEJ  tPXthCPC    #  s$V<P  B<U   B<B  B<L  B<I  B<C     FC$@ < t@<	   <
   <
   tPXth CP҃C    kS$B8 uj2RS?S$B8
uBC$@   BC$@S$   B8 uj2RQC$@ < t<	t<
t<
zSE   tPXth@CP҃C    pS$B8 uj2RS:ES$B8
uBC$@   	    BC$@S$   B8 uj2RS$B < t<	t<
x<
pB <"t<'uSEEe[^_]ÉUWVS}E    Ed   G$@8<X  x!N  x-D  x-:  jd Eujdh8      E-G$   @G$@-   E@;u|#EEPUR ER  EUuW$B8 uj2RXWCW$B8
uBG$@   t& BG$@W$   B8 uj2RU]G$@w	t

t
u>-}-#-EUD w=	t8
t3
t.tPXtEPhGP҃G       W$B8 u"j2R_Wjt& W$B8
u5BG$@   )    URh$P=D X&    BG$@W$   B8 uj2RtPPtEPGP҃UR7 e[^_]ÐUVS]S$B18&  x#^  xxT     BC$@8;  C$HB<	wt]B<wtHB<wt3v tPXthCP҃C    1}   t& S$B8 uj2RS2?S$B8
uBC$@   BC$@S$   B8 uj2RC$@8;
C$@8;  S$B8 uj2RJ<  S$B8
F  S  v S$B8&q  x#g     BC$@8;   C$H<	wtP3v tPXth CP҃C    1}   t& S$B8 uj2RS?S$B8
uBC$@   BC$@S$   B8 uj2RAC$@8;:C$@8;   S$B8 u j2R
SjrS$B8
uBC$@   v BC$@S$   B8 u;j2R+    tPXth@CP҃C    F=  v)	t$
t
t  =  v
  = w)t& tPXtVhCPC    1e[^]ÉUWVS]C$E       	@	C$@utt& S$B8 uj2RS2?S$B8
uBC$@   BC$@S$   B8 uj2RC$@ < t<	t<
t<
zSǃ   tPXthCP҃C    uS$B8 u"j2RSoJt& S$B8
uBC$@   	    BC$@S$   B8 uj2RC$@ < {<	s<
k<
cj VSlƋC$@w&    S$B8 uj2RRS?S$B8
uBC$@   BC$@S$   B8 uj2RC$@ < t<	t<
t<
zC$@8>t%tPXth CP҃C    S$B8 uj2R
SGS$B8
uBC$@   	    BC$@S$   B8 uj2RCCtPEPVxCtV荟 EtPz t	Wj e[^_]UWVS]E18SHƃ   tPXthCPC    1^      S$B8 uj2RrS?S$B8
uBC$@   BC$@S$   B8 uj2R!S$B < t<	t<
t<
zB8=   S$B8
t6CS$B8 uj2R
S2?S$B8
uBC$@   BC$@S$   B8 uj2R
C$@ < t<	t<
t<
zStzX tVh=CPBTЋE8e[^_]ÉU,WVS}E    E    E    W$B8<  BG$@W$   B8 uj2Rj2G$PWE u'tPXth`GPG      EPWW$B < t<	t<
t<
  W$B8 uj2RBW?W$B8
uBG$@   BG$@W$   B8 uj2RW$B < t<	t<
t<
z-  t& </u
y><     Mj2REPWƃ   1;]}jVUP0uKtPXtVhGP҃G    V进 EC  P訛 2  ;]|} u-E
   j(t Eusj(h>    E;E~VEESUR? Eu2Sh$P8 }   MQ   EU4@EEMAM    D    nt& W$B8 uj2RB
W
?W$B8
uBG$@   BG$@W$   B8 uj2R	W$B < t<	t<
t<
zE;   u'tPXthGP҃G    "B <w<	t<
t<
u
J<>UR-PW tP8tMQEPGP҃} t21;]}UtP褙 C;]|MQ菙 } tEPz e[^_]UWVSuV$B8<ux/t+  PX  h FP  v    BVǃG  uV$B8 u"j2RoVJt& V$B8
uBF$@   	    BF$@V$   B8 uj2RV$B < {<	s<
k<
cB <w<	t<
t<
uB8>t'tPXthAFP҃F    DV$B8
uBF$@   BF$@V$   B8 uj2Rc   Kx   PW,u5tPXtWhYFP҃W萗 F       WV   PW., tE   t;WP,t*tPXt   PWhFP҃F       tGWP+u6tP<t
WFP҃VtPЖ t	W e[^_]ÉUVSuF$@8&   x#u@V_EffE   PD   jEPFP   EPV} ujhrVR@D   t~   ~AtcPDt\jhrFPҋEP8,PEPFPCDЃ0( EMA tPDtjQFP҃EP蝕 e[^]UWVS]􋃄   Pe)Ƌ   E   j2C$PC$@8<ux/uS"   PV)t&E;   |   V    t& C$P:<u6z!uz-uz-uS7    A8<uS   A8&uSj S;   u4{4 tAtPXthCP҃C    &    j2C$Pt	V8 e[^_]ÉU,WVSuV$BEE       ~D t+BB EBE􋆄   P'ÃV7   M ;   uQS(t} u=V$B8>  BF$@V$   B8   j2R  tSf EPgÃu)tPXtMQhFP҃F    F$H9/uy>u   B  B8>uRV$B8
uBF$@   BF$@V$   B8    j2R7   &    tPXtMQhFP҃   F    PEP0'u'V VÃ tSA }   ~D   F$PH)щP U@EF4EEPV]  tL{ tFtP<tEPFP҃VÃ  S貑   t&    P%E   t& F$@ <w<	t<
t<
uV9   }ԋV$B <wp<	tl<
th<
tdtPXtMQh FP҃F    VV=Ã tS } tREP D} t>~D t,BJ)B EBEF4EEPVSEP蜐 e[^_]ÉUS]C    j2C$P   P,   h CPqS$B8 u!j2RSIt& S$B8
uBC$@   	    BC$@S$   B8 uj2RSC$@ < t<	x<
p<
hC$@8 u%tPXth!CP҃C    C$@   { uj j 7CSS$B{S$B8 u"j2RSJt& S$B8
uBC$@   	    BC$@S$   B8 uj2RSS$B < {<	s<
k<
cB8<  x!ux-u
x-C$H9<   y!   L	A<D   A<O   A<C   A<T   A<Y   A<P   A<Ew   SdiS$B8 uj2RbS ?S$B8
uBC$@   BC$@S$   B8 uj2RC$@ < t<	t<
t<
z{ uj j 8CStP4t	CP҃{ t
1    ]]UWVS]^  h   Sҡ jhe ǃuh@$P}* jhW蛡 jJe C0uh@$PE* C(    C,   C$    C    C    CCx    j(d C@C8    C<
   C4    j(d    ǃ       ǃ   
   ǃ        u;   [C    C   C    C    CD    Ch    ǃ       ǃ       CHP~e[^_]US]   t& PSuC@tP\ S脽u䋃   tP6    tP  C0tP
 CtP t=tP SՊ ]]ÉUWVS}h   Gc ƃuhc( iv Vsj(c Ã t4j(SI C   C   {{SVt& hcs( V2 1e[^_]ÉUWVS}EEMM]]G$E   MqQ)      9~]u
Cv A@} t^} tXHUt& ]8
uH} t]8\u9]8\u0} t	]8\uǇ       MAY)É)B9|   [^_]ÐUWVSuF$E  UuMRЋy+At& ]HSy+C)ǉЅ  VxBm  $    	   
|   
   q&    V$B8 uj2RVr?V$B8
uBF$@   BF$@V$   B8 uj2RF$@ < <	~<
v<
nEtP,th FP҃UBHM8<   !   F$HL	A<DunA<OudA<CuZA<TuPA<YuFA<Pu<A<Eu2} uj j j>VO
  VFx   	  j j FFx   	  V$B8 uj2RV?V$B8
uBF$@   BF$@V$   B8 uj2RQV$B U< t<	t<
{<
s]u
S{HE]Py+C)ǉЃ	  PU<4  !u>x-u8x-u2} uj>j-j-V  VwFx     <  }!   MQ
L	B<DurB<OuhB<Cu^B<TuTB<YuJB<Pu@B<Eu6} uj j j>V>  V Fx     t& <M  }!C  	  5  V$B8 u$j2RV1L&    V$B8
uBF$@   	    BF$@V$   B8 uj2RsF$@ < y<	q<
i<
a]uS{HE]Py+C)ǉЃ3  PU<uW!u>x-u8x-u2} uj>j-j-VB  VFx     <u}!u	  Fx     V$B8 u#j2RVK    V$B8
uBF$@   	    BF$@V$   B8 uj2R3F$@ < z<	r<
j<
bMu
Qy+A]HSy+C)ǉЃ  PU<uW!u>x-u8x-u2} uj>j-j-V   VXFx
     <u}!u	  tPXthFP҃F    FT   FxP  P4E  FP7     M#  8<tFx     } uj j j>V?     P5ÃV   E ;   uWStuMV$B8>u(BF$@V$   B8 uj2Rei  Sс X  t& tS軁 W迴Ãu&tPXtWhFP҃F    F$HE9/uZy>uT   UBtP<t
WFP҃VoÃS% t& MA8>uHV$B8
uBF$@   BF$@V$   B8    j2RJqtPXtWhFP҃   F    PWSV?V覲Ã S\ { tP<t
WFP҃VSÃS	 ~| t<fE  F|EtPDtjEPFP҃F|    ǆ       S  ]CPU<u|!u>x-u8x-u2} uj>j-j-V\  VFx     <u4}!u	  }/uFx	   ǆ         Fx   &u+} uj j j;V  VH  ~(u%  } uj j j<Vi  ǆ       j V>  F  } uj j j>Vs)  V    uFx
   ,v Fx   t& h $P Fx      h@$P Fx      h$P Fx   ~t& h$P Fx   ^t& h $Pq Fx   >t& h@$PQ Fx   t& h$P1 Fx   ǆ       N$M=1e[^_]Ív UEj P ]UWVS} ~|} tvEH$tl9tfxxtyWAq)ƃ+URMQWEP$@ZUB$pp} uB$ @xPv&MQEPUzxtMQR[} tsUBxt^
t7t2tPXthMAP҃E@    @T   UzxttP4tMAPҋE@xUe[^_]BTÍv UWVSuEP|Eu1^  h   jT Ãu	EP[h   S莐 St_=tP{ jhT ǉ;u!URm{ Sd{ 1   t&    } tEC} uǃ       UR   SdǃuSZ1y    } u
G    MQ$ GE@ GUB GWS\} ~$} tC$t tMQURP ؍e[^_]Ív UWVSU}tEPRÃu1:v t;ECSst
    C    Sse[^_]Ív UUEj j PRu]ÐUWVSj EPǃ   h   KR ƃuhc    t& h   Vb Vbj(R Ã tcj(S8 EP虄 CC   C   ;C    G CG CC$    SV&    hc3 Vx 1e[^_]ÉUWVSUEuPRÃu1:v t3ECS{t
    C    Se[^_]Ív UUEj j PRy]ÐUlWVSuEE    EEǃ} ttjdP Ãu1}  C     C$    C(    CD        CH    C    C    C    C@    C8    C<    j j j p  UCLCP    CX    Ѓtzt80t-@80t(@80t#@tt   t   u@@+E@PO CT H  URPN C\ 	t& 9tV>ruC\r<wt<auC\wB<	wЉE$fuE   huE   GFuC\   <wuGj8hEPjjjURS
  ƃ h   &O CHC   u5}   h   N CDj8hjS@  ƃ uS{D tMC   4b      } }EPUR     EPUR C@S@uS  t& {\wu0jj j j j j j jPPhRg C`
   Si  C@P1 +CC`؍e[^_]Ív UUEjPR]U VSu|%Vh]S; VEPSv 1e[^]ÐUS]t{\wtF{ u/SHC@SPh   jR =   tC8C   EPEPSo  ]]US]{< tdt& { uO`      C@Ph   jCDP Cu!C@C<   P  tC8륐CDK ]]ÉUWVSu1ۿt& V[;t/tFtFFX   ~ V8  CvVÃV
 utF8   1ۉǃEeEeEv VCvt2VÃVÃ rVu} tV{tu} tt& V[tu} t1ۍv V;Cv1~< tF8e[^_]UVS]1u
   CPtPr { t$C\<wuS   
<ruSm<  ƃC@tP, t`^ 8tC8}ƋCDtPEr CHtP2r CTtPr t	Sr e[^]UWVS}EEt\rt      G8tu
  u1  G8  EEGEGm  X tY_G9vÅt&WSPR# E؉EG)_)_W@  G@PRjEPB )G(   uR< uL]      G@Ph   jGDP GuG@G<   P *GDj WG<  G8   G+EPEPGLPi  GLGEW;   ;GLuW*  ;Gt	G8;W,8 u?_wW9  _wj j j ti  GL 8 u< u
 G+EPEPGLPAi  GL)}Ee[^_]Ív UUjEPRuUЉ]UWVS]}ut{\wtmC8Nt& ;s{ t?{ u$SHC@SPh   jR =   uCj SP  C8tVWCLPth  CL+se[^_]ÉU  SUEPR S ~PSEP.1]UEUUjURPuUЉ]ÉUWVSuE    t~\wt    t& F8   F    J    EPVS
  F8uuF8    E    F8~ uuE   w6   +^t$F@PSjFHP0 9uFHF~} tF81҃tЍe[^_]ÉUS]EPS	uC@PR C81҃tЋ]]ÐUVSu]E      ~8   F8    F<    ~\wunu+^   ~D uMh   E FDh   P '     ؃PFDPV3tZ)Å֋F   u^|@~X t#FDF    j SF@P |lF9sVe   }	N)ÅtE~H u;h   E FH&     ؃PFHPVQ~)Å֋Fe[^]US]t{\rtKCDC8    C<    C    {` tS5  j C`PC@P C@P 1]]Ív UEjj P"]ÉUU1t	z\ruB<]Ív UWVS}]1W%   Pj F~e[^_]UVSuVÃVyÃ VhÃVZuF8É؍e[^]ÉUS]u
Gv {\wu5jS#u#CLPC@P,CPC@P S]]ÐUVSuUup  F8u
  t^t; u   +F8`FPtP0j FTtzt8*t-B8*t(B8*t#B
tt   t   uBB)ى؃tzt8(t-@8(t(@8(t#@tt   t   u@@)؍TR+B FTVPPRt hFPPr SFPPr FPe[^]ÐUS]MUEPRj jjjQS   ]]ÐUWVS]}U E    t 8u}$8t
  tsC    {  uC $	C(    {$ uC$@	}uE   }	E   ߋEHw(}u"~} |}	} |}~
^  h  jC(PC Љƃu8  t& sEF   MUF$HF,   FDHFL	%~(NHVPjF$PC(PC ЉF0jF$PC(PC ЉF8 jFDPC(PC ЋMF<     j  PC(PC Ћ  N    F ~0 t~8 t
~< tuxCS  :&    $ȉ  R  MEN|   FS
  e[^_]Ív UWVS}]]E    } tEpt
t~*t
   v SWUB0P^  UB0   F$9v)]}F0SWP+} V0NP^d^T1F@R1#FLF@]9]w@NPF@F0^8D81F<#NL#V,N@HMfSV@F<f<PG;}v1e[^_]ÉUSUtZtz  tz$ ukB    B    B    B,   CC    C{ }C    *   { tq   CB0   C     S   S  1]]ÉUWVS}]E    t"wtu   	w} |}~zF|@(U;(t tjW   E9^|t5^|U D
Fx
   D
   D
FtE   Ee[^_]ÐUVSUuZJJBBB[^]UVSuNFY9vÅt5VASPRz F^XF^)^)XVz uBBe[^]UWVSu}t7^t0+|'~ t> u~ u{  utpF  ~    C 3E{ {*   K(C|Hv   	{d t B))ЍHCq   QS{d tF2PSF0PS F0   { tV~ u   ~ u
;}uC=  u~ t|F      ~ u{l u   =     C|@(WSЉBwC  tu~ ujauguS%  7v j j j S\  u#SDC<fDP  S<CDHPRv V~ uC 1Qu{ uAF2PSGF0PS9 V]C{        e[^_]ÐUVS]tCtp*tqt  t
   C@tPC(PC$ЃC@<tPC(PC$ЃC@8tPC(PC$ЃC@0tPC(PC$ЃCPC(PC$C    1que[^]Ív UWVSu]FEttu
     h  jC(PC ЉEu
f  }{Euǃ  Ej@$PC(PC ЋUB0jB$PC(PC ЋMA8 jADPC(PC Ћ}G<j  PC(PC ЋO0Ɖw t8 t
< tuS5   E]P0C$PRQbv K8}C$W8PRQIv K<W<CD PRQ0v KWCPRQv GWK)Ћ  ȉC$Ɖ  Rщ  ف     ߁ǀ	    t
  (  1e[^_]UVSuE^9vÅu19F)^x uSPF0PV  F0SPEPgu ^؍e[^]Ív US]C$SDC4C<fDP  S<CDHPRBs C|@ TSx   T   DCtCd    CT    Cl    Cp   CX   C`    C@    ]]Ív U,WVS}GtEWd_p   O0Ew$9v  )Ut& E    W8UG,EGdG0  ETUE拇   9GprmGl9EvEUW0E8   E8D   8   BA8   Bu!t& AB8u=AB8u5AB8u-;Ms(AB8u AB8uAB8uAB8uAB8tE)Ⱥ  )9~EGh;]}-TU3EEU#EBUE9v	M'Gl9w[^_]Ív UWVSu~$Vl^4Fd))Éuuu}   uqF$89rbV0WPRr NDF<)~h)~d)~TH9r)ff  IuF8H9r)ff  Iuz tVSFdF0FlPRFlFlv^0FdNPV@D1#VLV@~l  wx e[^_]UWVS]}  C9      SlKTSdSdCl    t9rA)SlCdj )P|C01PS`  CdCTP x    STKdC$)9r3j Q|C01PS  CdCTPH x ty{lPS
{l :tUPSTCd)P|C0	&    1PS  CdCTPx u1   u   e[^_]Ív UWVS}E      v=OPW@wdG0_8D01G<#WLW@#w,PUfs_@W<GdfZ} t.WdG$+U9w   tEPWGXGX   PGhWd)PW  EGXWl)Wl;GxwhvcHGXGdHOdOPW@pG0_8D01G<#WLW@#w,PUfs_@W<GdfZGXPWXuGdX    GXw0_PGdGdGX    0W@D1#WLW@"G0WdPj WV  EOlGd} tAj WTGd)P|	G01PW  GdGTP x    Gl=  AWGl=  w} t]}PWTGd)P|
G0    1PW7  GdGTPjx u}1   }u   e[^_]ÉUWVSuE    7  v=NPV@NdF0^8D1F<#VLV@#N,PUfKN@V<FdfJVXFhVpF\FX   } ta;Vxs\VdF$+U9wJ   tEPVFXFXw&   tuFhVd)=   vFX   Np   9NX   VdFlxAPF\@)RVT  EVlFpB)VlFpFdPVd9w:NPV@F0N8D1F<#VLV@#^,PUfYN@V<FdfJFpPVpuFdF`    FX   PVd}    j ЋVT)P|
F0v 1PV7  FdFTPj d~` tkFdV0DPj Vn  t8j VTFd)P|F0t& 1PV  FdFTP
 FdNlx u1   F`   FdNlFl=  VFl=  w} t~` t!FdV0DPj V  F`    }PVTFd)P|F01PV   FdFTPSx u}   }u   e[^_]ÐU]ÐUS]ǃ           ǃ  	    ǃ$  0t
  (  ǃ0  Dfǃ    ǃ      ǃ     S   ]]USM1   f  @=  ~1t
  	  t& f  @~1f  @~fǁ   ǁ      ǁ      ǁ      ǁ      []ÉUWVSUE]MT  ۋEH  9   UP  M9}/E{}4}f9r
uU8w]u}ET  f9r%uU8v}U]ۋH  9~E}MT  <[^_]ULWVSEUHM@M4  ]puPU@EE    1MЉfp  F~]uځT  L  fD  L  GÚ<     EЉEŰMDDp;u~uEEft;]KU1fr;]|U+EE1u  } tuDЋE  G<  z}    EЋMɍ&    uUNf<p u]Nf<s tfpfDpfUϋutbEЉE܉U܍NrMԅtBẺE؋UO;M,ET9t)ЋUU  EftKuċuԅu[^_]Ív U,WVS}u1   MːfDVfSB~1;]2΍    DtP0Rf0  fC;]~֍e[^_]U,WVSEU EBM18@EEǁH      ǁL  =  9}YUT  MP  &    ]f< t&MH  XH  Mut] EfD  F;u|UM]P  4  H  T  UM]b֋UXH  T}
EE    Uf  E  tUD)  ]H  ~EMUBH  H  ~V]SEPN]UUMUX  H  X  H  jMQEPIUX  L  HL  MUtL  PL  M|UffEP8rQMEUf\f\X  jPRMCH  1L  X  ZL  M]DSEPPURMQ]Se[^_]ÉUWVSEE1   HE   uE      ]ufDE    9]   Et
  Ev ]uGL;}}9y   9}	Uf<7t;Et]fuf
  
Uf
  
]f
  1EuE      9uE      E      uE9u][^_]ÉU,WVSuE   @EE       } u
      ]E    9]T  t& }]}}\]E9U}}G}9]  UBU9E   ]]썾t
  }E싎  0v
     )9~dUENVf	    
NFVf  
  F   )f  D  "&    U]f	    M\  &    }   9M   U  2v
     )9~^2t
  NVf	    
NFVf  
  F   )f  D  v 2t
  f	    M  
     )9~\
  NVf	    
NFVf  
  F   )f  D  
  f	         ~X]NVf	    
NFVf  
  Fۉ)f  1  v Ef	  ;  }
#    
     )9~Z
  NVf	    
NFVf  
  F   )f  D  
  f	         
~e]NVf	    
NFVf  
  Fۉ)f  󉆸  UBUB  v Ef	    ]C]    
     )9~Z
  NVf	    
NFVf  
  F   )f  D  
  f	         	~b]NVf	    
NFVf  
  Fۉ)f    }G}"v Ef	    E@EME    } u      #t& U9Uu      
      ]}]9[^_]ÉUVS]  P   PS&   P	  PS (  PSp    v
  f< u I~1f< t  DI  ȍe[^]ÐU,WVSu}  ~cEE^ыVf	    ^FVf    F]   )f    Ef	      ~[_NVf	    
NFVf  
  Fù   )f    ]Wf	    U􋖸  ~_}^ыVf	    ^FVf    Fߺ   )f  􉆸  Ef	    E1HE   U썎	  M;}   v
  E  
~eU NVf	    
NFVf  
  F   )f  󉆸  %t& U f	    G;}fMQEPVAURMQV0e[^_]ÉUWVS]}u  
~[KSf	    
KCSf  
  Cƹ   )f  󉓸      f	      
$D   jWEPS  e[^_]ÉUWVSu  
~[^ыV   f	    ^FVf    F   )f  󉆸     f	    "$E     +E9~]~V $f	    :~FVf  :  F   )f  UD   $f	  M    
V	      B)ȃ  
~_^ыV   f	    ^FVf    F   )f  󉆸     f	    "$E     +E9~]~V $f	    :~FVf  :  F   )f  UD   $f	  M    
Va  ǆ     e[^_]ÐUWVSu}]E    ~| ~b~uV    PV  PV V;E    

9wSэC9wtEPSWV+  9     
~]}^ыVf	    ^FVf    F׹   )f  󉆸  Ef	    h$h  V>             
~e}^ыVf	    ^FVf    Fߺ   )f  󉆸       Ef	    E@P   @P  @PV/	  P   PVd         V} tV      e[^_]Ív UWVSuM]    fP      u
f   < '  If     w	 %
 &f0	    E~|~k  udËFTVd)U  1ɉ}􍆀	  E}    A8@Ӄ~ދE9Esm;]s     H9E[^_]ÉUWVSuE       g    UPE  <BU}    ]   \]  )9~`EVNf	    
NFVf  
  F   )f  UD    ]f	  M  t& U 'E  U싎     )9~gEU  NVf	    
NFVf  
  F   )f  ]D  #v U]  f	  M쉎  E~     + (   )9~VNVf	    
NFVf  
  F׹   )f  D  f	  ى  M}   wE %    E &EU]     |)9~WNVf	    
NFVf  
  F   )f  D  U]f	    E@   ()E     )9~UENVf	    
NFVf  
  FU)f  D  eEf	  ى  U;  ]       )9~^   NVf	    
NFVf  
  F   )f  D  t& U   f	    ]    [^_]ÉUWVSu111Ɂƌ   t& B~B~   t& B   ~U9B[^_]Ív US]M1҉؃	I[]ÐUS]  uBKS  
KCSf  
Cfǃ    ǃ      4&    ~(KS  
Cf  f    []ÉUS]  ~"KS  
KCSf  ~KS  
Cfǃ    ǃ      []ÉUWVSu}]Vǆ     } tBVFNFVf
VFFшNFVf
Fr    NV
GFse[^_]ÐU帍)]U   +E]`ÉUUEPR" ]ÉUEP6 ]ÐUUtBu=t& B    B    B    1Ƀx t   j RB@Pj  1]US]t
Ct{$ u	/@t
SP  CPC(PC$C    1]]UVS]uEt81u}8t   u   C    {  uC $	C(    {$ uC$@	jjC(PC ЉC   @    C@    }C@   FvSUCp   PC1҃x u	RS  CPt
SN1Se[^]Ív UMUEPRjQ]Ív UWVS]  {   ;   }   EC
  $ *v SO  }tE    JSCCPtC 
   CC)@   똋SB;Bv
   CC)@   kv    C  }tE    HCsCB8N))9t
   CC)@       u      CC  }tE    HCSC BC    C  }tE    HCSC BC    C  }tE    HCSC BC    C  HCSC BSBC0        t&  
   CC)@      t& URS@P  EuC 
   C@    }t}  }    ]  E    CPRS@P  Cx t    N        }uEC   }tE    HCSC BC 	   Cth}tE    HCSC BC 
   Ct4}tE    HCSC BC    CuEf}tE    HCSC BSB9Bt
   CC)@   @      	t& e[^_]ÐUWVSu]߃} tUBt8t
ev SVj(  U;B0t	DEP@0   ؋Jt   X)SVBP  UB    1e[^_]UWVS}tGu
   v 8
t 
   G@    _u
   GPMGEw+   :8*uBt1)ЉAKtvډ+EEGG_Pu"_wWG_w    1e[^_]ÐUEt@t@u	P!  ]ÐUVS]uUtC8wCPF(PF$Ѓ;u-VCP!  VCP   VCP  C$C0C,C4    C    C     tj j j ЉC8F0e[^]ÐUWVSu}j<jF(PF ЉÃtMWjF(PF ЉC$t'C(EC4    j VS    SF(PF$1e[^_]Ív U\WVSEUM E܋RU؋y qY0]ԋA,9s)HEEP(+UԉUЋM	  $ +} U  ]E    M؉	C]܃vԋ]St7r      두)ދ]   qEPEPEPEP  EPEPEPEPEP_  UB0u2z r]؋MYE܃+AE܉MԉJ0j]SR  E@    @        U   M]	   C*y qE؉CE܃+CU܉]ԉY0jEPQ  v } &
  UE    M؉	BU܃vԉ%  9tB]E	   @*{ sU؋MPE܃+A]܉UԋEP0j  MQ11u1y t   v    ]} u:EUx pB    E܋]+BM܉
EԋUC0RMQS
  }    ]K(9Mu!C,S$9tU9s
)HE+MԉMЃ}    UԋEMP0Q]SP  EEU@0EԋB,9Es+EHEЋB(M]ԋA(E)]9Eu"MQ,I$9tM9s)JU+EԉEЃ} u;]{ sU؋EMPE܃+A]܉UԋEMP0Q]S	  EE    X;]v];]v]ЃSURMQk@ U])]])]ЃB)؉BK1z t   M4t& }   ]E    M؉	C]܃
vԋE?  Xw
vAUM	   A*z r]؉YE܃+AE܉MԉJ0j]SR    jSUB(PB ЋMAu8y qE؋]CE܃+CU܉]ԉY0jEPQY  &    UB       MA
9Asf.&    } 6  ]E    M؉	C]܃vԋ]C@*CCC
9Crʋ]UC]Uw$@*t& ]C    CCvEU@   RMQ]S@P  ÃtbUBPMA(PA$Љ]u	]	   Ex pM؋UJE܋M+B]܉UԋEP0Q]S  E@        UZ؃  ]JM9  EX9s1    }   UE    M؉	BU9rՉ#]SX@EĉUw!)ދ]MċSCCN  t& E   }t	EăEE   }uE   U̍9s.E}   ME    M	E܃;urՉ)ދ])#]]̋]UEUȉ  9w}   } umEPUR=  MAP]C(PC$ЋE 	   C*x pU؉SE+CM܉Eԋ]C0 jURS%  v M]AT1ҋM]̋AC]MuYEX؃  MA]E9]SUBPu  MEA    E	   E   YPEPEPEPEPAPAP  P  UÃ0BPMA(PA$ЃtEu	E 	   Uz rE؋MAE܃+AU܉EԋMA0SURQ  MQEPEPEPEP   uT]SEP  SEP  Ex pU؉SE܃ +CM܉Eԋ]C0jURS  MAEAEA   ]{ sU؋EMPE܃+A]܉UԋEMP0Q]SP  Et
PSE  UE    RMAP  ]SUBP
   SMAP
  EU]܃@E؋z rJ0MԋB,9s)H
]C(+EԉEЋUz u    v	EM܋M   Eԋ]UC0RMQS/  EE[0]ԋUB09B,t5z r]؋MYE܋]+AE܉MԉJ0SEPR  U   My qE؋]CE܃+CU܉]ԉY0jEPQ  v Uz r]؋MYE܃+AE܉MԉJ0j]SR  EUx pB    E܋]+BM܉
EԋUC0RMQSd  ]EU{ s@    E܃+BM܉
EԋUC0RMQS(      ]EU{ s@    E܃+BM܉
EԋUC0RMQS       ]EU{ s@    E܃+BM܉
EԋUC0RMQS       ]EU{ s@    E܃+BM܉
EԋUC0RMQSk]EU{ s@    E܃+BM܉
EԋUC0RMQS4]{ sU؋EMPE܃+A]܉UԋEP0jQP  e[^_]Ív UVSu]j SVRF$PC(PC$Ѓ VC(PC$1e[^]Ív UVSuU]F$SRPu6 ^$^0^,e[^]Ív UE8]ÐU  WVSM EUE    E    E    E    E    E    E    E    E    E    E    E    E    E    E    E    UuE9EuU        1*  U   } uE    Cw< t􉝰9sǅ   uEt< t싅9vǅ   ӥ;s%E)x,Cɉ;rދD*)y
F  D*|Eĉl1ۉxxtuM|lǅ    `t+`    `E9r|lxUǅ    ǅ    ǅE    ǅ    ǅ    9  L(I  &    9  )9v+   M$I(pM$@I t9v6J+L(;st& )C;s9wǅ   ӥj@PpPt҉u# tM$QEP  w  EM@    M` tR|0	Ɖ؋+닍ƋD4؉|9;0֋Ul*	ƍ9r
Ev ;Es =   v`щΉ]+U]P΋<+   ⋍닍Hh`H\;s4ى|;r鋍\   ㅝt1u1|`   H#;t9   )|H#;űh9D1 ttH[^_]UWVSEu}]SVWj j jjP u
C-#t> uSP  C-e[^_]UWVS}u$VEPURh ,h+h  WEPcÃ uU: uBu
F .      VUP8  F@.   &    VEPU Rh -h,j EPUPÃ uE8 uj  vbu
F_.:t& u VU P  F|.tF.VUP  	&    1e[^_]UU+E ?]U  VS= 	  ǅD  ǅh	ǅl    Dp1H   @=   ~=   ډ	   @=   ~=     @=  ~=     @=  ~O   VhOhOh ,h+h  h   Sr1    @~O   VhOhOh -h,j jS5   OEOEOEOE1([^]ÐUVSu]1҅t(CSډÅuZRF(PF$Љڃu1e[^]ÐUEjjP(R@ Љt    EBEBEBEBЉ]ÐU,WVSEUMpUIM@ UMERUY0A,9s)؍x	Ex()ߐ	  $.     }	   MUJ EBMUJEM+BEUZ0QRFPFPFPFP  EEUM  ERUI EUM@EZ0B,9s)؍x	My()߃} t}   	   -FFFF   FE9Es3}   UME    M	EEBUM9r͋UE#VJm)MuBF   &    tFBF   t& @L   t   iM	   A.UEP MHUEPEMU+AEZ0j  NM9Ms8t& }   UME    M	EEBUM9r͋UE#Fm)MFFFF   FE9Es:&    }   UME    M	EEBUM9r͋UE#VJm)MtFBF   2@uFBFM	   A.UEP MHUEPEMU+AEZ0j      NM9Ms8t& }   UME    M	EEBUM9r͋UE#Fm)M   E+P$F9s)ЋUJ()M])E~      E@(E9u UB,R$9t9s)؍x})߅usMEY0PURQ   MEY0A,9s
)؍xA(
v UB()9u&MQ,I$M9t9s)ڍz	t& )߅  UE    OMBUC;Q(uA$EFPV       MI(M9uUB,R$9t9s)؍x})߅   MEY0PURQ8  MEY0A,9s
)؍xA(
UB()9u!MQ,I$M9t9s)ڍz)߅u>UEP MHUEPEMU+AEMZ0QEPn  E    FCO    aUMZ0QEPRy  UEZ0MA09A,t9EA UQEMAE+AUMEY0PURQ     EMA UQEMAE+AUMY0jEPQ  MUJ EBMUJE+BEUZ0jt  t& UEP MHEU@    E+BME
UX0RMQP5  UEP MHEU@    E+BME
UX0RMQP   UEP MHEU@    E+BME
UX0RMQP   UEP MHEU@    E+BME
UX0RMQPxv UEP MHUEPEMU+AEMZ0QEP9t& MUJ EBMUJE+BEUZ0jMQR6   e[^_]UEUPB(PB$Љ]ÐUWVSE}@Ew,G09w_()UB9vÅt
}uE    U)؉BZW4tSVG8PҋUG8B0SVEP" ]G(ރ9uiw$9G0uw0U_0)B9vÅt
}uE    U)؉BZW4tSVG8PҋUG8B0SVEP1" ]ދEUBEw,e[^_]ÐU<WVSEUM ERUI EUMM@ER0UA,9sQ)HUuUE)uP MHEUupE+BM
UEP0     t& MA(+EEUUUU}w'&    UMM	EBUMvEU#Et  Om)MM  u#4wm)]}w UMM	EBUMvEU#E<Om)M   W}M)I$M9]s"t& MMM	EEM9rE#EU؉m)]}+E9rU+U؋MBABAM)])ËEP()9v)ދMBAMKuEP$MBAMNu   t& @uUG#<    E@ /Wt& @u;EW#<Om)MMGAMMYt&  E@6/uMU)uJ EBUurE+BM
UEP0O}  v
}	uEM)uA UQMuqEU+AEMJ01[^_]ÐUWVSEu}ɉ          v  )׃       FFFFFFFFF	F
FFF
FF˃rtFJuT/T/U+UU)U+UU)Ӆ	ˉ[^_]ÐU`/]UVSUM]u1   ҃v}`/23A23A23A23A23A23A23A23Awt`/23AKu҉[^]ÐUE@ÐUSUEËJ uBt0	)B0t  	t0		Ћ]UWVS}E  @ u ۃS:  Ex   OfW@tG9  fWW} u_t0	>&    _ށ t  	E
t0U
t& U	ډ@W@fzu
fJfJB9}fJB9~fJAG9~EO@ffE@ffEfWFf9U~ffGfG$ B  jWW  fG    fO      GEE	t,)  \  
  
  E  t& qEE})UEE$ u	GF9Et
G9EM  E0 E;]  &    fW@tG9   fWOE} uWt
ց 	;	4Wց t
  		Et	0MM	щ΋E@G@fzu
fZfZB9}fZB9~fZ4SG9~OO@ffE@ffEfWFf9U~#ffGfG$ u jW.V  fG  &    fW1҃  _;]  W
  O@EGF9E~GEM$   jWU  E      Wh
  EGF9E~!M$ uu      jWU  E    gH  } K  Mg2  E0EEE uE_fW@tG9   fWWE uOt0	6OME t  
&    M	f t0	ыE@G@fzu
fZfZB9}fZB9~fZCG9~HO@ffE@ffEfWFf9U~#ffGfG$ ujWRT  fG  f_1҃tE8 EfGEf1҉Ѝe[^_Ív U WVS}E  E  @ u ۃS;  Ex    OfW@tG9  fWW} u_t0	2_ށ t  	E
t	0UU	ډ@W@fzu
fJfJB9}fJB9~fJAG9~HO@ffE@ffEfWFf9U~ ffGfG$ N  jWR  fG    fO  GEE	t,A  l  
  
  U  t& qEE})UEE$ u	GF9Et
G9EM  E0 E;]  &    fW@tG9   fWOE} uWt
ց 	;	4Wց t
  		Et	0MM	щ΋E@G@fzu
fZfZB9}fZB9~fZ4SG9~OO@ffE@ffEfWFf9U~#ffGfG$ u jW>Q  fG  &    fW1҃   _;]  W  O@EGF9E~+GEM$   jWP  E      E      Wi  EGF9E~%M$ uv  &    jWP  E    gE  t& } C  Mg*  E0EEE uE_fW@tG9   fWWE uOt0	0OME t	  M	f t0	ыE@G@fzu
fZfZB9}fZB9~fZCG9~HO@ffE@ffEfWFf9U~#ffGfG$ ujWRO  fG  f_1҃tE8 EfGEf1҃t
Wi  E    Ee[^_U WVS}E  E  @ u ۃS+  Ex    OfW@tG9  fWW} u_t0	2_ށ t  	E
t	0UU	ډ@W@fzu
fJfJB9}fJB9~fJAG9~HO@ffE@ffEfWFf9U~ ffGfG$ N  jWM  fG    fO  GEE	t,A  l  
  
  U  t& qEE})UEE$ u	GF9Et
G9EM  E0 E;]  &    fW@tG9   fWOE} uWt
ց 	;	4Wց t
  		Et	0MM	щ΋E@G@fzu
fZfZB9}fZB9~fZ4SG9~OO@ffE@ffEfWFf9U~#ffGfG$ u jW.L  fG  &    fW1҃   _;]  W  O@EGF9E~+GEM$   jWK  E      E      WY  EGF9E~%M$ uv  &    jWtK  E    gE  t& } C  Mg*  E0EEE uE_fW@tG9   fWWE uOt0	0OME t	  M	f t0	ыE@G@fzu
fZfZB9}fZB9~fZCG9~HO@ffE@ffEfWFf9U~#ffGfG$ ujWBJ  fG  f_1҃tE8 EfGEf1҃t_0G0   Wd  _0E    Ee[^_ÐUWVS]uE} tVtRE    }71эY$> t$PFEPuUK׋EPc  Ee[^_Ív UWVS]Mffyu
   }1ۋE8 t	C8 uMAωM)@9~Åti@MQ@4    PMQM    P> fFftf9~f~f~tVMD9}Of~MQ2c  1e[^_USp   u
8  tPC  á	p谕 ؋]ÐUWVS]   f3fuf{fC@tf;s}$fC@ufuf;sf;{~aSEE@S@fBftf9~fzfCfBǋC9w    u19vS.b  1e[^_ÐUE3UMUp$  tRjQPRjQPp@  踲  P  ÐUMUp   tRjQPt& RjQwPp<  k  Pҽ  Up(  u,  u1&    P莽     Ív Uthؗ
jchؗ
j pfxP   	@P,  njp@PPR ¡	(  ta	(  f  pfxNtE	@N$  nǀl     n@P- ¡	   u
L    px% t	n@Ph3	n@Ph`3    1UWVS]M}f]fMf}f]f9~fMfEf9E~f}uf9u}f;]}EEˉϸgfff}}+Uuff9]uEf   uf     f1#ME)Eu4u    Й2ME)Eu4u    E  u)u)MЙ}ǋuf>f9]u%EU)Љ)    +MxTf9]u(EU)Љ)    +M   &EU)Љ)    +Mh  оh  ffEfe[^_ÐU0WVSEU]]؉֋]f]f~`ɉMM;
n}O
	0   tJf}   f} }fE }䡈n9|f u]։]9|8f} t0  f|}䡈n9}f} |]։]9}ЉE	É](  }f<x    ]X;E   ]= 	}ЉE    A   E    uq@1E    Ault& ]؋%   ;EuH0f~ufVfV"    F9}fVF9~fVE   = 	}B]C9~} t}Wa   	]ЃEEMA9EM	(  ]}fxp4   tdx% t
3    `34  tB}TRTRP][TRTRP}WV-  P胸  1e[^_ÐUWVSE}}Mu}f}fMfu=p}0   t2f|-;n}"f}wf|f}
f|f}~
   }% tD
	[҉   P   P   REPEPEP^8	   [ҋ}f<	   fL	   ftp0  tEPEPEPSR  PR  1e[^_U塠px# %   ÉU1pfzNt9fzPt2<   t	@   u    t	$   u	8   t   Ív UWVSE]u}f|;
n~Pt	   IfBft	   IfDBft	   IfDBf1e[^_ÐUSEM]f|;n~	3t	(  fDPft	(  fPf1]ÉUSU]u>p(  tSjR     8  tSjj #SjSj    p8  tSjRP8  P蟵     EPEPP} tUfEfEfUf} tf} u0t&f} uSj)f} uSj f} tSEP f} tSEP]ÐUM	p  t!PBt9JPu
        u1ÉUS]t
St@t& CtjSPu 	tjB@Pj RdL  S0  1]U	ǀ     1ÉU	ǀ      1ÐU	t ǀd     PX  4    '  ÐUWVSutxVE1FuM1ېt& F@FE;Ew
M;EvF@fD  V@fFfDGF9~f  fF  fVW  1e[^_ÐUSp8  u
   tP  á	p耉 ؋]ÐU   WVS}  	f\  f   f`  f9   WJ  uG tGuW8  
	\  A8f\  f9`  u^f ufǁ\    Bf\  	f^  f9\  ufǂ\  fǀ^    f\  f`    &    f       f               h   xVW~  j
cM  1э\9vCP@M  K9w
	\  A8f\  f9`  uf 	t& f ufǁ\    Bf\  	f^  f9\    fǂ\  fǀ^    |  v WH  uG tGu	Wa6   uSO<}	  ~>	  ~D    f\  uj Qj踴    8    17&    j 	D  j脴  u	VP  Ѓu)W  Ã  uF	PL  Ѓt      SK      	f\     f^     ƅw jwP2gH w@   	^  8	fǀb    f\  uf^  f`  f\  f^  f ufǂ^    Af^  	f\  f9^  u	fǂ^  
	\  A8f\  f9`  uTf ufǁ\    Bf\  	f^  f9\  ufǂ\  fǀ^    f\  f`  Df ufǁ\    Bf\  	f^  f9\  ufǂ\  fǀ^    	   t   tuΞ  
	f\  ft]f9`  tTӍA84f ufǁ\    v Cf\  	f^  f9\  ufǂ\  fǀ^    SNv 
u|   t
      }   u   t   
GuSW؍h[^_ÉUWVSE	x,   f
 tc	f`  f;^  u>1ҡ	8    B   ~	fǀ\  fǀ`    fǀ^    	f\  G
  ?	f\  tf^  f9`  uEPuj    
	f\  tf^  f9`     f^  u
   E jEP1E u@w
	   	^  84	fǀb    f\  uf^  f`  f\  f^  f= ufǁ^        @f^  
	f\  f9^  u	fǁ^    `  A84f`  f= ufǁ`    @f`        	f\  f`  f^  fufǀ^   Jf^  	f^  f9\  u:1ҡ	8    B   ~	fǀ\  fǀ`    fǀ^       tt& 8_tu
	\  A8f\  f9`  u_f= ufǁ\        @f\  
	f^  f9\  ufǁ\  fǀ^    f\  f`  
	Jf= ufǁ\    &    @f\  
	f^  f9\  ufǁ\  fǀ^    f\  f`  Ѝe[^_ÐUWVS]}U9U   MU } t~3SUWURS
  jURStUt& E    t{C;E}j S9|tWURS  Ee[^_ÐUdWVS}um  MĉMQ9  	|  M  M  M  E*    訖  ב  E  EuMOMW@  x  G w  i  
t
t  tW  u1}b  fGf9U  $ K  j
W;  E9t  t  u*;u  MQVMQMQMQW&ƃ   E9u4;u   MQVMQMQMQWƃ;uw   t&    } |+E;E|
[   F}u~MSWu(gj WjVMQMQMQWƃ AfW@t/$ t"G9EufGf9uM} E    fWW,  WAÃzfG  gff;G}@fWv,  	M|  M  M  M  MQ   t1e[^_ÐUWVS}    M@Q@<fq]KfAf9~fGftf9~fwfGftf9}f_} u	
dpMMQMQEf9|ӋMfKf9}1e[^_ÐUS= us   h 4 Ãt; u455 S  uSh
45$6y jk h*4e  |H  ]ÐUS]; tMt& jh34S t(jh94S tjh>4S u   C; u1]U=`P uH`P   O      fJyp   t0Zt
OÉU1ÐUWVS=OT  1ۍu   )PPM1-= tÃvF f   @    E$%   t*	t   t*t5   @   u@   e@    U@A  ӁOtBv LP@u
cx |
b@ u
bEt
JEt
JEt
JF߉BF߉B=LPtO1e[^_US]u
=`P    t[=OuSh  臁  hD4  	ǀH  8	ǀL  @	ǀP  X	ǀT  	ǀX  	=Ou
hM4  	p-y ]UWVSЁOtZ]&    ELP}u#]f; |C#O%  1#  EM~&    }OtELPEI1u       ]C9F   C9F   ^]Â      ]K49   U49tE
9tiOt]t^   t~ }F$F   O@tF t߀@F   t]fuLPt^]t& EO9U1u'  f>  ]f;  LPtكOf9   FA  tiAA  t_Ott$A   tAtA   f=O }A@t俀̀A   tffFtoAA  teOtt$A   tAtA   O   tA@t
   A   tfuLPt^]&    EO9U} t>O]f;tCu]ځOtZ]t& ELPMuǁOtB&    LPf8%   e[^_Ív U=Ou=O tj ÉU=Ou=O tjÉUWV}t8=O t/=OtPLPЉ   f1	t& e^_UWV=u   =LPtOh  9  e^_ÉUVSuU1ۅtOu=`P u17&    =O t %O%   PO؍e[^ÐUWVS]Mt<C`)1s9(S
UU9UCE9|C91e[^_Ív UM	tD  |
D     Ív U=O %   UWVS}E    tz} tt} tnM1M} t)GW`G
SVWȉM'SVW tGW`)G
)E   } t
MM1Ee[^_USU]Mt/|+B9#|B9fJffB$ fB1]ÐUWVSEuu
@B    v Ê   $   {<   j>S}R mtnT;@	DxtX4ɍGP$/.uC`4P<$]E*uV$C>uX4	ڀ  CR}MMm]Eme[^_Ív USuuÁ@B t	  ELș}É؋]Ív U塠p   t	@HPj R裏  P  Ív U塠p   t	Pܚ  	ǀx  ǀt  p  tǀp  R  ÉUW
	px  ~_ Й	     	   
ǂ     j p   ¡	  j p   ¡	  j p   ¡	  j p   }¡	   j p   [¡	  j p   <¡	  j p   ¡	  j p   ¡	    j p,  ¡	  ǀ      p\  tj Q¡	  p
	   u     jjj	  j  PY¡	  jjp@  @  P/¡	  jjpD    P¡	  jjp0    P¡	   jjpL  迌  P¡	  jjp   蕌  P¡	  jjp  k  PZ¡	  jp   ;¡	   jp   ¡	  jp  ¡	  jp   ¡	  jpT  ¡	   jjp(  蠋  P¡	  jjp4  v  Pe¡	  jjp  L  P;¡	  jjj ph     P¡	   jjj    P¡	  jjp   ̊  P¡	  ¡p   t1I1ɉ  	p   t1I1ɉ  	p   t1Iv 1ɉ  
p  t1   t'RQ tpǀ      ǀ|      R}ÐUj 	@HPjj  	p  t
j臀  p$  t	P  j
  Ív U8  WVS]ǅ    ǅ    } tE  9]/  ǅ@B 
p  t9} t"EPR*  REPc 
p	  9]c  E)0  tQ	9  }=} t+PS踈  REP 
p	      L  	  ;-  } tE  
p	     1I} t}эQv 1ҋ=    }   u֋K   PV K Z  +]L  tQ	9  }=} t+PS[  REP 
p	         	  ;   } tE  
p	     1I} t}эQ    1ҋ=  wP} tFu֋K ~1t& PV K @B @B   } t}1ыELME9E  ǅ@B 
p   t9} t"EPRЅ  REP	 
p	  E9E7  E+ED  tQ	9  }=} t+PS^  REP 
p	        1ƅ  }    1;}=
	A$P@E@4h  &    E؋09   C;|} t 1ы\1;}0=	E@4    G$@@Uʋ0CA;| 	     &    	   p   1IэQ=  wI֋K ~-PV K @B ;n  } tPEP M  E+E@  tQ	9  }=} t+PS'  REP` 
p	         ƅ   	     1IэQ=  wFK ~4&    PV K @B ;}} tPEPe @B u@B [^_ÐU  WVSu;uuE9Eu1  =	_9]|EEM9]   MAșO9   C))wp   thؗ
j QԌ  &    5 j
p K} ~8p   thؗ
j Q蕌  5 j
kp E    	CH9~9M~Mǅ    ǅ@B EPUR  À  tfQ S 
	  ^  }T  }~+A9E}])yۋM+Myٍ#     }t;jUREPURVj @B t;}ǅ   tRp    tDjEPURj Vj W@B t#	  ;}ǅ   p    tEjEPURj j j @B t#	  ;}ǅ   p    tNjEPURj 	@HPj @B t#	  ;}ǅ   
py tpy uj~f    t]jUREP	RJR~Wj 8@B t/	    ;}ǅ    J   ujEPUREPV   u/p   S jEPURj V	  zu0p   SM jEPURj j 	  AuFp   S jEPURj 	@HP	  Sjv ƅ  ~} ~p   S p   S jUREP	RJRW1эLQ @B thؗ
j P肈  1    ȍ[^_ÐUWVS}  fG     wP   VE);GLuV
E);GHu1   t& W.  Et|WvW  W,  F
)EMQF)EMQW+  Ãt1j GPGPj j j j WMQ
  Ã$t	W,  MQuÉ^WU	CH9WUCH9} |} }%&    MfOMfO
jG@Pj W  e[^_ÐU   ÐUWVS]}uEPWdh PSw  z  p   t`4   t"R4  * upǀ4      p0   t'   0   upǀ0      =    q   pfx6t@6qq   pǀ       ǀ0      ǀ       ǀ       ǀL      ǀ       ǀ            pfxD ~	=n~0nt&hx(
~	   )Pp  t4		    WqPqP  u
	1P  nt%pfxD ~5q5i  Vf ¡	Vf ¡	PVyf Pp  	1ɋp  00u
    ȉ  	ǀd      1ɡp   t	   u6H   u<   u	X   t 8   u,   u	    t     k  	@,    vEb  q  pH  <  ?@  <  P  j  	e[^_ÐUWVS}   	p  1Ʌ   9z   up  RN Gu,1Gu$1ۍv G@tP( FG9~w@ W ;= 	u
 	    ;=u
    ;=	u	    ыVe[^_Ív UWVSu}|o|k} |e} |_} u
	I)M
	} u	Y)]UA9(UA9j WV]S]S  Eu1   ]SE    ]9]}j1j]Sd ]C@tƋC@8]4    9s%}&        ]S@]9rE]9]|Ee[^_UWVSM}E   }       }    } |z|vUU]sF9b9[]@9Q} u	EH)ƉuuGM)UBtE   ]SUB
PBEPQ]S   ƅu
1`    UVL~H]CFCF1;M}3}1REUB@U]^@;EA;M|ދ]^Pe[^_ÉUUB
M)PBM)PuuRUWVS}uue~C} ~=jj臢 Et*jdjt ÃtjWc C@u
S 1  fC  f  NfufsuNfufsufsufs
	fBfC`ufsC    C    } u#1B9u
B9EȉK&    C    C(    C,   C$    C     C8    C<C0    C4    CHCLCP    fCD  fufsFfCTfCVfCXfC\fCZfC^19}(fufu1ҋC@fD  C@fuftA9|} uSUU
	A9u?fSփfs} uA9u
} ufSE	R9uK	p  u^p  ؍e[^_ÐU	ǀ|     1ÉU	ǀ|      1ÐUWVS} t} u  }ff}}ff}f9}}}_}W])UE    }_}W}fw
}fG
f9}ȋ}
}M)}E    }O
}
}}f9}|U)]&    E    f9|u)1}G}G9)ډ)؉Ë}G}}G9)uPSV}W}W}W}W}W2   e[^_ÉUjuuÉUj uuÉU$WVS]uMy }f} t	E E} tA} t;M )}G@9'UU$+UG@9MA9E 	A9E$~       uڋ} 9   vEREE    ]u;]$zMM}}MI@M܃}( t1}9 tJMA@}89t9#UU'&    MA@}8M}܋9t
E   FC;]$~} t&j} t
MA@Pj }W}  EEEM 9M11e[^_ÐUEPu5w   ÐUEPuub   Uuu5TtEPu52   US]uuS%t
EPuS   ]Ív Uuu
#  ¸t
PRuUS]; 	uC   .  .v S*   u{ t	@   `.  C    ]UWVS} t	MAt
  ufv
fuMfY	B9At"jA@Pj Q  	uFBMABQ  uffNfMfE  f^`f]Mf;N   v 	fuf;r   ƍ@R@<E@MQ@EfPftmpuE9~EfUUIMuM;t,fGfu
fWfWf9}fW
f;W~fWfEB];]~ufFfFfEfEuMf;q/My tA    	@   uF 	ufFffF`ffF
fFfBF B 1e[^_ÐUWVSMfMMfMMA   E}    uMMω+E9|8v4    MQ@M@MQ442 K+E9}҉+E9}IǍ[4    &    1ҋMAu#uMA@MMBMA9~C9|uMM}    ˉ+E98I<    MQ@M@MQ44: C+E9~҉+E9~BEv<    1ҋMAu!}MA@MMBMA9~K;]j+uFPMQMQ  e[^_Ív UVS]ut {$ tt;SFCD)99~ ShPCFPCDPVSS@  1e[^ÐUUuEB$1ÐUWVSE		p]  	B  	B$	B($  n,  nn<     ؍e[^_Ív US]t3sS蘫 ]Ív US]	=	 t"v 9u
x  x  x   us s$s(s,s0y   t	P (  t	P |  t	P   t	P s]  SԪ ;	u< 	    	        n    n    	    ]Ív U1ÐU1ÐU   ÉUÍv UÍv UWVS]u}f]fuh  j莖 	L  	x  	jW袀  	pBfXfXfpǀt  ǀx  ǀ|     ǀ      ǀ      ǀ     fǀ\  ǀd     xǀp  hh4  	  ǀD     ǀH  P#
ǀL  X#
ǀP  `#
ǀT  l#
ǀX  t#
ǀ\  ǀd      ǀh      ǀl      pfx< ~;  ¡	  o 8  с4  pf@<ǀ      W  =	<  n   	ǀ@     ǀ<      ǀp      ǀ|      ǀ      j j uuV]S	p  j j VS 	U  		B$ 	B ǀ`   w
	@    	@    1P=P       x    }8j 	@)PVS   PMQR@3j j VS   PMQR@С	fX	f)X     H
Gx GPj j V	@qP@t	P(ts  s  1e[^_ÉUUu1-=PsUP@    1Ív UEu1u}	   PÐUWVSu   =n   j j VtF@Pj Vj j V
	ʋ  1fx    1t& tg=nu^  @t8j V>tjFVC1PV&    j1VԤC'PVʤ
	Cʋ  @9|e[^_ÐUWVS	     jj蔑 ¡	  u      	  @    	  @    	  @   	  pf@Df=n      fB	  pfxD ~fXHfXFv =n      fB5	񋱐  Fn
~
v       
  f@fFj	  @Pc ¡	  P	  z    B@PBP) ¡	  PU5	򋆐  x   E    fx    E      @]}8	  BDEB]\8	  @|}Pj   @]ts 	  P@9ED
]E5	򋆐  @9E\n     }G@U)UE   1E    ]f{ ~TE      @}L85	򋆐  @}t}uMAEE苂  @9E|=nN  ]S5	7       P@)E}}E   1E    9U   1ҋ  @L5	u싆  @}uMAE]싃  @9E|        x}@)EUUE   1E    ]9]}XE      @}L85	򋆐  @}t}u
Mt& AEE苂  @9E|   	  ]Xuc5	  tS@tP覠 5	  @tP芠 5	  v 	ǀ      1e[^_ÉU	  t,@ 	   	  p  ÐUWVSu1F9   1ۍ&    V> u|    |
    
pfyD ~5=n,AD9   tvW  e^  Pi  xtn~1Pv	t  t	V@B=n
   v    PFtv蛨V@BVD FG9 pfxD ~~ t
  t&   h  e[^_ÐU	t
  u#x uP	  pp1ÉU	t
  u#x uPO	  p1ÐUMUtA9}A@Rf|%   ÉUSMt'1Q9ӋQ@f:t   
@9~1]Ív UWVS}t} |} |	G9E~r]u9}c[    G9QG@uuu} ufD
    fD  W@} tfGfD
t& fD
C;]|1e[^_ÐU  WVSj   9ui  ]S  jSI  jSA   WSj j   jWw  ƃuSؾ  jS  j Sj >  讲S踾  jS  ujS  j Sj  ǅt    txPx  ǅ   VSj诺  j Pr  $j Vj蕺  lO  h  J  j Wj褼  [^_ÐU   VSuFwdtxP  E    ǅt   j SV.  u1	t'Sw貱	ǀd      x  uj_  v U	tǀt     x  uÉU   S]tPj S謹  u&tt
uuj uS膹     1pÐUS=Q    } uP   h`QhP&    P=P tj h`Qj$  ihPƼ  DQ    Pd2
Sj2
GQP1
SjSjP0
Sju
Q   ]ÐU	f^  u
   v f\  fudfǂ\    	f^  f ufǀ^    Bf^  	f\  f9^  u	fǂ^  f^  f`  	7fufǂ\   Hf\  	f^  f9\  u	fǂ^  \  8E1ÐUWVSE    E    	th  pf{< ~4  !EE	tQf{R ~J1Ҿ4{R|4    <0t(Et E   =   u
E   	t& !EBvƋ
M9M  }   	} te
]#]0u#u t	l   t=u9E%   9uM   t}u} tMQMQW`}      @ t/p  t MQjP:b  %t MQjp   b   	t
l   h  `  9           t& p     }    utyMQjEPEPEPEPEPEPEPEPEPRU  (P$a   	t
l     x  9u   t}uT  } Z  MQMQW诪7    @ t  tMQjP`     t$p4  tMQjPn`     t$p0  tMQjPB`  t,p   tMQjP`  E0	 	t	l   t<t89u   t}u} tMQMQW譩  @ tp   tMQjP_     tp   tMQjPq_      tp   tMQjPK_     tp   tMQjP%_     tp  tMQjP^     tp  tMQjP^     tp  tMQjP^     tp  tMQjP^     tp  tMQjPg^     tp  tMQjPA^     tp  tMQjP^     tp  tMQjP]     tp  tMQjP]      tp  tMQjP]     @tp  tMQjP]  	} tM
tMh  	M
1e[^_ÐUhؗ
uÉU
p        t       t        t      t      t      t      t      t   	l   tÐUUu1J@@RÐUS]{0 t	S{4 tSN  ]ÐUWVSu}    MIPM   ]M9YHu	9qL   } |l|h} t]CMTUJ} t]C@9<
t& 0} t
MAT0V} t]C@9~nt& MQ   ]MYHqL1tAB}B][@]M][@vM    ]MFG} tŋ]C@9|1e[^_ÉUUuEB41ÐUWVSU   BP   ׉EE    Gu{E    _@]ut3u|OEGL@]S@u]T3GHEfyt	A;E~ufqfytA9}fQEEG9E~PGPEge[^_Ív UWVS}    uvPu   V1uF   E    uFLuv@u@    f| |\UuV@u\uFH)ËuL)uF}19~fztB9~fZfztB9}fJEGuF9me[^_ÐUS]t'SPtCCHPCLPRT[Puڋ]ÐUWVS}t$G
PGPG@PG@Pƃu1  fGfFfffGfFfGfFfGfFfG
fF
fG`fF`fOfNGFGFGFG$F$G F G8F8G<F<G0F0G4F4FH    FL    FP    fGDfFDfGFfFFG   EE    FuI1ۋV@G@MQ44{ V@G@fDfDV@G@fDfDEF9E~e[^_ÐU
	A;QAQ9~MQQA9~QBQ@QP5Q;  Qu1*t& Qtuu5Q5Q; QÐUS1ۡ	fb   uC@|"EEf@ j jP[ ~   t	fǀb   p%- 1]ÉUWVS}5p~	 ~   }~ t~u `}
	E09h  tP
	qe   ]S-: 	x  p    P
V               RU  px t~u	 `
	09h  tPo
	q   V9 	x  p  tRpU  p  ]U  3  t&     t	,   uT   u
4     
	AQHEUh    @ u
t~ uj 
	]S]Sx  t  	t  ]x  W  
	AQxrh    @ utpx uj A
	VWx  t  	t  x  j
	B@A@R@TR]  e[^_ÐU塠px t	ǀx  ǀt  *x	 t	ǀx      t  
	x  Ív UWVS
pM   	  h       };_   	BH9t  uBH9x  uSg&    px t
~u0ۃ`09h  tP	rS7 	x  
p  t	PR  	P9x  |EM}7M	M}   	BH9t  uBH9x  uQc]졠px t}~u0ۃ`09h  tP'	rSJ6 	x  p  t	P+R  	B9x  G  =  t& E   =p}M9M}EM9uE}9}|M      	    9E   y$ tE%  t   E%    E09h  tP,=p}MQ}  E  PDQ  M9M}m	t  ]x  h    @ utpx uj 	SVx  t  	t  x  !       }h   F  	M;  1  x  B9؉΅tN}}E M9h  tQ+=p}VMMe   }WMh  D  P5P  	x  t  BH9t  uBH9x  u
MQXg]졠px t}~u]`09h  tP	rS3 	x  =p  t	PO  	B9x     U   1;u   M	UBH9t  uBH9x  uSbpx t
~u0ۃ`0}9h  tP	rS2 	x  p  t	PN  	P9x  |F;uJ}M<})M}    1;u   M	UBH9t  uBH9x  uSbpx t
~u0ۃ`0}9h  tP	rS2 	x  p  t	PM  	B9x  |F;uI1e[^_ÐUWVS}	    9U	    EM9M   E)@;E   1;}   v MM9uB~;U~w))PMPw	h    @ utpx uj 	SMQx  t  覿	Mt  x  1FC;]f)}E@PMPe[^_ÉUVSM	BH9t  uBH9x  uQg    ˡpx t
~u0ۃ`09h  tP	rS20 	x  p  t	PL  	B9x  |e[^ÉUWVSj 	fb  ftHfb  d   u	t   t<  	d   t/|N  蟰(  	PT  С	ǀd      E     	x u	x t"|   	@    	@       E     	Q	@@9UE   tY  }W  E1ۃ9   1}u  E    	B@f|0u 	@@f|0tS  E	B9B@fD0	@@fD0 	B9B@fD0Ћ@@fD0C;]a]
	A97[    A@fD	@@fDC
	A9~Ջ]
 	A97[    F@fD 	@@fDC
 	A9~ӡ	x  u{f@fA 		f fp	h    @ utpx uj 
	VSx  t  	t  x  	h   tj 	rn  		RPj1e[^_UVS
    px$ tQ    	H	@@9R  V  1ۃ9}S  C9|e[^Ív UWVSE    
	΋x  1 	t  R@@}98t8E   
	CA9|ǃ}   }}E }9h  tW
	A+x  9     p   
	AH9t  uAH9x  u}Wfv ]px t~u]`09h  tP
	qS@+ 	x  p  t	P!G  	B9x  |NH    p   F  e[^_UWVS
	E09h  tP~
	t  hؗ
A)Pp   F  
	x  A9}*v     	@@}<B
	A9|FC9}DvE1f{ ~#] 	@@}<B
	A9|EFC9|ōe[^_ÉU WVSuu	P
	A@9Í4    uuvA@@DEp      x$ tE% 
t& E%    Rtu;5RvuVP)   Rh  u5R19} Ru4B9|]K]x^	@@E5 Ru[    5 	uEu<M u"uF@uu<M t]Kyɋu9u|+u9u   p             	h    @ utpx uj %	j uVx  t  	t  ǀx      uVDuu
	|   t.   t%|    C
	A9|ߋEe[^_ÉU@WVS	P@uvU 	R@EE    
	|  t  t=p}ĉ} tM    tDE    A9E}4Euu]0ҋ}09tE   EEu9u|E    }    h    @ u
t} uj 
	j uVx  t  聵	t  ǀx          px$ tP    R.	@HPj }WuV}W	  A9E	  E]U9uEu9u|A9E	  }胿     u}Ā$ t% %E}   1Q9}ӋUu92u@9|1Q9}UU}9:u	C;]|  9G  A9   9  |h    @ u
tu~ uj 3
	j }Wx  t  	t  ǀx      U09h  t	Rp   ~suh    @ u
t} uj 
	uV}Wx  t  胳	t  x  U09h  t	Rhp  @  9]}u}u0E9]|
	A9E  A}DE5pu܀~$ t%  u   E%    AHE}9~&u}9uMu9u}9}l  h    @ u
tu܀~ uj 
	}WuVx  t  T	t  x  }WuV}WuV}Wu)u}   P      AHEċ}9~u}98uMċu9uAHE}9~u}98uMu9u}9}.  E)9    h    @ u
tu܀~ uj 
	}WuVx  t  V	t  x  u;U   MAH9t  uAH9x  uRdӡpx t
~u0ۃ`0}9h  tP
	qS" 	x  p  t	P=  	B9x  |uVq"  t& }9}d  u}u9u@   t%  
	7  h    @ utpx uj ,
	}WuVx  t  	t  x  E+E	;     }WuV}WuV}WAt`]C
	h    @ utpx uj 
	SuVx  t  f	t  x  }W5  u9u|}}uĉu}WuV}WuV}W  uu؋}ĉ}ԋu}u9u1}ċu}u} t} tMMċ9t}9}
uĉu}}u9u|{h    @ utpx uj 
	}WuVx  t  Y	t  x  }WuV}WuV}W
	u9uM  }9}|u؉u}ԉ}ЋuFűh    @ utpx uj 
	}WuVx  t  赭	t  x  ]+]p4   t	9  n       t6,   t-	     U  +U93W&    T   t	E  +E9
.?B &}WuV}WuV}W  t& u)u}Wu}DPR  o  u9ui  ]Ch    @ utpx uj 
	S}Wx  t  x	t  x  MȋU  )ڡp(   t
9  0       tE  +E9   ?B    uVS}WuV}Wt`]C
	h    @ utpx uj 
	SuVx  t  襫	t  x  }Wt(E0u9h  t	P|})}ċuV  
	A;E~!+EP}    uREP e[^_Ív UWVSp    tK	U09h  tR
p   #8  	ǀx      ǀt               	ǀx  ǀt  Ëh    @ utpx uj }	j j x  t  S	ǀt      ǀx      U09h  t	R0p   Y7  /      u  	ǀx  ǀt  É1f{    }}E h    @ utpx uj 	j Vx  t  苩	t  ǀx      }9h  t	Wnp   6  F	C9lh    @ utpx uj  	j j x  t  	ǀt      ǀx      	1fy ~BE    1fy ~#M 	@@}<B	C9|EFA9|ōe[^_ÉUWVS}up4     hؗ
VVR@*  P5    t& px t
~u0҃`
	09h  tP
	qS: 	x  p  t	P5  Nuz        ,      R4  p   x t
~u0҃`
	09h  tPq
	qS 	x  p  tRx4  p\  tR`4  pNr,  C4        pT  $4  px t
~u0҃`
	09h  tP
	qS 	x  p  tR3  p\  t	P3  N_1e[^_ÐUS]p(  thؗ
SSP	(  Pp3  #    rp   ?3  s]ÉUS	tX SuK S	 ]UWVSu]U}g  
pȃ      ;u   9   	h    @ u
ty uj e	j Sx  t  =	t  ǀx      U09h  t	Rhؗ
j p  T2    &    }          9   	h    @ u
ty uj 	j Vx  t  荤	t  ǀx      U09h  t	Rnhؗ
j p   1    &    
pȃ8      ;u   9   	h    @ u
ty uj 	j Sx  t  ֣	t  ǀx      U09h  t	Rhؗ
}Wj Wp8     ,      9   	h    @ u
ty uj _	j Vx  t  7	t  ǀx      U09h  t	Rhؗ
}Wj Wp,  $  P@0    v       ;u   9   	h    @ u
ty uj 	j Sx  t  ~	t  ǀx      U09h  t	R_1;]   hؗ
j p  /  C;]|   t&        9   	h    @ u
ty uj 	j Vx  t  ǡ	t  ǀx      U09h  t	R1;]}6    hؗ
j p   .  C;]|	&    1e[^_ÉUWVS]uU}[  
pȃ      ;]   9   	h    @ u
ty uj 	j Sx  t  Ѡ	t  ǀx      U09h  t	Rhؗ
j p  -    }   X      9   	h    @ u
ty uj P	j Sx  t  (	t  ǀx      U09h  t	R	hؗ
j pX  ?-    
pȃH      ;]   9   	h    @ u
ty uj 	j Sx  t  v	t  ǀx      U09h  t	RWhؗ
}Wj WpH     <      9   	h    @ u
ty uj 	j Sx  t  מ	t  ǀx      U09h  t	Rhؗ
}Wj Wp<  y   P+    v       ;]   9   	h    @ u
ty uj F	j Sx  t  	t  ǀx      U09h  t	R1;]   hؗ
j p  *+  C;]|   t& X      9   	h    @ u
ty uj 	j Sx  t  g	t  ǀx      U09h  t	RH1;]}6    hؗ
j pX  q*  C;]|	&    1e[^_ÉUWVSu]
p,   u	    t<   uX   u  	h    @ u
ty uj 	j Sx  t  k	t  ǀx      } }}9h  t	WBup   t	hؗ
j !p,  thؗ
Vj VP  PK)  %19}hؗ
j p   ))  C9|	h    @ utpx uj 	j }Wx  t  |	t  ǀx      }9h  t}W\upX  t
hؗ
j %t& p<  t!hؗ
Vj VP  Pa(  ,&    19}hؗ
j pX  ;(  C9|1e[^_ÐUWVSE    
pMʀy$ t
@%    EE    } ,  }" u t~} ux1M9M}n	h    @ utpx uj L	j Vx  t  #	t  ǀx      j F;u|}WMQj }WMQ}W$Ã0  
pM΃    '  u	   u}8   tN	t  ;UtEH9u6  t,M|   t E   hؗ
j P&  =p}hؗ
j MQ}WM   !  P&  } thؗ
j p|  h&  	ǀx  ǀt  }WMQ}WQWMQhؗ
j }Wj p     P&  	ǀx  ǀt  $  	<     MQE+E@P}WMQ  v }" u #  M9M  }9}uzM    tn]]	h    @ u
ty uj 	j Sx  t  	t  ǀx      j /          1}}];u}x]]	h    @ utpx uj w	j Sx  t  N	t  ǀx      j F;u|MQ}Wj MQ}WuVÃY  
pM    
  tM	t  9tEH9u6}  t)|   t E   hؗ
j P#  
pMhؗ
j }WMQ}   c  P#  } thؗ
j p|  #  	ǀx  ǀt  MQ}WMQWQVhؗ
j }Wj p     PP#  	ǀx  ǀt  $u1	<   tMQ}WM}DPVÃt6MQEPEP}W5 	YMQ}WMQT<  1t& ؍e[^_ÉU	ǀh      	@   	l  up(  t	Pg"  p   u:  tRE"  p0  tR-"  p4  tR"  p,  tR!  p  t  tx	 tv P!  ÉUÉU	h   tj hÐUWVSE} t>j V	p09  ÃtlV	0P  tVVS	,<j V	p,  Ãt.V	,PW  tVS	0P.  SV 1e[^_ÐUWVS	HMPH)UʉUǀt      B9Eu
B9EH  h  /j5 	<  	p  U   MqFXFxFu~F	;E|Ef+BfF2JM+E9u9Mt]+]v B9u9]t]B9u9}t}WSV  t   &    M	MX	pMfH8fJMfH4fJf@8+EfB|  tP\U 	ǀ|        tP8U 	ǀ      M+M
qM
q1e[^_ÐUWVSE}Ƌ]1ft?t;t& GPP3u#f9s
ujGPA 
v [uɅtCuЍe[^_ÐUVS]EftS; tNt& P3u f9r
u&: tfB
  BRFT    &    Zz u1e[^ÐU$WVS}  M  M  OMwu9uu	9Mm  fWtGP@@EE    M9M   u1uFu9&v    G@4S E܋M9M~uDvPw@  G@   MAM܋u9ZI    G@    G@fD  G@MfLGtWU܍RG
uw@E܋M9M~WLEE    u9u  1ۍ&    W@UMtuFu&    E    MMu9u
}    Gu<M   PuV  G@UW@< u:   &    } u#GE܍@W
MUuW@M9M|?D9}uftW@MfLuMu0MM9M}t& fD  G@uftE܋M9MufwMfOf9wD~fwDfWf9WF	GF;EufWFfGf9G~fGfGf9~f1e[^_ÐUVSuEt#PV>5 ÃuV3Q &=      P) É؍e[^ÐUSE    uw  ÃtEj j PS_z  |U9t: t]ÐUWVSPp+   Tp+   Lp+   Hp+   tp+   pp+   xp+   |p+   dp-   p|   Xp+   \p~   lp_    p+   $p:   8p'   <p#   po   Po<   Lo>   Xov   To^   @p#   Dp#   `o#   `p-   hp-   p<   p>   p*   p!   pf   
p  tR  
p  to11эy9sZ
pnt&   a`}+|..~0t"~f|  D
  @ CC9re[^_ÐUVS];RuR04#|1Ҿ4    91tBvRe[^ÉUWVS]   |%1Ҿ44    91u9Bve[^_ÐU塠p<  Pm qPRptx  USEppt2x  oqp$  t 	&    1q؋]ÐUS]t;Ct	PM t	PM SM ;pu
p    1]U1pхt;T   u4   u    t ,   t    u	(   t   ÉU1pt)X   u	<   t    u	,   t   ÐU塠pu  U塠pu  Ív U塠pt8j   PA 	tfǀ\  fǀ^    fǀ`    1ÐUVSMMbM}+]])ލ4)Me)MEEe)EUэEHj Pgw 1e[^ÐUWVS}t75	1ۃ} tup    t   _(<  1e[^_Ív UVSut&	1} t%   F,@  e[^Ív US]C=   w&  	C  1]UEt&}u@<    &    @<1
t& ÐUUu&    EB1ÉUUtEB<ÉUEUu	P8R  ÐUU	  t
p  p  tP  1ÐUVS]	p  w?9tntt!IuDp   p   p   u
;    P  	p  	p  t
       e[^UU	P1ÉUWVSu]u14C
9u   %13Vu
sVt   e[^_U	p,uÍv UVS1۾d5    0  w&h5Pp   4	,P7   C   ve[^U} t
p  p  tP  	p\  	x4 ua	@4   1ÐU	tX=p tOǀ     ǀ     pH  <  ƀS  pƀR   p<  P  ÐU	ǀ     pH  =  H  ƀS  pƀR   p<  P1  Ív U塠pH  <  P  U	ǀ      ǀ      pH  <  
  <  P  ÐU	ǀ      pH  =  <  P  ÉU塠pH  <  P  U} tpH  pH  p<  PM  ÐUE	Ív UWVSu}=	 up@8p@4          h :k~h&:X~> ~? pp  P7 tW32       ]ShT  p  P2 }
2  8u 1  8t̓> E? C~? &pfx8 ~fx4 ~@8p@4~?    P   pffB8ffB4pfx6t@6q
q   e[^_ÉUEPEP	t`  tuuÐU   VS]S Pu  ƃu@1ҍKȀ< }
 B+v1ҍ   É    <u    B  v[^Ív UWVS} u:h.:k  Et8 u!}    h@:5$&  j[l  }1I   v5} tM,  h   h:5$  jl  h|  jr0 Ãu0} tE   h:5$  jk  SMQƃt#EP.  t߉     u-} tE0z  h ;5$,  jak  u<} tM    E  v EPh$;5$  j%k  t& Sp    thB;j  t   ph   0hp
Q q }ujα uE   E
pf  hqhq} t	M   pz t;} tE     gt& MQh`;5$  jEj  t& z t:} tE    &t& MQh;5$  jj  t& 1e[^_ÉUWVShB;h   E5p    EE    t& 1ҋ]<    }7   8 t4t& M1   ]8u]5pB}1   < uE}  ~e[^_ÐUUU    SP5SSu
h;*  ÉUPWVSEEԍ}S    E
  UԉU11: tet& E8%uMHtFɃNw;$;E/*   #EEPπwPу9~CEE8 uU+UU
 R9v.LM
 RP5$R
$R	  	~	   19}U܃GA9|9|S    u)K|"]܋<5S<@SF5SIyU: 
	  t& EԀ8%t?u   =SO;
SvQU=SSS  Eԋ}ԋ
$RU؉UE    E    E    E    E    E    %A?     EXwN$=    AE   jt& GAE   v GE   L    } tJGAEF7@	Dpt0} tUtVЉu
EtFЉuGAU
v E   } t
} I M;M}MEЉ}Ԋʃ]  $>=SO;
SvQ=SS%SH  &    
S~I
S@S1ۋ5$RM؃         
S~I
S@S	1эY=SO;
SvQE=SSh;ot& 
S~I
S@S	5$RE؉E1I9M~M=SL;
SvQ=SSV=SW  S=S1эL
S  WUԊG<  G  WUԊOME}w4GHS~KS@S1ۉR    GHS~KS@S1ۉ@RR  GEԊOME}w
GQm"  GPTt& _
S@SA
S}  1ۍWUԊGU\ZEԋUԊ<	v
S  @SA
S  5S~N5S@St& 1Ʌ~N5S@S1u  5S~N5S@S    1Ʌ~N5S@S1)ˉ3  5S~N5S@St& 1Ʌ~N5S@S1  5S~N5S@S    1Ʌ~N5S@S1ۉؙ  5S~N5S@S1Ʌ~N5S@S1ۉؙp  1ɋ5S~N5S@S1ۅJ  ~N5S@S1ۅ*        1ɋ5S~N5S@S1ۅu$~N5S@S    1ۅ       5S~N5S@S1Ʌ~N5S@S1!  5S~N5S@S    1Ʌ~N5S@S1	U  5S~N5S@S    1Ʌ~N5S@S11  5S~N5S@S    1Ʌ~N5S@S19   5S~N5S@S1Ʌ~N5S@S19   5S~N5S@S1Ʌ~N5S@S19R5S~N5S@St& 1Ʌ(t& 5S~N5S@S    1у   @SF5S   EE   t& 
S~I
S@S1Ʌ   WU1ۊO   v %u%EԋEԊ?uC;u~cK	eutWtSEԋUԊ
uEt& GE1ۊOtG%uEԋUԊ
?uC
;u~Kt#EԋEԊ uϋUԀ: t
BUԀ: =S ujj(# Su1SS 
Sȍe[^_ÐUS]px! tS t    5q˸h)q~qP	ЃK=	ؗ
u
	tI
 Q  1]Ív U	t@&     Pu  1ÉUhؗ
ju   UWVS]tu
  
pʅu
E    ft& E    ;   t;8  uE   E    z u>fy> t7	t	   u$5q`¡p@>9|E   E	'  <$tPE      C;<t!j$EЃ;    PE   C@	DPu;.uj>S> uj$Ej<EЃ   15@	DVtLBCDWuE    ;.uCDWtL
CDFu1*uM   Cǉ*t/tޅ~,} u
} utgfff)Raǉt
CǄ	ؗ
1e[^_ÐU塠ptu  PШ t1ÐU塠ptuj  P膧 t1Ív U塠p   Pt
*    p  tǀ       ǀ      1ÉU塠p<  PEupA  1ÐU塠ptL<  P=	t/tx8 tj	z u
jr5	  1ÐU=p tL=	 t/j 	p  	x t
j p  p   PÐUhS[ÐUhSwÐUVSj ]SS EEe)Eu4[Mb)ڍЍe[^ÉU WVSu}}e}e}}E1Ƀ} t	 EfE A} t$	\  |    }8fD8 AVQ}W 8|+E)ƅud~jdƜ|} t}7t5~111ɾ   U}st
	ÃAA~1ۉ؍e[^_ÐUE= 	 u0u=	 u#h@W  tא$		   $	ÉUu 	   ÐU$  WVS]jS    j S脒 u  j PP֒    *  ЉЉ4	Љ
ЉtP  EPu  ǅ       v   RPP ƅ  j1Q^ Eu  )  p.   v SR9    ~j PPБ ,v,   R]SPI ,~jPP腑 +ڍv  A+~tjPP u    NvN   RPP蹐 1Ƀd&fM ]4uMufK8&    uMufKfM M	fKA'9|'~ j4uVP芐 !t& &U4v fJA&~    E      T  SPPʏ 93  1ɉ9   1   v]Ä   u>t,u>u	2;~    &    EPA;|  ~%jEPPI +t&   U       A  ~ t6PEpP藎 ;tP^ 1q  RE   t3t/EX49w: tB9v9v    A  ~P    [^_ÉUWS]U1I  wuRh@S  uS1e[_UWVSuE    1QY EÉǃu1aVEP5 {t?C3t:u G9r?EPEPWEP;uE   EPU* Ee[^_ÉU$WVSE}uPj  Ph@]S  =	 tVSj DPWtEh@P  tVSPPWt  tVSPWu
   /    h#@P  uVSWh?	t& VSWPe[^_ÐUVSu]h1@KP  unV  	XtYqq=
  	
t& 
  	x u*S t	PS%   PRV  e[^ÐUWVS]EfEuS  I  =(	 <  f3  t|É]Cv jj CttÉ]CF<uC fC
     <tSt
ӊKt8ut8t<uF   tLҍt& jjW É]u(	      }CuF<uC fC
  }Gt_    jj Ãu,(	   ]t<}?}S' ]u"CF<uC fC
  > uf}f{
e[^_ÐUED@ÐUWVS	@90	}@    ,	tRP 	R  _  ,		@0	  =	}1f    
,	}wt9C9|}G9}l4)މ]C9})<t#Eщ)9uC;]}:u|3}}GHP}W}WVY=	}G9f}GX   
,	    t9|Ky|a4)މ]=	}Kx!<tы)9uKx:uЉ])E}GHP}W}WV{e[^_ÐUWVSu]1 	@H~9tGIe[^_ÉUVS]1    px$ tH     	@P~t& 9tFJe[^UXWVSE    E    1	C9  ¡,	t& 8uF9|  u=,	)MFB9}3<t-KM܍UM);EuMF;u}:uuC9}8uF9|uuC9}9|uEuN} }	M+MM;u^  vE	  M<1|  9  Mm9"  ,	Eԃu}ԡ	@@M4 	@@}    MЉ4E̡	@@4 	P@MɉMȉE4Ã} t	@@M4!	@@M4 	@@49}u	P@E4)	P@E4 	P@EE4EE9%   t,	<EN;uu} ~	M+MM;up  vE&    	  M<1|  9&  ȉM9)  ,	Eu}	@@M4 	@@}    M4wE	@@4 	P@MɉME4LÃ} t	@@M4n!	@@M4 	@@49}u!	P@E4,0&    	P@E4 	P@EE4E9%   t,	<EF;uuu	} ~uuuB9Ke[^_Ív UWVS=	}G;8	   4	tP  =	}}GDP'  4	u?=	}|  tPn  =	}}Ǉ|      8	      	B8	U}|            1f   E    	@@}f|8tH8E1 	@H~}}I}  4=	}EC}G9|-  j}GP ¡	|  ǉ}}   u!jGP ¡	  ǉ}}|        }  1f    E    	@@}8E1 	@H~}}I}  4 	B@}48E    BH~EEI	|  }<EC=	}G9U}GDP54	&3 =	}1f ~:|  4	9t	u
BZC=	}G9|ƋU1fz ~A  4	9t	u
BZ,	C	B9|4	: t;z}rt& ~u~u}9t,	E: uu=	}1f    &    
,	}W8uC9|}G9}qދ<)߉}C9}(<t"Eʋ);EuC;]}9u)E}99},	F9|	E@9ge[^_ÉUWVS=	}|   tA
 	Q@}41AH~I}|  }e[^_UWVS]}5	u싖|  5  M)؅})      P    Ru|  P/ })9   EE 	P@u2E    @H~EEI	|  u4EO;}   v P    Ru|      )P
/ )9}\EE 	P@u2E    @H~EEI	|  u4EG;}|e[^_ÐUWVSMut?A0҉ t!Q   t
A0	A	yu qe[^_ÐUWVS}   OMuWO0ɉOE    G9E^E    1Gu?uv G@0;EuG% @ PW
G@0CG9~ǃEEG9E~jt@Pj W|W誇1e[^_UUuEB1ÐU   VSu]SV| }XtLg  8uBj/V Ss$ P' u  9u	fǅ . jS| &    1[^ÐUESÍv UEth   Ph T& t&  T Ív UWVSuE T}1у   fTffEf Tf	EfTffEfTf	ETT	T	 T	TT	T	T	Ë}1Iww$hF kfEfbfEfF Tv MF Et& EfF6t& EfFF "^}1QEPV?. e[^_Ív U=q    5ShF5$  q|PhF5$  q|PhF5$ȴ  = T th ThF5$觴  5$j:  5$j   EPu5$I  hF5$e  Ív U5ShF5$G  q|PhF5$*  q|PhF5$
  = T th ThF5$  5$j:(  5$j   EPu5$6I  hF5$誳  j=  v U5ShF5$至  q|PhF5$j  q|PhF5$M  = T th ThF5$,  5$j:h  5$j [  EPu5$vH  hF5$  j=  U1ÐUWS=<	 ukhF<  ÃtX1у  w?уQj  <	uhF	t& ShFR蜲  <	e[_UWVSu]}M    E    t=     ЉUUPE vDdt	Q=  5dSV t	Wv=  } tU5dSVUP;  U_ÐU   WVS}  } uEX	{	  v uuuX	4EP u
H	  E    E    hGH;  t : tEPEPj:Rj+ Z  j:hGEPEPK, ;  }  uuE      E
MyE   j;Pc    }1эq)|QEP|Vx) {v 1ۋ|Eu)uEE    u;xGuuGM tC~Ճti||E4j;V |t)  |@Ej=uV |i1ۍ&    uE94ut&     1  C~ظ    t
ht	DEM~j}|Ex|\.Ѝ&    xPuVuu  t!ztBOxM} >  E    E   ǅx    1ۋE1эquxGEDEx ~} tuR tE    xx~} N  ǅxsx1эYwRMs)tSuOQs)v=u9Qs)v'u#Qs)xVu)    s1эYMwPs)tPuLQs)v:u6Qs)v$u Qs)hsQ ux   ]CSB  EtSuVP& 1҉iv EP  EtWUǅx    1u>GRl$ =BSR\$ ;Bxx~B }u1   E    EЉEǅxX	uuEFtGtҋu3x9t%}up	st	R xxE}~p	9tst	Rz =p	    t
ht	@uS   t& E    EEľ    t
ht	P@Fu< t.EPuVuu\  E  xt@EĉEE    E   ǅx    1ې}uu4|x    0x9uuE |u    ڋX	||1эquxGEDEx ~'} t!u6|P tE    xxA} W  ǅxsx1эYuwOs)tQuMQs)v;u7Qs)v%u!Qs)xPQR    s1эYuwOs)tOuKQs)v9u5Qs)v#uQs)hsQ ux   ]CSk  EtSE0uVv" 1҉       EP3  E   Mǅx    1}uu>x    'x9uuEu    v X	GQL  =ASQ<  ;Axx~A }uE       Fu< tEFtu2Gtҋ]ċE9X	t&}up	st	R
 uX	p	9tst	Rz
 =p	    t
ht	<uS
 Ečl[^_ÐUWVS1۾X	    F8F9tCtGtЁ>st up	=st	P	 sW  C~p	=stP	 p	se[^_ÐU@WVSE9 t.=L    Q'  u6)Rj/V tlhGU0  Et: uu4G30  Eut9 uhG0  Eхt9 u	uss1эYuEEԃwOs)tKuGQs)v5u1Qs)vuQs)RQT ts1эYuwOs)tKuGQs)v5u1Qs)vuQs)RQ uE suԋF  v E0F  uu1эq)eQREPT uVEPuVEPuVEPuVEPR"  E܃$j uԋGuVuuuuuuuuPuVEP]ԁVS  ǃ8u9juVuuuuuuuuEPuVEPS  ǃ8t} u
uVW   u`E    1ۍGEă t<t& uċ3z uEPRj  3z uE؋u؍    Eă< uȋuċ43wEċ<u1TO9 u0j/7 Qz/tJz/u_)QR O	uOQwBQOȍe[^_ÐUS]CPSuaEV9Xt@9Xu@    @    3 { tss/ tCs S ]ÐUWVS1Vt4t& ދCtxt	PO  [6V VP uG~e[^_ÐU   WVSE    E   E@   @    j 0Lg E  uVWjb   E%   = @     Wjg EӉ1ыExGL)̉GRS /SYSfB_ R j Sf E0  VPja N  -Ë;}j EPjjuj r Et}     ;&  E    u|  E   uԉx~Qt& VxWEPf Ã&}W           x)ޅoEM}9uE    SQ D    .E   EPG	G		9t;} tuԋ}Wy t& EP }We       M]EEu
}W$QA	A	}G	¾GE;0r?u
}W't& QA	A	}G	   ;Er=    'E40x<   W  Ã    EC}ԉ{ECC    x{19   EE}}    x}L} uQA	A		;S8E	{}<u2Kу} u&v QA	A		SExF;s[EPc }_l[^_ÐUS]t	P { tsse} s  S  ]ÐU	J   
@	J$   
L	J(   
H	B,D	B4P	BHT	ÐUWVS    t
ht	2=V    	    Vtu"P,   V          95$Vt    PR   Vu$V    \	   5$V19sEv  V j Q Hj Q J V+B)C;$VrV   1ۋ=$V}9sv= V}}w}}}A9|u<Q}G9|
u-G9A%}A9#uQ}G9uG9A}
EC;]r;]s}1۸    t
ht	
1؍e[^_UWVS}    t
ht	0=(V    	   ,VtuP  ,V    tt& tk950Vt    PRZ  ,Vu0V    =	   50V19s&&    ,Vj R PC;0Vr(V   ;=0Vs,Vt& 1۸    t
ht	/؍e[^_ÐUV    (V    ÐU	B,	B8	BD	BH	BP	B\	B`	Bh	ÐUWVS}   E8 u	
  1)qtsEP t|ًu} ut	S	t& s  t&    sEP   s1Iw[Es)tWuSEPs)v>u:EPs)v%u!EPs)VEP! tEP ǅu	1Z  SstR  {<  t& j  ƃtʋEP7 Vts1IwbEs)t^uZEPs)vEuAEPs)v,u(EPs)&    REP6 tEP Vu
v FsqtrEP }q5q1qtrEP ~
u3Ce[^_ÐU WVSU} u1  } u	E
qMt/v EpMQA t|E Euڃ} uEs   My?/u
}   t& 1Ӿ  D$)ĉe      !:"u(  $)ĉe    VMQ] Ãt̅R  Mqj EP f/ BR E  ÉڋE  E1ҋ}֍t2)eEPSMQ\ f/ BRK .mo }1҃)ԉet& E:u    EM:tuE C@ Kv U:tEBM	˄u =L t#EP.  +URj/MQ
 uM½uQtus    uZEE_MUE@  Å6UJ   ƅu+S{ tӋU/   ƅu; uM
e[^_Ív U WVSÉU{ u  s  ~  N M  }1IM]1ɀ; tCρ   t11݉1vUFE1uC]~tEUff	EU  tFETffE9tmVUE9Du^tUDff	ULQEP u&~    FDff  ^+]N ~9]r)]UUtEffU?  FEtTffE9t띋EU9DutUDfft& ULQEP  R~ tFDff   FL   t& E    ~9}   ]~ tFDff&    FLQUR?  }~CE9}r9}s0~ tFDffFLt& 11ɉȍe[^_Uw?$Xts5t.t%t(t0t<tCtÉUShJt  t8 u@h<t  t8 u*Sx  t8 uhStb  t8 us]Ív USqt$s>  C=st	P+  uܡ	=stP  ]ÐU,WVSÉ։Mj Pj j j j j j j Vj 1QSh4V	  ǃ8tX u|     1 t*_&    z u	Q  z u	F; u|1҉   V  E؃tP  ƅtmEPEPEPEPEPEPEPEPVz  $jEPuuuuuuuuR1QSh4V  ǃ8u1L u    u+ t%_v z u	q   z u; u} tV  e[^_Ív UVS4Vt%ދCt  [6Y  VS  uۍe[^ÐUhWVSEE    @   B    9  j PKT E"  EPURjO   UԉU  j URjjURj n ƃtURKT E   HUR#  ƃ  ]t& SWUR5T y  )uURS =t.=t'} tURVm X  V"  K  t& j$  ËUZ,  3USUS>%   CtFffv F   { tFffFC{ tFff@C{ tFff@C{ tFffFC{ tFffFC F    } tURVl 	V  S  UB    URR t& 	e[^_ÉUSÃ{ ts3*l t& 3  S  ]ÐUWVS1    toh	!`1ۋ
tN<:uЍz=
x:t

ʀ9 t::tz=
Bu9s)ʉc   Ått:}}
th
jP58VEP  1ip    t
h	 e[^_ÉU @  WVSB$)ĉjhtRQS P htSg  u
1  v ǅ        Ph    Q  `  j
Ph  u0 Qh    Sǝ  tj
S6  t֋ =@	DG tv BDC uƄ  <#  By t0ADC uv B: tDG t: t
 B=@	BDG u: v  By tADG uB: t
DG t
u	 B
t 
9
rp  1щщ 
ȋ
9vBʁ   s   S5	m     	
 
5
8VQP	R 
 

 
5
8VPQ	Q T 

{PZ   th
j5
58V  Կ[^_ÐUS
t	E    d       P58V:  t8V
]ÉUUE02 U	t	P  8VtP  ÐUWVS]   5	; txs1IwOs)tKuGSs)v5u1Ss)vuSs)RS5  u	sS  	stV,  	e[^_ÐU,WVS}1ыuTEEe t}1ʋuuet} 1ʋuuet}$1Et}(1ʋuuet},1ʋ}81эYuuetXt}01AME   Et}41MʍTt& U؍T&    TR  E؃  uVEPuV  j:EPV E|/GuVW  ǃ} t_GEPW  ǃ} t.Gu VW  ǃ} t.GE$PWx  Et0GE@t+E       v @u(VWB  ǃ} t+GE,PW)  ǃ} t7,G]Etu0VW  ǅt_GE4PW  /Gu8VW  1E Et8utEPRu  tG}uvuu΃} u}< uEPi    uVEP  ÃU⪪uu܁eUU  U܉U܁e}33  U܉U}U܁  U}M   S腿  Eu1  u؋E01ۋEPuV  uEu   EX@    uu6pu&    wEpGE    EPuV0  uEHEE؋uu}    &    EЅE   EGt
Eؘ   E؃   1wjE8Pu4VE0Pu,VE(Pu$VE PuVEPEP1QSuVEu@E8t}}9sj S  P9r} tU1҉ӅrM8Eu    Ee[^_UWVS1ɻ   1;Us&5@	v }:fFtAt1B;UrtAAP蝽  EtNt iso ]]1;Us/u@	fHt
H	tCFB;Ur Ee[^_ÐUWVSM    M    M    M    M     M$    M(    11]M8,t@t_t
@t+uËM9uj S     ;_    CM
t& _tCt.t@t
+t,u .ua    CM@tCuM9t9: t4)PRPMPM1m  uM1  <@u      <+u1    CM_tCut
+t,u   tp<v_u\   +u" CM 	v _tCt,u,u CM$_tCu_u CM(u6MMt8 u߅t: uMt8 ue[^_Ív UEt,_t'@t"+t,t@фt_t
@t+uÐU  S]Et	~?~
    jt& t   E     JySу    ru	   1EPtPS'   |ÐUd  WVS=r 9  b } tdE T`U߉    E   X   @t`
	t& P
\} tT	&    1ۃ} t1ҋ}پ   S   ̀[Á vۉ}:&t[} tJ |AMω    󥋅M         t& :r   } t?E EMIMu   u   @t`
P
U} t]1ۃ} tU1ҸC   uS̀[}߉:E} t EMuq}艹   E쉁   1 v    XYZÃXYZø[^_UWVS}=r uW>E EMU   S   ̀[Á vۋE}CU:&u;uM1r   MUS~   ̀[Á vۉ؍e[^_ÐڋL$\$%   ̀= ÐU  WVS}   Ev      Jy   Sу}s
   	C vݍ VWj}
9       E    t& C   t	UC vE[^_ÐUEth   P  1&        ÐUS]Et	~?~t    &    Pу   	1]ÐUS]Et	~?~$    $&    Pу   %   ]ÐU  S    t
h
<Vu@<V      p     Jy j Qj'<Vu<V   j }  <VuJ<V        t
h
gjA t
h
L<V      uZ<V   th   S  ǅt       Et&  JyE    j Sj3<Vu<V   w  <Vu<V   j <Vu<V      u<V   j) UWVS1}9sC7EEEPURU҃}Ս&    E&    s1e[^_ÐUWVS}(  uUU)uUUEǋURURURVURURURURURW](}uJUuB   }    WURU҃NUU
M뾅th} tLWURU҃!URURS  ËUUNt& URWS  }MutuVURS  U)UUURURURe  e[^_ÐUWVSu}]ށ  wC$)TWVURURY    [ ES  ÃuWVURURh v SWVURUR@S"  Ue[^_ÐUWVSu1ыd   >    ~ u9f> =  Ӌtn&    f;:tuWBTETIf>MӋt3f;:u#EPVR  uE|=tu1e[^_ÐU=L u
u1ÐUVSu= tdPHtEB@Lt	r"tqVAЃAЋBJu usЃrVY UWVS1    t
h@
	t11{9sK1< tF9r9rvauӅu)h  詯  Ãt#C   1vC       t
h@
tvD
C1e[^_Ív U4t   EB1ÐU8WVS]E    t:
	Q U~(<t$A P  EuE    } uE    } |}t}$~    u      uu=@	}DG t&    FUDJ uUׄ  -uE   &    }+uE    FUE    }0u>} t}u"VL	<XuE   U} uE   } uE
   u  U׈UtD}؉}L	UE;Et"EЀ}	v}DGtUȋ;E}
CUӄu;Mu0  ]} !  }? u9s
;EtA9r  9   MIUU9   ;EtI9s9   E)ȋ}SU9   y}EȋUȊIuJUȊ<t}"9   &    ;EtI9s9sm9r&    ;EtI9s9s)ȋ}?9~A9r)ˋU9t}};E~	\]M9uE9s	]1۸1uEȉUE    1ɊUT9tWE<	vUӉŰ}DWt=L	ɈEE;E}';Mwu;EvE   MFUӄu;ut^} t}7} u!} t
   w}E   } t  "   } t   RJȃ} tB>} t6E+E~#URL	<Xu}0uOU:U}1e[^_Ív Uj uuuÐU  WVS} u     t& ǅt   E       E&         JyWtSj  \PSje}ٽË3j WjK3     Xt&      Jy蘽Ë3\PPj '}:&t1j Pjj \Pj3  v 3  ÅuxǅLtǅPtMTǅX    j Pj|j \Pjlj \Pj$5dLPht  j  |j HPS  9t
ǅH蒼ǋ7j Pjj \PjDj \PjD	t?&t7H8[^_ÐU|WVSuE    E    u      u      } t eh  [  EE  E/t-h  EP3 [  j EP  
E /]Cu  	EE/tEEtE8/t	@E8 uE9E  u)Ɖu	.  u2.u-Ex.u$UB9c  K{/X  K{/uL  {/t/C;ErH+]}   }+}B=  ~|:  WEP蟲  Eǉ}u  VEPS   EPEPjD- &  E%   =       eE}   h  EPEP\= ƃ   E } u	 e}1эD=     QEPEP  VEPEP}  EUBE8/u&    9vK{/uEE +E@9v{/uK } t+]CSEPEP  t& U8D (   7 $   } tEPEP>  	EP  1x[^_ÉUj uÐUEtPu
ڸ    1UT  WVS}輸ƋM  u   ?  tMEvC  ?  ǅ,    ǅ0] ǅ    jV$  ,? tw    ,%td    }A  tVR,Qj n  &    j R,S)  ,,,8 u,(    ȉt]ShtlPMQj  ][FE   D(,),,SWEPDIщ9  ,,; J>  ǅ    ǅ     ǅ    ǅ    ǅ    ǅ    ǅ    ǅ    ǅ    ǅƅ E$,A,[DDDZwËht ǅ    D@DIDDDZwht ǅ   DCD@DDDZwht ǅ   ƅ DAD[DDDZwËht t& ǅ   D@DIDDDZwht  uƅ0DCD@DDDZwht v ǅ   0   ,jQ  ,S	x1JR	sPg  u	@ 
	I 0tt	 u
ǅ0    DCD@DDDZwht v ⋕Jz@	,D{tRЍBJDKt"<|{ЍBJ,DKuޅt8$  EE@}؉ƅ ǅ    =  v#)̋D$ <Zwhtv ⍍,DzCDA@	DBt$֍<,|xЍJZD^uމ =  v#$)čD<$$  <Zwht⋵N~*   ^؉|~@	DztZ|,Ѝ^|FDBt$֍<,|{ЍBJDNuޅt|8$  E][   ǅ   ~@	Dz   ,ЍN^DZt'֍v <,
|yЍZBDFuމp    EMI,X%  t& EMI,	  EE@,  ǅ    9~( =  vB#$)čT$ <Zwht 
v ǅ   D@DIDDDZwht
ǅ    DCD@DDDZwhtǅ   DAD[DDDZwËht ǅ   D@DIDDDZwhtǅ    ǅ    DCD@DDDZwhtǅ    ǅ    DAD[DDDZwËhtǅ   ǅ   D@DIDDDZwht&    ]S;Srj%S2        %E@,|  
    t^E]K[$((04t04 404   t&  tE]S
EEPtډ  t& 
         ǅ    ǅ    ǅ        E]K[ |Bƅ  u<u.$,    t~ 0Hrǅ   XSV$@PSQh ,, t,0 t#0$,5  ,D	D<˃  v  tEE@& uEMIE]C |Fƅ  u@ u7$,o   b   0HS  ǅ   0$BXu
v `,
t wt~   t& tK       ,0)00;,0uyt& ,0:,0uP,0:,0u+    ,01:,0uۋ,K, t,0 t#0$,3  ,$+,) ~4, 0H,<I< ' t tu,0K, 6  $+,) t tu u u	  t0   ~,, 0H,<I< ԃ t' tu,H 0H, t,-I,
   t,+K,        ,  H,    t' tu,K0K, t, -H,<v  t,+I,t&   t, K,~3&    ,  H,<I< ԋ][FE   $+,W,AQPR҉9  ,   t' tu,H 0H, t,-I,>t&  t,+K,t&   t,  H,$+,)MIF]   W,@PSR҉9  ,   Qj S      1҉   󫋝ӊ Ҁӊӊӊ ӊӊӊڈ tEMi۽E]CݝxxQV]S+1    ,  1҉   󫋝ӊ Ҁӊӊӊ ӊӊӊڈ tEMi۽E]CݝttQV]SG       u& ~Pj MQt\  ,E]SEp;prRP|    DD]C  ,  v  ?)ԉ捝ljS  SEEpV  ,) u& ~Qj ]S[  ,E@FM   ,SVEPIщ9m  , t& ~Sj EP;[  ,  EMI,, u7t	~ǅ,t      ǅ,Tv1    u`StWt3Sj ,P  t+,   ,1эy   ,`djV6  Vj `dSj ,  ǃ  ,`WO)̉,VRS,S  9s)y:E@FM   W,SEPIщ9  ,   u& ~Sj EPY  ,MIF]   W,PMQ[Ӊ9.  , .   !  Pj MQY  ,   E]St5   ǅ    ǅ   ǅ    ƅx}ǅ,Uv
ǅ   ǅ     3 V `EE@,fTt& h  SPH  ,ǅ     C  ǅ,T%  t& <A<G,<{ ti,8%t^    8 }:ɭ tVR,Qj   j R,S  ,,,8 u,][FE   )QWMQXӉƋ,<)<;<,: H$  	   d$  ǅ,'$  &    ǅ    ǅ     ǅ    ǅT    0   X,jPk  ,Q	{1JR	sP  u	@ 
	I 0tt	 u
ǅ0    (;   &    9rY@)̉<[79tWVQe  9u@Tǅ    @PA$aA    P>@	Dz   P,Љ0FPNDJt0׋0,
\YЉ0JZD_uҋ0t8P?$u-GPJH$֋9s֋0PP
΀ t$+t-t#t0t'   &    PPwY$\vKFH@:I .t& Kt& @0   IPހ t+t-y#p0g'^@ t@    A A    P>*   ^PF0@	DB   P,Љ0^PFDBt7֍&    0,LHЉ0BJDNuҋ0t5P8$u*BC ֋9s֋3Px     H APet& >@	DztPP,ЍFPNDJt$֍<,|xЍJZD^uދxAP>.z  ^P~*   FPN0@	DJ   P,Љ0FPNDJt0֋0,
\YЉ0JZD^u҃0 t=P8$u20IH09s֋0Py    YCPt~@	DztWP,ЍNP^DZt&։<,
|yЍZBDFuދ9t&     ``
Pʃ´P.   $vP:htHoBPI
\    KP:luABPH.a"cH
t& PPHP=v t9ʁ   /rt$(PjQ҉S,/  @,   P½5  $\wAtA(      t& StC(          t@(      A
t
A(      C(       @t	@(  vA(   gC(   X@(   IA(   :C(   +@(   A(   
C,    x$uP,tH${ uPHCC   v PYފtc%t^     > }9躣  tQRVj   j RV  
F	&    ֊usI\; 6T9s)܉SPƻ  I)̉1;A  \$,X(T,PL &    t
    Lt
    P	0tfu,T FX<,	    R0S\P<rу\0,0X0T0P0L00F; 1;  ǅ,    ,X<  61    tn1  -          tx                          t   v   I     f@f     K[_   v   @ٝم     An  k?Zt&   IA  [-t  @    G    G    ,F;T9  ۉ,Dǉ<˃<<؃<˃ȉ\<˃L
<˃<|\xtLs\rt t=4v4t}މt \ǅ   Tx,tt)4v}txt9}ʍB =  v6xt9}ڃ#)ԋxt9}T$r<Zwrht     P?MQ;Qrj%Qg  %    %]C,  
       @uE]K[(t& T$<Rˋ[04404 t04 404   [u#| tEMQ*E]ST$<Rtډ  
   
      ǅ    ǅ    ǅ     Y  @uE]K['t& T$<Rˋ[t |Kƅs t uEu7$,        0,xǅt   rXSV$@PSQI ,, t,0 t#0$,  ,<	<<˃  t& @uR| tE][    uEE@   EMY   | t'T$<R~    t%T$<RP u$T$<R#T$<Rt |Iƅs t uC u:$,j   ]   0,O  ǅt   0$BrXu`,
tw
ty   tJ   t& ,0)00;,0uyt& ,0:,0uP,0:,0u+    ,01:,0uۋ,K, t,0 t#0$,  ,$+,)tt ~4t, 0H,t<It< ' t tu,0K, 6  $+,)x t tux u u	 txs0   xx~,, 0H,x<Ix< ԃ t' tur,H 0H, t,-I,
   t,+K,       ,  H,    t' tur,K0K, t, -H,<v  t,+I,t&  t, K,xx~3&    ,  H,x<Ix< ԋ][FE   $+,W,AQPR҉9       t' tur,H 0H, t,-I,>t&  t,+K,t&  t,  H,$+,)xMIF]   W,@PSR҉9,x 
  xQj SI      4[     󫋝txrӊ Ҁӊ|ӊӊӊӊӊڈs tEMi۽E]CݝLLQV]S.t0$<vLLPRMQ  3	  4[     󫋝txrӊ Ҁӊ|ӊӊӊӊӊڈs tEMi۽E]CݝHHQV]S4    t0$<vHHPRMQ}&    |    x u&x ~xSj EP;  ,Iu'EEP7v RQE[  FT$<RMq;qs<<E@P,   x   xQj ]St  E ?)ԉ捅@,jP  ,Q[uEMQ t& T$<RRVm  ,)x u&x ~xSj EP9  ,MIF]   ,PVMQ[Ӊ;,T,, t'x ~xQj ]S9  ,  @uE][#&    T$<R,, u7tt	t~ǅ,t      ǅ,Tv1   | u\rStStt3tPj ,Q~  t+,t   ,1эy,48jVߦ  Vj 4`Sj ծ  ǃ,4WO)̉,VRS,S蛮  9tst)xy:E@FM   W,SEPIщ9@,   u&x ~xSj EP47  ,MIF]   W,PMQ[Ӊ9,   x x  xPj MQ6  ,V  [uEMQ"    T$<Rt5   ǅ    ǅ   ǅ    ƅrxǅ,Uvt
ǅt   ǅ|    Q[uy t0EMI,Xc  t& | tEMI    uEE@xv E][    t7T$<R0,X  | t)T$<R,   u)T$<R,z  T$<R,fP  h  QS蘚  ,ǅ|    vt@L<1uHA4]    hT,    )̉lǅ0    90ss,&    h0<D$<<I,,00;\,rlP<Q]S׉E,E@FM   [,DL+Qt]SR҉,D,\+9,9 MQ[+   tj P;,[^_ÐUWVS}EHP9}э   B%?)čTUW;Wrj%WR  u  %G   EPt1W;Wrj#WR  =  #G   EPt1W;Wrj'WPR    
t& 'GFEP@t.W;Wrj+t& WR    !+t& tW;Wrj  GFEP t'W;Wrj-WQ    -GFEx0u'W;Wrj0WQ  P  0GFEPtgы]C    K)`хu;]w6CW;WrPW1Q  Ȉ
%   G   F;]vʋE8   W;Wrj.WP     .GUBE`FEK)Eхu;]w2CW;WrPWP  Ȉ
%   Gt@F;]v΋EPt8O;OrPWYP  t    Ј%   GuFe[^_ÐUWVSEUΊ<t}~yUM+MA$)ĉQE@PW  HUU9rK]IK]Mu9r6UK]]FuNΐt& <t}UIJU9sEe[^_ v U   WVSƉHDL CCkǅL CF SH    tj Rۺǃ   @xDWHWS躻DS[)Ӄ~%FF   SRV@9t
&    D8[^_Ív UWVSu   ]N~)t"CF   RWS@Ћ^)É؉F;NrEPVeN  &    E%   Fe[^_ÐUWVSM˃{ t{fuCK~1   t& Cu/S܋Ctj
HPssn K؋S܋CL   S9}1ePsRsj s ƋCS)CЉ4CЋ0CC܃t(S| uC܍x{܉t| tS܅u	C   #j
Rssܔ K؅tS܋CC܉0e[^_U   WVSuE    E    E    E    E    E@
uM]jSR  S	z1KSrEP蹠  u[	@K    ]jS  S	z 1KSr EPl  u	@  Eă} uE.   MA   Q
u
	@ 	@(EE      uG]jSg  S	z1KSrEPΟ  uU	@E]jS   S	z$1KSr$EP臟  u	@$ E} uE    MA   (۽t}<$芁 t#E@E    
@	D      |xt tBE@E    
@	Dt	ExExmE   t& |xtEPEPj]S蛤 EE   &     ݕlU$4 t6E@E    
@	Dt	ExExE       pl tGE@E    
@	Dt	ExEx]EȃE.plEPEPj]S荢 E̉E} d  MqUu	AǨPt	NMIσ    u*~&Vj EP(  9  uU&    t.MQ;Qrj-Q%I    R-E@GMQ@tEP;Prj+Pōv +t"EP;Prj P먍     MAE   E@EMy;yrPQH  S  E@3  EKuMA k  c  Vj EP'  9  uE  t& U}ڍZ}Z>   )ĉhe)ĉe)ĉeE    U  ǅd    ǅ`   ǅ\    MщuHuNx&]Uy    UUNy݋EU܅}ډUf]})PuSh4V Ɖu؋UUy]܍E܃tE4E1E    B]]y9|_dCH9E   UuMQ7u  5PQRuu Ɖu؋UBEuUU;UuaMQuuR |IUЋEEPRMQ肖  UEDTd`\&    `\EU䉕  1Mԉ( 9 uHE8 u:   y u/x u)ˉ&    F<    <; u<9 t担(|   d  1)9}1<    Mԋ9CE䉅);|֋)M1U܉);      EGU܉)9|  v     XM(< t0 < t*;}XuT    );~cWR(QQ Wu܋EPP É]؃ 2  M܍    EE  ǅT    )T9Tb    )S)R(XP(Q EH)ESM)QUXPR܇  ]܉)M| uhSav TPB)RX(Q(P藇 )u䋍TQE@)P]SMQy  ]܍S)E| u)U2  ]  ǅP    ǅL   ǅHMQuShP軆 É]؋M܍    EEE   M艍ىM	q  HH;P  XU܋MЉ9}RuSQPSHPRuQۆ U؃U܉֋HpNM} uuE<    MXu)K)΋UB9uwM/E    ǅ   )
   ⋍Q7E   @    ǅ    )QjPPE UB9|1g  }ЋOE9rH  E9G<  )M苅LP)y)1MЉ$9 u	G< tuSǅ    ])9}-4    t& UЋM@9|ߋE)E   4    $1u;   )9~HCSEPQu; U؋E@E܋MEYt& ǅ   )9   )P])S$PQ]C)St0Vu. ]܃ULH/   j
uuuW U؋M܉M}7UӃ	9|
Dv <	    )   VEPWuJ U؃t*MEAM~   RMQWuw EE܀PPM6URuShP É]؋M܍    EEE    MIDǅ<    ǅ4    EP
H	<eu$U   0}   8Et& fu[Ef   E0}   8} u
}GM\1   8ǅ0ǅ,          E|0uǅ0   
v ǅ0   } u09M}Cv }~:@	DPtE   &    e   U싵0N   0)Ef   } u}G10)0CMAt8&    ǅ8    ǅ,    } tuEPWi  Ӄ)܍L$@˃} t}ftR<C9<|ǅ,   E@u8 ~+}E8 tEĈCD$0MEĈD$\$894|94}g&    }E8 tR4e<0tǅ,   v , uF8 ~8C894|94|4  ڃ5ugCuau܃uE8   } uG  <    u|> ut>v   > t샽   4 ~'Ss}9t:9u0J2}9u9t}ă4 t9A  B9uJJ;@r&    :9u0J;@s;@r	  }ft*@1} uUB	t& UJU   t& 09<   @Mċ@H@ 1MAu	4 ~<@D04<4ǅ<   EMIM    @	DtE   e   U    @@1<<4;0~+0))4894~{0uK4894僽4 uE@u
C;EuK} tuMQ<ڋ@  Ã}f   ECC} t-   +   ǅ
   U9ɉ9~	0CLgfff)ʉUЙ0CUЙU能
M0CUE@ǅuPtD+@)D    uBMy0t7D ~.DPWMQg  ;D  DEUt+MQ;Qrj-Q8  f  0v -"E@@   t+MQ;Qrj++E@EMIJ       t<EP;Prj PA8     t&  MAEE@    uDMy0u;D ~2DPj0MQp  ;D   DE    ~<MIFE   S@QEPIщ9uU]aKt\@@@Mq;qrPQa7  t!E@uKEKuMA t5D ~,DPqMQ  ;DuDE    E[^_ÉUWVSEU΋}tVPIRU1uM4&    E    9vE)Bt
|	t9w} uE]]E)PS]S裃  KuO9vGNEIJuEIt}NEI;MwEEe[^_ UVSMUt1>v IRU1u$129vC)B<t
|	t9w؍e[^ÐUE=   w#v@VUrU@V1Z    ÐU   WVS1E EURUE    }G
uQ]jSf  S	X1IQ	pURɈ  u`	@P    ]jS  S=	_ 1IQ	p URw  u	@  Eă} uE.   }G   E (}}<$zj tw@	Dp      uuui tUR=@	DWtxxm}ЋEE   UUU$i t-Ep@	Drt
xv xE    @uui t#}w@	Dptx
t& xUU  }P} uEHPtPUJP u+P ~"PWj EPj  9	  }} t5UJ;Jrj-&    R2  ~	  S-}GHEH@tUJ;Jr	j+Őt& +t"EH;Hrj P맍     UBE   dCUJ;JrdPR&2    &dpЈp}G  ENE@  	  P   PRj }W>  ;P  P  t& UrB!  } hǅl    hl1M1		ډ\`\h`	hЉUARj]S\`RP EM9vMU09wfM  uE0E1fρ  Pu }   E   ǅP  R  P  ~E    P0      E     
  Ehǅl    hl1M1		ډ\`\h`	hЉUARj]S\`RPӊ EM9v    MU09wE EEU  Pu)} tE    Q&    E   ǅP@  7P@  ~E    PE   @  +PP} l  ]{0uv M}0t}uEEU)UC  ]+]9]4  }E88     @9   } ~+ETT=@	DWut\uT}    MU@	DPu,t0   v E@UBË}>6       uNx&E09tӡH	<e~0INy}b}9uURUQUH	<eE=&    E} tPx#E    t& P
&    }}P`EE̍t& MP<)1EPu1ۃ} uUJPtt&    }OEÍU܉|}xh)hhD)E} u} uuE u)} ~#URj }W  ;M  EE} t7UJ;Jrj-R,    ]t& -}GNt& EH@tUJ;Jr
j+뼍    +t"EH;Hrj P띍     UBE}O;Orj0W],  %  
0E@EUzAuX   	t& x   }O;OrSW,    hhUB  E]}O;OrPW+    hh}Gs  E} u} 	E@tJ]ċUJ;JrPRm+  5  hh}G  E}    }    E+EPt]9~Ëu\\F}O;Or\PW*    &\hЈh}G  EKt9E~%]+PSj0UR
  9M  M}G t/0u)} ~#EPj0UR	  ;M  }}ExAuP   p   UJ;JrSR*     hhUB   E} t-   +   }O;OrSW)     t& hhUBthE|+xuePFUJ;JrPPRY)  t%1PhЈh}GuM&    EKE@ t0H0t(} ~"URQ}Wq  ;MuE&    EED[^_ÐUEPuujUEPu5 SÐUEPuuu#  ÐUEPuu  UEPuu芶 UEPuu
  ÐU   VS]Mt; u	xxh    PRm  PVShx5$#[^ÐUÍv UÍv U   ÐUWVS]    tShtlEPDS tS  ƃt&  tt& 1CF   j S@Sitj EP{$ t	S\'  ;t; t;$t    S`  e[^_ÐUWVS}U1ۊB<rt	<at&v <wt   (v         (L    1   <+t
<buz+u   jW}  tуu   tău   ttuRjWD  th   N8  Ãt   KHj ST'  ǃ   `Sx  WS
  uSX(  Sv_  1
%	؍e[^_ÐUWVS]u-  g    tShtlEPISCF   S@0Ѓt1Stj EPe[^_ÐUWVS}]
1           ЉUtShtlEP譐Sƃ $߉jj
GPURS  ǃt tDJ8t1
U }	S} tj EPAe[^_ÐUSh   6  Ãu	1Mt&    SHj S%  ǃ   `S  juuS  uS&  S]  1؋]ÐUWVSu]1эy    EEEtShtlEPySCF   WVS@Ѓ9t   S} tj EP0e[^_ÐUWVS}uuu	1ht&     ȉMtWhtlEPݎW@VuW2#  W6} tj EP讎9t
1uEe[^_ÐUWVSu    tVhtlEPhVj jj j V  ÃFtF$N,))Vtj EP"uG8 u    ؍e[^_UWVS}uutj    ȉMtWhtlEPƍW)GF   VuW@ЉW} tj EP茍9t	1uEe[^_ÐUj uuuuu   ÐUWVSu}    U       UBZ)ÅaR  u}    U   ;Eu+} ~UF} }
URUR#  +u   FMt&    ;]r]SURPl  ǃt6uU)UUB)Ã} |G} ~CSPVq  UzE*SUrVp  UZ)]} +ue[^_ÐUWVSM1 u
x,    0uxt&    }    Ky]~+UBF   jWR@ƃu$ׅ~UBF   SWR@Ɖe[^_ÐUWVSu~8 }a]S5  |QM<ruy uEECEE   :<wuMy uCEEEE   D    1       k  ǉ   utM9r؋EPj  E9tSEPv  EPM  ts88     uj uhxhxhx蒄  j;  EP  }
EP  1(EF8   5E	e[^_ÉUSh   0  Ãu1G   SHj S  ǃ   S  uuScuS   SW  1؋]ÐUWVS}= t9t)       u|Mw8  }
<   名u
FC8uj V     ÃtރtEe[^_ÐUWVS}]u}vB           ȉMtWhtlEPWN} t*$ t$}uGtGO)ș)W:  GF   MQMQVSW@$ЉÉW} tj EPv؉e[^_ÐUWVSu]}    ЉUtVhtlEP+Vt=tjt=afu<~ u[FF   V@4Ѓ|;f=$u.1E    FF   URSV@,Ѓu1V} tj EP脇؍e[^_ÐU   WVS]uHUj `W  E@SjSW'  VURW+Ã$t;xr
j W\  	  t؍<[^_U   WVSu}HUj `S[  E@j j VS='  j WURSw <[^_ÐUVS]S3Se[^ÐUVS]S3Se[^ÐUE@ t@8ÐUWVSu]    tShtlEPSdS;Sr%   PS+  
CS<tj EP超e[^_ÐUWVS]C u1Y    tShtlEPjSS#  j uuS}  Stj EP3e[^_ÐUWVSu    tVhtlEPVWjuERPVuu
    1V,tj EP覄؍e[^_ÐUWVS]    tShtlEPdSC;CrS  	v 0CStj EP"e[^_UuÐUWVSu]    tShtlEPуS4S;Sr%   PS  
CStj EP膃e[^_UVS]    tShtlEPQSjj j j S#Stj EPe[^U   WVSu}huu@   j  Sl  E  VGPVSJ#  uuS较E9<t	4  Ѝ[^_Ív UWVS}   9wt"G  j    SVW  www_wwEe[^_ÐU  ÐUWVSuU]
1L    ǃ $߉jj
BPVSEt t;8t1	M1 	e[^_ÐUWVSu1ɋ}8 }Z<rt<at0A<wt;t& E       :E   @     %E   @    5;    1      v F<bt,
t,<+t <xt&    E      ɀB~ǋE	ȃ} th  P}W  h  P}W<  |}G8%	؉t4GF   jjj j W@$Ѓuut:8<}W  Ee[^_Ív US]tA: 	      C;C   { uC$t
PN  cS    t2  SH  CCCCCCCSF   S )RPSA8Ѕu		t&  1Cu{Lu{PtCLSPC ]Ív UVS]ut b9 	      uT{ uS  CCCCS;S uCCCSSC CCCC  tSuSC)PRSJ  SS;S uC)RPS3  t6CCu
t
uSC)PRS  t%   e[^ÉU   WVS}E    G9GuG9G؉]WG} uE   E    E    9wGtW     u2Gt
PL  gW  GGGGGGG}t}   }t1uGw)Ɖ)EULu
P^  _L]_P]?GF   EPWBHЃ0  E%   =     uuuuE    }   ]LuPtpGtiu   u^UM+WLOP_)É؉|u|M|0;M+u;|w!GGWGGGu7  ]s  GO )ؙ]u!!։]u]u+]u|uˉ؉9U
u%9|v]u]uǅ|    E    GF   j ]uVSW@@ЉEU} }Y  |EuE            wGF   } uGW )t& |GRPWA8ЉEÉډ9M
u,9|v$|u]u}t)UME   ;GG|Ɖw]É_GGG]uΉ_LwP'   WF  GF   uV]uVSW@@ЉEU}u}t$']u_LwPGGGGGGGEU'P |GF   j _LwPVSW@@ЋEUp[^_ÐU WVSuEE}E    u1  t& +MYE   <VU^)Ӌ% 
  = 
  u"^ );]rMM;Mv
I9
t;MwtW;]v]v$SUREP\  NUډU%t& M{|    E EAOyN})ߋU  jVS    N +N}v	1)U}    FtFLFPJt& ^VU9t9FF   j)ډЙRPVI@щӃu
u1st& NL^PVF   EUREPVUR<҉Ãf~D ttSEPVDJR  AfNDNNNNNN  uN N);]rtWEEPV	  ))}Ee[^_UWVSuEE}   N^)9wWQURD]  ~1ׅtSQEP[  E)^FtV\
  묋^]tF )9sV     녋UVVVVVVtF )؉Ãv1)VF   QURV@8Љu+v  #M)σ~Lu
~PșFLVP)}Ee[^_ÉUS]tSuu  9t
    1]ÐUEup8j  Ív UEp8  UVS]MUEu} t
PRQn  PRQ蔧  |NC8%  	   t4CF   jjj j S@$Ѓuu08t1S
  ؍e[^UEuup8h  ÉUSEuM]SQp8J  ]ÐUS]{8 }LEC8$@CLCPCF   jjj j S@$Ѓuu 08t1	&    ؋]ÐUWVS]{8 }
   SC)PRSGS
  CF   S@DЉj j j S  C    C    C    C    C    C    $Si  $C8CLCPue[^_ÉUS]{8 |,SC)PRS@uCF   S@DЃj S'  ]ÉUS]CLCP$  S7  C8]Ív US]uuSY  tCCCCCCC1]ÐUWVS}E    GW9v)PRWt
zv GW)tVGF   EjщȉRPW]C@ЉEU}u}tGGv .8tMM}tGLGPEe[^_ÐUWVS}u]~"SVw8Ф  u v )ƅ)]P |UWLOPEe[^_ÉUWVS}MAtALAPX]sS9tKCF   Ej)щȉRP]SMA@Ѓuu
1w    ]CLSPMAF   uWQ@<Љƃ]f{D ttVWCDHP  @fCDMAAAAAA  u]C MAe[^_ÐUWVSƉU~})N0tQ9}Ӌ	u}})E)]N,V$)9E   Ed   EdP  Eu
   }*FU)RPP^,S]dST  PT  }W^S]dSV  F$tP?  }~$]^,W+EE}.PP}PyS  EF$)؋VM)QRt& } t}WEP}P4V  V$UV(U+VF0t	)P u1e[^_Ív US]CtgC9CvCF   jS@Ѓt;CtC(CC&    CCC;CvCCCCCc1   CK9s
    t)S,SK,CK$KC$K9sv {0 tStWat& K$tDtSC,CS,SKS$KQE>  C$    C,    C(    CF   S@Ћ]Ív US]Ct`C9CvCF   jS@Ѓt4CtC(CCCCC;CvCCCCCc1   CK9s C   t)S,SK,CK$KC$K9sCw{0 tStR\K$tDtSC,CS,SKS$KQ=  C$    C,    C(    CF   S@Ћ]ÉUWVSuMMu
1   M}G_)Å~X;]v]~SVP8Q  MA31+v ES|    }FG}Jy}My)]} t%FMAF   RQ@Ѓk})}Ee[^_ÐUWVS}}u    }G_)Å~S;]v]~SPV|P  Ƌ}_.1&&    S|&    AFJy}O)]} t}WGu})}Ee[^_ÉUWVS]}uCF   S@0Ѓu1   t& tu8sG{HStuC )  % PR苷  s{ 5v StuC )  % PRT  {s C    C    C    C    C    C    ؍e[^_Ív UWVS]S׋KM9vC   B;Eu	JS   Cuk9v!{$ t!t0       {$ uh     t܉C$耉C,C(SSKCK,KC,C$CS$KN9wJs+uu    MQl  ǃtE)Vs48VuP  s9  {s}{s(JKMJEe[^_UEPF   uPBUUBF   uuR@ ÐUS]t SC,CS,SC$CS$Cs$9  C$    C,    C(    ]UE`HP,PH,HP$PH$PÐUSEHXH,HX,XP$PX$H]ÐUS]C9CvCF   jS@Ѓt4CtC(CCCCC;CvCCCCCc1]UVSuU  F    F     F    F    F    F    F    F    F4    F$    F(    F,    F0    fFD  FF     t ]SijSiSvHiSie[^ÐUS]UC;Cv8Pu	HCCF   RS@Ѓt#]ÐUS]C;CvPS@CF   jS@Ѓt#]ÐUS]; }P    t
h-i= t9uC4	P4x4 u    t
hh#]Ív US]; |:    t
hhC4    t
hh]ÐUWVS]{ uOuCF   S@4Ѓu1sG{HStuC )  % PR藲  s{ e[^_ÉUS]{0 tC0    K$tAtSC,CS,SKS$KQ5  C$    C,    C(    ]Ív US]StuC )  % PR  ECEC } t#]USM]9vА@J:
t	9wE؋]Ív UVSu]^tYC9CvCF   jS@Ћt7tC(CCCCC;CvCCCCCtCCK)NC0s0e[^ÉUMAP0x0 t9u
 t& : uÍv UEUR@)ÐUMQuBtBBR)ЋI)ÐUVSuN;Mtmt& F|/t#QA,AQ,QA$AQ$AFA-u#YQ,QY,YA$AY$QFAA1e[^ÐUÉUS]CF   S@Ѓt	C C]ÐUWVSuj jj"jh    j 蛯  Ãt6    VtuF )  % PR良  ^~ &   e[^_Ív US]St,u'C )  % PRG  C     C    C0t
@     uC$tP2  C$        tsHd; }Q    t
hd= t9uC4
P4x4 u    t
hTd#]UÐUSUBF   uj M]SQR@$Ћ]ÉU1ÐUÉUÉUÐU1ÐUÉUÍv UVS1t/v C9CvCF   jS@ЃuƋ[4uԉe[^Ív UVS1t3&    C9CvCF   jS@ЃuƋ[4uԋt/u"%  tCF   j j S@,Ѓ[4uщe[^ÉUSt-%  =   uCF   jS@Ѓ[4uՋ]UWVS]}ȉMttp1  t& %   =   uCCCC{}+SKMs )΋M19   u4ud   uV   Љƃu   Ct'{ )ǉPMQVF  s   C    j}7PVSC+ECC+ECC+ECS+USsC CU} uM}CKM};{v{Ee[^_ÐUWVSM]} uJutt	E   2E   } u%t}Gwv }Gw)Ɖ   }GW9sЋuvu)E}   tJ}t}uu}G+EӅ|];MX}ϋu~}}~ȉڋu   tU}t}u u}Gw)ƉӅ|;M~t& }wΉwȉڍe[^_ÐUUB;BvB
%   =   u
BBBBB;Br
&     Ív UUEttPRÐUS]CtuP   ЃC    j Sf]ÐUWVSuMuU1IH}D      эM    ~
E;EwE;Evj ]SEPV2}~~~} tEF^F}~~^ǆ       e[^_ÉUWVSuMuU1IH}D      эM    ~
E;EwE;Evj ]SEPVr}~~~~~^ǆ       e[^_UMAQ9s+AÐUS=,   ,    8@Z4DZ84    t]    t"j h]tj h]vthj Ѓ
v    thhhhF]h y	Rtj j
j RtTPjY,  hyQtj j
j RGTPj,,  h'yQtj j
j RTPj+  h>yQtj j
j RSPj+  hOyUQ¡@Z8DZ4t: tPj+  )  0t,   ]Ív UWVS7  P=  w   =   w
   w*   !j jh"@  j h    j   u1O     )SP     )P   P  jWV  th   Vӥ  1~e[^_ÉUWVSƉUu,t&   u    t
h3[      t& t  P[uvtSj vN    9uthZu    t
hZE@  zƅ   ~>1ۍNMVMMC~Ǉ      F  vt
Wj Ѓ=v    tj   P2Z    t  PZv 1ۍ(  JMȃt)Wv)փr    t
hY  =    t
hYu	&    1e[^_ÉUWVSU8tuR   &    B~ǃ   vtj Ѓ
&    vޅt    t  PYtƅtjp   ù    t  PXuGt7    t
hX(   ù    t
hXu1Ce[^_U4WVSEU  wIUmMDp^9uX9t{}̋sKqNLX  E   U	u}}mswU8U`w[USTwUnU@T  wUwU*v T  wU|UM>t& E~   M}ϋX9t"KM̉+U̅  [9uE}_}9\  KM̉+U~.}{MA}GHHуH<  }My|}̀L  }  w7U   }	G4׋NsK^Y       E	uUYwEP8IwP[?    TwEPn)=T  wEPw=T  wEP|~   }4׋NM9u   }	G v MЋA$9Es
y}9uMЋqs}Љ{^_E}E   eЋ}}؉9}   MЅu!E$EɉMЅu
EeUt}M|}ԉMMuԃX9t&{}̉+U"  Q  [9uڃEEMuM9vu}   uE#E؋MAEe}9}w,} t&MЅkE Ee}Ѕ}tRMAP+U  };=   ؘ  ÍS9ssM\!j jj"jSj Ǟ  tNx=; v     كJ$أ$;(v(Ӆ\  N  E}}OM}8  ˋUr=tt!VЉẼZ  9s
}I  DtЉ9]u}7MQ   }O}Ѓ=uM̉
v E)Ẽt   )]1ۋE#E)E]SЉƃ  Dt}̉=)3W}uE    ;    &    }O  E;E@  MḾe  }̋}܋E])赖  H|,!M̋A4   fjRP  t-R}̋G4~Dj jj2j SP}  t'M̉q+u܋}  A+EMA   E    }:M̉JB  BGRP} tVE}MD9   v'D	   D   A	AʋE   E}OMD}GP+Us1   sKqN}̀Ls    MKs{w~MA}GHHуH6}̀LsKqN v Ë}{M}GP؍e[^_ÐUWVSE֋Fǃ7MY]];Ku{}u)ǋVNQJ^Mqu;= ;     ,  ue  ;= sE9  E  E    u3)ǋE^]9uE       VMQˉZM]DuE߃} u%EQ9uE   rMqVV]SKQJ7]
M]KN];}     w-}mU   ]	CMˋZV   	u	}mfw
8ETw[EGTw
nE5=T  wwE!    =T  w
|EE~   M]ˋJM9u]}   M]	CMA$9s
Y]9uMQV]^rsMyw@;= v8}t/]Sׁ  G9u  G9u
I
  e[^_ÐUWVS}<tu]SW:  u]Sg(      _]_]E~$EE   ]C[  ʑ  ]]SEEt!jVUUR+UR裘  t<])B$+E$;(v(Ut
Ѓq  E;Er_  ]Sƃu1F  t& ]]$wbv>GFOVv)GFGFOV#vGFGFOVABt& ]SWV%1  ]C$
)$P)S轖         ];Xs;s
U  2Ƹ    t  P'LvtVj Ѓ5v]SMU5   E    t  PK} tEv 1e[^_ÉU WVSEUMӉMu92  ߉}pu9tG$D8ug}Ou9u5}E9|Pu}G)PC	C  u;E| }OWJQE  E    1ɋuFx  u7)}W}   }9}   
EEE9Eo  uNVJQ}}$wpMSvLuFCFCMSv/FCFCMS#vFCFCM S AB}WEPCP.  EEuF})}up}GEG  t& 
E;E   uNVJQ}OWJQEuu$   MS   }GCGCMS   GCGCMS#   }    };E   uNVJQE}$wuMSvN}GCGCMS}v0GCGCMS}#vGCGCM S AB<  uVEPCP(-     UEÅuO}t;    t
hcHUø    t
h>Hu1	  }G$9uC$EE   uu$wrMSvL}GCGCMSv/GCGCMS#vGCGCM S ABuVEPCP,  U-t& M+Mv(}C	C΃rLEgCEC}L؍e[^_ UWVSU@tuRuV  }wRX  &    }wE   B~$Et& E   vtj Ѓt& v]t#    t.  P}Ft    }uT>E} tvMUE  ÿ    tE  P/FuL}t;    t
hFMU  þ    t
hEu1Ce[^_ÐUWVSEU8t'uWӉÅ  O u  ~ǃ   vtj Ѓt& v]t#    t&  P=Et    E}    MIMquEnE    tE  PD} uL}t6    t
hD Et
hD} u1   ]MA   $u9uu;EvEP$wa؃v<    C    Cv'C    C    C#vC    C    C          @        Rj S&  ؍e[^_ÐU WVSEU  EM	My}E9   MM}wNM\+S$Eu;EE   +EUU9rVMA})  h   Q覍  uCu+SCPB]MYM߉OE9j}OM+E}D81p9}1}  H|)!MA   jRP/  t%ŋ}_~j jj2j VPˌ  tMY})  )u}My   e[^_Ív UDWVS
$M̉ME    Ev EԾ    tE  P&BMЋAXȉMĿ   uЃuMЃMt& u;Ut    B$EċR;UuEEG~ЋMЋ  E؋MĉME    E    E    uЋ  )ىM]E$EF@$E    tE  PVAMQhy5$ìuhy5$谬uhy5$蝬uuȋMM̋uЋ  uЃ$hy5$fMQhy5$RuVhy5$> 5 hy5$%5(hy5$e[^_Ív U8WVSvtj Ѓ
t& vEԅuE    tE  P6@MԋAp؉]E   σM̋;UtB$EȋR;UuEEЃ}~ՋMԋ  E؋]ȉ]E    E    E      )]uE$EA@$E    t
  Px?}u
   Ee[^_ UWVShH  Ãu16      t
h&?AELDC   CCE    s   S9u        &    E}~¡            $  (  ,  ǃ0      4   8  $<  (@  LZD      t
h>؍e[^_Ív UWVS}PZ   ?AELDt
  G ~
      t
h=GGE    WUUE   E   Ev uU42uuU
+&    UuuU2} ~uNHEEEE}~            $  (  
,  4  8   <  $@  ( ~eD   t\=LZ uS=PZ uJLZ   8D4<@uh`y5$蘧    t
h;1e[^_UWVSEÃz  =}9   9   }w   G  97  .     "  $D     u'G   );U   B$9   0Ѓ%   9   Ɖ   B9   )9u   
  p#EtDt@t; t6@t1=   t*=   t#=   t=   t=   t=   t=  vHKȃu;)Ѕu1u'0I%   9tƅtB9s1)9u؍e[^_ÐUWVSD~  ESڡ9      tt%t& hz5$d*    j ЉǍwt	   )ƉX;UJ!)E]SЅt!+أ>)X1e[^_Ív UWVS}   E~	ǃ       t
h9|p1    t
h8a  OGt&*E
!+E=   v
;Uwn      t
h}8E       t
hU8ttWh@z5$賣)E~
ǃv        t
h7|P1    t
h7A  OGt&*E
!+E=   v
;UwN  ]KMeE~$EE     O{  u6u]SED!ȉEjPUR)P%  t8uE)B$+EE$;(v(U.  E;Er]]  f|U	Et& E    }    uu$wqUvK]CGCOUv/GCGCOU#vGCGCOU ABv uVWEP  ]S
)$R3)S  *w|]SMUEE        t
h5} u1aMuFt+*E
&    +E=   v
;UwEm]0Ëuȍe[^_ÐUWVS}   U~Ӄ       t
h4|ڸ+	&    1۸    t
h4u1Uv KCt'*E
"+E=   v
;Uw0ڋEʉ  &    }wE   U~UE       t
h3   }ET8BÅ   s1uu
Stk   }t7!փu)]})ًC)ʨtVaFL2{	KڸtSу+M~,EJ{	ǉ{A	&    1۸    t
h2u1Zv KCt'*E
"+E=   v
;Uw]mE0؋}ȍe[^_ÐU=PZ tPZ    KLZ   8D4<@=uh`y5$豝Ív UVSM4tuQ      YAt*$
Q)$QP)S)|  _&    ;Xs;sځ  2Ƹ    t  P1ډ    t  Px1e[^ÐUuyu  PCÐUS]du  \!SR#]ÉUS    t
h!1E  ø    t
h1؋]ÉUEtHPu$Du1t& BBUUEwP$`z    >   1   w'         1Ív UWVSEUύTÅu1   s1uSti       D7!ȍp)؃)ًC)ʨtVUFL2C	KڋESу+M~ EJCECE؍e[^_Ív UWVS|s  ǋUZ)D81p9|aj ЉE؃9uJPЉǃDtЅu.j Љ+]~+

UZ1)5)UZ   e[^_ÉUWVSuF~Ã	t&        t
h.<|ڸ1۸    t
hW.u1L{Ct%Љ(Ȉ:)=   v:9w0؈>e[^_Ív UVSu       t
h-ÅuE    t
h-t
t{   Vh"z5$hsv St9    the-S
)$R+Sw  ڸ[    t
h -e[^ÐUE~
v    at1US]t9KCt#$
S)$SP)Qv  ʸ]Ív UVS    t
h,t  Ph,  uߡ8@Z4DZ84(vt	j ЃvHZvt
j j v    e[^Ív UVSvt5HZj Ѓ
HZv@Z8DZ4    &    t  P+  u߅t
hq+e[^ÉUVSvt5HZj Ѓ
HZv@Z8DZ4    v tj   P+  u݅tj h*e[^ÉUS]8    S4]Ív UVSu]8    <    SVie[^ÉUVSu]@    rSVOe[^US]vt	j Ѓvu2C~
v    t:16t&     t
h)    t
h)SJ]ÐUWVSM   qAt#$
Q)$QP)Vs  ~;ps;5s  :ǡvtj Ѓ    vt    t  PA)]t    t  P)e[^_Uul  u1US]؋Mt& @u    A@u؋]ÐWD$T$։fʨtL8D    @t58-     @t8     @	    1ѿ   1ρG   1ѿ   1ρG   H1ѿ   1ρG   1ѿsm1ρGubH1ѿs[1ρGuP1ѿs>1ρGu3H1ѿs)1ρGu1ѿs1ρG&1_Ãt8t@t8t@t8t@_ÐUS]U    C
Bt8t)    ؋]ÐUS]U)ЍHBu؋]ÐUWVSu1S-t
SVR@  1e[^_ÐUVSu]Sj V  t)CPt SVP
  v 1e[^ÐUh   h`Zu   ÐU WVS} |E;\}   5`^t
	9d^t(jhtzh`^	d^։1IME M}O)ي`хuUE9vRV]S  E9Es+EPWR  } t]ED E&    jRhSe[^_ÐUWVSEMuǊ@uv3A@t=A@t3A@t)A@tKuՃt
A@tNut@ e[^_ÐUWVS]U}11ɃvFv C
BtI8uEC
Bt;8u7C
Bt-8u)C
Bt8uNuŃtC
Bt8uOu)Ѝe[^_ÐUWVSU]}OvLBt+BAt!BAtBAt
NtBAuՉ))É؍XutBAKtuA Kue[^_ÐWV1t$L$͉f      8u  F   th8uk  F   tO8uR  F<      uF    uF
FuF
   1ׁG   1ʿs1ׁGuV   1ׁG   1ʿh1ׁGoVsf1ׁGu[1ʿ61ׁG=Vs.1ׁGu#1ʿ1ׁG"8ut 8uFt8uFt8uF^_ÐUWVSE]8   Kt& CM   9uHMthpCte9tCtY9uCtM;UuKMKut+EFM9utAMF9t؋uu    1e[^_ÐT$D$ up^1QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQj j j j j j t'HtHtHuӍBtHtHt	Hu@@@P
8tJ8tJ8t	J8uBBB   9t  tBp^1VWD$T$t$H  ։fʨ   8g  @N?     8O  @N'     87  @N   &    1  1ρG   H1   1ρG   H1   1ρG   H1   1ρG   qr[1st1ρGuir;1sT1ρGuIr1s41ρGu)t8t0@Nt8t(@Nt8t 1t@t
@   t@_^ÐUWVS]Eߋu)9r'vك)<t& ƍ<v&)ONON؍e[^_ÐUWVSu]Ev#	Љ	Љك)e[^_ÐUWVE}uvك)    e^_ÐUWSU}1vك)e[_ÐD$L$)   t$TPtTPtTPu@@@ÐVD$t$L$)<
0tZT0PtMT0Pt@T0Pt3s΃t80t,@It+0t@It0t@I@I@I@t Iu^ÐUVS]M9u125H	8EuCUAuU%   )Ѝe[^ÐUWVS}u]9t=t9
H	MMFUCt8tU%   )Ou1e[^_ÐUWVUE׋uvك)t& Ѝe^_ÐWD$T$։fʨt)8   @t8   @t8   @    1sd1ρGuYH1sH1ρGu=H1s,1ρGu!H1s1ρGu똃t@t
@   t@_ÐUWVSuU1ۅt1)Cu؍e[^_ÐUWVSu1ӃvxShEu   q&    ;EuM;vz t 
    KBFuхuE0{M    E     ME     M    1e[^_ÐUWVS]Uut 1IMJ)tCe[^_ÐUWVSu1ӃvWڋERM1Eu   5M;EuE;vz t KBFu׋M1e[^_ÐU0VS]M߉MЍ   =  wu
   v M؉MM܉ME    E   E   uEEjP	9`ti  ]ߋj EPE@PEPVRBЅtttEE؍e[^ÐUEut^Puuj    ÐU,WVSu}]u]܉]KME    E   E   Eu|^EuM܉Mྠz   	9`t  uԋj EP7PEPEPRBЃt:t't"tthzjNhzhz  t
tuB9]t1; u,uH uhzjWhzhV{  v 1,])%t& u	t& f T   ؍e[^_ÐU(WVS}]H  %%?)ĉ}/  EE    E   E   ؅u^Eu
uE    	9`tK  } u8jEPj j EP5BЉtu;E  E0MM؋j EPȃPEPEP5BЉt8t%t tth{j]h{h{o  t
tu])  T   ؍e[^_U@  WVSu]E    E   E   Eu^E	9`t8     M1VF MT1MMuj QQQQP@ЉËU)ǃtt	   z    h@|jUhL|hX|4  t&   PM1
  MDu]j PQMQEPRBЉËUЉ) t
tuSx uM9uh@|jthL|h|  t& u@E uh@|juhL|h|{  M    OtKt(t#tth@|jhL|h|C  v ttt T   [^_ÐUUM1: t1t-@: t$It!@: tIt@: tIt	@: uÐUWVSǸ    t
h 9=`v  ?suO  j j G1hp}SC À;.uWC؀; tv 8@t@8 u9t=)Vj S$t
)	&    B$)ĉ RSPƉu_P1t& B</uFu)ڍB$)ĉeڀ: tL	BA: uw/Au/A EPMV}E:j  u}t1t& EEPMUV}j  u}t
1	    E= =`    t
h 
e[^_ÐڋL$\$N   ̀=  ÐUXWVS}? u    1N  ^u[Ë3h  hu}@  |PA  ^;t^
^   00^}6EPWj:  zE%   = @  t    [h  W4@  ǃCEPWj{;  |JE%   = @  u;jjW+A  |*E=  w
  v ƍF0PjÃuuƋW@  1&t& S0Ss;    tj CPq؍e[^_ÐUVS]u    :    tCP.3    tCPSV?  e[^ÐUVSu    t3FP%FF    1҉^CVCF; u+F;Vr݋FVUURPv6'   1۸    t	FP|؍e[^ÐUWVSjj EPZ?  EEQeMM)]u})e}US   ̀[E= vEUډE}u E   &    j MQ}W>  nE9se    SUUMM9wċ{}~UfVF
 KQ{
WVuCÃUU9r} t}M9+ue[^_ÐUWVS    t
h$
^uq^   h   o^Q&    ƃ>"ub^   ^P5^蝾Ãu>5^>^څt)EP5^Rh^MQI  u=^ uE    =Ë;    t
hV;Ee[^_ÐUWVS    t
h0$^uq^   h   o^Q&    ƃ>"ub^   ^P5^蝽Ãu>5^>^څt)EP5^Rh^MQ  u=^ uE    =Ë;    t
h0V;Ee[^_ÐUWVS}vt#H
vȃd~
v    =v u3MQMQWMQ聫  u
M9   M       Hu<EPh}EP脟  tH   EHE^q^EU[t& =w tu+  'SMQMQWMQEЃƃu;"tj VEPh}EP*  tuM9	M    tt& 1e[^_ÐUWVS}vt#H
vȃd~
v    =v u3MQMQWMQa  u
M9   M       Lu<EPh}EP$  tL   ELE^q^EU[t& =w tu  SMQMQWMQEЃƃu;"tj VEPh}EPʛ  tuM9	M    tt& 1e[^_Ðڋ\$z   ̀=F  ÐUj j uj#   ÐUj uuu
   ÐVSt$T$L$\$r   ̀[^=  ÐU  WVSEllC    u   Ev      JyM hQVj #t
      tPj j}&AË;j hQj;t& tu7SlSz   d8j hQjd9 j hQjxSlS3   ƅtl{d~pƉX[^_ÐڋL$\$   ̀=  Ð   ̀=n  ÐY   ̀=sQE     ̀=3  Ðڋ\$   ̀=  ST$L$\$   ̀[=  ÐUWVSE    $}   tV9uD4]        )ĉ49uSRQF9u	t& SRQ(GCu5dRuFe[^_ÐUWVSǉVW7 8uX   > tVt& AuA)ĉ$}|$~Tt& IS36 e[^_ÉUWVSE    E8 u蓾    K  j/MQtUE9  t& h}VÃu,j j j   B$)ĉ$:RCPj   }1щMҋET)ԉސj:SVƅu
j S9uMQEPW~#)RSWP/BMQEPR9U\臽
t t :&    ttt
't& E   F^} tC 
   e[^_UWVSE    $}   tV9uD4]        )ĉ49uSRQ9u	t& SRQGCuRue[^_Ð   ̀=  Ð   ̀=~  Ð1   ̀=^  ÐA   ̀=>  ÐUp  WVS} t} t	E t    ?  E  j{MQCÅ  }1ҍЃ%?)ĉ+URMQPK1ʊ[u,t5}t0t,{u   B߄t}utNBuuht\ր}t_1V^&    u,t7}t2t.{u   B߄t!}utOBuu
t& օue
F1щ E uM    A    E } QV)QSPRMQEP QPÃt"t u	MQ  )  t& 8}   Cǅ    ڊH u@,t{}tr ti{u
ǅ   B뾍&     tI&    }u tB
uۀ uh}h  h}h}%  t& E9t11  E    j/EPn(uSE
Pt+M9~u#$1J    E(ǅ$}ǅ        M9(u#ǅ$}ǅ    (   t& ( M)  $)ĉ㋍ QEPS $((9 uS vJEPMQEQ$PuMA$eEA	  U P  M uE     @    M	E  $8~6  Pt	/  h},t	8    jGo0 Pu   J)̉RP5/    jF10 ʶ u   C$)ĉ0}$蘶:"uOۍK)̉VSQWPS|   t0@ t9 uE@B  ǅ}$y u$  1J D$)ĉ㋍ Q$@PRQSYRN$  j/$Pu%$AF    ǅ,       +$B$)ĉR$@PS  jF. " u   F$)ĉ}䍝,,t& :"pF$)ĉ
SVPWQ|,tr1ty1I tэQ1ҋL
)̉RPQVSR $E@0  (   MuQtEP$QE@ ЉMQ$PjJ$    E%   = @    M]tQ   REp苫MQu
     t#Et& MI    E ;PrM1Y$PMQ< uR   b  KED    MH1E  EQ$P
    MQEPMQ   P$QWÃ  1U9s{E M9QEPQE4(Qk  Ãt/  E)Q@<WM4[    FU9rM
M9  E  (1щ]t&MITT
REpkMQuP	       t%M&    E@    M;Qr1;u   4M1ҍzE
tPSMI щPSj;!     D%   = @  uwLQ(EHMA< j  Q(PWS4/BRE F;uMA    EA@PqtMQ       +      P     MQEPMQ$P(Q  Ã       EtMY9sڋE)Q@R$Q     EP	       Q  EP  h  v Q  EP     F  Q  EP     &  MQ       E   M;   4t& E
tQE@4MI щPMI4j  uXD%   = @  uFE@<1ҍrVE@43fD2/ MICE;WMu2Et	X9vh@j)RMI4V1[^_UWVS}1JUuE8/uE    1;]   MME81֋ED0Pٙǃu$tM<K7'u   KEPMQW/BVE0RM1E8EC;]k1e[^_ÉU   WVSuE    E    EEmue1ۋU
MtT<[t7<*   <?   2v \t	]t!} tz tB      B: uE     }1Ӌ}JUT)ԉSEPMQEPV|/BRmMt"EPVMI щ       EPVj     M   } u:ej	EP        E     t& MtEPMI	EPqE} u9t2MQ։uEt
     E       } |   1҉UM@tME    MEEe       } tMQE@	MQÅt; tE tS
tuÍsEPVMQ  u1эyQɖS  WVs M]E[} ugEtV}1ҍZE   e$    R\EP  SMQp@ }    E]tPMTt& ETRMq^EP   tMI    E ;PrM} t"EPMI E EMuދE@    MEHݨ} t"MtEPMI	EP讨} u   1҉]蔨MtEPMI	EPAi} t MQt	RXE Eu   d[^_ÐUVSuNt(1ۋ9stPNC9rQe[^ÉUS]1ɋUE<[t,
<*t1<?t-2<\t<]t(    tz tBv    t   	Bu1]UEU 9u1 u   tRPU v ÐU  WVS]uCz  }&    tH	?t5*     t& [  \tb  t&   Et	/  E  .  ;u    ~/    Mu&C  tѡH	tH	9{  N  v ;<  _  EtH>.uC;uK  Et4~/;  (    Et	>/$  ?u
>   FC?tЀ*tˀ   Eu\u	v tH	K   [t/tH	9t't& ;uE$PVSL  F> uE  =^ u"h}t   ^  <.uEt;u  Et
~/  </u
E  ǅ    M<!t
=^ }<^u
ǅ    tCCtH	 u@\u7X  tСH	C:b     [ur;:um1    cB     C:uۀ{]uՃ Pp    PPPZq     H   tH	9   ;   C-ua<]t[C u\uC,  9tҡH	;~59~(C]M       ]tg    Cu\u
;    C-[u#;:uCt|<:u{]t]u t-StH	;u<&    9u(FCtMt</u1   [^_ÐUSEU=O  =L  }H=  t1tI=  B0=P  t=[  2 }   4t& }   $t& ~   t&     1t
uPR؋]ÐUWVS
`_M
d_M
TM=l_ C  ;
h_7  FV6Ãuh_    l_      5h_5vSh_JE)PQ.5h_v   M9M   MMM)MMM)MM9M~Z19}LMMM)M]Mu=l_ ~vvG;}|M)MN1;}}Av ]Mu=l_ ~vvG;}|MMM9M#T+d_`_d_e[^_ÉUWVSuT`_d_T_    h ~
\_-uX_   F-+u
X_    FtX_    
X_   =\_    E;p_   E;t_   h_   vtC; t>1эy=h_;}}Eh_5h_vuh_!WSR¡h_)PRh_l_t& l_    e[^_U<WVSP    =T t=X u2t& T   EPuVEPiEX   T_t	:   T9d_~d_9`_~`_=X_|   
`_d_9t9tuVV9t`_Tv<1u25TuF5TUB;U}E9-u܀y t;l_|áTd_
T;MthuǃuBxӅuzu@CTd_9`_tA9tuVA
`_Ed_T;Mu`_;d_t5T-u:-uz t;
l_}Xv<1uM=X_ ut  t& E
PT   S  t& ]uЉuE     1҃} tEx-BuT_}   Tuz-t+}   z uRREP  E    E    E    E
T_Mtt& =tEE u]E    ; t`T_E)PR3蚼u:U+T_;1I9} u
]uЉu	E   EЃ; u}    }    =\ tVTu46^t
	9^t&jh3~h輳^	^R5$KT_1эL

T_U  } A  Tr5TE8   u~ t@P  =\    Ez-uVu60^t
	9^t&jh`~h^	^R5$:K[t& E0Ru6^t
	9 _t&jh~h蚲^	 _R5$JT_1эL

T_uv5`?   T  t& Ex   B;U}uPT       =\ tREt0_t
	9_t&jh~hֱ_	_R5$JT_1эL

T_uv5`E8:u
:   o  ?   e  T_1эL

T_} tEuuV  u   } t1Tux-t 5T_6VEP#   =\    5TE
T_z-uQQ0_t
	9_t&jh h覰_	_R5$HVv QRu6_t
	9_t&jh@hN_	_R5$HT_`T`    ?     T_T_uЉVEP

T_9 uTt	:   =\    =\_ tHuVE0_t
	9 _tnjhah耯_	 _FuVE0$_t
	9(_t&jh{h8$_	(_R5${G=`?     &    :W  z;  E    E    E    E    9 t
P   T;U   =\ tRuVE0,_t
	90_t&jhhw,_	0_R5$F=`u>:u:t& ?E      ]E؉EE      uPTPEУT_t    =tEЋEЊ u]E    tbT_E)PRQu:U+T_;1I9c} u
]u؉u	E   E؋u}    }    =\ tVTu464_t
	98_t&jhh4_	8_R5$\ET_1эL

T_T?     }   uЀ>    Ex tF5PF  =\ tSu6E0<_t
	9@_t&jh hd<_	@_R5$DT_1эL

T_?   *  u~   T;U}EPT   =\ tRut6D_t
	9H_t&jh~h貫D_	H_R5$CT_1эL

T_u>:u:   Zt& ?   OT_1эL

T_} tE܋uuVtF1&  &    uV  v T_    W      z:   
T_z:u&9 t
P       P       9 t
P   T;U   =\ tOWE0L_t
	9P_t&jhhZL_	P_R5$B=`u>:uE:   $E?   &    EPTT_    EЍe[^_ÐUj j j uuuÍv UEUp_t_ÐUlWVS}N   }E̐t& KE)ME`Uuݍ{_Ѝt ]t=    VWRxuڋ
vt& Buuɍe[^_ÐUE    E    EPEPuj  ÐU@WVS}]}u,Sj   ̀[Á vOۉ   MSj   ̀[Ɓ v"މ0   }t           EC    fC  EĉCEȉCEʉCẺCEΉCEЉC C$    fC(  EԉC,E؉C0E܉C4EC8C<    EC@CD    ECHCL    CP    CT    e[^_ÐU@WVS}]}u,Sl   ̀[Á vۉ   MSl   ̀[Ɓ vމ0   }t֍           EC    fC  EĉCEȉCEʉCẺCEΉCEЉC C$    fC(  EԉC,E؉C0E܉C4EC8C<    EC@CD    ECHCL    CP    CT    e[^_ÐU@WVS}]}u,Sk   ̀[Á vۉ   MSk   ̀[Ɓ vމ0   }t覌           EC    fC  EĉCEȉCEʉCẺCEΉCEЉC C$    fC(  EԉC,E؉C0E܉C4EC8C<    EC@CD    ECHCL    CP    CT    e[^_ÐUWVS}u}t֋    G^M]Uff	ڋMS   ̀[Ɓ v荋މ0e[^_ÐU@WVSu}]MSl   ̀[ǁ vA߉8         EC    fC  EĉCEȉCEʉCẺCEΉCEЉC C$    fC(  EԉC,C0    E؉C4E܉C8C<    EC@CD    ECHCL    ECPCT    CX    C\    w    1҉Ѝe[^_ÐڋL$\$c   ̀=B  Ðڋ\$<   ̀=&  ÐڋL$\$   ̀=  ÐڋL$\$^   ̀=  ÐڋL$\$'   ̀=  ÐST$L$\$   ̀[=  ÐUE@tU1R̀PuÐڋ\$   ̀=F  ÐST$L$\$   ̀[=   ÐST$L$\$   ̀[=  ÐST$L$\$   ̀[=  ÐڋL$\$!   ̀=  ÐST$L$\$7   ̀[=p  Ðڋ\$)   ̀=F  ÐڋL$\$?   ̀="  Ðڋ\$*   ̀=  Ðڋ\$   ̀=  ÐUWVS]MM=x_ t=h tʉ    } ut菇    1f  E  u}WtƃuؐY
M=x_ utMS   ̀[= v	؉|
      &ux_   h    "utaVVچM}O}WVh
  tD>/u59r V諚0 u@PV~Åufh   q 
t$t
h   VM} uVM1U"   Euu} tV'Ee[^_U   WVSEUt} u} t
   1  E   } uUR`rxuԐt& ExxuLN UpRhj^|EUEUU|pPhj-_EUEUUUE   EEE9EuU9UuE9|M  U9U   uFE<E    WRoqÃEPURSXE<T  t& E<E    WREP|Ãx  UډUEPSUR }]EpPURj"1  EUdhU`ƅ_ E9duU9htƅ_EP=l  ׃    UUE)X   .u    f.   _ u|9   TGXT?)ԉ㋅XPURS/AGPQ\pRSj
|E9EuU9Uu|9EUTlR#ǃ-u(݂ǋlP蝹u     P1эy+x9w{} l  eURxP|zD  MˉމxD)DULH)HHPDRVެ)WPPVˬN/lR˸dhEU`|E9dU9hE9`UxT9uN/}tEP莕)LLRVxP9dtxblPxR@3   "    lP"   }t	UR18[^_ÐUpWVSEUM1щMEPE  M1s      E9tM9    Z޿       ޿       ޿       Bxu;5pvG5|_u    pPl|_   EHPMQR肨/WSM
|_Q艪EP5|_j8uE%   =    uE9EuM9MtHEP蹶MQCnE1@v MEP1'MQ|_l2M
|_Ѝe[^_ U   WVSǅ    ~EP     jhEPgrM0K)`хu9sBF;r =t u1t  h   j_ut    1*  5t5_Pe  t!_:[t;
ts _   EPEPj|WhjUu>@%   = @  u,PPuUM&    }1҅uft#PPuUMqu6t-ǅ   PPuUM7Ѝ [^_U<EPu"  %   ÐڋL$\$S   ̀=ҋ  ÐST$L$\$U   ̀[=  Ðڋ\$
   ̀=  Ðڋ\$(   ̀=f  ÐUDWVSEӉME    
_uy  _M؉ȃ%)ĉe)ĉe)ĉeQUR֤}WEPɤWUR迤}}]̉9P  Uȋ}$  ;
_   q5_F%)ĉe)ĉe)ĉeЉ+]SUURKS}}W>SEEP1UR}WEP E$UR}WEPEUR}WEPեEu؃U
}ftMăeUċE}EftMăe}ċU<EUftMăeEċ}U
;M~}tM܃EEEE9EMbmM)ˉ])ٍMċM+MĉMe)Mċ}čMčMEA}u1QUR}WEPUBR  E   }}M9   Ήv f  E|tMăeMmEċU}t
f U
MăeMm}ċEU<tEMmUċ}tE9unEe[^_Ív UWVS}u]=x uM yEUS   ̀[= v؋U}%M9&uMU
x   ى}e[^_ÐUE@%  UE8 |
@%  1Ív UMUt#vsx        A%	ЉA1Ív UUMtv+x    !u
Jt& bB%	ȉB1ÐU0WVSEt
t'&    tT  'T  T  w       U
M܋BEBEBEBE}փ   fU܉URSMQq  ƃujT  ub;wË;URhT  MQE  ƅt;1;Uz}ЁeЀ  MMԉ%  9Eu0t09t   e[^_U$VS]EPhT  u   ƋE܉ECECECECEjPS'j
P\e[^ÐUEPhT  uy   |EÐUuhT  uU   ÐUVSu= t	=P tj T |t
PuT |e[^ÐST$L$\$6   ̀[=Є  ÐU   ÐUEPjS |E       ÐU  WS]uiu    QxP t	71;MwQRSߟ1u $   p[_ÐWVS|$ t$T$L$\$   ̀[^_=  ÐUj juM  ÐUSCeM)ˉ]e)]EU)ʉUe)UEUBj Rճ]U    uD=| uh   `_|   _t*h   Ph_uC   hEh|11Uh   `_U塠_tPڇU  WVSu}W}WV7  j
Vt  0v  j
Su}Wh   SZ7u1ҊB2< t<	t2t#yuǅ    1Eр t	u  .t& 	tAt ut     u}Åt'1Ɋ < t<	ut& A t	tuǅ    1M&     t	u  /
t& 	tAt ut     u}GÅt&1Ɋ < t<	uv A t	tuǅ    1M&     t	u  /
t& 	tAt ut     u}GÅt&1Ɋ < t<	uv A t	tuǅ    1M&     t	u  /
t& 	tAt ut     u}Gt!PPhR"
1(t& 1tu}G    }G    E[^_ÐUWVSu1эyEX19ty,ut
=t,u$j,S跍ÅtCVS覔u1e[^_Ív Uuu&UVSu]jj V1u$sssss3hV!v    e[^UEtPt"   ÐڸZ   \$̀= ~  ÐڋL$\$[   ̀=r~  ÐST$L$\$}   ̀[=P~  ÐUWVS}EUщUMuEMUSø   ̀[ǁ vn߉8tƉ	v u}e[^_ÐVSt$T$L$\$   ̀[^=}  Ðڸf      L$̀Ӄs}  Ðڸf      L$̀ӃS}  Ðڸf      L$̀Ӄ3}  Ðڸf      L$̀Ӄ}  Ðڸf   
   L$̀Ӄ|  Ðڸf   	   L$̀Ӄ|  Ðڸf      L$̀Ӄ|  ÐUUE02nUVSu]36XusvFe[^Ív U8WVSẺM1E   F@uuȍ    )PYEE  E    E    ]3}̉}N} d      )]\]Eȋ}ǉ}]\]}|}܋]\]؃EEԋ}ȋ]|;}Ѕu]Sߋ]C }Љ]ȉ]̍F};u]3賋
}ȋ]D;D}̋]D;}G@<8/u?G6     }ȉ;]ԉ}    B]܉B}B]U  }t+=w tRy  EEP҃E   ][]EȃEȃEȃEȃEȃEȃEȃEN}    F};7s`    )]É]̋}DEȋ]ȋt=w tPAy  }WЃ]̋}7  8]̃E8F};7r]S}    ]    } u<E   3E   NVv ]}    }    ]    Ee[^_ U   WVSẺUȉME    EEE]uˋUȅuỦ]UE    E    hDLh_]SP t
IuBM1	  E       t
h?}u}ċUȅuỦ}UE    E    hDLh_S`P t02vE0Ju    zhЯk}    䉥lM$1JT$D$    D$    D$    D$    D$    euĉ4$JT$D$    D$    D$    D$    D$    lfD$EPMĉ$1JT$D$    D$    D$    D$    D$    et$uE-  t& 
vMuV;U    E9F    MQuvHE89vRMqWĉ  uvE9p  MME    uuGFM9At  V0ÃuZuMȉMQ  ủuF  U<  EXu,jRÃS|: tMAu^  j EЉEPjM1SS=   }   uEԀ<   E      DMI0M  \t[WDEt09r6耉E$)ĉ+DWDPStǉDMWE  t& u~   Fu\uX\FuGWDMD9   选M)̉+DWDQSǉD   t& <   u6EM   uԉu0)щDEt09r.耉E$)ĉ+DWDPSrǉDMuE)QuRWIEEu;Dt DM}   uvE@4ƉDMIuv8MEPMQ t$}   uVEP    } tM9D|
uu9u}DEMM} uSu4$1JT$D$    D$    ut$ED$D$    e  &    MQt    UrPuE$1JT$D$    D$    ut$ED$D$    Mac  u9D|R  E9EF  ]t3MQЂt[uu\u4$1JT$Dt$ED$ML$ut$D$    E L$M       S;D   u9s   ECMK]tBSt4B4CB8CSztv G4CB@8CRBǅu[u]tK&    Ss~z4{FR8ЉDC;}|	uM9}]}Du[uE@DEMIu9Nt0E@HE}MI@M
uvLu} 
E@E} t+]u]ċUȅuŰMQuVًEEE     M    uuuEĉEMȉ|u	ủ|E xM	t}1щp|щDptV>NÃt\pPMQsVEDP|QpR'SxstChDLh_S0A $    t
hZE8[^_ U WVSEUM1E        uT= u         t
h=v u1    t
hڦ   \  hleh밃=v t]]]h0Lhv}}WF t p1]]h0Lhv}WF t
 @EE    ]S}WVMUE_E   3]       )E|}EȃEN]x;uX]}D)  uBF];3s+    )E}];+  8}F};7rE   
    u    t
h艥Eu]; %   e[^_ UWVSÉE        t
hAOt@    )4\t& tu1+  Eu    ȃOu׸    t
hEe[^_ÐUSvthPE vt@ËC@t   CLt   CDt   ڋ[HB<8/u	RSru桤_th[PxE ]Ív UWVSu1NMV9s>1ۋDt+=w tPk  VPDЃNMV8G;}rrqN    )FpqvqVqe[^_Ív USËC@tCLtCDtڋ[HB<8/u	R_qu]ÐUWVSEU=v   G;Uv	U    RwMQ~   M;O   uM;Oup      Fu&jR^S/ tF^؃t2j ]SjMQP|2 u} uCM< u   FvDwM;Ou	1/t& H}@L	t& %   e[^_ÉUlWVSUMh
PEE    E    E    q  M  t& }Wj
EPEP  ƃ)  ]]j#Syt      }|7
uD7 ]=@	}}DW tE]}DW u9E  ]]؀; t)}DW u&    E]; t
}DG tE+E؃  uؿ    x  ]}DG tE]}DG u]]ԉހ> )  }DO u)L	EF];   @	DH t׋}?    FUBU@	]DC tE}]DC u}? t8]DK u+t& L	EF}? t@	DH t9n   F+UԉUJES  +uԍFPvFE9  V]SP~}EGh0LhvW/@ uh0LhvW|9   ]    uؿ      }}]܉]̉G}܋]}DW t    E]}DW u]]E    ; t  EDP uSPu$}<-t</t<.t<_t<(t<)tE   L	]C]; &  @	DP t}?    G}}}@	]DF tE}DF u]  DV u5t& L	E}G}]  ѡ@	DP tЄ  } G}@	]ڍv E}DB u]]Mt?}DG u1&    ]}EG}]Mt@	DP tքu} G}0    ] C]Ej j
P}WE;}tE   ]  </uE    t& }G}E    ]]})}}vރ    tE   } tUE    ]@	Bu<-t</t
<.t<_u4E}ȋ];Bu;<-t</t<.t<_t
E+EHE})}]Ћ}DPEPjVE  u+uV]SPP!}G} t]}_]]})}]SW}wVG0]_4]̉_8}]S<} tEHP}WR~/B]S}WR~} tB} uG]CEh0LhvEP7< t$Si      ]}_H   Ev=v    }?}W]C9vR}w]svu|SG9ub3u"s&    }D}][D]to}uGPVsuЋ]s0}w0suuA798]H}}@}
]L]}? /}];]Et	Ph}W.e[^_ U<  WVShǅ    ǅ    3T u<1эq)QRP~E1эqQ)ԉjhVSU|:BRF|B<:tu1щ<:t	BǄut Bʅ    &    PR?tc1эy)̉jhWVS{/BR{PVB:tu1+р:tBuu
v  Bʅ:ǅ    ǅǅ    < u/h0LhvV8    ǅv=v    SO9vRswosu{WK9uc7u Gt& sD[DthuSRPjpus0w0Vpuu;19s_H(H}@L> 98PPǅ   t& @1эq)QRP{=@	DW tADW uˀ; :  DW u$L	AC9   @	DP t܀9    CA1=@	Dw t
ADG u9 t2DW u(    L	AC9 t¡@	DP t9    C+Wuy+؃PU<ÃtYPVCPYzSh0LhvS6 uh0LhvSW/ u	Sbc JEO2[^_UWVSE11MQmt	 Cvvh̅jHhh ^  GGGG    G G$G(G,G0    e[^_ÐU$WVS}u8uw uuvu} t61ۃ =  V$\  juVj j uVuVu։      EwuE    uue    u9uvOEuV[  j uVuEPuVuVuփtMU9t)ʋu)
v u1ۅ   uu܋uM܋U)ڋE)9~Ѕ}19s3ff1@9ruu;Mu   ;]u   	t&    Ã EEuG؍e[^_Ív U,WVS}8}} }}}} t61ۋ} t  }WZ  j}Wj j }W}W}׉M  }E}E    }}؍}}l}9}v\}E}WDZ  j }WuEP}W}W}׃t"MU9t)y})t& u1ۅ   }}E    }uM)ًE)y9v; |<CJu}} u7;]uE   )F;EvE   E   }E   )Ћ}}}؉7]ԋ} EE}}G؍e[^_ÐU(WVS}8}} }}}} t61ۋ} U  }WX  j}Wj j }W}W}׉.  }E}E    }}܍}}it& }9}vT}E}WX  j }WuEP}W}W}׉tUE9t
)})u1ۅ   }}1}]؋E)yU)9v9w+CJuu$;Mu   ;]r         ؋}+}}}܉} EE}}G؍e[^_U\WVSE8EU U@E} t91ۋUz   PTW  jEPj j UREPU҉\      E EURUE    EEUU  &    E   L  t& E   <  t& E9E  UUEPV  j URuEPUREPU҉Ẽz  ];]Q  UEE܉E]E    UEM)y+]܉]*}+}9      E0}hUh   hhhxlW  wE@Eo&    E   1ɍ&    #@tE}v]];]MUN]M&    $?U
MuEOK}    E   U9U   E9Ep};}QU2}hUh   hhhxV  w
UBUdE   1ɐ#@tE}v]];]MEN]M&    ?ʀEMu}E9<MU+
yEEUEUU9UthhC  hhԆU  }thhD  hhU  ]E     E     u1ۅ1  E EUUE    EԉUЋM)yEEU)U*m}+}9      Eԋ0}hUh   hhhxT  wEЈ@En    E   1ɍ&    #@tE}v]];]MЋUN]M&    $?U
MuEOL}    E   U9U   E9E}ԃ;}Uԋ2}hUh   hhhxS  w
UЈBUdE   1ɐ#@tE}v]];]?MЋEN]M&    ?ʀEMu}ԋE9<MԋU+
yEEԋUEЋU]؋Uz EEU    UB؍e[^_UhWVSE8E} }@E} t91ۋ}   PQ  jEPj j }WEP}׉      E E}}E    EE}}  &    E     t& E     t& E     t& E9E[  }?}EPP  j }WuEP}WEP}׉Eă  U;U  }E8E܉EUE    }E}}E)E*E}+UM+MyM9vUEM   }w	G}   %   =   u   l%   =   u
   S%   =   u
   ;%   =   u   #E   J%   =         9s'EUe   }   u?	C9ru}}EEHE} }   E      EE}9	Ew@   %   =   u
   k%   =   u
   S%   =   u
   ;%   =   u   #E   ]%   =      }}E9   9s'};Ue   }   u?	C9rًEE}EE}9}UE+y}}E8}E8E9Eth hC  hhԆ_O  }th hD  hh=O  ]<t& E     t& E     t& E     t& u1ۅ  }?}EEE    }Eԋ}}E)E*E}+UM+MyM9vUЋEMЅ   v }w	G}   %   =   u   ot& %   =   u
   S%   =   u
   ;%   =   u   #E   J%   =         9s'EUe   }   u?	C9ru}ԉ}ԋEЉEHEЃ} }   E      EԃE̋}9IEw@   %   =   u
   k%   =   u
   S%   =   u
   ;%   =   u   #E   ]%   =      }}ȋE9   9s'};Ue   }   u?	C9rًEȉE}ԉẺEԋ}9}UԋE+y}}E8}ԋE8]؋Ex }8}E8v E@؍e[^_U,WVS}8}} }}}} t61ۋ} }  }WJ  j}Wj j }W}W}׉V  }E}E    }}؍}}l}9}v\}E}WDJ  j }WuEP}W}W}׉t UE9t)Љ})u1ۅ   }}E    }uU)ډE)y9v    ff%  Iu}} u&;]u	E   F;Ev	E   E   )Ћ}}}؉7]ԋ} EE}t& }G؍e[^_U,WVS}8}} }}}} t61ۋ}   }WH  j}Wj j }W}W}׉]  }E}E    }}؍}}c}9}vS}E}WH  j }WuEP}W}W}׉tUE9t	)})u1ۅ   }}E    }uE)yU)9v9  wHf9ff>Ju}} u<;MuE   .&    F;EvE   E   }E   )Ћ}}}؉7]ԋ} EE}}G؍e[^_ÐU,WVS}8}} }}}} t61ۋ} }  }WG  j}Wj j }W}W}׉V  }E}E    }}؍}}tt& }9}v_}E}WF  j }WuEP}W}W}׉t#UE9t)Љ})t& u1ۅ   }}E    }uU)ډE)y9v    Iu}} u+;]uE   t& F;Ev	E   E   )Ћ}}}؉7]ԋ} EE}}G؍e[^_U,WVS}8}} }}}} t61ۋ}   }WVE  j}Wj j }W}W}׉^  }E}E    }}؍}}ht& }9}vS}E}WD  j }WuEP}W}W}׉tUE9t	)})u1ۅ   }}E    }uE)yU)9v9  w=ffJu}} u4;Mu	E   &F;EvE   E   }E   )Ћ}}}؉7]ԋ} EE}    }G؍e[^_U$VSEh<h_EP^ uKj`"Ã  ECC    h<h_S uSI1ۃj  CJ  E    EٺPL9  Ut
RGIu[CEE@E    EMl9  Ut
RIuE@E1Cu-  1       CEEFE    EMl8  Ut
RHuE@Et& 1CCEEQE    E܍MlO8  U܅t
RJHuE@Ev 1CC   { t@}   C؍e[^Ív USEUE    EMl7  U؅t
RGuE@E1]ÐU壬_h5_l 1UEUR@)ÐUS]   <  C]ÐUS]C    SCj q    C]ÉUSEUtu8;_u	C    'C HKȃ}Ct<  C    ]ÉUh5_ Ív US]CtU<  SF]ÐUWVS}1JU	X@E   v 1ҍB9EuuߋM tӀ; u10euȋUE%   	mE%   	mUЍe[^_ÐUWVSu	H8X<119s =P	}t& }94t@9r9rtD	!EEv 1e[^_ÐUWVS]]|18}     M}}䍶    С@	DP-  j j }WQG  ƃu018"  U<.uE9   z}B럄t   С@	DP    +]C   $\E=          ]U   w}E=   ws  wk4M   wUU   wJE=   w@   w8			} tff}.0}8   0}81e[^_UEPujuEÐUWVS}u    t
hu>    =_ u  _tZ_tCPURaNuCu> uCt'_tCPW1NuCu> uEuQ      t
hDu1e[^_ÉUWVS}1۾4WMt|+C_v`t 4    <> tNE  Åu.    0    t
ht>    t
ht1e[^_ÐUUE9t02:M1U8WVS    t
hhth`}W]S Ƌ9tZ;  jE܃uh`WEP 1ۃ  v M܉EMy u5ʃ _u_.  EPuMQA뜋Ep~    >1s-U؃)܉e}EGۇu?6E libn@ss_ POV.so fCff	fAA 7jhۇ6E libn@ss_ P	V .so PwUE    E|0  U؅t&R@tMIA,E؉MY{   ;1ҋuэT
)ԉeCEV3_nssfB_ RNUf_ BR=UE    ]M𺠔/  Uمt
R?uEX]1ۋE܉X    t
hq؍e[^_ÐUWVShDPǃtj,ƃu1       F    1E    E    MMMMNt& U|
uD Uj#RHt  E8 t  ttv uWMQMQ%  }u>We[^_ÉUWVSE    MM=@	}DG tCDF u  ]DF u[tCt
MDA t9]  +uF!PE  V}WE PR  MA    A    A    A   A   A    A        =@	}DG tCDB u;[-  
DF tCu!ȉMtC]t0}DG u#=t]tCtDF u=u+EuKjhFMQSu	E   }jhN}WS  EY&      jhVMQgSuE    )&    jh_}W@SE  E
@	MDF tCDF u;=  v CDB u]t]tCtDF u=u+uu%jhh}WRuE   0t&    jhoMQR   E    u} t)}   0}Myyyy0t& }M|@	UDB tv CDB u]C}M9}&    Ee[^_ÐUVS֍Xx t t& V0FFt,Xx ujt0@    @    1e[^ÉUWVS]}uW3
 tWPu(Ѓz tރ> u: u       1e[^_ÉUWVS]}u} t!zuGzuAzu;zu5   hMv
h  B<u   A&    : u.t& 8 tWPux t݃> t1e[^_ÉUWVSE=@	DG tCMDN u]Ut-EDF u}:tCUtDG tt9]u1S C}1֍FP.ǃt)VMQGP;PW    t& 1e[^_ÉUS]   -  C@P]ÐUS]C    SCj q    C]ÐUS]=  u$h hj h} uuS]ÐU(WVSE        t
hj=_ u$_   h   	_  Hwu uU
  E@	fPuuE8:Z  Iw t
      
u	E   E   }1эY 9_sP_S5_u/#Ë35_7_    _    3  _S5_[L_ӍCE{C EE E
@	DA   U   SEPV   EPEP:B_E_     G    =_Iw t9u4	    CJyCK_
   _       5_E_9&      E_\  DAu:.uB: uz.-EDAtj:EP?uE8:  Iw t	E
   E   }
u	E   E   }1эY 9_so_S5_uN!Ë35_53_    _    E    v  t& 7%     Z  _S5_^J_Ӎ{sC EM   SEPEP ~EPEP[@_=_    F    5_Eܣ_E_$     E_   @	DPu:t.uA9 u߀y.b_J ǃ?"un_   _P5_Ãu75_47_څt5EPEP5_Rh_EP^   t}t=_ uE    * Ë3    t
hCf3]t# Ee[^_ÐU4WVSuEHwu$_ u}E8E     EE  @	fPuu	>:  Iw t
      
u	E   E   1эQ 9U  R}W"H}܉}EE؉E̋} }ԉ}E
@	DA   >    ~.   }WVS1   VEP=}EG     E}̉G    ExIw t:u5]	    CJyCK}G
   G   &    EX}x!      E     DAu:.uB: uz..EDAtj:V|;u	>:  Iw t
      
u	E   E   1эQ 9Us "   
  R}WF> uy~.   EPVS F  V}W<E}܉x    }E؉8@    }G_EG      E     @	DPu:t.uA9 u߀y.fvt#z=vd~
v    =v u9EP}WEP}WV  u
E8.  }       udEPhEP Ãt   EE_=@y        v         _EUg=w tu)  EPS}WEP}WVEЃEu
}?u;"t!j EP}WhEPÃt}u
E}	}    }tEP 1҉Ѝe[^_ÐUpWVSRƋ>j jj胭Ã}
>CfE jhEPEjnEPS諬}S讑>t& ؍e[^_ÉU@WVSẺUĉMmƃuv      h  E   ]]}ĉ}jEPV葑EtV0   ,      ]S}WVbE9tV      j$EPVE$tVې      EԃuVv            U؋M܍]]؋}}]؉E9Es "   Vnm&    E}GEG]ЉGȉGEGEȉG}WSVIEV 9}%   v V
U    e[^_ UWS]t&1uuu1ɉ.   e[_ÉUWVSuuhj}WP]SV]S   e[^_ÐUpWVSƋ>j jjÃ}
>CfE jhψEP:CjnEPS}S>t& ؍e[^_ÉU`WVSƉӉMoEupy        v E   }}؉]jEP}WtW蓎     uV}W̎;EtWn     t& j EP}Wq tWC   m  Eu!}W(v      H  t&      +]MUED}u
9Er+9Es! "   }W轍  v ]}_E\_}}\}MˋUM)ĉeeE4   }t}u_]ċ}}ȋE)ĉẻE1;U}}GB;U|}G   G   E4   }}qt& }u}    )ĉeĉEƹ       }}8}|(1;U}}GB;U|}G
   G   EA}G    Q}W}WI  9tWl      11;u}Mt& }GƃB;U|}G    EE9LVG0}W.9t
W   .}W1!UE}W܋'    e[^_ UWVS]Iw t   &       1uuuue[^_UWVS]}
u
          1uuuu2e[^_UEUMutu
t   "t&       u uuuÐUTWVSEU1Ҁ8 thx t_G tNG t?G t0G tC%   11; uUE    E    vM  }}؋E EE    :}ЋRUE    E    Eԋ}Ћ4}u
  Q  =v t/j hV: u<RhEPh(j  ~0}F,@E  }E1    U   E]Ã{ to}uf{ tbC$<wY;]t!EP}}E}W\1u3} tUE}fGfUef}v9f|Eȃ}u]ċE  Ei}u]1ۅt5CЃt
t v E؉p8    }؃? uwEԋE9EvE}?}FU   EtB<   E u}~E   1ۉE1ыEDECv܃$)ĉe14Re:Cv} t}? u<u
0UM1  E     1s]=v t[j h?}WhBCP: u<RhM} t}? u<u
0URhRjl  UE[Ѝe[^_ v UtWVSEUM1Ҁ8 tjx taF tNG t?G t0G tA%   119 uUE    E    v1ɋuPË}9:t/v ;Krh`h   hwh  ACu94uԋ{}9  u6u܍}}؉Mԋ]E    E    uԋ}Ћ4u} t}95  =v t2j huF8 u< Ph}Wh(j  uF0@EċF,@E  }E1    UtxE]Ã{ tPC$<wG;]tuVEP-u,} tM}uf~Ѐfv8f|Ẽ}u]ȋ}  uEu}u]1ۅt8C%   tt!}؉uw  }؃? uuwEԋ}9}uu}G  uut& }?}E    0u@E    E    E    }u<}} tu95  =v t2j h}G8 u< PhuVh(j=  }G0@EG,@E  uE1    UtxE]Ã{ tPC$<wG;]t}WEP+u,} tMu}fwЀfv8f|E}u]u  }Eu}u]1ۅt8C%   tt!u}~3v u> u}~Eu9uE}`Eu
u    1q]=v t[j h}WhBC@8 u< PhM} tu> u< u
0EPhRj  E}C e[^_ U   WVSEU1Ҁ8 tfx t]Hʀx tNHʀx t?Hʀx t0HʉÃx tC%   11; uUE    E    vu  EEt& M	ME    ERU    MEM}u
  q  =v t2j hEP: u<RhMQh(ji  E@0HME@,pM  E1    U  E|||MMy   }ufy   MA$<   E9t.MQ|E ||Q(   u]Ep   MqV(؋Myu"t7V|(tt   0  EfCE  MI9L:uE04:*(tAMy uE  |8 u
Mf<K }E  MMEMAЃtt+MEMH  t& E8 uMMH} uWExtMMqW'MYut3W^'t[ttt& EE9Ea   EMMEȮE EEйMIMEωu	EEEEǍu      1ۋU&    <1эtCvF$)ĉ1ۋM4R0Cv} tE8 u<u
0v U1D  M    1  t& EE x7U   MtB<   E EEEخM	M̉ME EEȮǅ|   1ۍut& <1ы|D|Cvۃ$)ĉ14R/Cv} tM9 u<u
0U1>
  E     1}   ]=v tej h M1hEPhBKQ: u<RhM} tE8 u<u
0URhRj  UM[ЍP[^_ U   WVSEUM1Ҁ8 thx t_G tNG t?G t0G tA%   119 uUE    E    v1ɋ}?\WE9t,;Krh h
  hwh2  AE{9uԋ{}9  E E܍}}؉Mԋ]ЋEԋ}ЋẼ} t}9n  =v t2j hE̋P: u<Rh}Wh(jK
  E̋@0x}ȋE̋@,x}E̋  E}1    Uą  t& }ĉ}eEEȉEx   ǊG$<   E9t(}WEE}?}EP"   uh}}   EpW"}̋_D  t3EPj"(  [t݅     }f~؋}̋  E@9Du}74"t?Ex u}̋  | u
Ef<F }}̋  EċEąE}GЃtt-&    }E؉8}̉xh  E؃8 u}8}̉x} u_E@EtR}wPk!_  v t3}WA!  [t݅  EԋE9Ef}}EP  }}E EE    :}RUE}E} t}9e  =v t2j hEP: u<Rh}Wh(jz  E@0x}E@,x}E  E}1    U  t& }}eEEEx   ǊG$<   E9t(}WEE}?}EP   uh}}   EpW}_t  t3EPX  [t݅   D  }f~؋}  E@9Du}74Gt?Ex u}  | u
Ef<F }}  EEE}GЃtt-&    }E8}x   E8 u}8}x} uWE@EtJ}wP_uR&    t3}Wqt3[tu(EE9EoE}?x<U   Et
B<tsU1э͐   %?)ĉQWjh S'R'} tE8 u<u0U1  }    1   t& ]=v tgj hAE0h}WhBCP: u<RhM} t}? u<u0URhRj  UE[ЍP[^_ UA(t@      ÐU  WVSu
ǅ`vt
j҃_     t1эY1ۋ1֍PtEt(CPQR'f
vfLVPS'uRP  t& j hy t h    PQ{R tv{RP t9 t	v{Ru{Rh<uRj  (j<v USá_tQRS
#v ]Ív U   VSXTPǅ\    vt	jЃ_Ej `P	
  Ãuhvt\Pj҃    \5_PVTփvt
EPjE_X    8vtEPjt& E_\Xt1H[^UWVSEUMvtjЃ_=_vtj jЃ
_    u5_uVuփvtSj_=_e[^_ÐUWVSuU]1IQRVGqSu܍e[^_ÉUWVS}uE    EEt& uEEp      ]}} uB=E} vhh   hϊhي  MK)`хu9vt& J09wE:E	jW5 rp11Ʉtv :
tBA: u1; u)SV5 =pEEp)@PV5 ps   e[^_Ív UXVSj u>oƃ}1IEPVjj|!Eԅtj VjuPj Ãu1UԋEVJo؍e[^ÐUWVS]{}j j117 Ɖs      E%   Pj 11҉WJ E1҉\ ~ tv [{ u&      u$j E%   P  PS6A 9t[1T @   {T   5d5 w5wЃS uHJ   BEMu޸    u
P   e[^_ÉUWSÉ   uI
_t
	9_t&jhh
_	_ڸ       t
h$,=]}E    EM@=     t
h$<UtLMt
J   U1эA$)ĉeQREPD!u
1҉|Ee[_ÐUWVSE  uP 1K    th$X<u  w}  tJu        }  }u  uE    9ush}u  uK  u<CLt5  t,=v tj h7sh:jLCL@E}9}ry   Q E    u9usUv   E}9}rE      }u<}샿   j    W     tDH؋K    t& Iu92uA;Hs TAH;KrK}싇     )ƉP  WtGBt& }GwuVtFB}싇  t	PJu싆  tt	P/}w!_v ؋[P
uu싖    9t&uhJh   hTh`  R}9}tu싆  t	P}WEu9un}W=xy t,
Hv9Auvxy    RVy    O     t
h$Y9e[^_ÐUSju1Ҹ    @       ] UWh-u: Ew|tyh-
 =vt(? uv    1t1I
v}ÐUVS1559upj  Ij  9t   5Le[^ÐU=w tuu_ Ív Uuu_ UWVS}u]=P uj   TP  =w5 wdRSVWv   S@ae[^_UWVS}u]=P uj y  TPl  =w5 wdSVW   S`e[^_UT(UWVS}us&    VWURЃre[^_PYÐUUutPЅuPuu$wt
v PЅuP_t
	9_t&jhh	_	_R5$$5$פB'US]ttj/Pu@$w]U塤	@LÐUEUщ%5  		!ʉÐUEUс		  )Um}UM   %  5  	M	      )!ÐUm}M%  E    E%E		  )UE}fU%?  	fUmÐXYjQP&    XYj QPv '    D$X pxhL$HL$ H   US]1} tCPj j #%   C1]UVS]uVSV   { tj CPj"u   PS   L$D$QY qyiaUÐUuA1P+#ÐU4  WVSE$)ĉU}   }  uEHE 9  +1uEǋVWU҃uU)} CAuWVU҃}^ut& CAuRWuփ}#UCAuuVWR&9   
UVRuփ|+}WRuփ|9s3UCAuu)z9nU+}+;wO+;w+6R{t& h+;vL9~(2z&V9}EHEEU9vËVWU҃}}9vߋu9t}CAOuUu<V;   U)	u)RWuփ|U9tj\:9rb&    ىu)9r'U)9sيK9s};H[^_ÐU8WVSE    } t:
	Q U~(<t$A PEuE    } uE    } |}t}$~    G  &    uu=@	}DG t&    FUDZ uUׄ  -uE   &    }+uE    FUE    }0u>} t}u"VL	<XuE   U} uE   } uE
   u}   U׈UtD}؉}L	UE;Et"EЀ}	v}DGtUȋ;E}
AUӄu;]u.  &    M}   }? u9st& ;EtC9r   9   t& MIUU9   ;EtI9s9   E)ȋ}SU9u{y}EȋUȊIuJUȊ<t}9{   ;EtI9s9sh9r;EtI9s9s)ȋ}?9~A9r)ˋU9t}};E~	\]M9u/E9s	M1ɸ1uEȉUE    1ۊUT9tWE<	vUӉŰ}DWt=L	ɈEE;E}';]wu;EvE   ]FUӄu;ut/} t}7} t "   J؃} tB>} t6E+E~#URL	<Xu}0uOU:U}1e[^_ÉUj uuu!ÐUVS]Kx&    uE    9u
Ky19v   e[^ÐU4WVS}]E    }t4} t  &    }        }  E E̋L9r	)E   UUU]x/]uԍt& uԋủуuMyE)EUJUxu1ủуMy  t& |uvuE EOU9rw9ru+uMuE   E\]   UU؋u9u|    ;MuCE]9s+]ًE EԋűU؉2pMM]ЅtIEЉEv EԉuẺӋEẻEԉы7u9w
uE9EvM̋U+U U];]sۋE̋u؉U+UˉىUԃEMAOuԉ7h  ]ԋE)EԋUԍ<utuUTUDE9r=wUJRuVWp|#EPURWWx  EDEE   E+EHE   U9U|u4u3EDE܋UJUx\My    u9uuLuDUuÉUЋEẺ'E̋U;Dv"Kuu9urE9EsIU)U;MwtSuVEPW-  9MtVURWW# KuEUTUMEe[^_ÐWVS|$t$T$L$1Jt.Pu؍&    ؉JÉJuX[^_[^_ÐWVS|$t$T$L$|4ڋ1Bt(Pu
ؐ؉BÉBuX[^_[^_ÐUWVSu}uuDE}   } u1  &    }wIu&1;]}<MU&    C;]|1;U}Et&      B;U|1RuV}WuV[  }uu   ;]2  }}uw1u)}WuV}WW! RuV}WuV9" }uuEC;]|  }    )܉eTWuV}WuV  }u}u)u9u   )܉et& }   }WuV}WuV}W  uV}WuVV! EE}}}uu}EЉ9sCNutb}B}u(MuFuV}WuV}W  yv ;Mt 1ۋuNu9}UC;]|}}}u)u9u}    }WuV}WuV}WuVW}WW!  E]}<M}Љ9sIt<uBuuIu";]t1IM9}MB;U|}e[^_ÐWVSU|$t$L$l$ <41ۉ؉ Au][^_ÐU4WVSM+  N   }wGu*19};]MM̍t& }̋}B9|19}U    @9|1RVMQ}W?M˃E   9u}d}}ԋMԋw1uV}WSS RVMQS1 EE9u|}WVMQ}WMQ}4VMQ}S M4}WMQS 7}h  u   MMMMЋ}<}    MMMwDu'19}8]Љ}̍t& }̋}B9|19}U    @9|1RVMQ}WMЉMл   9   }}؋M؋w1u#V}WMQQZ RV}WMQ }Љ}ЃEC9|2MQV<    }EPEPMMEPV}W]S|VWSMQ
  E    VS}WMQ
  E   V}W]Sg|VWSEEPq
  uVSMQEEPY
     }}}wOu+19}C]MM̋}̋}B9|#t& 19}U&        @9|1RVMQ}WOM˃E   9u}j}}܋M܋w1uV}WSS RVMQSA EE9u|EEPVEEP}WMQ19}*}}}̋UU荶    M̉M̃C9|VEE}RPP6 E} tMQ}WEEPP  )EMQ}WEEPP E   M}}ЃwKu'19}?]MM̋}̋}B9|19}U&        @9|1RVMQ}WM]E   9u}g}}Mw1uV}WSSA RVMQS EE9u|EEPV}WMQ}WMQ}W]]SS E} tu]]̉uЋEEЉ]9s&NMЅtN}̋B}̉uMu2;]t-1ҋMIM9} }̍&    M̋MB;U|19}}}̋UM̉M̃C9|VEEPEEPP1 Eta]]}M4}̋B9sMt9BuMu!9t1ҋ}O}9}B;U|e[^_ÐU(WVSM#  N   }wGu*19};]}؍&    M؋MB9|19}U    @9|1RV}WMQ}E   9u}`MM}w1uVMQSS RV}WS EE9u|MQV}WMQ}4VWMSA }M4}WQS( 7M  u   }}}}܍    MMMwEu(19}9M؍    }؋}B9|19}U    @9|1RVMQ}WOM܉Mܻ   9   }}Mw1u#V}WMQQ RV}WMQ9 }܉}܃EC9|,MQV<    }EPMMEPV}W]S|VWS
&    VS}WMQ     }wMu)19}A]}؋M؋MB9|$    19}U&        @9|1RV}WMQ}E   9u}cMM}w1uVMQSS RV}WS EE9u|EEPVMQ}W19}$MMM؋UU}؉}؃C9|VEEMRPP E}WMQEEPP  )E    }MM܃wKu'19}?]}؋}؋}B9|"t& 19}U&        @9|1RVMQ}WM]E   9u}c}}Mw1uV}WSS1 RVMQS EE9u|EEPV}WMQ7}WMQ]]SS E} tn]]؉u܋EEЉ]9s&~}܅tGM؋BM؉uMu+;]t&1ҋ}O}9}M؋}؋}B;U|19}$MM؋U    }؉}؃C9|VEEPEEPP& Etf]]M}4M؋B9s"Mt>&    BuMu!9t1ҋMIM9}B;U|e[^_ÐUWVS}uM9M      MwDu'19}8}ʐt& MMC9|19}     B9|1RVMQW_   9E  MMv Mw1uVMQSS 
RVMQSt EG9|       )TVMQW   v    Mw?u#19}3}UMMC9|19}     B9|1RVMQW_   9}iMM&    Mw1uVMQSS 
RVMQS EG9|    )TVMQMQWge[^_Ív UWVSu}MwEu(19}9uUt& MMC9|19}     B9|1RWMQV   9}NMM&    Mw1uWMQVV# 
RWMQV EC9|e[^_ÉUWVSu}MwAu$19}5uʉMMC9|19}     B9|1RWMQV   9}NMM&    Mw1uWMQVVS 
RWMQV EC9|e[^_ÐWV|$t$T$L$؃tA)))t& FBGFBGFBGFBGFBGFBGFBG v R Iu^_WVSU|$t$L$l$ <41ۉ؃ ) Au][^_ÐUWVS}EM]M]]E%  MMU W   } uu]           t<OM_    )΋Љ	؉GM)S    M
~ʃEG        +EUӉ_E+E]	   W   e[^_ÐUWVS}Um}E
E%  ]EUWE  u{uu    k&    wwt7΃Mt    )ˋЉ	ƉwM+E]_    )ȋM   e[^_ÐU$WVS} t	EE`uE@U}t}      E1҉ÅtP}}ܹ
   v NE܉EeU}EI߉]eE	ENU}܊]N]eEUu$  E1҉Åt3}}ܹ   NE܉EeU}EIt& ]N]eEUu   M1ۅtW};Or/1wӋEwEUwEUE   1t& Eʋ}wEUE       EEE   UUM܋}܋E1Ʌt1uNEAu} t$UR9}v N0A}9|} ue[^_U   WVSEEE    E    E    E    E    E    E    E    E    E    MM؋]tE 	   0  t& } u%    0  t& EEjPMQ	{1JRs]SFu	@ EjEPMQ	{1JRs]Su	@ E    ى]tEPhtlMQ{
]SyjEPMԀ9 D/  ]Ԁ;    EP1JRS@ƃ   }t.]S;SrSȜEEȋMA}tE̋}ȃ}u>]SIy} tE} tj EP} ,  ,      M	E9t#z-  SEP賢c-  v NLH.  EԊ Eԋ@	<%   Dr tE   .  }t/MQ;QrQݛE
]ȋE@}tE̋}ȃ}  } to@	Dz t[}t5EP;PrP舛E
Mȋ]C}t
Et& k8b-  @	]DZ uE    9uV-  }%  E  E    E    E    1M9Dzt\Љ}AM9Dzt"t& ]|_Љ}EԋE8DzuMԀ9$t]]ĀM@E       t& EԋEԊ \<*t<'u4EԀ\'t\*u
MMMԊ	\*tр't̋];fz%   f`tM@E    f` t%Mč|OЉ}Eԋ]pDzuۋEԊ \} uE\\Eԃ.w^$ȜMԀ9hu
AMԀMHMB&    ]Ԁ;lu
C]ԀM)M#EԊstSt[tHE	MMԋMԊ	\#  Eԃ} u9\[   \c   \C   \n   t& +8     v }t1MQ;QrQE
]ȋE@}tE8  Eȋ
@	DA u8}tM]SEPE    \WۃS*  $}t.MQ;QrQfE]ȋE@}tE̋uȃ};  9V*  "  %   PMQ莞"  M(*  tM]̉dǅh    } uEE؋PUuNtNudh
Z)  ]t:} uEE؋P    UuNt
&    NuM̉
)  ]t9} uEE؋Pt& UuNt
&    NuMf
S)  } uE]؋SUuNtNuẺ$)  MB  M΅u;} uE]؋[]}UJt
&    Ju?}} (  }t.]S;SrS蘖EEȋMA}tE̋}ȃ}}uE      ;v }   MQ;QrQ9E]ȋE@}tYE̊Mȋ]C]Mă} ~A뱐}t8EP;PrPE

Mȋ]C}tEMă} '  E'  ǅ\   e}  } uEE؋@EuUJt
&    Ju6u}   &      \  %   =   t%   =   u<} tEMQq} tj EP< T   '  %   =   u   ]ȉ\\   %   =   u   Eȉ\\k%   =   u   Mȉ\\F          u   ]ȉ\\   Eȉ\\    }t/MQ;QrQE
]ȋE@}tE̋Uȃ}t%   =   t%   =   u} tM	]S\?	\Nyu\EEǅ\    Mă} ~Q}t0]S;SrSnEEȋMA}tE̋uȃ}\ N%  iv M  xxx   tV} uE]؋[]}UJt    Ju?}} $  Ed   jdY]U)} uEE؋@E}UJtJu?}} #  }t.EP;PrPXE
Mȋ]C}tE̋}ȃ}     t& uk]ȋE@EMtW]E9EuHM<M    WREu}GW3E"  ME]ىM}} ~	Mă} ~d}t^EP;PrP菑Ev 
Mȋ]C}t0E̋@	EDB 7tMMQ]S蹗\#  E  qǅ\   Mxxx]   t`} uEE؋@E!    uUJt
&    Ju6u} !  Ed   h  VEUF} u+EM؋IM1    Mj ]S\  uUJtJu6u} ["  }  v \  %   =   t%   =   u} t]EP$  %   =   u   Mȉ\\   %   =   u   ]ȉ\\hv %   =   u   Eȉ\\@      u   Mȉ\\       ]ȉ\\}t.EP;PrP8E
Mȋ]C}tE̋Uȃ}t%   =   t%   =   u2} tE    MQk} j W\?	\N^} u\]]\Qf  x    \]]E   M]9]   EPREEuouF    Q]3%Eu9M    EЃ} t]EPj}    j Ws   ]ME]u]ME]Eǅ\    } ~	Mă} ~{}t.MQ;QrQvE]ȋE@}tE̋uȃ}\ t1MQi} t
]&    } j W} *       E    1   E    "
   E    
   1E   }t:MQ;QrQ譌E
]ȋE@}tE̋Mȉ\	]ȉ\}  \-t\+   &    ;uu=U]4]       w   u$)ĉetj REP\]   } ~Mă\t1EP;PrPߋEv 
Mȋ]C}tẼ}   }0  } ~M;uuGUE\=   w
ǅ\   \M˃)܉etVREP%Mȋ]F}t.EP;PrP5E
Mȋ]C}tE̋Uȃ} t[H	<xuPu   uO} ~MătAEP;PrP׊E
Mȋ]C}tEt& 
        
      }    @	uEDBu7   MDJt	ȃ9|E   
   ];]   ;uuMUE\=   wǅ\       \M˃)܉etVREPMȋ]F} ~Mă}t>EP;PrPE    
Mȋ]C}t
Ẽ}t%  E+  -    }   }(  MQ;QrQGE]ȋE@}tE̋H	Mȃ<ne  tN]S;SrSEt& EȋMA}tE̋H	]ȍ\&    B\\9i   }tB]S;SrS蕈EEȋMA}tE̋]ȡH	
&    :l   }Z  MQ;QrQ=E
]ȋE@}tẼ})ugM܉\;uuOU]ۉl   wǅl   &    lE)̉etVR]SE0FC}  MQ]S  ]܉\}tMEPMQ;uuNU]ۉl   wǅl       lE)̉etVR]SE uto} t6Mpp   pSW\PMQ  EU   ]pp   pPW\Q]S$ EUj} t4Epp   pQW\SEP2&    Mpp   pSW\PMQU];]1  ];  }    t7} uEE؋P   UuN   v Nu   t& ]t(}    UuN  Nu   t& ]t(}    UuN  Nu  t& ]t(}   UuN'  Nu  t& }   UuN/  Nu$  t:} uEM؋QUuNtNuM]
Z-&    ]t:} uEE؋P    UuNt
&    NuM
]t9} uEE؋Pt& UuNt
&    NuMf
]t7} uEE؋Pv UuNt
&    NuM
d} uE]؋SUuNt	v NuE4}t.MQ;QrQۃE]ȋE@}tE̋}ȃ}  -t	+   -E  MQ;QrQ考Et& ]ȋE@}  E̋@	EDBu';Et"  MQ]S裉  v } ~M	t& E ]ȡH	n  ;uu<UM4M       w   u$)ĉetj R]SEȋM   }  ]S;SrS蓂E&    EȋMA}m  E̋]ȡH	<aX  ;uuBUE4E       w       u$)ĉetjRMQ]ȋEX   }h
  MQ;QrQE]ȋE@}9
  E̋MȋH	<n#
  ;uu=U]<]       w   }$)ĉetVREPBMȋ]F  i  ;uu<UE4E       w   u$)ĉetj RMQ]ȋE   }q  MQ;QrQE    ]ȋE@}<  E̋MȋH	<n&  ;uuAU]4]       w
   t& u$)ĉetjREPAMȋ]K   }EP;PrPIE
Mȋ]C}E̋Eȋ
H	<fs;uu=UM<M       w   }$)ĉetVR]SEȋMF}L  ]S;SrSEEȋMA}  E̋]ȡH	<i  ;uuAUM<M       w       }$)ĉetVR]SEȋMF}  ]S;SrSEEȋMA}  E̋]ȡH	<n  ;uuAUE<E       w       }$)ĉetVRMQb]ȋEF}	  MQ;QrQn~E]ȋE@}	  E̋MȋH	<i	  ;uu@U]<]       w
   t& }$)ĉetVREPMȋ]F}=EP;PrP}E
Mȋ]C}E̋Eȋ
H	<t;uu@UM<M       w
   t& }$)ĉetVR]S"EȋMF}tB]S;SrS2}E    EȋMA}tE̋]ȡH	<yt!MQY} a]V;uu;UE<E       w   }$)ĉetVRMQo]ȋEF  MMQ]S  t& E    Ee}00  ;uu<UE4E       w   u$)ĉetj RMQ]ȋE   }t.MQ;QrQ{E]ȋE@}tE̋}ȋMȋH	<x   ;uu@UE4E       w	   t& u$)ĉetjRMQQEX   E   Epet2MQ;QrQP{Et& ]ȋE@}tEE ƅc O} ~Mă}   }{  MQ;QrQzE]ȋE@}L  E̋@	MfJtO;uu;U]<]       w   }$)ĉetVREPPMȋ]FP} u} tu} tgM]8L3u[}-t}+uO;uu;UE<E       w   }$)ĉetVRMQ]ȋEFt|} uvH	M]9ud;uu@UE<E       w
   t& }$)ĉetVRMQb]EFƅcEWt& M;Mu_c uV;uu;U]<]       w   }$)ĉetVREPMȋ]Fƅc} }cE;Eu[c uR;uu>UM<M       w   v }$)ĉetVR]SEȋMF}tM]SEP	  } t		  E܉\;uuBUM<M       w   &    }$)ĉetVR]SE M   pp   pS\PMQ赛 ]xT  E9EW  } uEM؋QUuNt
&    Nu:}   :	  ]   pp   pP\Q]SR Ex   9]   } uEM؋QUuNtNu}    {   v ]pp   pP\Q]S Exu99]tC} uEM؋QUuNt	v Nu} t؋]9]u{  t  t& x y  u   ]xx   t\} uEE؋@E}UJt
&    Ju?}}   Ed   h  膌EU6} uEM؋IM!    }UJt
&    Ju?}} u}   ]  E      Mxx   tU} uE]؋[]}UJtt& Ju?}} +  Ed   jd蹋]U)} uEE؋@E}UJtJu?}}   }t.EP;PrPtE
Mȋ]C}tE̋}ȃ}u!EP9Q} M	]Ԁ;^u
C]EE }   wE    eh   EP MԊ	\]t-u\EEԋMԊ	\\EԄ   \]tv\-uGEԊ \t8<]t4MԊQ8w*9}5Eωҋ]9|ɋ]EԊ \\EԄu\ u(  }  ]SEPyi       E|  \  %   =   t%   =   u6} t
M	&    ]SO} j |%   =   u   Mȉ\\   t& %   =   u   ]ȉ\\k%   =   u   Eȉ\\F          u   Mȉ\\   ]ȉ\\    }t/EP;PrPqE

Mȋ]C}tE̋Uȃ}t%   =   t%   =   u6} tEMQEN} j |Su    \?	\NYx u\EE1\   w6]E\8u%  M\SEP{w  x    \MME   EM9M   ]SRǒEuyuF    PM1角EuA]E    EЃ} tM	]SM}   j |  ]ME]u]ME]E} ~M1}    }t4MQ;QrQoE    ]ȋE@}tE̋uȃ}tRMQeL} t]} tj |P} tU!  t&    x   E     MIM   x    ]ȋE@EEt}M]9uoE4E    VREuAuFVM1Eu(]E EЃ} t
M	t& ]SH  ME]ىMu} ~Mă} te}t_EP;PrPnE    
Mȋ]C}t.E̊EM]8	tMEPMQt]9]t8x uE] Zt&    eME    E   0} t
Et& MQk]Ԁ; } tU}t%EP;PrPmE
Mȋ]Cuȋ@	EDB utQ]SsEPJ} tj EPEЍP[^_Uj uuuÐUdWVSu} tE8 uEE   %    }1IMvE   } tuhÃt01EPSjJuE%   = @  t2t,1ۍEPVjuE%   = @  ؅u1   1ۍEEPhjuE%   = @  ؅uCމ߹    t51EPSjuE%   = @  t    `1эQvLv 9/uIJwED9ErEPEPVRhuG1舕    e[^_ÐU   WVScE E}1ҍr~]t3_E   M t5]   3  &    E  M
1  ]|j EEP6ƋMIM]M3M3]M]3M3]
__E    t& _5_j j>VS
  j j>VSs	 Éj j>VS
  Gj j>VSJ	 Éj j>VSX
  Gj j>VS!	 Éj j>VS/
  Gj j>VS Éj j>VS
  Gj j>VS j j>RP	  G} tO} th  h   ]S	t& h  h   EP	ƅ@K8t6`t& MQ]Sj}#:2    _a  _ E} o    t[^_Uuj
uu   ÐU`WVS}8 |GF   EPWBHЃ}1u       ]ԅu    j jj"j  % Pj "t-jPRWptw8tOt&    e[^_ÐU WVSE    } t} uߑ    f      ȉMtuVhtlEPMQ9Du uIM9 tu> uMx   jx~utMAY)Å2Q	fu
   uF^
t& MAY)SuVPJEt	M+AX}߉}Gu9v!9sЋMPu6߈tSMqu6uMQzu^MM} uVWecu MQ#C} tj EP؍e[^_ÐUWVSu1эYt&SVj9~)}!8t7U|WVSUEE    E    E    E    	]{ uPR诮  : u8     8 u     uv    )ĉe}<$ue]cuF    u}}EE5	uNAÉE	|tX19^  }}]]U    u1   PEЋ}]Ћu;Fr   t& ]TU5	u}}]]E    ]    u| tG}}܉؍LMt& ]܋u}9u}BFu9 u֋]| us}}u>]u\]1ɋ=	}};Osa	]uuU؋}]Gu΋߉}Au;Nr؋=	}]u4]    E8 $E8   }}][    )ĉeԋu4$ue}g]C    ]EE5	uNAÉE	|tS19d  }}Ћ]]U    u1   PEЋ}]Ћu;Fr   ]TU5	u}?}]]ȍ&    E    ]    u| tI}}̉؍LM    ]̋u}9u}BFu9 u֋]| us}}u>]u\]1ɋ=	}};Osa	]uԃuUȋ}]Gu΋߉}Au;Nr؋=	}]u4]    E8 $E    E};x  E    &    @]Euuu
&    }}} u]]uu} u}]L;Iv 1Ƀ} u
u}T7J1ҋ]]v E    E    E    E    } tyuu}]D;Eu^E} t
A;L;}FIyB} tuF}uE    E    } u
]LI1ɉE} u} tzuu}]D;Eu_E} tB;T;}GJyB} tuF}uE    E    } u
]TJ1҉E} u}    }    uF}t%]9]t} u} tu9u&2}9}t} t8AE]u;L|{}1B];\uvu1LIy}?}t]L;IJ.u6u}T7J]9]t} }EEEu;ps1x[^_ÐT$D$1QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQj j j j j j t'HtHtHuӍB8tH8tH8t	H8u@@@)Ё   ÐUU1: t'v @: t@: t@: t	@: uÐUU1t: u   U5duuÐ/   ̀=Ð2   ̀=ΖÐU  WVS j h`Ã}脇    h   WSec  St]0       5  j WPPP PS轐  }
u   ?;1;Msچ "   "   
QRu胱  [^_ÐUE=   w$l臆      &                     d         {         k       [      R K      ?;      c   +              )
       	           @                   /n         n         p         p                      ~   w   n   g    ^   W   N   G>  7 .   '           ÐUd  WVSM]MIǅ    ǅ    ǅ    ǅ    h  pEu
   V/  E    E    M]KcC    C    =X uZh   h@`٬a   ƀ@`@z~A   ƀ@`@Z~0   ƀ@`@9~`X   ]{ uOtj P{j %pM]; uuy   .  &    MA    ];[,  v 
B tr)  $,E@9   M   QR]SZ  S)     v    -  U    ]C=   vC   Mq1z]&9tk)Љ)Љ t)Љ t)Љ t)M1)@Q92	4(  t& ;   M   QSR(Z  4(     t&    ,  U    ]C=   vC   Mq1`y]9tk)Љ)Љ t)Љ t)Љ t)M1)@Q92
'  t& a  t& E  .'   uM *  '  ƅ ƅ 1   r tË*   Eu!+   ?   yt& \uk;uu   *  ZJ tË+t
?@t& +tÀ?tǋ; K(    ]3)S9      *  U    MA=   vA   ]s3v9tk)Љ)Љ t)Љ t)Љ t)M1)Q93 tB4t& r tA.9t   .    |   ;st t tA
9t@
u;]@u3+PQj
T  ƅ&)PSjT        A(  U    ]C=   v
C       Mq1u]9tk)Љ)Љ t)Љ t)Љ t)M1)Q9*S+PQ t      PS  ǅ     (%  ]3)S9      &  U    MA=   v	A   ]s3sp9tk)Љ)Љ t)Љ t)Љ t)M1)Q91SjQjR  $  M1      %  U    ]C=   vC   Mq1r]]9tk)Љ)Љ t)Љ t)Љ t)M1)@Q91k   ƅ 9x$  ]ދ)؃"MQ      $  }    ]C=   vC   Mq1q]E9tk)Љ)Љ t)Љ t)Љ t)M	΋)ȃ"]S9#)@9   v    #  U    ]C=   vC   Mq1p]F9tk)Љ)Љ t)Љ t)Љ t)M1)@Q928^u	&    :^uB]3)@S9   &       "  U    MA=   vA   ]s3po9tk)Љ)Љ t)Љ t)Љ t)M1)@Q95 Cj S蝟{  M  K   t-uz:]!  -uhB;Erz[tZB;Erz[uz^tF:]tASMQSQPO  ƃ  u%!  :-uYz]tS;   SMQSQPN  ƃ  u躉   Eq  [d  ::[  ;q   ƅ ;   0;(    t&    :u8]t9u0 :]  8]N       È& ÈPAƃ  9I  9  ǅ       VQ賡PBt&؉ t\ u	 tJu>@	DXt,ȉ   Bƅitu닍IIƅ 2ƅ Њ޸   ;uu     ~U ttz\uq;uu虆     &    N tЊ   )t& ]@9uQt& ˋYʄtA| t⋝CÉ  M    U  ]   D  M  3  f}   #  E%   =       ;uub   l   كU  $]   MAu;uu+    pPuhEeuU]+Eu     t+@D	D    EU]+LEU\      UM+]D      D  U    MA=   vA   ]s3h9t[)Љ t)Љ t)Љ t)M1)Q9CCC CEǅ    ǅ    ǅ    H  t& M   } u     u        ]3)@S9        U    MA=   v
A   v ]s3fP9tk)Љ)Љ t)Љ t)Љ t)M1)@Q92CЍDPQjYE  Eu']   c  uȁ         HMU׍D]މDtD
ǅ    Ettǅ       K  T(ˈ];)S9        U    MA=   v
A   v ]s3dp9tk)Љ)Љ t)Љ t)Љ t)M9)Q90CCn  E  ]     t&      U    ]C=   vC   Mq1c]f9tk)Љ)Љ t)Љ t)Љ t)M1)Q90S+PQjB  ǅ     t+PSj>B  ]3)S9        U    MA=   vA   ]s3pb9t[)Љ t)Љ t)Љ t)M1)Q9Cǅ      M0  %   =     B;Eu;  ǅXM   ;u   uA}	   K    tub5@	DVtU}1|BЋ;t:  tt,   ;     t|   5@	DVtm }
ǅ    TBЉ;t9  tt }ǅ  
&    |  ;~"   uu{
     v  uL\  ;*    t}t" U  uz
     v  u!]   "     ]3)S9        U    MA=   vA   &    ]s3W^ 9tk)Љ)Љ t)Љ t)Љ t)M1)Q9,S+PQj
\=  H~ǅ       ǅ
   ]3)S9      L  U    MA=   vA   ]s3]9tk)Љ)Љ t)Љ t)Љ t)M1)Q9/SWރ~+t& +PQj*<  VWjSj<  (IQ+PSjo;  SQ+PSj;  $at& ;x    t 	  ;E	  x\	  	  M   	  M1   &         U    ]C=   vC   Mq1Z]v9tk)Љ)Љ t)Љ t)Љ t)M1)@Q92  t& M     M1        U    ]C=   v	C   Mq1Y]m9tk)Љ)Љ t)Љ t)Љ t)M1)@Q90{  M     ]3)@S9   v      U    MA=   vA   ]s3Xi9tk)Љ)Љ t)Љ t)Љ t)M1)@Q95w  &    M     ]3)@S9      
  U    MA=   vA   ]s3W`9tk)Љ)Љ t)Љ t)Љ t)M1)@Q94n  M     ]3)@S9          	  U    MA=   vA   ]s3VY9tk)Љ)Љ t)Љ t)Љ t)M1)@Q95g  &    M     ]3)@S9        U    MA=   vA   ]s3UP9tk)Љ)Љ t)Љ t)Љ t)M1)@Q94^  M     ]3)@S9            U    MA=   vA   ]s3TI9tk)Љ)Љ t)Љ t)Љ t)M1)@Q95W  &    M   |  ]3)@S9        U    MA=   vA   ]s3S@9tk)Љ)Љ t)Љ t)Љ t)M1)@Q94N  M@}  ;  PuuuY4  =  ]3)S9        U    MA=   vA   ]s3OR9tk)Љ)Љ t)Љ t)Љ t)M1)Q93CC  t& ] t tqD;u\;tW֊<*tI<^tEMt<\uB<+t2<?t.]  t
>{t  >\  z{  ]3)S9        U    MA=   vA   ]s3P@9tk)Љ)Љ t)Љ t)Љ t)M1)Q92C CK        U    ]C=   v
C   v Mq1O]M9tk)Љ)Љ t)Љ t)Љ t)M1)@Q9/A; t!+PQj).  } tuj         ]              U    ]C=   vC   t& Mq1GN]9t[)Љ t)Љ t)Љ t)M1)@Q9=CuiM+Y1   ui
      uzi      uhi   uuYi   fuJi   Wu;i   Hu,i	   9ui
   *   #&    u i   
      [^_ÐU WVSMIM}7uOMEE eE   E    h   }Wn}MA$A;ut>u7]}G  M	$WWE{}EtFP  $MI  F}8i  FV  ؅}C0)sMKy+         };C   ~F  ؅}C0)rMKy  1۸@`&    <u};C   ~  t& 1۸@`<tMC   ~{  }W
       HKyMA@u}W
M  MAj  ;  FÍt3H<t<:FFÍt3UE9tJU    FÃ;]sj}};}u?P9w@    )ĉ    PuR|EteMME}E       MI} qE ev FHE:4*ÈE u&    M	Ȉ}G$ЈG1e[^_Ív UWVSu] MyIMMMM3  9  }
;E~])My t#~ <t
<	uAu
X     t3MAu*Q
u8  t& ,  ~KFCN   ;u   MA   ~lE    ];u|
E+E3;E|E)])EU} t;]~$MB<8 uKK;]~
B<8 t)]u?} t;u|
+EMM} t%   M%   8 tH|;uu
t	MAt:M(QM$QVMQMQMQMQMQ&    t
e[^_ÐU   WVS]]ԉ]Ћ}}E    ][]ȋ}GX]E  E   E    E    E    eE   E           )ĉe)ĉe)ĉe)ĉe)ĉe)ĉe)ĉe)ĉe)ĉe} k  } a  } W  } M  } C  } 9  } /  } uH$  t& E    E    E    E    E    E    E    E    E    }   EE9E  ǅ,   }9,   U]0}(uMt& @a@a(@a0@a$0(,]9,r} u } t}}]]E    E    }}}]]]}9}$]]$]}]]}}$])߉}} ~ }9}]]]܋}}&    ]]})]܋]]؋}9}  ]9]e  1҃} t}9}w]9v}9}8t]9]v }9}}    } t  E   ]܉]ǅ,   }9}  ](uMU((,]9,rx  }       }}܋]9r]9w}}]]ǅ,   }9,sP](uMU((,]9,rσ}    }G  udE@v] 	}    ]     P7} G    P7G     }G$GKuFE@] 9s;PsBC;    PsBC{ K  C  v ] t7C}8S]9]u}+}:] t& E+EE} ǅ,   ]쉝(Mu   } W=@at9@au] C,Z} t9Ew;(w+E+EE,} W} t9Ew;(w+E	+EE,,} ;UvE9,L]ĉ,9s(} WG,C,;r؋E+E}9}t])]+E+E,,      }G}Ժȵl  $t& },G}ԃ} tL]9]u}9}D  ]]܉}9t}]ԊC]G}܋}8:  ,uI]9]u    }9}  ]]܉}9t}܊]ԊC]G}8  ,u} _E   U]9J}B;Uv3]9]u &    }9}t  ]]܉}9t}G@u*} t]}Ȁ<8
E  v ]܀;
4  } }'} t]}Ȁ<8 u  ]܀;   }   E   U]9  }B;Uv  ]Ԁ{È]}9}u]9]  }}܉]9t} t]}Ȋ8]܊މҋ}    9s%   Tsu]ԍLMԀ} <  }   E   U]9	  }&    B;Uv  ]ԉ]}u,W]SEPY  }]$Ȉ}t]=@auE}]}}܋]<]}$E    }]}  u]E]ԉ]    }]t}=@auE]}]]܋}}]$E    ]9]t,}Ԋt#]uv t}tuE  E   E]}tH9E  Eԃ;E  1ɉEǅ,    E]ԊC<w
<s<
t+<u'UBÉ,z}tU,UU, E  :<  z2  ]Ԋ8B$  }   $C9sx    ]É4}ǉ(]4E,t& ,(9r44(,A]S9rUz}ZBÉ,U}(M)ʋE+Epu    LD9shƍ&    P9(  (    )ĉ    PuR'nE  e](M)9r}}]9wz    }ǉ8]É(}4UEMU(EMU8E8(EM]9]vE}<EUE]EUE,}<EUE]܉E      Ek&    }xG}ԋ}=@a  }ց@a  E1Ƀ} t9Ew]9v   1} t9uw;U%   9t|   }䉽|   ]9]u}9}$  ]]܉}9t}؉,]),|+E9,~,} t(}W,S}W]S    v u܋},   ,}}} u#E   U]9w}B;Uv|9]+t& }9|t$x}9|t]]|9tы|9}} t
]9]t}9}t} u]C   }܀
  ?}9}u]C@m  t& }9}u
];
t  }܀?
  ]C6  } t}9}]9]} c  }GÉ,}ԋ](M)ʋE+Ep<u    HD>9sdƍv P9()  (    )ĉ    PuR7jE  e}(M)9r]t]9]   }    ]É<}ǉ(]4    UEMU(EMU<E<(tM]9tvE}<EUE]EUE,}ԉ<  }GÉ,}ԉ}]9s>? ux};us(> t;us>uVFЉE}  uU](M)ȋU+Ur<u    DT>9sa֡P9(b  (    )ĉ    PuRphE2  e}(M)9r]p]9]   }    ]É@}ǉ(]4UEMU(EMU@E@(pM]9pvE}<EUE]EUE,}ԉ<EUE]܉E}GÉ,}ԉ((;Es (<w(ٍ&    (;Es(?u(뱋,]ԉ]}9(   (<t]C   <
   <
t([(ƅ(
u~u(8^  P<  F8(s$(%   T(sV  H<L  ul~uA(GV9~N%   Tȃr]C   t& lG<   1ɋ(_T9}_ldTh(((? tdC9}ЅuF(A;h|;Tune<uh1ҋ(_P9}5l_`(;`}"uFAB;P|;PtlC9u}GE]Ԁ{t	C
   Ex}UX]Lx}D(9ri    ]É,}4UZ]EDUz}ED,Uz}ED,I;(sE    }GÍ\;]]uM)ȋU+UB,҉(,T9sc(\(P9      )ĉ    PuRcEo  euM);(r}\]9       }ǉ(]4E,t& U,EMUEMU(E(,\M]9\vE}<EUE]EUE    EUE    Et& uM)ȋU+UB,҉(,T9su(\(v P9w1    )ĉ    PuREbEtet& ;      uM);(r}X]9}       }ǉ(]4E,U,EMUEMU(E(,XM]9XvE}<EUE]EUE    EUE    E}_GÉ,~3K,,,,_}:    , '}G G v }_GÉ,t(K,,_,,__v E&    }GÃډUGÉ,}Ԋ,E,,Xs} t}9}a]9]S} I}9}=UJ@`;Uu]v EH9u	}G]C<}9}u	]t& EH9Eu	}G]<8$  t& } t}9}  ]9]   }   }9}  UJ@`;Uu]t& EH9u	}G]C<}9}u	]t& EH9Eu	}G]<8y  t& @`}9}u]EH9Eu	}G]<<  } t}9}]9]} UJ;Uu	}EH9u	]C}G<  } t]9]u      }9}  }   UJ@`;Uu]t& EH9u	}G]C<n  }9}u]EH9Eu	}G]<}9}-  ]9]ut& }9}  ]]܉}9t@`}9}u
]t& EH9Eu	}G]<   }    E   U]9   }B;Uv   ]9]u}9}   ]]܉}9t@`}9}u
]t& EH9Eu	}G]<tB} u(E   U]9w}t& B;UvEh&    EU  X]MTtU܍x}\]ԍx}\]x}DE9       ]É(}4E,UZ]ED,UZ]EDUz}ED((,I;Mst& E    } }9}sS1ҋ]Ԋ<w<s<
t
><u8E@E}_@ÍD;Et8	8]9]\}9}P]Et& } 0    [^_UWVS}uME9   <   <   BEZ@U   |uVt& VDPu	     E؉E:u*BEZ@ÍBE|tBEZBVUPR/	  t9])&    M    VWEP   tU91e[^_ÐUWVSu}E@Ew<$@EVuEPuʀ$Јur1{EPExȉEPUZ]JCz}uU
Bˉ]t& E u
떉E뎋E}   e[^_ÐUWS]uK=`a    `t
	9`t jhj 3G`	`   =`a uQh   S`auj5oda   h   (pauj5D    
|ah`a5(w1IQS蘨u1j4\j {Fe[_UWVS]}   t
ܲ          C    C    h   yC   t_h   aCu      1ҋKu@	DPt
H	EUE
B   v
    C       t濁   Kc$SSSV}1IQEPkǃu   u#{ tS$us?C    e[^_Ív UWVSUuvbj4\j D1Ӆt"9vNVREP&T SRMQ4V؍e[^_ÉUWU1IMQj Pj PRj j h`aЋ}ÉUE(w(wÍv UEPʀPP5(wuu8u1j4\j DÍv UEPuuuPuj j u<ÉUEPuuPuj j uÐUu$u uuuuuuÉUSMU]tA$AEBEBt& a    B    B    ]Ív ULWVSu]}1JUE Fu
} EˍMԉMĉ   ڀE$ڀ$$E} t3MMQ*Uu
      EUU1ҋMQRQj QEPj j MQEЃ$} tH|<1;Us5]}uEEt& M	EB;Uru=mEЍe[^_Ív US]t	P<    C    C    Ct	P<C    cCtP<C    ]ÉUMUE
BBÍv US]MEUAAQQ]Ív UVSuMUZ9t
KJ9uENNe[^UWVS}M]Ur9t
v NJ9uEOO__e[^_Ív USM]A1;Evx\1I(u	 uu|uf|t   ]ÉUVSMu9\ÍA;Es11    t9)t+
t	t:)tf}
9|tv tt
:|u   e[^Ív UWVS];Eu      &    PM@9vE   usv ׃} tҋM
҉]Ã} t	M
E0} tM
%  $)¸   G;}v1e[^_ÉUMUJx   E9u   Jy1ÉUVSE]uE9s<9tVSEPu1&AEQ@D
EM9rĸ   e[^ÉUWVSM}u]t:CF88t
   v Iu1e[^_ÐUlWVSEU1IMURZÃ   E ;%	  U9tE8    qu߶       u    tuu    ta}1;MwyQUREEP%N UREPj!uE%   =    uU9UuE9EtOS[6S0[[$U   7E S[9$"   "   SZ$U1e[^_ U   WVS}ǅ    #Ëu      $  }	w"   "     UR試u        jhEP"LqM0Ӎv K )` u։;sAF;r UJRWPIt?[t*9 1C  "9$u"   "   '  v UREPjq}"    Gf
fWEPWju9@%   = @  u'RPuEURPU7"   tvt-G EPRuEURPUpt<t3G ǅ   RPuEURPU0ȍ[^_ÐڋL$\$L   ̀=0ÐU-   ڋ]̀Ӊ
;Mr1Y!    ÐUWVSEUM119}Ѓ8F;u|G$)ĉeW]S]S͗Ea}1;u}T]]]荶    ]9v}E]S]S]3kK]])߃tEEF;u|Ee[^_Ív UWVS}u]i EUS   ̀[= v؋U} M9u~MU
ىe[^_ÐU$WVSE    E    UUE    E    E    u
1d  v }܋t`]܅H      U܋U2}WU҉E  }܋C   K   @   A   K`Ct`}    U
A   }7} } 1ШtKINc} }CAKCFst& CAKCFs}0&    U
aN} }
AFqAFq} }]]; t }}U܉U]܋}}UUjEtU}OG    G    ;]   IAt`At`}    }܋C   U2} } 1ШtMKNa} }ACYAFq&    ACYAFq}5&    UcN} }CFsECFsEe[^_Ív U0WVSUUE(   E       et	uԋu1  y    }9}u3U؃U    )ĉeЋu؍    P}WURGEUԋu؋}Fu؋} }
sut& {}ԋUԋ/  0uV}׉Et]UԋUruЃz tu}}|   ]ԋUUu؍4S   u	v E}9}u1U؃UE$)ĉeЋu؍    P}WURFEu؋}EFu؋]x uEURUЅu	uvuЃ} u
UЋ}ԉ"u؋}DU;QuuЉq}ЉyU9Utu}G  }   } tUB  u؋}tuC9E   Kt,At&aKACYMU؉BU؋KquԅtFuA   @   At@u0SuԊF$ЈFFCFAN^       SA$ЈAcA`ACY   &    t2At,aKACY}MU؋uBU؋Ky}ԅtGuAt@uI]yAt@u3SuԊF$ЈFFCFAN^}7c,v SA$ЈAcA`ACYuE   E    M؃} ~} 6}G)} tUЀbuV-E1e[^_UWVS}uEu$'%3Wփt}C	    C8 u1e[^_ÉUVSu]t^tZ~ u~ u
j jE&    j j VӃFt   g   j jVӃFt   J   j jVӍe[^UVSu]t&Ft   Ftq   6V,e[^UWVSÉ׉΃{ u{ uVj7Vj S׃Ct
NVjS׃Ct
NVjS׍e[^_ÐUVSÉ֋CtCt3S+e[^ÐU,WVSEUE    hh蛧E܃tI]]u    u]]]S]S]S]S訣uȋ]S褧E؍e[^_ÐU   WVS        U   1у)̉j	hRS%@R?hSÃtB1j	h'P\8uFSh    PuSa[^_U   WVSǅ        1у)̉j	h1RSP?R>hSÃtzǅ    RPPPu,}  
Йv Sh    VuSWu &   Ѝ[^_Ív U:ÐUJÐUS]t#tj/P7u@]Ðڋ\$   ̀=#ÐUWVSu	H8X<119s=P	94t@9r9rtH	    e[^_ÉUWVSu	H8X<119s=P	94t@9r9rt
L	e[^_UWVSu	H8X<119s=P	94t@9r9rtD	%    1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   @t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÉUWVSu	H8X<119s=P	94t@9r9rtD	%   t& 1e[^_ÐUWVSEU1E    uE XShZR-t,ZB=   wSu%E}D   .u8t4}t.F 1MAMu}~EM   t& 1e[^_ÉU,WVSEUujV*8mE    M9:u
AM9:h  MME    E       WeSs,uWvS`,te)	Eԁ}    E   z:uFMM܃} u}    uZF;E   EFMԈFE    E    /.   ^;]   EP.   &    M9AM/} tF;EvnEFMԈF} t*+u   9M|E)؊ OC9~u;uu&EMEAEAEA   t& 1e[^_ÉUMEUt
tt& '
 a   ÐU  WVSǅ    ǅ    ǅ    =@w u
@w   =Dw u
Dw   Hwu
Hw  f=w u  fwTw    Lw    fPw fRw 5x$xx    h~H   h   Qhw.ǅ   w
ww1=w t_wsG
tB t	u        t1ǅ   Au

tAt
 t	u     hhǅw    <;  <#  jhV9-   < t<	    e  
&    A< t<	tA  <
9  h   Qhwc-w
:
tBt< t<	u: tv 1t ǅ          jhVs,   < t<	      A< t<	t  <
y  h   Qhw,j
hw'wt 
w1=w tLws& t	u
    t1AuЄt t	t
At< u     ǅ          j
hVc+|   < t<	uneA< t<	tz   <
tvPQtbTw@wfD fD 52jh÷V*u< t<	u˷2  Wh  V1;=Lw~=LwW蝻=w u<h   S@u$j.S!&tAPW' uswwww    1=w t9.uFA9 uws'    ~j.Q%HNwr    hзCt
ܷ   
Hw1[^_USÊ   	    C< t<	tjhSH)uACj j
j P"Ex$ЈxIv 
x=&    jhS(t"jhS(u
Iw <	tCt< u[]Ív USj ]S><iJE3C1%  ]ÐUWVSuE싀E   #  uut-
@	E8,t@EtDA u#uߋEEE)EE    1t& EP    E3EP0u;1I9MVFv} u'EPEPEPh`5$迷1   t& Dy~%jEPEPh5$菷1   t& EHyDyU
@	DA tBDC u֊,t|K;F:|AFDC tBDA u֊t#uEPEPh5$1
se[^_UWVSu	#   ut&@	9,tAtDC u#uΉ+UXy~!j}W}Wh 5$y1       XyR}W7$\y@	DC tBDA u֊,t|K;F:|AFDA tBDC u֊t#u}W}Wh`5$1
e[^_Ív UWVSME    M@	DC tEE DC uML  #C  ΄t-DC u##tِ>,tFtDA u#uuE)EE    E    EPEE3EP-u;1IE9t5EEE}v} u*EPEPEPh |&    EEӍv 
@	DA tBDA uEpREPEPE@Љt>t8@	DP u #t$QEPEPh 5$D	AÄuȍe[^_ÐU  WVSǅ    =@y   j0h@y-+hM>ǃu^hmW'ƃuDy    ǀHy   DyT 0&    j
SRt  SRWVh   SuVnho<ÃtDy    j Sjhohr<Ã   يt(5@	9,tAׄtDF u#u)ރujhSy+u	%ly@
lyujhSP+tujhS7+t%lyh;ÃtUjhS	+u	
ly8jhS*u	%lySjhh5$hW;ÃtYjhS*u

ly<jhS*u%lyv Sjhh5$謱h:Ãtj SjhhȺ:ÃtXy    j SjhȺl@y   [^_Ív UWVSXy  E E1IM19}Nt& \y1эQ9Uv#SE)Ћ]S2)u     F;5Xy|E    EP:    EU1эq1;Xy}L\yE1эQ9v$EPu)U}}W(u 	C;Xy|EE@EE< ue[^_ÐUWVS}1эq1;Xy}S&    \yE1эQ9v$EPu)U}}W(u 	C;Xy|e[^_UÍv UWVS}t2@	DB u"#tр;,tCtDA u#u)ujhW'u	%ly=
lyujhW'tujhW't%ly؍e[^_UVS]ujhSl'u	5ly:jhSM'tSuuh5$胮1
!5ly؍e[^ÐUS]= u$hhj h}uuSE]U ÐUpWVSBƋ>j jjsÃ}
>CfE jh
EP&jnEPS蛍}Sr>t& ؍e[^_ÉUPWVSEȉӉoEupy        v E   u]}}E   }ȉ}ԉ]j}̉}W}W[ C9tW	r     jEP}WrtWq     Eu }Wqpy      l  v G  ]   )ڃ}}4   <}}}EM9Es" "   }W^q
  t& Ӌ}_})}}]_ˋEG}    )ĉeƉẻuЋ}EԋEȉE)uj}W}W9tWp      U}G    11;usM}GÃB;Ur;u,V}G0}Wp9tWp    &}Wdp1}WWp    e[^_ UWS]1uuu   e[_ÉUWVSuuhj}WP]SV]S   Ie[^_ÐU    t
hD*?@ и    t
hD?ÐU    t
hD>@@@$    t
hD>ÉUS    t
hD>@u@ЉÃ    t
hD>؋]ÉUS    t
hDe>@uu@ЉÃ    t
hD:>؋]Ív U塀Ѕt@    `Ѕt
@`ÐUS]Ѕt@`Ѕt@`t@Su@    ]US]Ѕt@`Ѕt%@`t@Suu@t&     ]US]Ѕt@`Ѕt%@`t@Suu@t&     ]U塀Ѕt@    `Ѕt@`t@u@1UÐUS    t
hDu<@uuu@ЉÃ    t
hDG<؋]UWVS=\ J   5߹    uj h<5m   E.5}    uj hKmtk<5ǹ    uj Plu8K5ǹ    uj Plut& E&    K&    <jWck\uj WNk\u1dj j5\^l|Pj5\Glu5\dk1'j j 5\ka    fa   e[^_ÐU,  WVS=\ }hZh   hhauU       j S ǅdp
dhP?*E    VSjy&jS ]jSfE  fE  Sj5\Gkh  ha5\jfE Sj5\k$j Vj&QCS   u+a  }a`   MU
1t& aU    [^_ÐUSMU1fffw<fffw/y( tz( tjB(PA(	j BPAPpu   ؋]U4  WVS}uǅj mR ǅdp
dhP(E    QSj$j(R ]jS:fE  fE  Sj5\ifHfvftfuIh  V5\h=  ua  ff9uK    a=h  V5\h=  u΁a  WVtǅ    fE Sj5\ij Qj#Q,Q [^_Ív U8  WVSu=\ } hh9  hhW &    au:E        &       aM      j P ǅdp
dhP&E    QSj#jOP EjP[fE  fE  Qj5\gt& h  ha5\g=  -a  faffwÍ^a1Iw}эywSVa)tNuJSa)v8u4Sa)v"uSa)v RSi,j RS}a`   MEfE Pj5\fj Qj!PN M9 u1҉Ѝ[^_ÉU  WVS}=\ }h̻hl  hh=a ~@faf;ufHfvftftWhabtǅT   PWTj N Pǅp
Pl$ǅh    XLPSj jM pjVfǅp fǅr  Vj5\beT }kjj 5\d
aRH+HtO)УaP5\N jj 5\d}$1gaaj P5\~dh  W5\:d=  t T }5a5\N 뢐a  fǅp Vj5\mdj LPj]PPL ؍<[^_U8  WVSǅjubƃ}%  j IL ǅdp
dhP"E    PSjjL }jWfE fE  WjVcjj VDcøR+t)SVL jj V
c|.h  uVb=  tSVL 
ǅ    fE WjVcj PjP:K V!b[^_UÍv UWVS]=\ }hh  hh]au    6hau>|}a`   M1    e[^_ÐU\} hۻh  hh&    PZa\ÐUj hauj hat5=| }lh~   |}hh   |}1Tj j5|a|Pj5|au5|`5|U  |   1ÉUpSj jj|Ã}	9fE uEPjnEPS/{}
S2`؋]UVS]u|}h
jxhh-zSPg  |1    e[^Ív UVS]u|} h>h   hh-'&    SuP  |1    e[^ÉUVS]u|}hOh   hh-SuP  |
1&        e[^ÉUS]|}hbh   hh-sv SP  |1]ÐU|}hsh   hh-3v P  5|^|Ív UShÃ}	*uuS  }
SW^SJ^1]Ív UWVS=1ӍsVǃuu   wG    S5GPE   E   E    EPWu0  }Wt& } }EWEe[^_ÐU  WV}E   E   E   ǅ`   ǅd  ǅh   `PEPu  }+} }oE    l`   EX^_ÐU   WVǅt   ǅx  ǅ|   u`   ǅ   ǅ  ǅ   PtPu  }1p }l}`   󥋅p^_ÐU  WVǅt   ǅx  ǅ|   u`   ǅ`   ǅd   ǅh   `PtPu6  }p}lpX^_Ív U   WVǅt   ǅx  ǅ|   u`   ǅ   ǅ  ǅ   PtPu  }1p }Zl}`   󥋅p^_ÐU E   E   E   E   E   E   EPEPu  }E}EEÉUWVSU1Ӎ  V8Eu
   E    p@   u`   SEPM  QE   E   E   }WEPuB   }MQ !} }E}WUЍe[^_UWVS}]usSWY;SuRjEPWYu<E9u5V;Uu-E9Fu%BPFPWWYF9u1&    e[^_ÐUWVS]    t
hDo(@@@$5S    1IwO)tKuGS)v5u1S)vuS)RS u)t	R2    S ǅtt	RU=1    t
hD_'e[^_ÐU$  WVSuǅ    j$Vd   jh_CSwu   jhfS\u	   7t
/t:uj$P	u u41S	u1
SVR  E  2  H9 thoh   hhMh   PhF>ctl [tcj/Q+GPbÃtb9ufUf   WPS2 f=vtW1эyQ Ãu2t& W5vSǍS9v&    /uO9w M  t%t t1эQ    1҉1эyv9sӃ|;WYu1   $   jh_NQ u   !jhfPu`	   7t
/t:uJuM  vttRS4At=:t0Ft& t& :u
:FCFC% [^_UWVSU1Xt$&    3EPetxދ^u}1ӍCPǃuU   Nuhƽh  hhٽQSMQGPG    ~e[^_U0WVSE؉ӋCEw   =L uxPR:E܅tgU1эQE;wtx:uBu܊2t:u3j!Eu 1Ҹ   z}    E  EPS/Ãu$1Ҹ   Et& 1҉ـ; t&    9:uBA9 u   PEu 1Ҹ   ]E    uu  &    1эYuEvuT:/uJKwt}|/t;/C0cEtmu9^uU~}ԉى t}?}u؃} t?1;UsMt& E9t	B;Ur;U   Eu}Fu   5(cVEu 1Ҹ   v E}G_;8cv8cu>/t"1;
(cs8U   A;
(cr 1;
(csU    A;
(cr}G?EG50c7=0cEu<@E=Eԋ]m  >EuQ   E8u Ef      uVSu}t
 =  E     /  ?EuXta:Ut:Uu E  &    :UtAt:Uutu    }       =@ uquE    1   :Ut
:Ut:UuE   u   
E8tAt:Ut:Uu9 tu _}    Tt& t; th=SL Et.  '&    b; Yu        ډU}E    e[^_ÉU<WVSEvvh,c(cF$cj4cEu`1Ҹ   J(c	    Q¡4c
4cu 1Ҹ   0cE=    ]FE̍^v M1MEx tM1t& 1҉CC    E8;1JS;8cv8c8/t"1;=(cs6U̍v    G;=(cr1;=(csU̐    G;=(crE]EEƋM9 EE     } <  M/  ʾ   ƀwFBu   P] cu 1Ҹ   t& =L t	EE     cE}1Su1SEPRUE    MM      1ҍBE؅uEܠ}vM܍Tt& :/u
JM؃}w} tMUE܀8/u  : l  v ދ}܋M uM؀</u| t	uօ7  } tE؋M܀|/t/@E؋0ctYE9Cuu܋{ tut81;Usu9t	B;Ur;U   MEAM       
(cQÃu 1Ҹ   t& E܉CM؉K;
8cv
8cE܀8/t 1;5(cs4S   F;5(cr1;5(csS    F;5(crCC    
0c0cEM@EƋ]d  
MׄuG   8u E^  VSEЉ1    6      Eքuctl8t:Uu E  &    ߄   8t:UtG   8u   EЉ8     v = uguE    1   t& 8t
:Ut:UuMЋ	 E 
E8tGt^8t:Uu? tNEЉ8  Qt; thSl EЉt.  '&    l; cM        ߉}܅EM    e[^_ÉUVSE]$PEIt#StCBStCBSvukMUEeU  WVSEEE    }WujC}$huuuu0[&    wEt>uMU]9$  u9  u9     @Eu˃= w tj huhjgtyz)hRhPu@HÃ3h!uuuuP0h	       h?ELFth7uuuuj \hxthJuuuuj 8t& hthuuuuj hxthuuuuj h thƿuuuuj t& hx thܿuuuuj huuuuj t& hthuuuuj `hPtth uuuuj 4hf* th`uuuuj EuMU  Uuhuuuujǂ     Uh@  hGlf,f  hx,pP9w
x\p$)ĉxRj u>FpWxPuE9th!uuuu0&d]  <R)`ǅ\    xt9  ǃ,D$(|$$D$ |$D$쉅|$艽ttt"wt;-      t      FC	  t& F     N15tythSuuuj ~+1th Suuuj ($ \#VVtyT!~~8~~ 8F#$,8W(] , t   x9t`\|Xƃ7)Љplt
l   wEpjwpWR\u*huEpE0Ep<0t& +Ej X40)VUW\U:8  Ћp     \0   P7D+H  ]  &      Ep     \0\  t& H9vQ)ы}pEpjwQR[u%huEpE0Ep0DHP9  E ȉTtyt!9TsT9   Ou8QRty!P$[}h`uuuug0)PS'WuR5tyty!SZ9TvIj jj2p)TTWVSZuhuuuu0 0\`<9T]P     `0\9svh@DLyHD9w-7)Hhx,D9WL9r   uhSuuuj -  dus?]  ulu
  ]Su$lu#hSuuuj t& S]  = w   E E E jj0}@Wjj0E<Prjj0|8WYEP`}4IЃuE}IЃ0up]IЃ0uj h8Ph<Wh@Phj=$jj0@Wjj0<Pjj 8WE  4IЃ0uE  IЃ0uE      K<)1хuj h*8Ph-<Wh9@PhDja$EH0X  9    	kt&    1w	t  @So)ЃwN  p)Љ;t& ڍBw	x  thj9hżhԼ)9 uStrStrStrSDt"CLxthjMhżh rSPt#zthjThżh+&    S\trx  tr]{( t
5]{X      ;     jϱE  Ã  u?hRSuuujWv u;uEU9E  u}Ǉ         Ǉ     jE  P}  Wi}Ǽ  E  ËEU     UE$  Ѝ[^_ÉUWVS},c8c%%?)ĉE   j hkj   v M9H   ppVE1ۋ(c9szt& <tf$ct4؋MQ`9tF9u>/u 
    B j V} ty=Pj OE    (cC9rM} t7j hzM9 u	< EPh}MQhj t& j hzMQhj e[^_ÐUpWVSE    } tUUu,      &    URURPr  ,c8cUD$)ĉet& E    =w t UB9EtErRURUrrUREE    -  U;(c  4    ]<   URUR$cUt4ЋURPEU)U=w tj hRhjj UR8ǃ< uEu9E+EUD EPRj2uE%   = @  t	      tA} t;=L t2EPWj2uEuW7%    Et+UR螭U2W70t&  t	
EUE'e[^_ÐU,WVSEUMw   M샹      qEPTEXuSt3MQ.t;[tu0EPPt6H,ZYSEPuڋE^M    E@EY= w t8} t2j hMQ: u<RhEPhj{j/MQ
  }1щM=w tj hEPhj.MM} thEPTtM   u!H,ZY)E쉐  t#MQE  MQEPMQƃE싀  Et
wM
  t;  t,E9t%  tMQREPMQEPƃ    ctMQREPMQEPhƃ   MQ  Et\j P4ƃtO}1S躪u1SEPRUuV4u MQ54cEPMQEPƃ=w    j hj{   v } tMQEPm:    }1Su1SEPRUUu!j R3ƃ   u%   }    }1S茩t*SEPRÃtMQMU  EuU   軾Eǀ  ǀ       E+胼 U脾MQEPuVMQe[^_ UWVS]uM   t& EЊ<	weЀ	wSЉECxFMDPЉECM<	v|BF<	v9}t.)}E:   3v <	w!8UuCFM} j)Ѝe[^_UWVS=w tj hhhj.
<cuajh@ch@Ãt3@cv!    u
<ctRSK<c1  v u1  t& QRDEE    E    z   9}V[<c
@c9
  EPuV0t(}C]{U9}~   ]]~6suv<c
@c9sEPuVtÍ[EN
<cuTtu,@cuL9s} t9u
MM9t=EC94;]~<c@cu9sEPuVgt=w t} tj huVh-j*Ee[^_Ív U<ctt5@cPI<c    ÐUWVSEUM1jh(  REFP肥Ã} tu1   EMAVMQCPyC    MYU  $  E  1wt:Ztv ڋBÅuMQJʁ  w     M
wʁ  } t9E  t]  M˅uE  ]ì  t& ]ì  M  E   /u91VOÃu
   VEPS   t& }1щM΃1V
Ãe8"u(VSZÃt+EPSq/ǃt΅utS2xj Sz/t/BEPMQRtj/S9uC  E  Ee[^_ U   WVS]]uu    } u
~x tE    =v t:j } tPB8 u< Phj]]uuă~p      ]  9   ]u|t& ];u]|FuQtyڋ!ы]5tyD!Љʋ]j)PR[F}EX詵  諷| E E uuu    9Ej]C,@E{t    }    C$@X}    @5v|sVE؉]uvxu9x t*x3|Vt[x} t̓} tu5w
    @E    E    E    E    ]]C\t@EC`@E䐋u~h tAFtH} uUE9tM]C @EuuuF PU]]E    uu]]uu][mu40|u]]u<0 td]u9|W  |v |9thBh  hhW|u9|r  ]C0@E    @Eu9|  |CuF]  |6މuEEEЋ|vu%   u}      ]u  |{ s  t/y t)uV]v]PQpJUЉަ7]CUЋsxe   ]SrHUЋxEEMЉʅtqu|CH   $   QuF9wsH=w t?]C,j h`uPRh< uPjuMЋ]CQ9vPuV]Sa]uWv }    u5    )u][)]]u/u)u]"thh|  hh |u9|  |6]މu|FEEEFu}    u  ]uf  |{ U  uV]vxPpJUЉ藜xMЉʅt	Yx|FH   $t&    Q]C9wsH=w t?uF,j h`]PRh< uPj轵MЋuFQ9vPxSuVwx]3hv }    u    )xuv)xx]37])xx3"thh|  hh 軾|]9|5Euu}U=v tYF pj謯E  É]   u0j h< u	Ѝ&    Pj蘴ju  ]|{p      u  9   u]]&    u>u~][]up
ty؋ux!x]T!x|e]WP+xRQ>}EX8 :E E E u|    9ELl[^_ÐUTWVSE܉ӉM؉ȃ)ĉeE    E    $    Uu܉4MUDD
UDD
E  $?@  E    }9}so]t& uUE    UEMUDD
UDD
E  $?@  uE}9}rEHU    EHU    MUDEЉEԉM̉U  uvuă~ u   u
   |  }ċG,@Eu   E}}}uuċvuN  u   U}uV}  u   P1ɋElT$D$    uЉfeE  t    &    $    D$    }ԉgeE  $?@    =t=z     uu]}}=w t7j h uċF8 u< Ph"E}Ph6jٺtE3   ]uhMh   hahkCS  =w t7j h uċF8 u< Ph"E}Phj蓰Uu}Wu  u   P1ɋEE}$GD$GD$GD$g    EGE       z ttMB9Ht	@ut\u^B@BUJt	BAUJt	BAUC@BSEBUBtPUC   }G    UB9t
@;EuZlufEE  ?@  UJt	BAUJt	BAUD$@BT$EBUBtPUD$B}9}u]ԋu9uu]Љ]ẼEE}	u   }? tu> t
}}u} -u    Pg}܉  uW   蹪Eu܉  E    }I} tuF   u}  Mu܋  }GEuF  ?~}u}̋u܉  9}u       u̍    P諔}܉  uW   1ɋuutA} t}G   uu  }܋  uFA}}u} *  1ɋuu9s!}܋     uEȃA9rxyucH@EȋEȃxyPܓÃu!xy    u܋F   &Hx    R0S:
HEA9v7}ȍDP1ޞÃtxyxyHuuE    1ɋ}9}s8t& u܋     uHUP Eȋ}}A;Mr̋Eȍe[^_ v US]CPSs  u   Q1C]ÐUWVSÉыC0S,zStJq@Ɖuu1u3uQthj=hh  t6@P  x tUu>jPs  ʙUE8js  NUtB1ue[^_ÐUWVSƉUM  U   V0F,XFt}xHJMPthh   hh  t6@P  x tUjPv  v UEjv  fËEtX1ۋ}S}Ws  ؍e[^_Í    '    PQRT$D$ ZY$ &    PQRL$T$D$ZY$ UVSƋN     uot\    {H tPC8 u	  t?  =v t#j hC8 u< PhjdCH@%  Ivy       1e[^ÐUÍv U=y u#|y   ywyyt|yÐUPWVSǉU΋E@,@E=v t5j hWhEP: u<RhVh j艨$E`  uy}   E }EOE   1ۍu<1ыEDECv$)ĉ1ۍt& 4RgCv  &    RuhQjhh^hkCv Ef;   E E{`]̍t& K)9хu]EܐEԉE]EE   1ۍu<1ыEDECv$)ĉ1ۉ4RCvEP1]E;CuREPV   S}    } }   EuEȱ}EOE   1ۍu<1ыEDECv$)ĉ1ۍt& 4RCvEP1]1       EuEȱ}EOE   1ۍu&    <1ыEDECv$)ĉ1ۍt& 4R7CvEP1ͣ   e[^_ UxWVSEЉUE    E    P,u17  RUċEЋX  E}Ћ`  }~  @}Ћ?Ef8   E E{]K<)`хu]EEԉE]EE   1ۍuE1ыEDECv܃$)ĉe1ۍ    4RCv}ЋW: u<M1РEĉE}}w`}wEP{_u*&    t3}WQt[tt
u   t& E@EuE    }E;  st}Ћ  Es}W[u#t3}Wмt[ttEЋ  }4EE};  r1uhh   h^h ˬ][t& MKEЋ@E8 u
< Ef{P}WVEH	UfC;UvUSt
릍    }Wt
׉}\} t(EP}fB;MvMJt} W  j]CS8EЉ  uP: u<    踞}Љ    xEЉ  }    }w0[    fSҋEЋ  ;|  fC% fEǁ   |EЋ  }{<EЋ  }~|St	땐t& Vt	w} t]EX}vCu<fSҋEЋ  {|  }><EЋ  D    St뮋Eȍ|[^_Ív UWVS1Åt'1   tl%   	Ƌ[uىe[^_ÐUp  WVSǅǅ      Ë  9   =tyރ;uj@t^!>D!ȉ9s9v   ;x   	=pc
tc)
xc
Tc|c   j  Kc=xc=\cQ%xchc1w
hc2   hc  vhc    dcٍI=Tc|@=cEjP`UE txTc|q  É]jheURܺEs1ӡv1֍t)􉥸PR/Cj	hm5vSfSh  jBQuƃu;j hvh  W3ShxP  v EPVj	|E%   =   t>蹗ËV_j hvh  TRS薷Sh      ]ԅ   =ty%?)ĉWRj 
tyً=c!QVMÃuMËV
j hvh  PSShR  t& ˖8u'
tyI=c!QPV
Ãtυ|cW&    
c9t@V
ct5cS&j h5vhWbv j VjjPj {&ÉcuKËVj hvh  RSShQjZ  t& Vj=c8=Pc=TcLc=Dc} uJ   󥋅@    t   Lc@   U    x ƃt     C|jdc\cP0Xcu)5c5c3%j h j2j{\cXc`clc    5Lchc9vHcޅ   v    v |c҉
DcL1
lclcDc؋=`cϋ
XcfQfTXcfBNu5tc+5pc=Tc9sy1=  vc   d   v   1cD v	1þ   1Ɖ5ct& c   5c5pc5Tc5Pc)      [^_UXWVS=      
pc)Mxc9]rE    )M9]  
cEEmU5XcVU
tV5`cu΋U9p  fy t]16E9tQfy u3E9;  M
Lc9Hc   5Hcu;5hcszDcvE܋|c҉U؋L1u؋
lclc]܋5`c΋XcfBfTXcfB5HcuF5Hc
LcE@9uuf> ulC;hc   flcfЋ5`clc[]DcuDc4u؉tD    fA  Hc!E0`cU3E9C    e[^_ÐUXWVS]E    t;5	F EԊ~)t$F P6E؃uE    } uE    } |}t}$~p    ]  t& UUU@	UDB tt& EE8UDz uE E  <-uE   EUU,t& }+uE    EE E
    E    }0uC} t}u'URL	<XuEE   UU} uE   } uE
   EE  EUU8t=]
L	u;utEЀ}	vDst;E}EE Eu;}uUU4  M}} $  EԀ8 u 9   ;E   A;Mr   U9U   t& Ou;M   ;EtI;Ms;M   })MESU9UusAEFIuNt};M   ;EtI;Ms;Msj;Mrv ;EtI;Ms;Ms)9~B;Mr	)9t}U9U~|;}5;MsMM    }E    EEȉURPjj EUEȋURPjj ӉME            UU   EȋỦEUċU9U   MЀ	w	Mt& MEDHtwL	ɈEM;M}a;}wu;uw;uu;}u;Mv	E   *EӋUӋEUUΉu EE E[U9U   } tUE} u0} t   wuwt& vE   } t+膌 "   } t       } tك ۉȉK} t;E+E~(E@L	<XuEx0uHUt& UE        e[^_ÉUj uuuÐUXWVS]E    t;5	F EԊ~)t$F P&E؃uE    } uE    } |}t}$~`      t& UUU@	UDB tt& EE8UDz uE E  <-uE   EUU,t& }+uE    EE E
    E    }0uC} t}u'URL	<XuEE   UU} uE   } uE
   EE  EUU8t=]
L	u;utEЀ}	vDst;E}EE Eu;}uUU4  M}} $  EԀ8 u 9   ;E   A;Mr   U9U   t& Ou;M   ;EtI;Ms;M   })MESU9UusAEFIuNt};M   ;EtI;Ms;Msj;Mrv ;EtI;Ms;Ms)9~B;Mr	)9t}U9U~|;}5;MsMM    }E    EEȉURPjj  EUEȋURPjj  ӉME            UU   EȋỦEUċU9U   MЀ	w	Mt& MEDHtwL	ɈEM;M}a;}wu;uw;uu;}u;Mv	E   *EӋUӋEUUΉu EE E[U9UtC} tUE} t誇 "   _} tك ۉȉH} t7E+E~$E@L	<XuEx0uHUUE        e[^_ÐUj uuuMÐU  WVSE
   E    } t=	C Eք~)t$C P[EuE    } uE    	@ P+EuE.   E    E    E    MIM@	&    EE EDS u<-uE   EM	Mv }+uEE EE<	  Ud;]uMI΀/~	9  H	<iu`jh}W0ƃu   jhEPƃu'   } 6  ]U6  6  H	<n9  jhMQÃ  E}?(   H	dEUPllЀl	v܋M	d4`~z~ÀP_tP)t]   j j EPCS۽pHLۭpU9Uu[ٝhHL  	uǅH  @ ǅL    t& H% h  	hمh} 5  }M95  } >  UE1  }0u-MIH	<xuE   EE EE    UP}0t} t M}9uEE E<0t} uE<	v}uUdH	MME    H	Et& E<	v}u}4`~
fE} t1EU9u&EM	M}u	}O~}z~} u}   }   P}|E8 u 9  ;E  C;]r  P9U  |IduP9   d U9tdP9ds܋P9d   |ld)lM{h9l   JxFdHduNdt}KP9dr2d?E9tdP9ds܋P9ds|   dP9r2d U9tdP9ds܋P9ds+d9~P9dr+d9x|,h9l~d\;|d|P9|E|;PsP9]tx;Pu}   }M9  &    ;]s}   E  &    ]E    ]U9s<	wEC;]rMM1  }d}u}O    }z~E&   EEH	u1U9dueEM	Ml<}H`~@f;}0tuu+uEEUUllЀl	v˃}tMP}d}u<pt      d<ei  ǅt    EUU-utEM	Mv }+uEE EE<	  }u,t tU   )*t&    M)t t=   ^&+]}<}d9~iu} t:4~ "   t u} t    EU<	v} /  M/  }dDЉdEEUUllЀl	Ft t؉E	PM}9}~$Px0uv PMPz0t} t}M9} u}   3/  tBE U9tEM	}9uED0E}u    )Ev )u)u}  ǅH    ǅh   Ud@	DSuv EM	dDKtꋽdD{t
Ev EdH	4ƩH    }h+h@4;hM} w  pH ^  Ud5@	DVut& EM	dDNtꋽdD~t
Ev EdH	4Ʃh@~ h拽p	4;h  ǅd   h)dldӭllp	;hHQ  } lUHlǅh   d`  )Ӄ)  tduR}lǅh   1ۍ    > tdKy1ۋ        Ky    sH}	CHHlllhl)hǅd    h h: tdhdH}	KHHH9d|   hHltdH}	{HHhhlh)llQl)llWRQǅd       7lH)lld    dH}	{HHH9d|)~%UlKhSjWWǅHlhsd uu   HltY   t&HjjPPuJ!    Hu   t
ǅHH   )  MQHWP)  HlӋ4hM} 1;H}    F;H|uǅ`    ǅ\    ǅH    <  )M&  uF}`ǅ\   1ۃ> tHKy1ۋ    Ky    sd}	Cdd`ll\l)\ǅd    hh: tHhdl}	Klll9d|   \H`tHd}	{ddhhlh)llQl)llWRQǅd       7lh)lld    dh}	{hhh9d|)~%U`K\SjWWr`\&  H u!u   H`&     t&  &  EdÅ}uމH9}u+udH9~HHM)ˉl]߉dE'  d}t "   J&  } '  UXMT}PELUHǅd    1E    d	  L1u]      h ʚ;VPWWeDL dUuӉl]H9s3dt#AHHuduݻ   C9Ht81ۋdH9}%H>H9HC;|1DtL DPLǅd    1ۋX<	vXXЀ	wX \XXdTT H2~,dH	`4`    d4`L Hu]L      VHQPWW踔@L dUuӉl]9ls&dtAudu   C9t=ǅh    dOH9h}hH9h|1@tL	@PLXM}d0  PE<ǅ8   ǅHd8   38Ud}h9|QHRWS<Q%v hWSdPH
Q<W9dEЉhEd uHEl<l<}d8Hd #;uEPRPQo]P|4lll)E=   ~qp "   !      }h  ]yu)ÉHuV00H tHI,
ǅ,   H utu}   v d4HU9   (P$ǅ     H) dh)h$H@d$< 	h(d}O9|d)dPHEǅd    } uPt& dd< tuN0PǅH    E9E|9d}
ǅH   ,H\  )     HtHuF}ǅ   1ۃ> tHKy1ۋ    Ky    sd}	Cddlll)ǅd    hh: tHhdl}	Klll9d|   HtHd}	{ddhhlh)llQl)llWRQǅd       7lh)lld    dh}	{hhh9d|)~%UKSjWWW  H ~   H%  cE9E
  uNHdyUdd+d      h4)h}QPPhR2ǅh    +]9h  d   hd    AhlE)ll9|<  v    ǅl   )llQ4WPP   l)lUlQǅh    +]9h   d   hd    @hlM)ll9|}   t& S4PPRǅl   )l]lQ輈d}߉1ۋE9}#dd    C}9|鋝Hǅ    ǅ    ǅH    @  )  uIEǅ   1ۃ> tHKy1ۋv     Ky    sd}	Sdd<lll)ǅd    h h9 tHhdl}	{lll9d|   HtHd}	{ddhhlh)llQl)llWRQ识ǅd       7lh)lld    dh}	{hhh9d|)~%UKSjWWskH uu   HtE0   tCjjPP诅Ju
   t     MQS-  SPPUR脑Md}Eǅ U+Uǅl   M)lVUUUll+lK}EU9~ǅ   ˉ
ǅ    +dE    ǅH    H   3H} u)MQ PRqiMQWP 
QW胄dEDEd uHElH =9uURPQȏ}ǅd    1E    d	  2u]          h ʚ;VQQ蝆?dEuÉl]H9s;dt&v BHHuduݻ   H    9Ht81ۋdO9}%HH
HC;|1t?ǅd    1ۋ<	vЀ	w \Xd 2~,dH	`4`    d4` Hu]      VHQWW dUuӉl]9ls&dtAudu   C9t=ǅh    dOH9h}hH9h|1t	MI~;SEPWW?SuRR.Ã tM9Ev EE}t}L  U|K
  1ۋM}t& 1H} umu    Ht& )u    )~1^ǅl    )lHl}9      v HEރ    u H
g   +]~Y uHDSjRR~ǅd    )dHhdӭhh	}uuNǅd   )d1ۃ u	 t   HdHa  )b     HtHuJ}ǅ   1ۃ> tHKy1ۋt&     Ky    sd}	Cddlll)ǅd    h h: tHhdl}	Klll9d|   HtHd}	{ddhhlh)llQl)llWRQ|ǅd       7lh)lld    dh}	{hhh9d|)~%UKSjWWb|  H 
   H  ǅ    ǅ    EUĉ}   EH9r1   } UUhu ~%ǅ   U) ~< u    RjQQ{}EH]HǅH    ]UH}  ;uTǅH9s+  H   HHtKH*H֋H9wu2H t)H+ H;s1+HމH} uy u
    v     )u    )~4ǅl    )ll}9      Eރ    u 
   ǅ   }) ~p uW&    QjWW
yǅd    )dhdӭhh	}uuNǅd   )dǅl     u
u	H t
ǅl   dlHi  )Z     HtHuR}ǅ   1ۍ    > tHKy1ۋ        Ky    sd}	Cddlll)ǅd    h h: tHhdl}	Klll9d|   HtHd}	{ddhhlh)llQl)llWRQvǅd       7lh)lld    dh}	{hhh9d|)~%UKSjWWRv  H    H  ǅ    ǅ    U}WEl)llRQ[qÃ~}    E];]  u)ރ} vH~*t& HHJH1ۍVd9}(H    H    C;d|)u  HHEHt     Uh~*t& hhJh1Fd9       C;d|   t& ǅ   M)~t}hhlh)llRjQ}P}sރ|P    Ny> ~3 u    QjWW*sEHUޅ~Vօ񋍈|    H}S  UB9Huǅ   HӋHHH;v5;r!9HsN)H9wtRQWPÃ|9t}WPRRK  |H~ˍVօ} uw u
    v     )]    )؃~0l)ll}9      Eۍs    u 
vǅ   }) ~Y u@QjWWpǅd    )dd	]uu< u|
N< t]KǅH   )Hǅh     u|
ǅh   ދHhHk  )~Q !      HtHuH}ǅ   1ۃ> tHKy1ۋ    Ky    sd}	Cddlll)ǅd    h h: tHhdl}	Klll9d|   HtHd}	{ddhhlh)llQl)llWRQnǅd       7lh)lld    dh}	{hhh9d|)~%UKSjWWmskH uu   HtE   tFjjPPmJu
   t   ~} 1t& MQVW  <[^_Uj uutÐU  WVSǅ
   ǅ    } tI	C ք~2t-C P{u
ǅ     u
ǅ    	@ P{u
ǅ.   ǅ    ǅ    ǅ    MI$@	$$ DS u<-u ǅ   $$	+u$$ <	D  <;u$I΀/~	9  H	<i   jh($WOwƃu   !jh,$P,wƃuS   } F  $UE  t&              X\݅XF  v H	<nL  jh5$QvÃ,  $$?(  H	<$$GHHЀH	v֋$	<4`~z~G_tG)t$   t& j j PCS۽LȿۭL$9ua$[^ 	uǅ    ǅ   1҉ %  	֋VS$} D  $M9D  0u?$I=H	<xu)ǅ   $$ ǅ    $0t! t9&    9u!$$ <0t能 uΊ<	v"u<
H	@$ǅ    H	a<	vu4`~
f tY9uH$$ ui  ~  z m      $9 u&9  ;  C;$r  9$  H<9   <	9t<9<sً9<   H<)HS@9H  O|&    F<I<uN<t}N9<r5<9t<9<sً9<s   <9r5<	9t<9<sً9<s+<9~9<r+<9|,@9H~<\<9/;s9$   ;u} ;  UE.  ;s}   M  $ǅ    $9s<	wC;$r鋅1      <ui    ~
ǅ4  =H	@u
v 1ۋ9<   $$HT@4`~XfS0tu+$$ HHЀH	vt$<u@<pt!<      <@<e   ǅx    $$-ux$$	+u$$ <	  uEx tǅ<2  )<V   )<<&    x tǅ<h  )<4  )ʉ<<@<9   u tmgD "   x uQ t*             X\݅X              RP$$$Ѐ	v} 8=  }.=  @TЉ@$$	HHЀH	x tډ$9~~0u    N~0t} t$E u   p<  t`	9t 9u狍Lu    )))	  ǅ$   ǅ@   ?<@	D{u <DCt䋕<DSt
փ<=H	4Ʃ$    h@+@@A4@ +  t$    <5@	DFu#&    <DVt䋍<DNt
΃<H	4Ʃ@@~'@拽t	4;@g  t& ǅ<   @)<H<ӭHHt	;@$   Hplǅh   $f  )Ӄ55  t$5u[hlǅh   ht& > t$9~   h    Ky    s<}	C<<hlHHhH)hǅ<    h@@: t$@<H}	KHHH9<|   hHlt$ޅ}s<@@H@)HHPǅH   )HHQh<WhP5]ǅ<       8H@)HH<<h8    <@}	S@@@9<|,~(lChSjhRR\ǅplh  $ u!h u   Hl   ǅ$   hC<9s2ǅ$   C<<u
$uCv 9<t81ۋ$I$9}%<<<C;$|ውhY    t pjjQQ[hOpu   t
ǅpp   6  Pp16  $Hh4@ 1;$}h    F;$|dǅ`    ǅ\    ǅ$    N  )Ӄ51  uVhI`ǅ\   h> t$9~   h    Ky    s<}	{<<h`HH\H)\ǅ<    h@@8 t$@<H}	SHHH9<|   \H`t$ޅ}s<@@H@)HHPǅH   )HHQh<WhPYǅ<       7H@)HH<<h8    <@}	S@@@9<|,~(`C\SjhRRtXǅd`\   $ u!h u   H`      h?$hGh8<$9s%   A<<uKuL9<tDǅ@    K$9@}+<&    @$9@|⋍hY    t!djjQQ`WhOdu   t
ǅdd   1  Pd2  @}$$;$}.&$)$@;$~$)@@=5    @}7 "   h1   T  XThPLHǅ<    1ǅ    <	  L0uh       h ʚ;VPRR-YDL	<hlHh$9s2<t#@$$u<uݻ   B9$t81ۋ<I9}%$$$C;|1DtL	DPLǅ<    1ۋXЀ	vXX<	wX	\YX<TT H7~,<$	 4     <4 L	$uhL      V$PPRRuW@L	<hlHh9Hs*<t@u<u   E9t=ǅ@    <J$9@}@$9@|1@tL @PLX@J  Pd<ǅ8   ǅ$t& @8   38<@9|P$9WRS<P"@RS<Q$P<RR<>@< uIH<H<@8$@ ;du QdWPP]PT4HHH)щ   ~2 "   I,  5  ˉys)É$u~0t& 0$ t$H,ǅ,   $ u-hhlq   t& <4Oh9   (P$ǅ     $) &    <@)@$$G$ 	Ë@(<O9<|<) <P$苍hAǅ<    h uP<<< tN0Pǅ$    9|9<}
ǅ$   ,$n  )5{&     Ht$5uVhǅ   h> t$9~   h    Ky    s<}	C<<hHHH)ǅ<    h@@: t$@<H}	KHHH9<|   Ht$ޅ}s<@@H@)HHPǅH   )HHQh<WhPMǅ<       7H@)HH<<h8    <@}	S@@@9<|,~(CSjhRR"Mǅ  $ u!h u   H      h?$hGh8<$9s%   A<<uKuJ9<tBǅ@    K$9@})<t& @$9@|⋍hY    t!jjQQLhOu   t
ǅ   &  P&  9n  N$<y<<+<      @4)@hRPW@PUWǅ@    +9@  h<   t& @<    A@H)HH9|  t&    ǅH   )HHQ4WPP   H)HhHQJǅ@    +9@-  h<       @<    @@H)HH9|   t& S4PPRǅH   )HHQI<ǅ@   )@h@ǅ@    ǅH   )HH9@}G؉<   t& @<    B@H)HH9|ʋ$ǅ    ǅ    ǅ$    N  )5  uVhIǅ   h> t$9~   h    Ky    s<}	{<<hHHH)ǅ<    h@@8 t$@<H}	SHHH9<|   Ht$ޅ}s<@@H@)HHPǅH   )HHQh<WhPCGǅ<       7H@)HH<<h8    <@}	S@@@9<|,~(CSjhRRFǅ  $ u!h u   H      h?$hGh8<$9s%   A<<uKuK9<tCǅ@    K$9@}*<    @$9@|⋍hY    t!jjQQEhOu   t
ǅ      P2   SPWhPCQ
h    d h`ǅ+tǅH7   )HVUUUHH+HKH@hlpH9t~ǅ   Ct
ǅ    t+@ǅ    ǅ$   $   3$ u0P
Q WOtt& P RQPRC<;LuI H $,`9 uWQdP2Otǅ<    1ǅ    <	  l7uh          h ʚ;V`PPEl<hlˉHh$9s2<t#>G$8$u<uݻ   B9$t81ۋ<J9}%$$$C;|1tl`<l ǅ<    1ۋЀ	v<	w	\Y< p7~,<$	 4     <4 l	$uhl      V$P`RREDl	<hlHh9Hs*<t@u<u   E9t=ǅ@    <J$9@}@$9@|1tl `lHd~>SQRR?S`WWu?Ã t8t%X  x  t& 1h    1    u    
)    )؃5~<s5ǅH    )HHǅ$V   M      h@    ۃ $  &     $5\   h<h@@<<@Kۋh   t& 5   +    uX   h<h@@?<8<@Kۋh
:v VjhWWP=ǅ<    )<<	$5H$ǅ<   )<1ۃ u	 t   $<$q  )Ӄ5      Ht$5uXhǅ   h> t$9~   h    Ky    s<}	C<<hHHH)ǅ<    h@@: t$@<H}	KHHH9<|   Ht$ޅ}s<@@H@)HHPǅH   )HHQh<WhPE;ǅ<       8H@)HH<<h8    <@}	S@@@9<|,~(CSjhRR:ǅ   $ u!h u   H      h?$hGh8<$9s%   A<<uKuL9<tDǅ@    K$9@}+<&    @$9@|⋍hY    t!jjQQ9hOu   t
ǅ     P2  ǅ    ǅ    g  h9r
1b   !  v  $΃5Z   h<h$$<<$Kۋh       t& ǅ5   )     uW   h<h$t& $?<8<$Kۋh    QjhWWg7hǅ    t& lh5  ;u]ǅ9s"+ދ     v $$tN$*Ӌ9wu2 t)+ ;s1+މ     u    
)    )؃5~>5ǅH    )HHǅ$V   j  h@    ۃ $?  &     $5\   h<h@@<<@Kۋh   t& ǅ5   )     uY   h<h@t& @ <<@Kۋh9CPjhRR4ǅ<    )<<	$53H$ǅ<   )<1ۃ u
u	 t   $<$v  )˃55     Ht$5u]hǅ   h&    > t$9~   h    Ky    s<}	C<<hHHH)ǅ<    h@@: t$@<H}	KHHH9<|   Ht$ޅ}s<@@H@)HHPǅH   )HHQh<WhPu2ǅ<       8H@)HH<<h8    <@}	S@@@9<|,~(CSjhRR1ǅ   $ u!h u   H      h?$hGh8<$9s%   A<<uKuL9<tDǅ@    K$9@}+<&    @$9@|⋍hY    t!jjQQ0hOu   t
ǅ   <  Pb  ǅ    ǅ    d<dQH)HHdP`R+Ã~`9    ;  )ރ p$~%`$$J$1ۍF<9}$`$$    C;<|)+  $$$5      h<h@@<<@Kۋh    G    @~%`@@J@1F<9;  `        C;<|  ǅ5   )~|}@@H@)HHPjhRh<W-ރ   h    Ny    ~v uN   h<ht& <
<K勽h    &&    PjhRR,$"v ޅ~`t& Vօdx    `4
5E  G|;uǅ   t& `ӋƉ$9wuJ&    `;4v2;r;s$+9$wtP|RdQ`W@Ãx98tRdQWWO  `<Hx<<~Ë<O<<ヽ     u	        )    )؃5~>5ǅH    )HHǅ$V   j  h@    ۃ $?  &     $5\   h<h@@<<@Kۋh   t& ǅ5   )     uY   h<h@t& @ <<@Kۋh9CPjhRR)ǅ<    )<<	$5<`< u!< |<<`< tߋK   +ǅ$     u	< |
ǅ$   $  +5~S
 !   x   Ht$5uXhǅ   h> t$9~   h    Ky    s<}	C<<hHHH)ǅ<    h@@: t$@<H}	KHHH9<|   Ht$ޅ}s<@@H@)HHPǅH   )HHQh<WhP5'ǅ<       8H@)HH<<h8    <@}	S@@@9<|,~(CSjhRR&ǅ   $ u!h u   H      h?$hGh8<$9s%   A<<uKuL9<tDǅ@    K$9@}+<&    @$9@|⋍hY    t!jjQQ%hOu   t
ǅ   ~+              RP$PRhQ!I  [^_ÉUj uuķÐU   WVSǅ
   ǅ    } tI	C ք~2t-C P3u
ǅ     u
ǅ    	@ PF3u
ǅ.   ǅ    ǅ    ǅ    MI(@	(( DS u<-u ǅ   ((	+u(( <	  @;u(I΀/~	9  H	<iuyjh(W/ƃu
   $v jh(P.ƃu7   } t(U t
-E  -E  H	<n  jh(Q.Ã  -((?(   H	@t& ((KLLЀL	v֋(	@4`~z~K_tK)t(nj j PCS۽PwÉۭP(9u>۽ډ	u
       @1
   ۭ} D  (M9D  0u?(I=H	<xu)ǅ   (( ǅ    (0t t49u!(( <0t能 uΊ<	v"u@
H	D(ǅ    H	a<	vu4`~
f tY9uH(( u  ~'  z m      (|9 u&9  ;  C;(r  9(  |H@9   @	9t@9@sً9@   |L@)LSD9L  Ox&    F@I@uN@t}N9@r5@9t@9@sً9@s|   @9r5@	9t@9@sً9@s+@9~9@r+@9x|,D9L~@\|@|9|/|;s9(   ;u} 3  UE&  ;s}   M
  (ǅ    (9s<	wC;(r鋅1c      @u  '  ~
ǅD  =H	Du
v 1ۋ9@   ((LTD4`~XfS0tu+(( LLЀL	vt(@uD<pt!      @D<e  ǅt    ((-ut((	+u(( <	~  uEt tǅ@=@  )@V @  )@<&    t tǅ@  )@D  )ʉ@<D@9~zu t<-6t& + "   t u t
--((Ѐ	v} `=  }V=  t& DTЉD((	LLЀL	t tډ(9~~0u    N~0t} t(E u 4  -<  t`	9t 9u狍Lu    )))	  ǅ(   ǅD   ?@@	D{u @DCt䋕@DSt
փ@=H	4Ʃ(    pD+@DA4D ,  p(    @5@	DFu#&    @DVt䋍@DNt
΃@H	4ƩD@~'D拽p	4;Dh  t& ǅ@   D)@L@ӭLLp	;D(   Llhǅd   (V  )Ӄ@%6  t(@uLphp> t(9~   p    Ky    s@}	C@@phLLdL)dǅ@    pDD: t(D@L}	KLLL9@|   dHht(ޅ}s@DDLD)LLPǅL   )LLQp<WpPǅ@       7LD)LL@<p8    @D}	SDDD9@|,~(hCdSjpRRǅlhd  ( u!p u   Hh   ǅ(   pC@9s2ǅ(   C@@u
(uEv 9@t`1ۋ(I(9}M@@@C;(|&ljjpQQpO"lupx }
ǅll @  ~ ]6  -r6  RlS6  (LËp4D 1;(}p    F;(|`ǅ\    ǅX    ǅ(    N  )˃@1  uVp\ǅX   p> t(9~   p    Ky    s@}	C@@p\LLXL)Xǅ@    pDD: t(D@L}	KLLL9@|   XH\t(ޅ}s@DDLD)LLPǅL   )LLQp<WpPSǅ@       7LD)LL@<p8    @D}	SDDD9@|,~(\CXSjpRRǅ`\X  ( u!p u   H\      p?(pGp8@(9s%   A@@uKuM9@tkǅD    K(9D}R@    D(9D|&`jjpQQpO"`upx }
ǅ`` @  R`+2      DÅ}((;(}.&()(D;(~()DD=E  ~,& "    t
-1  -1  D} "   c1   k  TPLHDǅ@    1ǅ    @	  H2u          h ʚ;VLQQ=@H?@ÉL(9s2@t#B((u@uݻ   B9(t81ۋ@O9}%((
(C;|1@tH?@LHǅ@    1ۋT<	vTTЀ	wT \XT@PP D2~,@(	4    @4H (uH      V(QLWW<H @ӉL9Ls*@tAu@u   E9t=ǅD    @O(9D}D(9D|1<tH	<LHTDJ  Ll8ǅ4   ǅ(t& D4   34@D9|Q(RWS8Q"DWS@P(
Q8W
@ЉD@ uHL8L8D4(D ;lu PlRLQL|0LLL)= @  ~0 "    t
-q,  -f,  t& @  ys)É(uV,    ,( t(I(ǅ(   ( u-pp   t& @0Jp9   $L ǅ    ()&    @D)D (B@ <	D$@O9|@) @L(苍pAǅ@     uL@@< tN,Lǅ(    9|9@}
ǅ(   ((n  )@i&     Ht(@uVpǅ   p> t(9~   p    Ky    s@}	C@@pLLL)ǅ@    pDD: t(D@L}	KLLL9@|   Ht(ޅ}s@DDLD)LLPǅL   )LLQp<WpPǅ@       7LD)LL@<p8    @D}	SDDD9@|,~(CSjpRRǅ  ( u!p u   H      p?(pGp8@(9s%   A@@uKuJ9@thǅD    K(9D}O@v D(9D|&jjpQQ	pO"upx }
ǅ @  R&      9^  N(@y@@+@      D0)DpQLPDREǅD    +9D  @   D@    ADL)LL9|     ǅL   )LLQ0WLP   L)LpLQǅD    +9D-  p@       D@    @DL)LL9|   t& S0PLRǅL   )LLQ@ǅD   )DpDǅD    ǅL   )LL9D}G؉@   t& D@    BDL)LL9|ʋ(ǅ    ǅ    ǅ(    N  )@  uVpIǅ   p> t(9~   p    Ky    s@}	{@@pLLL)ǅ@    pDD8 t(D@L}	SLLL9@|   Ht(ޅ}s@DDLD)LLPǅL   )LLQp<WpPCǅ@       7LD)LL@<p8    @D}	SDDD9@|,~(CSjpRRǅ  ( u!p u   H      p?(pGp8@(9s%   A@@uKuM9@tkǅD    K(9D}R@    D(9D|&jjpQQpO"upx }
ǅ @  R       SLPpRC	
p    lhǅ+\ǅLB   )LVUUULL+LKLDptxL9\~ǅ    C\
ǅ     \+Dǅ    ǅ(   (   3( u0P
QWtt& PRQPR@;LuIL(,h9uWQlP2\ǅ@    1ǅ    @	  t7u          h ʚ;VhPPt@ˉL(9s2@t#>G(8(u@uݻ   B9(t81ۋ@J|9}%(((C;||1tth<t ǅ@    1ۋЀ	v<	w	\Y@ x7~,@(	4    @4t	(ut      V(PhRREt	@L9Ls*@t@u@u   E9t=ǅD    @J(9D}D(9D|1tt htHl~>SQRRShWWuÃ t8t%X  `  t& 1    1    u    
)    )؃@~<s@ǅL    )LLǅ(a   M      p@    ۃ (  &     (@\   p@pDD@@DKۋp   t& @   +    uX   p@pDD?@8@DKۋp
:v VjpWWPǅ@    )@@	(@H(ǅ@   )@1ۃ  u	 t   (@(q  )Ӄ@      Ht(@uXpǅ   p> t(9~   p    Ky    s@}	C@@pLLL)ǅ@    pDD: t(D@L}	KLLL9@|   Ht(ޅ}s@DDLD)LLPǅL   )LLQp<WpPEǅ@       8LD)LL@<p8    @D}	SDDD9@|,~(CSjpRRǅ  ( u!p u   H      p?(pGp8@(9s%   A@@uKuN9@tlǅD    K(9D}S@&    D(9D|&jjpQQpO"upx }
ǅ @  R      ǅ    ǅ    g  9r
1b   !  v  (@Z   p@p((	@@(Kۋp        t& ǅ@   )     uW   p@p(t& ( @@(Kۋp    WjpPPgǅ    t& @  ;uXǅ9s+ދ     ((tN(.t& Ӌ9wu2 t)+ ;s1+މ     u    t& )    )؃@~>@ǅL    )LLǅ(a   j  p@    ۃ (?  &     (@\   p@pDD@@DKۋp   t& ǅ@   )     uY   p@pDt& D @@DKۋp9CPjpRRǅ@    )@@	(@3H(ǅ@   )@1ۃ  u
u	 t   (@(v  )˃@5     Ht(@u]pǅ   p&    > t(9~   p    Ky    s@}	C@@pLLL)ǅ@    pDD: t(D@L}	KLLL9@|   Ht(ޅ}s@DDLD)LLPǅL   )LLQp<WpPuǅ@       8LD)LL@<p8    @D}	SDDD9@|,~(CSjpRRǅ  ( u!p u   H      p?(pGp8@(9s%   A@@uKuN9@tlǅD    K(9D}S@&    D(9D|&jjpQQpO"upx }
ǅ @  RK      ǅ    ǅ    llWL)LLlRhQÃ~h    ;  )ރ p(~%h((J(1ۍV@9}$h((    C;@|)+  (((@      p@pDD	@@DKۋp     @    D~%hDDJD1F@9;  h        C;@|  ǅ@   )~|}DDLD)LLRjpQpPރ   p    Ny    ~v uN   p@pt& >@9@K勅p     &&    RjpQQ("v ޅ~ht& Vօl`    h49@E  @d;uǅ   t& hӋƉ(9wuJ&    h;4v2;r;s(+9(wtPdRlQhWÃ`98tRlQWW  h<L`<@~Ë@O@@ヽ     u	        )    )؃@~>@ǅL    )LLǅ(a   j  p@    ۃ (?  &     (@\   p@pDD@@DKۋp   t& ǅ@   )     uY   p@pDt& D @@DKۋp9CPjpRRǅ@    )@@	(@@h< u!@ |@@h< tߋK   +ǅ(      u	@ |
ǅ(   (  +@~S !   `   Ht(@uXpǅ   p> t(9~   p    Ky    s@}	C@@pLLL)ǅ@    pDD: t(D@L}	KLLL9@|   Ht(ޅ}s@DDLD)LLPǅL   )LLQp<WpP5ǅ@       8LD)LL@<p8    @D}	SDDD9@|,~(CSjpRRǅ  ( u!p u   H      p?(pGp8@(9s%   A@@uKuN9@tlǅD    K(9D}S@&    D(9D|&jjpQQpO"upx }
ǅ @  ~&    -RQpW  [^_Ív Uj uu ÐWV|$t$T$L$؃tA)))t& FBGFBGFBGFBGFBGFBGFBG v R Iu^_WVSU|$t$L$l$ <41ۉ؃  Au][^_UUE	E%   	%   	Q$ÐUVSMU%	֋E  %  	ƋQ %  	VS$e[^ÐUMUE$ЈEE?  U 	fUEAEmÐT$D$1QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQj j j j j j t'HtHtHuӍB8tH8tH8t	H8u@@@   u1ÐU1MtAÐUWVS}1эy5yt(S9w)tVEPut<ދu؍G	PÃu1*    {EP{Wxt
ye[^_U(WVS= tY     hE؃u	EE؀8 uE} t}؀?:uG}؋t} tREP  c    c    t	R} t}W
    EP
  =   } t}؀?    ccc    c    fc  fc  fc  fc  fc  fc  c    c    c    c    ccc    c      j@hc_cccU؉1эA$)ĉeQWEP VhWOkZ  1эY>  V/c]؃E؊˄  +t-tы=@	DW  -t+uE؀-u   c
cEEP}}WEEPh}Wjt
t  t  fE  fE  f}:w
M&    ;   f}:wU)Ѝ
t& 
  cf}wU    )	v pC Ӊc1ۋ@	э&    E DAtv E؋}?DzuwE؀8:u@ECvɋ}؀?   1VhEP|i  1эY  V\c]؋E؊-t+uE؀-u   c
v c}WEP}WhEPht(tt =c  =cfE  fE  f}:w
M&    ;   f}:wU)Ѝ
t& 
  cf}wU    )	v pC Ӊc1ۋ@	э&    E DAtv E؋}?DzuwE؀8:u@ECvɋ}؊t,uk ue5c5c5c5cX  = t<5      cccc  &    fE  ]ށcE؊,u@E؊Jt}@	DP   J%   cuE؋}@	DP  }j j
WEP`fcU;U  fm  cu	f  U   v Mu{ǃc   }WFP~
WFPh}Wf  fVf  f{  fV
fn  fd  f~Y  Eǉ}ME  ǃc   cufǃc fǃc fǃc
 fǃc fǃc  }؊t/t,   /   E؋E؀8    }WEP}WhEPett
tfE fE  fE  1ۋ@	ы}?DytE؋E DBuw}؀?:uG}CvE    )M)ȍUЉF
    F   FfEf}ycأe[^_Ív UWVSEUt	9P  1  ;u}_v    uHQщM})]EE9u)ٍ9u 	v ǀ3F;u|EHt      a  t& UBHEUE)׋Ufz;*  E  Qmщ])ލ4u9Eu)ٍ9E  ǀQ   EPUEUE)  1UuEQщM}])]EE9Uu)ٍ9Eu   u    ƋUJMpUBEUE)׃	*M}+][)ٍqMEfxwIQM}+]E)эv4uUgfff}+ut}ޅ}s)މu踓$Iu}+M    )ȉ)yUZ)yE   Ep
9usU
+MCE9}
E9ur)ǋU+zzzEB   e[^_ÐUWSǋWl  ct;Wl  ct$c9c~Wm  cu1{t& c;cEډ=c=c1эQIy9vy9v
y   e[_ÉUWVSu}]u蕮    1      t
hcy%   #= tSEPEPW6}  u0   Sj V  tu1E    E    t|t== uI1ҋ;c|;cЉS C(cC$C     C(C$    SEK$)PV"  tEt& 1۸    t
hc؍e[^_ÐU    t
hc   = ucc    t
hcMÍv U    t
hc21    t
hcyÐUhWVS    t	R    t	R    t	R{    t	R^    t	RA    } u	E+`E  =L tJ/u*ƿ+    tƿ    ~  h:MQ:c  E8/tyh>{Et8 uE   }1эQ}1֍D2$)ĉRMQS/BVEPR]hDMQ.aǃ  Wjj,EPS    Uff dEffdMffMEffdMffMȋEffEąt8    P%  5 d
  dt    P  } tMQĖ  dt    P蚖   dWSj5
  9n   dWSj5  9N  1ۋ d9s$5dEt& 3;E#  C9rZt(&    
ff]K} u1;d-  MЉM   t& W;Wr
WGtE@ENuԅ      MMEMM   W;WrW~
t& GtE@ENuЅA  
MEE   W;WrWp~t& GtMAMNuυ  |  D;E  EffC;dWMQj5B  ;U  1;d       ẺEE   W;Wr
W}GtMAMNuԸ   )4  Uff؋MM   v W;Wr
WV}GtE@ENuԸ   )  UffTC;d01;]sLW;WrW|ƃt& Gƃ  DC;]rD C;dr1;]sIW;Wr
W|ƃGƃ(  DC;]rD C;drWY1ۃ;ds"DPdC;dr         dt\K
E|4     uLQ E   )}M< t= u8=dthFh.  hTh]賴v 5= u
E   du dd   11d    d    Z]E
MKt]u*ME| u   Љd,t& u#ME| t   Љdttu
ddd;dMȃډ   	v WWe[^_ÉUWVShlm= \  =dvG5!}1щM}щMEP舐u       MQEPMQEPRXRMd   11; dsct& 
4ЊF~ u4t~ uE+d&    E+d~C; dr
A M@ MH
E
AAEM
ى
UUA  e[^_ÐUWVS}    dt

u;1}/1ҋd9sH9 tB9r9u814       9sÍAu;0|B9rTЉUd;dƃ5ډ         dtRK|D4    u uP   )< t= u7=dthwh  hTh]诰   5= u
uFuF uFuF(uuF$u    u    dt& rnu;4|Duu;4uJuz 
D9D~6u   t)t& D@9DuuKtD@9tݸ   e[^_UWVSǋ։Ӌ
y: t	v B: u)9vy5B79rύe[^_Ðڋ\$   ̀=6ÐUWVSEME    19M}B]F;u|E$)ĉe}1;u}CUӃ]]9v}U]S]3PN+}t]EF;u|ȋ]S]S]Se[^_ÐUWVS}u]eEUS   ̀[= v؋U} M9u~MU
ىe[^_ÐڋL$\$]   ̀=ÐU   S]uB=d u1  j hdj  |Pd    j h dj   =d t4j hdjf  |j h dj}
   dM
dEdEdǅt0E   txP  h dSj~|Gǅl    ǅp   lpdhhddPj      `Ív UdUD)%d;ds	dfPÐUSE    E   E    E    j ]Sj    Sj j   M~@B Й1]ÐUEth   h   P:1ۜ    ÐUWVSu}߅u1&    Suu,w9t1e[^_U$WVSE EܸE.m܉MME܉E}U)UEUEU)M)Myt& MQ xv EQ ų]܉M}E)E܋E܋UBU))]܉M}E)E܋E܋UBEe)EU)ыEM$I]܉M}E)E܋UE))ыUJyJ    }l    mMM܋EE}U)U܋E܍8EЉEEE)Um+MMWUQщM}EE}U)U)Ӊ}Oʍ    M))ʉэE)yA)ىM]KQщM}]}E)E)Ɖم}Mʍ    ))ʉэ)yA)UU)}܋E܍U܍U4Q]}+}<})y	UL
MQmEE}+]])y
EUDEE))M}} V>QщM})]܋E܍E9u)ٍ9}m  EPUPE    u>Qщ)ލ4u9u)ٍ9uE   UUU҉с   9E}YO9E|y)UExUBP   e[^_ÐUhyjuUujuÐU\  WVSǅd   E `UR\MIXE@TURMIPE@ L*+ލv)ÉHH+HDP@HHۉ81ցl     uaQ)9u)ډ9u   }    ǋ8yTD<`4}
ǅ`    `;~
ǅ`;   EF   E    E    E    E    @0Á  ,,uÁ  Q+)+)#@((F((<IX$$)$$\)`phUhhlxxUԉvx;luB;ht:L   u  L 1z  dS	  hlhxPRMщ  x  1}u   t& F9   }%)ڋ#)PQU҉t}   󥋵
t& RF9R u,t(0u   Eԉ u
   B0  , u  R  u  Q+)+Q+)+))+)Ӌ@)ɋȉڋ<@)RX@)щ  ) \R) )`)6  ]9L  L     ǅVax Ux$i}
ǅǅ   tx+tQPU҉  t  1}
u   F9    }$)")񋕼
RPMщt|    QF9Q u)t%0|   EL9U
  0  t, u  E  u  Q+)+Q+)+))+)Ӌ@+Љ؋U)<<@XU)ȉ)\M))`M)xQPU҉,  x  1}
u   F9   }%)؋#)񋕸
 QREЉt|   󥋵SF9S uMtI0|   Eԉ"v ux+pMUԉ94tC4+`1` u	<xQPU҉Åt|ۅDڅPeڅTڅXڅ\څ4EuEt&    Eu&    }   󥋅x[^_ÉUS]hdhl!S]ÐST$L$\$h   ̀[= ÐU0WVEU}MMEUu?9vE   } u
   1ǋEUEUE   v U9UvE       uu#M9Mw9}rލ    E   l&    EE    )uM}mU	ЉEEMUEmM	ЋUEueE9wu;uvM1ɋuuEMU^_]ÐU0WVUMEEEUUMEU܅uN9Uvu%} u
   1uEE܋UuEUuU}   uM11y  E9Evuǉu}   UUuDM9MwE9Ert& M܋U+UMM܉U}    u}܋E       UEE    )UeMыUeMM	EEe܋MM	E܋EuUeeE;Uw
uE9EvM+MUM؃} t+M܋E+EщM܉ʋMM}ƋE	0xEU^_]ÐUS "= "tЃ;u[]ÉU]ÐUS    [S 7O]                       w Out of memory
 %s
    r /etc/mtab Unmounting device %s umount                         Failed to unmount device %s mounted on %s statfs /etc/fstab iso9660 auto mount Mounted device %s supermount fs= dev= /dev SETUP_CDROM SETUP_CDROM_ %s/%s        
Please insert the %s CDROM.
Choose Yes to retry, No to cancel  
Please mount the %s CDROM.
Choose Yes to retry, No to cancel LC_ALL LC_MESSAGES LANG Detected locale is %s C POSIX none any up %d.%d-%19s major exact Invalid matching policy: %s              Registered plugins :

          	Description: %s
	Version: %s
	Author: %s
                      	Plugin is statically linked.
 	Recognizes %d extensions:  %s  

                               :// ftp file                    Out of memory, no network check Unable to create pipe, no network check Fork failed, no network check n y                       product  desc component uninstall splash splash.xpm version binarypath cdrom required meta yes once superuser express nobinaries promptbinaries install true path %s/%s                         No destination directory selected                               Please select at least one option                               Not enough free space for the selected options                  Install path is not a directory No write permissions on the install directory                   Binary path and install path must be different                  No write permissions to install a selected package              No write permissions on the binary directory cdromfile /usr/local/games eula                    The 'eula' attribute is deprecated, please use the 'eula' element from now on. lang             Duplicate matching EULA entries in XML file! readme README      The 'readme' attribute is deprecated, please use the 'readme' element from now on.              Duplicate matching README entries in XML file! remove_msg 
 name id website_text url reinstall localurl file:// / auto_url false update_url http://codehost.com/ preinstall preuninstall postinstall postuninstall desktop args Out of memory
                  Detected distribution: %s %d.%d /usr/local/bin                  Could not find default component. Make sure to define components for all entries. Out of memory gui                             You must use a 'symlink' attribute with 'play'                  There can be only one binary with a 'play' attribute no         The only valid values for the 'play' attribute are yes, gui and no                              Couldn't find your home directory                               Couldn't find home directory for %s option exclusive require arch libc distro command           XML: 'require' tag doesn't have a mandatory 'command' attribute XML: 'lang' tag does not have a mandatory 'lang' attribute      XML: option listed without translated description for locale '%s'                               XML: option listed without description help                     The 'help' attribute is deprecated, please use the 'help' element from now on. Default nouninstall Unable to remove '%s'        The '%s' RPM was installed or upgraded (version %s, release %d) SETUP_PRODUCTNAME="%s"
SETUP_PRODUCTVER="%s"
SETUP_COMPONENTNAME="%s"
SETUP_COMPONENTVER="%s"
SETUP_INSTALLPATH="%s"
SETUP_SYMLINKSPATH="%s"
SETUP_CDROMPATH="%s"
SETUP_DISTRO="%s"
export SETUP_PRODUCTNAME SETUP_PRODUCTVER SETUP_COMPONENTNAME SETUP_COMPONENTVER
export SETUP_INSTALLPATH SETUP_SYMLINKSPATH SETUP_CDROMPATH SETUP_DISTRO
 Could not register binary: %s /tmp/setupXXXXXX   Could not create temporary script w pre()
{
 %s
 }
pre 0
 %s-preun                              Could not write temporary pre-uninstall script in %s post()
{
 }
post 0
 %s-postun              Could not write post-uninstall script in %s                     update-menus 2> /dev/null
kbuildsycoca 2>/dev/null update-menus preun postun                    setup.data/bin/%s/%s/uninstall setup.data/locale Could not create install log Please visit %s   Missing 'command' attribute for an option %s %s & /usr/lib/menu/ ~/.menu/ /etc/X11/applnk/ KDE2DIR %s/share/applnk/ /opt/kde2/share/applnk/ KDEDIR /opt/kde/share/applnk/ /usr/X11R6/share/applnk/ /usr/share/applnk/ ~/.kde2/share/applnk/ ~/.kde/share/applnk/ r                              gnome-config --prefix 2>/dev/null %s /share/gnome/apps/ /opt/gnome/share/gnome/apps/ /usr/share/gnome/apps/ /usr/local/share/gnome/apps/ ~/.gnome/apps/ %s %s /usr/bin/update-menus %s%s Games  ?package(local.%s):\
 needs="X11" \
 section="%s" \
 title="%s" \
 longtitle="%s" \
 command="%s" \
 icon="%s"
                 Unable to create desktop file '%s' %s%s/ .kdelnk .desktop # KDE Config File
 KDE                [%sDesktop Entry]
Name=%s
Comment=%s
Exec=%s
Icon=%s
Terminal=0
Type=Application
 kbuildsycoca %s/tmp_script_XXXXXX /tmp/tmp_script_XXXXXX                      #!/bin/sh
SETUP_PRODUCTNAME="%s"
SETUP_PRODUCTVER="%s"
SETUP_INSTALLPATH="%s"
SETUP_SYMLINKSPATH="%s"
SETUP_CDROMPATH="%s"
SETUP_DISTRO="%s"
export SETUP_PRODUCTNAME SETUP_PRODUCTVER SETUP_INSTALLPATH SETUP_SYMLINKSPATH SETUP_CDROMPATH SETUP_DISTRO
%s%s
 %d execv Command: %s
 fork       ERROR: Too many curdirs. FIX IT!
 chdir(push: %s): %s
 chdir(pop)                               | %s/%s                         Unable to create %s symlink pointing to %s r w %s/* Unable to copy directory '%s' Unable to find file '%s'                      Unable to find file '%s' on any of the CDROM drives %s/%s.check-dynamic.sh %s.check-dynamic.sh sh %s >/dev/null 2>&1 %s/%s.dynamic %s.dynamic inrpm true arch any libc keepdirs binpath  binary bin/%s/%s/%s / %s/bin/%s/%s bin/%s/%s $INSTALLDIR   symlink play icon name menu desc Running script option path srcpath cdromid lang . distro files binary script install product -f execlp     'product' attributes can only be used in files with the 'meta' attribute. exclusive component   Component element needs to have a name version                  Component element needs to have a version default %s/bin/%s/%s/%s %s/%s/%s size                 Suspect size value for option %s
   @@@@8@@@&@0@@@@@@@@@@@@@@@@@@@@@@@@8@@@&@0readme eula BZOut of memory rb Failed to open file %s Couldn't read from file: %s Installing file %s wb Couldn't write to file: %s Read on write stream Skip zeroes on write stream Short write on %s Write on read stream                Creating symbolic link: %s --> %s
                              Can't remove existing symlink %s: %s Can't create %s: %s Creating directory: %s
 Creating FIFO: %s
 FIFO Creating device: %s
 Device                            Can't change permissions for %s: %s %s/%s Unable to read %s     PATH HOME . / ./ gnome-moz-remote                               gnome-moz-remote --newwin %s & netscape                         netscape -remote 'openURL(%s,new-window)' || netscape %s & konqueror konqueror %s & mozilla     mozilla -chrome %s || mozilla %s & opera opera -newwindow %s & NetPositive NetPositive %s & opera -page='%s' & links            xterm -T "Web Browser" -e links %s & lynx                       xterm -T "Web Browser" -e lynx %s & links %s lynx %s        qLL    LL    M%M    4M@M    cMiM    MM    cMM    MM    M N   M$N   M-NDISPLAY LOKI_BROWSER                Usage: %s [options]

Options can be one or more of the following:
   -b path  Set the binary path to <path>
   -h       Display this help message
   -i path  Set the install path to <path>
   -c cwd   Use an alternate current directory for the install
   -f file  Use an alternative XML file (default %s)
   -n       Force the text-only user interface
   -o opt   Enable the option named "opt" from the XML file. Also enables non
            interactive operation. Can be used multiple times.
   -p pref  Specify a path prefix in the installation media.
   -v n     Set verbosity level to n. Available values :
            0: Debug  1: Quiet  2: Normal 3: Warnings 4: Fatal
   -V       Print the version of the setup program and exit
 setup.data/setup.xml  setup.data/locale setup hnc:f:v:Vi:b:o:p:  Out of range value, setting verbosity level to normal.
         Loki Setup version 1.6.0, built on Sep 19 2002
 Couldn't load '%s'
 No UI drivers available
    You need to run this installer as the super-user.
              
This product is already installed.
Uninstall it before running this program again.
            
Illegal installation: do not mix components with a component installation.
                    
The %s component is already installed.
Please uninstall it beforehand.
                        
You must install %s before running this
installation program.
 The 'cdromfile' attribute is now mandatory when using the 'cdrom' attribute. Could not enable option: %s    !3"3"3"3"3"3"3"3"3"3"3"! 3"3" 3"3"!3"3"3"3" "!3"3"3"3"3"! )#0(E(`(u((((()    Y N %s   [%s]  Y/n N/y %s [Press Enter]                         Warning, invalid yesno prompt: %s
 Y/n/? N/y/? ? %s
 Continue? arch libc distro option exclusive required                       '%s' option will be installed.
 Install %s? install true No help available
 false               ----====== %s / %s installation program ======----
             ----====== %s installation program ======----
 
                You are running a %s machine with %s
                           Hit Control-C anytime to cancel this installation program.
 %s "%s"                             Do you agree with the license?  Would you like to read the %s file ? %d) %s
 %d                 Please choose the product to install, or Q to quit.             Please enter the installation path Install path set to: %s
 / No write permission to %s
        Do you want to install symbolic links to a directory in your path?                              Please enter the path in which to create the symbolic links Binary path set to: %s
             Binary path must be different than the install path.
The binary path must be an existing directory.
 component showname 
%s component

 name                    Do you want to install startup menu entries? Installing to %s
  %d MB available, %d MB will be installed.
 Continue install? Installing %s ...
  %3d%% - %s
  %s
             Y@                Install aborted - cleaning up files
 Installation complete.
 Would you like to start now?       If you run the program as root, the preferences will be stored in
root's home directory instead of your user account directory. Do you want to proceed with Express installation?               Installation could not proceed due to the following error:
%s
Try to use 'Expert' installation. Thank you for installing %s!
   Please visit our website for updates and support.
              Would you like to launch web browser?                           Standard input is not a terminal!
 PAGER more                   Request %s / %s Installation %s Installation                    You are running a %s machine with %s
Distribution: %s %d.%d License Agreement                   Do you agree with the license?  Would you like to read the %s file ? README install option  true on off exclusive component Component name Installation of %s   Please choose the options to install false                      Please pick a product to install Choose the product             Please enter the installation path Installation path / No write permission to %s
 Failed permissions                            Do you want to install symbolic links to a directory in your path?                              Please enter the path in which to create the symbolic links Symlink path                        Binary path must be different than the install path.
The binary path must be an existing directory.
 Error                      Do you want to install startup menu entries? Installing %s ... Installing...          Y@        Install aborted - cleaning up files
 Aborting                   Would you like to launch a Web browser?                         Installation complete!
Would you like to start now? Installation complete! Finished Recommended Express installation using detected defaults Expert             Full control over the installation parameters   a^!^a
b^$^ b                Please select the class of installation                         Installation could not proceed due to the following error:
%s
Try to use 'Expert' installation. 070701 070702                   %8lx%8lx%8lx%8lx%8lx%8lx%8lx%8lx%8lx%8lx%8lx%8lx%8lx 070707     %6lo%6lo%6lo%6lo%6lo%6lo%6lo%11lo%6lo%11lo Invalid CPIO header
 / TRAILER!!! wb Bad checksum for file '%s' rb .cpio.bz2 .cpio.Z .cpio.gz .cpio                  TAR: Size(%s) TAR: Copy %s -> %s rb %s/%s %o wb                 Tar: '%s' is unknown file type: %c .tar.bz2 .tar.Z .tar.gz .tar cp %s $SETUP_INSTALLPATH/%s || exit 1 ; cd $SETUP_INSTALLPATH/System ; export LD_LIBRARY_PATH=".;$LD_LIBRARY_PATH" ; ./ucc-bin decompress ../%s -nohomedir ; rm -f ./UT2003.ini ; rm -f ./User.ini ; rm -f ./ucc.ini ; rm -f ./server.ini ; rm -f ./StdOut.log ; rm -f ./ucc.log ; rm -f ../%s ; exit 0 failed to uncompress file. %s/%s rb %s/%s/%s wb         write error uncompressing file. .uz2                            [%c] (%c) %.*s                  Can't allocate memory in dialog_checklist(). on       ?              %.*s          ?Cannot get file position Cannot seek to end of file             Cannot set file position to %ld Can not allocate %ld bytes      can't have tab_correct and cr_wrap at the same time in textbox.c read_high Error reading file   Error reading file in tabize(). Internal error in back_lines(). (%3d%%)  Search  Can't open input file %s %d
                   /dev/tty r w [?      @rb      auto_sizefile: Cannot open input file %s Size: %d, %d
          Window too big. (Height, width) = (%d, %d). Max allowed (%d, %d).                               Window+Shadow too big. (Height, width) = (%d, %d). Max allowed (%d, %d).  %s                    Can't make new window at (%d,%d), size (%d,%d).
                Can't make sub-window at (%d,%d), size (%d,%d).
  %.*s \n XXX %3d%% (+)   %*s %-*s < > EXIT OK Cancel Yes No                    post-uninstall pre-uninstall .xml %s/%s &quot; &apos; &gt; &lt; &amp; SETUPDB_XML_BASE . %s/.loki/installed/%s/*.xml %s.xml name desc root prefix update_url %s/.manifest/%s.xml xmlversion %d.%d                               Warning: This XML file was generated with a later version of setupdb (%d.%d).
Problems may occur.
 component version default option file md5 directory symlink fifo device rpm script type patched mode %o %s/.loki /installed / %s/.manifest 1.0               Could not create symlink : %s
 %s/.manifest/scripts product %s/.manifest/scripts/%s.sh          Could not remove scripts directory                              Could not remove .manifest directory                            Could not remove install directory %s/.loki/installed/%s/%s.xml message yes %04o no             readlink: Could not find symbolic link %s
 dest block %d major minor char Couldn't read link: %s
   pEEEEEEE#P PPppprevision autoremove w #! /bin/sh
 %s r unlink       /bin/sh %s/.manifest/scripts/%s.sh /tmp/setupdb-bin.XXXXXX mkstemp open %s/.loki/installed/locale %s/.loki/installed/bin /uninstall %s --version %d.%d.%d popen rb wb Couldn't write to %s!
    Couldn't open %s to be copied!
 LANG %s/.loki/installed/locale/%s /LC_MESSAGES                  %s/%s/LC_MESSAGES/loki-uninstall.mo                             %s/%.2s/LC_MESSAGES/loki-uninstall.mo                           %s/.loki/installed/locale/%s/LC_MESSAGES/loki-uninstall.mo %s/uninstall                         #! /bin/sh
#### UNINSTALL SCRIPT - Generated by SetupDB %d.%d #####
DetectARCH()
{
        status=1
        case `uname -m` in
                i?86)  echo "x86"
                        status=0;;
                *)     echo "`uname -m`"
                        status=0;;
        esac
        return $status
}

if which loki-uninstall > /dev/null 2>&1; then
    UNINSTALL=loki-uninstall
else
    UNINSTALL="$HOME/.loki/installed/bin/`uname -s`/`DetectARCH`/uninstall"
    if [ ! -x "$UNINSTALL" ]; then
        echo Could not find a usable uninstall program. Aborting.
        exit 1
    fi
fi
"$UNINSTALL" "%s" "$1"                        Could not write uninstall script: %s
 0123456789abcdef xx rb    SETUP_ARCH x86 /lib/libc.so.6.1 /lib/libc.so.6 SETUP_LIBC       fgrep GLIBC_2.1 %s 2>&1 >/dev/null glibc-2.1 glibc-2.0 libc5 HOME  r %d.%d Sun Solaris Linux/PPC Caldera OpenLinux Slackware Debian GNU/Linux (or similar) SuSE Linux Mandrake Linux RedHat Linux (or similar) N/A solaris linuxppc caldera slackware debian suse mandrake redhat none /etc/mandrake-release /etc/SuSE-release /etc/redhat-release /etc/debian_version /etc/slackware-version OpenLinux /etc/issue              1.8.9 xml-stylesheet            Fatal: program compiled against libxml %d using libxml %d
      Warning: program compiled against libxml %d using older %d
 realloc failed !
                   malloc: couldn't allocate a new input stream
                   internal: xmlNewEntityInputStream entity = NULL
                xmlNewEntityInputStream unparsed entity !
                      Internal entity %s without content !
                           Internal parameter entity %s without content !
                 Predefined entity %s without content !
 CBB3CB`Cinternal: xmlNewStringInputStream string = NULL
 %s/%s          xmlInitParserCtxt: out of memory
                               xmlNewParserCtxt : cannot allocate context
 malloc              xmlParseCharRef: invalid hexadecimal value
                     xmlParseCharRef: invalid decimal value
                         xmlParseCharRef: invalid value
 CharRef: invalid xmlChar value %d
 CharRef at EOF
 CharRef in prolog!
 CharRef in epilog!
      CharRef are forbiden in DTDs!
 Reference at EOF
 Reference in prolog!
 Reference in epilog!
    Entity references are forbiden in DTDs!
 Entity reference: no name
                             Entity reference: ';' expected
 Entity reference: entity %s not declared
                       Entity reference to unparsed entity %s
 #PPPPPSPPPSSPSSSSPPQ#Q#QS`Q#QSSSSSSSSAQPEReference at EOF
 PEReference in prolog!
 PEReference in epilog!
                             xmlHandlePEReference: no name
 PEReference: %%%s; not found
    xmlHandlePEReference: %s is not a parameter entity
             xmlHandlePEReference: expecting ';'
    7T`T`TWT`TWWWWWWWWT                            xmlDecodeEntities: malloc failed realloc failed encoding unknown
                               char encoding UTF16 little endian not supported
                char encoding UTF16 big endian not supported
                   char encoding USC4 little endian not supported
                 char encoding USC4 big endian not supported
                    char encoding EBCDIC not supported
                             char encoding UCS4 2143 not supported
                          char encoding UCS4 3412 not supported
                          char encoding UCS2 not supported
                               char encoding ISO_8859_1 ISO Latin 1 not supported
             char encoding ISO_8859_2 ISO Latin 2 not supported
             char encoding ISO_8859_3 not supported
                         char encoding ISO_8859_4 not supported
                         char encoding ISO_8859_5 not supported
                         char encoding ISO_8859_6 not supported
                         char encoding ISO_8859_7 not supported
                         char encoding ISO_8859_8 not supported
                         char encoding ISO_8859_9 not supported
                         char encoding ISO-2022-JPnot supported
                         char encoding Shift_JISnot supported
                           char encoding EUC-JPnot supported
  ]XaXa]^@^p^^^ _0_`____ `P`````a6amalloc of %ld byte failed
      xmlStrncat: realloc of %ld byte failed
                         xmlHandleEntity %s: content == NULL
                            xmlNamespaceParseNCName: reached XML_MAX_NAMELEN limit
 malloc of %d byte failed
 realloc of %d byte failed
 String not closed "%.50s"
                         xmlParseNamespace found garbage
                                xmlScanName: reached XML_MAX_NAMELEN limit
                     xmlParseName: reached XML_MAX_NAMELEN limit
                    xmlParseNmtoken: reached XML_MAX_NAMELEN limit
 EntityValue: " or ' expected
 EntityValue: " expected
 AttValue: " or ' expected
                               xmlParseAttValue: malloc failed Unescaped '<' not allowed in attributes values
 AttValue: ' expected
                           SystemLiteral " or ' expected
 Unfinished SystemLiteral
 Unfinished PubidLiteral
               Sequence ']]>' not allowed in content
                          Space required after 'SYSTEM'
  xmlParseExternalID: SYSTEM, no URI
                             Space required after 'PUBLIC'
  xmlParseExternalID: PUBLIC, no Public Identifier
               Space required after the Public Identifier
                     xmlParseExternalID: PUBLIC, no URI
                             Comment must not contain '--' (double-hyphen)`
                 Comment not terminated 
<!--%.50s
                              xmlParsePItarget: invalid name prefix 'xml'
                    xmlParsePI: PI %s space expected
                               xmlParsePI: PI %s never end ...
 xmlParsePI : no target name
   Space required after '<!NOTATION'
 NOTATION: Name expected here
                                Space required after the NOTATION name'
                        '>' required to close NOTATION declaration
                     Space required after '<!ENTITY'
 Space required after '%'
 xmlParseEntityDecl: no name
         Space required after the entity name
                           Space required before 'NDATA'
 Space required after 'NDATA'
    xmlParseEntityDecl: entity %s not terminated
                   Space required after '#FIXED'
  Attribute default value declaration error
                      '(' required to start 'NOTATION'
                               Name expected in NOTATION declaration
                          ')' required to finish NOTATION declaration
                    '(' required to start ATTLIST enumeration
                      NmToken expected in ATTLIST enumeration
                        ')' required to finish ATTLIST enumeration
                     Space required after 'NOTATION'
                                Space required after '<!ATTLIST'
 ATTLIST: no name for Element
 ATTLIST: no name for Attribute
 Space required after the attribute name
                        Space required after the attribute type
                        Space required after the attribute default value
               xmlParseAttributeListDecl: detected internal error
             xmlParseElementMixedContentDecl : Name expected
                xmlParseElementMixedContentDecl : '|' or ')*' expected
         xmlParseElementMixedContentDecl : '#PCDATA' expected
           xmlParseElementChildrenContentDecl : Name or '(' expected
      xmlParseElementChildrenContentDecl : '%c' expected
             xmlParseElementChildrenContentDecl : ',' '|' or ')' expected
   xmlParseElementContentDecl : '(' expected
                      Space required after 'ELEMENT'
 xmlParseElementDecl: no name for Element
                       Space required after the element name
                          PEReference: forbidden within markup decl in internal subset
   xmlParseElementDecl: 'EMPTY', 'ANY' or '(' expected
            xmlParseElementDecl: expected '>' at the end
 Space needed after '<?xml'
 1.0 Space needed here
                                XML declaration must end-up with '?>'
                          parsing XML declaration: '?>' expected
                         XML conditional section not supported
                          XML conditional section not closed
                             Content error in the external subset
                           Extra content at the end of the document
 xmlParseEntityRef: no name
 Entity '%s' not defined
  Attribute references external entity '%s'
 lt                   '<' in entity '%s' is not allowed in attributes values
         Attempt to reference the parameter entity '%s'
                 xmlParseEntityRef: expecting ';'
 xmlParsePEReference: no name
 Internal: %%%s; is not a parameter entity
                      xmlParsePEReference: expecting ';'
                             xmlParseStringPEReference: no name
                             xmlParseStringPEReference: expecting ';'
                       xmlParseDocTypeDecl : no DOCTYPE name !
                        DOCTYPE unproperly terminated
  xmlParseInternalSubset: error detected in Markup declaration
 error parsing attribute name
     Specification mandate value for attribute %s
                   xmlParseStartTag: invalid element name
 Attribute %s redefined
 realloc of %ld byte failed
     xmlParseStartTag: problem parsing attributes
                   xmlParseEndTag: '</' not found
 End tag : expected '>'
         Opening and ending tag mismatch: %s and %s
 Ending tag eror for: %s
                            Ending tag error: internal error ???
 CData section not finished
                               CData section not finished
%.50s
                               detected an error in element content
                           Couldn't find end of Start Tag
%.30s
                           Premature end of data in tag %.30s
                             xmlParseVersionInfo : expected '='
 String not closed
%.50s
    xmlParseVersionInfo : expected ' or "
 Invalid XML encoding name
                               xmlParseEncodingDecl : expected '='
                            xmlParseEncodingDecl : expected ' or "
                         XML standalone declaration : expected '='
                      standalone accepts only 'yes' or 'no'
 String not closed
 Standalone value not found
 Blank needed after '<?xml'
 Blank needed here
                            Extra spaces at the beginning of the document are not allowed
 Document is empty
               Start tag expect, '<' not found
                                Couldn't find end of Start Tag %s
                              PP: internal error, state == COMMENT
                           PP: internal error, state == PI
                                PP: internal error, state == ENTITY_DECL
                       PP: internal error, state == ENTITY_VALUE
                      PP: internal error, state == ATTRIBUTE_VALUE
   FI  $Out of memory
      xmlNewNs : malloc failed
       xmlNewGlobalNs : malloc failed
 xmlNewDtd : malloc failed
 xmlNewDoc : malloc failed
 xmlNewProp : malloc failed
               xmlRemoveProp : cur->node == NULL
 xmlNewPI : malloc failed
 xmlNewNode : malloc failed
        xmlNewDocFragment : malloc failed
 xmlNewText : malloc failed
  xmlNewComment : malloc failed
  xmlNewCDataBlock : malloc failed
                               xmlStaticCopyNode : malloc failed
 xml:lang Q1Q1c1c1Q1Q1Q1c1c1c1c1c1c11111111111111html HTML head HEAD base BASE href HREF xml:base    E3S333333333E3333}4040404040404}4}43}4}44g5555555g5g545g55Z6@6@6@6@6@6@6Z6Z65@6Z6        xmlGetNsList : out of memory!
  xmlGetNsList : realloc failed!
 %.20s %.20s%d                   xmlReconciliateNs : memory pbm
                                 xmlBufferCreate : out of memory!
                               xmlBufferAdd : out of memory!
  xmlBufferCCat : out of memory!
 ' " <?namespace  href=  AS= ?>
  xmlns:  xmlns = <!DOCTYPE   PUBLIC     SYSTEM  >
  [
 ] : =""    
 <? ?> <!-- --> & ; <![CDATA[ ]]> < /> > </ <?xml version= "1.0"  encoding=  standalone="no"  standalone="yes" w%d - w       xmlAllocParserInputBuffer : out of memory!
 http:// ftp:// - r  xmlParserInputBufferGrow : out of memory !
                     xmlParserInputBufferGrow : buffer full !
                       xmlParserInputBufferGrow : no input !
 read error               failed to load external entity "%s"
                            no_proxy http_proxy HTTP_PROXY / HTTP/ Content-Type: ContentType: content-type: contenttype: Location: location: connect http   GET http://%s:%d%s HTTP/1.0
Host: %s

                       GET http://%s%s HTTP/1.0
Host: %s

 GET %s HTTP/1.0
Host: %s

 GET %s %s HTTP/1.0
Host: %s

                           %s %s HTTP/1.0
Host: %s
Content-Type: %s

                  %s %s HTTP/1.0
Host: %s
%s
  %s %s HTTP/1.0
Host: %s
Content-Type: %s
%s
                %s %s HTTP/1.0
Host: %s
Content-Length: %d

%s              %s %s HTTP/1.0
Host: %s
Content-Type: %s
Content-Length: %d

%s                            %s %s HTTP/1.0
Host: %s
Content-Length: %d
%s
%s            %s %s HTTP/1.0
Host: %s
Content-Type: %s
Content-Length: %d
%s
%s -> %s <- %s
 
Redirect to: %s
                           Too many redirrects, aborting ...
 
Code %d, content-type '%s'

 
Code %d, no content-type

 -  no_proxy ftp_proxy FTP_PROXY ftp_proxy_user ftp_proxy_password / USER anonymous
 USER %s
 PASS libxml@%s
 PASS %s
 QUIT
 SITE %s
 USER anonymous@%s
 USER %s@%s
                        FTP server asking for ACCNT on anonymous
   }}){zz}}}}}0}|}}}}}0} }}}CWD %s
                        xmlNanoFTPGetConnection: failed to create socket
 PASV
 %d,%d,%d,%d,%d,%d Invalid answer to PASV
                              Failed to create a data connection
 Failed to bind a port
 Could not listen on port %d
 PORT %d,%d,%d,%d,%d,%d
                xmlNanoFTPCloseConnection: timeout
 total LIST -L
 LIST -L %s
 TYPE I
 RETR %s
 ftp://      xmlNewElementContent : name == NULL !
                          xmlNewElementContent : name != NULL !
                          xmlNewElementContent: unknown type %d
                          xmlNewElementContent : out of memory!
                          xmlCopyElementContent : out of memory
 ( #PCDATA  ,   |         xmlDumpElementContent: unknown type %d
 ) ? * +                 xmlCreateElementTable : xmlMalloc(%ld) failed
                  xmlAddElementDecl: dtd == NULL
 xmlAddElementDecl: name == NULL
                                xmlAddElementDecl: content != NULL for EMPTY
                   xmlAddElementDecl: content != NULL for ANY
                     xmlAddElementDecl: content == NULL for MIXED
                   xmlAddElementDecl: content == NULL for ELEMENT
                 xmlAddElementDecl: unknown type %d
                             xmlAddElementDecl: Table creation failed!
 Redefinition of element %s
                          xmlAddElementDecl: out of memory
                               xmlCopyElementTable: out of memory !
 <!ELEMENT   EMPTY>
  ANY>
   >
                           xmlDumpElementTable: internal: unknown type %d
                 xmlCreateEnumeration : xmlMalloc(%ld) failed
                   xmlCreateAttributeTable : xmlMalloc(%ld) failed
                xmlScanAttributeDecl: dtd == NULL
                              xmlScanAttributeDecl: elem == NULL
                             Element %s has too may ID attributes defined : %s
              xmlAddAttributeDecl: dtd == NULL
                               xmlAddAttributeDecl: name == NULL
                              xmlAddAttributeDecl: elem == NULL
                              xmlAddAttributeDecl: unknown type %d
                           Attribute %s on %s: invalid default value
                      xmlAddAttributeDecl: Table creation failed!
                    Attribute %s on %s: already defined
                            xmlAddAttributeDecl: out of memory
                             xmlCopyAttributeTable: out of memory !
 <!ATTLIST   CDATA  ID  IDREF  IDREFS  ENTITY  ENTITIES  NMTOKEN  NMTOKENS  (  NOTATION (                                xmlDumpAttributeTable: internal: unknown type %d
  #REQUIRED  #IMPLIED  #FIXED                  xmlDumpAttributeTable: internal: unknown default %d
    Ǡ#3@xmlCreateNotationTable : xmlMalloc(%ld) failed
                 xmlAddNotationDecl: dtd == NULL
                                xmlAddNotationDecl: name == NULL
                               xmlAddNotationDecl: no PUBLIC ID nor SYSTEM ID
                 xmlAddNotationDecl: Table creation failed!
                     xmlAddNotationDecl: %s already defined
                         xmlAddNotationDecl: out of memory
                              xmlCopyNotationTable: out of memory !
 <!NOTATION   PUBLIC   SYSTEM   >
                        xmlCreateIDTable : xmlMalloc(%ld) failed
 xmlAddIDDecl: doc == NULL
 xmlAddIDDecl: value == NULL
 xmlAddIDDecl: attr == NULL
   xmlAddID: Table creation failed!
 ID %s already defined
 xmlAddID: out of memory
 id name xmlGetID: doc == NULL
 xmlGetID: ID == NULL
                          xmlCreateRefTable : xmlMalloc(%ld) failed
 xmlAddRefDecl: doc == NULL
 xmlAddRefDecl: value == NULL
 xmlAddRefDecl: attr == NULL
                               xmlAddRef: Table creation failed!
 xmlAddRef: out of memory
 xmlGetRef: doc == NULL
 xmlGetRef: Ref == NULL
 NOTATION %s is not declared
   մմ             Syntax of default value for attribute %s on %s is not valid
    ID attribute %s on %s is not valid must be #IMPLIED or #REQUIRED
                               Element %s has ID attribute defined in the external subset : %s
                                Definition of %s has duplicate references of %s
                No declaration for attribute %s on element %s
                  Syntax of value for attribute %s on %s is not valid
            Value "%s" for attribute %s on %s is not a declared Notation
   Value "%s" for attribute %s on %s is among the enumerated notations
                            Value "%s" for attribute %s on %s is not among the enumerated set
                              Value for attribute %s on %s must be "%s"
 CDATA ???    ȽȽȽ                    Attribute element not expected here
 Text element has childs !
 Text element has attributes !
 Text element has namespace !
    Text element carries namespace definitions !
                   Text element has no content !
  Entity element not expected here
                               Notation element not expected here
                             Document element not expected here
 
 unknown element type %d
  No declaration for element %s
  Element %s was declared EMPTY this one has content
 Internal: MIXED struct bad
                 Element %s is not declared in %s list of possible childs
       Element %s content doesn't follow the Dtd
Expecting %s, got %s
 Element %s doesn't carry attribute %s
                          Element %s doesn't carry attribute %s:%s
                       Element %s required attribute %s:%s has no prefix
              Element %s required attribute %s:%s has different prefix
   @e  0  WNot valid: no DtD found
 Not valid: no root element
 HTML html                  Not valid: root and DtD name do not match '%s' and '%s'
        xmlValidateDocumentFinal: doc == NULL
                          IDREF attribute %s reference an unknown ID '%s'
                Could not load the external subset '%s'
 <!dummy?>              Validation failed: no DTD found !
                              End tags for %s don't hold the namespace %s
                    End tags %s holds a prefix %s not used by the open tag
         Start and End tags for %s don't use the same namespaces: %s and %s
                             & amp " quot ' apos > gt < lt realloc failed                    xmlAddDtdEntity: document without external subset !
            xmlAddDocEntity: document is NULL !
                            xmlAddDtdEntity: document without internal subset !
            Deprecated API xmlEncodeEntities() used
                           change code to use xmlEncodeEntitiesReentrant()
 malloc failed &#%d;                         xmlCreateEntitiesTable : xmlMalloc(%ld) failed
                 xmlCopyEntitiesTable: out of memory !
 <!ENTITY    >
  PUBLIC   SYSTEM   NDATA  <!ENTITY %      xmlDumpEntitiesTable: internal: unknown type %d
    ap                         UTF-8 UTF8 UTF-16 UTF16 ISO-10646-UCS-2 UCS-2 UCS2 ISO-10646-UCS-4 UCS-4 UCS4 ISO-8859-1 ISO-LATIN-1 ISO LATIN 1 ISO-8859-2 ISO-LATIN-2 ISO LATIN 2 ISO-8859-3 ISO-8859-4 ISO-8859-5 ISO-8859-6 ISO-8859-7 ISO-8859-8 ISO-8859-9 ISO-2022-JP Shift_JIS EUC-JP  xmlNewCharEncodingHandler : no name !
                          xmlNewCharEncodingHandler : out of memory !
                    xmlInitCharEncodingHandlers : out of memory !
                  xmlRegisterCharEncodingHandler: NULL handler !
                 xmlRegisterCharEncodingHandler: Too many handler registered
 encoding.c                         	increase MAX_ENCODING_HANDLERS : %s
 %s:%d:  Entity: line %d:  %c 
   ^
 error:  warning:  validity error:  validity warning:  htmlDtdDump : no internal subset
 <!DOCTYPE   PUBLIC     SYSTEM  >
                             htmlAttrDump : property == NULL
 = =""                          htmlAttrListDump : property == NULL
                            htmlNodeListDump : node == NULL
 htmlNodeDump : node == NULL
 <!-- --> & ; < > 
 ></ </         <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd"> w                    realloc failed !
               instance of a variable or program argument var unordered list  ul underlined text style u       teletype or monospaced text style tt table row  tr document title  title table header  thead table header cell th table footer  tfoot multi-line text field  textarea table data cell td table body  tbody &#160; table superscript  sup subscript sub style info  style strong emphasis strong strike-through text strike      generic language/style container  span small text style small option selector  select script statements  script                 sample program output, scripts, etc. samp strike-through text style s short inline quotation  q preformatted text  pre named property value  param paragraph  p selectable choice  option option group  optgroup ordered list  ol generic embedded object  object                               alternate content container for non script-based rendering  noscript                            alternate content container for non frame-based rendering  noframes generic metainformation  meta menu list  menu client-side image map  map a media-independent link  link list item  li fieldset legend  legend form field label text  label                  text to be entered by the user kbd single line prompt  isindex inserted text ins form control  input embedded image  img inline subwindow  iframe italic text style i document root element  html horizontal rule  hr document head  head h6 h5 h4 h3 h2 heading  h1 window subdivision frameset subwindow  frame interactive form  form local change to font  font form control group  fieldset emphasis em definition term  dt definition list  dl            generic language/style container div directory list dir instance definition dfn deleted text  del definition description  dd table column group  colgroup table column  col computer code fragment code citation cite           shorthand for div align=center  center table caption  caption push button  button forced line break  br document body  body long quotation  blockquote large text style big i18n bidi over-ride  bdo base font size  basefont document base uri  base bold text style b client-side image map area  area java applet  applet information on author  address  acronym abbreviated form abbr anchor  a xmp listing                Opening and ending tag mismatch: %s and %s
 euro sign, U+20AC NEW euro                          single right-pointing angle quotation mark, U+203A ISO proposed rsaquo                          single left-pointing angle quotation mark, U+2039 ISO proposed lsaquo                           per mille sign, U+2030 ISOtech permil double dagger, U+2021 ISOpub Dagger dagger, U+2020 ISOpub dagger                          double low-9 quotation mark, U+201E NEW bdquo                   right double quotation mark, U+201D ISOnum rdquo                left double quotation mark, U+201C ISOnum ldquo                 single low-9 quotation mark, U+201A NEW sbquo                   right single quotation mark, U+2019 ISOnum rsquo                left single quotation mark, U+2018 ISOnum lsquo em dash, U+2014 ISOpub mdash en dash, U+2013 ISOpub ndash                       right-to-left mark, U+200F NEW RFC 2070 rlm                     left-to-right mark, U+200E NEW RFC 2070 lrm                     zero width joiner, U+200D NEW RFC 2070 zwj                      zero width non-joiner, U+200C NEW RFC 2070 zwnj thin space, U+2009 ISOpub thinsp em space, U+2003 ISOpub emsp en space, U+2002 ISOpub ensp small tilde, U+02DC ISOdia tilde                     modifier letter circumflex accent, U+02C6 ISOpub circ           latin capital letter Y with diaeresis, U+0178 ISOlat2 Yuml      latin small letter s with caron, U+0161 ISOlat2 scaron          latin capital letter S with caron, U+0160 ISOlat2 Scaron        latin small ligature oe, U+0153 ISOlat2 oelig                   latin capital ligature OE, U+0152 ISOlat2 OElig                 black diamond suit, U+2666 ISOpub diams                         black heart suit = valentine, U+2665 ISOpub hearts              black club suit = shamrock, U+2663 ISOpub clubs                 black spade suit, U+2660 ISOpub spades lozenge, U+25CA ISOpub loz                               right-pointing angle bracket = ket, U+232A ISOtech rang         left-pointing angle bracket = bra, U+2329 ISOtech lang right floor, U+230B ISOamsc rfloor       left floor = apl downstile, U+230A ISOamsc lfloor right ceiling, U+2309 ISOamsc rceil           left ceiling = apl upstile, U+2308 ISOamsc lceil dot operator, U+22C5 ISOamsb sdot              up tack = orthogonal to = perpendicular, U+22A5 ISOtech perp    circled times = vector product, U+2297 ISOamsb otimes           circled plus = direct sum, U+2295 ISOamsb oplus                 superset of or equal to, U+2287 ISOtech supe                    subset of or equal to, U+2286 ISOtech sube                      not a subset of, U+2284 ISOamsn nsub superset of, U+2283 ISOtech subset of, U+2282 ISOtech      greater-than or equal to, U+2265 ISOtech ge                     less-than or equal to, U+2264 ISOtech le identical to, U+2261 ISOtech equiv not equal to, U+2260 ISOtech ne                     almost equal to = asymptotic to, U+2248 ISOamsr asymp           approximately equal to, U+2245 ISOtech cong                     tilde operator = varies with = similar to, U+223C ISOtech sim therefore, U+2234 ISOtech there4 integral, U+222B ISOtech int union = cup, U+222A ISOtech cup     intersection = cap, U+2229 ISOtech cap                          logical or = vee, U+2228 ISOtech or                             logical and = wedge, U+2227 ISOtech and angle, U+2220 ISOamso ang infinity, U+221E ISOtech infin                                proportional to, U+221D ISOtech prop                            square root = radical sign, U+221A ISOtech radic                asterisk operator, U+2217 ISOtech lowast minus sign, U+2212 ISOtech minus                       n-ary sumation, U+2211 ISOamsb sum                              n-ary product = product sign, U+220F ISOamsb prod               contains as member, U+220B ISOtech ni                           not an element of, U+2209 ISOtech notin element of, U+2208 ISOtech isin                         nabla = backward difference, U+2207 ISOtech nabla               empty set = null set = diameter, U+2205 ISOamso empty there exists, U+2203 ISOtech exist        partial differential, U+2202 ISOtech part for all, U+2200 ISOtech forall                        left right double arrow, U+21D4 ISOamsa hArr                    downwards double arrow, U+21D3 ISOamsa dArr                     rightwards double arrow, U+21D2 ISOtech rArr                    upwards double arrow, U+21D1 ISOamsa uArr                       leftwards double arrow, U+21D0 ISOtech lArr                     downwards arrow with corner leftwards = carriage return, U+21B5 NEW crarr                       left right arrow, U+2194 ISOamsa harr                           downwards arrow, U+2193 ISOnum darr                             rightwards arrow, U+2192 ISOnum rarr upwards arrow, U+2191 ISOnum uarr                          leftwards arrow, U+2190 ISOnum larr                             alef symbol = first transfinite cardinal, U+2135 NEW alefsym    trade mark sign, U+2122 ISOnum trade                            blackletter capital R = real part symbol, U+211C ISOamso real   blackletter capital I = imaginary part, U+2111 ISOamso image    script capital P = power set = Weierstrass p, U+2118 ISOamso weierp fraction slash, U+2044 NEW frasl                            overline = spacing overscore, U+203E NEW oline                  double prime = seconds = inches, U+2033 ISOtech Prime           prime = minutes = feet, U+2032 ISOtech prime                    horizontal ellipsis = three dot leader, U+2026 ISOpub hellip    bullet = black small circle, U+2022 ISOpub bull                 greek pi symbol, U+03D6 ISOgrk3 piv                             greek upsilon with hook symbol, U+03D2 NEW upsih                greek small letter theta symbol, U+03D1 NEW thetasym            greek small letter omega, U+03C9 ISOgrk3 omega                  greek small letter psi, U+03C8 ISOgrk3 psi                      greek small letter chi, U+03C7 ISOgrk3 chi                      greek small letter phi, U+03C6 ISOgrk3 phi                      greek small letter upsilon, U+03C5 ISOgrk3 upsilon              greek small letter tau, U+03C4 ISOgrk3 tau                      greek small letter sigma, U+03C3 ISOgrk3 sigma                  greek small letter final sigma, U+03C2 ISOgrk3 sigmaf           greek small letter rho, U+03C1 ISOgrk3 rho                      greek small letter pi, U+03C0 ISOgrk3 pi                        greek small letter omicron, U+03BF NEW omicron                  greek small letter xi, U+03BE ISOgrk3 xi                        greek small letter nu, U+03BD ISOgrk3 nu                        greek small letter mu, U+03BC ISOgrk3 mu                        greek small letter lambda, U+03BB ISOgrk3 lambda                greek small letter kappa, U+03BA ISOgrk3 kappa                  greek small letter iota, U+03B9 ISOgrk3 iota                    greek small letter theta, U+03B8 ISOgrk3 theta                  greek small letter eta, U+03B7 ISOgrk3 eta                      greek small letter zeta, U+03B6 ISOgrk3 zeta                    greek small letter epsilon, U+03B5 ISOgrk3 epsilon              greek small letter delta, U+03B4 ISOgrk3 delta                  greek small letter gamma, U+03B3 ISOgrk3 gamma                  greek small letter beta, U+03B2 ISOgrk3 beta                    greek small letter alpha, U+03B1 ISOgrk3 alpha                  greek capital letter omega, U+03A9 ISOgrk3 Omega                greek capital letter psi, U+03A8 ISOgrk3 Psi                    greek capital letter chi, U+03A7 Chi                            greek capital letter phi, U+03A6 ISOgrk3 Phi                    greek capital letter upsilon, U+03A5 ISOgrk3 Upsilon            greek capital letter tau, U+03A4 Tau                            greek capital letter sigma, U+03A3 ISOgrk3 Sigma                greek capital letter rho, U+03A1 Rho                            greek capital letter pi, U+03A0 ISOgrk3 Pi                      greek capital letter omicron, U+039F Omicron                    greek capital letter xi, U+039E ISOgrk3 Xi                      greek capital letter nu, U+039D Nu                              greek capital letter mu, U+039C Mu                              Lambdagreek capital letter lambda, U+039B ISOgrk3               greek capital letter kappa, U+039A Kappa                        greek capital letter iota, U+0399 Iota                          greek capital letter theta, U+0398 ISOgrk3 Theta                greek capital letter eta, U+0397 Eta                            greek capital letter zeta, U+0396 Zeta                          greek capital letter epsilon, U+0395 Epsilon                    greek capital letter delta, U+0394 ISOgrk3 Delta                greek capital letter gamma, U+0393 ISOgrk3 Gamma                greek capital letter beta, U+0392 Beta                          greek capital letter alpha, U+0391 Alpha                        latin small f with hook = function = florin, U+0192 ISOtech fnof                                latin small letter y with diaeresis, U+00FF ISOlat1 yuml        latin small letter thorn with, U+00FE ISOlat1 thorn             latin small letter y with acute, U+00FD ISOlat1 yacute          latin small letter u with diaeresis, U+00FC ISOlat1 uuml        latin small letter u with circumflex, U+00FB ISOlat1 ucirc      latin small letter u with acute, U+00FA ISOlat1 uacute          latin small letter u with grave, U+00F9 ISOlat1 ugrave          latin small letter o with stroke, = latin small letter o slash, U+00F8 ISOlat1 oslash division sign, U+00F7 ISOnum divide       latin small letter o with diaeresis, U+00F6 ISOlat1 ouml        latin small letter o with tilde, U+00F5 ISOlat1 otilde          latin small letter o with circumflex, U+00F4 ISOlat1 ocirc      latin small letter o with acute, U+00F3 ISOlat1 oacute          latin small letter o with grave, U+00F2 ISOlat1 ograve          latin small letter n with tilde, U+00F1 ISOlat1 ntilde          latin small letter eth, U+00F0 ISOlat1 eth                      latin small letter i with diaeresis, U+00EF ISOlat1 iuml        latin small letter i with circumflex, U+00EE ISOlat1 icirc      latin small letter i with acute, U+00ED ISOlat1 iacute          latin small letter i with grave, U+00EC ISOlat1 igrave          latin small letter e with diaeresis, U+00EB ISOlat1 euml        latin small letter e with circumflex, U+00EA ISOlat1 ecirc      latin small letter e with acute, U+00E9 ISOlat1 eacute          latin small letter e with grave, U+00E8 ISOlat1 egrave          latin small letter c with cedilla, U+00E7 ISOlat1 ccedil        latin small letter ae = latin small ligature ae, U+00E6 ISOlat1 aelig                           latin small letter a with ring above = latin small letter a ring, U+00E5 ISOlat1 aring          latin small letter a with diaeresis, U+00E4 ISOlat1 auml        latin small letter a with tilde, U+00E3 ISOlat1 atilde          latin small letter a with circumflex, U+00E2 ISOlat1 acirc      latin small letter a with acute, U+00E1 ISOlat1 aacute          latin small letter a with grave = latin small letter a grave, U+00E0 ISOlat1 agrave             latin small letter sharp s = ess-zed, U+00DF ISOlat1 szlig      latin capital letter THORN, U+00DE ISOlat1 THORN                latin capital letter Y with acute, U+00DD ISOlat1 Yacute        latin capital letter U with diaeresis, U+00DC ISOlat1 Uuml      latin capital letter U with circumflex, U+00DB ISOlat1 Ucirc    latin capital letter U with acute, U+00DA ISOlat1 Uacute        latin capital letter U with grave, U+00D9 ISOlat1 Ugrave        latin capital letter O with stroke latin capital letter O slash, U+00D8 ISOlat1 Oslash          multiplication sign, U+00D7 ISOnum times                        latin capital letter O with diaeresis, U+00D6 ISOlat1 Ouml      latin capital letter O with tilde, U+00D5 ISOlat1 Otilde        latin capital letter O with circumflex, U+00D4 ISOlat1 Ocirc    latin capital letter O with acute, U+00D3 ISOlat1 Oacute        latin capital letter O with grave, U+00D2 ISOlat1 Ograve        latin capital letter N with tilde, U+00D1 ISOlat1 Ntilde        latin capital letter ETH, U+00D0 ISOlat1 ETH                    latin capital letter I with diaeresis, U+00CF ISOlat1 Iuml      latin capital letter I with circumflex, U+00CE ISOlat1 Icirc    latin capital letter I with acute, U+00CD ISOlat1 Iacute        latin capital letter I with grave, U+00CC ISOlat1 Igrave        latin capital letter E with diaeresis, U+00CB ISOlat1 Euml      latin capital letter E with circumflex, U+00CA ISOlat1 Ecirc    latin capital letter E with acute, U+00C9 ISOlat1 Eacute        latin capital letter E with grave, U+00C8 ISOlat1 Egrave        latin capital letter C with cedilla, U+00C7 ISOlat1 Ccedil      latin capital letter AE = latin capital ligature AE, U+00C6 ISOlat1 AElig                       latin capital letter A with ring above = latin capital letter A ring, U+00C5 ISOlat1 Aring      latin capital letter A with diaeresis, U+00C4 ISOlat1 Auml      latin capital letter A with tilde, U+00C3 ISOlat1 Atilde        latin capital letter A with circumflex, U+00C2 ISOlat1 Acirc    latin capital letter A with acute, U+00C1 ISOlat1 Aacute        latin capital letter A with grave = latin capital letter A grave, U+00C0 ISOlat1 Agrave         inverted question mark = turned question mark, U+00BF ISOnum iquest                             vulgar fraction three quarters = fraction three quarters, U+00BE ISOnum frac34                  vulgar fraction one half = fraction one half, U+00BD ISOnum frac12                              vulgar fraction one quarter = fraction one quarter, U+00BC ISOnum frac14                        right-pointing double angle quotation mark right pointing guillemet, U+00BB ISOnum raquo        masculine ordinal indicator, U+00BA ISOnum ordm                 superscript one = superscript digit one, U+00B9 ISOnum sup1     cedilla = spacing cedilla, U+00B8 ISOdia cedil                  middle dot = Georgian comma Greek middle dot, U+00B7 ISOnum middot                              pilcrow sign = paragraph sign, U+00B6 ISOnum para micro sign, U+00B5 ISOnum micro               acute accent = spacing acute, U+00B4 ISOdia acute               superscript three = superscript digit three = cubed, U+00B3 ISOnum sup3                         superscript two = superscript digit two = squared, U+00B2 ISOnum sup2                           plus-minus sign = plus-or-minus sign, U+00B1 ISOnum plusmn degree sign, U+00B0 ISOnum deg       macron = spacing macron = overline = APL overbar, U+00AF ISOdia macr                            registered sign = registered trade mark sign, U+00AE ISOnum reg soft hyphen = discretionary hyphen, U+00AD ISOnum shy not sign, U+00AC ISOnum not               left-pointing double angle quotation mark = left pointing guillemet, U+00AB ISOnum laquo        feminine ordinal indicator, U+00AA ISOnum ordf copyright sign, U+00A9 ISOnum copy               diaeresis = spacing diaeresis, U+00A8 ISOdia uml section sign, U+00A7 ISOnum sect               broken bar = broken vertical bar, U+00A6 ISOnum brvbar          yen sign = yuan sign, U+00A5 ISOnum yen currency sign, U+00A4 ISOnum curren pound sign, U+00A3 ISOnum pound cent sign, U+00A2 ISOnum cent                       inverted exclamation mark, U+00A1 ISOnum iexcl                  no-break space = non-breaking space, U+00A0 ISOnum nbsp single quote apos                       greater-than sign, U+003E ISOnum gt less-than sign, U+003C ISOnum lt ampersand, U+0026 ISOnum amp                               quotation mark = APL quote, U+0022 ISOnum quot                  htmlDecodeEntities: malloc failed realloc failed encoding unknown
                              char encoding UTF16 little endian not supported
                char encoding UTF16 big endian not supported
                   char encoding USC4 little endian not supported
                 char encoding USC4 big endian not supported
                    char encoding EBCDIC not supported
                             char encoding UCS4 2143 not supported
                          char encoding UCS4 3412 not supported
                          char encoding UCS2 not supported
                               char encoding ISO_8859_1 ISO Latin 1 not supported
             char encoding ISO_8859_2 ISO Latin 2 not supported
             char encoding ISO_8859_3 not supported
                         char encoding ISO_8859_4 not supported
                         char encoding ISO_8859_5 not supported
                         char encoding ISO_8859_6 not supported
                         char encoding ISO_8859_7 not supported
                         char encoding ISO_8859_8 not supported
                         char encoding ISO_8859_9 not supported
                         char encoding ISO-2022-JPnot supported
                         char encoding Shift_JISnot supported
                           char encoding EUC-JPnot supported
  						2	T	v					&	H	p							2		P		g				malloc: couldn't allocate a new input stream
                   htmlHandleEntity %s: content == NULL
 xmlNewDoc : malloc failed
                                http://www.w3.org/TR/REC-html40/loose.dtd                       -//W3C//DTD HTML 4.0 Transitional//EN HTML                      htmlParseName: reached HTML_MAX_NAMELEN limit
                  htmlParseHTMLAttribute: malloc failed                           htmlParseNmtoken: reached HTML_MAX_NAMELEN limit
 htmlParseEntityRef: no name
                  htmlParseEntityRef: expecting ';'
 AttValue: ' expected
 AttValue: no value found
 Unfinished SystemLiteral
                    SystemLiteral " or ' expected
 Unfinished PubidLiteral
 malloc of %d byte failed
               Sequence ']]>' not allowed in content
 realloc of %d byte failed
                               Space required after 'SYSTEM'
  htmlParseExternalID: SYSTEM, no URI
                            Space required after 'PUBLIC'
  htmlParseExternalID: PUBLIC, no Public Identifier
              Comment not terminated 
<!--%.50s
                              htmlParseCharRef: invalid hexadecimal value
                    htmlParseCharRef: invalid decimal value
                        htmlParseCharRef: invalid value
                                htmlParseCharRef: invalid xmlChar value %d
                     htmlParseDocTypeDecl : no DOCTYPE name !
                       DOCTYPE unproperly terminated
 error parsing attribute name
 No value for attribute %s
         htmlParseStartTag: invalid element name
 Attribute %s redefined
 malloc of %ld byte failed
 realloc of %ld byte failed
         htmlParseStartTag: problem parsing attributes
                  htmlParseEndTag: '</' not found
 End tag : expected '>'
 Unexpected end tag : %s
 &             detected an error in element content
 Tag %s invalid
           Couldn't find end of Start Tag
%.30s
                           Premature end of data in tag %s
 Document is empty
             htmlInitParserCtxt: out of memory
 malloc                       Extra content at the end of the document
                       Couldn't find end of Start Tag %s
                              HPP: internal error, state == CDATA
                            HPP: internal error, state == DTD
                              HPP: internal error, state == COMMENT
                          HPP: internal error, state == PI
                               HPP: internal error, state == ENTITY_DECL
                      HPP: internal error, state == ENTITY_VALUE
                     HPP: internal error, state == ATTRIBUTE_VALUE
  uP	E	
G	O	O	H	O	@K	M	O	&O	 P	 P	@P	(J	1.0.8 %c%c%c%c%c%c%c%c%c%c <fd:%d>  :                       hr	    s	    s	      s	    @v	      @v	    @v	     @v	    @v	   @v	1.0.8                                                                                                                                                                                                           	   	   
   
               
   
                                                                                     	

     L    ,    l        \    <    |        B    "    b        R    2    r    
    J    *    j        Z    :    z        F    &    f        V    6    v        N    .    n        ^    >    ~        A    !    a        Q    1    q    	    I    )    i        Y    9    y        E    %    e        U    5    u    
    M    -    m        ]    =    }     	 	  	 	 S 	 S	  	 	 3 	 3	  	 	 s 	 s	  	 	  	 	  	 	 K 	 K	  	 	 + 	 +	  	 	 k 	 k	  	 	  	 	  	 	 [ 	 [	  	 	 ; 	 ;	  	 	 { 	 {	  	 	  	 	  	 	 G 	 G	  	 	 ' 	 '	  	 	 g 	 g	  	 	  	 	  	 	 W 	 W	  	 	 7 	 7	  	 	 w 	 w	  	 	  	 	  	 	 O 	 O	  	 	 / 	 /	  	 	 o 	 o	  	 	  	 	  	 	 _ 	 _	  	 	 ? 	 ?	  	 	  	 	  	 	    @     `    P  0  p    H  (  h    X  8  x    D  $  d    T  4  t      C    #    c                         
                	        
                         								















































   		





                            
                         (   0   8   @   P   `   p                                                                  0   @   `                                           0   @   `  incompatible version buffer error insufficient memory data error stream error file error  stream end need dictionary 1.0.8  unknown compression method invalid window size incorrect header check need dictionary incorrect data check  	&				T			S				N	U	                         	      
                  
               invalid block type invalid stored block lengths     too many length or distance symbols invalid bit length repeat   ̠	7			f		/	'		Ы	                         inflate 1.0.8 Copyright 1995-1998 Mark Adler                                     	   
      
                     #   +   3   ;   C   S   c   s                                                                                                                             p   p                         	   
         !   1   A   a                                0  @  `                                                                          	   	   
   
               
   
           oversubscribed dynamic bit lengths tree                         incomplete dynamic bit lengths tree                             oversubscribed literal/length tree                              incomplete literal/length tree oversubscribed distance tree incomplete distance tree            empty distance tree with lengths    invalid literal/length code invalid distance code   R	&	 		p	Ѽ			M		invalid distance code invalid literal/length code   q            0w,aQ	mjp5c飕d2yҗ+L	|~-d jHqA}mQǅӃVlkdzbeO\lcc=
 n;^iLA`rqg<GK
k
5lBɻ@l2u\E
Y=ѫ0&: QQaп!#ĳV(_$|o/LhXa=-fAvq Ҙ*q俟3Ըx4 	
j-=mld\cQkkbal0eN bl{WٰeP긾|bI-|ӌeLXaMQ:t 0AJו=mѤjiCn4Fgи`s-D3_L
|
<qPA' %hWo 	fa^)"а=Y
.;\l ұt9Gwҝ&sc;d>jm
Zjz	' 
}Dңhi]Wbgeq6lknv+ӉZzJgo߹ﾎCՎ`~ѡ8ROggW?K6H+
L
J6`zA`Ugn1yiFafo%6hRwG"/&U;(Z+j\1е,[d&c윣ju
m	?6grW Jz+{8Ғ
|!ӆBhn[&wowGZpj;f\eibkaElx

TN³9a&g`MGiIwn>JjѮZf@;7SŞϲG0򽽊º0S$6к)WTg#.zfJah]+o*7Z-                              x 2 d  2 d  2 d J2 d < 2 d ,2 d   2 d                                
      	   
         TERM unknown Error opening terminal: %s.
 ESCDELAY xterm rxvt kterm [?1000h [?1000l      A          $@NCURSES_NO_PADDING                                           @           @               2      K      n                        ,     X  	     
        `	       
   %      K                            \     ]     ^  7        b     a     _     `     c  8   V  9   M     d     e     f     g  :   U  ;   J  <   H  =     >   L     h     W  ?   O  @   N     i  A     B   	  C                                                  D   
                               !     "     #     $     %  E        &     '     (     )     *     +     ,     -     .     /  F        0     1     2     3     4     5     6     7     8     9  G   
     :     ;    <    =    >    ?    @    A    B    C  H     	  D  
  E    F    G  I     J     K        j     k  L     M   K  N   I  O     P   [     l     m  c       n     o  Q   R     p     q  R   S     r     Z     s     t     u     v     w     x  S        y     z     {     |     }     ~                                T   P                                                         U   Q                                V   T                 W                 LINES COLUMNS TERM              TERM environment variable not set.
                             TERM environment must be <= %d characters.
                     Not enough memory to create terminal structure.
                terminals database is inaccessible
 '%s': unknown terminal type.
 CC                            '%s': I need something more specific.
                          '%s': I can't handle hardcopy terminals.
   Out of memory %d    
5
5
5
5
5
5
5
5
5
5
4
4
4
4
4
4
4
4
4
4
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
5
4
4
5
5
5
5

5
5
5
5
5
5

5
5
4
֎












Ў















































































e
$
Б



B



 












%

e
















ԓ





























D





@
 







`

Е
/usr/share/terminfo TERMINFO %s/%s %c/%.*s TERMINFO_DIRS NCURSES_NO_SETBUF  bF_F\FYFVFSFPFMFJFGFDFAF>F;F8F5F2F/F,F)F&F#F FFFFFFFFFFFFEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE}E{EyEwEuEsEqEoEmEkEiEgEeEcEaE_E]E[EYEWEUESEQEOEMEKEIEGEDEBE@E>E<E:E8E6E4E2E0E.E,E*E(E&E$E"E EEEEEEEEEEE
EEEEE EDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD~D|DzDxDvDtDrDpDnDlDjDhDfDdDbD`D^D\DZDXDVDTDRDPDNDLDJDHDFDDD                                                                                                                                ^? ~ } | { z y x w v u t s r q p o n m l k j i h g f e d c b a ` _ ^ ] \ [ Z Y X W V U T S R Q P O N M L K J I H G F E D C B A @ ? > = < ; : 9 8 7 6 5 4 3 2 1 0 / . - , + * ) ( ' & % $ # " !   ^_ ^^ ^] ^\ ^[ ^Z ^Y ^X ^W ^V ^U ^T ^S ^R ^Q ^P ^O ^N ^M ^L ^K ^J ^I ^H ^G ^F ^E ^D ^C ^B ^A ^@ .  


 


 
0
"%s" , line %d , col %d , terminal '%s' 
 HOME Out of memory %s/.terminfo               						aHcpc`sbbmGbGZGOGCG7G0GLC_ALL LC_MESSAGES LC_MONETARY LC_COLLATE LC_TIME LC_NUMERIC LC_CTYPE      
      
            
    
,
        LOCPATH             /usr/share/locale:/usr/share/i18n LC_ALL LANG         6                                                                                                                                                                                                                                                                                                                                                                                               /SYS_                                                                                                                                                                                                                                                                                                                   `                                                                                                                                                                                                                                                                                                                                                                   `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                                                  	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                      s               I        PVL    \      `bCb`   4bANSI_X3.4-1968 tolower toupper              upper lower alpha digit xdigit space print graph blank cntrl punct alnum    s               bbbbno yes ^[nN] ^[yY]     s               @c@c@c@c@c@c@cbbbbbbbb       s               mclcDc .  s            6   meieeeae]eYeUeNeGe?e5e,e%eeeeeeee edddddddddeddddddddddvdmdad    `d`d`d`d`d        `d`d %I:%M:%S %p %H:%M:%S %m/%d/%y %a %b %e %H:%M:%S %Y PM AM December November October September August July June April March February January Dec Nov Oct Sep Aug Jul Jun May Apr Mar Feb Jan Saturday Friday Thursday Wednesday Tuesday Monday Sunday Sat Fri Thu Wed Tue Mon Sun                T  `   O         0        N  ^      D      L   G  \      >           8         8   @  Z     v   }   ,     R        q  l             "           i   "   m   $   q   &   u   (                          
   '     ]  d        :  X                   g  h                t                                             z        0                          	          
                  <      :   l  j   i     k     m     o     q     s     u     w     y     {     }                       6        _                   2     ~        b        |   0  V          x      .   Q     y   *        \     ,         @           N         {  p                                4                r   1        F   F             H         Y  b      B      J   u  n     P   e            a  f   E      '  T           NUL SOH STX ETX EOT ENQ ACK alert backspace tab newline vertical-tab form-feed carriage-return SI SO DLE DC1 DC2 DC3 DC4 NAK SYN ETB CAN EM SUB ESC IS4 IS3 IS2 IS1 space exclamation-mark quotation-mark number-sign dollar-sign percent-sign ampersand apostrophe left-parenthesis right-parenthesis asterisk plus-sign comma hyphen period slash zero one two three four five six seven eight nine colon semicolon less-than-sign equals-sign greater-than-sign question-mark commercial-at A B C D E F G H I J K L M N O P Q R S T U V W X Y Z left-square-bracket backslash right-square-bracket circumflex underscore grave-accent a b c d e f g h i j k l m n o p q r s t u v w x y z left-curly-bracket vertical-line right-curly-bracket tilde DEL                                                               	      
                  
                                                                                                                         !      "      #      $      %      &      '      (      )      *      +      ,      -      .      /      0      1      2      3      4      5      6      7      8      9      :      ;      <      =      >      ?      @      A      B      C      D      E      F      G      H      I      J      K      L      M      N      O      P      Q      R      S      T      U      V      W      X      Y      Z      [      \      ]      ^      _      `      a      b      c      d      e      f      g      h      i      j      k      l      m      n      o      p      q      r      s      t      u      v      w      x      y      z      {      |      }      ~         s                                                                                  el    `oC POSIX messages /usr/share/locale / .mo C POSIX LC_COLLATE LC_CTYPE LC_MONETARY LC_NUMERIC LC_TIME LC_MESSAGES LC_ALL LC_XXX LANGUAGE LANG 

 




            /usr/share/locale:/usr/share/i18n /locale.alias r iso sh -c /bin/sh                             (null)                                                   	                                                                                                                                                              
                                                 
                                                           
    (nil)  
 
 
 
 
   
 
 
 
 
 
 # $ $ $ $ $ $ $ $ $ $ $ $ $# $ $ $ $ $ $ $ $ $ $ $ $ $# $$ $# $ $ $ $# $ $$ $ $ $ $ $#U%%"%%"%%%%%%%%%%%%s%%%%%$%%%%%%%%%%F%$"%"%"%%$%%%%%$%%%d%%$%%$                    E@L<ě\ x         NAN nan INF inf NAN nan INF inf  :  %s%s%s
                 0000000000000000-c sh /bin/sh                   MALLOC_TRIM_THRESHOLD_ MALLOC_TOP_PAD_ MALLOC_MMAP_THRESHOLD_ MALLOC_MMAP_MAX_ MALLOC_CHECK_    malloc: using debugging hooks
 Arena %d:
 system bytes     = %10u
 in use bytes     = %10u
 Total (incl. mmap):
 max mmap regions = %10u
 max mmap bytes   = %10lu
 malloc: top chunk is corrupt
 free(): invalid pointer %p!
  realloc(): invalid pointer %p!
 reXUnknown error                                __mbrtowc mbrtowc.c            status == GCONV_OK || status == GCONV_EMPTY_INPUT || status == GCONV_ILLEGAL_INPUT || status == GCONV_INCOMPLETE_INPUT || status == GCONV_FULL_OUTPUT __mbsinit (data.statep)                   __wcrtomb wcrtomb.c             status == GCONV_OK || status == GCONV_EMPTY_INPUT || status == GCONV_ILLEGAL_INPUT || status == GCONV_INCOMPLETE_INPUT || status == GCONV_FULL_OUTPUT           __wcsrtombs wcsrtombs.c data.outbuf[-1] == '\0'                 data.outbuf != (unsigned char *) dst __mbsinit (data.statep)    status == GCONV_OK || status == GCONV_EMPTY_INPUT || status == GCONV_ILLEGAL_INPUT || status == GCONV_INCOMPLETE_INPUT || status == GCONV_FULL_OUTPUT INTERNAL ANSI_X3.4-1968// @.+, /dev/null getpwnam_r getpwuid_r /bin/sh PATH glob ../sysdeps/generic/glob.c next != ((void *)0) . / HOME ~ POSIXLY_CORRECT /bin:/usr/bin -D_FILE_OFFSET_BITS=64            POSIXLY_CORRECT -- %s: option `%s' is ambiguous
                %s: option `--%s' doesn't allow an argument
                    %s: option `%c%s' doesn't allow an argument
                    %s: option `%s' requires an argument
                           %s: unrecognized option `--%s'
 %s: unrecognized option `%c%s'
  %s: illegal option -- %c
 %s: invalid option -- %c
            %s: option requires an argument -- %c
                          %s: option `-W %s' is ambiguous
                                %s: option `-W %s' doesn't allow an argument
 _GNU_nonoption_argv_flags_=                       /proc/self/cwd                  ../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../.. . / stdin stdout stderr /proc/self/fd/ /dev/pts /dev  	   %d %d  %s %s %s %s %d %d
 -          /usr/lib/gconv gconv-modules .so INTERNAL ISO-10646/UCS4/ =INTERNAL->ucs4 =ucs4->INTERNAL ISO-10646/UTF8/ =INTERNAL->utf8 ISO-10646/UTF-?8/ ISO-10646/UTF =utf8->INTERNAL ISO-10646/UCS2/ =ucs2->INTERNAL =INTERNAL->ucs2 UNICODELITTLE// =ucs2little->INTERNAL =INTERNAL->ucs2little OSF00010102// ISO-10646/UCS2/ OSF00010101// ISO-10646/UCS2/ OSF00010100// ISO-10646/UCS2/ UNICODEBIG// ISO-10646/UCS2/ UNICODE// ISO-10646/UCS2/ UCS-2// ISO-10646/UCS2/ UCS2// ISO-10646/UCS2/ OSF05010001// ISO-10646/UTF8/ UTF-8// ISO-10646/UTF8/ UTF8// ISO-10646/UTF8/ OSF00010106// ISO-10646/UCS4/ OSF00010105// ISO-10646/UCS4/ OSF00010104// ISO-10646/UCS4/    10646-1:1993/UCS4/ ISO-10646/UCS4/                              10646-1:1993// ISO-10646/UCS4/ ISO-10646// ISO-10646/UCS4/ UCS-4// ISO-10646/UCS4/ UCS4// ISO-10646/UCS4/ r alias module GCONV_PATH : /                         =INTERNAL->ucs2little =ucs2little->INTERNAL =INTERNAL->ucs2 =ucs2->INTERNAL =utf8->INTERNAL =INTERNAL->utf8 =ucs4->INTERNAL =INTERNAL->ucs4 __gconv_get_builtin_trans gconv_builtin.c           cnt < sizeof (map) / sizeof (map[0])                                    internal_utf8_loop ../iconv/loop.c wc <= 0x7fffffff                        __gconv_transform_internal_utf8 ../iconv/skeleton.c outbuf == outerr nstatus == GCONV_FULL_OUTPUT                               __gconv_transform_utf8_internal gconv gconv_init gconv_end  (Pshadow services rpc publickey protocols passwd networks netgroup hosts group ethers aliases libnss_files.so.2   ۇ/etc/nsswitch.conf nis [NOTFOUND=return] files illegal status in __nss_next libnss_ .so _nss_ _ r SUCCESS UNAVAIL NOTFOUND TRYAGAIN RETURN CONTINUE         compat [NOTFOUND=return] files passwd gethostbyname_r %d /var/run/.nscd_socket /var/run/.nscd_socket                            undefined symbol:  
 ;  lookup in file= symbol= <main program> '
 : symbol `  to  binding file  _dl_lookup_symbol_skip dl-lookup.c i < (*scope)->r_nduplist ' (skip)
 symbol  , version   not defined in file   with link time reference  (no version symbols)  ]
 ' [                          _dl_lookup_versioned_symbol_skip ] (skip)
                      DYNAMIC LINKER BUG!!! :  
      : error in loading shared libraries:  <program name unknown> _dl_debug_message dl-misc.c pid >= 0 && pid < 100000 
 invalid mode for dlopen()                   shared object not open 

 
calling fini:  _dl_close dl-close.c  imap->l_searchlist.r_list != ((void *)0) LD_WARN  LD_LIBRARY_PATH cannot create capability list %s%s%s:%u: %s%sAssertion `%s' failed.
 :   libc                         
           d           '                     o#             ﬅ[Am-                  jd8n헧?O                         >.	8/t#ڰͼ3&N                                          |.[Ӿr؇/PkpnJؕnq&fƭ$6ZB<TcsUe(U܀n_S                                                                         lgrwFo]:FGWvyuD;s(!>p%"/.Q]OᖬW2Sq$^c_䭫*sf\wI[iCsFEHis84c                                                                                                                                           )r+[[!|nN5
}L,D4fl}C}Ο+#U>#`e!Q4\Ycɟ+1*ZibBtz["؊4س?ŏmk1Ke6ukG܉ـ( f13j~{j6h߸<bBQuɶluYD?e1Væ5RğIJ@A[ ^#IFި6ISs*pGI[?l	bI9C-ƣ4]0%                                                                                                                                                                                                                                                                          3eh	?M}ύI!G.Tu6Um.swBP겍Q,4Pn,4IyiJ.fq-WRU# 8I44Tl(Cf-dt.o(z@ZRD	dtɺ5HCDeVU^h6LU3I!
I<f-L{kyG_.؄D< sWjRbܧEE`f@/w]7fFtBk{|<{A3[W_lێ%\x[VFoNUS<DsvSЙK9v
pU.y`KmZC@3?Cy\XF->\A)\='_Djzp ؊4|ElݾV}*@|gu
"Ωo$po?b(UxI>Nkw};u

#6'0q'"(\<a+H+Tq40{&)tJSܵ	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         g*NrzATQTQ)kPr)NWFalj^EY4|~#H|L衋u߿Ax²gk#ͫ=t%jʀ.'aH#, K˄/ha	AT$vN0{;G-DlOaxeA0
~V}MP0!	լ*ǎ?:7B2M(aOmzӘȸ8ܠNE	8+͗20_e%	}o9k;PC4uP[<ba2BRʃi <h
z!pt0tvlw뛡c5ތ7d@ч;Bb&.^	Y]=u8Q)+
9/%->؄t.z-TMеub
<49Ԣ7.~2!'{n $-PԓX+1"#+%?D~br*~xxކzos{'~j=jr1|òAv09&Ѷ~j2=_+0cm-X%<|b
7w
ʐ,5P6xPnx	[4?E,W8 9qIHۚ풴lMP#*wg:8-ñj@?F[$GtJL0s-o|;#o`Is{Kҵ65m1
k?f%(炸r;v=4tP w?j&ATN4
@SZ
E3TɤAc+;={CpfU,ie.O\Oߢݭ9^2XX%-VNqv4§v=ЉMOT+}\
IA?7߻D!W DGn®8p p;3,f%k;ܑyٸZNh.ltH
Ic/~=otgx!RJݼ -ݎW5YAV9	T<!{>;b.w_ W5ƶ(NT]=!̇odI@BuhؖҋcU4ph{3'"2I%%
dKE)0b                                             
   $         0   6   2   @   k   g   X	         |          S  P  08       m   J
  G
  ď          '5  $5                       @   
  sH           u  
     @    
     	   ʚ;    	  +m            !0     W                  qEu     }$    {fG5      @KL    nZk      ᬔ      g       d     QJ     @i    I          Ht#     @s+    A;4       @     <L     @\    m                   0123456789abcdefghijklmnopqrstuvwxyz                            0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ    HHHHHHHHHHHHHHHHHHHH(HHHHHHHHHHHHHHKHHHHHKG!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!
!

!
!

!

!
!
!
!
!
!
!
!
!
!
!
!
!
!
!

!
!
r
!
!
!
!
!

!




!

!
!
!
!

!
!
!
!

!
!

            file TMPDIR /tmp %.*s/%.*sXXXXXX                                abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 XXXXXX                           T<"ѭ`B0$Ьs_@&ܫͫoUB/    y`QC*
ҩ~    iUC5רxeRF ާǧ`@ @P9[D £@ qS9#
СtWrong medium type No medium found Disk quota exceeded Remote I/O error Is a named type file No XENIX semaphores available Not a XENIX named type file Structure needs cleaning Stale NFS file handle Operation now in progress Operation already in progress No route to host Host is down Connection refused Connection timed out          Too many references: cannot splice                              Cannot send after transport endpoint shutdown                   Transport endpoint is not connected                             Transport endpoint is already connected No buffer space available Connection reset by peer      Software caused connection abort                                Network dropped connection on reset Network is unreachable Network is down                      Cannot assign requested address Address already in use          Address family not supported by protocol Protocol family not supported Operation not supported Socket type not supported Protocol not supported Protocol not available                          Protocol wrong type for socket Message too long Destination address required                    Socket operation on non-socket Too many users Streams pipe error                                Interrupted system call should be restarted                     Invalid or incomplete multibyte or wide character               Cannot exec a shared library directly                           Attempting to link in too many shared libraries                 .lib section in a.out corrupted Accessing a corrupted shared library                            Can not access a needed shared library Remote address changed File descriptor in bad state Name not unique on network           Value too large for defined data type Bad message RFS specific error Multihop attempted Protocol error Communication error on send Srmount error Advertise error Link has been severed Object is remote Package not installed Machine is not on the network Out of streams resources Timer expired No data available Device not a stream Bad font file format Invalid slot Invalid request code No anode Exchange full Invalid request descriptor Invalid exchange Level 2 halted No CSI structure available Protocol driver not attached Link number out of range Level 3 reset Level 3 halted Level 2 not synchronized Channel number out of range Identifier removed No message of desired type                              Too many levels of symbolic links Directory not empty Function not implemented No locks available File name too long Resource deadlock avoided Numerical result out of range                    Numerical argument out of domain Broken pipe Too many links Read-only file system Illegal seek No space left on device File too large Text file busy            Inappropriate ioctl for device Too many open files Too many open files in system Invalid argument Is a directory Not a directory No such device Invalid cross-device link File exists Device or resource busy Block device required Bad address Permission denied Cannot allocate memory        Resource temporarily unavailable No child processes Bad file descriptor Exec format error Argument list too long Device not configured Input/output error Interrupted system call No such process No such file or directory Operation not permitted Success }   /dev/tty    `3
p3
3
4
3
3
3
5
5
5
5
O3
5
O3
5
5
5
5
5
5
O3
O3
O3
O3
O3
4
O3
O3
O3
3
3
4
O3
O3
O3
O3
3
 5
3
3
4
4
4
 5
4
 5
 4
5
5
O3
D3
5
5
O3
O3
O3
O3
O3
5
5
O3
O3
O3
O3
O3
O3
O3
5
5
04
04
4
4
4
04
 4
04
5
5
5
O3
O3
O3
@4
P4
`4
p4
5
4
4
4
5
5
5
5
O3
 4
O3
5
5
5
4
4
4
5
4
4
4
4
4
4
4
4
4
4
4
O3
O3
4
4
 5
5
5
5
5
5
O3
O3
O3
5
5
5
    Unmatched ) or \) Regular expression too big                    Premature end of regular expression                             Invalid preceding regular expression Memory exhausted Invalid range end Invalid content of \{\} Unmatched \{ Unmatched ( or \( Unmatched [ or [^ Invalid back reference Trailing backslash Invalid character class name Invalid collation character Invalid regular expression No match Success lower upper 'H
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
 8
k`
k`
k`
H
H
=9
09
k`
k`
>
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
09
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
?
`H
k`
6
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
k`
HH
8H
]
H
J
L`
@`
L`
L`
L`
L`
L`
^
^
^
^
^
^
^
^
^
L`
L`
X
L`
Y
@`
L`
L`
[
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
W
L`
L`
L`
L`
L`
L`
L`
L`
\
L`
Z
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
L`
V
L`
L`
L`
P
M
Re
(h
e
f
e
f
 h
 h
e
Re
Re
Re
Re
f
f
Pg
Pg
f
f
f
Re
g
f
h
bf
f
Re
Re
Re
Re
l
Qn
p
q
br
br
1s
s
pw
y
Ry
y

\
\
P{
y

!}
w

S





W
a


$
$
$
$
$

$





(
$
$
$
$
$
$
$
F
$

$
$




        No previous regular expression stdin stdout stderr /proc/self/fd/ /dev/pts/ r /etc/fstab proc /cpuinfo processor /meminfo MemTotal: %d kB MemFree: %d kB  0123456789 0123456789abcdef 0123456789ABCDEF LOCALDOMAIN r /etc/resolv.conf domain  	
 search nameserver options conf RES_OPTIONS env ndots: debug inet6              reorder spoofalert nospoof multi spoof trim order nis hosts bind                                %s: line %d: expected service, found `%s'
                      %s: line %d: cannot specify more than %d services               %s: line %d: list delimiter not followed by keyword             %s: line %d: cannot specify more than %d trim domains           %s: line %d: list delimiter not followed by domain off nowarn warn on                           %s: line %d: expected `on' or `off', found `%s'
                %s: line %d: bad command `%s'
  %s: line %d: ignoring trailing garbage `%s'
 RESOLV_HOST_CONF /etc/host.conf r RESOLV_SERV_ORDER RESOLV_SPOOF_CHECK RESOLV_MULTI RESOLV_REORDER RESOLV_ADD_TRIM_DOMAINS RESOLV_OVERRIDE_TRIM_DOMAINS dns [!UNAVAIL=return] files hosts %d /var/run/.nscd_socket /var/run/utmp /var/log/wtmp /var/run/utmpx /var/log/wtmpx getutent_r_file                       ../sysdeps/generic/utmp_file.c file_fd >= 0 getutid_r_file getutline_r_file pututline_file endutent_file /var/run/utmpd.rw /var/run/utmpd.ro getutent_r_daemon utmp_daemon.c daemon_sock >= 0 getutid_r_daemon getutline_r_daemon pututline_daemon endutent_daemon /var/run/utmp                bad dynamic tag elf_get_dynamic_info dynamic-link.h ! "bad dynamic tag"                         info[19]->d_un.d_val == sizeof (Elf32_Rel) info[20]->d_un.d_val == 17 /proc/self/exe /  ORIGIN PLATFORM expand_dynamic_string_token dl-load.c l->l_name[0] == '\0' cannot allocate name record add_name_to_object lastp != ((void *)0)                   cannot create cache for search path cannot create RPATH copy : RPATH /usr/lib/ /lib/            cannot create search path array system search path :; LD_LIBRARY_PATH ELF                   failed to map segment from shared object cannot stat shared object ;  generating link map
 file= cannot read file data invalid ELF header ELF file class not 32-bit                             ELF file data encoding not little-endian ELF file version ident not 1 ELF file OS ABI not 0 ELF file ABI version not 0 internal error ELF file version not 1    ELF file machine architecture not i386                          ELF file's phentsize not the expected size                      cannot create shared object descriptor                          ELF load command alignment not page-aligned                     ELF load command address/offset not properly aligned            cannot change memory protections cannot map zero-fill pages     program headers not contained in any loaded segment             object file has no dynamic section 
    size: 0x   base: 0x   dynamic: 0x 

   phnum:      phdr: 0x     entry: 0x cannot create searchlist  search path=  )
  from file  		(   trying file= ;  needed by  
file= ; searching
 find library=                     cannot open shared object file 
 /etc/ld.so.cache  search cache= ld.so-1.7.0   trying file=     bad dynamic tag elf_get_dynamic_info dynamic-link.h ! "bad dynamic tag"                         info[19]->d_un.d_val == sizeof (Elf32_Rel) info[20]->d_un.d_val == 17  (lazy)
 
 
relocation processing:                        cannot make segment writable for relocation                     ' has different size in shared object, consider re-linking
 : Symbol ` <program name unknown> unexpected dynamic reloc type elf_machine_rel ../sysdeps/i386/dl-machine.h                        ! "unexpected dynamic reloc type" elf_machine_lazy_rel ((reloc->r_info) & 0xff) == 7            cannot allocate memory for profiling                            can't restore segment prot after reloc   ERR	
#
#
P			
  requested by file= load auxiliary object= _dl_map_object_deps dl-deps.c errstring != ((void *)0) load filtered object=       cannot allocate symbol search list cannot extend global scope   bad dynamic tag elf_get_dynamic_info dynamic-link.h ! "bad dynamic tag"                         info[19]->d_un.d_val == sizeof (Elf32_Rel) info[20]->d_un.d_val == 17 fixup dl-runtime.c ((reloc->r_info) & 0xff) == 7 profile_fixup 

 
calling init:          
  required by file  ' in file  checking for version `          no version information available (required by  ) match_symbol dl-version.c def_offset != 0 unsupported version   of Verdef record weak version ` ' not found (required by  version `  of Verneed record
 _dl_check_map_versions needed != ((void *)0)           cannot allocate version reference table                         gmon seconds .profile 
 : cannot open file:  : cannot stat file:  : cannot create file:  '
     : file is no correct profile data file for ` : cannot map file:                                 Out of memory while initializing profiler
                          
   d     '   @B    ʚ;inf infinity nan                                                                                      
   d     '   @B    ʚ;inf infinity nan                                                                                          
   d     '   @B    ʚ;                  inf infinity                      nan                                                                                                                                                            GMT TZ /etc/localtime Universal UTC  %[^0-9,+-] %hu:%hu:%hu M%hu.%hu.%hu%n /usr/share/zoneinfo /etc/localtime ../ TZDIR r __tzfile_read tzfile.c num_types == 1 posixrules __tzfile_compute                            ; Z x     0Nm   < [ y     1On         v@      8@      N@   UUUA  T)

H

X

E([                        ,"                                                                        GF                            `UbU                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Unix CPIO Plugin                                                                                                                                                                                                                                                1.0                             Stphane Peter <megastep@megastep.org>                                                                                             	d dcc                                                YY,Ya            Unix TAR Archives Plugin                                                                                                                                                                                                                                        1.0                             Stphane Peter <megastep@megastep.org>                                                                                             dddd                                                 bbbdb            UZ2 Plugin                                                                                                                                                                                                                                                      1.0                             Ryan C. Gordon <ryan@epicgames.com>                                                                                                 f                                                            Pf\flff                                                                                                                                                                                                                                                                                                                                                                                                                                                  j j                        &   @j<   ;j>   6j'   /j"   (jr                    rr                        ssss}sssasWsKs                            tttsssssstt                   text                         W                                                            `l|                \H,hph                                                                H,    h    h    {yvtomhfb`                                               {v                    e]                    \T                    =6                  )$                                                                                                                                    |w                  he                  RK                    >6                    '                                                                                                                    ~                    pl                    XT                  EA                                                                                                                                                           x                   eb                    YV                    YS                    YP                    YM                    YJ                    YE                  63                  "                                                                                                                                                     `I                    2+                                                                                                                                    `<                                                                                                    ~                   sm                  WS                    @>                    &$                  
                                                                                                    `T                  @9                    )#                                        	                                                                                                                                       }w                   ic                    SP                   EB                                                                                   bVSPMJ    TTS        ~3bVSPMJTTSE    E~    c~    wE#c~    ~bVSPMJTSE    3~E    b~E    V~E    S~E    P~E    M~E    J~E    T~E    T~E    S~E    ~E    ~E    ~E    ~TTSE    ~TTSE    ~TTSE    ~ETTS    ~E    ~E    ~~EbVSPMJ    A~E    <~E     ~E        6~    6~    6~    ~EbVSPMJS        ~    PP6~    w6    P6w~    P6w~        +~EbVSPMJS            "   

&   ~
e
<   b
D
>   A
 
'   
         eL   F,   %         q   m@   -   

   

   n
V
   R
 
   
	   		   v	[	   T	 	   	   `   L          `   I          @   "      h       `   R          `   U       `   R          `   R              `    I             `   W          `   P          w@   6          u@   -      `   P          `          `   U          `   U          `   P          `   T          `   P          `   N        c@  "       e@  "       b@  #           `@  (       a@  +       i@  !       i@  (       k@  (       h@  )       f@  &       g@  /       k@  '       i@  ,     "   k@&   6 2   3   >   i@D   !  !  !  y@"!   5!  !  !  bE!  @ !  !  !  @!  ' !  !  !  g@!  (  "  "  "  v"  p@"  , "  	"  "  `"  M "  "  "  "  k@"    "   "  '"  ("  a@)"  # *"  +"  4"  <"  `E"  G H"  `"  a"  d"  `e"  I "  "  "  "  "  h@"  * "  "  "  nQ#  K 	#  
#  #  )#  `*#  S %  `&  c&  e&  l@f&  " R  S  `  r@a  0 x      fK   F.   )	   
   
      h@   (             k@   (          h@     
!   0   9   `:   @                   deflate 1.0.4 Copyright 1995-1996 Jean-loup Gailly              $@                                })r)q)f)Y)N):)-))q)                                           ?                   ?            O    P                               ؗ
        ?                        JLXR\`sssssss                        \HHHHHIabbHcpc`s                    el`os                                                t                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `
                    GwwGG
g
D


 %0p0            GG
g
D


 %0p0            G
g
D


 %0p0            

D


 0            g
D


 %0p            
D


 %0p            P?P?P?P?P?P?P?P?P?P?P?P?P?P?g,,---58:== ?9(7P?P?                                                    xT|L<Lě( '
$<,vh(4                    Lh}؟L(ě\ x (4                    xT|L<Lě( '
$<h(4                                                                                                                                                                                                           `                                                                                                                                                                    `                                                                                                   X                                                                `                                 LP؟L(ě\ x (4                                                    ((0088@@HHPPXX``hhppxx    ((0088@@HHPPXX``hhppxx    ((0088@@HHPPXX``hhppxx    ((0088@@HHPPXX``hhppxx                                                                                                @t                            a                                    _}V}l                                                V}_}n                                                                                                                              ?                                                                                                                                         
                       
                                          *                                                           :   J                Zl
                                          z                                                                                                                                                                                          ʂ                                                                              ۄ`?!ԃmP2Pk                    Pk                     p                    u                    ||                    l~                    VX                    @                    ć                                 w    p                                                                                      v    v            رm`H6%  N      YY,
    '
    !
    
   
   
    
   <   6   2           

`

 
l
    $                        
P
x
x



@
\


d


./  OE                                                          |         
_   AB
DAAc.        |  (      
C  AB
DAAz.I.L.4   D   4
   AB
DAAf.M. K.X.X.F.H.           |  ,       E  AB
GPAQAR..E.           |  (      
  AB
DA
Ah.3.  0   D   l
  AB
DAAk.L...      x   \
F   AB
AAAX.,      
t   AB
AAl.S. J.S. J.          
<   AB
AAh.   ,      T
_   AB
AAA[.Q. I.Q. I.       
4   AB
AA`.                               	                             GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.3 20010315 (release)  GCC: (GNU) 2.95.3 20010315 (release)  GCC: (GNU) 2.95.3 20010315 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) 2.95.2 19991024 (release)  GCC: (GNU) egcs-2.91.66 19990314/Linux (egcs-1.1.2 release)           01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01             01.01    .symtab .strtab .shstrtab .init .text .fini .rodata __libc_subinit __libc_atexit __libc_subfreeres .data .eh_frame .ctors .dtors .got .bss .comment .note.ABI-tag .note                                                        /                  !            
                '         1Ա
                   -          2 
                  5         O                   D         P                   R         P                    d         @@P ?                  j          8                 t          "                    {         ("(                            0"0                           `"` lW                               ` [                                                          [  4                                
                                                                                                                                   setup.data/bin/Linux/x86/glibc-2.1/                                                                 0040777 0001750 0000144 00000000000 07537165266 016417  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  setup.data/bin/Linux/x86/glibc-2.1/plugins/                                                         0040777 0001750 0000144 00000000000 07537073560 020073  5                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  setup.data/bin/Linux/x86/glibc-2.1/setup.gtk                                                        0100777 0001750 0000144 00006433540 07542466500 020274  0                                                                                                    ustar   icculus                         users                                                                                                                                                                                                                  ELF              P4   P3     4    (      4   44                                                       B BG  TQ                                             /lib/ld-linux.so.2           GNU                                i      b	  t  e
  
  <  	  !          Q                  D                      #      U          S                      Q  s      1  {  q            H  Z  	  [
  `
  
  a              g          ~    c        i  R  y  	  
  
    H  	          a  s              	  C      	  p  
                 "  ~    U	      Z     
    /       
                          %
     5   e      |  	       H   
              
          E     B  S  G      `  p        
  )    f                *      	              5      <  N      	  !        \          
  	  5  	         /	    K   V        Z        2           [    A         
  g  
  
  B     &  	    x  C  
  	  m
  
          M        L  O        c       &      	    N	  u  
            r      i         \  >     
	  7  2   F          F  	    L
  =       G       *  
        [                     
  
                                                  b
                    J              4        $
        "                8  E         
  .    9                e    
                  Q
    -           
           0                   u  1          l                        	  F  
     	  
  a	  n  *  
  B
  2          Z  	  r      )	                         
  c      f
        
  
  g  G  -  .                  P      	  B  ,
          5	    >            
           |      &    )  :	    	          	                  K  V   	    D  L  
      D                       	  
  #         +
  )  	  
         i      ]  =
      v      ~  d  o        Q  V  	  /         '	   
  
        W  <
    p  D
        
            K  (  >  
  V       D  ^  	              X  s  	  f    :      	                  Q        	         
  T	      (
  |          	       <  0          !  7  T
    k                  m  
  #	  w  K
  f      =          
        :
          		  K    ?    2      -
      
                	            m  	  y	  [  C  L      k                     Q    Z  V
  Y  h              m     n      
    	      	          F  ^         Q  `  H	          
    x      8        d	  $  b             '         	      d  k
    !    /  (	  &   j  9  M    r          W  $	  [	      ?            X                          	  	        
                              I      ,   
        
  $  j     k                  	  J          	
      s	                /  2      
  
    _         	      O         N          S  B  1  |  
     E  J      
      z                A
       T        A  
  4  N  
    Y                
  w        {
      m  
     N          M                 t                   j    "    2  h    0                g
    s      X      _    I    9   5
                           
  	    ^          H      y          I      *
  7  	              
  ;      A        %  
        
    2      ]    
    Y   f	  %  A    I
      K	                 	    Q	               =	      p      C  	  	          _	  
  Z    B  k   :              +  &	  S	    
      	  	  ,  	      	  v     
      D  
  q  h
  a   f  {  K  /    "  g  V    k  0  
  
  _
  
  &  ^  3
              7                                  J
    	  b   
  
      W          o  E	            X  y  
  8       0      ]	             T        V  &
                              R    -            9  Z
  [      	  	          #  '  4                   2	      
  #  6  U
    g            %              ]        C	  
        <  L          W  >    d  
  	  `         	  
            
      J                
            3   
    \
  Y             	  `                            {      
      P     	  l        m  f    p        J  
  o       :            k      _      |    	              N
  	  u  3  =          H               &                      	  	               
      )               	  C                  !  (  D      
              x
               A   	               	  "       	     {          |	              I  ?               ]   `  Y    7  1  E      W        3  M          
          l          	    E    L  c  (    e                   u           "  
        A  *     t
  2  
      R        	  
                                                    U  X
  _  	  ,         m	  K      h  	  4      V    o	    V          
      d                  W	    
  ]    u        
  E  	  n	  
      C
  <        ^      d                  	  )          	    	     z
             
  W  
  E  O
  %          
      _    !   
        r
        e          }                  $            
  U      !      9	  
  	      	  \	  &  j    
              
  '
    E
              U    8  H      2
  c
  
    
      v  +      	  @                         Q            6    V	  q        R
  I  P          u               O  
  \          v  0  
              
            R	  ~
                              6  i
    w            
    I           =  i  F  {	    	      M	            W                     m  3  	           #
  ^	      m      6	  s      	              8
    $      1
  }          
    
        	            	    y              
          ;
  y
    	      f                    :    f      w  h    	      !  0        
        t         l  ,  	          c    	  o
             h  
          r    
    P                	  T   @
             	  ~  u      (   
  
  "  	                            G
  x  >  
  
        S  
  :                     R  7     v	  `	                       v
      |
  J        	  6      a                   M                                  	  N  
  6          _  z            
    	  
    #        
        J      
        b                      }
                  D  J  	  	  :   ~   `  w	      	  O    n        
              	    

  +         ~              9  Z                  K  e     e    P     ]  }  p  -            I                    T      
      B        	  o        :      u	    t  F
  
      p
      8  
  1  t                      Y	  p             s  |       
            
  [                 	              @        }  /              >
  v     t      z  k  S  X  $  !
    
        
  	  l        
  $  
      3          4          g  w  o  %                   	                    	      	                      I            ^  j            J            U                  b          X  A                      \  o    D  B	                  	      M          #  	        V      r              i      
          N      8	      .        	    R                  k      {    !	                    P  *  
      ^            d  >                         
            	          l
    9
                                     \  )
    c                                      \  	  	  	  &                        s  z           n        4          
    l  `  	                             /
                         	                      	                                   x	          _      3	                      6            	    ?                                              @                 	                .  ,  .        Y          j  p                    Y                        ,                    	  #                                    N      	  F                     P    O	  b                                                      h                ]            
      V          #  #             7                          	  \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   X                                                                                                                                                                                                                                                                                                                                                        6          Z                                                                                w                                      1                                                                                                                                <  }                                                    \                      +                                    v        )                                                      %      
                                                                                                                                        6                                                                               
                              G                                           U                    ;                                                                                                                                                         3            v                            2          }                              j        '                  x                                                                  ~                                                      z              4                                                                                                                                          ,                      /                G                                               !                                                                                                                     {         H                                  6        1  9  k                      
          u                  a      ~                4                     y  Y  9                                    M    S   N  h      ;                                                                           k  q  _                          ;                                                                  z            ?      y            m      y          (                          G                           /              .                                   Z                              b      1                n                  q                            )                       e                  %                      "    C      P  n            w                      c                                       d      >          D                                                         .                          =            $                L           r              2          +          (        T                          U        I  w      |                  g                W                          ?               x      |  4                                                                        R      |                                                                        C                                                .                        
                  B                              t                                                                          G        T            5              r      F              L            R       d    
                              \  X                                           `      2                      V        P                                          @                @  )                [  #  	              m                                          0               f                         
                            _  (  O                                          A                                              4      W              e  i        %      @                   c          $               f                            n  j                          z    U                            W                  {      G                              '                      Q            
  L                                3  S  :         C    8                l             t  p                                                 8                   9        O  v                                   G        j            [                n                                     4               *                    ]                                      t    g                   '      (            :                                              N           (  !                      n  9                        P      :        5    ~                            U             u                                         @                                        }             C        m                              8                  o  H  `  T                      I  d        +          ~               o          _        =                    *  a                                            E              5                              
       o      .  ^             3  [      `                ;                Q                                           !            K                                       x      y        )                      O  u      v          B                  F          .                8    X              @          *          Y        %  (           ?  Z          |    S                        s  /                	     @      ,              p  a          <        q  &  z       3  7  '                   6    U        %          J  i  c  \              -            ^                      O              O      =  <  x        K  d          K    C                       b      x      R  )      x           {                    s  z                3                      Q       t                            9    '  y                /  J                                
  m                              ^                        r     x          c  *  q  A     {          U                  e   	  y         Z        f      
  o      <	                            }    -  9        5  e                   0  '      ?    <   w  T  `            =      A    ;  ?      ]    R      L  "	       	      @	            -          l            i   e	  H                  }	  S                  v    J	                                  t	  =      	                               X           h      ;                        0  ;                  v    _  z	          	        h   	                       E    +                  ,             4	      l             	                                               p	              C                7       	  D   5  [          	             o      ,      j  r  L	          Z	                              k  	  
  5  <        '  	    a                w                  *	  +  	      i      	  	  .
  ]    	         j    |  >	          O                   
      	        @      +                ~        I	  c  G    	      F            S  L  	    	  .	  7    0	  Y    	  {  
          &    	    {      	          E  S
                1    1   r	        
  	  =                
	  %	  ^       7	  >                 h                      -            
              f   B    H          "    	          }  \  8                H
  g    M
    "  
  A            1	        &        	      
                    q  ;     X	        T  	      }  	  	               h	  c	         w  l      l  q     s
      	  q               
                 	  
  	  ?	  b  H  ;	                -  P    i	  z      u
  -      
        -	  *  
              5             	  5      
  	            b                M   T  8  @    
  b       	  ]
                    
            
  	  
        T      
  N     F	  $  t               M    D	  6      ;  ?
        F  }  
  -          p       q        6
  	                L           	  >  $        >         
        q
      ?    	                 "
      O  F            r  j	        X  q	    s  ,      R  	                          	      
  Y  
  	  '  g	    	             	                  
  	  
       
      A	  
        D                                  
          
           
        	          P
  n
      ?     Y
  %  u        a      
  	      '  :  3      h  
  y    	        a
            P	        e      +        x                              	  .      ]        (        +	  ,	  #  
  ;      G	  l	     d
      N           ~	  M      7
    S            n      4
               	  
  	       s      R  
  a    n  r      j
  W
  /           =    "  d              +        
  )    M            	  K    	           >             7                B    a            1  <    w
    b  
  z  k	        Q  I  	         W   
  E  i      B  g  	  $  0
         
        *        
  [     [           ^
         0  
  G  g    	                                                  ,         5        K         Q   N      W   *      j   #                 +        d1                 $         d        j        4        4       t      !  :      /  :      >        S        Y  D      k          D               t                T       T                T                4              !  t      3  4      =       E  t      [  T      i       s  D     }                                 Tr                                >        T      &  4)     0       ;       F       R  )     a  t     o  G     }  d~        ~        e              t              t       4       <       f                      &        2        >  p      L  Dp      b  p      t  4               >                              Th               T       4               D      )        6  d      B  4,     R        ^  T     k       {  D        $
                $        d        s                      k                       	       E     (  d      5  D     @  d      P        ]        h  Tp      w  $        D        4                4}        dp        p        z        4        e                     +  x      7  x      @        M        Y       f  U     v  $5       3       $       D              ;               d        4        d        d             "       /        E  t%      S  46      c  ,      u  ,        \        \        4>        m        t        D        T
      	  (      	  tG      %	  k      2	  k      ?	  x      I	  j      T	  u      a	  x      n	  -      z	  -      	  dN      	  M      	  b      	  S      	  TU      	        	  $      
  L      '
  L      A
  L      [
  L      u
  3      
        
  E      
  2      
  <      
  E      
  $2      
  <      
  D        b            @        H  7      P  DO      V  $=      g  4"      n     "   y  D%   "     $)        ZO              t   "     t:   "     d:   "     tO        )        5       /   "     t        '   "                    ;   "     D        tR       dk      $        *  $$      1     "   7  l      =  >      D        K  F     P  do      W  4=   "   `  T/   "   g  t^      q  4_  "   x  3   "   }  2  "     ~   "     $
              3           "     4;   "     D       7   "     :   "     DI   "                 $   "     "          "   
       
  6   "   
  DD      $
  d=   "   *
  To   "   6
  :   "   ;
  d     A
  D;   "   G
  {      M
  T7   "   R
  $:     [
  d7      a
  ;      h
       p
  4  "   w
  =   "   }
      "   
  $      
  $;   "   
        
  1      
  4:      
  T4      
  ;      
     "   
  T7   "   
            
  M      
  4      
  O                      #   "     7   "     43   "            '     "   .  =   "   3  $      ;        C  $7   "   J  t_   "   U    "   ]  K      f        o       v  :      }  /   "     t$            "     d        $        '   "     d   "            T;   "     d;   "     )        %        $F        4          "     A          "        "   	          $  "     :      $  $     -    "   4  TK     B  T~     L       U     "   [     "   g  $      o        v  5      }                !        D        L        4\$       $                   "     T;   "     :       s           "             :         "     ~   "     y              $  N     3  D6      9  
     B  T%      I        [  =   "   `  g     g     "   m       t  Dp   "   }  t=   "     t;   "             tt   "     $7   "     YB                      "     :        N                     t        )    
 
  h
    
   	F   
 ?      
 M  ܘ
   
 f     
 {  BC    
   @   
   `    
   <Q
    
       
   pB    
       
 4   A   
 I     
 b  lI    
 z      
   m9    
        
        
       
   
u    
   P    
   J   
 )   a    
 6  {_   
 X  y%   
 k  Pga   
 {  n3    
   ,F/    
   ^z    
   
[    
         
   0q   
       
   
b    
 4  hB     B  PP    
 J  `s     ]  @<    
 w  k   
   +Y    
   q       r%    
   *   
        
   
    
   `   
   <    
 (  L)   
 :  g,    
 O  
p    
 _  
o   
 u  
    
   (
$    
   `o%    
      
   0   
   I       `1%    
   0;    
 
   *
"   
 &     
 B  s     ^  pr     q   `   
   5    
   n       `5	
   
      
        
   0m    
 
  
k    
       
 ,  z    
 @  n'    
 f   C    
    /    
   p
    
       
    8   
   9\   
   pC   
   PB       @rz    
 $       
 A  ^    
 O  -4    
 _  (	    
 o      
   p>   
   
    
   Eg    
   p    
    #    
   [    
   r     "  (
{    
 0  o     =  LO   
 P  ?    
 X  `    
 {   ]    
       
   5    
    u8    
       
       
   s   
   6;    
   @r       `    
 :  P\    
 G  lB     U       h  `    
   	
(    
   lr       0    
   {    
   lj
+   
        
 
  p    
   
R    
 )   ($    
 8  a    
 K  q     a  hr     x  9    
    5    
   o   
      
   0H   
   R    
   n    
   з
%    
   k1    
 /  p2   
 ;  
    
 L      
 h       
 ~  q       P`o    
   @$    
       
   %    
       
   Pi    
   6r    
 %      
 4      
 S  Z	   
 g   P     |   
	    
   	   
   @    
    @    
   %    
   l7
.    
   X8
   
 
  p8    
 #  r     <  0    
 L  -    
 m  r                W"    
   r       %    
   0[v    
   =   
        
    F    
 *   0    
 3  @   
 B  p:   
 S  M    
 f  P    
   `    
   ^    
   @m%    
   ,    
       
              
    p    
 &   M    
 :   q     O   &   
 i   ]%    
 |   dE    
    `+   
     V   
    p    
    T	   
        
 !  3    
 "!  @G   
 .!  0    
 9!      
 K!  I    
 a!  L:    
 u!  -    
 !  6    
 !  
    
 !  1N    
 !  ~    
 !      
 !  H    
 !  u    
 "  -    
 "   (   
 ."  pB/   
 ="  0d    
 J"  `    
 ]"  p%    
 z"  
   
 "  	    
 "  ^    
 "  p/    
 "  p:F    
 "  
   
 "  '\   
 #  _    
 "#      
 9#  `    
 T#   SZ   
 b#      
 x#  `9    
 #  
i    
 #  @ %    
 #  @%    
 #  m    
 #   J     #  
    
 #  %    
 #  t    
 $   %    
 #$  	a   
 2$  06v    
 O$      
 f$  Ю    
 |$  C^    
 $  @    
 $  Б)    
 $  Pn3    
 $  p    
 %  @G"    
 %      
 5%  PV7    
 N%      
 d%   7    
 s%      
 %  Dr     %   Q    
 %      
 %  M    
 %  H
    
 %     
 %        
 &  Y    
 #&  .    
 4&  1    
 G&     
 Y&  T	    
 s&        ~&  !   
 &      
 &  \K4   
 &  J    
 &   $    
 &  0]
   
 &  i   
 '  /8    
 '       
 "'       
 8'      
 P'   $    
 `'  9    
 t'  _   
 '  	   
 '  F    
 '  r    
 '  ]z    
 '  (
f    
 '       
 (  4&J   
 (  @,"    
 9(  U   
 P(  r     d(  
^    
 {(  M    
 (  J
    
 (  C    
 (  	    
 (  q}    
 (  S   
 (   E    
 	)   o    
 )  (
    
 &)  y    
 >)       
 E)      
 d)   /    
 y)  F5    
 )  pD    
 )      
 )       
 )   K    
 )  9w    
 )  8m    
 )      
 )  x    
 *      
 #*   Z    
 2*  3%   
 J*  C    
 \*  GZ    
 v*  hO    
 *       
 *  x    
 *  `   
 *  \4?    
 *  l   
 *      
 +     
 +  G   
  +  J    
 3+  @8    
 G+  
    
 \+  m    
 m+  `   
 }+      
 +  	h    
 +     
 +  i    
 +  p
   
 +  PdD    
 	,      
 ,  t
    
 $,  PY    
 ,,  <    
 G,  0    
 j,  p2   
 ,  e   
 ,  4s     ,  r     ,        ,  r     ,  1    
 -  \s     (-  s    
 6-  [
    
 N-      
 Z-   6=    
 g-  J    
 -  I     -  X   
 -  0    
 -  0wc   
 -  p-4    
 -       
 .   x    
  .  x,    
 8.  p   
 X.  `   
 d.  @   
 .  
    
 .  @c   
 .  @X   
 .  `    
 .  5    
 .  H@    
 .  
    
  /  \    
 /  
    
 )/      
 7/  [   
 I/  C5    
 `/   #    
 l/      
 |/  ,"    
 /  h(
     
 /  d    
 /  |Ta   
 /  yc    
 /  Po    
 0  Ц{    
 0     
 -0  t    
 >0  q     R0  I     c0  
    
 x0  
   
 0  O    
 0  P~    
 0  1
n    
 0  'm    
 0  r6    
 0      
  1  @<    
 1  q     *1  @~    
 N1  WC    
 [1       
 v1  pO    
 1      
 1  H    
 1  @K    
 1  dr
|    
 1  ?K    
 1  0    
 2      
 "2  F    
 ?2  0r     T2      
 e2  
h    
 s2  &
    
 2  pv%    
 2   (    
 2       
 2  L	    
 2  i#    
 2  P    
 2  r    
 
3  d    
 .3  Pr     A3   t    
 Z3  -
u    
 q3  lH    
 3  7    
 3  
    
 3   }    
 3  `W1    
 3  `@    
 3  4    
 4  P    
 -4  Q   
 ?4      
 Y4  m    
 }4  @m    
 4      
 4  @    
 4  pL    
 4  p    
 4  Z   
 4  PX    
 5  |    
 (5  
    
 B5  v
^    
 X5  `<    
 p5  F    
 5  |
L    
 5  (
    
 5   r     5  0V    
 5  BP    
 5  x    
 
6  P    
 !6  PH    
 26  0s%    
 H6  
    
 \6  Ж    
 s6  iO    
 6  @    
 6  
   
 6  Y    
 6     
 6  NP    
 6      
  7  p   
 7  	    
 -7  n
y   
 ;7  ]t    
 I7  	G   
 Y7  @a1    
 f7  W    
 }7  d    
 7  p
    
 7  pw   
 7  M    
 7  (
z    
 7      
 7  U    
 7       
 
8  p9    
 8  
   
 08  (B    
 P8      
 n8  `    
 8  ^z    
 8  
    
 8  &
    
 8  r     8  5    
 9  `     
 "9  
_    
 49  N)
   
 @9      
 V9      
 e9  Y   
 9  l
.    
 9  p   
 9  `%    
 9  @    
 9      
 9            9   uL   
 :      
  :  pu   
 D:      
 c:  R    
 q:  O    
 :   %    
 :  ?    
 :  
y    
 :  r     :   7q    
 :  N    
 ;  $    
 &;  P
    
 6;       
 I;  	    
 ];  05    
 h;   a
f    
 |;     
 ;  !   
 ;  pr%    
 ;  C	    
 ;   ~   
 ;       
 ;  (    
 	<  `    
  <  @h    
 ,<  ԟ
+   
 J<  F    
 \<  @    
 t<  `i    
 <  Ds     <      
 <  73    
 <  B0    
 <  r		   
 <  XD   
  =  0Pw    
 =   B4    
 .=  0[   
 F=  @="    
 Z=  \h    
 f=      
 }=  0`    
 =  `$    
 =   A    
 =      
 =  @I   
 =  DS	!   
 =  0Q    
 >  0    
 >  Po    
 ,>  )
    
 ?>  `    
 `>  2    
 v>  l    
 >  r    
 >   ,    
 >      
 >  p}    
 >      
 >  S   
 ?  
a    
 ?       
 9?  `
    
 J?  `    
 ]?   j'    
 w?      
 ?  *)    
 ?  ;
    
 ?  з    
 ?      
 ?       
 ?  4   
 ?  P    
 @  x'   
 1@  `q   
 T@  u&   
 d@     
 ~@  2J    
 @  \#G    
 @  @    
 @  p    
 @  
   
 @      
 @  `    
 A  0    
 A   %    
 (A  3   
 ?A  |
    
 SA  `6    
 dA  `?    
 sA   
    
 A  D
    
 A       
 A  P    
 A  @-
u    
 A         A  W    
 A  P@
    
 B  %    
 .B      
 @B  0{k    
 ZB  U\    iB  о   
 vB  5   
 B  H6
    
 B  pj/    
 B  T$    
 B      
 B   n+    
 "C  `   
 8C  P'    
 VC  8'    
 dC  9    
 zC      
 C  0
T    
 C  H    
 C  
H    
 C  q     C       
 C  t    
 C  m    
 D  q     D  0]'    
 3D       
 GD  0E   
 bD  N   
 }D        D  0I:   
 D  0b   
 D  Be    
 D  p    
 D  `
t    
 D  07    
 E      
 )E  p    
 6E  0l+    
 ^E  K    
 E  0    
 E  l   
 E  4r4    
 E  0j    
 E      
 E  Z    
 E  
   
 F  y
M    
 F  l    
 +F  Q,   
 GF  @    
 VF  P   
 sF  І4    
 F  Z    
 F  0!    
 F  y   
 F  `    
 F  g	   
 F  r     G      
 %G  @   
 5G  Pil    
 DG       WG   

    
 hG  r     G  P-    
 G   |   
 G  h!z    
 G  P    
 G      
 G  %    
 H  r    
 #H  
`    
 /H  }G    
 =H   a    
 RH     
 cH  q     H  
    
 H  %    
 H  g   
 H   I$     H   F    
 H     
 H  %    
 H  ,    
 I  Y    2I  [
    
 HI      
 WI   @    
 wI   I    
 I  e    
 I  Q    
 I  ~     I      
 I   H
   
 I      
 J  m)    
 7J  @    
 SJ  ^    
 hJ   9    
 tJ  pC    
 J     
 J  R
    
 J      
 J      
 J      
 J  
   
 K  H
s   
 K  p    
 3K  Dg    
 UK  wC   
 iK  a    
 zK  ]    
 K  @M   
 K  P    
 K  @Q    
 K  y   
 K  @/    
 K  P   
 L      
 !L  P    
 <L   +Y   
 ]L  [    
 qL  q     L      
 L  	&   
 L  $    
 L  %    
 L   9    
 L  0R
u    
 M  $Q   
 M      
 /M  ~    
 >M  `%    
 TM      
 hM  iE    
 }M  з<    
 M  kN    
 M  	c    
 M  
    
 M  q    
 M  `l    
 N  %    
 $N  pk    
 <N  O
    
 MN  
p    
 [N  $
Q    
 pN  PP    
 N  A    
 N   ]'    
 N  Ж   
 N  @\    
 N  L   
 N  
   
 N  @h   
 O      
 %O      
 <O      
 NO      
 dO  h
N    
 oO  o    
 O  B    
 O  Z    
 O  W    
 O  0*   
 O  p    
  P  #
!    
 P  |B@    
 P  do    
 2P  E%    
 KP  G   
 WP  P    
 wP  {	   
 P      
 P      
 P   e    
 P  &    
 P  @3    
 P  +%    
 Q  t    
 Q  
    
 -Q  ,
    
 6Q  
   
 CQ  n    
 TQ  @    
 uQ  P4B    
 Q  `A   
 Q  @*    
 Q   D    
 Q  A=    
 Q     
 Q  #    
 Q  $      
R  n   
 *R  Hs     @R  ~    
 UR  q     rR      
 R     
 R   4     R  x1   
 R      
 R  5    
 R  P   
 R  B   
 S      
 S  !   
 +S  
    
 DS  ~     XS  p    
 eS  ~     rS  $:   
 S      
 S      
 S  0%    
 S  HGW    
 S  Л    
 S  p	3   
 T  3
F    
 T   %    
 *T  $
   
 CT  `
    
 cT   ;    
 wT  
s   
 T  0w}    
 T  	    
 T  Ad   
 T  0<    
 T  P    
 U  X    
 U  `	
   
 0U  p]    
 FU   n    
 iU  #
   
 U  `%    
 U  
    
 U  O    
 U  N    
 U  0G    
 U  \
   
 U  P     U     
 	V  q     V  ,r     6V     
 LV  5    
 oV  `$    
 zV  @6   
 V  @<    
 V  \f    
 V  "d    
 V  TX
    
 V  `4   
 V  o    
 W     
 W  S`   
 'W  @   
 CW  ;    
 PW  	   
 gW  `    
 xW  
0   
 W  ^    
 W     
 W  ԉ
    
 W     
 W  ~     W  P    
 X  2
m    
 X  
j   
 ,X  %    
 >X  `%    
 LX  *   
 jX  lC    
 ~X      
 X  xr     X      
 X     
 X  H    
 X  v    
 	Y  ~
   
 Y  B    
 BY  Ps    
 PY       
 _Y  7   
 xY  @    
 Y  q
    
 Y   9    
 Y  p
6   
 Y  w    
 Y  -    
 Z  <    
 -Z  d
g    
 FZ  
    
 ]Z  m'    
 Z       
 Z  '    
 Z  x    
 Z  C   
 Z       
 Z   |
h    
 Z      
 [  Pz]    
 1[  @    
 D[   :T    
 R[  L    
 n[  0Z    
 }[  <    
 [  X(   
 [  r     [  7    
 [  	   
 [      
 [  p   
 \  M    
 \  n    
 4\  V$    
 M\  e     m\       
 \  1    
 \  ,	(   
 \  .K    
 \  ex   
 \  r   
 \      
 \  	    
 \  P}   
 ]  Џ    
 ,]  p6    
 ?]      
 N]      
 n]      
 ]  |
    
 ]      
 ]     
 ]  0(    
 ]      
 ]  pX   
 ]  }    
 
^  C9    
 )^       
 ?^  d    
 U^  q    
 n^      
 |^  E    
 ^   99    
 ^  $     ^   C!    
 ^  k    
 ^  0K     ^   I;    
 ^  _    
 
_  `    
 $_  0    
 :_  
h    
 G_  к    
 Y_      
 i_  %    
 _  @J    
 _  G    
 _  b    
 _  83   
 _  

y    
 _  з    
 `       
 !`  P%    
 3`  
Y    
 E`      
 Z`  P    
 d`  4;   
 n`  @1   
 `   r    
 `      
 `  E@    
 `      
 `  h;r   
 `     
 `  0j3    
 a  И+    
 .a      
 =a  `    
 Va  I@    
 ha     
 ~a  M    
 a  0-4    
 a      
 a  ~    
 a      
 a  ;
     
 a  %/    
 a  ^    
 b  l
,    
 b  
3    
 (b  @e
b   
 Bb  0}    
 Zb  p    
 cb  t    
 sb  p %    
 b  `]    
 b  L    
 b      
 b  0G   
 b  Lr     b      
 b  J    
 c      
 ,c  ]   
 6c  @K   
 Lc  @?'    
 lc  0]    
 zc  $-    
 c       
 c      
 c       
 c   1    
 c  @e    
 c       
 d      
 d  @    
 $d      
 4d  (      Hd  \N}   
 _d      
 qd  t
    
 d      
 d       
 d  
~    
 d  !    
 d  {    
 d  0    
 d   
    
 e  \
B    
 "e  -    
 2e  r    
 @e       
 ae  E?    
 ke  l	    
 ~e  )    
 e  PfM   
 e  d    
 e   e    
 e  @k    
 e  2    
 
f  H	    
 f  l   
 -f  r     Ff  Р/    
 Wf  P    
 kf  
    
 wf  	   
 f   %    
 f  `    
 f  <s     f  V<    
 f      
 f      
 g  :    
 g      
 *g      
 =g  p    
 Ug  $    
 ng      
 g  \F[    
 g  x$    
 g   B%    
 g  <B     g  @   
 g      
 g  01    
 h  :   
 h  r     +h  g   
 Ah      
 Oh      
 [h  L3    
 oh  kU    
 h      
 h   ||    
 h   X   
 h  `
}    
 h  >   
 h  `     
 i  6^    
 +i  0    
 @i       Ri  0   
 pi  L$    
 i  8
    
 i  F    
 i      
 i  e   
 i  \4-   
 i  
    
 i  s   
 !j       
 <j  0   
 Kj  pA    
 ]j  \r     yj  7   
 j  `    
 j  w   
 j  `3    
 j      
 j      
 j  r     	k  `Jp    
 k      
 'k  r     ?k  $
3    
 Qk  0    
 ik      
 vk       k  o     k   N    
 k  @_c    
 k  -    
 k  @
    
 k  
   
 l      
 .l  m    
 Bl  	    
 ]l      
 {l  |
I    
 l   5
    
 l  d   
 l  T~     l  0W$    
 l      
 m  0x    
 m  e    
 4m  x	    
 Qm   l#    
 nm  `G   
 m  Ft    
 m  %    
 m  ,   
 m  f%    
 m  P8?    
 m  >    
 m      
 n  в   
 0n  j3    
 Vn  m'    
 xn  s    
 n  H    
 n       
 n  P    
 n  |
S    
 n  y   
 n  1    
 o  0    
  o  ^    
 5o  h 
    
 Bo  r     ^o  p    
 |o      
 o      
 o  $G!    
 o  p    
 o  `I$     o      
 o   7   
 p  |GI    
 p  G    
 "p  @    
 ?p      
 Wp  ,
    
 dp  `     
 pp  ,s     p  ip    
 p      
 p  H
`    
 p  N%    
 p      
 p  9   
 q  q     q  P%    
 3q       
 Aq  
    
 Mq  L    
 _q  /    
 xq  5    
 q      
 q  U    
 q  `{    
 q  P>    
 q  @;   
 r  q     r      
 %r  0p%    
 <r  j    
 ]r  9    
 nr  r
g    
 r      
 r   r    
 r      
 r  @<r    
 r     
 r  P3#    
 r  d4E    
 	s  $	    
 %s  `y    
 8s  X
    
 Ks  aB    
 ]s  K(     ws       
 s  %    
 s  P    
 s  v
   
 s     
 s      
 s  u\   
 t      
 t       
 ,t  02    
 ?t  `g    
 Xt  0x    
 wt   
    
 t  0f    
 t  (
   
 t  `?    
 t  B    t  @+    
 t      
 u  @d    
 /u  s     Ju  v    
 au  	l    
 lu  pL9   
 tu  t    
 u      
 u   @0   
 u  P   
 u  O   
 u  r     v  	-    
 v  %   
 4v  57   
 Ov      
 Vv      
 sv  N   
 v  ر
s    
 v  8   
 v      
 v      
 v  `k   
 v  d    
 	w      
 0w  6%    
 Cw  `
    
 Mw  `6    
 xw  PC!    
 w      
 w  @    
 w  Hb    
 w   y    
 w     
 w  
    
 w  |Y    
 
x      
 x  $s     ;x  0+
    
 Tx  
    
 hx   
    
 {x  1    
 x  
i    
 x  >   
 x   {    
 x  
p   
 x  @6    
 
y  
t    
 y       
 ?y      
 Uy  x    
 py  <,&    
 y       
 y  %    
 y  c    
 y  0u    
 y      
 y  p    
 y  Au    
 z       
 *z  Ԣw   
 ;z       
 Gz  
@    
 \z       
 mz   /   
 z  Q	P   
 z  lo     z      
 z  o     z  %    
 z  A    
 z  <    
 {  `
   
 *{  @fQ    
 ={  `    
 Z{  R   
 g{  =
   
 y{  o    
 {  %
U    
 {      
 {  
^    
 {  	    
 {  @^g    
 {       
 |  0    
 C|  *   
 W|      
 h|  09@   
 x|  	T    
 |      
 |  @e    
 |  p>/    
 |  0%    
 |  r      }  }
Y    
 }  X
    
 )}  
    
 D}  p   
 ^}  4     q}     
 }  Jn   
 }  q     }  r     }  
    
 }     
 }  
   
 ~  X+   
 ~  K    
 :~  -    
 I~  U   
 f~  @g   
 ~  8   
 ~  s    
 ~  X
C   
 ~  p~;    
 ~   o    
 ~  yC    
 ~       
 
      
   p    
 ,  `   
 <  F    G   x    
 V  d	    
 e  p   
 ~  @    
   |$
    
   `%    
   `&    
   q       L    
   L
p    
 
  p^,    
 -  pJ    
 ;  P    
 P  `    
 f       
   ,$Z    
   :    
       
   
%    
 ǀ  r    
 ܀  %    
        
   D    
  P    
 #   W   
 @  `s    
 T  s!   
 s  `s    
    9    
   (r           
 ܁   5q    
   h       W
D   
 #  z    
 ?  P   
 b  Q    
 u   7    
       
   <    
       
   
    
 ق  d,   
   08    
       
 
  H
    
    V    
 .       
 C  L	    
 N  @k    
 a  pQ   
   ?    
   ;j    
   P    
 ˃        ݃  .J    
   H    
   ~       E%    
 %  /   
 :      
 A  M    
 G  `Q
    
 V  q
m    
 f  d    
 z  `P    
    
    
   r           
 τ  q       E   
   `B     	              
 /  @t    
 E  `,    
 V        m  @    
   T   
   VJ    
      
   T!    
 ̅       ޅ  @    
   P?p    
   ]u    
   Q<   
    ж[    
 6       
 F  P2    
 _  j    
 q  po    
 {  M    
   p,    
   X
U    
   #    
 ņ  `D     ҆  (   
   q       
l    
   <    
 %   {y    
 4  @M    
 K  g    
 a  8	    
 p  @VJ    
   K    
   
0    
   X   
   kP   
   >s   
        
   0E    
 4  s     H  0    
 Y  
   
 `      
 j   x   
 w  P     
 ~  @8    
       
   <"    
   P{    
 Ɉ  =[   
 ݈  W1    
   N	   
       
 $  س
:    
 0      
 <  
f    
 L   >    
 ]   o    
 p      
   	    
       
    $   
 Ӊ  -    
   
Q   
   x	
   
   p     
   
>   
 '  dc    
 3  0    
 R  <    
 c  0    
 ~  |Z    
   ;    
       
    W    
 ъ  
    
   [    
   @q    
   `r     :       M      
 f  .    
 t  %    
   ~*   
   5
    
       
 Ջ  03   
       
   @I    
   0:    
 6  .%    
 P  F    
 c      
 z      
   DY    
   Pb8   
       
       
   PN    
    3   
 ;  @}<    
 R  
<   
 a  0
D    
 p         p%    
   &    
   1   
 ΍  pO    
 ލ  l    
   V    
      
 #  @X9    
 ,  P>    
 C     
 R  #%    
 e  $r     z       
       
       
       
 ώ  c    
 ގ  @Am    
   8s       .    
   pr    
 6      
 W  @T    
 _  0    
 k  p
F    
   p="    
   `jC    
   ,{$    
    <3    
 ʏ  	    
 ׏  @.
    
       
   :2   
      
 3  <
    
 A  F    
 Q       
 `  p    
   @    
   S    
   Uc   
 Ð      
 ې  0(,    
     
    
       
        
 )  a    
 :  G"    
 W  q     n  pa    
       
   p    
   $    
   P{    
 Б  `N   
   P5    
   ȯ   
   :    
 "  TP    
 8  @    
 Y  @o    
 n  PH    
      
   Y    
   F    
 ʒ      
 ْ  !    
   @    
   l!   
   <    
 )  
    
 <  @    
 `     
 }  p    
   %    
   j    
       
   &
    
      
      
    	    
 &  I    
 4      
 E  Pk'    
 ^  I    
 s   Q    
   %    
   L&
R    
   `p    
 ɔ   W    
   x    
   3+    
   @F    
 !  >    
 *  x
O    
 9   ,    
 J  P   
 `      
 {  |3
    
       
   p)
    
   p$    
 ѕ       
 ܕ  X+    
    f    
       
 +  L    
 >  P<    
 N       
 b  |r     z  `z    
   o    
   dr          
 ٖ  ~I    
   `K|   
   O    
       
   W1    
 5  l,    
 V  ]    
 f  	    
 r  *   
       
       
   079   
   !t   
 ˗  d
;    
 ߗ  '
    
    %}    
   д   
   8=    
      
 .  @?    
 T      
 s  P    
   _    
    |~    
   	    
   9    
 ޘ  5       0    
   pt`    
       
 6  v    
 C  t     X   
    
 c  pm	.   
 u  
    
    b<    
       
   D   
   H
O    
 љ  P    
   
   
       
 	  \
N    
   0'    
 &  (s     @  4
Q    
 P  x	    
 [   9    
 y  ?    
   05    
   U
   
   q    
   `LG    
 Ӛ  \    
   
    
       
   y   
 2  
$    
 A  q     [  $    
 w  pB    
   K	1   
   %    
   `
,    
 ʛ      
 כ  8    
   P[   
    ~    
 0  
s    
 =  d   
 G  $    
 a  P
2   
    8    
   @Y   
   7   
   \    
 Ϝ   /8    
   `?C    
   %    
   p    
   @`    
 .  `J    
 E  i9    
 Y  /   
 i  
P    
 w  b    
   1F   
   ="    
   0s     ǝ   
!   
   ]	   
   ho       |   
    0Z?    
 .   u    
 =      
 V      
 b  r     y       
   

6   
   l    
 ɞ  >
H   
 ޞ  P    
   hr4   
       
 	  W   
 $  0c    
 9  ,
    
 E  	S   
 U  j    
 a   Bx    
 r   pn   
   ܗo   
   D   
   E    
   ~X     ɟ   ~   
 ݟ  p)    
       
   `<    
 )  p    
 M  0\k    
 l  
A    
 w  p    
      
   <d    
   $    
 Ġ  0f    
   8D     
   p    
      
 &   X@    
 A  1m    
 Z      
 p     
   %    
   E    
   l   
 ա   Ea    
   CY    
   r        p    
 (  e    
 5  $    
 I  >%    
 a  	    
 k  ;    
   Hs
   
   PG
   
   ?P   
   	    
 ʢ  s        H    
       
       
 #  %   
 :  Fi    
 E  '    
 T  `E0   
 c   j    
 s  @
a    
   .8    
   p7Q    
       
   2    
 ȣ  <J   
 ң   =f    
        
       
       
 3  0   
 N      
 a  `X;    
 }  }
    
    F   
        
 ɤ  @J    
   &    
   &z   
   <U
   
 *       
 ;  })   
 K  ?    
 \  0    
 v  Ԓ
Y    
    ]    
   ,A    
   T    
 ǥ  8^    
 ѥ  Oj   
    P    
   r       <
&    
 '  I%    
 :  !
    
 S  X	    
 h      
 {   2%    
   Xx   
   
^    
   0$    
       
 Ǧ  	W   
 Ԧ  `    
   
   
   0   
   r     ,  @F    
 5  @    
 ?  0{    
 T  s    
 v  `    
   0][    
       
   V9    
 ħ  hu	   
 ɧ  u    
    J    
      
   lc    
 /  ,    
 ?  ~     M  
    
 d  %    
   
    
   c    
   t    
   p;    
   y    
 ɨ  	    
 ը  \B           
   GE    
   h    
 /   r     D  @ 4     U  @    
 u  I    
       
   p
    
   
    
   $    
   Ќ    
 ѩ  ,
    
    /   
   $   
   <J
p    
       
 2  p    
 E  r     ]  0<    
 l  g    
   y    
       
    
   
 Ϫ  3
2    
   pw%    
   7    
 #      
 >  Ls     R  L    
 d  
    
       
    ;    
   !
n   
   p	+    
 ū  `p    
 ׫   ~4       0I    
   r    
   Y    
 +  PQ    
 ?     
 P  w    
 b  h
}    
 v  `   
   `|I   
       
   4r     ì  "G    
 ̬      
   M    
   v    
   4j    
 )  lD    
 A  
K    
 R  PP   
 f      
 }  0
u    
   (}
[    
        
 ­  
   
 ٭     
    A    
 	  <    
   %    
 3  ,%    
 K  \
    
 X      
 j  :    
    [    
   0%'    
   @s       P    
 Į  P%    
 ׮  0    
   |$|   
   WJ    
        
    @s   
 ;       
 G  P    
 V   %    
 i  0`C    
 y  X   
   x    
   @}       A    
   
    
 ʯ     
   <	    
   q       ()
    
 .  	    
 :  :    
 L  \	    
 Z  X    
 f  Xr     }  `
    
   D   
    
    
    /   
 ϰ  w    
   0d    
   Zk    
   SJ    
 #  0    
 G  @%    
 U  p    
 d      
   D4    
    S   
   s           
 ̱   .    
 ۱      
      
   P    
   O^    
 7  u    
 C      
 ]  P    
 {  "    
        
   @    
   	    
 Ų      
 ݲ  `    
   8    
   ^    
 /  	U    
 ?  Gp    
 S  `y    
 d  @
    
 ~   
F    
   7
    
   `    
   &    
 ׳  UJ    
   @b   
   (
    
   4k    
 +  p~    
 ?        P  Ts     d  8r     ~  f    
   .    
   
    
   _	    
 Ǵ  p@   
   0    
       
   _    
   ?    
 E  Xe    
 Y  
t    
 j  XF    
 {  0W    
      
   ȹ
d    
   ^    
 ǵ  pe    
   U8   
   @    
   `    
 &  pQ    
 9  0   
 M  
u    
 \      
 u  X    
   Ps       n    
   @    
 ϶  Zm    
   P    
   ~    
   4    
 "  0k    
 8   ?   
 F      
 f  @lC    
 {  `    
    B          ,    
   I     ͷ  P
   
   '    
   0   
    
>    
 $  d-    
 8  q    
 G  r   
 Y  
    
 j  H    
 {  @~z    
    (          
   `|<    
 ĸ  h
j    
 ָ  b    
   	    
   W    
 
   w   
 (  D:
B    
 A      
 I  q     ]  `s    
 v  p   
   r       +    
      
 ʹ  0v   
 ٹ       
   -    
   
   
    2    
 4  M;   
 N  0   
 ]  El    
 s  (   
    |    
   %<   
   x
Y   
   %
    
 ۺ  `*    
        
   4    
   `    
 3      
 L  l   
 a       
 l  @%    
   4   
   \O    
      
   ?    
 ߻      
   =    
   
   
         
 >  |   
 Q  P    
 l  @]e    
   $9    
   o    
    )V    
 ļ  
   
 Ѽ  w    
       
   >    
   г    
       
 0      
 M      
 g  (    
   q       3    
   04    
 ʽ  `e    
 ݽ  0B    
        
   _	T   
   t'    
 -  @"k    
 7  ,"    
 P  d    
 `  q     s  8    
   P    
          \    
 Ѿ  h
_    
   d/	   
   j   
       
 2      
 G  Jh     ]  $     n    m    
 ~  u
   
   
    
   L=   
   $D    
 ǿ  @v    
 ۿ  t~
m    
   	   
   ;    
   @B4    
 /  8
#    
 @  p    
 O  L
    
 a  0
    
 x  BV    
   @   
   {v    
       
   0   
   %    
       
   0t;    
   f   
 *  0%    
 B  `(s    
 b      
 r      
 }  =   
       
   dO    
       
   m'    
       
   pa   
 )  >    
 3  HQ    
 =  m    
 O      
 g      
   R   
    =    
       
       
   Ir    
   @v   
        
   (    
 *  $    
 <      
 R  P
   
 c  x    
 v  ]    
    s       k    
   pA    
    ;    
   0	;    
   pO    
   `L    
 
  %    
 &  P   
 >  4   
 ^     
 q  -   
   &e
   
   =   
   @   
   0    
       
   
   
       
 $  P    
 >  `_    
 S  C    
 j  ,
    
   @   
   ,    
        
   p    
   &    
   жB    
   '
   
 0       
 F   s     ^  p    
 q  x	    
   n    
   4	   
        
   d    
   *    
   3    
   Q
   
 	   |    
       
 0  r     T  L
    
 d  y    
 s  pI   
   P   
   hW	m   
   pD    
   q            
   )    
 &  pZ    
 <      
 S  .    
 h  p4    
        
   |   
   Y    
   Pk    
        
 	  @
$    
   (    
 $  PZ    
 <      
 L  G    
 a       
 {   
    
   	'    
   liX    
   ؖ
   
   9    
   
>   
       
 
  
    
    LB     5  F    
 Q  @8     q  0[i    
   
    
   %    
   2    
   r       jK    
   [   
        
   Pk    
 3  `%    
 G  
   
 ]  h
y   
 s  й    
   k    
   |   
   F    
    ~       P    
   (
k    
   "h    
   zs   
   |
    
    Q    
 0      
 I  Pl   
 c  `e    
 ~      
   U    
       
   L    
        
       
       
 -   [   
 I  `    
 _  @7
+    
 ~  0%    
   [U   
   )    
   0L    
   C	   
   
a    
   k    
   _    
 	  +
    
   
    
 -   t    
 A  s     ]   k    
 m   >f    
   T	    
   Xp    
   `@j    
   lC~    
   l   
   x   
       
   &    
   pjL    
 ,  pV2    
 @       
 O  %
    
 c  %   
 {  p    
   <.    
    .   
   &    
   
    
       
          |
]    
 "  P    
 3  \    
 D   }    
 [        j  'N    
 u  N    
   4
    
   0    
       
      
   z
   
    
{    
   j3    
 8  @    
 Z  r     s      
   peM    
       
   @g    
   w    
        
    !m   
      
   Pc%    
 -  
C    
 >      
 S  
    
 e  h	+   
 v  q       k    
   @    
   =f    
   G    
    0    
   `    
 
  jT    
   `   
 7      
 Q  П)   
 j  
   
   a
`   
   `>   
   4   
   @9"    
   D\!   
   J    
   L
    
       
   @W    
 
  R    
   _O    
 (  D    
 8  p"
   
 Q  ;   
 k  `
   
   X    
   PG<    
   tr       z?    
   `W    
 
  4    
 '  )    
 H  I     ]  ;    
 w  q    
   }    
   l   
   
    
   
^    
       
   
   
            9   
   pw    
 9  y    
 S  @@    
 c  `    
 y  =    
   SY    
   p
z    
    %    
   P    
       
   pZ-    
   
    
 (       
 ?      
 T  Z    
 c  m
,   
 w  t;    
   j    
   q        K     
       
   W    
    k'    
   m    
    */     )  P(%    
 C  
    
 V  0j^   
 t  @K    
   	u    
   @   
   v    
   Ȍ
    
   pA%    
       
   
    
    Jh       l<0   
 3        H  
   
 ^  41    
 u  B   
       
   ?    
        
   p	    
   @/   
   :
    
 "  $&
%    
 1  @u   
 @  p0<    
 L  z    
 h  P+   
   s       PLf    
   p    
       
    1    
   
    
   	u    
   I     $  
    
 2  m    
 C       
 Z  o   
 k  0   
   
    
       
   q    
   @
    
   pb   
   
    
   X   
   <	
    
 	  H    
   i    
   p    
 1  TF}    
 H  Tr     ]  P%    
 y  7    
   4    
   w%    
   7    
    -w   
      
   2    
    I    
 .  Ё	   
 =      
 W  r     l  G    
      
   e    
      
   p)    
   !   
   :   
       
 "        0  (
    
 H  0J    
 [      
 u  z?    
   O    
   Ш    
   Hk   
   	
    
   &
:    
   I       r     ,      
 K  `N    
 [  0b   
 i  ,
z    
 {      
        
   0    
   |    
       
   4
   
   @p    
   pv    
   @'    
   ~     %  \    
 =      
 J  @UT     U      
 s  `   
   S    
   r           
   X   
      
   8F   
   0n   
 #  `    
 B  @    
 Q     
 r  <
N    
   0Qt    
   z    
       
   h   
   A    
   L<    
 "  ,    
 0  0<l    
 J  
t    
 S  #?   
 [   }<    
 n     
   %    
       
   
   
   I    
   F    
   p?    
       
 (  r     @  `M    
 R  PA   
 d  c%    
 }  hy
1   
   p   
      
       
   p    
   u   
   r       Xu   
   =    
 1  `B    
 E  @z    
 b  
m    
   p    
   }    
    %    
   x	   
   @j    
       
   `
}    
 (   3v    
 8  @/k    
 N  Y]   
 f  PvB   
 ~  ~       0SV   
    y    
   $    
   q       `    
    
    
   Hr     )      
 ?  
C   
 Z  
    
 l  $L    
 {  `<]    
   Pf   
   TJ    
       
   u    
       
       
       
   d    
 &  
   
 <  @    
 Y  E    
 v  N    
   9    
   u   
   TU    
       
   ]>   
   
6    
   p    
   ,3
    
 4  ^    
 H  v    
 V  
F    
 b  
!    
 r   	   
   Z    
   r       `   
      
       
   l(    
 #       
 0  S    
 >  L   
 O  p    
 d   a\    
 |  6   
   pC    
    $    
   v   
   ,M   
       
 
  R    
 #  `N    
 0  
   
 C  R   
 Z  P    
 n  7    
 y  LK	      |
J    
   Ly
   
    6<    
   
-    
   L    
    
   
   e    
 :  r     V   <    
 l  @9    
 {  J~    
   p    
                
        
   `    
   q     !  ̊    
 A        O  BC    
 c  ~     v  `~    
   D$
7    
   
    
   b    
   l#    
       
   `    
   P$    
 #  ;    
 9  t
M   
 K  0#
    
 V      
 r  J    
   pF   
    7    
   @    
   Э    
   1   
    ;    
   @T   
   m#    
 8  *=    
 T  pv    
 l  ^    
 z  \
    
   `    
   
    
       
   P
K    
   q       |   
    N    
 '  HUY    
 E  Lm    
 N  Ef    
 d  
}    
 }  D    
   F    
   O    
   
    
   $x    
   P    
    !-    
   f   
   gw    
 *  V!    
 :  pC   
 R  `L    
 `  x&    
 s  w}    
       
   
    
   ~       J    
   r       i    
   <r     #  I    
 =  
e   
 P  @    
 a  P   
 y  (
3    
   0o#    
   0
s    
   
    
   2?    
   %    
   =    
   0
    
   
4   
 0  L3
/    
 F   B      S  Y    
 k  0    
    #   
   lX    
   :    
       
   -    
   `    
   z    
   El    
 .  I     8  GI    
 B  `    
 ]  4F    
 n  %    
   к    
   PA'    
   
'    
    J    
   %    
   Vh   
 5  J    
 O  02>    
 r  |    
   Xs       G,    
   S    
       
   /%    
   pZK    
   mu   
   
    
 (  p    
 ;  PZ?    
 U  `    
 k  N    
   P    
   8    
        
    C   
   q           
   p    
 
  
\    
       
 -   3+    
 @  `    
 ]  .    
 r  \
L    
   
g    
   P    
   @L    
   @ax    
   pf    
   x	    
   @%    
   t	H   
 $  p5+   
 C     
 ]  r     q  P    
   J
   
   6    
   @    
       
   L<    
   
    
   5%    
       
 2  N   
 G     
 X  <
    
 g  k   
 w  J    
   -    
   p@    
   p    
    !Y    
   r    
   B    
 #  P
    
 ?  p   
 T     
 n  42    
   M   
   
    
   '
    
   x    
      
   |~    
   L
h    
   4?    
   X
    
 $  
_    
 7  pr    
 R  :%    
 e  
s    
 }  |
"   
   
M    
       
       
   f-    
   m    
   #
E    
    0n    
    .%    
 4     
 I  @8   
 ^  I     t       
    I    
    %    
   L   
   V    
   aq    
       
   >   
    
]    
 .  #    
 B  7   
 T  @U    
 _  d9    
 q  

$    
   V    
          M    
   p
~   
   p9    
    [    
   Py%    
   8	*   
 &  q    
 6   o/    
 `      
 q  }    
    <
    
   v    
   
    
       
   \D    
   %    
   j    
   
   
   @	8   
 !  @    
 >       
 R  q     t  p:    
      
        
   `   
   t    
   
&    
   @;    
   B%    
 %  @p
X    
 4  X   
 R  ;
    
 m  `n    
 {     
   '    
    6    
   
!    
   ]   
   y"   
   @p    
   @    
   '    
 &  ha
v    
 4  $    
 A  0F    
 Y  0    
 r  8
A    
 |  @s    
   T   
   pB       4    
      
       
   
n    
  `m#    
 .     
  __gmon_start__ _nl_msg_cat_cntr libXi.so.6 _DYNAMIC _GLOBAL_OFFSET_TABLE_ _init _fini XFree libXext.so.6 XShapeCombineRectangles XShapeCombineMask XShapeGetRectangles XShmQueryVersion XShmAttach XShmDetach XShmCreateImage XShmPutImage XIfEvent XGetVisualInfo libX11.so.6 XAllocColorCells XAutoRepeatOn XAutoRepeatOff XSetWindowBackground XBell XSetCloseDownMode XChangeActivePointerGrab XSetWindowColormap XChangeProperty XChangeWindowAttributes XResizeWindow XCheckIfEvent XCloseDisplay XFreeGC XSync XClearWindow XClearArea XMoveResizeWindow XConvertSelection XCopyArea XCopyGC XCreateBitmapFromData XCreatePixmap XCreateGC XPutImage XCreateColormap XCreatePixmapCursor XCreatePixmapFromBitmapData XCreateSimpleWindow XCreateFontCursor XDefineCursor XDeleteProperty XDestroyWindow XDisplayName XDrawArc XDrawLine XDrawLines XDrawPoint XDrawPoints XDrawRectangle XDrawSegments XGetErrorText XSetErrorHandler XSetIOErrorHandler XGetWindowProperty XFillArc XFillPolygon XFillRectangle XLoadQueryFont XFreeFont XListFonts XFreeFontNames XFreeColormap XFreeColors XFreeCursor XFreePixmap XSetFillStyle XSetGraphicsExposures XSetSubwindowMode XGetAtomName XAllocColor XGetFontProperty XGetGeometry XGetWMHints XGetImage XCreateImage XGetKeyboardControl XGetMotionEvents XGetSelectionOwner XGetWindowAttributes XGrabKeyboard XGrabPointer XGrabServer XQueryExtension XInternAtom XConvertCase XKeysymToString XLowerWindow XServerVendor XMapWindow XMoveWindow XNextEvent XOpenDisplay XSynchronize XParseColor XPending XSetWindowBackgroundPixmap XQueryColors XQueryPointer XQueryTree XRaiseWindow XSetRegion XReparentWindow XSelectInput XSendEvent XSetBackground XSetClipRectangles XSetClipMask XSetClipOrigin XSetDashes XSetFont XSetForeground XSetFunction XSetWMHints XSetTransientForHint XSetClassHint XSetLineAttributes XSetSelectionOwner XSetStipple XSetTile XSetTSOrigin XStoreColor XStoreColors XStringToKeysym XDrawString XDrawString16 XTextExtents XTextWidth XTextExtents16 XTextWidth16 XTranslateCoordinates XUngrabKeyboard XUngrabPointer XUngrabServer XUnmapWindow XCreateWindow XGetGCValues XGetWMColormapWindows XAllocWMHints XAllocClassHint XSetWMNormalHints XSetWMIconName XSetWMColormapWindows XSetWMProtocols XFreeStringList XWithdrawWindow XCreateFontSet XFontsOfFontSet XBaseFontNameListOfFontSet XFreeFontSet XVaCreateNestedList XSetIMValues XGetIMValues XCreateIC XDestroyIC XGetICValues XSetICValues XSetICFocus XUnsetICFocus XmbLookupString XOpenIM XCloseIM XRegisterIMInstantiateCallback XUnregisterIMInstantiateCallback XSetLocaleModifiers XSupportsLocale XmbTextPropertyToTextList XwcTextPropertyToTextList XmbTextListToTextProperty XwcTextListToTextProperty XwcFreeStringList XmbSetWMProperties XmbDrawString XmbTextEscapement XmbTextExtents XwcDrawString XwcTextEscapement XwcTextExtents XFilterEvent XRefreshKeyboardMapping XLookupString libm.so.6 libdl.so.2 dlerror dlclose dlsym dlopen libc.so.6 strcpy textdomain waitpid printf __strtod_internal stdout vsprintf recv connect shmctl strerror fdopen geteuid memmove snprintf __ctype_b getenv fchmod __rawmemchr __strtol_internal usleep qsort fscanf fgets shmat memcpy pclose glob perror readlink getuid rewinddir system feof malloc iswspace endpwent optarg __bzero vsnprintf statfs __dcgettext rmdir socket select __finitef readdir __strtoul_internal fflush __ctype_toupper realpath mbstowcs lseek strncasecmp send abort chmod popen pipe __lxstat uname rename strrchr calloc write __ctype_get_mb_cur_max fprintf kill setpwent strcat bind inet_addr mkfifo __deregister_frame_info chdir __finite shmdt fseek shmget memchr stdin wait umask ferror strstr signal read strncmp strncpy unlink strcasecmp realloc __strdup _IO_getc strtok listen fork sscanf setmntent strncat execlp endmntent fread inet_aton symlink gettimeofday getopt localtime memset fnmatch ftell time opendir poll __xmknod getpwuid_r strcmp getpwuid getcwd gethostbyname strsignal getpwnam fgetc gethostname sprintf fclose atexit setlocale stderr mkstemp fputc globfree strftime localeconv getmntent fwrite access __xstat rewind __errno_location exit __fxstat bindtextdomain iswalnum fopen fileno _IO_stdin_used _exit getpwent gmtime __libc_start_main open strchr fputs execvp closedir fcntl mkdir __ctype_tolower __register_frame_info close vfprintf __finitel free getsockname _etext _edata __bss_start _end gdk_image_new_bitmap xmlNodeSetContent xmlParseElementMixedContentDecl add_dir_entry xmlValidateAttributeDecl gtk_arg_values_equal gdk_keyval_is_lower gtk_signal_add_emission_hook_full gtk_widget_restore_default_style xmlNanoHTTPReturnCode gtk_viewport_set_hadjustment loki_find_component gtk_clist_columns_autosize gtk_selection_notify gtk_drag_set_icon_pixmap gtk_tooltips_set_colors gtk_hseparator_new gtk_hbutton_box_set_layout_default g_strdup_printf g_bit_storage gtk_signal_connect_object_while_alive xmlNewTextChild gdk_window_set_icon gdk_property_get g_node_depth gtk_widget_set_scroll_adjustments gtk_statusbar_push gtk_widget_draw gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER xmlCharStrdup gtk_toolbar_set_space_size xmlDocSetRootElement gtk_range_draw_trough file_write gdk_input_remove xmlGetPredefinedEntity force_console get_md5 GTK_TYPE_GDK_COLOR gtk_button_box_set_layout file_open xmlNewParserCtxt GTK_TYPE_MENU_FACTORY_TYPE gtk_tree_get_type gdk_window_get_root_origin gtk_ctree_remove_node gdk_visual_ref gtk_accel_group_remove g_hash_table_size xmlInitParserCtxt gtk_get_event_widget xmlAddDocEntity xmlValidateNamesValue xmlAddRef xmlNewDocText gtk_menu_get_type gtk_ctree_node_set_row_style gtk_widget_grab_default xmlSaveNoEmptyTags gtk_toggle_button_get_type gdk_gc_ref gtk_clist_set_selectable g_datalist_id_set_data_full GTK_TYPE_GDK_SELECTION_TYPE GTK_TYPE_SPIN_TYPE gtk_style_apply_default_background gtk_table_attach_defaults gtk_debug_flags xmlParseElementDecl gtk_clist_set_vadjustment g_hook_next_valid gtk_paint_oval htmlnodePush GetProductMessage gtk_widget_activate gtk_marshal_NONE__POINTER_INT_POINTER gtk_args_collect_cleanup create_log gtk_clist_find_row_from_data gtk_widget_get_pointer htmlParseDocTypeDecl gdk_pixmap_create_from_data gtk_pattern_match disable_binary_path g_scanner_warn gtk_ctree_node_get_cell_type gtk_style_ref gtk_item_toggle xmlSAXParseFile gtk_ctree_find_all_by_row_data_custom gtk_accelerator_parse gtk_color_selection_get_color xmlCharStrndup g_slist_free_1 g_list_sort2 gtk_button_clicked GTK_TYPE_GDK_MODIFIER_TYPE xmlAddSibling default_font gtk_entry_set_text gzflush gtk_signal_handler_unblock_by_func gtk_ctree_find_by_row_data g_hook_compare_ids gdk_color_hash file_issymlink gtk_draw_option gtk_ctree_new file_symlink gtk_rc_style_ref GTK_TYPE_FONT_FILTER_TYPE gtk_ctree_unselect_recursive g_strcasecmp express_setup glib_micro_version gtk_radio_button_new_from_widget xmlNewDocTextLen GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY gtk_theme_engine_unref g_scanner_get_next_token xmlNanoFTPList g_hook_list_init g_string_free startDocument gtk_gc_release gtk_ruler_draw_pos GTK_TYPE_PREVIEW_TYPE GTK_TYPE_RC_TOKEN_TYPE gtk_rc_reparse_all g_main_set_poll_func deflate match_distro g_logv gdk_visual_get_best_with_both gtk_scale_draw_value gtk_color_selection_get_type gtk_marshal_INT__POINTER_CHAR_CHAR gtk_rc_init gtk_clist_remove gdk_string_to_compound_text gtk_window_reposition GTK_TYPE_BUTTON_ACTION gtk_toolbar_get_button_relief GetProductComponent g_io_channel_init gtk_radio_button_get_type loki_findpath gtk_widget_draw_default launch_game gtk_vpaned_new gtk_clist_set_column_max_width xmlParsePEReference gdk_event_mask_table getPublicId xmlStringGetNodeList close_lookup gtk_accel_group_unlock gtk_curve_get_type xmlParserInputBufferCreateFd xmlParserInputBufferGrow gtk_editable_delete_text GTK_TYPE_GDK_WINDOW_TYPE gtk_draw_handle gtk_container_child_args_collect GTK_TYPE_SUBMENU_DIRECTION gdk_root_window gtk_toolbar_prepend_space GTK_TYPE_WIDGET_FLAGS gtk_vscale_get_type gtk_main_iteration_do detect_distro g_list_push_allocator gtk_object_get_type g_memdup gtk_fixed_move gtk_rc_get_style g_io_channel_write gtk_clist_get_column_widget gtk_ctree_node_set_foreground g_string_up gtk_hbutton_box_get_type gzgetc gtk_invisible_new g_thread_use_default_impl gtk_type_describe_tree gtk_menu_item_deselect loki_registerscript GTK_TYPE_CORNER_TYPE gtk_calendar_select_month gtk_ruler_get_type gtk_quit_remove_by_data gtk_aspect_frame_set gtk_widget_unrealize gtk_accelerator_set_default_mod_mask xmlCreatePushParserCtxt gtk_widget_get_composite_name md5_init run_command gdk_im_end gtk_alignment_new motif_top_level_leave loki_getnextproduct GetDefaultPath gtk_toggle_button_toggled xmlParserError gtk_rc_add_default_file abort_install g_list_alloc gdk_window_lower gtk_widget_accelerator_signal g_slist_concat gtk_drag_finish gtk_widget_new gtk_quit_add gtk_draw_extension gtk_scrolled_window_get_type gtk_range_default_hmotion console_okay gtk_signal_handlers_destroy g_main_pending glade_xml_get_type htmlDecodeEntities xmlNewInputFromFile gtk_object_remove_no_notify gtk_tree_unselect_item gtk_signal_handler_pending xmlSplitQName gdk_window_at_pointer gdk_exit isolat1ToUTF8 g_list_position gtk_preview_get_info gdk_gc_set_font xmlDefaultSAXLocator loki_getoption_file gtk_text_get_type gtk_tree_append gtk_vpaned_get_type xmlSAXParseDTD gtk_toggle_button_get_active gtk_adjustment_changed gtk_calendar_get_date gtk_widget_newv g_strtod setup_button_warning_continue_slot gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT gtk_range_draw_step_back gdk_pixmap_create_from_xpm gtk_paned_set_position gtk_toolbar_prepend_item gtk_ctree_is_hot_spot gdk_input_exit gtk_widget_set_extension_events GTK_TYPE_OBJECT_FLAGS gtk_object_getv g_dirname gtk_gamma_curve_new xmlNodeSetContentLen htmlParseComment gtk_spin_button_set_numeric g_strdown xdnd_send_xevent g_module_supported htmlParseCharData xmlParseBalancedChunkFile gdk_screen gtk_container_resize_children gtk_clist_set_column_width copy_list gdk_window_withdraw g_io_add_watch xmlNanoFTPConnect _tr_flush_block g_main_iteration g_int_hash gtk_range_draw_slider gdk_window_get_geometry g_slist_reverse g_hash_table_freeze detect_diskspace xmlParseEncName gtk_preview_new gtk_scrolled_window_new gtk_handle_box_set_shadow_type xmlBufferCCat gtk_spin_button_set_wrap xmlNewEntityInputStream gtk_notebook_append_page_menu gtk_misc_set_alignment GTK_TYPE_STATE_TYPE xmlCreateEntitiesTable loki_setroot_product xmlNanoHTTPClose loki_getpath_file xmlParseLookupSequence g_scanner_error gtk_object_arg_set gtk_editable_copy_clipboard log_init ignorableWhitespace gtk_progress_bar_update gzopen gtk_clist_column_titles_active gtk_drawing_area_new glade_xml_push_accel FreePlugins zlibVersion gtk_draw_oval gtk_widget_show gdk_time_get htmlSAXParseFile gtk_draw_tab setup_button_cancel_slot gtk_window_add_accel_group gtk_main_level gdk_input_motion_events set_cdrom_mounted glade_xml_pop_uline_accel loki_setmode_file gtk_text_set_point g_scanner_sync_file_offset gtk_spin_button_update install_preinstall loki_remove_component motif_drop_start g_datalist_clear gzerror gdk_cursor_destroy gtk_target_list_ref gtk_clist_set_pixmap gtk_paint_string get_option_name gtk_menu_bar_append xmlCreateDocParserCtxt g_datalist_id_remove_no_notify gtk_paint_hline gtk_ctree_post_recursive_to_depth gtk_quit_remove match_arch xmlGetDocEntity g_strup gtk_notebook_get_tab_label gtk_signal_handler_unblock_by_data motif_find_drag_window gdk_selection_property_get GTK_TYPE_GDK_RGB_DITHER GTK_TYPE_GDK_WINDOW_CLASS gdk_wm_take_focus GTK_TYPE_TOOLBAR_STYLE gtk_notebook_get_current_page GTK_TYPE_GDK_EVENT g_list_insert xmlNanoFTPCheckResponse poll_lookup gtk_rc_parse GetProductCDROMRequired xmlDoValidityCheckingDefaultValue gdk_rectangle_intersect gtk_tree_unselect_child gtk_widget_event gtk_item_deselect gdk_gc_destroy gdk_draw_rgb_image_dithalign GetProductHasNoBinaries gtk_file_selection_set_filename connect_url gtk_tree_item_remove_subtree xmlCopyDoc xmlParseSystemLiteral g_static_private_set loki_enumerate_files gtk_toggle_button_set_active log_warning xmlCopyDtd gtk_toolbar_set_orientation xmlRemoveRef gtk_type_is_a gtk_main_do_event select_corrupt_options gdk_gc_copy gdk_text_height gtk_notebook_prepend_page_menu xmlBufferCat binary_path_combo_change_slot xmlNamespaceParseNSDef gdk_colors_store gtk_radio_menu_item_group g_strdelimit xmlParseEnumerationType gtk_tree_prepend GTK_TYPE_CURVE_TYPE xmlParserVersion gtk_clist_get_pixmap xmlEncodeEntitiesReentrant g_cache_destroy gtk_accel_group_create_add xmlElemDump xmlNewStringInputStream gtk_hbox_new gtk_widget_popup gdk_pointer_is_grabbed GTK_TYPE_CTREE_POS gtk_progress_get_current_percentage g_mutex_init gtk_radio_button_set_group file_skip gdk_event_peek glade_xml_get_parent_accel gtk_accel_group_lock_entry xmlCopyElementContent inflate_trees_free gtk_tree_item_collapse gtk_preview_set_install_cmap gtk_menu_item_new_with_label GTK_TYPE_WINDOW_TYPE gdk_query_depths xmlNewDocNode gtk_clist_get_cell_style gtk_statusbar_get_type gdk_wcstombs inflate xmlParseBalancedChunkMemory gtk_marshal_BOOL__NONE g_strescape gtk_text_get_point gtk_accel_group_entries_from_object GTK_TYPE_SIDE_TYPE gtk_pattern_match_simple gtk_clist_unselect_all glade_xml_handle_label_accel gdk_cursor_new loki_getfirst_option gdk_color_parse gtk_toolbar_append_widget gtk_button_box_get_child_size gtk_check_menu_item_toggled g_completion_add_items FindPluginForFile g_byte_array_remove_index gtk_hbutton_box_set_spacing_default gtk_marshal_NONE__NONE gtk_container_child_arg_get_info gdk_im_open g_tree_remove gdk_font_load xmlParseDefaultDecl gtk_object_constructed gtk_accel_label_get_accel_width loki_getversion_component xmlCreateElementTable gtk_list_unselect_child gtk_widget_push_colormap htmlIsAutoClosed xmlNewReference GTK_TYPE_SIGNAL_RUN_TYPE gdk_rgb_set_min_colors add_corrupt_file gtk_scrolled_window_set_placement gtk_widget_show_all gdk_window_raise gtk_calendar_get_type xmlValidateDocument g_slist_push_allocator g_node_last_child gdk_window_unref UTF8ToUTF16 g_io_add_watch_full gtk_pattern_spec_init glade_register_widgets setup_close_view_readme_slot gtk_ctree_node_set_pixtext xmlSAXParseMemory xmlNanoFTPGet g_node_unlink xmlParseContent gtk_init_add gdk_drag_get_selection gtk_style_unref xmlValidateNotationDecl file_mknod destroy_log xmlValidateDtd deflateSetDictionary g_ptr_array_set_size gtk_signal_connect_full InitPlugins xmlValidateElementDecl setup_button_license_agree_slot gtk_window_set_geometry_hints gdk_gc_set_function gtk_toolbar_set_space_style xmlDetectCharEncoding xmlBufferLength GTK_TYPE_GDK_FUNCTION gtk_font_selection_dialog_set_font_name gtk_combo_set_use_arrows_always xmlAddPrevSibling copy_binary gdk_window_get_events gtk_draw_hline gtk_ctree_export_to_gnode reference g_strjoinv gtk_preview_get_type gtk_window_activate_default gdk_window_register_dnd _fp_hw g_scanner_scope_remove_symbol gtk_ctree_node_set_selectable gtk_scrolled_window_set_vadjustment gtk_list_remove_items_no_unref g_tree_search gdk_char_height gtk_tree_item_get_type gtk_button_box_set_spacing xmlRegisterCharEncodingHandler GTK_TYPE_GDK_LINE_STYLE htmlSAXParseDoc loki_getmessage_component GetDesktopInstall xmlNanoHTTPSave xmlParserInputRead xmlSAXUserParseFile g_strfreev xmlNanoFTPConnectTo GetProductEULA gtk_window_add_embedded_xid gtk_hbox_get_type xmlParseMarkupDecl xmlScanName gtk_draw_focus gtk_container_unregister_toplevel gtk_menu_item_activate g_node_find xmlValidateElementTypeElement g_completion_free gtk_widget_get_colormap gtk_selection_clear GTK_TYPE_CTREE_NODE motif_motion gdk_input_window_get_pointer glade_xml_signal_connect_data xmlParseStartTag parse_line gtk_widget_hide_on_delete gdk_keyval_to_upper gtk_arg_type_new_static gdk_screen_width_mm gzsetparams gtk_text_set_line_wrap gtk_ruler_set_range gtk_container_foreach gdk_event_put gtk_tree_item_expand gdk_window_foreign_new xmlParseEntityRef add_mounted_entry g_strsignal gtk_layout_get_vadjustment xmlBufferWriteChar gtk_signal_handler_pending_by_id gtk_notebook_page_num g_node_children_foreach gtk_progress_get_value gdk_events_pending gtk_draw_ramp gtk_menu_item_set_placement gdk_rgb_get_cmap gtk_selection_owner_set xmlNewDocRawNode gtk_signal_add_emission_hook gtk_clist_insert gdk_rgb_ditherable gtk_marshal_BOOL__POINTER gtk_hruler_new gdk_image_init xmlSetExternalEntityLoader g_string_insert_c gtk_clist_get_column_title gtk_list_select_item g_hook_unref gtk_widget_set_name g_scanner_scope_lookup_symbol gdk_window_get_deskrelative_origin gtk_menu_detach gtk_clist_set_hadjustment gdk_input_set_source nodePop g_hook_list_invoke_check gtk_draw_diamond htmlParseSystemLiteral mounted_filesystems gtk_progress_set_value g_strchug gtk_invisible_get_type loki_unregister_script loki_getname_option gtk_rc_style_new gdk_drag_abort gtk_clist_prepend htmlnamePush gdk_window_set_icon_name gtk_arg_to_valueloc gtk_clist_select_all gdk_input_ignore_core gdk_window_set_title gtk_button_box_get_spacing gtk_hruler_get_type motif_drag_status g_scanner_peek_next_token htmlStartClose gtk_type_new htmlCreatePushParserCtxt xmlParserInputBufferCreateFilename gtk_marshal_BOOL__POINTER_INT_INT GetPreInstall gtk_ctree_node_moveto gtk_marshal_NONE__POINTER_POINTER_INT_INT gtk_widget_set_parent gtk_container_set_focus_child gtk_frame_new glade_widget_tree_ref g_quark_to_string gtk_accel_label_new g_tree_destroy htmlnodePop GTK_TYPE_MATCH_TYPE g_quark_try_string gdk_draw_rgb_32_image is_fs_mounted GTK_TYPE_PACK_TYPE gdk_rgb_gc_set_background g_hash_table_remove gtk_menu_set_tearoff_state gtk_rc_find_pixmap_in_path gdk_wm_window_protocols inflate_fast gtk_ctree_set_expander_style glade_xml_get_widget g_module_error xmlGetDtdAttrDesc gtk_notebook_set_tab_pos gtk_preview_set_color_cube g_slist_last gtk_marshal_NONE__C_CALLBACK_C_CALLBACK gtk_object_class_user_signal_newv gtk_drag_unhighlight htmlParseCharRef file_eof gtk_scale_set_digits gdk_visual_get_system gtk_button_pressed xmlValidateOneAttribute xmlFreeElementTable gtk_paint_diamond gdk_color_context_get_pixel gtk_dialog_new gtk_binding_entry_add_signal g_scanner_stat_mode gdk_window_clear_area g_list_insert_sorted gtk_menu_popdown gtk_grab_get_current xmlParseInternalSubset GTK_TYPE_GDK_NOTIFY_TYPE gtk_packer_set_child_packing gdk_ic_set_attr g_node_n_nodes glib_major_version xmlNewCDataBlock GTK_TYPE_GDK_FILTER_RETURN gtk_vseparator_new gtk_progress_configure delete_cdrom_install setup_button_exit_slot gtk_signal_handler_block gtk_vbox_get_type gtk_spin_button_get_adjustment htmlnamePop g_scanner_eof gtk_ruler_draw_ticks gtk_table_attach GTK_TYPE_CTREE_EXPANDER_STYLE xmlFreeEntity gtk_fixed_get_type size_tree distribution_name gtk_editable_set_editable gtk_widget_set_events g_slist_position setup_destroy_view_readme_slot html40EntitiesTable xmlNanoFTPGetResponse add_file_entry gtk_radio_button_new_with_label gtk_box_pack_start_defaults g_completion_clear_items gtk_rc_parse_state gdk_threads_mutex gtk_clist_column_titles_show inflate_flush gtk_clist_set_column_justification g_spaced_primes_closest gtk_ctree_node_set_row_data loki_unregister_path g_mem_check gtk_type_get_varargs_type gtk_range_default_hslider_update xmlNanoFTPProxy gtk_vscale_new gdk_colormap_lookup g_array_free xmlValidateOneElement xmlAddNotationDecl gtk_ctree_node_get_pixtext glade_xml_get_widget_by_long_name gdk_colormap_change gtk_object_unref gtk_object_get_data gtk_widget_show_now gtk_paned_add2 gtk_selection_add_target gtk_menu_shell_insert gdk_image_destroy gdk_text_extents_wc gtk_packer_set_default_pad gtk_spin_button_set_digits gtk_font_selection_get_font_name gtk_object_set_data GTK_TYPE_DEST_DEFAULTS gtk_tree_select_item xmlParseElement GetPostUnInstall gtk_event_box_get_type gtk_notebook_set_tab_hborder xmlNanoFTPCleanup gtk_binding_parse_binding gdk_visual_unref gtk_packer_new gtk_progress_get_type gtk_accel_group_new gtk_tooltips_disable gdk_window_get_user_data gdk_color_context_free_dither gdk_gc_set_clip_region gtk_clist_set_compare_func g_snprintf gtk_marshal_NONE__INT gtk_radio_menu_item_get_type gtk_scale_set_value_pos xmlNanoHTTPFetch htmlAutoClose xmlFreeNotationTable gdk_color_context_new_mono push_curdir gdk_rgb_gc_set_foreground gtk_selection_request gtk_button_enter gtk_spin_button_spin xmlGetNsList gtk_propagate_event gtk_preview_set_expand gtk_text_set_word_wrap gtk_drag_get_data gtk_widget_set_visual growBuffer gtk_radio_button_group g_mem_init gtk_widget_queue_draw gdk_window_merge_child_shapes gtk_container_child_composite_name gtk_ctree_set_show_stub xmlNodeIsText pop_curdir gtk_option_menu_get_menu gtk_gamma_curve_get_type md5_compute gtk_signal_remove_emission_hook xmlParseEndTag setup_entry_binarypath_slot loki_registerscript_fromfile g_ptr_array_remove gdk_ic_get_events gtk_notebook_set_page gtk_item_get_type g_datalist_foreach gtk_combo_new xmlGetID startElement g_hash_table_new gtk_progress_bar_set_orientation gtk_rc_parse_string gtk_container_add g_string_new gtk_widget_get gdk_keyval_from_name gtk_ctree_set_node_info gtk_container_forall gdk_input_gxid_port gtk_menu_shell_activate_item GTK_TYPE_GDK_COLORMAP g_scanner_input_text GTK_TYPE_MENU_DIRECTION_TYPE g_hash_table_foreach xmlParseEntityValue UI xmlParseStringCharRef gtk_range_draw_step_forw g_strnfill gtk_accel_group_handle_add gdk_draw_text_wc gtk_ctree_node_set_text delete_install xmlValidateDocumentFinal gdk_default_filters gdk_gc_unref gdk_use_xshm gtk_list_toggle_focus_row gtk_calendar_unmark_day gtk_menu_shell_append gtk_check_button_get_type xmlStrstr gdk_visual_get_best gtk_range_default_vtrough_click xmlDocDump xmlPushInput gtk_clist_set_cell_style gtk_widget_push_composite_child gtk_target_list_new xmlValidGetValidElements gtk_scrolled_window_get_hadjustment xmlNewDoc gtk_notebook_set_tab_label_packing g_main_is_running gtk_vbutton_box_get_layout_default gtk_exit gtk_style_attach gtk_toolbar_set_style gtk_hbutton_box_get_layout_default gtk_clist_set_background gtk_table_get_type characters gdk_char_measure gtk_type_parent gtk_list_item_new create_install gdk_nevent_masks gtk_type_parent_class GTK_TYPE_DEBUG_FLAG GTK_TYPE_WINDOW_POSITION xmlParseAttributeType gtk_font_selection_dialog_get_font g_list_nth gtk_calendar_display_options gtk_check_button_new_with_label gtk_rc_load_image g_list_sort xmlNanoFTPNewCtxt gtk_arg_get_info gtk_paint_check open_lookup gtk_rc_parse_color gtk_ctree_collapse_to_depth gdk_font_ref loki_upgrade_uninstall g_ptr_array_free xmlEncodeEntities gtk_object_remove_data gtk_window_set_transient_for xmlDumpNotationTable gtk_table_resize gdk_display gtk_widget_pop_visual xmlDocDumpMemory xmlCopyEntitiesTable gtk_misc_get_type gtk_arrow_set setup_button_view_readme_slot g_node_last_sibling gtk_accel_groups_activate GTK_TYPE_TOOLBAR_SPACE_STYLE gtk_signal_n_emissions gtk_curve_get_vector gdk_window_clear gdk_draw_indexed_image xmlAddAttributeDecl gtk_notebook_query_tab_label_packing gdk_draw_line gdk_font_equal htmlCreateFileParserCtxt gtk_widget_get_extension_events xmlNewElementContent gtk_vbutton_box_set_layout_default gtk_style_detach gtk_widget_get_toplevel gtk_clist_new_with_titles gtk_frame_set_shadow_type xmlParserValidityWarning loki_getname_component gtk_marshal_NONE__POINTER_INT_INT gtk_draw_shadow_gap gtk_radio_menu_item_new xmlParseStringName gtk_notebook_reorder_child gdk_draw_lines xmlCreateEnumeration gtk_window_set_modal g_scanner_scope_foreach_symbol free_mounted_cdrom gdk_timer_set gtk_box_query_child_packing gtk_button_new glade_xml_construct htmlParseTryOrFinish GTK_TYPE_GDK_FILL g_idle_remove_by_data xmlStringLenGetNodeList gtk_type_unique gtk_text_set_adjustments g_basename gtk_selection_add_targets gtk_toolbar_append_space glade_xml_build_extended_widget g_dataset_destroy gdk_input_init xmlParseChunk gdk_image_get_pixel gtk_tooltips_force_window gtk_menu_attach_to_widget gdk_draw_points xmlFreeDoc gtk_widget_set_style gtk_widget_ensure_style g_timeout_add_full gdk_char_width gtk_widget_get_default_colormap gtk_drag_source_unset setDocumentLocator gtk_tree_select_child gtk_drag_begin g_list_reverse gtk_ctree_node_get_pixmap g_string_insert gtk_tree_set_view_lines glade_xml_get_widget_prefix gtk_signal_disconnect gdk_gc_set_background gtk_binding_entry_remove gtk_type_free g_list_copy gdk_init g_threads_got_initialized gdk_threads_enter gdk_draw_point xmlPredefinedEntities gdk_pixmap_ref gtk_toolbar_set_tooltips gtk_range_draw_background gtk_window_set_policy notationDecl g_string_sprintfa gtk_signal_emit gtk_font_selection_get_type gtk_object_class_add_signals gtk_list_item_deselect g_string_append_c xmlParserHandleReference xmlNewChild gtk_ctree_node_get_text gtk_adjustment_set_value gtk_list_get_type xmlCreateRefTable gtk_container_remove print_log get_cdrom gtk_drag_dest_handle_event gtk_clist_get_hadjustment g_hook_alloc gtk_object_init_type gtk_arg_copy xmlDecodeEntities gdk_ic_new gtk_marshal_BOOL__POINTER_POINTER_INT_INT gtk_widget_pop_style glade_tree_get gtk_type_enum_find_value glade_xml_gettext gtk_widget_class_path gtk_object_weakunref gtk_item_select gztell gtk_type_enum_get_values g_hook_free xmlLoadExternalEntity inflateSyncPoint g_node_insert xmlDocGetRootElement xmlNodeSetLang xmlNanoFTPCloseConnection gtk_window_set_position log_exit gtk_paint_focus g_list_index gtk_button_set_relief g_tree_lookup gtk_menu_item_configure gtk_widget_unparent GTK_TYPE_PACKER_OPTIONS gtk_alignment_set gtk_widget_destroyed gtk_signal_emit_stop_by_name copy_tree g_log_default_handler gtk_notebook_set_tab_label_text g_list_remove GetProductUpdateURL gdk_cursor_new_from_pixmap g_tree_traverse gtk_clist_thaw gtk_notebook_remove_page gtk_timeout_add gdk_string_measure g_slist_insert_sorted gdk_flush gtk_widget_path gdk_input_gxid_host glade_xml_build_widget gtk_menu_item_new hasInternalSubset path_combo_change_slot gdk_window_get_children endElement xmlParserInputShrink gdk_window_add_filter gtk_preview_size g_hook_list_marshal_check xmlNanoFTPQuit g_slist_foreach gtk_arg_reset gtk_signal_handler_block_by_data xmlStrdup xmlInitNodeInfoSeq gdk_wm_protocols_filter gdk_color_context_query_colors gtk_option_menu_new gdk_xid_table_insert gtk_menu_shell_deselect gtk_menu_item_get_type xmlSAXParseDoc xmlParseAttValue GTK_TYPE_GDK_VISUAL_TYPE g_strdup_vprintf g_hook_destroy_link xmlCopyProp xmlParseVersionInfo gtk_hscrollbar_get_type gtk_draw_cross GTK_TYPE_SELECTION_DATA gtk_toolbar_append_item gtk_signal_query _tr_stored_block gdk_timer_get gtk_arg_name_strip_type loki_register_file gtk_widget_get_ancestor gdk_window_set_functions gtk_window_set_default_size xmlStrcmp GetPreUnInstall gtk_box_get_type static_plugins gtk_ctree_set_line_style gtk_tree_item_new gtk_arg_info_equal expand_home GTK_TYPE_GDK_INPUT_CONDITION gtk_selection_convert gtk_clist_new g_cache_new gdk_property_delete g_node_child_index gdk_event_send_client_message gtk_menu_set_accel_group g_strjoin gtk_combo_set_case_sensitive glade_xml_signal_connect gtk_list_start_selection gdk_input_window_destroy gdk_window_set_hints gtk_minor_version gtk_accel_group_handle_remove glade_enum_from_string xmlNewDocProp GetProductNumComponents gtk_widget_get_events gtk_option_menu_set_menu htmlParseChunk xmlNodeGetContent gtk_scrolled_window_set_hadjustment gtk_table_set_col_spacings g_string_erase gtk_arg_info_hash GTK_TYPE_PROGRESS_BAR_STYLE gtk_window_remove_embedded_xid gtk_selection_data_set gtk_menu_popup gtk_label_new gtk_draw_arrow glade_init_gtk_widgets GTK_TYPE_GDK_SELECTION gdk_atom_name gtk_signal_init GTK_TYPE_SELECTION_MODE xmlNodeAddContent gtk_widget_pop_colormap inflateInit_ glib_binary_age _gtk_private_n_signals gtk_window_new gtk_object_remove_no_notify_by_id GetAutoLaunchURL gtk_clist_set_text gdk_window_add_colormap_windows gtk_progress_set_percentage gtk_hbutton_box_new xmlParserFindNodeInfoIndex gdk_event_get_graphics_expose xmlCopyEnumeration xmlAllocParserInputBuffer xmlParseEnumeratedType gdk_dnd_cursorinfo gtk_toolbar_insert_space gtk_widget_set_colormap gtk_layout_set_hadjustment gtk_idle_add_priority xmlSubstituteEntitiesDefault gtk_marshal_NONE__C_CALLBACK gtk_box_pack_end gdk_pixmap_colormap_create_from_xpm gtk_window_get_type gtk_notebook_insert_page_menu gtk_scale_get_type g_malloc0 gdk_beep gtk_accel_group_detach gdk_window_set_geometry_hints gtk_marshal_BOOL__POINTER_INT_INT_INT gtk_marshal_NONE__INT_INT_POINTER gtk_ctree_set_drag_compare_func g_slist_remove gdk_string_height gtk_list_child_position xmlFreeEnumeration gtk_widget_set_uposition gdk_xid_table_remove gtk_text_thaw g_node_insert_before xmlNewNsProp GTK_TYPE_GDK_SUBWINDOW_MODE gtk_accel_group_create_remove gtk_font_selection_new gtk_hscale_new xmlStrchr gtk_signal_n_emissions_by_name distribution_symbol gtk_signal_new gtk_rc_style_unref glade_xml_ensure_accel xmlStrlen gtk_clist_column_titles_hide gtk_widget_modify_style getNamespace detect_arch GTK_TYPE_GDK_DRAG_ACTION file_create_hierarchy gdk_window_move_resize xmlAddDtdEntity gtk_handle_box_get_type gdk_rgb_get_visual gtk_frame_set_label GTK_TYPE_RELIEF_STYLE gtk_menu_shell_get_type g_set_prgname xmlCopyNode g_io_channel_read gdk_colormap_alloc_color gtk_font_selection_dialog_get_font_name gdk_rectangle_union gdk_window_set_transient_for gdk_window_get_visual g_strndup g_mem_chunk_alloc GTK_TYPE_METRIC_TYPE g_slist_free gtk_scrollbar_get_type gtk_widget_get_child_requisition gdk_get_use_xshm xmlFreeElementContent gdk_font_unref gtk_paint_tab gdk_window_copy_area gtk_editable_get_position gtk_calendar_thaw gdk_input_set_axes inflate_blocks_free GetProductCDROMDescriptions g_node_is_ancestor xmlNanoFTPFreeCtxt g_node_max_height xmlPredefinedEntityValues gtk_spin_button_configure gtk_dialog_get_type gtk_selection_data_copy xmlAddElementDecl on_class_continue_clicked gdk_im_ready gdk_colormap_sync gtk_ctree_set_spacing g_list_length gtk_label_get_type gtk_object_get_user_data gtk_scrolled_window_set_policy xmlSprintfElementChilds g_array_insert_vals generate_uninstall gtk_button_box_set_child_ipadding_default cpio_plugin deflateInit_ gtk_binding_set_activate gtk_accel_groups_from_object GTK_TYPE_GDK_WM_DECORATION gtk_list_prepend_items g_hook_ref adler32 gtk_menu_get_attach_widget gtk_ctree_collapse gtk_notebook_set_menu_label gtk_packer_add_defaults gtk_text_forward_delete GTK_TYPE_GDK_WINDOW_HINTS xmlClearNodeInfoSeq gtk_accel_label_refetch gtk_notebook_set_show_tabs zcfree gtk_ctree_node_get_row_style gtk_object_new attributeDecl htmlParseAttribute gtk_progress_get_current_text gtk_container_set_resize_mode gtk_widget_size_allocate gtk_tooltips_new gtk_file_selection_show_fileop_buttons gtk_frame_get_type getEntity gtk_font_selection_dialog_set_preview_text gdk_threads_leave gtk_window_set_wmclass log_debug write_log g_get_tmp_dir gtk_widget_set_composite_name gtk_clist_get_cell_type g_scanner_cur_value gdk_event_get GTK_TYPE_GDK_COLOR_CONTEXT_MODE gtk_clist_get_selectable g_hook_list_marshal gtk_clist_row_move gdk_event_handler_set xmlInitCharEncodingHandlers run_script gtk_ctree_node_get_row_data htmlParseName gtk_font_selection_dialog_get_preview_text htmlAutoCloseTag gtk_progress_get_text_from_value g_hook_find_func_data gtk_layout_set_vadjustment xmlClearParserCtxt gdk_text_width gtk_vscrollbar_get_type gtk_quit_add_destroy gtk_paint_slider gtk_arg_new gtk_accel_group_get_default glade_xml_signal_autoconnect_full gtk_layout_move xmlParseCharData g_list_last xmlCopyNamespaceList gtk_signal_emitv enable_option_recurse xmlParseReference rc_files gtk_draw_shadow _gtk_private_signals gtk_radio_button_new_with_label_from_widget g_slist_copy loki_getfirst_component gtk_bindings_activate gtk_input_add_full gtk_drag_source_handle_event detect_cdrom g_mem_chunk_clean gtk_range_get_adjustment xmlBufferFree g_quark_from_string xmlCreateIDTable xmlSetBufferAllocationScheme gtk_object_remove_data_by_id gtk_clist_set_column_resizeable gtk_font_selection_set_preview_text gtk_ctree_sort_node gtk_menu_bar_new g_mem_chunk_new xmlFreeNs gtk_drag_source_set_icon gtk_ctree_node_is_visible gdk_key_repeat_restore gtk_widget_get_default_style GTK_TYPE_GDK_PROP_MODE xmlCreateAttributeTable xmlParserWarning xmlFindCharEncodingHandler gtk_list_extend_selection unix_channel_funcs xmlParseNotationType xmlNamespaceParseNCName GTK_TYPE_ATTACH_OPTIONS GTK_TYPE_GDK_EVENT_TYPE xmlNewText gdk_window_new htmlDefaultSAXHandlerInit gtk_toolbar_insert_element gtk_accel_group_unlock_entry GetProductDesc gdk_color_context_get_pixels gdk_event_send_client_message_to_all_recurse gdk_ic_destroy gtk_tree_new htmlParseHTMLName exit_setup gtk_viewport_get_hadjustment g_scanner_set_scope gtk_text_new gtk_notebook_new gtk_widget_unref gdk_draw_string uz2_plugin gtk_type_query xmlParseMemory gtk_range_set_adjustment motif_check_dest xmlBufferCreate gtk_check_menu_item_get_type gdk_visual_lookup GTK_TYPE_ACCEL_FLAGS glade_set_custom_handler UTF8Toisolat1 gtk_handle_box_set_handle_position g_tree_nnodes gtk_window_set_title gtk_ctree_is_ancestor gtk_signal_connect_object_after namePop g_string_chunk_new gdk_draw_rectangle gtk_combo_get_type gtk_paint_shadow_gap gtk_hscale_get_type gtk_type_class tar_plugin gtk_text_backward_delete gtk_widget_set_app_paintable gtk_calendar_freeze gtk_widget_remove_accelerators gtk_paint_box_gap gdk_bitmap_create_from_data GTK_TYPE_VISIBILITY gtk_progress_get_percentage_from_value gtk_font_selection_dialog_new gtk_combo_string_key xmlNanoFTPScanProxy gtk_tree_set_selection_mode gtk_signal_handler_pending_by_func gtk_entry_get_text g_io_channel_ref g_hash_table_lookup gdk_im_close gdk_drag_context_unref gdk_gc_set_line_attributes xmlParseCharRef gtk_theme_engine_ref g_list_free xmlGetLastChild gdk_rgb_set_install gtk_menu_bar_prepend xmlFreeDtd gdk_error_trap_pop gtk_spin_button_set_adjustment gtk_button_box_get_child_ipadding_default glade_xml_new gtk_adjustment_new gdk_leader_window gdk_image_put_pixel gtkui_okay gdk_null_window_warnings gtk_toolbar_new xmlParsePubidLiteral zError crc32 xmlNanoFTPInit xmlNanoFTPClose loki_getsize_option gtk_widget_push_style xmlCopyNodeList GTK_TYPE_GDK_PROPERTY_STATE gtk_menu_set_title GTK_TYPE_POLICY_TYPE gtk_box_pack_start current_component gtk_micro_version gtk_binding_set_new gtk_text_set_editable g_slist_nth_data gdk_selection_property gtk_ctree_select_recursive gtk_widget_realize g_set_message_handler md5_final set_symlinkspath g_log_domain_glib log_normal g_mem_chunk_print gtk_button_get_relief gtk_widget_map gdk_window_set_cursor gdk_window_init gtk_rc_get_default_files gdk_gc_set_dashes file_read loki_setupdateurl_product gtk_notebook_prepend_page xmlTextMerge namePush inflate_mask htmlParseEndTag GTK_TYPE_CLIST_DRAG_POS xmlRemoveProp gtk_tree_item_new_with_label gdk_color_copy loki_setprefix_product gtk_get_current_event xmlNewGlobalNs g_set_warning_handler gtk_accel_group_get_entry xmlFreePropList gzseek gdk_color_context_get_pixel_from_palette xmlStringDecodeEntities gtk_radio_menu_item_set_group gdk_visual_get_best_with_type GTK_TYPE_GDK_TARGET gtk_ctree_expand gzread detect_os xmlParseName _start gdk_drag_context_ref loki_create_option gdk_screen_width dir_is_accessible inflate_trees_fixed gtk_toolbar_insert_widget xmlParseExternalSubset gtk_list_remove_items endDocument g_list_find xmlFreeNotation gdk_list_visuals gtk_paint_flat_box gtk_container_set_border_width xmlRecoverMemory gtk_drag_set_default_icon gtk_ctree_node_set_shift gtk_layout_new GetLocalURL xmlParseEncodingDecl gtk_container_check_resize xmlAddID size_readme gtk_clist_set_column_min_width gdk_ic_get_style gtk_range_clear_background gtk_menu_get_accel_group gtk_accel_group_ref gdk_text_width_wc gdk_window_get_size gtk_clist_get_selection_info g_node_new gtk_widget_unlock_accelerators GTK_TYPE_PROGRESS_BAR_ORIENTATION glib_interface_age gtk_selection_remove_all g_bit_nth_lsf gtk_list_toggle_add_mode gdk_colormap_free_colors xmlFreeParserInputBuffer g_string_chunk_insert gtk_range_default_htrough_click gtk_ctree_post_recursive gdk_pixmap_unref g_module_make_resident gtk_drawing_area_get_type g_list_remove_link gdk_gc_new_with_values gtk_paned_set_handle_size glade_widget_tree_parse_memory size_list loki_registerscript_fromfile_component gtk_vbutton_box_set_spacing_default gtk_type_children_types gtk_toggle_button_set_mode g_scanner_cur_position xmlNodeGetBase g_hook_prepend gtk_major_version gtk_vbutton_box_get_type gtk_preview_get_cmap gtk_ctree_node_set_cell_style gdk_gc_set_tile loki_create_component gdk_text_property_to_text_list gdk_drag_status gtk_init gdk_key_repeat_disable g_module_close gtk_arrow_get_type GTK_TYPE_UPDATE_TYPE gtk_check_menu_item_new detect_libc gtk_tree_remove_item gtk_list_end_drag_selection gtk_ctree_find gdk_send_xevent GTK_TYPE_ACCEL_GROUP gdk_window_get_toplevels gtk_clist_get_vadjustment gtk_container_add_child_arg_type g_print g_hook_find gdk_gc_set_exposures gdk_screen_height_mm gtk_tooltips_data_get file_exists gdk_pointer_ungrab xmlParseFile gtk_clist_undo_selection gtk_widget_get_default_visual gdk_pointer_grab gtk_list_select_all getLineNumber gtk_widget_setv gtk_draw_vline gdk_window_set_static_gravities gtk_signal_connect_after g_array_prepend_vals xmlParseQuotedString gtk_widget_reset_shapes gtk_container_children gtk_clist_swap_rows gtk_spin_button_new gtk_ctree_last g_hook_find_data gdk_pixmap_create_from_xpm_d GTK_TYPE_JUSTIFICATION gtk_target_list_add_table g_byte_array_prepend g_cache_remove gdk_color_alloc gtk_menu_set_active gdk_color_context_new gtk_target_list_find xmlParseComment gtk_editable_get_chars loki_seturl_component gtk_signal_handler_block_by_func gtk_widget_get_style glade_xml_get_uline_accel loki_remove_option gtk_signal_name gdk_visual_get_best_with_depth g_slist_length xmlParserInputGrow gtk_range_slider_update deflateInit2_ setup_button_play_slot htmlNewInputStream gtk_vbutton_box_get_spacing_default gtk_viewport_set_vadjustment gdk_color_equal gtk_accel_label_get_type gtk_scale_set_draw_value gtk_file_selection_hide_fileop_buttons xmlBufferContent g_strsplit gtk_misc_set_padding xmlRecoverFile g_module_name xmlParsePITarget gtk_marshal_INT__POINTER loki_setpatched_file gdk_color_context_free xmlNewInputStream xmlBufferShrink gtk_widget_lock_accelerators gdk_selection_owner_set file_chmod gdk_input_set_key gtk_check_menu_item_new_with_label g_getenv xmlFreeElement g_completion_new gtk_list_unselect_all gtk_ctree_expand_recursive xmlGetCompressMode gdk_window_get_pointer gtk_clist_get_row_style GetProductCDROMFile g_strerror setup_button_browser_slot gtk_idle_remove gtk_progress_bar_set_discrete_blocks gtk_object_weakref g_datalist_init gtk_menu_bar_insert GTK_TYPE_TREE_VIEW_MODE gdk_colors_alloc gtk_layout_get_hadjustment GTK_TYPE_RC_FLAGS gtk_range_default_vslider_update signal_abort gtk_box_reorder_child gtk_object_newv gtk_label_get gtk_toolbar_prepend_widget gtk_marshal_NONE__INT_FLOAT_BOOL gdk_window_show xmlParseTry gdk_image_new gtk_ctree_unselect g_slist_find gtk_editable_insert_text htmlParseDocument GetProductReinstall xmlBufferAdd xmlFreeInputStream gtk_preview_put g_malloc gtk_container_arg_get gtk_button_box_set_child_size_default gtk_progress_set_format_string glade_widget_tree_unref gtk_true gdk_color_white xmlGetBufferAllocationScheme gtk_notebook_set_tab_vborder deflate_copyright gdk_im_set_best_style gdk_colormap_unref g_hash_table_lookup_extended gtk_menu_new g_log_domain_gmodule xmlGetProp xmlParseAttribute xmlFreeNode gtk_key_snooper_remove gtk_hscrollbar_new copy_cpio_stream xmlFreeEntitiesTable g_list_pop_allocator xmlParseCharEncoding g_slist_alloc xmlNodeSetName enable_option GTK_TYPE_GDK_OVERLAP_TYPE xmlFreeRefTable xmlNewProp gdk_add_client_message_filter gzdopen gtk_notebook_set_show_border glade_get_adjustment g_vsnprintf gdk_property_change inflateReset xmlCleanupCharEncodingHandlers gtk_table_set_col_spacing gtk_signal_emitv_by_name GetWebsiteText GTK_TYPE_CTREE_LINE_STYLE GetProductDefaultBinaryPath gdk_window_get_type xmlParseConditionalSections htmlFreeParserCtxt xmlFreeNodeList deflateReset gtk_accel_group_lock gtk_progress_set_text_alignment gtk_check_menu_item_set_show_toggle htmlSaveFile size_node loki_setmessage_component gtk_color_selection_set_opacity gdk_pixmap_new copy_node xmlParserHandlePEReference gdk_selection_send_notify gtk_rc_get_module_dir inflate_codes_new g_source_remove g_list_free_1 gtk_object_set_user_data gdk_gc_set_clip_origin gtk_tooltips_enable gdk_drag_motion htmlTagLookup g_cache_key_foreach gdk_init_check gdk_screen_height GTK_TYPE_GDK_DRAG_PROTOCOL gtk_container_child_getv xmlParseStringPEReference rc_dir_stack gtk_selection_incr_event gtk_main_quit g_hook_destroy gtk_binding_set_by_class g_array_new GTK_TYPE_GDK_CAP_STYLE gtk_progress_bar_new_with_adjustment gtk_clist_set_shift gtk_target_list_remove xmlNanoHTTPScanProxy gdk_drop_reply file_close gtk_draw_box_gap glade_xml_set_window_props g_hash_table_destroy getSystemId xmlParseXMLDecl file_fdopen g_allocator_free gdk_colormap_new setup_checkbox_option_slot g_log_set_handler g_path_skip_root gdk_dnd gtk_widget_reparent gtk_container_get_toplevels gdk_window_set_group gtk_notebook_popup_disable gtk_packer_set_default_border_width gtk_object_set_data_by_id_full xmlFreeRef gtk_tree_item_select gtk_widget_set_sensitive inflate_trees_bits inflateSync gdk_color_context_query_color getToken gtk_type_set_varargs_type gtk_spin_button_get_value_as_int gtk_toolbar_append_element gtk_rc_set_default_files gtk_calendar_mark_day g_completion_complete gtk_progress_bar_get_type gtk_object_post_arg_parsing_init gtk_drag_source_set xmlStrndup free_corrupt_files GTK_TYPE_GDK_VISIBILITY_STATE gtk_tree_item_deselect gtk_idle_add loki_unregister_rpm gtk_button_box_get_type xmlNewDtd gtk_notebook_popup_enable xmlDumpElementContent xmlNanoHTTPOpen inflate_codes xmlCleanupParser GTK_TYPE_GDK_IM_STYLE gdk_pixmap_foreign_new gtk_table_set_homogeneous g_hook_list_clear gtk_type_register_enum xmlStrncmp gdk_ic_cleanup gtk_widget_set gtk_paint_vline xmlUnlinkNode gtk_rc_get_theme_dir g_idle_add_full g_int_equal gtk_toggle_button_new copy_path gtk_rc_add_widget_name_style gdk_draw_image g_array_remove_index_fast gtk_type_describe_heritage gtk_menu_shell_select_item topmost_valid_path gtk_toolbar_prepend_element xmlScanAttributeDecl gtk_container_add_with_args gtk_type_check_object_cast gtk_box_set_homogeneous g_source_remove_by_user_data gtk_list_undo_selection xmlNanoFTPUpdateURL g_string_prepend gdk_colors_free g_mem_chunk_info gtk_clist_set_shadow_type xmlGetDtdNotationDesc gtk_pixmap_new glade_xml_signal_connect_full add_rpm_entry g_realloc glade_xml_set_common_params g_ptr_array_add GTK_TYPE_GDK_FILL_RULE xmlNanoHTTPCleanup gtk_entry_get_type gtk_clist_row_is_visible xmlNodeListGetString gdk_input_add_full gtk_editable_get_type gtk_main xmlCreateNotationTable g_slist_nth md5_write xmlParseMisc gdk_events_init internalSubset gtk_clist_column_title_passive GTK_TYPE_FUNDAMENTAL_TYPE g_atexit log_quiet gtk_tree_clear_items gtk_spin_button_set_update_policy gdk_window_destroy g_node_destroy gdk_window_set_role gtk_toolbar_insert_item main gtk_spin_button_get_value_as_float g_tree_height gtk_tree_item_set_subtree setup_destroy_license_slot g_list_nth_data gdk_progclass gtk_clist_get_row_data gtk_container_foreach_full xmlFreeProp gzclose gdk_draw_rgb_image gdk_ic_attr_destroy g_get_home_dir dialog_okay current_option g_direct_equal gdk_pixmap_colormap_create_from_xpm_d gtk_widget_draw_focus GTK_TYPE_TROUGH_TYPE gdk_input_vtable gtk_spin_button_set_shadow_type gdk_bitmap_unref gdk_draw_arc htmlNewDoc loki_gettype_file GetPostInstall gdk_rgb_cmap_free gtk_clist_unselect_row g_dataset_id_get_data gdk_window_xid_at xmlNanoHTTPRead gdk_gc_get_values g_string_sized_new GTK_TYPE_GDK_JOIN_STYLE g_main_destroy gtk_option_menu_set_history g_get_user_name gdk_window_get_origin gtk_clist_set_column_auto_resize xmlSetCompressMode gdk_colormap_get_system_size gtk_container_set_focus_vadjustment gtk_signal_handler_unblock GTK_TYPE_GDK_VISUAL loki_register_rpm xmlInitializePredefinedEntities g_hook_list_invoke gdk_event_get_time xmlGetNsProp xmlFreeNsList g_scanner_destroy gdk_root_parent g_path_is_absolute gtk_widget_add_accelerator gdk_selection_convert gtk_widget_hide_all gtk_args_collect gtk_statusbar_new htmlFreeInputStream size_binary gtk_statusbar_remove gtk_style_set_background GTK_TYPE_SORT_TYPE inputPop gtk_accelerator_get_default_mod_mask gtk_entry_append_text gtk_list_append_items detect_home glade_xml_relative_file htmlEntityLookup gtk_curve_set_gamma gtk_accel_group_attach gtk_clist_clear xmlDumpEnumeration gtk_ctree_find_by_row_data_custom htmlParseHTMLAttribute gtk_label_parse_uline gtk_type_flags_find_value gdk_keyboard_ungrab gtk_viewport_get_type gtk_vseparator_get_type isStandalone gtk_draw_flat_box gdk_window_set_user_data gtk_button_released gtk_arrow_new GTK_TYPE_STYLE gdk_ic_attr_new gtk_clist_get_type g_slist_prepend htmlInitParserCtxt g_static_private_get gdk_color_change g_scanner_scope_add_symbol g_strconcat g_slist_insert gtk_range_get_type g_node_get_root gdk_rgb_init gtk_label_set_pattern current_dest_drag gdk_keyval_name xmlRemoveID gtk_combo_set_item_string xmlCreateMemoryParserCtxt GTK_TYPE_RESIZE_MODE xmlBufferWriteQuotedString xmlParseDoc gdk_timer_disable xmlRecoverDoc copy_script GTK_TYPE_PRIVATE_FLAGS gtk_color_selection_new g_module_symbol xmlValidateNameValue gtk_theme_engine_get gtk_menu_item_remove_submenu g_slist_sort gtk_object_query_args g_set_print_handler gtk_font_selection_get_preview_text g_slist_index gtk_vruler_new gtk_signal_disconnect_by_func htmlParseTry gdk_visual_init GTK_TYPE_GDK_AXIS_USE gtk_menu_shell_prepend g_slist_append add_option_entry gtk_tree_remove_items loki_setversion_component gtk_rc_find_module_in_path MatchLocale gtk_spin_button_set_value gdk_window_shape_combine_mask gdk_input_add gtk_vscrollbar_new gdk_event_free gdk_gc_set_clip_rectangle gdk_window_get_colormap gtk_container_child_type gtk_notebook_set_tab_border gtk_handle_box_set_snap_edge xmlUpgradeOldNs glade_xml_pop_accel g_hook_find_func gtk_button_box_get_layout gdk_gc_set_subwindow xmlParserInputBufferPush g_list_find_custom htmlCreateDocParserCtxt g_set_error_handler gtk_button_box_child_requisition xmlBufferWriteCHAR remove_root gtk_menu_reposition gdk_wm_protocols GTK_TYPE_GDK_WINDOW GTK_TYPE_FONT_METRIC_TYPE gtk_input_remove gtk_list_scroll_vertical htmlAutoCloseOnClose gtk_false gtk_ctree_sort_recursive gtk_curve_new loki_split_version gtk_toolbar_set_button_relief gtk_button_box_get_child_size_default add_component_entry htmlHandleEntity GetProductIsMeta g_datalist_id_get_data gtk_adjustment_clamp_page setNamespace g_string_down gtk_drag_set_icon_widget gtk_object_arg_get gtk_container_clear_resize_widgets gtk_grab_remove gtk_handle_box_new gtk_accel_group_add gtk_clist_sort gtk_pattern_match_string gtk_set_locale GTK_TYPE_GDK_FONT gtk_hbutton_box_get_spacing_default gtk_signal_set_funcs gtk_main_iteration gtk_object_setv g_hook_first_valid gtk_widget_set_default_style gtk_preview_set_gamma gtk_style_new gtk_file_selection_get_filename g_node_first_sibling g_slist_find_custom data_start gtk_notebook_append_page xmlKeepBlanksDefaultValue gtk_container_addv g_string_sprintf gtk_packer_add gtk_color_selection_dialog_get_type GetProductUninstall gtk_paint_ramp gtk_drag_dest_set gtk_clist_append loki_getmd5_file gtk_packer_set_spacing z_errmsg gtk_list_clear_items g_scanner_cur_token htmlDocDumpMemory gtk_quit_add_full xmlSetNs gdk_window_set_child_shapes g_dataset_id_set_data_full xmlParserInputBufferRead zcalloc GTK_TYPE_ARROW_TYPE gdk_window_remove_filter gtk_paned_pack1 GTK_TYPE_SHADOW_TYPE g_array_set_size gtk_binding_entry_add_signall gtk_style_copy gtk_widget_get_parent_window GetProductName xmlDumpEntitiesTable gtk_notebook_get_nth_page gtk_box_set_child_packing gtk_layout_put glade_get_widget_name loki_create_product gtk_label_set_line_wrap uninstall xmlCopyNotationTable xmlBufferSetAllocationScheme gtk_aspect_frame_new gtk_layout_set_size loki_getproduct_file loki_getdefault_component g_ptr_array_remove_index gtk_widget_set_state gdk_gc_new gtk_menu_bar_get_type mark_cmd_options loki_registerscript_component deflateCopy gtk_button_box_set_child_ipadding gtk_menu_bar_set_shadow_type glade_xml_new_from_memory attribute gtk_ctree_node_get_cell_style xmlParseEntityDecl gtk_ctree_toggle_expansion gtk_object_get_data_by_id htmlParseFile gtk_viewport_get_vadjustment g_get_current_time htmlNodeDump gtk_calendar_new gdk_im_decide_style g_mem_chunk_reset gtk_preview_uninit gtk_input_dialog_new glade_widget_tree_parse_file g_completion_remove_items g_source_remove_by_funcs_user_data GTK_TYPE_CTREE_EXPANSION_TYPE launch_browser g_main_remove_poll gtk_timeout_remove g_module_build_path gdk_drop_finish xmlParseDocTypeDecl htmlParseLookupSequence inputPush gtk_notebook_insert_page get_option_help GTK_TYPE_CELL_TYPE gtk_container_set_focus_hadjustment gdk_window_resize gtk_binary_age gtk_object_set_data_full xmlAddNextSibling xmlParseElementContentDecl gtk_tooltips_set_tip gtk_clist_optimal_column_width g_array_remove_index htmlDefaultSAXHandler unix_watch_funcs xmlCheckVersion xmlSprintfElementContent loki_getfirst_file xmlParsePI restoring_corrupt gtk_text_get_length xmlScanIDAttributeDecl xmlParseNotationDecl g_array_append_vals gdk_keyval_to_lower GetInstallOption gtk_ctree_move xmlNewDocFragment gtk_clist_set_row_data g_log_set_always_fatal gtk_label_set_text gdk_color_free g_string_chunk_insert_const gdk_set_locale gtk_notebook_get_type gdk_drag_get_protocol gdk_colormap_ref htmlParseContent gtk_hseparator_get_type gtk_container_register_toplevel g_string_append g_strchomp gtk_ctree_real_select_recursive g_strncasecmp gtk_timeout_add_full gtk_accel_group_activate gtk_marshal_NONE__POINTER_POINTER_POINTER gzwrite gtk_selection_property_notify log_fatal xmlStrcat gtk_layout_freeze gtk_ctree_pre_recursive gtk_ctree_expand_to_depth gtk_clist_column_title_active g_mem_chunk_free htmlParseReference g_cache_insert gdk_atom_intern gtk_clist_construct gtk_entry_set_max_length setup_button_complete_slot GetProductVersion g_scanner_unexp_token gtk_clist_moveto gtk_drag_highlight gtk_widget_queue_clear GTK_TYPE_GDK_WM_FUNCTION get_md5_bin g_allocator_new gtk_selection_data_free xmlParserFindNodeInfo g_tree_new g_string_truncate gtk_spin_button_get_type gtk_container_child_set gtk_clist_set_column_visibility loki_removeproduct detect_and_mount_cdrom inflate_blocks gtk_notebook_set_tab_label gdk_draw_polygon gdk_draw_pixmap gtk_fixed_new gtk_color_selection_set_color gtk_container_set_reallocate_redraws gtk_type_flags_get_values gtk_ruler_set_metric loki_getsize_component loki_getinfo_product g_printf_string_upper_bound g_io_channel_unix_new gtk_signal_connect_object gtk_combo_disable_activate gtk_container_focus gtk_ctree_node_get_selectable gtk_clist_set_row_style gtk_widget_get_visual GTK_TYPE_GDK_INPUT_MODE gtk_ctree_node_nth xmlCreateIntSubset gtk_menu_item_right_justify xmlNewNs gtk_signal_lookup gdk_gc_set_foreground xmlFreeParserCtxt gtk_notebook_next_page gtk_object_get g_string_chunk_free gdk_string_extents GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE getColumnNumber gtk_hpaned_new g_hook_insert_sorted gtk_ctree_pre_recursive_to_depth xmlParseStringEntityRef gtk_editable_cut_clipboard GTK_TYPE_PATH_PRIORITY_TYPE gtk_entry_select_region gdk_drawable_set_data g_node_push_allocator gtk_window_set_default gtk_radio_button_new gtk_widget_set_default_colormap gtk_viewport_set_shadow_type gtk_menu_ensure_uline_accel_group gtk_widget_queue_draw_area gtk_paint_polygon gtk_check_button_new GetProductURL gdk_mbstowcs gdk_window_clear_area_e gtk_draw_string gtk_list_item_select gtk_type_check_class_cast gtk_clist_get_text xmlKeepBlanksDefault has_binaries xmlValidateNmtokensValue g_mem_profile gtk_clist_set_row_height gtk_clist_set_selection_mode htmlCheckAutoClose disable_install_path GetProductHasPromptBinaries g_thread_functions_for_glib_use gtk_object_set_data_by_id gtk_clist_set_button_actions inflate_blocks_reset gzputc GTK_TYPE_SUBMENU_PLACEMENT gtk_tooltips_set_delay gdk_draw_text gtk_type_set_chunk_alloc g_node_child_position gtk_pixmap_get_type htmlParsePubidLiteral xmlCopyAttributeTable gtk_preview_set_dither gtk_marshal_NONE__BOOL gtk_packer_reorder_child gtk_widget_push_visual gdk_debug_flags gtk_event_box_new comment nodePush gtk_statusbar_pop xmlGetRef gdkx_visual_get gdk_visual_get_best_type gtk_scale_get_value_width gdk_window_set_back_pixmap g_byte_array_remove_index_fast motif_drag_window_filter gtk_draw_slider loki_getnext_component gtk_combo_set_popdown_strings gtk_widget_get_name g_ptr_array_remove_index_fast gtk_widget_queue_clear_area gtk_label_set_justify xmlParserInputBufferCreateFile g_string_assign gdk_rgb_xpixel_from_rgb gtk_type_init g_io_channel_seek xmlParseTextDecl cdataBlock gtk_marshal_NONE__POINTER gtk_grab_add gtk_clist_select_row xmlReplaceNode gtk_paint_extension GTK_TYPE_GDK_EXTENSION_MODE gdk_gc_set_fill gtk_rc_add_class_style xmlParseDTD file_skip_zeroes gdk_error_trap_push file_is_corrupt loki_openproduct gtk_statusbar_get_context_id gtk_paned_pack2 gtk_preview_get_visual g_node_n_children gtk_button_get_type gdk_drag_begin xmlBufferCreateSize gtk_type_register_flags gtk_progress_set_show_text g_mem_chunk_alloc0 gtk_clist_set_column_widget gtk_viewport_new xmlNewPI gtk_range_trough_click gtk_interface_age xmlValidateAttributeValue g_byte_array_new gtk_button_leave gtk_tree_set_view_mode gdk_xim_window gtk_gc_get g_hash_table_thaw xmlNodeAddContentLen gdk_window_set_colormap gdk_drag_drop gtk_container_arg_set xmlDumpElementTable gtk_clist_set_sort_column gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER gtk_button_box_get_child_ipadding GTK_TYPE_GDK_CURSOR_TYPE gtk_ctree_construct gtk_idle_add_full gtk_ctree_select gtk_binding_set_find gtk_menu_insert gtk_progress_bar_set_activity_blocks gtk_list_end_selection DumpPlugins gtk_tooltips_get_type htmlNodeDumpFile gdk_xid_table_lookup hasExternalSubset xmlParseDocument GTK_TYPE_TARGET_FLAGS gtk_paint_arrow gdk_set_show_events gtk_rc_add_widget_class_style gtk_object_destroy g_list_concat gtk_table_set_row_spacings g_node_nth_child gtk_progress_set_adjustment gtk_drag_set_icon_default gdk_window_xid_at_coords xmlParserPrintFileContext xmlNanoFTPGetConnection gdk_fontset_load htmlParseStartTag glade_init xmlParseNamespace gdk_font_id xmlNewTextLen gzeof g_blow_chunks gtk_object_set g_node_prepend gtk_widget_getv gtk_clist_set_foreground gtk_frame_set_label_align gtk_container_queue_resize gtk_drag_dest_unset gtk_list_item_new_with_label GTK_TYPE_TOOLBAR_CHILD_TYPE g_scanner_thaw_symbol_table g_static_mutex_get_mutex_impl inflate_blocks_sync_point setup_button_warning_cancel_slot xmlBufferAllocScheme gtk_editable_set_position g_strdup g_scanner_input_file htmlParseElement UTF16ToUTF8 xmlGetDtdEntity gtk_ctree_toggle_expansion_recursive unmount_filesystems gdk_xim_ic gtk_binding_set_add_path gtk_ctree_new_with_titles gdk_window_destroy_notify gdk_get_display gtk_ctree_is_viewable gdk_set_sm_client_id gtk_check_version xmlNanoFTPOpen gtk_paned_get_type gtk_ctree_node_set_background gtk_target_list_unref gtk_object_args_collect xmlGetCharEncodingHandler gdk_free_compound_text gtk_ctree_set_indent ui_fatal_error xmlNanoFTPGetSocket gdk_colormap_get_visual g_node_find_child GTK_TYPE_POSITION_TYPE g_log gtk_container_query_child_args gdk_gc_set_clip_mask gtk_marshal_INT__INT gdk_window_move inflate_copyright gtk_aspect_frame_get_type getParameterEntity gdk_color_context_init_dither g_io_channel_unref xmlSetupParserForBuffer gtk_widget_add_events gtk_menu_append xmlIsID gtk_list_item_get_type g_ptr_array_new xmlNewReconciliedNs xmlDefaultSAXHandler inflate_trees_dynamic gdk_wm_delete_window gtk_clist_set_pixtext inflate_set_dictionary gtk_paned_compute_position motif_operation_changed gtk_button_box_set_child_size gtk_file_selection_complete xmlSAXParseBalancedChunk IsReadyToInstall xmlParserGetDirectory xmlBufferEmpty gtk_args_query g_main_quit gtk_range_set_update_policy gdk_compress_exposures GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE gtk_object_sink gtk_type_from_name loki_getnext_file g_list_append gtk_clist_set_auto_sort xmlSAXUserParseMemory xmlIndentTreeOutput g_direct_hash gtk_clist_freeze gdk_query_visual_types gdk_string_width gtk_ctree_insert_gnode xmlValidateElement xmlParseNmtoken g_string_prepend_c resolveEntity gtk_trace_referencing gdk_im_begin CheckRequirements xmlNewComment xmlStrncat g_hook_get gdk_draw_segments glade_xml_set_toplevel GTK_TYPE_ANCHOR_TYPE gtk_file_selection_get_type gtk_notebook_set_homogeneous_tabs set_installpath gtk_packer_get_type htmlParseDoc gtk_list_scroll_horizontal gtk_clist_set_column_title gdk_input_list_devices gtk_editable_changed xmlParseCDSect gtk_ctree_node_set_pixmap GTK_TYPE_SCROLL_TYPE inflate_codes_free gtk_progress_set_activity_mode g_ptr_array_remove_fast htmlParseExternalID gdk_image_exit gtk_container_child_setv gtk_notebook_set_scrollable gtk_vbutton_box_new gdk_xim_using xmlValidateNmtokenValue gtk_widget_destroy gtk_table_set_row_spacing g_scanner_freeze_symbol_table gdk_gc_set_stipple gtk_widget_is_ancestor copy_directory gtk_clist_get_pixtext xmlBufferDump xmlSubstituteEntitiesDefaultValue GTK_TYPE_GDK_INPUT_SOURCE gtk_check_menu_item_set_active gtk_widget_hide g_module_open htmlInitAutoClose gdk_window_reparent _tr_init gtk_paned_add1 loki_getfirstproduct loki_runscripts xmlSaveFile gtk_paint_option file_mkfifo g_source_remove_by_source_data gdk_display_name gtk_rc_set_image_loader g_strreverse htmlEquEnd gtk_widget_set_default_visual gtk_widget_shape_combine_mask gtk_curve_reset GTK_TYPE_GDK_EVENT_MASK loki_geturl_component add_bin_entry loki_newer_version copy_file gdk_color_context_get_index_from_palette gtk_ctree_find_all_by_row_data gtk_draw_check gtk_accel_label_set_accel_widget xmlCopyNamespace gtk_entry_set_editable gtk_menu_get_active gtk_window_activate_focus gdk_color_context_add_palette gtk_editable_delete_selection setup_checkbox_menuitems_slot deflateParams glade_xml_new_with_domain xmlIsRef install g_scanner_cur_line gtk_curve_set_curve_type gtk_adjustment_get_type path_entry_keypress_slot g_hook_insert_before gdk_bitmap_ref GetProductInstallOnce gtk_notebook_get_menu_label gdk_visual_get_best_depth GTK_TYPE_GDK_BYTE_ORDER g_get_current_dir xmlSwitchEncoding gtk_option_menu_get_type xmlCopyElementTable gtk_widget_set_rc_style gtk_signal_connect_while_alive gtk_progress_bar_new gtk_text_freeze gtk_fixed_put GTK_TYPE_GDK_IMAGE_TYPE file_mkdir g_io_channel_close g_slist_remove_link glade_xml_signal_autoconnect gtk_color_selection_set_update_policy g_byte_array_free gtk_menu_get_uline_accel_group gtk_alignment_get_type xmlParseTryOrFinish dir_create_hierarchy gtk_preview_reset gtk_clist_set_use_drag_icons g_main_add_poll gtk_drawing_area_size gtk_object_add_arg_type g_scanner_lookup_symbol gdk_xgrab_window gtk_widget_unmap g_get_real_name loki_getcomponent_file GTK_TYPE_DIRECTION_TYPE gtk_ctree_node_set_row_data_full xmlGetParameterEntity GTK_TYPE_ARG_FLAGS g_byte_array_set_size xmlValidateElementTypeExpr xmlSearchNsByHref RegisterPlugin gdk_keyboard_grab g_node_traverse g_set_printerr_handler on_use_binary_toggled gtk_paint_handle gtk_pixmap_get gdk_event_copy gtk_widget_intersect setup_button_abort_slot gtk_list_insert_items setup_entry_installpath_slot gtk_editable_paste_clipboard gtk_entry_prepend_text g_bit_nth_msf gtk_tree_insert match_libc gtk_signal_emit_stop gdk_color_context_get_pixels_incremental entityDecl gtk_widget_pop_composite_child xmlGetDocCompressMode gtk_target_list_add g_get_prgname htmlDocDump globalNamespace xmlParseVersionNum gtk_object_arg_get_info GTK_TYPE_GDK_CROSSING_MODE gtk_signal_newv gtk_range_default_vmotion gtk_container_dequeue_resize_handler gtk_marshal_NONE__INT_FLOAT gtk_draw_box gtk_table_new GetProductREADME gtk_menu_item_select g_node_reverse_children loki_closeproduct gtk_editable_select_region inflateSetDictionary gtk_calendar_select_day gtk_font_selection_set_font_name gtk_accel_group_unref gtk_rc_parse_priority gtk_arg_free htmlSwitchEncoding xmlNamespaceParseQName gdk_draw_gray_image g_idle_add html40ElementTable xmlFreeIDTable xmlParseExternalID gtk_font_selection_dialog_set_filter GetRuntimeArgs gtk_entry_new_with_max_length xmlDefaultSAXHandlerInit gdk_window_set_override_redirect GTK_TYPE_GDK_GC_VALUES_MASK gtk_list_select_child g_list_prepend gtk_box_set_spacing gtk_paned_set_gutter_size current_option_txt gtk_spin_button_set_snap_to_ticks g_hash_table_foreach_remove gdk_get_show_events GTK_TYPE_PATH_TYPE binary_path_entry_keypress_slot event_poll_fd gdk_keyval_is_upper gdk_error_warnings gdkx_colormap_get xmlTextConcat g_io_channel_unix_get_fd g_cache_value_foreach gtk_marshal_NONE__INT_INT gtk_preview_set_reserved gtk_layout_thaw gdk_window_set_decorations gdk_window_get_parent htmlParseAttValue xmlSetProp gtk_packer_set_default_ipad gdk_gc_set_ts_origin g_log_remove_handler g_timeout_add gdk_window_get_toplevel gtk_pixmap_set_build_insensitive gtk_window_set_focus gdk_window_ref gtk_init_check gtk_marshal_NONE__POINTER_POINTER gtk_font_selection_get_font gdk_colormap_get_system g_tree_insert xmlNewCharEncodingHandler gtk_menu_shell_deactivate xmlFreeAttribute gdk_rgb_cmap_new xmlParserPrintFileInfo GTK_TYPE_BUTTON_BOX_STYLE gtk_signal_emit_by_name gtk_type_name glade_standard_build_children gzrewind glade_get_widget_tree gtk_combo_set_use_arrows loki_unregister_file GetProductRequireRoot gtk_entry_set_position xmlNewNode xmlPopInput gtk_menu_item_set_submenu g_list_foreach gtk_pixmap_set gtk_option_menu_remove_menu g_messages_init gtk_ctree_get_node_info gtk_entry_new inflate_blocks_new gtk_scrolled_window_get_vadjustment g_quark_from_static_string xmlValidateRoot gdk_error_code xmlHandleEntity GTK_TYPE_GDK_FONT_TYPE gtk_widget_size_request GTK_TYPE_FONT_TYPE gtk_box_pack_end_defaults htmlParseEntityRef gtk_draw_polygon gtk_drag_dest_set_proxy xmlNodeGetLang gtk_marshal_NONE__INT_POINTER processingInstruction xmlAddChild gtk_toggle_button_new_with_label gtk_layout_get_type g_str_hash xmlValidateNotationUse htmlParseNmtoken xmlSetDocCompressMode __data_start gtk_identifier_get_type gtk_menu_reorder_child gdk_ic_get_attr inflateEnd gdk_timer_enable gdk_event_send_clientmessage_toall gdk_image_get gtk_list_set_selection_mode gtk_tree_child_position glade_get_widget_long_name xmlW3CPIs xmlStrsub gtk_drag_get_source_widget loki_find_option gtk_data_get_type gtk_signal_disconnect_by_data gtk_notebook_set_menu_label_text gtk_color_selection_dialog_new gtk_radio_menu_item_new_with_label gtk_container_get_type gtk_object_default_construct setup_button_install_slot gtk_font_selection_dialog_get_type gtk_binding_entry_clear GTK_TYPE_GDK_DRAG_CONTEXT glade_xml_push_uline_accel gdk_window_get_position g_str_equal g_main_new gtk_events_pending g_scanner_new loki_isdefault_component gtk_signal_connect gtk_button_new_with_label g_slist_pop_allocator gdk_window_set_background gtk_entry_set_visibility g_free gtk_widget_set_parent_window g_log_set_fatal_mask GTK_TYPE_ORIENTATION add_script_entry gtk_paint_cross xmlSearchNs g_byte_array_append gdk_input_set_mode gtk_adjustment_value_changed gdk_drag_context_new xmlCopyPropList xmlParserValidityError gdk_window_set_events gdk_window_hide gtk_object_ref gtk_widget_queue_resize xmlCreateFileParserCtxt gtk_separator_get_type xmlParseSDDecl gdk_input_set_extension_events xmlParseAttributeListDecl GTK_TYPE_GDK_STATUS gtk_clist_column_titles_passive xmlNanoHTTPMethod gtk_curve_set_range g_hash_table_insert gtk_ctree_find_node_ptr glade_create_custom loki_getpatched_file gtk_bin_get_type gdk_drag_find_window g_parse_debug_string gdk_text_extents checkNamespace gtk_text_insert gtk_object_class_user_signal_new GetProductSplash gdk_window_is_visible DetectLocale gtk_pattern_spec_free_segs gtk_widget_accelerators_locked gtk_editable_claim_selection gtk_clist_set_row_data_full gtk_preview_draw_row gdk_colormap_alloc_colors glade_widget_tree_print gtk_ctree_insert_node gtk_combo_set_value_in_list xmlBufferResize mark_option inflateInit2_ gdk_color_black elementDecl install_postinstall loki_getmode_file unparsedEntityDecl gtk_widget_reset_rc_styles gtk_ctree_get_type gtk_clist_set_sort_type xmlValidGetPotentialChildren xmlFreeAttributeTable gdk_dnd_init gtk_list_unselect_item gtk_idle_remove_by_data loki_setdefault_component xmlIsBlankNode g_main_run gtk_widget_get_type gtk_curve_set_vector gtk_widget_set_usize oldXMLWDcompatibility gtk_progress_bar_set_bar_style gtk_accelerator_valid gtk_input_dialog_get_type _tr_tally gdk_window_is_viewable gtk_key_snooper_install deflateEnd g_dataset_foreach xmlGetDtdElementDesc gtk_list_toggle_row install_menuitems g_printerr glade_load_module xmlNewDocComment gdk_rgb_set_verbose glib_minor_version get_crc_table xmlReconciliateNs gdk_set_use_xshm g_node_pop_allocator gtk_hpaned_get_type xmlParseElementChildrenContentDecl add_cdrom_entry gtk_marshal_NONE__INT_POINTER_INT_INT_INT gdk_text_measure loki_launchURL xmlNanoHTTPInit gtk_menu_prepend gtk_clist_set_reorderable gtk_list_new gzprintf gtk_vruler_get_type gtk_paint_shadow xmlDumpAttributeTable xmlParserAddNodeInfo gtk_ctree_collapse_recursive loki_getnext_option GTK_TYPE_CALENDAR_DISPLAY_OPTIONS g_mem_chunk_destroy gtk_font_selection_set_filter g_list_first _tr_align gtk_progress_bar_set_activity_step xmlCleanupPredefinedEntities gdk_free_text_list gtk_toolbar_get_type xmlNanoFTPRead g_dataset_id_remove_no_notify xmlGetExternalEntityLoader gtk_paint_box loki_check_file gdk_selection_owner_get gtk_vbox_new namespaceDecl gtk_scrolled_window_add_with_viewport file_size gtk_widget_ref gdk_char_width_wc gtk_file_selection_new xmlNanoFTPCwd g_source_add GetProductAllowsExpress gtk_calendar_clear_marks xmlFreeID gtk_widget_remove_accelerator check_deviant_paths argv0 gtk_notebook_prev_page gtk_accelerator_name gtk_window_remove_accel_group xmlIsMixedElement gtk_marshal_NONE__POINTER_INT gtk_widget_grab_focus GLIBC_2.1 GLIBC_2.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            +         ii
   D       5     0   ii
   D    ii
   N       ]         ii
   D    ii
   N          _   A          ăI  ȃ  ̃  Ѓ
  ԃ  ؃_  ܃/    ^ &    ?   ;    z           X      $ $  (Y ,G 06  4  8  <  @0  DH  H7  La  Pr  T  X  \  `l  d` h l. p2 t, xg  |R 5       a     9     {   ! }      Ą  Ȅ  ̄.  Є Ԅ  ؄  ܄S  w  @  F    W           @ k    6 %  s  ]     $  (L ,K 0#  41  8 <  @^  D/ H  LP P4 T  X  \I `  d$  h  l  p	 t  xY  |R  Q          E     '             
   ą  ȅ  ̅ Ѕb  ԅ  ؅m  ܅4    '  j  p  J y  (    b            U   n  $  (O ,  0# 40 8T  <>  @+ D  H  LG  P% T  X  \ `<  d  hN lZ p=  t x  |u    2  
      V    q          +  [   f  	  ĆU Ȇ  ̆D  І ԆC  ؆C ܆         L    
 h   e      W `  5       Z  $B  (;  ,  0 4  8 <  @D Di  H  L  P  T X  \  `  d] h  l8  p  t> xe |  M  &    F "  \ ) *     \  1    < X ćN  ȇ,  ̇  Ї  ԇv  ؇  ܇8       x  ?       :   M         V  c  $" (  ,d 0  49  8o  <P  @  D|  H7 L  P- Tt  XT \  `  d:  h3 l  p t!  xQ |  A  3  ~    [  K        =   H E  -      ĈO  Ȉ  ̈ Ј  Ԉ  ؈*  ܈(       J  B )       d           US    [ `   t2    袃 ] 5%    %ăh    %ȃh   %̃h   %Ѓh   %ԃh    %؃h(   %܃h0   %h8   p%h@   `%hH   P%hP   @%hX   0%h`    %hh   %hp    % hx   %h   %h   %h   %h   %h   %h   %h   % h   p%$h   `%(h   P%,h   @%0h   0%4h    %8h   %<h    %@h   %Dh   %Hh  %Lh  %Ph  %Th   %Xh(  %\h0  %`h8  p%dh@  `%hhH  P%lhP  @%phX  0%th`   %xhh  %|hp   %hx  %h  %h  %h  %h  %h  %h  %h  %h  p%h  `%h  P%h  @%h  0%h   %h  %h   %h  %Ąh   %Ȅh  %̄h  %Єh  %Ԅh   %؄h(  %܄h0  %h8  p%h@  `%hH  P%hP  @%hX  0%h`   %hh  %hp   % hx  %h  %h  %h  %h  %h  %h  %h  % h  p%$h  `%(h  P%,h  @%0h  0%4h   %8h  %<h   %@h  %Dh   %Hh  %Lh  %Ph  %Th   %Xh(  %\h0  %`h8  p%dh@  `%hhH  P%lhP  @%phX  0%th`   %xhh  %|hp   %hx  %h  %h  %h  %h  %h  %h  %h  %h  p%h  `%h  P%h  @%h  0%h   %h  %h   %h  %ąh   %ȅh  %̅h  %Ѕh  %ԅh   %؅h(  %܅h0  %h8  p%h@  `%hH  P%hP  @%hX  0%h`   %hh  %hp   % hx  %h  %h  %h  %h  %h  %h  %h  % h  p%$h  `%(h  P%,h  @%0h  0%4h   %8h  %<h   %@h  %Dh   %Hh  %Lh  %Ph  %Th   %Xh(  %\h0  %`h8  p%dh@  `%hhH  P%lhP  @%phX  0%th`   %xhh  %|hp   %hx  %h  %h  %h  %h  %h  %h  %h  %h  p%h  `%h  P%h  @%h  0%h   %h  %h   %h  %Ćh   %Ȇh  %̆h  %Іh  %Ԇh   %؆h(  %܆h0  %h8  p%h@  `%hH  P%hP  @%hX  0%h`   %hh  %hp   % hx  %h  %h  %h  %h  %h  %h  %h  % h  p%$h  `%(h  P%,h  @%0h  0%4h   %8h  %<h   %@h  %Dh   %Hh  %Lh  %Ph  %Th   %Xh(  %\h0  %`h8  p%dh@  `%hhH  P%lhP  @%phX  0%th`   %xhh  %|hp   %hx  %h  %h  %h  %h  %h  %h  %h  %h  p%h  `%h  P%h  @%h  0%h   %h  %h   %h  %ćh   %ȇh  %̇h  %Їh  %ԇh   %؇h(  %܇h0  %h8  p%h@  `%hH  P%hP  @%hX  0%h`   %hh  %hp   % hx  %h  %h  %h  %h  %h  %h  %h  % h  p%$h  `%(h  P%,h  @%0h  0%4h   %8h  %<h   %@h  %Dh 	  %Hh	  %Lh	  %Ph	  %Th 	  %Xh(	  %\h0	  %`h8	  p%dh@	  `%hhH	  P%lhP	  @%phX	  0%th`	   %xhh	  %|hp	   %hx	  %h	  %h	  %h	  %h	  %h	  %h	  %h	  %h	  p%h	  `%h	  P%h	  @%h	  0%h	   %h	  %h	   %h	  %Ĉh 
  %Ȉh
  %̈h
  %Јh
  %Ԉh 
  %؈h(
  %܈h0
  %h8
  p%h@
  `%hH
  P%hP
  @%hX
  0%h`
   %hh
  %hp
   % hx
  %h
  %h
  %h
  %h
  %h
              1^PTRhNhQVhhU=(B u>$BP$B С$B8 ut
h(B   ]Ív U]ÉUtth hs]Ív U]ÐUjtEB    B    Љ]ÐU   WVS}UEPRh     V   E;r PVPM j@Ãuwtt   t   u@@)@PuS(VPC     u_GX_1[^_]UVS]tHhNEP\ƃu)[tVP[uV1e[^]ÉUVSut5~ t&^CFPS ~ uڃVe[^]ÐUEP,BuM=8 t
9<t#jhNj 8<8PP)]ÐU,BP(]U   SUEPRh     SShNj ,BP]U   SUEPRh     SShNj,BPR]U   SUEPRh     SiShNj,BP]U   SUEPRh     S)ShNj,BP]U   SUEPRh     S,BShNjP U   SUEPRh     S  t
jSPS  ]ÐUSjÃt.EPEPC0BC0B؋]]Ív U=0B ]UWVS}1h OhOÃt8W Pu
   v SuӃSe[^_]Ív UVSuEPV>/ultzt8#t+C8#t&C8#t!Ctt   t
   uCC&    FK9v;/u j V|܍e[^]Ív US0B   P=@ t
9Dt#jhOj b@D@P	jCPh!Oj Y   tQCPP=H t
9Lt#jh@Oj HLHPP CP؋[ P0B    ]]Ív U\  WVSEǅ    ǅ    8/  PSHމtt   t
   uFFv N9v>/u     j S|ɀ    EPSthjO1   EĉEЉÉƋ㉅É}  [^_]ÐU<  WVSǅ    h OhqOl,     |O   B tƿO       PpÃBPYƃSunjShOj V  uXVSPS=P t
9Tt#jhOj 6PTPPS]VT PBRh OhO  U  v P PvBPSZ޿O   1t߅   hOBPt%PSj,SGt  hOBPVt%PVj,Vt  jhOVuQ PV3t:|O    u'BPUPt
R[^_]Ív UVS]u   ؃t1}%}KPKPK7DPDPDPPue[^]ÐUl  WVSEǅ    ǅ    0P  tv j S$  [uU0P     hOgƃu~j
hOPtt   t   uAA: t5BA: u WƃtLCPVhOh  P j R>uVS#  [ t   S1;   U0P  Ptk<     &    CP/PhOh  V j Vu/PS/#  [u;mPR![^_]ÉU  WVSE1pEPE0P  t'PEPqu
sCu\[uم   tH=X t
9\t#jhOj X\XFv 맃=` t
9dt#jh Pj 9`d`xVSh    Syj S  Ѓ u	褎  1
[^_]ÐUh^PA4Bu.heP(4BuhqP4B4BP=h t
9lt#jhvPj WhlhP~]ÉUWVS]t?4Bt<uBt,ֿP    tSR];4Bu   ޿P    t1e[^_]Ív UWVSu   uFu
FuF   E    V2ǉj W& UP  PVtsj VxÅűUP  PVuE   WUE   e[^_]ÐUUt?uBu
BuBtEP  PRNt1   ]Ív U,WVSUE     uBu
BuB  E P     RE܃j-Rkƅt FU P  `IPEP   C  PE    E    fEPEEjj P]SEPEPhPV Eu
BuBu*E$P  E9|?   UE9(P     %ֿP    uUE9$P     E    }ֿP    uUE9$P  uԋE9(P  tOǉR=p t
9tt#jhPj ptpPE܃P&    E    Ee[^_]ÐUWVS8BEj/URuEj.Pu     }    UE       u  PEPj   Ӄtzt8#t+C8#t&C8#t!Ctt   t
   uCC)ӋU:>  ʉȃtzt80t-@80t(@80t#@tt   t   u@@)9#UEU;  ,E@E1e[^_]Ív UVSu]j¡8B2ZB8B  u   Ѝe[^]UVS8B1t%  tƉ؋[Puۉe[^]UWVS}58B=x t
9|t#jhPj Tx|xPWE     P   PP= t
9t#jh Qj PW& ~ uK= t
9t#jh@Qj PW  P= t
9t#jh_Qj OPW1ۃ;  s%  Ph{QW[C;  rۃhQW?ve[^_]Ív US=<B t<Bj P; u]   ]ÐUWVSEP?1hQS1t"  XhQV{u   ;/   thQVT   j/SNt  j:S9t  @j j
j PfuP   SEuVS: t(St^AAPRVff}fE j jj/Ã|#jEPSw|
S'1e[^_]UVSjƃuU= t
9t#jhQj P1y  &    ]S}]= t
9t#jhQj PnV1      EFttz   t& = t
9t#jhRj 
PEPC PFat& EPEP }jh&Rt& jh(RCPj 4CPH~ }V1e[^]ÐU   WVS1    uEPЃxjSSj j VUB@P 1ۃu*jwPUBPu
wy؉؍X[^_]ÉUS]CPvjPi j ,S]]ÐUEh@RP  @,P# uHR]Ív UEhIRP  @,P# uHR]Ív UEhNRP  @,P# ]UEhXRP  @,Pl# uXR]Ív UEhbRP  @,P<# uiR]Ív UEhtRP  @,P# ]UEh|RP  @,P" ]UEhRP  @,P" thRP3u   t& 1]ÉUEhRP  @,Px" thRPu   1]ÉUEhRP  @,P0" thRPu   1]ÉUEhRP  @,P! thRPWu   1]ÉUEhRP  @,P! thRPu   1]ÉUEhRP  @,PX! ]UEhRP  @,P,! thRPt   1]ÉU0  WVS} /  hREP  ƃ   R       Ur     hRV  ~   h  WPC  W So  /t=SEPhRh  R Pxz  QSez  t%vXURUBPt	   E@E1[^_]Ul  WVSuǅ    ~W S~ u@= t
9Ċt jh Sj Ċ  8P  uTV  =Ȋ t
9̊t jh@Sj JȊ̊ȊC  XW9vG=Њ t
9Ԋt jhSj ЊԊЊ  &    P PjuR%   = @  t@=؊ t
9܊t jhSj |؊܊؊u  j Pb}G= t
9t jhSj $  &    FP  SuF= t
9t jh Tj        VP  @,@P6tC= t
9t jh`Tj `\       tSjS@}A= t
9t jhTj [^_]ÐUEhTP  @,P` ]UEhRP  @,P< uT]Ív UWVSE    hTUP  @,P Et-h    Ph E   h U&UP  @,X   t& s(T       hOUS P tp}uh`UjCPUP  P Et8   uv =  uh    WV>  uE   [O} tIh E0  PhRh    h  jh &u 	&    1e[^_]UWVShUUP  @,P E    u# READfME 4&    h    Ph E   hU~UP  @,X   s(U       hOUS P tm}uh VjCPUP  P Et5   u=  uh    WV<  uE   [R} tHh E0  PhRh    h  jh u
     1e[^_]UWVSUP  @,X   t& s(/V       hOUS P t}jCPUP  P Et[ + 8 tHh    h EP;  h h +( h:Vh +E8 u +
[B1e[^_]ÉUWVSEP  @,1ҋ@t"NRt& p(߹
    uB@u[^_]ÉU   WVSUǅ    P  @,X   s(R       jCPUP  P  t,ƅ    uh    VW:  uVh<VS! PhAVS PEP  t[K[^_]Ív UEhDVP  @,P ]UEhQVP  @,P ]UEhUVP  @,Pl 1҅t <tt<yu   Љ]ÐUWVSEh_VP  @,P- ǃ  h  ƃfileF:// tzt8"t+B8"t&B8"t!Btt   t
   uBB)  )Ptzt80t-@80t(@80t#@tt   t   u@@PhpVV4 tzt80t-@80t(@80t#@tt   t   u@@))SWVe[^_]Ív UEhrVP  @,P u{V]Ív UEhVP  @,P uV]Ív UEhVP  @,P| ]UEhVP  @,PX ]UEhVP  @,P4 ]UEhVP  @,P ]UEhVP  @,P ]UEhVP  @,P uHR]Ív UUEPP  @,P ]ÐUWVShTP  ǃuU= K t
9Kt#jhVj  KK KPP1[  hTP  W6EP P  uW  1       WWG WGWG  P  G P  (P  P$P  Po (P   P  P$P  P IP=K t
9Kt#jh Wj KKKPǇ0P      P  @P  ǇDP      Ǉ<P       h  0  PWHP   WPWPPhRh  _SY0  Ejh WP
Ƈ    SzƃSVW^	  Vu =LB th  EPS=PB t} t
h  E$Wth  WPV} th  EP@  PuƇ@   @P  t-P  LB   h     PS5WÃtJ@P  t@SP  DP  tǇDP      GPS@P  P  DP  Wit"WVPWLP   t& ǇLP      3  uj P  @,PW#  e[^_]UWVS]uVS蔼t<VSS9u.tt   t   u@@)D؍e[^_]ÐUVSuj?ÃtHEP:CEP(EPCC    0P  C0P  ؍e[^]Ív UVS]ut(CPbtVCC    e[^]ÐUVSuj臿Ãt<EPEPqCECC    <P  C<P  ؍e[^]Ív UVSuuR=K t
9Kt#jh@Wj KKKKPPxCj ɾÃtAEPC    C    C    C    C    C    FC^؍e[^]UWVS}uj [Ãt^EPEPPF|   CjP;GCtVCC    _G=K t
9Kt#jhWj KKKPA؍e[^_]ÐUVSuj苽ÃtBEPEPuSEC; t
t	FC^ECG= K t
9$Kt#jhWj f K$K KPe[^]UVSujۼÃt.EPtc} tFC^RFC^G=(K t
9,Kt#jhWj (K,K(KPe[^]UWVS}uGPV(   j#Ãt*VWMPtUUBCZG=0K t
94Kt#jhWj 0K4K0KP=e[^_]Ív UWVS}u](j耻%  ErEBEBE MBE$BABQ  PuCPuCPuSt%AuCu
CuC   uH=8K t
9<Kt#jhWj 8K<K8K      ug   uCu
CuC   uCu
CuCB  =  5     v =@K t
9DKt#jh Xj Z@KDK@K]Au
CuC   =HK t
9LKt#jh@Xj HKLKHKP"   t& ty    up   V  PhRh     PG=PK t
9TKt#jhWj tPKTKPKPe[^_]ÐU  WVSu} >~  Ft</ue tPW    &    =XK t
9\Kt#jhXj XK\KXK   1ҍ t</tي
FBt</u S.t@PWjLt& S=`K t
9dKt#jhXj I`KdK`KP0VW蟾[^_]ÉUEMPRQP]ÉUEM  RQP]Ív UWVS]Ys(׹   1tUuEPhRSy } t5[t.s(}    uEPEPSEP[uҍe[^_]ÐU   WVS]ǅ       S(ֿY   1tօ   jCPUP  P ƅ   &      uh    VW(  uEPV8u^jhRSURBt& Y
    tֿNR
    uEPCPUR[[^_]ÐUUEPP  @,@PR]ÐU@  WVSUP  @,X  t& s(Y      hOUSG Pa   hYS% PEP `  h"YS PURY :  h'YS PEP   h.YS uO=hK t
9lKt#jh@Yj ٽhKlKhKP    j PUR      jCPUP  P tlƅ   8 tM &    h    VPS&  VS赺 h:VS褺8 ujW  1[5   [^_]Ív UWVS}]uKE    jGPUP  P E } f  uv ; uEPSV%  u}  Ur(OU    	  hOUR ƃuL=k t
9kt#jhYj kkkP7   V   jUBPUP  P Et" u; ubEPSV$  uKV=k t
9kt#jhYj hkkkPOURUH=k t
9kt#jh Zj 
kkkP؍e[^_]ÐUWVS]hGZSr  k t&h    Phkh`Z[   v s(GZ    uohOUS  P% tQjCPUP  PN Et/k u=k uh    hkV#  u݋[r1=k tke[^_]UVSu0P   t]t& 0P  C0P  CPPC PߺCPӺ SǺ0P   ue[^]ÉUWVSE<P     v U<P  G<P   2  t& wFG~ tI^CFPPSG ~ u ^CFP(S ~ uڃ~ t=VBFR~ u ^CFP߹Sֹ ~ uڃ~ tZv ^CFP谹S觹 ~ u/^CFP船CP| Sp~ uˋP\VS  P;GP/ W#E<P   |URULP  tPEPܸe[^_]ÉUWVS}WujGPhZWg`BP  @,pVWC  8P  EP_SVW8   ,P  t1FVW  tWƃt(WuEPj jj SVW%   W6ƃt(WuEPj jj SVW%   hZWkuW  WW   t   Ѝe[^_]ÐU  WVS}W\t$4P   tj W>PWX  _SU  tS  <P      p  4P   t^tj PW  [u^tfPH}MP= t
9t#jhZj 4P[u^thPɳ}MP= t
9t#jhZj ŴP謽[u4P   t^tj PW  [u^tYCPCPP= t
9t#jhZj =P$[uvi@AWPPhRh  P:0PS  tgP肧}QP= t
9t#jhZj jPQWt$4P   tj WPWq  I  [^_]UWVS}]u P  t`IHR
v HRP0P  ȅtBP  PCPV(  PV  PCPPh [Wե0jj Wee[^_]Ív UL  WVSUǅ    DP  t@P  aUPK  uSMAPAPȃPP  E@   t@  PRϿ   	  M <P    z   MDP   ubPP  u%BPPQq  x tR  EP  IH  PQ  u!PQq  XtT{ u{ uj PRc  (    CP  PPQ9   [uX          P7  P PR   th  P(  L P= t
9ċt#jho\j ӯċP躸[dYt%&    j PPT  [u⋕Zt-t& CPCPCPPQN  [ u؋x   \   󥤃Siƃ}J=ȋ t
9̋t#jh\j ֮ȋ̋ȋPh\V(ƃ   PURVh\Vɡ Yt t& Ph\V裡[uh\V苡h  V躠P V腬Ph\h  Qf PRj QS  P訡 QR=Ћ t
9ԋt#jh ]j 蒭ЋԋЋP蹶y   \   󥤃S蟱ƃ}J=؋ t
9܋t#jh\j ؋܋؋P3h\V^ƃ   PURVh5]V YtPh\Vޟ[uh?]VƟVݪ PhI]h  Q軫PRjQ   PU&    R= t
9t#jh`]j P
I  @=TB th]h]jR  Qy  EP tPR  MQYW  \   󥤃SWƃ}J= t
9t#jh\j ĪPh\Vǃ   j EPPRMQWU ~=h  PV}~WPjR膭σVh  W蔜P転Wb Qh]j P  R覝 MQ3W  \   󥤃Sƃ}J= t
9t#jh\j VP}h\V訚ǃ   j EPP表RMQW ~=h  PV~WPjRσV芛h  W&PMW Qh]jP  R8 i  P  Ph ^h  Q蠧 h^PRZ  Q蟶  SUP  P= t
9t#jh1^j ˧P[^_]ÐUWVSu}1ۋLP  t/P4tVh    VÃtWS׉ƃ}HS=  t
9t#jhN^j   Pe[^_]ÉUVSu1  uVtjPV
  É؍e[^]ÐUVSu1v  uVtjPV	  É؍e[^]ÐUWVSEE   X      S(ֿY   1tօ  hRS    .YƉ׹       RS t<j PEP&	  ER} t{VPhRS y   = t
9t#jh`^j wP螮h{VhRS3  ƿR    uE    j SUR} tQ} tVIt& NR
    uj SEP v ֿY
    ujSURZ[pe[^_]ÉU  SU    tMtE   t<    t3HP  P   Ph^h   S S5	   ]ÉU\  WVSǅ_    ǅ_    1}t;r}tP}    ǅ^ǅ^ǅ      ǅ^ǅ    k  t& h^'t,Ph^h   S   t& ǅ^   h^ؖt-Ph^h   S誢   v ^   
_@#_@6_@L_@           ha_h_"ÃtD Vh_S蔙th_V   SH_G_G_G	`D    	1  Eƅ؟ Pt\EPRh`h  ؿS耡 ha_SOÃt!Sh  ؟P衛S蘕 U<P    v _I_  _xZ   E   ;  _ "   __P_PMQj_PF   ؟ t&h  ؟PoSgU*o PuVhRh  SG GPRhRh  _S$ }   jh`訖*  GP_Rh4`h  ؏Sٟ h\Sآƃt{_QoPGuUBPMGuPGu9`PRh@`V[ Voj S_PUR(_ǅ_      S= t
9t#jh`j 詟  Gu9`P_Qh`h  ؏SО SEP-  _ڋ
tt   t   uBB)ھ  )PGPS*}u=_ڋtt   t
   uBB)ډ)Ph`=t& _ڋ
tt   t   uBB)ډ)Ph`S襏h\Sƃ   }uh`V裑_PoRGuMAPGuUPHR}u
aPh aVX Vlj S_QEP%U_  P  u$P  	(P  ~u}_cS= t
9t#jh`j 腝Pl__9 _@_~_R_P} u(_ ~jj h]MQc  TB   }u%_ ~j j hraEP5  TB   __[^_]U0  WVSƅ  jEP藒uVh   S,ډtt   t
   uBB)ڸ  )PhpVSMuVhah   S}Sdǃ }!hah  SRS9ǃ   h\W9Ã   UR PU P  t`IHRHRPE0P  ȅtBPE  PRUBPPhaS蓎0h  S迍PS荙 } | EPhbh   Sjt& h  R S9jP PUR1   ƃW蓍 P聎[^_]ÉUWVSu}E    ՍÃ      VEtWEE    E    EPV蓕} t$hb-VhbPI EP:tEP'jʛ    hb׌_u+ tUR&    h'  觉jVSxtEu
%   EE   Ee[^_]ÐUS]XB	~hbPqPh  E PXBS }") PQPShcP]]UXB~-HXBE P谒}
hc謋]ÐUWVS]ujǃSVGdBG=dBe[^_]US=dB tBdBX PadB@PPdB P?dBu]]Ív UWVS}dB1tZPWTu>tCFCdBPޘCPҘ SƘ   ދ[u1e[^_]ÉUVSudBtCPV"[ue[^]Ív U=dB ]UUM    Bt<}u]UWVSUE    E    u
E  1  À; tC; t
DB uu   t& u} t]E    }    ;$   {{   EP{WG}    } tUR脗jEPEE)؃PWEPF h@cUREPf uh@cj 蠘t	UBUÊCFu} t
t
t+E;E} tEPԖ;uv	v N;uvFDB u UEtzt8"t+B8"t&B8"t!Btt   t
   uBB+UЍe[^_]U0  WVSu]ǅ    } tj/Sot@PEPhBcEP=dB tURu1  t& t SVhBch   S S SPރVEP*.     h   SV|C URSEPj,  }  {  h  jdjdUREPU ]  v SEP=,  t
9, t#jh`cj 赓, , , P蜜	  hcVUR#  ƃu
   hcEPUR#  uVEPc*      <U4P  }  t'h  FPPUREPU ҃ t2Vh    WEP'  ÃtRSWEP(  9t}$ tBpU$PUR)  VEP)  [^_]Ív U<  WVS}ǅ    Whch   V贑Sj jV裂    u[V P譄uBWEPhBch  V^ VEPj   h  VEP+   Qv 1;sD    EPEPj EPEPPEP    tC;rPIW= ,  t
9$, t#jhcj 9 , $,  , P [^_]ÐUl  WVS]}u ǅ    PSj7   %   = @  uVEPURWSEP/JS$tVURh  WSUR  j VEP PWSEPURKtWO&    S=(,  t
9,, t#jhcj (, ,, (, P [^_]ÐU<0  WVSǅ      }   EPUR裣u1  URPhBcVΒV= Sj jWuX1;s=E$PU REPVURPEP1 tC;rÃR贌HW=0,  t
94, t#jhcj 0, 4, 0, PΗ   EPiSj jW uY1;s>U$RE PURj EPPUR_ tC;rPHW=8,  t
9<, t#jhcj 8, <, 8, P(} t#h     WEP[^_]U   WVS}uǅ    t WVhdh   S Wh+dh   S͌jS_uhSh?dh   S行S uAt	WVhUd	WhcdEPBjEPu
ǅ    u
WEP躑[^_]ÐUP  WVShndEPK ǅ    thtdP谌ǅ    hydUR  th~dSguEP  hdUR th~dS#uEP  hdURx hd]Sa ǅ    ǅ     |  v    ǅ    h  URS赍h   Vh  蟍  ȉʃtzt8"t+B8"t&B8"t!Btt   t
   uBB)ʸ   )PhdQ | t h  SS+VPRhdh  S     j/Sƃ    tt   t
   uBB)ڻ  )PhdP){tt   t   u@@))SSRz/}   EPUR荝ƃu1  􍝨SVhBch  S܈} WSj躁uCV|PRP]SjPR|SVEP   C  RPVhdh  SQ WSj2ug􍕨RPhdh  S V|RSP]SjPR|SVEPF      R=@,  t
9D, t#jhcj 3@, D, @, PS=H,  t
9L, t#jhcj H, L, H, PI  P=P,  t
9T, t#jhcj 菇P, T, P, PvR=X,  t
9\, t#jhcj >X, \, X, P襐4  ]SPjguLj |RS4PEPjRS|Pj UR   &     :  􍅨PRhdh  P SRj~uSj |SPPURjSP|Rj ]S0,  P=`,  t
9d, t#jhcj `, d, `, PǎR=h,  t
9l, t#jhcj 菅h, l, h, P  S=p,  t
9t, t#jhcj <p, t, p, P#P=x,  t
9|, t#jhcj x, |, x, PR   t& jVhd蔀   EPW胉xtt   t   uBBt)   v 1:tBAtt   t   u@@)9vȃhdP舁ƅ RS؈ u
    hdEPj h  SEP   U    t@t<V  PhBch  Sӂ SSEP  hdUR Phd]S PhdS PhdS PhdS PVP\BPEP@} t#h  VEP"X[^_]Ív UVSu]=dB uYtYh  j j =,  t
9, t#jhdj B, , , PVӃ u1jEPVee[^]U,   WVSEp(e    uSj@PUP  Pݤ h   SP S`BP\BEǅ    @  t& heUR heEP  heUR    1ۃuEPڣtUh eEP tP論ǃ u
Ueh   VP /t6VEPhBch   S SV_    u
ǅ%e  hydEP PURl   hdEP PUR   h'eEP PUR> g  E.e   P(1tօ   jUB@PUP  P蚢 h   h  P{E PURSPRPjUBPUP  P? PEP6R4e    uWURPPjUBPUP  P PEPUR t_W&    ֿ;e    u=EPPjUBPUP  P茡 PEPUR E@E[^_]U  WVSǅ    } R  Ee   P(1tօE  hBeUR ƃ  td      hJeEPa Ãt]UR贠t5j ShRepBPPbw hUep      h`e蛆p  heEP uU$h   SPEPPUREPtUREPUBPEP      e
    u UREPUBPEPK  ֿe
      hdUR ƃuJ=,  t
9, t#jhej (|, , , POheEP ÃuJ=,  t
9, t#jh fj {, , , PhydUR< PEPʑ    hdUR PEPm twh'eUR PEP蠒 tRh*fUR PSVEP`BUREPUBPEP tURU[^_]Ív Ul@  WVSEǅ    g  PEPz   1q  VUP  PP  PPh2fh    Sy} WSjrt;VUP  PPhdh    Sry WSjSru	U}    h    VEPD   VUP  PP  Phdh    Sx} WSjqt4VUP  Phdh    Sx WSjqu	E} t#h    VEP&V[^_]U<   WVSE1+  PEP辌u
1          t& SURPhBfh  Ww Sj jWh   1;s`P֑tPEP  PUR  tC;rPut& 1} 
  h   SEP       SURhBch  Wv Sj jWgu}1;sav PސtPEP  PUR  tC;rPt} t#h   SEP'[^_]UVSu]h eSL t5P\t%jCPP  P舙 Ph%ej Vr1e[^]ÐUWVS]E   E    hKfSܻ ƃ   j j
j VGqUtzt8&t+F8&t&F8&t!Ftt   t
   uFFF+w!$f
UhU^UV  wNC(P=,  t
9, t#jh`fj nu, , , PU~h eS tPE} i  [^  heS貺 EheS衺 E uEP觗tUU} uE%e}    hydST PEP    hdS. PUR舋    h'eS PEP躋    C(ƿ.e    u-jCPUP  P- PEPUREP=ƿ4e    u/jCPUP  P PEPURE [Ee[^_]ÉUWVSE    }   Ee   X(1tڅughBeUR ƃU  td    @  EPURUEBPEPjE   v ֿe
    uUBPEP6   t& ֿe
       hydURU PEP    hdUR, PEP膉 twh'eUR PEP蹉 tRUBPEP7޿4g    t޿;g    uUREPBEURUYEe[^_]ÉUWVS]E    t4s(4e    uECPEPE[űEe[^_]ÐU  WVS}Eh  P SsE  t&v >/u h  SW1  /F> uݍ[^_]U  WVS}h  EP S=sE  t&v >/u h  SW
  /F> u݋EPEPW
  [^_]Ív UdSjtgÃuR=,  t
9, t#jhDgj <p, , , P#y1M&    jtStECECECE CEPEPj:huEԉC؋]]Ív UlWVSjtafÃuF=,  t
9, t#jhDgj ~o, , , S  jtS'tEPnu[SEPV  =,  t
9, t#jhDgj o, , ,   t& E C<r  hRgEPCqCuZSEP  EP=,  t
9, t#jhUgj {n, , , P  PjjuVqe   @g       jjCPgCP^CC P|^CCCPd^CCC PI^	CCP'lC     hRgEPXq C5CPbCP`E PRjgEԃC{ uf{ u`{ uZSEPd  EP=,  t
9, t#jhlgj m, , ,    Cp      v EPEP`EP=,  t
9, t#jhgj l, , , P
uhgEPnC ugC    SEP{  EP=,  t
9, t#jhgj &l, , , P
u1'j EP\BPEP+CpCP,  ؍e[^_]UVSuUM1ۀzru-BtPQjVb_BtVQVPr G=,  t
9, t#jhgj dk, , , PKt؍e[^]U   WVS}]u)Åt$V=    ~    P PW-u֍[^_]ÐUS]{rux.    t$CuVC   jjPav    CtP[v CtPs uVjjPVcG=,  t
9, t#jhgj :j, , , P!s]]ÉUWVSu]U1{w   CtPRjVEmCtRVPMs ǃLP=,  t
9, t#jhgj i, , , Pr_{WVCP  Lt& =,  t
9, t#jhgj :i, , , P!re[^_]ÐUM   QtRZy t
j tv ]US]  CtdP*g   {w   P=,  t
9, t#jhgj xh, , , aCtcPv tS{wuMP= -  t
9- t#jhgj h - -  - Pp{p t*CP_  SpC,BC0BC4BC8BP
iSi]1]UlWVS}]WS=-  t
9- t#jh hj mg- - - PoSEPE PSjbu{E%   =   ulSZ}\@\ Ph[PS=-  t
9- t#jh`hj f- - - Po SWeƃ}[[ PZPS=-  t
9- t#jhhj `f- - - PGoWS\BPEPle[^_]UhUEPRj`uE%   =   u   1]U`VS]1EPSj0^uE%   = @     S= -  t
9$- t#jhhj e - $-  - PmEPSUƃ }dZ tkPYPS=(-  t
9,- t#jhhj e(- ,- (- Pmt& S\BPEP=e[^]ÉUWVS}]S=0-  t
94- t#jhhj d0- 4- 0- PmSWE PSZƃ}fY tlPXPS=8-  t
9<- t#jhhj d8- <- 8- P m    hhS\BPWe[^_]ÉUWVS}]S=@-  t
9D- t#jhhj c@- D- @- PlSWEUEU EPEPSjeƃ}gX tmPWPS=H-  t
9L- t#jhhj 
cH- L- H- Pk&    hhS\BPWe[^_]ÉUVSuEPVXÃ}YW P WPV=P-  t
9T- t#jh ij gbP- T- P- PNk؍e[^]Ív Ul  WVSEPEPj\  E%   = @     EPOaǃtb1:x.t4PEPh$ih  S+a SEPotƃWyeuW`[  EP=X-  t
9\- t#jh*ij VaX- \- X- Pi  =   u	u   hRgEPcÃ   SjjVXuj@g    uYjjSYSFQ S2Q	S!Q	 S
Q	ƃuԃS^LEP=`-  t
9d- t#jh*ij F``- d- `- Ph[^_]ÉUhUEPRj`X]UlWVSEE    P^Ɖtzt8#t+C8#t&C8#t!Ctt   t
   uCC}WVjWu,E%   = @  ujVvUu"E    j/V]ÃuV`Ee[^_]ÐUl  WVSǅ    h@iRÃ 
 /  ƅ  j:SPƅu?؉ރtzt8&t+F8&t&F8&t!Ftt   t
   uFF;~u9hEiQthEiQJiPWCcCC9v#)PSWYOhLiW[hNiW[EPW[ jWTu1PWjCVu%   =   u^> [^_]ÐU@  WVS|k!   ǅxhkP|hkPƃu:11G
w'|;|uD+Ptԋt+t!MQQVS;`SRxxX[^_]ÐtBUtP\w{hdEPY]Ujj&P ttBP҃tBPj ]Ív Uj]UEhnP=h-  t
9l- t#jhkj [h- l- h- PY]ÉU$  WVSǅ    ǅn   ǅ    ƅ  ƅ  j%Ohnj6P hnhnThn$Y p       $qP3U  P*Nj[[  hB   L  ttj j
j PUƃ)  =p-  t
9t- t#jhnj Zp- t- p- PPM      1   h o/Xj [h  PP\LB      t& h  PW`\PB   ]OjPáPXxBCxBUPkj YZt& hnEPURS/vuPtVaPWRPMtB ueR=x-  t
9|- t#jhPoj Xx- |- x- PP%LjY&    1^|Bޅth Ѓt|B uW=-  t
9- t#jhdoj mX- - - PPKj Y1ۃh~jKh~jK h~jK1 t  C
w$rtBP迅ƃ=xB PEPURtBP ЉÃu   tBP>{t`\tW  j=-  t
9- t#jhoj YW- - - Pл'tB@P   taPxztQ  j=-  t
9- t#jhoj V- - - P  tBPxh  tBP5~R  j=-  t
9- t#jh pj eV- - - P   tB@P      DP      PxP=-  t
9- t#jhpj U- - - Ph    S;U jS  л	   @P=-  t
9- t#jhpj U- - - Ph    STjS  л	    :tBPw   tBPH~uJ=-  t
9- t#jh qj T- - - P^tBP}PtBBPPRtB P4ftBPRvh u 	   l~tBPetBPeu
7xB*ËPtBPuMP=-  t
9- t#jhmqj S- - - P\[u   &    tBP    tBP        tBP ~   tBP ltBPg PtBP軛átB P耬tBP  tBP tBPI         ttBP҃ǅ   xBCxBPSSS =xB u҃W1[^_]ÐUS. v 9. u		 u. []ÐUVSu PV= P Ã tWS. P. PSDt'. P9 PV= P      e[^]Ív UVShgr. P! ƃ PV1= P Ã0tWS. PG. PSCt'. P蓿 PV< Ps   1e[^]UVSuZ PV< PM Ã tWS. P蹏. PSTCt'. P PVN< P 
  e[^]UVSuξ PV< P Ã t[S. PM.   PSBt).   Pu PV; PU      e[^]Ív UShur. P^ Ã% PSn; P Ã0t^S. P褎.   PSBt,.   P̽ PEP; P   ]1]UVSu蒽 PV: P Ã t[S. P.   PSAt).   P9 PV: P Q  e[^]U   WVS]jj j PEP@: P觫 hrSPƃ tk A؉tt   t   u@@)PSj j EPUR'
  Vh  SGuVlLj Ȥ PEP9 P5 [^_]U   Shr. P? Ã=. W  覣
 PS?9 Pi
 lB    . P     P=-  t
9- t#jhrj ,M- - - Ph     SsLjSx   h s. Pz Ãj
 PS8 P
    . Ppu/. P  @,@PRt. ,P  hs. P ÃjA
 PS
8 PD
 .    ]UUEPR   ]ÉU.    hsP菳 P
 .  tt:tj. P7 P7
 .     h(s. P6  jP h6s. P  jP hRs. P  jP ]ÉUWVShshis譫 . P  hs. P衲 ǃhs. P茲 á.  Puƃ         W׽ Vj Y
 PSb6 P WM h(s. P Ã j S h6s. P Ã j S hRs. Pб Ã j Sd e[^_]ÉUhs. P蛱 P .       .    ]ÉUhs. PW PҼ . . 	    tt:tj. P>5 P
 ]ÐU. tu
.    .     ]Ív U. tu
. 	   .     ]Ív U.    ]Ív U.    ]Ív U. 	   ]Ív U. 	   ]Ív U. ttt	u. 	   `j =-  t
9- t#jhsj qH- - - P  u. ]ÐUShs. P趯 Ãjk=
 PS3 P
 .    ]]ÉUEj P h}. P%]ÐU=.  u==-  t
9- t jhsj G- - - EPdm]UWVS. PÃht. PЮ ǃ ht. P踮 ƃtj D=-  t
9- t#jh#tj F- - - jV S-	 PWl2 P0	 e[^_]ÐU0VSh5t. P ƃt~. 8P  @P=-  t
9- t#jhHtj AF- - - Pj ]SES,	 PV1 P^/	  e[^]ÐU0VShNt. Pm ƃ   . P#R. P=-  t
9- t#jhHtj E- - - Pj ]SDSD,	 PV
1 P.	  e[^]Ív USE]Pn PS0 Pw ]]UWVS]s(_t    u^j j S. PP} tUt8tjEPj0 t& EP
  tjP [tURSn[ue[^_]ÉUWVS]hft. Pի ƃhrt. P ǃ 4
 PS/ @HPV?  
 PS/ @HPW  
 PS/ @Ht2ht. PJ Ã PSZ/ P 01utP. P艂e[^_]ÉUWVS]httt8tjS. P
 ƃ  ht. P褪 E
 PS.  @HtAj htP. PX  EPS[u  jhtP. PρXZ  &    C(ƿ_t       j j S. PsP} tUt8tjEP- EP
 ƃ    j (
 PV- PX
 j V-     t& ƿt
       {   j j W. P˄P} tUt8tjEPH- v EP
 ƃ t+j 聗
 PV- P豛
 j V  z[. P  @,@PRm¡. 8P  ge[^_]ÐUS]
 PS, . HH,P  $Ȉ,P  ]]U.    ]Ív U.     ]Ív U.    ]Ív UWVS]k` ƃS)	 E=-  t
9- t#jhtj 4@- - - P# . tt8tjV+ t& Phhttt8tjSy+ t& P tt8tjVK+     Phhttt8tjV+ t& P( }  =-  t
9- t#jhtj ?- - - P ǃ= .  t
9. t#jhtj > . .  . P踽 Ãtt8tjVI* t& Phhttt8tjW* t& P( tt8tjV)     Phhttt8tjS) t& P Wg P] PV) @dP) Pz  Sxg P\ PVX) @dPL) Pz EPAg P\ PV!) @`P) Plz =.  t
9. t#jhtj #=. . . P! PV( P% jb! PV( Pb-  jB! PV{( P+ V  =. u	 =. tVv . e[^_]Ív U,  WVSht/ht. Pޣ .  PC_tP5 `  ǅ    j. P2u. Pj } ǅ    . P  @,@   r(t       R1w    htP   h  2ÃuR=.  t
9. t#jhuj 4;. . . PPa.X  SV. Px`. Ahtj =ƃU@ u*=B t!`. B1ҋ< u냽 t`. B`.     ǅ    =`.      . P[P`. Phtuh  Wj901@WPz,tUFVR~ u׃j`. P/u%WW8PQC{ `. < 7Q\ PP % P^ P蓧 PZ\ PQ$ @DP$ PX  h  P. P:;j \ PQy$ PP] [^_]Ív U  WVSǅ   hft. P . P{[ tPm )  ǅ    j.   P=.u(.   Pj y ǅ    hzuq+ƃ   ǅ    h  VS%:E    1Ҋ<:ttBC<:tu; uǅ   v  t}.   PW	*tb?.t]1t& WP)tCFVP~{ u׃jW0-uWPx  uC<:t5ht[*ƃtX1VPd)tCCSPz u׃jV,uVP?x  t+PY PP" P[  tD tZP{ t%j P&z  P. Pu  tP}{ uS tJ= .  t
9$. t#jhuj 5 . $.  . P>.   Pݣ PX PP! @DP! P袦 j uX PP  PY [^_]ÉUShu. P蒜 Ãt/EPEP	t
j SRS G=(.  t
9,. t#jhuj 4(. ,. (. P=]]U  WVSv h  j P&6h
vEPy ÃSURgJ   hvMQy ÃSEPK   hvURy ÃSMQ5K n  Ex   @4P P  P- 0: t[R	 P'  j j j 蓆 PQ P PEP P觝  RŐ   j j MQEPvM1҃ 9}Nىƃ~t%~~ƅ      B
 B9}
 D D D 9| ډtt   t
   uBB)ڸ   )PRSx#MQ]Ut>SBPE B PP P{E B0V}$ t=SU(PD ZB PQ P7E U(0S MQEPvÃt:UR
 tj SQ j SP1
 P
 j(UPht tt8tjP Pd
  ht. P芘 ERQt
t8tjMQ{ 	    EP
  hvEPCv t<hth'vURfx j 詃 PQ P  h'vEPu Ã} ~MI
 PE P P	
  u+j E PtR P* j j j  PQ P蝖 PEPs P* U Rhܗh/v tt8tjP. P R  t8޿t    u%jG
 PQ Pq
 jhtEPUR3nMI   E@_t   B( u6j j QPURMQPURMQ0dƿt
    uQǅ    Xt:VjRQEPURSMQEP[0űR3M@P      Q]   } tEPU@P  P?  M@P  P?  tbRPE  tKj 讃
 PQA P؇
 j P  jhtURMQl[^_]Ív U  VS]7v7v BBh  j P.h   S ShCv. Ph ƃ/ PVx @<P|V PVe Pk 0V@ Sj PB(P{  tBPR"
 ÃS  SV PV PXi     VG [^]Ív U  WVS}.     =. EPEP	  hrhisV. u  P+*hthis) .  htP+ ÃN PS> XT hgr. P j hhOvtt8tjS P0  j hhdvtt8tjV P hft. P聒 Ã N PS XThur. PW ƃ j hdhOvtt8tjSP P j h̊hdvtt8tjV PP .  P ht. Pȑ ƃ DP   tfWLPGP=0.  t
94. t#jhtvj )0. 4. 0. Ph    S1)0WGP=8.  t
9<. t#jhvj )8. <. 8. Ph    S(؃P
 PV PS hs. P̐ Ã WRt.     .    t& .    .    } tjWWLtBj "
 PS{ P貀
 hv. P; Ã j S j
 PS9 Pp
 . PkSu_h(s. P j Pz  h6s. P P;  hv. P衏 P  hv. P肏 Ãt#ht	 PS P	 hv. PC Ãt#ht~	 PSG P	 WJ   hv. P ÃtSb hNt. PȎ ÃtS: hv. P蠎 ÃtS h5t. Px ÃtS hv. PP ÃtS hv. P( ÃtS蚙 =LB t#ht. P Ãj S  =PB t#hft. Pˍ Ãj Sb  WNJtxhft. P蘍 ÃtS
 hrt. Pp ÃtS hu. PH ÃtS躘 WIuWIu(hw. P  ÃtSr P  @,@PW蕱8P  Wn t5h s. P謌 Ãj!{
 PS PQ
  V5 W-GP0jC	 PV| P Vj . [^_]UWVShshis . PK  hs. P Ãh!w. P ǃ t{twh@wZ5 ƃS? E PMPV PW PK S觓 jZ PS PZ  b
.    . e[^_]Ív UEPGt.    .    . ]ÐUhv. P jP  ]U	t& 諢	 V	 u]ÉUWVS=lB tJhs. P蓊 ÃjH
 PS Pz
 .         t& ht. PI Eh}w. P3 E PhPL PEP6 Pk UP  ǂ8P      @,@EB    `  E_t   P(1tօu*j j j j UREPURj EP0  t
    uNUE    Z  u    Vjj j EPURSj EP2[0u  v ֿw
      h
vURg PEP7 c  hvURf PEPF8 :  hvURf PEPu8   hwURf    = Ãj j j 
t PS P藇 PEPm P$  SX hwUR4f P		 Ã0j
j j s PS! P5 PEP P  S UZt<j j j j EPURShwEPe PUR[0uċE@Ec25UP  @,@PRJe[^_]U<  WVSEM=. u1  t@t<1҉߭ȉٝ߭ؽٝ
ǅ  ?wمٽff
 f٭۝٭
Bٽff f٭۝٭9  مD@uB    v مBhv. P
 ǃt"EPI	 PW
 P	 hv. Pυ ǃ0  EPhwh    V. ډ؃tzt80t-@80t(@80t#@tt   t   u@@)PSVuTډ؃tzt80t-@80t(@80t#@tt   t   u@@)؍DPVN"tt   t   u@@)(~DPV"V	 PW PY	 hw. P ǃ` PW P@) M1ҋ4P  ߭ٝ8P  ߭ؽٕ Euǅ  ?Eu
ǅ    hw. P΃ ǃ PW P(  腛	 0	 u   [^_]ÉUSht. Pj tt:tjPq @   . t;hsP) Ãj
 PS7 Pns
  Vt& his=@.  t
9D. t#jhwj 5@. D. @. PPb]]Ív UWVShs. P脂 ƃj9
 PV Pr
  hw. PO ƋEPr<P	 PVR P	 E0PVIǃt4hx. P ƃW@	 PV	 P	  E1ۃPJƿt    uhx.    t& h'x. P艁 P th}EP-rae[^_]Ív U  WVS}hs. P. ƃj
 PV< Psq
  h4x. P ƃGP< 	 PV P	  hLx. P ƃ   tita   tXP=H.  t
9L. t#jh`xj H. L. H. Ph    S)
ƅ   P PVN P	 hx. P ƃ t&    tt	   uVf WFCu(hRs. P ƃtV. [^_]ÐUVS]1=hB uuj |td(CCC$CCXC ĚC$<C(CԷCs,C0   P	   e[^]ÉU1]Ív U1]Ð$U<WVSæ u}ș)щșEPWEPUR.>e[^_]ÉU   ]U   ]Ë$US@ UEPRz]]Ë$U   WVS Etzt8"t+B8"t&B8"t!Btt   t
   uBB+UB0ǅ$    ǅ<    Hj@PE \  Uǅ4    RjuVEP <jPVtjPV   U}24Rjh PUR躩<hE |PxPtPpPlPhPdP`P\PXPTPPPLPP PBP/      j=PV   URjF PUR<FE dPxP`PDP\PXPTPPPLP@PHP P@҉lDAhEp҉t@U0  td   94 t*jsPj 0 d   4 0 P"EtP0xPc
UERPPEP
EPxP0EPUR蘧<x< j
P0EP  j<VEPURP%   = @  u4EPEP股P%  PEPUR   =   u*{u!P%  PEPEPҭ  P%   = `  u;j{u2ptRPP%  `PEPURKt& P%   =    uB{u9ptRPP%   PEPEP4 2  P%   =   u
z  P%   =   ukzubd@PfURdPWEP˥d<8 E PWURөW       ?zt/EPwyuEPdPUR[  PEPE1PO8  d,  8<PWREP迦(),4    |    1
DDDDDDDDD	D
DDD
DDƃ  ~U(4P  } t)URdP+,PEPEPU҃ tC, t:EP,=    v    PHREPǃ4 tg|t]9tYEP8  td   9< t*jPj ]8 d   < 8 P>d8$PUR<P%  PEP  -&    EPdPUR衣d<j<PUREPxUREP蕥UREP讥Et	P$[^_]Ë$UVSǶ uUPRVru	1t& EPEPEPRVfe[^]ÐU   ]U   ]Ë$UWVSN }uVPVWx e[^_]Ð$U,"  WVS uEPVPǅ    	PVUR萝   i  t& H    PURPh     We PVdPPV|P
  y  	 <2g  t <0t  &    <5o    v ?ut7 Rttu!WPEP  ǅ    P R}W<ǃ  r  wWPPUR軡U4P  )} t,EPRP REPU҃ t1N~*Ph   REP舟=   ]WUReP W+    s   WPEPZ   s   PWURؙ   v PWH  td   9L t*j(Pj 
H d   L H PwPh   R}W聞NڋR}Wu<Ph    RW2   PUR[^_]ÐU   ]U   ]Ë$US  UEPR:]]Ð$U<D  WVS˱ Eǅ    P V$j/Vt   PPPURhPh    VJ j VEP lt􍃐PR}WVh    P tt   t   u@@@   PURP PURZ Իػu P\  R PEPPh    R/ tt   t   u@@@  P PUR謗  PԻRػPh    R tt   t   u@@@   PREPE  Rh     WEPƃ~eRVWEP艜9tPU4P  } t%EPRPUREPU҃ PUR'XPUR=PUR* PԻRػPh    RJܻ tt   t   u@@@   Pv[^_]ÐUSEj/PXh{S  ؋]]Ív USE]U8/uRPS|    PE   Ph{RSk؋]]ÉUWVS]u   VSqt<VS09u.tt   t   u@@)D؍e[^_]ÉUWVSE1۾ 1 8 tmt& 1PU1ҍt& 8Hu-Ht*  w"t& FCAt  v	G~u  w FCE8 u  w  1 [^_]UUEj@PP& ]Ív UUMA(    tB(uJ(
]ÉUh|u|]U  SPLE  Ph|h   S h`q j jSu(=`q  tdq q     Pv 1]Uq ;`q s dq Pq Y	&    1]ÉUWVSMu]}UE<*u*AFJU8JUKt1Pu}.uAFKtPu9.t UtAGJtu [^_]ÐUWVS}]M~F7> t?DPt0&    CPI~րx tPDPu [^_]ÐUVS]j j
j PơDPtȍQPDPue[^]UL  WVSh    Ph   ]SEP] h    Ph   VEPmE1u 8   À    Pt
DBu   DB   DBt2EPÃEP 9tc       j VEPKj SEP6 SV tSV| [E8.u@EE8.u@EuEÀ; tEƀ> 
E DBtE DBu   [^_]ÉU,  WVSj/E1PtURi ǃ   PA  Ph|h   V h Q j jVug Q t^1 Q C9sL$Q PPEP\ uѡ$Q Ph5|h  V|V ǃ u1  h@  8ǂ@      h<|G,PiD ƃ j@VPhA|G,P;D ƃt"h   VDP t& @D hF|G,PC ƃh  V   S hK|G,PC ƃth  V0  PR fǂ0  . hR|G,PyC ƃh  V  P E8/uh  P   P,PSh]|h     P hq|G,PB ƍPPh||V\ u$ ~PRh|PKǂ@      ǂ@      G,@      p(}
    ]  j$LPh<|PB PBh
}PA PBhR|PA ƃtVB
@    h}R{A ƃ1t	>yBt@  B    B    @  B @  R
  }   B(   jPh<|P@ PBB    BBPRE  j,JÃCjPW$}   P( uEh)}P@ 1Q  P9  CBCBC BC$'  ֿ-}
   1tu
     ֿ7}    u
      ֿ?}    u
      ֿD}    u
      v uBu
BuBu   &    ֿO}    u`hV}   R> ƃtCHPVu	C    $HPVuC      S{h[}P> ƃt>yu	C   C    hc}PT> ƃtCPhh}Vt& C  RPƃVCPSR   ƿO}       j,ËC   hV}P= ƃ tAHPViuC    "t& HPVEuC   RPP5CBC(Z@Rn[^_]Ív U,   WVS8  Phk}h   Sdh  S ډtt   t
   uBB)ڸ  )Pht}Sh  Sډtt   t
   uBB)ڸ  )Ph}Swڋtt   t
   uBB)ڸ  )PPS3h  S2EPh}h   VX h  Vh} ǃ u
1X      ڋtt   t
   uBB)ڸ  )Ph}Sڋtt   t
   uBB)ڸ  )PEPSRڋtt   t
   uBB)ڸ  )Ph{Stt   t
   uBB)  )Ph}Vtt   t
   uBB)  )PEPVtt   t
   uBB)  )Ph{VGSSV! }Sh}PFEPh}h  VOh  V h@  qƉ>ǆ@     ǆ@      ǆ@      j h}j W G, j@EPFPEPh<|G,PL; } t3h   EPFDPEPhA|G,P; FD j jh||h  Sy Shq|G,P: h  EP   P9EPhF|G,P: h  EP  Pfǆ0  . EPhR|G,Pq: EPEPh]|h     P[^_]ÐUVS]uh  V   PVhF|@,P: ǃ@     e[^]Ív UVS]uh  V0  PAVhK|@,P9 ǃ@     e[^]Ív UVS]uh  V  PVhR|@,Pf9 ǃ@     e[^]Ív UWVSE@   t PE   PI U@  U   EU@ EztMGEwt!^(FPEV<ރ uߋGP'W} uUrt'    ^(FPVރ uߋUBPUBPU BPEPUU "EP1e[^_]ÉU  WVSE@       E       Xt:CPPh}h  V# V[(űptN^t@{u-CPPh}h  W W3[(uƋvu@ GE   P]   Sh}h  Pj P}h ~Sh}h  P*P{ }h@~S[}h~EPPO0  Ph~h  P PEP1[^_]Ív UE]Ív UE]@  UU1tB ]ÐUE]@  UVSEu@  tVCPOu	[ u1e[^]ÉUE]@Ív UE]@Ív UWVU@t/p(~    uPBPWt& @u1e^_]ÉUWVSUBǀ@     Xt2s(~    uS S   [u΃} tEP:Ph~j UPO e[^_]ÐUVSE1PR  S  ƃSI  Ãue[^]ÐUE]@Ív UVSu^@   t(j h}@   P4 @  @    h~h}P3 @  ǃ@     e[^]Ív UWVS}j h}j @,P` ƃ   j$QËE3{PKUCR9CC    @   ESǇ@     Ph<|V*3 URh
}V3  { th~h}V2 @  C    C    @  C @  t& 1e[^_]U  WVSUǅ    P ]P C PCPC Ps   F^tm t& S({u2CPUB   Ph}h  W WCPWSN uFP5V, ]]st` &    ^(FPUB   Ph}h  W WbFP Vރu]C@  t;;Mu) tUB C EP@ @  I uŋUBǀ@     RM[^_]UVSu]ShR|P0 FP tSuFF    e[^]UVS]uVh
}Pm0 CP V)CCǀ@     e[^]UUBuB  ]Ív UE]@Ív UU1tB]ÐUVSEuXt&&    VCPu	[u1e[^]ÉUE]@Ív UlWVSE1P  Ãt8}S[  WPjuuԃS  Ãủe[^_]UWVS}j h}j P ƃu
1]    jËE3{PCGCC    G_ǀ@     EPh<|V. ؍e[^_]Ív U  WVSuǅ    P P F P^ti C({u2CPF@   Ph}h  W WCPuSl uFHt79u% tFBt& VFBIuʋF@ǀ@     V[^_]UE]@Ív UU1tB(]ÐUVSEuXt"CPVuv [(u1e[^]ÉUE]@Ív UUBv(h  h`Q BPB@@P`Q t& B]ÐUE]@Ív U VSuEFPh~j]S*Shc}P, F@e؋@ǀ@     [^]ÐUE]@Ív US]EC~t~Rh[}P9, C@@ǀ@     ]]Ív UE]@Ív UE@]@UE@@]@ÐUU1z uB]Ív U  WVSuǅ    ^tc Cwh  CPWh  WCPF@PM VFPCPRE[(u[^_]ÉUWVS} tnE@  tawtSt& ^t@Cv.CPEPEPPuv [(uvu u1e[^_]Ív U   WVS]h  VEPUB@PVEPVj`}1"  j,ǋEPGGjPE%   =      G    tURgt& E8/ujxSP<URUBx@   Ph{h  VA jxSV!  EP-Ph$}j UPB  Sh)}Pr) S   GBGBG BG$   = @  u!EG   PPh-}   v =   uyEG   PPh7}j UP  h  xSV}Vh~P"D   Sh*  &    =   u0EG   PPh?}j UP/     = `  u5EG   PPhD}j UP  hP=    t    G   1   EG   PPhD}j UP  h%hV}P' EȋU%   Phj
]S3 ShP' EPhj
S
 ShPu' EG    G  GPWUB@ǀ@     X[^_]Ív U<   WVSU]B  $D&    t3Sc  Sh)}}P&    UB8/ujSP9P}G @   Ph{h  V
 jSVM  Sh)}UPZ& S  u¹   1t tjEP}GBGBG BG$UB   }G8/u*h   SPǃ}qUBPNP}G@   Ph{h  V h   SV~ǃ}Vh*P| ShUP>% }G@ǀ@     E[^_]Ív UWVS]}WC@PƃVS} tURPS7    C@PWtP  EPVSe[^_]ÐU   WVSh   SUBPB@@P>uFT  $hj  P`&  jW R  h)}uP!    j PW   t& P Rj  huPj!   h  S P| RS[     S  P Vj"  hV}UP  	      u%   = `  u%    u%   =    \hUPd  t5j j
j V9hUP  tBj j
j Vq9t)t& j  P3}   t& 1h[^_]ÐUVS]uP P(  9uC(R(t9Z(uC(B(CPSe[^]US]EPC@PPS u CPRSC@ǀ@     1]]ÉUSUt*Zt#CPRC@ǀ@     1]]UWVSu]j,ǋEPQPhK}j Pi 0Sh
}P  EPhj
]S	 ShPq  ~} t~PhPM  EwPGG   FG(F~e؋@ǀ@     1[^_]UEǀ@     ]Ív U  WVS}WE   Ph}h   SB hSAÃu1   j,WƃhSE PhSh  SP( SWPhO}j EP M0HPhV}R Eǀ@     WMFF   N[^_]ÉUVSu]MUFPRQSPuB    FB(V1e[^]ÐUVSu]MFU@PRQSPkurFB(V1e[^]Ív UlWVS}]EEPSj   Eԃ@PƃhS{Ã tXSjEPVSLE0 G PVEPEPP tB    GB(WE    VEe[^_]UlWVS}]EEPSj   Eԃ@PƃhSÃ tWSjEPVASE0 G @PVEPEPP tzGB(WE    VEe[^_]ÐU  WVS}Eǅ    P G   Ph}h  S jSu*SC}hoǅ   _tA&    EPCPuGPSGǀ@     a[(uƋwtM^t?EPCP|u!FPSGǀ@     t& [(uvu[^_]ÐU  SEu17v PE   Phh   S S5   ]ÉUWVSE1Xt'U9SuCPUBPxǃ[(uًEpt>^t0v {u U9SuCPUBP7ǃ[(uӋvue[^_]UlWVSjhh`a h`a ǃ}
h   j EPƃ|vEPVj{EԃPËEԃPSV\Eԃ PSWKSR Vh  W W`a h1e[^_]Ív U|   WVS  ǅ      Phh   Sh  S Y  Ph"h  Sh  Sz h}Sh  VSGh  SFh}Sh    PSh  S
h9SLj SA  ShDh   ShSƃ    􍅤PPPhQV> VEPǃ t	W
    EPhDh  ShS_ƃtn􍅘PPPhQV V9|"u*9|u9}
ǅ   t,WkhZ
ǅ      SEPjh`EPǃ   hc PƃthPWPjS VPjS4S h  VGPnV  PhfPWt& EPhPhƃ  }   V  Phh   P h   P/h Phh   PVEPhh   P#0j PtDVEPh h   P j Pv
t&       P Pjh` Pǃ   V  Ph`h   P[ hc PTƃtLPlWPjS VPjSS VWEPOƍ   Phh   P h PÃtD􍆾   Pj jhS_ h  S苾PSYv  Ph@P1x[^_]ÐUE #Eg@@ܺ@vT2@    @T    ]ÐU\WVSEu}HMX@E   3E#E3EExj׹   UEM1!1EčV   ȉЉE3E#E3EEȍp $   ]EM1!1E̍νȹ   ؉E3E#E3EEЍ|   UEM1!1Eԍ*ƇGȉЉE3E#E3EE؍F0   ]EM1!1E܍Fȹ   ؉E3E#E3EEؘi   UEM1!1E䍌DȉЉE3E#E3EE荜[   ]EM1!1E썌\ȹ   ؉E3E#E3EE"k   UEM1!1EqȉЉEЋ}3E#E3ECy   ]EM1!1E!Iȹ   ؉E1#E1Ečb%   UЋM3E!3EE؍@@ȹ	   ЉE1#E1E썜QZ^&   ]؋M3E!3EEǶȹ   ؉E1#E1Eԍ]/ֹ   UЋM3E!3EE荌SDȹ	   ЉE1#E1Eع   ]؋M3E!3EEЍȹ   ؉E1#E1E䍔!   UЋM3E!3E7Éȹ	   ЉE1#E1E̍
   ]؋M3E!3EEZEȹ   ؉E1#E1E㩹   UЋM3E!3EEȍȹ	   ЉE1#E1E܍og   ]؋M3E!3EEL*ȹ   ؉E13EEԍB9   UЋM3E1Eqȹ   ЉE13EE썜"am   ]؋M3E18ȹ   ؉E13EEčD꾤   UЋM3E1EЍKȹ   ЉE13EE܍`K   ]؋M3E1E荌pȹ   ؉E13EE~(   UЋM3E1E'ȹ   ЉE13EE̍0Թ   ]؋M3E1E؍ȹ   ؉E13EE䍔9ٹ   UЋM3E1Eȹ   ЉE13EE|   ]؋M3E1EȍeVĉȹ   ؉EEE1ED")   U؋M	3EE܍*Cȹ
   ЉEEE1#   ]ЋM	3EEԍ9   ȉ؉EEE1EY[e   U؋M	3EE̍ȹ
   ЉEEE1E荜}   ]ЋM	3EEč]ȉ؉EEE1EO~o   U؋M	3EE,ȹ
   ЉEEE1E؍C   ]ЋM	3EENȉ؉EEE1EЍ~S   U؋M	3EE썌5:ȹ
   ЉEEE1Eȍ*   ]ЋM	3EE䍌ӆȉ؋MAYEA[^_]Ív UWVSu}]~T@uFPVFT    F   VTtTt?N
GFTKtVT?~j j VtHWVJFT    F@?wޅtVT?N
GFTKtVT?~e[^_]ÐU,WVS]j j SC9ST։9sG9sGǃ7`CCTSTEumumum}m}m}mCE7   Ev  CTST7~CCTSTEumumum}m}m}mCE?E&     CTST?~j j Sj8UR'CLUSMECNUSOCPUSQECRUSSEPSCCUCBCBe[^_]ÉUWVS}H11Ҿq 92B9$2BA~Ƃq  q [^_]UWVS}wfEyE11ۍEE    ;EC;Ej jj ECP臻q F~Ըq e[^_]ÐUl  WVS]} thzS ƃt􍝨SI PSPh   SV	 uփ􍅨P/V    hzSƃuS褲􍝨S PSP Vh   jS[u׃􍅨PV茽 WPEP1[^_]ÐUhQu]Uhq ѹq ]U  WVShui1 IF    ;tj Puuߋ;t3Phh    S谽S'u
[^_]ÉU=I u)yPӲt@P蠼I=I u hBIu
II]ÉU  WVSE}hP    E     tVh    PʃtV9 tۋDC tB: uÅt59 t0A9 t"DBt9 tWURhQ)V][^_]U  WVSE1hPAƃtC URPt   Vh   SEu΃V[^_]ÉUVSu]j hׅWuSVhׅ      v j h%uSVh[      j huSVh+      j hűuSVh   ht& j h'蕱uSVh'   8t& h>hHru1v SVhH   e[^]ÐUSMh)ڃtjRhP?j襻Q)ڃl~jlRhP]]Ív UWVS]t{ tCtRu
Qv +PR ~)KK EPPZ 3FS 9t{CF)׉Sȍe[^_]UWVSut^tFtJu`)   9Av1Pz uz u: uz uz |ߋEPP ËAV 9t~FA)׉V؍e[^_]UVS]ts{ tmCtfRt_+=   ~PRa ~)CC Bx   w.h  R0 AS 9tsCA)։Se[^]Ív UVS]uC,9C(|: S,PC0P8C0uhP1v S(C04C(s$C(e[^]ÐUMA(12v PQ(~A0DA$A$    Q(A0    ȉ]ÐUVS]uC<9C8|7 S<PC@P脵C@uhPW1S8C@4C8s4C8e[^]UMA812v PQ8~A@DA4A4    Q8A@    ȉ]ÐUVS]u   9   |@    P   Pȴ   uhP蘪1!      4         e[^]ÉUM   1BP   ~   D   ǁ                 ȉ]ÉUS]{(u1]t& S Pn   S$B 8 u#h   RJS{| tC|
C$@ ]]UEt
PEP&]ÉUS]thCtPVCtPCS$tCt	P҃tP: j(jS蚷S]]Ív US]j(@u-CT   tPXth CPCT   1E@    @    @    @    @   @        @$    @     @    ]]UVS]uu.CT   tPXth`CPCT      ~    H   $CT      PX   h\SFPFP    v    PX   FPh CT   tsPXtlFPh CPXt& CT   tFPXt?FPh`CP+SOtFBFBFBFB1e[^]ÉUVSMut.QÃt>ssV9   C*    AT   tPXthAP1e[^]Ív U  WVS1}    j EP2 ƃ   UB$t?@t8URPhшS:j S
 ƃ tS! ǃuIU   t8URPhшSj S
 ƃ tIS ǃt7uEP ǃURÃut	W褳1KEPC{3F CFU C    utWP  U   ؍[^_]UWVS]jh蒨ǃuhPjiC0C(    C,   C$    C    C    CCX    C\    C     C`    Cx    C|    ǃ       j(C@C8    C<
   C4     j(٧   ǃ       ǃ   
   ǃ       u
 J; J   II[C    C   Cd   Sh   [ltCp
Ctd
Cp    Ct    ICCD    ǃ       ǃ       CT    CHP e[^_]US]   PSuPiSu䋃   tPCC@tP0C0tPCtP
CtPt= JtPް   tPȰS輰]]ÐUSh    ÃtSF(    h PqhL41]]Ív US]CHP: S]]ÉUVS]1C|tC|      C$P:&i  z#_  zxU     A  t& t/Wt& C$@ /~Dt9~9&    C$@ 9$t	t  C$@ t   t
`Uv C$@ `~Dtf~9&    C$@ f$t	t   C$@ t   t
@Sv C$@ @~BtF~7&    C$@ F"t	tFv C$@ t4CT   tPXth`CP҃C    1   {| tC|       S$B8 u h   RS:HS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
	  C$@8&uSr  K|t;t& C$@8;C|    C|t
&t  A8&  Ax#     AO      t/Ut& C$@ /~Bt9~7&    C$@ 9" ttEC$@ t4CT   tPXthCP҃C    1   {| tC|       S$B8 u h   RSzHS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSM  C$@8&uS  C|t;v C$@8;C|t
;tOv C$@8;uAC$   @3&    CT   tPXthCP҃C    F=  v)	t$
t
t  =  v
  = w,CT	   tPXtVh CPC    1e[^]UWVS}1҃}   M  Ɗ&   N#u~~xux;   C<	wÍTI&    C<wÍT/C<vGT   tvPXtoh`\ÍTF;udt& &uc#u^pX;tPC<	wÍTP0GT   tPXthGP҃G    1F;u;u+F(GT   t~PXtwhGPgt& E0B=  v)	t$
t
t  =  v
  = w0t& GT	   tHXtRh GPG    1e[^_]ÉUWVS]1{| `  S$B8&Q  h   RS$B8 u!h   RSS|t
&t  v C$@8&   C$@x#   Cx@  $CT
   N  PXC  h#0  t& CT   !  PX  h3  &    CT      PX   hG   &    CT
      PX   h`   &    SC|  Cx@   $CT   tpPXtihYCT   tRPXtKh;CT   t4PXt-hCT   tPXthCPC    b  tC|       S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uS  C$@8&uS2SH  ƃu5CT   tPXthCPC    C|&   `  V  C$@<;t;CT   tPXth CP҃C    C|&      V>     @Љ   V$  C$ PBPtPtVCP҉ǃuIV ǃu7CT   tPXtVh@CP҃C    Ht& ?u-CT   tPXtVhCP҃C    ?uG C|V%t& WSPS\ Ve[^_]ÉUWVS]1{|   C$@8%z  Cx@   $(CT   u  PXj  h W  CT   L  PXA  h4.  &    CT     PX  hL   &    {` u
{(  {| tC|       S$B8 u#h   R]SKv S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSSG  ƃu5CT   tPXthCPC      &    S|t
;t  C$@8;x  tC|       S$B8 u%h   R?SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uStP`tVCP҉ǃu_{t{X u+{\ u%   PX   Vh   tPTtVhCP҃Cd    lwWS8PS It& t7PXt0VhCT   tPXth CP҃C    V7e[^_]ÐU,WVSEEE  EUUMME    PWEu
hU}z| tR|h蕒1  MA$@E9E    &5  MA$@x#uQQGEp  E  EP EN  Uz tdp> t>EFG+]9~MɉMQEP%E5뽋UBPJ  MLM  UBP,  MËEDIME&EG+u)؃9~6U҉URMQ袛E
UKBUG;Gb  %u[EtU}   MQ EP)Uz| [  B$@8 L  z(A  &    EGE+]9~'MɉMQEPEߋUz| tB|       MQ$B8 u#h   REPxIMQ$B8
uBA$@   BUB$@   R$B8 uh   RMA$@8%uQGUB$@8&uRMy| tQ|UB$@M9Ms:Ut:Ut
:Ut( Ee[^_]ÉUWVSUUE  UEEEEREu h
h71  E}  &'  x#u#EPEP  G  E   EPUR Ã  Ex tT[; q  ECG+u9~'U҉UREPʘE8; u)  CP  [Ɖ]&EG+])9~;U҉UREPmEt& UNBUG;G       %unEthEPEPi Ã   [; tECG+u9~'U҉UREPڗEH; u<EG+]9~'U҉UREP蚗EEEt:Ut:Ut
:Ut Ee[^_]ÐUS]E@  $ĒCT   tPXthCPC    z  CT    g  PX\  h%  &    CT    7  PX,  h   &    CT      PX  h`  &    CT      PX  h  &    CT      PX  he  &    CT    w  PXl  h 5  &    CT    G  PX<  h`  &    CT      PX  h  &    CT      PX  h  &    CT      PX  h u  &    CT      PX|  h`E  &    CT    W  PXL  h  &    CT    '  PX  h   &    CT       PX   h    &    CT       PX   h`   &    CT       PX   hXCT    tuPXtnh:CT    tWPXtPh CT    t9PXt2h`CP"CT    tPXthCPҋ]]ÐUWVS}} tC|?wV貌ÃtWEPS+ Vh P1e[^_]Ív UMʅu1(t& B<w<	t<
t<
t)RQa]ÐUWVS}ut-|)^S
uSh P萈119}
:
B9| ȍe[^_]ÐUUЅu1: t@8 u)PRm]ÐUS]Muu1@9&    u   't& )ACu; t9 u)[]ÐUVS]Mu~&utB&    u   0t& 1')ACuN~; t9 u)[^]Ív UEUu	18t@8 u1]Ív UWVS]}t8t4W   ƃu 8uVWS2tC; u1e[^_]ÐUSEM]t,|(|$19}8 t@B9|8 tSPD1]]Ív UU1t: t
v B@: u]ÐUWVSu}    } x   uEPURdVEEEGWVCÃ t&UURURPE t& Wh@Pe[^_]USE]مt7uS(Aw	t
t
t)QSP]]Ív UVS]uM19}!t& 2< t<	t<
t<
   B9|St C4@(PR]J    tp    ugS|t
<u[    C$@8<uHK4tAy u"t<t
C$@8<uC$@x/tQ u
C4x4 t+1,P uC4@t
P uո   e[^]UVSu]Fu/CT   tPXtFPhCPC    BP~VSPStRDtPFPCPҍe[^]ÐU  WVS]1C|t@~8v C$@1 @~#S|t
Z1  C$@ Z  t	`~6C$@ `~$tz   t& C$@ z   t
   ~7C$@ =   ~%t
      C$@ =      t
   ~0C$@ =   ~t
   qC$@ =   ~at   ~3C$@ =   ~ t   4C$@ =   ~"t_ut& C$@8_t1    v C$@8  F{| tC|v C$@ :{| tC|       v S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2    hPl   v C$@8  {| tC|       S$B8 u$h   RSLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RPC$@8%uSC$@8&uSBS|t@/C$@ @~!tZC$@ Z	t`1C$@ `~#t
zC$@ zt
   6C$@ =   ~&t   C$@ =   t
   6C$@ =   ~&t   [C$@ =   Et
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.t-C$@8-t
_sC$@8_`I   L  S|t@/C$@ @~!tZC$@ Zt`2C$@ `~$tzv C$@ zt
   6C$@ =   ~&t   C$@ =   yt
   6C$@ =   ~&t   KC$@ =   5t
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.t-C$@8-pt
_cC$@8_P9   <VW#[^_]ÉUVS]u    SsC|t:t   C$@8:   {| tC|       S$B8 u"h   R
SJS$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2SЍe[^]ÐUVSMu    ;xu%{mu{lu{:uS.  t& B<v'B<v B@<vB(<vw
_t1   YCB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀt)PQ>;:   CB<vB<vB@<vB(<v
w_uVٍYCB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀt)SQȍe[^]ÉUS]1ɋC|txt;  &    C$@8x%  S$Bxm  xl  xn  xs      BC|t:t   &    C$@8:   {| tC|       S$B8 u$h   RS>Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
C$@8&uSrS]ȉ]Ív UWVS}E    Ed   jd{Eujdh  v W|t
"t  G$@8"  | tG|       W$B8 u#h   RW
Kv W$B8
uBG$@   	    BG$@W$   B8 uh   RPG$@8%uWG$@8&uWBW|    &    uF;u|#EEPURvEt  EUu| tG|           W$B8 u%h   RWMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R@G$@8%uWG$@8&uW2W|t_|G$@w	t

t
u	""    W$B8 u h   RWBW$B8
uBG$@   BG$@W$   B8 uh   R`G$@8%uWG$@8&U  WNG  t't8  G$@8''  | tG|       W$B8 u$h   RW>Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uW
G$@8&uWrW|    &    uF;u|#U҉UREP~E  UEu| tG|           W$B8 u%h   RW/Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   RpG$@8%uWG$@8&uWbW|t_|G$@w	t

t
u	't'u
=G$@8't2GT"   tPXtEPh-GPG       tG|       W$B8 u#h   RW{v W$B8
uEBG$@   9    UR&    EPhPr1^t& BG$@W$   B8 uh   RG$@8%uWG$@8&u	WEe[^_]ÐUWVS]11   &    C$@8
?  {| tC|       S$B8 u$h   R~SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSHS|t &C$@8 t	C$@8	t
C$@8
C|t
  C$@8
  &    C$@ =    t
 ~  C$@ = k  t
>u]  C$@8>N  t
nt  C$@8n  K$Axs     A   C$@8
<  {| tC|       S$B8 u!h   RS+IS$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t 9t& C$@8 #t
	C$@8	t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R躿S   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R^SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SF   C$@8
>  {| tC|       S$B8 u#h   R=SKv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S蝿{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
t  C$@8
`  &    tht  C$@8h  K$Axr  xe  xf     A   C$@8
<  {| tC|       S$B8 u!h   R˺S+IS$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t 9t& C$@8 #t
	C$@8	t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R躸S   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R^S辻Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S轺{| uC$@8 u{(݋C$@8%uSC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SF   C$@8
>  {| tC|       S$B8 u#h   R=S蝹Kv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S蝸{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
t  C$@8
`  &    tpt  C$@8p  K$Axr  xe  xf  xi  xx     A   C$@8
8  {| tC|       S$B8 u h   R跳SES$B8
uBC$@   v BC$@S$   B8 uh   R`C$@8%uSC$@8&uSRS|t =t& C$@8 't
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R誱S
   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   RNS讴Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S譳{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
S6   C$@8
>  {| tC|       S$B8 u#h   R-S荲Kv S$B8
uBC$@   	    BC$@S$   B8 uh   RЮC$@8%uS]C$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S荱{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
d  C$@8
P  &    tAt  C$@8A  K$AxS     A   C$@8
?  {| tC|       S$B8 u$h   RάS.Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t 6t& C$@8  t
	C$@8	 t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uS蘽S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=  C$@8=  {| uPS$B8 u#h   R躪S   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R^S辭Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S转{| uC$@8 u{(݋C$@8%uSÿC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SF   C$@8
>  {| tC|       S$B8 u#h   R=S蝫Kv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSҹS|t 7t& C$@8 !t
	C$@8	t
C$@8

S蝪{| uC$@8 u{(݋C$@8%uS製C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
t  C$@8
`  &    t?tet& C$@8?uUS$Bx>uI{| u{8 u#h   RSx   S$B8
      &    1utPXth`CP҃CT#   C    {| tC|       S$B8 u!h   R若SIS$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uS轻C$@8&uS"S|t4C$@ ~&t  tC$@ =  ^t	Q    C$@8	:t
-C$@8
t


C$@8
t
  9v C$@ =  ~&t  C$@ =  r  zt& @BS$B <w<	t<
t<
uB8>u܃{| tC|       S$B8 u h   R詣S	GS$B8
uBC$@   t& BC$@S$   B8 uh   RPC$@8%uSݹC$@8&uSBtV^t	W~^e[^_]U  WVS]h   C$PآS$B18 u!h   R躢SS|t@~5C$@ @~$tZL  t& C$@ Z6  t
`~7v C$@ `~$tz  t& C$@ z   t
   ~7C$@ =   ~%t
      C$@ =      t
   ~3C$@ =   ~!t
      C$@ =   ~tt
   ~0C$@ =   ~t
   HC$@ =   ~8t_u-t& C$@8_tt:u
C$@8:t1  }   C$@>F  ~hhPyNC$HFB<vB<vB@<vB(<vwۍB<	vԀ.tπ-tʀ_tŀ:ttyv C$@B<oB<dB@<YB(<NEB<	:.1-(_:
VW0[^_]Ív U  WVSuh   F$PV$B18 u!h   RڟV:~| t	^|t& F$@Sv0C<v)C@<v"C(<vw_t:t1  t& ?  G~| tF|       v V$B8 u%h   R/V菢Mt& V$B8
uBF$@   	    BF$@V$   B8 uh   RОF$@8%uV]F$@8&uV°~| t^|F$@S  U  hPK   ~| tF|       V$B8 u h   R7V藡EV$B8
uBF$@   v BF$@V$   B8 uh   RF$@8%uVmF$@8&uVү~| t^|F$@C</C<$C@<C(<C<	.-_:pt& C<C@<C(<C<	.z-q_h:_VWP[^_]UVSut7t1ÉيB<v+B<v$B@<vB(<vw_t:t1RAB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀ:tt)QSe[^]Ív U  WVS]h   C$P؛S$B18 u!h   R躛S  t& C$@8  F{| tC|v C$@ :{| tC|       v S$B8 u%h   R?S蟞Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSҬ    h PH   v C$@8  {| tC|       S$B8 u$h   RNS讝Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t@/C$@ @~!tZC$@ Z	t`1C$@ `~#t
zC$@ zt
   6C$@ =   ~&t   C$@ =   t
   6C$@ =   ~&t   [C$@ =   Et
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.t-C$@8-t
_sC$@8_`t
:SC$@8:@)   ,  S|t@/C$@ @~!tZC$@ Zt`2C$@ `~$tzv C$@ zt
   6C$@ =   ~&t   oC$@ =   Yt
   6C$@ =   ~&t   +C$@ =   t
   <C$@ =   ~,t       C$@ =   t/3C$@ /~$t9v C$@ 9t.C$@8.ot-bC$@8-Pt
_CC$@8_0t
:#C$@8:   VW胹[^_]ÉU,WVS}E    Ed   E    G|t"tt& G$@8"uE"PG|t'tG$@8'uE'0GT$   tPXthPGPG    1  jdEEujdh  G$Gx   Eh   P虔W$B8 u!h   R}Wݗ| tG|       W$B8 u%h   R?W蟗Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWmG$@8&uWҥ| k  k  E@;u|#U҉UREPKE  UEu| tG|       W$B8 u!h   R;W蛖IW$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWmG$@8&uWҤ	W| t_|G$@ u(ֈÄuSh   G$PoW$B8 u!h   RSW賕| t_|G$@w	t

t
u:]pU9W$dEU :]t.GT%   tPXthnGPG      | tG|       W$B8 u"h   R蜑
WJW$B8
uBG$@   	    BG$@W$   B8 uh   R@G$@8%uWͧG$@8&uW2j j j jEPW辮E } t&EU(URhPI>1EP8LEe[^_]Ív UWVSUB$P,MQ$B8 u$h   Ru]SғEP|t
"t   v MA$@8"   ]Cx   E"{| tC|      EP$B8 u#h   RURWHMQ$B8
uBA$@   B]C$@S$   B8 uh   R蝏UB$@8%uR'MA$@8&6  Q   t
't   ]C$@8'   EE'@x   x| t@|       MQ$B8 u#h   R	]SfKEP$B8
uBUB$@   BMA$@Q$   B8 uh   R詎]C$@8%uS3UB$@8&uFR蕠8MAT'   tPXthAPҋ]C    1V  Ed   jd?Eu
h  E}x| t@|s  t& UB$_  t& <&  MA$@x#uQG  ]S  Ã  Ex tVs>   EFG+]9~'U҉URMQDE  ߀> u  t& CP[Ɖ]&EG+])9~6EEPURDE  
MNAMG;G7  < t<
t<
t<	u% EG+]9~KEEPUR"EG+]9~'MɉMQEPDE  ߋUz| tB|       MQ$B8 u#h   R9]S薏KEP$B8
uBUB$@   BMA$@Q$   B8 uh   Rً]C$@8%uScUB$@8&uRŝMy| tA|]C$@ :Et<<t UB|t<tBMA$@8<u4]tPXthCPҋE@T&   @    ;  ]MS|t9uM    ]C$@ 9t7UtPXthMAPҋ]CT(   C       tE@|           MQ$B8 u#h   R茊]S\EP$B8
u#BUB$@   h71bBMA$@Q$   B8 uh   R]C$@8%uS襠UB$@8&u	REe[^_]ÉUWVS}E    Ed   G$PJW$B8 u!h   R薉WW|t
"t   G$@8"   tG|       W$B8 u h   R:W蚌HW$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWmG$@8&uWҚE"  t
't   G$@8'   t
G|       W$B8 u%h   R_W迋Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R G$@8%uW荞G$@8&uWE'1tPXth@GPGT+   G    1  jdj8Eujdh  |     uF;u|#EEPUR>EB  EUu| tG|       t& W$B8 u%h   RW_Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R蠆G$@8%uW-G$@8&uW蒘| t_|G$@   h   G$PCW$B8 u!h   R'W臉G$P蠆W$B8 u!h   RWL| t_|    G$@w	t

t
u	:]=EU w=	t8
t3
t.tPXth_GPGT,   G       | tG|       W$B8 u"h   R,
W茈jW$B8
u5BG$@   )    EPhP]21^t& BG$@W$   B8 uh   R谄G$@8%uW=G$@8&u	W袖Ee[^_]ÐUWVS}E    Ed   G$PW$B8 u!h   R2W蒇W|t"t       G$@8"   t
G|       W$B8 u%h   RσW/Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   RpG$@8%uWG$@8&uWbE"  t
't   G$@8'   t
G|       W$B8 u%h   RWOMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R萂G$@8%uWG$@8&uW肔E'1tPXth@GPGT+   G    1  jd2EujdhI  |     :]  E@;u|#EEPURY9E  EUu| tG|       W$B8 u h   R舁WFW$B8
uBG$@   t& BG$@W$   B8 uh   R0G$@8%uW轗G$@8&uW"| t_|G$@   h   G$PӀW$B8 u!h   R跀WG$P0W$B8 u!h   R|W܃| t_|    G$@ Q
H
?C<4C<)C<	-'()+,./:=?;!*#@$_|%sEU :]t2tPXthyGPGT,   G       t& | tG|       W$B8 u#h   R~W]kv W$B8
u5BG$@   )    EPhP-,1^t& BG$@W$   B8 uh   R~G$@8%uW
G$@8&u	WrEe[^_]ÐU  WVS]C$P~S$B18 u!h   R~SkS|    <]uCC$@x]u7x>u1}   tzX thCPBTЃCT>   Gփ{| tC|v C$@   uH; tAWVSQtzH t'WVCPBHzD tWVCPBDЃ1{| tC|       v S$B8 u%h   R|S_Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R|C$@8%uS-C$@8&uS蒎S|tC|C$@ <<u<u)<&u&u <Y<	Q<
I<
AtK; tFWVStzH t&WVCPBHzD tWVCPBDЍ[^_]ÐUVS]C$PM|S$B18 u!h   R{S~S|t
StB  C$@8S3  K$AxY#  xS  xT  xE  xM     AC|t
 ua  C$@8 R  S|t
	uA  C$@8	2  t

u$  C$@8
  C|t

u  C$@8
   tPXthCP҃CTA   C       C$@8
:  {| tC|       S$B8 u h   R9zS}GS$B8
uBC$@   t& BC$@S$   B8 uh   RyC$@8%uSmC$@8&uSҋS|t ;t& C$@8 %t
	C$@8	t
C$@8

S|{| uC$@8 u{(݋C$@8%uS裏C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
Sƃ    PX  h   t
Pt  C$@8P  S$BxU  xB  xL  xI  xC~     BC|t
 ua  C$@8 R  S|t
	uA  C$@8	2  t

u$  C$@8
  C|t

u  C$@8
   tPXth@CP҃CTA   C       C$@8
:  {| tC|       S$B8 u h   RvSIzGS$B8
uBC$@   t& BC$@S$   B8 uh   RvC$@8%uSC$@8&uS肈S|t ;t& C$@8 %t
	C$@8	t
C$@8

SMy{| uC$@8 u{(݋C$@8%uSSC$@8&uS踇S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SEu,tPXth`CP҃CTG   C    }    S|t
 u  v C$@8   t
	u  v C$@8	  t
u  v C$@8
  C|t

uy  C$@8
j  tPXthCP҃CTA   C    9  h   C$PtS$B8 uh   Rs	SKwC$P< t<	t<
t<
uB< t<	t<
t<
t1K  C$@8
>  {| tC|       S$B8 u#h   RmsSvKv S$B8
uBC$@   	    BC$@S$   B8 uh   RsC$@8%uS蝉C$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

Su{| uC$@8 u{(݋C$@8%uSӈC$@8&uS8S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
Sƃu)tPXthCPCTF   C    e[^]Ív UWVSuE    Ed   F|t<  F$F$P:<  Pz!  z-  z-  VxUFx   PsqV$B8 u!h   RpVtF$   @jdp!EujdhP  ~| tF|F$@ E~| tF|       V$B8 u%h   R/pVsMt& V$B8
uBF$@   	    BF$@V$   B8 uh   RoF$@8%uV]F$@8&uV~| tV|UF$@ E~| tF|       V$B8 u!h   R[oVrIV$B8
uBF$@   	    BF$@V$   B8 uh   R oF$@8%uV荅F$@8&uV~|     }-u2}-u,tPXth FP҃FTP   F    E@;}|#MɉMQEP%ER  MEU}UU]~| tF|       V$B8 u h   RnVwqEV$B8
uBF$@   v BF$@V$   B8 uh   RmF$@8%uVMF$@8&uV~| t^|F$@   F$P nV$B8 u!h   RLmVph   F$P(mV$B8 u!h   RmVlp~| t^|    F$@w	t

t
u>}-1}-ME w>	t9
t4
t/tPXtQh`FPFT-   F       ~| tF|       V$B8 u h   R7lVoVV$B8
u#BF$@   v URhwBF$@V$   B8 uh   RkF$@8%uV\F$@8&uV}tPPtEPFP҃UR&MNxe[^_]ÐUWVS}W7ƃtk<xt<XuaF<mt<MuVF<lt<LuK=I t IPVPt*; utPTthGPGT@   e[^_]Ív UWVSuE    Ed   F|t
<t  F$@8<  V$Bx?  FxEFx      BF$PjV$B8 u!h   RBjVmVEP  jdEujdhPkK  ~| t
^|
t& F$@   	  
  
   tPXtEPhFP҃FTA   F       F$@8
>  ~| tF|       V$B8 u#h   R=iVlKv V$B8
uBF$@   	    BF$@V$   B8 uh   RhF$@8%uVmF$@8&uVzV|t 7t& F$@8 !t
	F$@8	t
F$@8

Vk~| uF$@8 u~(݋F$@8%uV~F$@8&uVzV|t &F$@8 t	F$@8	t
F$@8
t
F$@8
    t& E@;}|#U҉UREPEB  UE}~| tF|       t& V$B8 u%h   RfVOjMt& V$B8
uBF$@   	    BF$@V$   B8 uh   RfF$@8%uV}F$@8&uVx~| t^|F$@   F$PfV$B8 u!h   RfV|ih   F$PeV$B8 u!h   ReV<i~| t^|    F$@w	t

t
u?;F$@x>+UE wA	t<
t7
t2tPXtEPh FP҃FT/   F    /F$   @tPLtEPEPFP҃URt EPh KURhPMEFx0tPXthAFPFT.   F    UVxe[^_]Ív UWVS]C|t<t	  &    C$@8<	  S$Bx!	  xN	  xO	  xT	  xAx	  xTn	  xId	  xOZ	  x	NP	  RdS$B8 u!h   RcS4gC$   
@
C|t
 uS  C$@8 D  S|t
	u3  C$@8	$  t

u  C$@8
  t

u   C$@8
     PX  h`  C$@8
>  {| tC|       S$B8 u#h   RbS=fKv S$B8
uBC$@   	    BC$@S$   B8 uh   RbC$@8%uS
yC$@8&uSrtS|t 7t& C$@8 !t
	C$@8	t
C$@8

S=e{| uC$@8 u{(݋C$@8%uSCxC$@8&uSsS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
Sǃu/tPXthCPCT0   C       S|t
 u   C$@8 ttt	u
iC$@8	t^t

uSv C$@8
tEt
u
:C$@8
t/tPXthCPCTA   C      u   C$@8
G  {| tC|       &    S$B8 u%h   R_SOcMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R_C$@8%uSvC$@8&uSqS|t .t& C$@8 t
	C$@8	t
C$@8

SMb{| uC$@8 u{(݋C$@8%uSSuC$@8&uSpS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
jVS?   C$@8
;  {| tC|       S$B8 u h   R]S*aHS$B8
uBC$@   	    BC$@S$   B8 uh   Rp]C$@8%uSsC$@8&uSboS|t :t& C$@8 $t
	C$@8	t
C$@8

S-`{| uC$@8 u{(݋C$@8%uS3sC$@8&uSnS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
>t   v C$@8>   t
C|       S$B8 u%h   R[S_Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RP[C$@8%uSqC$@8&uSBmtDPt=VEPWCP҃,tPXth CP҃CT1   C    WHtV8Et	P%e[^_]Ív UWVS]E    1}}}}h   C$PjZS$B8 u!h   RNZS]C|t<t  C$@8<z  S$Bx!j  xE`  xNV  xTL  xIB  xT8  xY.  Cx
   RUZS$B8 u!h   RYS]C$   @C|t up  &    C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXth@CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RXS[Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0XC$@8%uSnC$@8&uS"jS|t 6t& C$@8  t
	C$@8	 t
C$@8

SZ{| uC$@8 u{(݋C$@8%uSmC$@8&uSXiS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
%t  v C$@8%  {| tC|       S$B8 u$h   RnVSYLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RVC$@8%uSlC$@8&uShS|t uo      C$@8 Z  t
	uL  v C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthaCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RTSNXLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RTC$@8%uSkC$@8&uSfS|t 6t& C$@8  t
	C$@8	 t
C$@8

SMW{| uC$@8 u{(݋C$@8%uSSjC$@8&uSeS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
E   Sƃu.tPXth{CPCTD   C    3  S|t
 ub  C$@8 S  t
	uE  C$@8	6  t

u(  C$@8
  C|t

u  C$@8
   tPXthCP҃CTA   C       C$@8
>  {| tC|       S$B8 u#h   RQSMUKv S$B8
uBC$@   	    BC$@S$   B8 uh   RQC$@8%uShC$@8&uScS|t 7t& C$@8 !t
	C$@8	t
C$@8

SMT{| uC$@8 u{(݋C$@8%uSSgC$@8&uSbS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
}    t"t)C$@8"tC|t
't!v C$@8'uEPSdE} t,  P  EPj j j)  t& jEPSǃ    P  j WEPj  t
"t0v C$@8"t C|t'tL&    C$@8'u:EPS褹Ea  PV  EPj j jo  jEPSǋC|t>u      C$@8>z  S|t
 ui  C$@8 Z  t
	uL  v C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RMSQLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`MC$@8%uScC$@8&uSR_S|t 6t& C$@8  t
	C$@8	 t
C$@8

SP{| uC$@8 u{(݋C$@8%uS#cC$@8&uS^S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
C|t
NtC  C$@8N4  S$BxD$  xA  xT  xA     BC|t up  &    C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RJSMLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@JC$@8%uS`C$@8&uS2\S|t 6t& C$@8  t
	C$@8	 t
C$@8

SL{| uC$@8 u{(݋C$@8%uS`C$@8&uSh[S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
S覨E  P(  EPWEP!   P   j WEPjVCP҃    C$@8
<  {| tC|       S$B8 u!h   R+HSKIS$B8
uBC$@   	    BC$@S$   B8 uh   RGC$@8%uS]^C$@8&uSYS|t 9t& C$@8 #t
	C$@8	t
C$@8

SJ{| uC$@8 u{(݋C$@8%uS]C$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
>uF    C$@8>t5tPXtVh CP҃CT%   C       v tC|       S$B8 u%h   RES?IMt& S$B8
uBC$@   	    BC$@S$   B8 uh   REC$@8%uS
\C$@8&uSrW} tP1Ƀ} tt!P`	tPtVCP҉ty uEAEPx tVh } tEPS tWC EtP0 } tEP e[^_]ÐUWVS]}    C|t#t
YC$@8#uNS$BxRuBxEu<xQu6xUu0xIu*xRu$xEuxDu   	B	     v S|t	#tRC$@8#uEK$AxIu9xMu3xPu-xLu'xIu!xEuxDu   A   t     t
#t  C$@8#
  S$BxF  xI  xX  xE  xD     BC|   t un  t& C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXth`CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   R^BSELt& S$B8
uBC$@   	    BC$@S$   B8 uh   R BC$@8%uSXC$@8&uSSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SD{| uC$@8 u{(݋C$@8%uSWC$@8&uS(SS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SԯCx   u*tPXthCPC        e[^_]ÉUWVS}E    E    G|t(uG$Et& G$P:(t5tPXthGPGT0   G    1N  t& PW@W$B8 u!h   R?WC| uWW$B8 u'h   Rq?WB   t& W$B8
t`sv G$@8
?  | tG|       W$B8 u$h   R?WnBLt& W$B8
uBG$@   	    BG$@W$   B8 uh   R>G$@8%uW=UG$@8&uWPW|t 6t& G$@8  t
	G$@8	 t
G$@8

WmA| uG$@8 u(݋G$@8%uWsTG$@8&uWOW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
Wƃu/tPXth GPGTD   G    w  V ÃV` W  } u]]   E]   v G$@8
?  | tG|       W$B8 u$h   R~<W?Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   R <G$@8%uWRG$@8&uWNW|t 6t& G$@8  t
	G$@8	 t
G$@8

W>| uG$@8 u(݋G$@8%uWQG$@8&uWHMW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
t
|G$@8|t
)uF    G$@8)t5tPXth@GPGT1   G       &    tG|       W$B8 u%h   R:Wo=Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R9G$@8%uW=PG$@8&u	WKEe[^_]ÐUWVS}E    E    G|t(uG$AG$P:(t5tPXthGPGT2   G    1N  t& P9W$B8 u!h   R8WC<| uWW$B8 u'h   R8W<   t& W$B8
t`sv G$@8
?  | tG|       W$B8 u$h   RN8W;Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   R7G$@8%uW}NG$@8&uWIW|t 6t& G$@8  t
	G$@8	 t
G$@8

W:| uG$@8 u(݋G$@8%uWMG$@8&uWIW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
Wxƃu/tPXthGPGTC   G    w  V7 ÃV W  } u]]   E]   v G$@8
?  | tG|       W$B8 u$h   R5W9Lt& W$B8
uBG$@   	    BG$@W$   B8 uh   R`5G$@8%uWKG$@8&uWRGW|t 6t& G$@8  t
	G$@8	 t
G$@8

W8| uG$@8 u(݋G$@8%uW#KG$@8&uWFW|t &G$@8 t	G$@8	t
G$@8
t
G$@8
t
|G$@8|t
)uF    G$@8)t5tPXth GPGT3   G       &    tG|       W$B8 u%h   RO3W6Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R2G$@8%uW}IG$@8&u	WDEe[^_]ÐUVS]uC|t
NtB  C$@8N3  S$BxO#  xT  xA  xT  xI  xO  xN     BC|t uo      C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  t

u  v C$@8
   tPXth@CPCTA   C    C  v C$@8
?  {| tC|       S$B8 u$h   R>1S4Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSmGC$@8&uSBS|t 6t& C$@8  t
	C$@8	 t
C$@8

S3{| uC$@8 u{(݋C$@8%uSFC$@8&uSBS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
S(t"
   St	   t& 1e[^]ÐUS]C$P/S$B8 u!h   R.SZ2K|tCtAC$@8Cu5S$BxDu)xAu#xTuxAu   B   V  tItIt& C$@8Iu9S$BxDu-xRu'xEu!xFuxSu   B      tItAC$@8Iu5S$BxDu)xRu#xEuxFu   B     tIt5t& C$@8Iu%S$BxDu   B   x  t& tEtIt& C$@8Eu9S$BxNu-xTu'xIu!xTuxYu   B      tEtQC$@8EuES$BxNu9xTu3xIu-xTu'xIu!xEuxSu   B      tNtUt& C$@8NuES$BxMu9xTu3xOu-xKu'xEu!xNuxSu   B   gv tNtLt& C$@8Nu<S$BxMu0xTu*xOu$xKuxEuxNu   B   
EPS]]ÐUWVS]C|t<t  &    C$@8<  S$Bx!  xA  xT  xT  xL  xI  xS  xT     	B	C|t
 uh  C$@8 Y  K|t
	uH  C$@8	9  t
u+  C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   R*S.Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`*C$@8%uS@C$@8&uSR<K|t 6t& C$@8  t
	C$@8	 t
C$@8

S-{| uC$@8 u{(݋C$@8%uS#@C$@8&uS;K|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SȈE   tPXthCPCTD   C    q
  C$@8
;  {| tC|       S$B8 u h   Rj(S+HS$B8
uBC$@   	    BC$@S$   B8 uh   R(C$@8%uS>C$@8&uS:K|t :t& C$@8 $t
	C$@8	t
C$@8

S*{| uC$@8 u{(݋C$@8%uS=C$@8&uS89K|t &C$@8 t	C$@8	t
C$@8
C|t
o
  C$@8
[
  &    C$@EE    E    SPǃu7tPXthCP҃CTD   C    
      h   C$P&S$B8 u!h   R%S[)K|t
 u   C$@8 ttt	u
iC$@8	t^t

uSv C$@8
tEC|t
u7&    C$@8
t%X  PXM  h7  v u   C$@8
G  {| tC|       &    S$B8 u%h   R%So(Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R$C$@8%uS=;C$@8&uS6K|t .t& C$@8 t
	C$@8	t
C$@8

Sm'{| uC$@8 u{(݋C$@8%uSs:C$@8&uS5K|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
VSE  h   C$P#S$B8 u!h   R"SR&K|t u
yC$@8 tnt
	ucv C$@8	tUt
u
JC$@8
t?C|t
u1C$@8
t%X  PXM  h 7  v u   C$@8
G  {| tC|       &    S$B8 u%h   R"So%Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R!C$@8%uS=8C$@8&uS3K|t .t& C$@8 t
	C$@8	t
C$@8

Sm${| uC$@8 u{(݋C$@8%uSs7C$@8&uS2K|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
VSƃ
  h   C$P C$P: u!h   PSS#K|t>uC$  t& C$P:>  t
 ul  v C$@8 Z  t
	uL  v C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXth`CP҃CTA   C      C$@8
?  {| tC|       S$B8 u$h   RS."Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uS4C$@8&uSb0K|t 6t& C$@8  t
	C$@8	 t
C$@8

S-!{| uC$@8 u{(݋C$@8%uS34C$@8&uS/K|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
U;Pu*tPXthCP҃CT      t%P tEPEPVEPWEPCP҃ tWEtPh   C$PcS$B8 u!h   RGSC|t>C$@8>K|t
>t   C$@8>   tC|       S$B8 u h   RS*HS$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uS1C$@8&uSb-URe[^_]ÐUWVSuE    E    h   F$PV$B18 u!h   RV?F|t
#t  v F$@8#  V$BxP  xCw  xDm  xAc  xTY  xAO     B   F$@8
>  ~| tF|       V$B8 u#h   RV}Kv V$B8
uBF$@   	    BF$@V$   B8 uh   RF$@8%uVM0F$@8&uV+V|t 7t& F$@8 !t
	F$@8	t
F$@8

V}~| uF$@8 u~(݋F$@8%uV/F$@8&uV*V|t &F$@8 t	F$@8	t
F$@8
F|t
F$F$P:
PV$B8 u!h   RVV|t
)t  v F$@8)  t
F|       V$B8 u%h   RVMt& V$B8
uBF$@   	    BF$@V$   B8 uh   R`F$@8%uV-F$@8&uVR)jj g EF|t*t  t& F$@8*
  E@   ~| tF|      t& V$B8 u%h   RVMt& V$B8
uBF$@   	    BF$@V$   B8 uh   R`F$@8%uV,F$@8&H  VN(:  t(t6t& F$@8(t$t|t  &    F$@8|  jj Uf EE  1  tF|       V$B8 u"h   R
VJV$B8
uBF$@   	    BF$@V$   B8 uh   R@F$@8%uV+F$@8&uV2'u+jj we E%UPEE  jj Le ÃjW4e CUZ]W#    &    F$@8
?  ~| tF|       V$B8 u$h   R^VLt& V$B8
uBF$@   	    BF$@V$   B8 uh   R F$@8%uV*F$@8&uV%V|t 6t& F$@8  t
	F$@8	 t
F$@8

V~| uF$@8 u~(݋F$@8%uV)F$@8&uV(%V|t &F$@8 t	F$@8	t
F$@8
t
F$@8
Vhrǃ  tPXthFP҃FTD   F    EP  v F$@8
?  ~| tF|       V$B8 u$h   RV^Lt& V$B8
uBF$@   	    BF$@V$   B8 uh   RF$@8%uV-(F$@8&uV#V|t 6t& F$@8  t
	F$@8	 t
F$@8

V]~| uF$@8 u~(݋F$@8%uVc'F$@8&uV"V|t &F$@8 t	F$@8	t
F$@8
F|t
F$F$P:
h   PV$B8 u!h   RVZV|t|F$@8|t
)tSv F$@8)uEF$@x*u9tjW
` UBWE@   F$   @ztWtPXth FP҃FT4   F    UR` Ov tPXth`FPFTE   F    Ee[^_]ÉUWVS]E    E    C$@8
;  {| tC|       S$B8 u h   RSHS$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uS$C$@8&uS" S|t :t& C$@8 $t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 u!h   RSC|t
(t  C$@8(  {| uPS$B8 u#h   R8S   S$B8
t[nC$@8
=  {| tC|       S$B8 u"h   R
S<JS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
"C$@8&uSrS|t 8t& C$@8 "t
	C$@8	t
C$@8

S={| uC$@8 u{(݋C$@8%uSC!C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
Sǉ}   C$@8
;  {| tC|       S$B8 u h   R	S
HS$B8
uBC$@   	    BC$@S$   B8 uh   R`	C$@8%uSC$@8&uSRS|t :t& C$@8 $t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 e  h   RL  S;  t& Swgƃ  jVW ǉ}h   C$PaS$B 8 u!h   RES
S|t?t
`C$@8?uUG   {|    S$B8 u%h   RSO
  S$B8
      t*tGC$@8*u;G   {| u[S$B8 uh   RS	   C|t
+t   C$@8+   G   {| t
C|       S$B8 u%h   RS	Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uSt& G   Vh   C$PgS$B 8    h   RG   S       C$@8
?  {| tC|       S$B8 u$h   RSNLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SM{| uC$@8 u{(݋C$@8%uSSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
P
  t
,t`  C$@8,Q  } utC|E_C$@ ERMt9uBC$@ 9t3tPXtQhCP҃CTB   C    Q  tC|       S$B8 u%h   ROSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSjj +R   } <  A  t|tC  C$@8|2  } utC|E2C$@ E%Mt
9C$@ 9tC|       S$B8 u"h   R
SlJS$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uS=C$@8&uSjj P @  } u
xǉ}BUBUPE1tPXth CP҃C    CT7   
  h   C$P S$B8    h   R   SA   t& C$@8
?  {| tC|       S$B8 u$h   RSLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSC$@8&uS"S|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 u!h   RS C|t
(t  C$@8(  {| uPS$B8 u#h   R8S    S$B8
t[nC$@8
=  {| tC|       S$B8 u"h   R
S< JS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
C$@8&uSrS|t 8t& C$@8 "t
	C$@8	t
C$@8

S={| uC$@8 u{(݋C$@8%uSCC$@8&uS
S|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SE   C$@8
=  {| tC|       S$B8 u"h   R
SJS$B8
uBC$@   	    BC$@S$   B8 uh   R`C$@8%uSC$@8&uSRS|t 8t& C$@8 "t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
  C$@8
p  &    SXƃu0tPXthCPCT6   C    1  jVI EVC| t
?tj    C$@8?uYE@   {| &  S$B8 u&h   R0S{  v S$B8
,  <  C|t*t
NC$@8*uCUB   {|    S$B8 uh   RS	  C|t	+tSC$@8+uFE@   {| uZS$B8 Vh   R`=S   UB      C$@8
?  {| tC|       S$B8 u$h   RS^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS-
C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S]{| uC$@8 u{(݋C$@8%uScC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$C$P:
h   PS$B8 u!h   RSZS|t)C$@8)} t} t	UEP{| tC|       &    S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uS
C$@8&uSS|t?t
ZC$@8?uOG   {| I  S$B8 u#h   RS   S$B8
to   t*t   C$@8*   G   {|    S$B8 u%h   R?SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSm	C$@8&   S   t+t   C$@8+   G   {| tC|       S$B8 u h   RWSUS$B8
u"BC$@   v WC 1[v BC$@S$   B8 uh   RC$@8%uS}C$@8&u	Se[^_]ÉUWVS]E     C|t(u
>C$@8(t3tPXth`CPCT6   C      {| tC|       S$B8 u h   R(SFS$B8
uBC$@   t& BC$@S$   B8 uh   RC$@8%uS]C$@8&uSh   C$PS$B8    h   Rn   S   C$@8
<  {| tC|       S$B8 u!h   RS{IS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uSS|t 9t& C$@8 #t
	C$@8	t
C$@8

S}{| uC$@8 u{(݋C$@8%uSC$@8&uS S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
C|t
#tSv C$@8#uEC$@xPu9xCu3xDu-xAu'xTu!xAuSƿ          Sƿ      C$@8
:  {| tC|       S$B8 u h   RSGS$B8
uBC$@   t& BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2S|t ;t& C$@8 %t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uShS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
E0e[^_]UWVS]E    h   C$PS$B8 u!h   RsSC|t<t<
  &    C$@8<&
  S$Bx!
  xE
  xL
  xE  xM  xE  xN  xT     	B	C|t
 uh  C$@8 Y  S|t
	uH  C$@8	9  t
u+  C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RSNLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SM{| uC$@8 u{(݋C$@8%uSSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SGƃu3tPXthCPCTD   C    	  S|t
 ud  C$@8 U  t
	uG  C$@8	8  t
u*  C$@8
  C|t

u	  C$@8
   tPXth CP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RSNLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSC$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

SM{| uC$@8 u{(݋C$@8%uSSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
EtF    C$@8Eu5K$AxMu)xPu#xTuxYu   A     tAt7t& C$@8Au'K$AxNuxYu   A     t
(t#v C$@8(uEPVSV  t%tEt& C$@8%u5{` u/{(u)tPXth@CP҃CT   'tPXthCP҃CT6   C    VGC$@8
=  {| tC|       S$B8 u"h   R
SJS$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSC$@8&uS"S|t 8t& C$@8 "t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
{|   C$@8    {(   S{|    C$@8    {(   C$@8
;  {| tC|       S$B8 u h   R*SHS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS]C$@8&uSS|t :t& C$@8 $t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
>uF    C$@8>t5tPXthCP҃CTI   C       t& tC|       S$B8 u%h   RS?Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS
C$@8&uSrtP$tEPWVCP҃EtP/ t	V菙e[^_]Ív US]h   C$PS$B8 u!h   RS-SSl S Sy SrS.l {` u{(u	S&  Cx   ]]UVS]C$   @C|t uo      C$@8 Z  S|t
	uI  C$@8	:  t
u,  v C$@8
  C|t

u	  C$@8
   tPXthCP҃CTA   C       C$@8
?  {| tC|       S$B8 u$h   RNSLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SRL  ƃuh
lƃVCV躕C| t u   C$@8 t|S|t	un&    C$@8	t\t
u
QC$@8
tFC|t
u8C$@8
t,tPXthCP҃CTA   C    SW     C$@8
8  {| tC|       S$B8 u h   RWSES$B8
uBC$@   v BC$@S$   B8 uh   R C$@8%uSC$@8&uSS|t =t& C$@8 't
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
?t-    C$@8?uK$Ax>u   A  t
>t   C$@8>   tPXth@CP҃CT9   C    {|    S$B8 u h   RSECS$B8
uBC$@   BC$@S$   B8 uh   RC$@8%uSC$@8&  S~  tPXthCP҃CT9   C    @BS$B <w<	t<
t<
uB8>u܃{| tC|       S$B8 u h   RS9GS$B8
uBC$@   t& BC$@S$   B8 uh   RC$@8%uS
C$@8&u	Sre[^]Ív US]h  PT]  hCPG  ]uK$:]uAx]u
x>D  {| tC|           S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`C$@8%uSC$@8&uSR	S{| u*C$@ uJ{(܄u@h   C$PS$B8 u!h   RS;C|C$P: {| uA8 u8Q-S$B8 u!h   RyS{| u8C$@8 u-tPXth CPCT;   C    C$   @]]Ív UWVS]h   C$PS$B8 u!h   RS7C|t<t
EC$@8<u:C$@x?u.xxu(xmu"xluS,tP{ uh
J  CtSz  uEPEPj R蛨  Cx   C`     C$@8
  C$px t<t(><u#Ax!ux[uSO      t tS
t& A8 tDt	t;A8	t1t
t(A8
tt
t   t& A8
   {| tC|       S$B8 u%h   ROSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&u?S1C|t%t
C$@8%uS^
  
t& SK$SK${| uA8 u{(9qu7;y u2tPXth@CP҃C    CT<      S|t	<tC$@8<uC$@x?t<t
C$@8<uC$@x!t C$@8 t
	C$@8	t
vC$@8
cL
R{| uC$@8 t)tPXthCPCT<   C    e[^_]UWVS}G|t&*  G$@8&  (~JfE  E&tPDtjEPGP҃|&u
G|       G$   @   G$@x#u7WEffE   PD   jEP3W   tvHtE8t@tR@t uQGPK tPW4PW.t& Xt#7t~D tSPSGPFDЍe[^_]UWVS]h   C$PS$B18 u!h   RSS|t
&t  C$@8&  tC|       S$B8 u#h   R=SKv S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSS,ƃu5tPXthCPCTD   C      &    S|t
;tc  C$@8;T  tC|       S$B8 u%h   RSMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uSt(PtVCP҉ǃuzV2k ǃuh{t{X u1{\ u+tPXtVhƣCP҃CT   Q  tPTtVhƣCP҃CT   -  u+tPXtVhCP҃CT      {x   u,tPXtVhCP҃CT      t\hGPtDGt=j<Pft+tPXtVh CP҃CT&   \v Y|TtPXtVh`CP҃CT   %tPXthCP҃CT   C    V;e[^_]Ív UWVS]uh   C$PS$B18 u!h   RrStu
1      E8&  @EEPS,ƃu.tPXthCPCTD   C      S|t
;t_  C$@8;P  tC|       S$B8 u!h   RSIS$B8
uBC$@   	    BC$@S$   B8 uh   RPC$@8%uSC$@8&uSBt(PtVCP҉ǃuzVg ǃuh{t{X u1{\ u+tPXtVhƣCP҃CT   Q  tPTtVhƣCP҃CT   -  u+tPXtVhCP҃CT      {x   u,tPXtVhCP҃CT      t\hGPGtDGt=j<Pt+tPXtVh CP҃CT&   \v Y|TtPXtVh`CP҃CT   %tPXthCP҃CT   C    Vˁe[^_]Ív UWVS]1C|t
%t  C$@8%  {| tC|       S$B8 u h   RSGES$B8
uBC$@   v BC$@S$   B8 uh   RC$@8%uSC$@8&uSS>%ƃu5tPXth¤CPCTD   C      &    S|t
;t  C$@8;  tC|       S$B8 u%h   RS/Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbtP`tVCP҉ǃuo{t{X u;{\ u5tPXtVhCP҃CT   C    p    tPTtVhCP҃Cd    Bv!t2PTt+VhCP҃WSPSY C\   ,tPXth CP҃CT   C    V~e[^_]ÉUWVS]1} t	Uu1i  E8%S  @EEPSC&ƃu2tPXth`CPCTD   C      t& E8;   @EtP`tVCP҉ǃup{t{X u5{\ u/tPXtVhCP҃CT   C    XtPTtVhCP҃Cd    0&    vtPTtVhCP҃C\   ,tPXthCP҃CT   C    V}EUe[^_]ÐUWVS]E    C$u   	@	   C$@8
:  {| tC|       S$B8 u h   R)SGS$B8
uBC$@   t& BC$@S$   B8 uh   RC$@8%uS]C$@8&uSS|t ;t& C$@8 %t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
S6ǃ  tPXthCP҃C    CTD      C$@8
G  {| tC|       &    S$B8 u%h   RϾS/Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&uSbS|t .t& C$@8 t
	C$@8	t
C$@8

S-{| uC$@8 u{(݋C$@8%uS3C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
jVSAƃu
}    CX      t& C$@8
?  {| tC|       S$B8 u$h   R莼SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R0C$@8%uSC$@8&uS"S|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uSXS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
ttVEPWCP҃tVvEtPutWuC|t[  C$@8[  C|t	>u9C$@8>t,tPXth CP҃C    CT=   {| tC|       &    S$B8 u%h   RϹS/Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uSC$@8&u	Sbe[^_]UWVS]C|t
[tl  v C$@8[Z  Cx   {| tC|    H  S$B8 u h   R׸S7ES$B8
uBC$@   v BC$@S$   B8 uh   R耸C$@8%uS
C$@8&  Sn  C$px    C$@8
?  {| tC|       S$B8 u$h   RS^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R蠷C$@8%uS-C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S]{| uC$@8 u{(݋C$@8%uScC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SSS$ t& SoS${| uB8 u{(9ru8;z u3tPXth@CP҃C    CT   &t& C|t]RC$@8]AC|t
]t   C$@8]   {| tC|       S$B8 u"h   R<
S蜸JS$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&uSC|t>u
7C$@8>t,tPXth CP҃C    CT=   {| tC|       S$B8 u%h   R?S蟷Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSmC$@8&u	Se[^_]UWVS]}    Srƃ   tPXth~CPC    CTD   1  t& C$@8
?  {| tC|       S$B8 u$h   RSnLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R谲C$@8%uS=C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

Sm{| uC$@8 u{(݋C$@8%uSsC$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=tt  v C$@8=b  {| uPS$B8 u#h   RSZ   S$B8
t]pC$@8
?  {| tC|       S$B8 u$h   R螰SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uSC$@8&uS2S|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uSC$@8&uShS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
SCx   /tPXtVhCPCT)   C    1e[^_]ÉU,WVSuE    E    E    F|t<  F$@8<   ~| tF|       V$B8 u!h   RVkIV$B8
uBF$@   	    BF$@V$   B8 uh   R谭F$@8%uV=F$@8&uV袿V^
E	  tPXthFPFTD   F    1  Sh k  F$@8
?  ~| tF|       V$B8 u$h   RVNLt& V$B8
uBF$@   	    BF$@V$   B8 uh   R萬F$@8%uVF$@8&uV肾V|t 6t& F$@8  t
	F$@8	 t
F$@8

VM~| uF$@8 u~(݋F$@8%uVSF$@8&uV踽V|t &F$@8 t	F$@8	t
F$@8
F|t
N$,  F$P:
  F$@ =  6  t
 ~%  F$@ =   t
>u  F$@8>  t
N$/u
F$P:/u
Ax>  AEI MEPVǃ  }   1;]}iWUPuJtPXtWhFP҃F    FT*   WeEPve s  ;]|} u<E
   j(ZEuTj(h P0Wp&    E;E~(MɉMSEPaE=UM<EBBU    D       t& F$@8
?  ~| tF|       V$B8 u$h   RVnLt& V$B8
uBF$@   	    BF$@V$   B8 uh   R谨F$@8%uV=F$@8&uV袺V|t 6t& F$@8  t
	F$@8	 t
F$@8

Vm~| uF$@8 u~(݋F$@8%uVsF$@8&uVعV|t &F$@8 t	F$@8	t
F$@8
t
N$F$P:
E;A u9U;Qu1tPXth@FP҃FT   F    6  h   QV$B8 u!h   RʦV*V|t5F$@ ~&t  F$@ =  t	F$@8	t
zF$@8
it
\F$@8
Jt
  9v F$@ =  ~&t  F$@ =    tP8tMQEPFP҃} t+1;]}UP`C;]|MQ`Ee[^_]Ív UVS]h   C$P@S$B8 u!h   R$S脨C|t
<uK$
C$P:<u	Ax/t2tPXthCPC    CTJ   k  t&    ASƃh   C$P葤S$B 8    h   Rq   Sͧ   C$@8
?  {| tC|       S$B8 u$h   RS~Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uSMC$@8&uS貵S|t 6t& C$@8  t
	C$@8	 t
C$@8

S}{| uC$@8 u{(݋C$@8%uS胹C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
~<    C$@ ~&t     C$@ =     t
	u   C$@8	   t
u   C$@8
   t

u   v C$@8
   t
  ~5v C$@ =  ~ t  RC$@ =  ~@t  ~OC$@ =  ~;t /C$@ = t>uEt& C$@8>t5tPXthCP҃CTI   C       t& tC|       S$B8 u%h   R诠SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RPC$@8%uSݶC$@8&uSBt   tPVKtltXPXхtOt   t+VPhCP/   tPhCPh SR@XЃCTL   C    tP<t
VCP҃tVZSut	PZe[^]UWVS}E    Ed   W$B8<  x!  x[  xC  xD  xA{  xTq  xAg  x[]     	B	G|Gx   t~?t& G$@1 ~(W|t
  !  G$@ =  
  t
	u   G$@8	   t

u   G$@8
   t

u   G$@8
   t
  ~6v G$@ =  ~!t
     G$@ =  ~tt  ~3G$@ =  ~ t GG$@ = ~5tPXthFGPG    GT?   Gx     tG|
G$@ E| tG|       v W$B8 u%h   RWMt& W$B8
uBG$@   	    BG$@W$   B8 uh   RG$@8%uWMG$@8&uW貮W|t~5G$@ ~%t
    G$@ =    t
	u   G$@8	   t

u   G$@8
   t

u   G$@8
   t  ~4G$@ =  ~!t
     G$@ =  ~tt  ~3G$@ =  ~ t GG$@ = ~5tPXthFGPGT?   G    Gx     tW|UG$@ E| tG|       W$B8 u%h   RW_Mt& W$B8
uBG$@   	    BG$@W$   B8 uh   R蠚G$@8%uW-G$@8&uW蒬| t_|G$@jd.KE(  jdh)  E@;u|#MɉMQEPQE  MEUuUU]| tG|       t& W$B8 u%h   R这WMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R`G$@8%uWG$@8&uWR| t_|G$@w	t

t
u}]}]>ME G|Gx   t~<G$@1 ~(W|t
  .  G$@ =    t
	u  G$@8	   t

u   G$@8
   t

u   G$@8
   t
  ~:v G$@ =  ~%t
     G$@ =  }   t
  ~0G$@ =  ~t
 QG$@ = ~AtPXtMQhGP҃GT?   G    EPR  tG|       W$B8 u#h   RMW譚kv W$B8
u5BG$@   )    URhP}D   t& BG$@W$   B8 uh   RЖG$@8%uW]G$@8&uW¨tPdtMQEPGP҃URQe[^_]UWVS]h   C$PKS$B8 u!h   R/S菙S$K|  rz C|E   ><u~?uS+      B8<u<x!u6x[u0xCu*xDu$xAuxTuxAux[uSSlu\B8<u$x!ux-ux-uS!$Cx   ;{| u*C$@ <uS+  &uSj Sh   C$PS$B8 u!h   RS]{| uC$@8 u{(݋C$P_S$B8 u!h   R諔SC$K|;z u8;ru3E9u+tPXthCPCT   C    (t<5B8<'Bx/e[^_]ÐU,WVS]S$BE{D t+BB EBESuƃ  VSb{4{h t){ t#Ctt;x,uPClPG !CdS|t/t
MC$@8/uBK$Ax>u6   AtP<t
VCP҃Sb  t
>t   C$@8>   {| tC|    F  S$B8 u$h   RS^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R蠒C$@8%uS-C$@8&   S莤   tPXtMQh CP҃C    CTI   SqS8 tPM  {D   C$PH)щP U@E}EPSb    S`C|t	~:C$@1 ~(S|t
  N  C$@ =  :  t	u,  &    C$@8	  t
u  v C$@8
   t

u   v C$@8
   t
  ~:v C$@ =  ~%t
     C$@ =     t
  ~0C$@ =  ~t
 dC$@ = ~TtPXtEPh@CP҃C    CTM   S袒Si tJPK?St/{D t)C$PH)щP U@E}EPS,a  e[^_]ÉUWVS}E    E
   j
@Euj
h$    |   _|  EPhP=1`  E@;u|U҉UREPFEtUEu| t	G|    닋W$B8 u h   R*W芒HW$B8
uBG$@   	    BG$@W$   B8 uh   RЎG$@8%uW]G$@8&W辠G$@w	t

t
uEC<C<C<	_.:-UE Ee[^_]ÉUWVS]1C|tvt  t& C$@8v  S$Bxe  xr  xs  xi  xoz  xnp     B   C$@8
>  {| tC|       S$B8 u#h   R]S轐Kv S$B8
uBC$@   	    BC$@S$   B8 uh   R C$@8%uS荣C$@8&uSS|t 7t& C$@8 !t
	C$@8	t
C$@8

S轏{| uC$@8 u{(݋C$@8%uSâC$@8&uS(S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=uF    C$@8=t5tPXthCPC    CTK   1  t& {| uPS$B8 u#h   RSy   S$B8
t\oC$@8
>  {| tC|       S$B8 u#h   R轊SKv S$B8
uBC$@   	    BC$@S$   B8 uh   R`C$@8%uSC$@8&uSRS|t 7t& C$@8 !t
	C$@8	t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uS舛S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
"t  v C$@8"q  t
C|       S$B8 u%h   R蟈SMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@C$@8%uS͞C$@8&uS2C$pSǋC|t"uEt& C$@8"t5tPXtVhCPC    CT"   w      {|   S$B8 u#h   R腇S  S$B8
    t& t't  C$@8'  t
C|       S$B8 u%h   RSoMt& S$B8
uBC$@   	    BC$@S$   B8 uh   R谆C$@8%uS=C$@8&uS袘C$pSxǋC|t'uEt& C$@8't5tPXtVhCPCT"   C           {| tC|       S$B8 u#h   RSMKv S$B8
uBC$@   	    BC$@S$   B8 uh   R萅C$@8%uSC$@8&u4S肗)tPXthCPC    CT!   e[^_]Ív UWVS}E    E
   | t_|G$@C<vC<  j
5Euj
h  EE   | tG|       W$B8 u%h   R菄WMt& W$B8
uBG$@   	    BG$@W$   B8 uh   R0G$@8%uW轚G$@8&uW"|     E@;u|#U҉UREP\;E  UEu| tG|       W$B8 u!h   R苃WIW$B8
uBG$@   	    BG$@W$   B8 uh   R0G$@8%uW轙G$@8&uW"| t_|G$@   G$PpW$B8 u!h   R輂Wh   G$P蘂W$B8 u!h   R|W܅| t_|    G$@w	t

t
u<C<AC<6C<	+."_-UE EURhPY/1-tPXthGPG    GTO   Ee[^_]ÉUWVS]1   t& C$@8
?  {| tC|       S$B8 u$h   RNS讄Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   RC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

S譃{| uC$@8 u{(݋C$@8%uS賖C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
et  v C$@8e  S$Bxn  xc  xo  xdz  xip  xnf  xg\     B   t& C$@8
?  {| tC|       S$B8 u$h   R~SLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R`~C$@8%uSC$@8&uSRS|t 6t& C$@8  t
	C$@8	 t
C$@8

S{| uC$@8 u{(݋C$@8%uS#C$@8&uS舏S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=uF    C$@8=t5tPXth CPC    CTK   1  t& {| uPS$B8 u#h   Ry|S   S$B8
t\oC$@8
>  {| tC|       S$B8 u#h   R|S}Kv S$B8
uBC$@   	    BC$@S$   B8 uh   R{C$@8%uSMC$@8&uS貍S|t 7t& C$@8 !t
	C$@8	t
C$@8

S}~{| uC$@8 u{(݋C$@8%uS胑C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
"tS  v C$@8"A  t
C|       S$B8 u%h   RyS_}Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   RyC$@8%uS-C$@8&uS蒋C$pS8ǋC|t"n  C$@8"\  {|   S$B8 u#h   RySv|  S$B8
    t& t't  C$@8'  t
C|       S$B8 u%h   RxS{Mt& S$B8
uBC$@   	    BC$@S$   B8 uh   R@xC$@8%uS͎C$@8&uS2C$pSǋC|t'uEt& C$@8't5tPXtVhCPC    CT"          {| tC|       S$B8 u#h   R}wSzKv S$B8
uBC$@   	    BC$@S$   B8 uh   R wC$@8%uS譍C$@8&uJS?t"t
4C$@8"u)tPXth`CPC    CT!   e[^_]ÐUVS]   &    C$@8
?  {| tC|       S$B8 u$h   RNvSyLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RuC$@8%uS}C$@8&uSS|t 6t& C$@8  t
	C$@8	 t
C$@8

Sx{| uC$@8 u{(݋C$@8%uS賋C$@8&uSS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
st
  v C$@8s	  S$Bxt	  xa	  xn	  xd	  xa	  xl	  xo	  xn	  x	e	     
B
   C$@8
?  {| tC|       S$B8 u$h   RsSwLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RPsC$@8%uS݉C$@8&uSBS|t 6t& C$@8  t
	C$@8	 t
C$@8

S
v{| uC$@8 u{(݋C$@8%uSC$@8&uSxS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
=uF    C$@8=t5tPXthCPCTK   C    %  {| uPS$B8 u#h   RiqSt   S$B8
t\oC$@8
>  {| tC|       S$B8 u#h   R
qSmtKv S$B8
uBC$@   	    BC$@S$   B8 uh   RpC$@8%uS=C$@8&uS袂S|t 7t& C$@8 !t
	C$@8	t
C$@8

Sms{| uC$@8 u{(݋C$@8%uSsC$@8&uS؁S|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
't  v C$@8'  {| tC|       S$B8 u$h   RnSNrLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RnC$@8%uSC$@8&uS肀C|tnt
)C$@8nuS$Bxou1   Bov C|t	yt2C$@8yu%S$Bxeuxsu      B-tPXthCP҃CTN   C    S|t
'uF    C$@8't5tPXthCPCT"   C      &      S$B8 u#h   RGmSpr  S$B8
&  6      t"tz  C$@8"i  {| tC|       S$B8 u$h   RlS.pLt& S$B8
uBC$@   	    BC$@S$   B8 uh   RplC$@8%uSC$@8&uSb~C|tnt
)C$@8nuS$Bxou1   Bov C|t	yt2C$@8yu%S$Bxeuxsu      B-tPXthCP҃CTN   C    S|t
"uF    C$@8"t5tPXthCPC    CT"      &    tC|       S$B8 u%h   RkSnMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RjC$@8%uSMC$@8&u4S|)tPXthCPC    CT!   e[^]UVS]C$   @C|t
 uc  C$@8 T  S|t
	uC  C$@8	4  t

u&  C$@8
  C|t

u  C$@8
   tPXth6CP҃CTA   C       C$@8
<  {| tC|       S$B8 u!h   R[iSlIS$B8
uBC$@   	    BC$@S$   B8 uh   R iC$@8%uSC$@8&uSzS|t 9t& C$@8 #t
	C$@8	t
C$@8

Sk{| uC$@8 u{(݋C$@8%uS~C$@8&uS(zS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
Sbƃuh
|ƃVƋCV"C| t u   C$@8    S|t
	u   C$@8	   t
u}    C$@8
tlt
u
aC$@8
tVt?tt& C$@8?uS$Bx>   tPXthRCP҃CTA   C    SC  S|t u  C$@8   t
	u  v C$@8	z  t
ul  v C$@8
Z  t

uL  v C$@8
:  t
?t-    C$@8?uS$Bx>u   B  tPXthRCP҃C    CTA      C$@8
G  {| tC|       &    S$B8 u%h   R?eShMt& S$B8
uBC$@   	    BC$@S$   B8 uh   RdC$@8%uSm{C$@8&uSvS|t .t& C$@8 t
	C$@8	t
C$@8

Sg{| uC$@8 u{(݋C$@8%uSzC$@8&uSvS|t &C$@8 t	C$@8	t
C$@8
C|t
C$@8
SC   C$@8
=  {| tC|       S$B8 u"h   Rc
S|fJS$B8
uBC$@   	    BC$@S$   B8 uh   RbC$@8%uSMyC$@8&uStS|t 8t& C$@8 "t
	C$@8	t
C$@8

S}e{| uC$@8 u{(݋C$@8%uSxC$@8&uSsS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
t
?t-    C$@8?uK$Ax>u   A  t
>t   C$@8>   tPXth@CP҃C    CT9   {|    S$B8 u h   R`SdCS$B8
uBC$@   BC$@S$   B8 uh   RP`C$@8%uSvC$@8&  S>r  tPXthCP҃C    CT9   @BS$B <w<	t<
t<
uB8>u܃{| tC|       S$B8 u h   R_SbGS$B8
uBC$@   t& BC$@S$   B8 uh   R@_C$@8%uSuC$@8&u	S2qe[^]ÐUS]u  C$@8
1  t
<t+    C$@8<uC$@x?uS,  t taC$@8 tTt	tKC$@8	t>t
t5t& C$@8
t$t
t   &    C$@8
   {| tC|       S$B8 u$h   R^S~aLt& S$B8
uBC$@   	    BC$@S$   B8 uh   R]C$@8%uSMtC$@8&uSo	S7S|t<t
C$@8<uC$@x?rt<t
'C$@8<uC$@x!ux-u
x-@t
 3C$@8  t
	C$@8	 t
C$@8

]]ÐUS]  h   C$P\S$B8 u!h   Rt\S_tP,th JCP҃S|t t^C$@8 tQt	tH&    C$@8	t4t
t+C$@8
tt
tP  C$@8
@  tPXthCP҃CT   C       C$@8
?  {| tC|       S$B8 u$h   Rn[S^Lt& S$B8
uBC$@   	    BC$@S$   B8 uh   R[C$@8%uSqC$@8&uSmS|t 6t& C$@8  t
	C$@8	 t
C$@8

S]{| uC$@8 u{(݋C$@8%uSpC$@8&uS8lS|t &C$@8 t	C$@8	t
C$@8
t
C$@8
{| u7C$@8 u,tPXthCP҃CT   C    h   C$PKYS$B8 u!h   R/YS\C|t
<t  v C$@8<q  C$@x?a  xxW  xmM  xlC  @< t<	t<
t<
,  SO   C$@8
=  {| tC|       S$B8 u"h   RlX
S[JS$B8
uBC$@   	    BC$@S$   B8 uh   RXC$@8%uSnC$@8&uSjS|t 8t& C$@8 "t
	C$@8	t
C$@8

SZ{| uC$@8 u{(݋C$@8%uSmC$@8&uS8iS|t &C$@8 t	C$@8	t
C$@8
C|t
  C$@8
  &    C|t
<tr  C$@8<c  C$@x?S  xXI  xM?  xL5  @< t<	t<
t<
  S   C$@8
<  {| tC|       S$B8 u!h   RUS;YIS$B8
uBC$@   	    BC$@S$   B8 uh   RUC$@8%uS
lC$@8&uSrgS|t 9t& C$@8 #t
	C$@8	t
C$@8

S=X{| uC$@8 u{(݋C$@8%uSCkC$@8&uSfS|t &C$@8 t	C$@8	t
C$@8
C|t
$C$@8
h
yCtP0tCP҃h   C$PSS$B8 u!h   RSSWSh   C$PSS$B 8 u!h   RcSSVC|t<t   &    C$@8<   C$@x!uvxDupxOujxCudxTu^xYuXxPuRxEuLS^C|t[tC$@8[uCx   S腙Cx   Sh   C$PRS$B8 u!h   RzRSUC|t<uAC$@8<t5tPXthCP҃CT   C    g&    Cx   SCx
   S {| uC$@8 t,tPXthCP҃C    CT   CxtP4t	CP҃{ t1]]ÐUWVS}EEMM]]G$E   MqQ)      9~]u
Cv A@} t^} tXHUt& ]8
uH} t]8\u9]8\u0} t	]8\uǇ       MAY)É)B9|   [^_]ÐU,WVS}E    t& w|G$Eu,@WSw|W$UuB8 u(ك} 3  M	Mu!]CSU܋K+U)ыU܉M"v EMXQI)ȋ[)É]Љʃ}   _xCZ$v  t	t
t	
  t6P,th JGP҃tPXthGP҃GT   G    ]C   v G$@8
?  | tG|       W$B8 u$h   R.OWRLt& W$B8
uBG$@   	    BG$@W$   B8 uh   RNG$@8%uW]eG$@8&uW`w|t 6t& G$@8  t
	G$@8	 t
G$@8

WQ| uG$@8 u(݋G$@8%uWdG$@8&uW_w|t &G$@8 t	G$@8	t
G$@8
t
G$@8
]]uSs+C)Ɖuv HE]PI+C)MЃ}  XuRt6P,th JGP҃tPXthGP҃GT   G    
  <   ?   }  } uj j>j?Wm  tP,th JGP҃uFxxuLxmuFxlu@@< t<	t<
t<
u-EW.tP,th JGP҃h
qGtP0tGP҃Gx   IG$@8
8  | tG|       W$B8 u h   RKWNEW$B8
uBG$@   v BG$@W$   B8 uh   R@KG$@8%uWaG$@8&uW2]w|t =t& G$@8 't
	G$@8	t
G$@8

WM| uG$@8 u(݋G$@8%uWaG$@8&uWh\w|t &G$@8 t	G$@8	t
G$@8
t
G$@8
UuMRЋY+A)É]v uHVI+F)MЃ}t  X<%  ?l  !uBx-u<x-u6} uj>j-j-W/  WGx   <
  !   xD   xOu~xCuxxTurxYulxPufxEu`} uj j j>WR
  W6G|t[t
G$@8[uGx   Gx   t& <,
  !#
  }Z
  
  G$@8
>  | tG|       W$B8 u#h   R-HWKKv W$B8
uBG$@   	    BG$@W$   B8 uh   RGG$@8%uW]^G$@8&uWYw|t 7t& G$@8 !t
	G$@8	t
G$@8

WJ| uG$@8 u(݋G$@8%uW]G$@8&uWXw|t &G$@8 t	G$@8	t
G$@8
t
G$@8
UuMRЋY+A)É]v uHVI+F)MЃ}  X<  ?u.} uj j>j?Wm
  WM!uHx-uBx-u<} uj>j-j-W.
  WNGx   &    <,  !#  }Z
    G$@8
>  | tG|       W$B8 u#h   R-EWHKv W$B8
uBG$@   	    BG$@W$   B8 uh   RDG$@8%uW][G$@8&uWVw|t 7t& G$@8 !t
	G$@8	t
G$@8

WG| uG$@8 u(݋G$@8%uWZG$@8&uWUw|t &G$@8 t	G$@8	t
G$@8
t
G$@8
UuMRЋY+A)É]v uHVI+F)MЃ}  X<   ?u+} uj j>j?Wm  W:v !uAx-u;x-u5} uj>j-j-W1  WQGx
   
<u!u
}l  tPXthGP҃G    GT   w    },  8<t1tPXthGP҃GT   G    2} uj j j>Wr  WjÃu1Gx  P4  GP  &    SfPW!D h t, t&WtG4t;B,uRGlP  !Gdw|t/t
zG$@8/uoW$Bx>uc   BtP<t
SGP҃SWD tPp    `    &    t>t   G$@8>   | tG|       W$B8 u$h   R@WCLt& W$B8
uBG$@   	    BG$@W$   B8 uh   R0@G$@8%uWVG$@8&u]W"ROtPXtSh GP҃G    GTI   WBWB tP-S!]  t2fE  G|EtPDtjEPGP҃G|    }N  UBX<  ?u/} uj j>j?W  WUE  t& !u>x-u8x-u2} uj>j-j-Wq  WGx      <   x!uNx[uHw$NyCu<xDu6yAu0xTu*yAu$x[u   	F	Gx   &    <u,!u
}R  /uGx	   Gx   &u*} uj j j;W  WnC(u&}  } uj j j<Ws  Ǉ       j W蓿| BG$@8 3()WA| G$@8 (j>j]j]WÃ}T}  M  tPdth  MAPGPҋG$     @  Ǉ         t~PdtSuFPGP҃   ؉   G$XXǇ       Gx   8}  } uj j j>W   W4    uGx
   E )Љ}1V     9~MA@9syME} tE8u_E Y<"uE"L<'uE'B<]u=uFJ@9s3|]u"19s!uFӋp;>t*CA9rB;Ur}          t& WwGx   Ǉ       h`>t& h0    hPGx   h PGx   h`PGx   Ee[^_]ÐUEj PP]UWVS} ~|} tvEH$tl9tfxxtyWAq)ƃ+URMQW%Q  EP$@ZUB$pp} uB$ @xPv&MQEPUzxtMQR} tnUBxtY
t2tPXthMAP҃E@    @T   UzxttP4tMAPҋE@xUe[^_]BTUWVSu1} t}~EPF  PM  Eu1=  DDÅuURCt& t`= JtPjh!ǉ;u"MQS1          } tEC} uǃ       URVR     S\=ǃuSB1z    } u
G    MQGE@ GUB GWS9} ~%} tC$t8 tMQUR PN  ؍e[^_]ÉUWVS}BƅtEV<Ãt*W  PV4X{{ SV9VA1e[^_]UWVS}EtP|Ãu1Xt	;C    S{ u} t
st& C1P  st    S)Ae[^_]ÐUEj Pj ^]ÉUWVS}E    1} uthAÅt]} ttPeEC    tPtWEPCP҉ƃu} t    Sy@1   VSv:C$@P'   PSV~ uWZFF   F   C$@FC$@FF$    WURScCt2{ tP U@     E    CP  C    } t    S?Ee[^_]Ív UUEPRj ]UWVSu}tt	3t& K@Åu
   } uh
L
  C} ttPEECWS9} tEPSOUS裞{Tu&} t    CP
  S>e[^_]Ív U]ÐU]ÐUEjPj ]ÉUWVSj EPI  ǃt&C?ƅtV8Ãu
V2>1[EP6C;G CG CSVP5    uEPM      u
t   e[^_]ÐUWVS}E1P6Ãu1   ttP/;C        u4uEPL  ƃ    utVW   S{ u} t
st& C1P  st    S<e[^_]ÐUEj Pj ]ÉUEjPj ]ÉUWVS}E<8 uy=ƅtnV;7ÃtSC    C   C       C     W'  PVR{{C$     SV3V&<1e[^_]ÉUWVS}UEPRHÃu1Xt	;C    SQ{ u} t
st& C1Pv
  st    S;e[^_]ÐUUEj PRj ]]ÐUUEjPRj A]ÐUWVSu}V5ÃuhLV2V^<tWCECCSV92e[^_]Ív UWVS}E1PJÃu	Z= JtPBEt{S{ uCTtƃ} t    SZ:e[^_]ÉUWVS}UE1PRzÃu=;ECS{ uCTtƅt    S9e[^_]Ív UY    ]UVS]uVCHPq   SP94t1v Ѝe[^]ÐUE@         @    ]ÉUS]CtPS]]Ív UWVS}EE       1ҋH9w=puu)D9u	E   9sJZ9w} tɅtMA9xsB[^_]UWVSUPEHP^MÃ;YLs'IPu    9u<      uFLVH@9vnIVPu
P8PRu/UtPXth̭MAPҋuFT   pUBPIBHM4    ALu9t)9v#MǃyPJw   9wEu؍<    ~Pu   uFLe[^_]UEIIЉ]ÐUEII
IЉ]ÐUEI]ÐUI]UMtGA(t@y, t:: t    B   : uB   A,@0Q,A(B0A(    ]Ív UWVS]}u	1   jƃuhP1   v F   WPF} tEPPFF        tkC0us0_v ËF{ ut9PCPpQt%0F{ utPCPKQu
V   1	; uˉ3e[^_]UWVSu}EP  tWVP       jzÃuh PcC   tVOCC    tWOC
v C        } tUB(uZ(	 8 u1e[^_]ÐUUtEB,]US]t?CtPZCtPGjjSS+]]USEtP؃u]]ÐUWVSu}t~$ t1   t& j*Ãuh P1   v tWN    } tEPhNCC    } tEPGNCC    C    C    C    C    t^$؍e[^_]UWVSu}t
~  t1   jRÃuh P1~tWM    } tEPMCC    } tEPuMCC    C    C    C    C    t^ ؍e[^_]ÉUS]   tP'CtPCtPCtP~  CtP_  CtPL  CtPi  jjS5S]]ÉUVSu   j8ÃtjC	   VJLCC    C,    C     C$    C(    C    CCC0    C4        C    h;P1e[^]ÉUS]   CtPCtPCtPC,tPQ  C tP*C$tPC(tP(C0tP!  C4tPƕ  j8jSS
]]Ív UWVS]E    1u1  ـ9   E9Ey  t& ;&W  9tQtu)PQW>  3t& )PQEP  i  uEGxǍKˊI  
C:  +E;E};u; "  +E;E  9   )PQIƃVEP   t58u0u@PEPq  EǃW@PWV  EVEPH  u   V   v uE
&    GxǃVsKt& C; t+E;E9t>tu)SQW  %)SQEP  tuEGxEe[^_]ÐUWVS]E    1u1  ڀ: K  ;&7  9tQtu)PRWN  3t& )PREP  =  uEGxǍSӊC  <;u;   9   )PRGƃVEP   t78u2u@PEP
  EǃZ@PW  FVEPy	  u   V~   t& uE
&    GxǃVSt& C; 9t<tu)SRW  #)SREP
  tuEGxEe[^_]ÐUWVSu1u1   EEFuR} tF4PWJ   F4PEPA  Ã   SWIǃS       } t5F(PEP  t@PWIVF4PWIGE&fEfEjEPWHǋF(PWpIǋEE;@  jPWHǃve[^_]UWVS}uu1   j XÃuhVP1   C   {C    VEC} t0EPGP  ƃVGPC VC        C    C    tG$u_$@x uX    C    ؍e[^_]ÉUWVSu}u1   j hÃuhVP1   C   sECWDC} tEPFPC
    C        C    C    tF$u
^$t& @x uX؍e[^_]UWVSu}u1~   j ÃuhVP1Tt& C   C    VCCtWEPCC        C    C    ؍e[^_]ÉUSEt    XP   ؃u]]US]tnCt(SP@P虊  tSC@Pf  CtP;CtP
  j jSS]]ÐUEtVPuhP:&    J$9u(AB$Q
BAR*1Q9tхu]UWVSu}u1   j8ÃuhPX1   C   C    C    C    C    C    C     C$    V BC(C,    C0    tWAC4
    C4        C    ؍e[^_]UVSu   j8ÃtjC   C    C    C    C    C    C     C$    VMAC(EC,C0    C4        C    hP!1e[^]ÉUWVS}UEuPR1Ãt4{t-VWCuC     &    @x uC ؍e[^_]UWVS}UEuPRÃt-{t&VW  CuC     @x uC ؍e[^_]Ív Uj8tkB   EBB    B    B    B    B     B$    B(    B,    B0    B4        B    &    hP1]Ív UVSuj8ÃuhPw1   C    C    C    C    C    C     C$    C   hI?C(C,    C0    tV>C4C4        C    ؍e[^]ÐUS]MEUt"tuRPC,PRPQCPu11v B   ZCB{ u
St& C PBS Ћ]]Ív UWVS}uj8ÃuhP71   C   {C    C    C    C    C     C$    >&u3FVE@|;uHPVd=PVV=
t& V=C(C(C,    C0    PWz  t@C4C4        C    ؍e[^_]ÉUEPtEBЉ]UVSuj8ÃuhP1   C    C    C    C    C    C     C$    C   hI<C(C,    C0    tEPV2<C4C4        C    ؍e[^]ÉUUEPR"tEBЉ]UVSuj8Ãuh P'1   C    C    C    C    C    C     C$    C   hI;C(C,    C0    tV;C4C4        C    ؍e[^]ÐUVSuj8Ãuh@Pc1   C   C    C    C    C    C    C     C$    hI;C(C,    C0    tEPV~:C4C4        C    ؍e[^]ÉUEPbtEBЉ]US]MEUt"tuRPC,PRPQCPau15&    B   ZCB{ u
St& C PBS Ћ]]Ív UVSu]tu1<S  FCFCsFC^CtXCt9puX؍e[^]ÐUVSu]tu1<SU  FCFCsFC^CtXCt9p uX ؍e[^]ÐUVS]utu1XCtx t@ t
x u	[{ uV  ~ uCFC^F    Fstp e[^]ÐUVS]utu1}   ^CFC4tNPCPJt:SPtBCx tt& @x uC C4P|C4    { us    C pFs e[^]ÐUEt@ 1]Ív USEtXP   ؃u]]US]   CC    C    C    C    tPC$tP{tC4tPC(tPC0tPTj8jSS\]]ÐUMtSQt9JuABQt9J uAB QtABQtABA    A    A    ]Ív UVS]uu
1v    uSs_VgCFCFCFtpCFtpFt9XupF9X up C    C    C    ؍e[^]Ív UUt;Btt,BPBPj t& BPBPj 1]ÉUWVS]11t SuƉƋue[^_]UWVS}ut/Vtj FPBPj FPj 3Ãu1@Ftt@PWGP  CC    FtP  C؍e[^_]UWVS]11t,SEPOuƉ    FƋ[uԉe[^_]UWVSu}u1  j8(ÃuhP謽1  FCEC{C    C    C    C     C$    F(tPR4C(
    C(    C,    C0    F4t~tP4C4C4        C    t
SW}    F0tPC0F,td@PSUR	  uGF,@PVFP	  t-JR؃{ t	@x uQRPv S,F$tPS(C$FtSURP1   CtCuC     @x uC ؍e[^_]ÉUWVS]11tAjEPEPS} uuu
@    ƉFpƋ[ue[^_]Ív UUEPj j R]ÐUEj j Pj]ÉUVSutFPFPPj _Ãu
1]    FtP8  CFtPu  CFtPe  CFtPn  C؍e[^]UVSutFP9Ãu1   t& FtPCFtP~1CFCFC} tBF tPC F(tPHC(F,tj SP#C,؍e[^]ÐUEu
1    @,t
xt@u]USEUu1?v X,[t
{uuuP,RQM
v RS؋]]ÐUUt"BHw$EPhR
  ]ÐUS]thS  u	[u1]]ÐUVS]ut3t/CHw$C(tPV/C(e[^]ÉUSE]u	u  uC  x
   X,   {t[   hPY0tHhC(PA0t0hC(P)0th#C(P0u[Yh(C(P/th-C(P/u)h2S[
  uEh7SF
  5t& tC((1h<S
  u	[u1]]UUtmBHwd$HjBPBJtjBPAP,6jBPj "B4ut& B4tP$.1]UVS]u   CH   $|C4tPC4    CtPVCPCtjuC     ]@x uC OC4tPCtPMC    C     tVS-C4C4    e[^]ÉUWVS]u}   CH   $C4tPC4    CtPWVCPCtouC     b@x uC TC4tPCtPjC     C    tWV,C4
    C4    e[^_]Ív UWVSu]      FH   $1~ t~ QF4tJPFPFtu
F     
@x uF F4P~ F4    SEPzÃt?SVt.G9u'PW[   } tSEPF4P-F4e[^_]UVSu]ttS-PSVe[^]ÐUVS]uu6t.{u(~u"F4PSV V؍e[^]Ív UWVS1}E
   }    Ep0   u-E@P ǃu
h eE    1C;]}%V@9tiPR*+uVt& E9E|8E@PWIǃuh@P13t& E4@E    6EE@E$e[^_]UWVSu};&    ^0t*Cuu$tWPh*tu֋vu1e[^_]UWVS}}   } t|w0tnFta} t[URP
*uG9}t9EX0tCu~ t+VtRP)tut& 6uu1e[^_]Ív U<WVS}   } t!tGPEPEP)tq1mGPh`]SwSEPE*      VGPhfSLSEPEFPn uσEPGPEPe[^_]ÐUWVSuE    E    E    E    B  ~, 5  } u7E
   j(3EO  j(EP  1;U})MF,9uMB;U}M9uMF,;U   F,PEPURǃ   M9M}EESURAEu#hPMQ  t& SEPEuhPگUR  ME<F,UAM~,N$M  v Ex   } upE
   j(Eu"hPc  t& j(課EuhP-UR   1;U}-MAM9u	MB;U}M9uMF,;U   UBPMQEPǃ   U9U   MɉMSEP誸EuhP}UR1SMQwEu)hPJEP>   UM<UMBUAMMyE@E]Fu;uFt";ut&Ft;utFu~ u1;u11e[^_]ÉUWVSu}      ^$t6WCP9%ujCPFPt_n[uʃ=I t\^tUS tNWF(PRp  uS$tWF(PRp  t@P#h#1e[^_]Ív UWVS}_$}    EPW
9  t& URCP\$uiCu%G,tUR@P7$tCt=UR@P$u&jCPGP      t& [u=I    w   V    EPG(PRo  ÃuV$tEPG(PRo  ÃCtFPWVt4UR@P^#uCPs"hd"1e[^_]ÉUWVSEu}X$tu&    VCP"uSCtPC    t1WUBPV  ƃVUBPC V[uWVEPÍe[^_]UEtxt1	t&    ]Ív UEt
xu@4u1&: t<
t<
t<	t< uB: u   ]Ív US]t"CwEPEPC4P#C4]]ÐUSjgÃuhPTt& IC    C  Ch  !t  hP螩S蕷1]]UVSuj׬ÃuhP[1pv IC    Ct
st& C    Ct7P}u hPS1
      ؍e[^]ÉUUtEB]US]t@t!h  jP4P薶jjSSz]]Ív UE@    PRj P߶]Ív UVSu]u13F9w')؉FPPRF 
t& e[^]ÉUEUt
u
1    uPBPjQη]ÉUEt
     1]ÉUEt@1]Ív UVSuUӋFt 9s   aFu9~9    Z
uS蒪
SP6t^   h P 1e[^]ÐUWVSu}]         }W  t& 19}? tt& @9}<8 u9}ÃuÅ~RF;Fv'PVuh PWSWFP$VډV e[^_]UEtjPEP]UVSuEtKÀ; tDF
;Fr&PVZuh PĥV
FC; ue[^]ÉUUEPRb]ÉUUEPRf]ÉUVSu]j"St9j'Sh@V$SV h@V	)hBVSV hBVe[^]ÐUVSu]tm{ughDV2{ thPVCPV* { thWVCPV h\Ve[^]UVSu]tSVZue[^]UVSu]t^{uX{ t&h`VtCPVK     hhVNhoV=CPVLe[^]Ív UVSu]t    SVbue[^]UVSEuX   hqVPV { t(h|VCPV h{ thVxCPV { u&{ u { u{ uhVB~   hV.Ct
PV  Ct
PV]  Ct
PVN  Ct
PVW  hVhVe[^]ÉUVSu]   hVCt"@tPVYhVg CPV;j CPEPÃ t&hoV.SV@ S蠯hVe[^]Ív UWVS}u]tSVW'[ue[^_]Ív UWVS}utpt& } t.=I t%~u} ~]hW~KuEPEPVEPW.    } thWKvue[^_]Ív UWVSu}  Gu=G4  PEP٘  Ã  SVSe  uY4   hVG(PV 4 thVG4PVn h^  u94 i  hV]G4PV4 h$  t& u+hV)G(PV  h   u2hVG4t
PVh   }u WRtBtuE    hŲVG,t"@tPVjhVx G(PVLG0t
PV0G$tPEPV@4 u' u!=I uhǲV  t& hʲVG4t,PEPÖ  ÃtSVSS  tk} thVEP} |E@PGPEPV =I t#} t} ~]hV]Kuh̲VIG,t"@tPVhV  G(PVhʲVe[^_]UWVSu}tQPÅtFt~
uWVS}  t& jj WVSy SEP1STe[^_]ÉUWVS}hϲWnUBtPWsh޲WGEx t!hW-UBPW9 UBtthv h Wh\WEx  t
PWUr,t^=I tB(PWt& EP`t-jj SURWC hWf[uӍe[^_]ÉUWVSu}} tÅu        5    EPSCPPC Se[^_]Ív UEt
@
t& ]Ív UUEt}	B    	~	B	   B]ÐUI]UE}I    	~I	   I]ÉUVSut.Åt#VSSEP Se[^]ÉUWVS}]E    ]ƅu1   t& SVJ{ }ICSBwJRh]SӉuGuRj蔪     SWf E} u*hWÃu6VIv FPPEPݯ ǋEP藴 VSǃS謤 Ve[^_]USjÜÃuh PGZjS蹪Ct6@    EP  CCC    C    &    S1]]ÉUS]CtPC    CtP蠳 CtP  CtP;  C|Pjh   SST]]ÐUWVS]11}t+jhLS赠uj S  ǃu~1   jhTS胠uS9  EuM͍v uCu!h]PP- h]S ƃtEPÃts{ECjS  ؍e[^_]US]u1EPt]]ÐUS]}1EPtX]]ÉUWVS]}1   Ex t{<]   W(ƃu+h`P謖j 袤T&    UBSURWV@Љ3 SVUBPw V_SEPUBPU؍e[^_]ÐUWVSE]p  
t  EPBR)Ѕ hP1      9~ÃCP2ǃuh`P趕R  UBtSWP?  lUBt
SWP+7  TUtPSjW:?t& Ex t
SWV@ %UB}hj    SWPÃuW1   }hϔ8Ex tw]   URAƃu$h`PŔW輢[UBSWURV@Љ3 SVUBP V; SWUBPtW\؍e[^_]UUz uz u: uz uz |EPR	&    1]ÉU  WVSE1u1   h  P SE ؉tt   t   u@@9v8/tH9v8/u8/u9uƅ !v   h   StE S͞ǉ[^_]UWVSu]u%tPTtEPh S13t& VSfǃut@TtVh SЉe[^_]UEI]ÐUI]UMUEPRQIЉ]ÐU=I um=I uZhs P   h`蕒u<hi聒tPI  htbt	P*  I   ]UIt	PI    ]ÉU  WVSuU1tPßE8UBtP訟E@    UBtP舟E@    n  ƅ  > ^   ڍ&    >:u~/u
~/   FG> u߀> %   ڊ<:uj R聜UBDBЉF<	vჽ tUB</tFtGF</t9u3v </tu RUBFGf    > uKjՓtcjhPNQ  S蹛U1v 1ƅ  ڐt& FG> u S{UB[^_]U  WVS]I11tPӝ=I=hs  t
hs        ƅ     <:u{/u{/u
ƅ  . CF   <:u{/u߀{/u 1;    ƅ   ʊ<:uR R虚I
|BC<	vt=hs </tBt>&    C</t0u*v </tu R?It& CF끍[^_]USjDÃt2jDSCP   C8    EPSt& 1]]Ív US]   CtP6tP$CtPCtPC tPC<tP؛C@tPśCC   |P;CS蘛]]ÐUS]CtWSщЃtzt8(t-@8(t(@8(t#@tt   t   u@@)PRCPC4]]ÉU   WVSuF  Eh~  u+h  KF    F0  F,F$F(N V,   9v F())ЃPRQ艐)^,)^$)^(^ ~0N(   9sh)ىtV$)ډpN,)ىl?F0PSiF uF4   tV(pN$lF,h   F(PFPF4~F(y&    tlu
֍8u]ǅx
   x1C    hVhЃSj j QF@PF ~F1H[^_]ÐU  WVSu ߋF(9F,u!V,u9u19 +t& F, F,<
u <
tG)=  ~E St[^_]Ív UVSu]  jhS^uv1ɃC<	v;.uC<	vt& < t
<	  C< t<	t<	  LBCB<	vt t		~  N8v  j
hSђu,V<
C< t<	t   R   jhS莒u#~<   t& C< t<	tnv j
hSTu
~<    C< t<	t8jhS!u6~<    &    C< t<	tSДF<}   t& j	hSԑu)V@	C< t<	tt>R0v j	hǴS蔑u"	~@ uC< t<	tSNF@e[^]ÉU   WVSjjj&Ã   j jS{tPjSd   EEEfE ffEjEPS#ǃu48sthѴaǅh<   hd1҉P    pكdPj Vj CP荈ǃ tuSV؍H[^_]UWVSE}PXƃu:t& F1ۃ8 t'     WPuFC< u߸e[^_]U  WVSǅ    1} tEuUR\SHS1ۃ tٴ    t(P^  S袔  JuR  v Iths PRFPQ}P  B=I t^RPt) APAPRAPhST FPFPFPh S˕,t&  BPBPhGh   S͑ ؃PAAA   QF       SPhtSLRÃt!t; uA,A$S~@ twF8=+  ~m=  fPuꃽ	4B@P,ÃQPV91'} tB<tPM[^_]ÐUWVSu}]tu
Ev 1:F,V()9}VuF,V()9}ӃSPW^,؍e[^_]UEt	Pz]ÉU<N  WVSǅܱ    1ۃ} u
1  v } uEe} t	E     uURرSرSU1ۃ رtٴ    t-رPiS[t& رQuQرFPR.}Vvt& رB}    } u]} t	Mu(رFPFPEPhi  v PرBPBPMQh   } t	uu+EPرBPBPMQh   uVPرBPBPMQh z   Etzt8"t+B8"t&B8"t!Btt   t
   uBB+U} up} t	uu5EPRرBPBPMQh@h N  S舍    uVRPرBPBPMQhnt& } t	uu1EPMQRرFPFPEPh0    MQuVRPرBPBPMQh h N  Sߌ0Shg>SرFFF   VF      2SرPptShmߊSCرRÃt!t; uرA,A$S
رV@   F8=+     =     Rht_رPuꃽܱ	9رܱB@PرÃQ)t& رV
h} t)رB<tP觊M	u    رB<tPB8Ph÷蕉رA8Ph|ر[^_]ÐU  WVSE]URPuƃu   uCtHh  jASԊǃ}1V} tUtPWE     1 PSW'}h   SV܃V-W}1[^_]ÐU  WVS}UuzuBt+jARƃ}WF&    1     PSVy|h   SW܃W1[^_]UEt
@8
t& ]ÐU=I    jdhs RI   h +}    h	}uh|tP;  h|tPIh,|tPII   ]Ív UItPLI    ItP-I    ItPI    s  I    ]Ív UWVS]u}ItPȉItP賉ItP螉tSItVItWԆIEIEIe[^_]ÐU  WVSuU1tPE8UBtP E@    UBtPE@    f  ƅ  > V   ڀ>:u~/u
~/   FG> u߀> $   ڊ<:ui RUBDBЉF<	vჽ tUB</tFtGF</t9u3v </tu RoUBFGg    > uKj5}tcjh?P讄Q  SU1v 1ƅ  ڐt& FG> u SۄUB[^_]U  WVS}]1ɉr  j  ? a   W  ƅ  ; G   ;:u;{/u5{/u/ RP3x   1Ƀ&    CA ; u;    1 <:ui RGPw   ODBЉC<	v9   W</tDt@C</t9u3v </tu RGPkwuPW1CAbtRG    ; u+j>{t>jh?P跂,)1ƅ  CA; u1 V	G1[^_]Ív U  WVS]I11tP_=I=I t
I       ƅ     <:u{/u{/u	ƅ  - CF   <:u{/u߀{/u 1;    ƅ   ʐt& <:uN R!I    |BC<	vt=I</t4t0C</t)u#</tu RˁICF뉍[^_]UVSuhL  yÃu1Q&    hL  S膇C   C(   C8    ǃ@      ǃD      t
VS؍e[^]ÐUS]tvCtP袃tP萃CtP}C,C(   |PtC,ǃ@  ǃD  S<]]ÐUM}B<	w"PA<	wTBA<	v1TPЀy-uډЉ]Ív US]@        D  =      9   ~-)PD<PC<Pkx@  )D  ǃ@         +D  u1Uj P@  <PC,P)|D  D  D< &    C,PsC,]]ÐUWVS}EWD   uu
   @  <8D  <489su)PSWo~9EC)H  9s;
tC9s;
u;
uC;
u0C-    C9s
<
u9rD  @  S<
tC뇃} BC)@  EQE)Ѝe[^_]Ív UEP]ÉU   WVSu1xxC    UtV,tЃSj j QF,@PAs tu1	VtX[^_]Ív U   VSuFuhAt& PhRh   8SM~j PRF,P+|1([^]ÐU   VSuFuhs h\	v Phmh   8S}j PRF,P|1([^]ÐU   VSuhwh   8S}j PSF,P1([^]ÉU  WVS}  W  ItPR}ƃr  _jS菂fG FOFPRQ{=I tIGu   ffGj jj+G,  jSPq  Wƃ  =I >  I   PhRh  pSn|j PSG,PQ~ƃ   W'ƃF\  $=I t_It
Phmt& hs h\h  S{j PSG,P}ƃ[  Wƃ  Itq    GPh~h  pS{j PSG,P|}ƃ    WRƃuI   	  =Ir  Wu%GPhh  pS/{'    GPRhh  pS{ j PSG,P|ƃ|fWƍFwI     t& Guhs h\Phmh  Szj PSG,P|ƃ}G,PmG,   W@ƍFvwWƃ|dWƃFwN$Wƃ|4WƃFw$$hPmG,PBmG,1X[^_]ÐUWVSu}LtBj 2ÃVxCt{S|Sz1e[^_]ÉU  VSuEPh@h  pS$yj PSF,P{ |.Vu&    u   t& 1X[^]ÉU  WVSujjj}F0}h`Pzlǅ   jS}fǅ ~(   hh   8SMxj PSF,P0zÃ b  VÃt&v  F0P{kF0F(    H  <0BЍ ,($ 
&    AB<	vuPPPWS ShQ-y t'hP2kF0     1ҍ0B~04f
PPF0Pyb  hPj-  WSF0Pufǅ
  PSF0Pu }hPcj   WSF0PujF0Pbm }'
fPhPj   P
PBPBPBPPh8h   8SuE 0j PSF,PwÃ}F0P5iF09    VÃtF0PiF0v F0[^_]U  WVSE@0PhB0ǅ   1q]    ߉R,Ѓ     󫋽W,ЃWQj SB,@PKi }&A,PhG,ot=PWtRB,PgA,.h`PhG,PgG,1[^_]ÉU   WVSuǅ<    1840,jhV;pu7^~ u&    C; tC<	vC< t<
t<
t4  <+  C< t<
t<
t  1< t \	
BC  < uƅf ; uC; te  ,DBЉ,C<	v; uC; t/  1< t P	
BC
  < u捅P ; ut& C; t  1< t$Dt& 	
BC  < u捅D ; u
&    C; t  0DBЉ0C<	v; uC; t_  1< t @
BC=  < u捅@ ; ut& C; t  4DBЉ4C<	v; uC; t   K   S   :t :uc8DBЉ8C<	v;:uC<	w=|BC<	v(    <DBЉ<C<	vC; ttH1<
t*<
t&hv    
BCt <
t<
u㍅h 
t
t1f&    C<
t<
t} tJW8P4R@P<R,P0RDPPR\PQEPE)؍[^_]U,  WVS]ǅ    uGUBPR%  MQ0UB0  hHt& ;/tMAPQ   EPUB0|  Shh  Soj QPUB,PZqÃ} MA0PbE@0  URÃtJMA0PbE@0ۉ  t& UB0PebMA0  |    ǅ   @    1MQ0Ѓ1MQ0ЃPQj PUB0@PbÃ u@MQ	Ã   UB0P`aMA0      +P*PMA0PrƄ( 1URMQ/Pi߃݋)S/PPe UR1[^_]ÐU<  WVS}} u u
   v WG0   hh,  Slj PSG,Pnƃ }G0P`G0   Wgƃum} uGEPhh,  S`lj PSG,P@nƃ}G0P_G03WƃuG0    G0Px_G0މ[^_]U  WVSuEǅt    u~ t@} t:PV}3'tPWMQEЋF0P_F0   xlpt& lǅx   @        1V0pЃxPj j QF0@P_ ku2VUuSF0PQ^F01Rh    WF0PotPWEPMуt )VX[^_]Ív UVSuU]tF0|u(1 SRP	oÃ	V؍e[^]US]t^jShifuGSÃt5SS|CPS|t& S1]]ÉUS]uQ&    C0|P\C0{, |SC,P\C, S\1]]ÐUWVS}utw
t4v w,u5ht'h P\Vh@t& j_ÃuhP~\1=    3C   tWNCt& C    C    C    ؍e[^_]Ív UVSuu1`PFP
ÃuhP[11FCFtPCFtPC؍e[^]US]tRCtPCtPCtPpijjSiSTi]]ÐUWVS]u}  thS蘵t8wt      t3      hS[   FPS-   Vwj	t& j RS\hSF8ujPS4   &    j PSvVwjj RShS諴F8ujPS*    j PSPh PYth(SSFtv8tt ,h*t& h,Sh.Se[^_]UWVS]u}\  thSct5wt       t0tv   hSVc   FPSDc   Vwj&    j RS\hScF8uKjIVwjj RShSbF8ujj PSth(SbFtv=tt%1v h*    h,SVbh.SFbe[^_]USj[[Ãujh@PW1$t& C        h   [C؋]]ÉUWVS}} u
h  } uh      t.w	tet1tFWt& } t[h\  } tHh I  } u5h`6  &    } uh  Wh  EXu%UBÅuh    &    19}QCMQ Pou.}    EP   MQhK P   F9|C9|  SPCP^`CtWjYƃtDCM4~Q
EPUF RMQB  FhPU1e[^_]ÉUS]t:CPtPcjjS dSc]]ÐUVSut51;}v FPC;|FPAcV8ce[^]Ív UWVSjyXǃuhPT1   UBPBXGuKhPTW&hPTWbG Pb1   UBGE    9E}mjWÃtGUUBU4FCtP'    FPCC    EE;|e[^_]Ív UWVSu} d  E1;8W  UBCtRw
t  v tn      hVPV hV   hVۭPV賭 hV辭   hV諭PV胭 hV莭jCPV hVnghV^PV6 hVAjCPVn hV!v CPh PREG;8e[^_]UVSujUÃujh`PAR1(tV C&    C        ؍e[^]US]t>tPCtP_jjS\`S_]]ÐUVSuu1-FP$Ët
P    ؍e[^]Ív UVSu]t@CPV詫; uh(V诫hV螫PVe[^]ÐUSj_TÃujhPP1C        h   #TC؋]]Ív UWVSE1uht& } uh P{P1Kv Xu	1=t& 1;;}0EPC PuCxC<F;3|Љe[^_]ÉUWVS}1} u1Kt& EXt;    {u(F~"tWtCPMPh`P҃[uˉe[^_]Ív UWVS} u
h  } u
h  } u
h   }
w}sEPh`r  }  tMU RMQ#  u6} t)EPtM QEPMQhMP҃ E     Epu UBƅuh   EPMQPE1;>   F} t{ tx{ upEPCPRuYURP<uCEtPCP!u(} t"MQtEPMQh MP҃G;>mF9|  VPFPXFtj PQÃuh`PM1   FMKECEUCRECE$C}  tM QtCC    EPUR  ǃtF}u7Wj +t%} tMQtEPMQh`MPҋGC_؍e[^_]US]twCtPtPZCtPZCtPZCtPZj jS[SZ]]UVSut51;}v FPMC;|FPAZV8Ze[^]Ív UWVSjyOǃuhPK19  UBPBOGuKhPKW&hPKWYG PY1   UBGE    9E   UBU4j NÃtGUFCFCFPxCtP    FtPC	C    FtPCC    EE;Oe[^_]Ív UWVS]}   E1;8  UB4hSPSƤ hSѤFPS訤V B	   $hS蝤   hS芤   hSw       hS^   hSKqhS;ahS+QhSAhv hSFPS
 Rh@P`IFtwtU<tt"0hrS誣4h}S蚣$hS芣PhPH~ thS]FPSl hS?EG;8+e[^_]ÉUSjKÃujh P}H1$t& C        h   KC؋]]ÉUWVSu}u
h@   uh   &    } u} uhPG^u:FÅu
h    19};t& CW PzuWh@PGF9|ɋC9|  SPCPQCtjJƃuhP@G1YC4W} tEPFF    } tURFF    e[^_]ÐUS]tQtPTCtPTCtPTjjSUSyT]]ÉUVSut91;}&    FPmC;|FP1TV(Te[^]Ív UWVSjiIǃuhPE1  UBP2IGuKhPEW&hPEWSG PS1   UBGE    9E   jHÃtGUUBU4tP    FtPCC    FtPݻCC    EE;oe[^_]Ív UWVSu}    E1;8   UBhVPV֞ { t.hV۞CPV { t(hhV譞CPV脞 hV菞EG;8ke[^_]ÉUSjKGÃujh PC1$t& C        h   
GC؋]]ÉUWVS}uu
hJ  } uhe   t& } u
h   ^0uIF0Åu
h   19}Mv CUR@Pֺu&   W   EPhPwF9|C9|  SPCPLCt6j	Fƃt#C4EP|UFVhPjB1e[^_]ÉUS]t,CtP>PjjSPS"P]]Ív UVSut21;}FPC;|FPOVOe[^]ÉUWVS]}u      S u7{$ u1V<It<i   B<Dt<d   z }      x{
u2FPhtۋFPhtAv t:FPG(PR  uS$tFPG(PR  txt1e[^_]ÉUWVSE}t^tZH0u6Qt& K)P    QTRAP~D1(    19}qt& 9xtB9|e[^_]UWVSEuhPE@Q} u
hx0u
8    C/1;7}'t& GEPCPƷtF;7|1e[^_]ÉUSj3CÃujh@P?1C        h   BC؋]]Ív UWVSu}uhk   t& u
h   } u
h   ^4uPF4Åu
heC9|  SPCPICt6jPBƃt#C4WƵFEFv hP>1e[^_]ÐUS]t,CtPLjjSMSjL]]Ív UVSut91;}&    FPC;|FP!LVLe[^]Ív UWVS]}u{  u{$ tJFPG(PC P  uS$tFPG(PR  txu
       1e[^_]UWVSE}t^tZH4u6Qt& K)P    QTRAP.A1(    19}qt& 9xtB9|e[^_]UWVSEuhP<Q} u
h5x4u
8    C/1;7}'t& GEPCPvtF;7|1e[^_]ÉUWVSEtAxu
8&    /1;7}'    GEPPtF;7|1e[^_]Ív UWVSEtXxu
O&    F1;7}>    GEPCP足uURP蠳tF;7|1e[^_]UWVSEt=xu	4v /1;7}'    GEPPGtF;7|1e[^_]Ív UWVS}]utC uQVPvu;S$t
VR^u#tWtVhMP1       e[^_]ÐUVS]ut-C t&VP-uS$t
VRu@rv
u1	t&    e[^]ÉUE   B<v(B<v!B@<vB(<vw_t	:tQAB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀ:ttu   1]ÉUSEY  ÊB<v/B<v(B@<v!B(<vw_t:t%  t& CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt   t&  t	t

t
uC< t<	t<
t<
tB<v'B<v B@<vB(<vw
_t:u|CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt n	Q
H
?u   t& 1[]ÐUE   B<v@B<v9B@<v2B(<v+w&B<	v.t-t_t:ttSv AB<vB<vB@<vB(<vw܍B<	vՀ.tЀ-tˀ_tƀ:ttu   1]ÉUSE  ÊB<v@B<v9B@<v2B(<v+w&B<	v.t-t_t:tt5  CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt   v  t	t

t
uC< t<	t<
t<
tB<vAB<v:B@<v3B(<v,w'B<	v .t-t_t:tu|t& CPvA<vA@<vA(<vހwٍA<	vҀ.t̀-tȀ_tÀ:tt T	7
.
%u   1[]Ív U   ]UUEH	wB$lR5Rw*t& Rt& R_
t&    ]Ív UWVS}]E   } t	Ex  u1   u
      Ct;PCPRƃutWtPCPhP҃uC   St.t)tWtPCPhP҃E    CuOEP$tE1PRItPj ƃ~tWtCPPh@PҋEe[^_]ÐUWVSE   } t	Ex  u1  } u
     Uz   z   8   p_YC   8   V@Pu.} t!MQtVMPhMP҃E    [tG;uVCP蕫u.} t!EPtVMPhMP҃E    t?uG4UPMA Pt5;Et0} t#EPtMPhKMP҃E    UPMA$Pt5;Et0} t#EPtMPhKMP҃E    EPUR~E    Ee[^_]ÉUWVS}E   }    EH    } t{]S(tq} tk]CtaPRQ*ƃuTEP$tMAP]C(PR ƃu*tWtMA(P]CPhP1  EPFPu-t"WtMA(P]CPh P҃E    ~uEPURMQW	~u]SEPURW~
   ^MQUB PuRMQUB$Pu8t)Wt"MA(PMAPEPh`P҃ E    tURCP¨u4t)Wt"MA(P]CPEPhP҃ E    ~	uX^tURCPdu4t)Wt"MA(P]CPEPh P҃ E    ~uHURFPt1t&WtFPMA(P]CPh`PE    Ee[^_]UWVSu}t"t'Ctu
Cv t   t9w
t      tR      {      v    GPC(P4Ѓu@   GPVEP   tktaGPVEP^   tLt=AGPVEP@   t+tGPVEP!   tu1   e[^_]ÐUWVS]}   t& t#Btu
B捶       WSEPg   WtCwtzt=t@nu=   B   Bvqu<3hu/u31[    3WSEPtt83t*Btu
B捶    t	t&    e[^_]ÐUWVSu]}   thV7[tYCHwI$C(Ph    hVV7{ thV?7[uth(V#7e[^_]ÐU  WVS]ǅ@   G  S <  } 2  EHA  $|t& } 
  MQ  h  Ex t%}   MQ  h  Ex$ t%}   MQ  h   Ex, t&}   MQr  h?`  Ex4 u'} Q  MQC  h1           }   EP  h    }    MQ   h    t& }    EP   h@    }    MQ   hd   t& } t~EPttQhf dv MA(tZPR<ǃuSS$tMA(PRǃu3} t!EPtMA(PhMP1  t& G  w
t  tS@    t& Ex   }   MQ  @(PhP҃  UBD  Dx   p(_Wt& u0Ct8uV@P~tO)u	t8thP)'v [t!uVCP/u܅u2} t"MQtMA(PVh MP҃ǅ@    D@D#   U_BDSDPMQ+@t	D tnƅ jSV0ƅH jEPHS } t&MQtSVMA(Ph@MP҃ ǅ@    wm  ~X  EX$tgFPCPuIV'  CuMA,u})1%t& R@P迟      [uuyVu<}    EP   FPMA(PhMP҃   t& }    EH   FPRUB(PhUPau)} tZMQtPFPFPMA(Ph ,u2} t,EPt"FPFPMA(Ph@MP҃ v@([^_]UWVSu}u1   G t8 utVthPӃWklÃtC(utVthP렐t& PG  Pt^hG  PuhC(Pt,KV@G  PC(Ph P'   e[^_]ÐUWVS} t} t	Ex  u1   &    EPEPEPǋEp$tFj FPEP@UÃSVEPEPEP!ǃ0tSR3vuEXtSEPEPM[!ǃue[^_]ÐUWVS}E   } uh@P$1kEX4t^1;3}XC@PEPVu6t+Wt$C@PC@@PhP҃E    F;3|Ee[^_]Ív UWVS}uEtXtTV$UF$VWcÃt2VjPVWBÃ VW!ËEF$v UV$1e[^_]ÉUWVSu}F u~$ ur   Pux t`~$ uZR@Po@F$uCN AttsWtlPhP\tXWtQAPhP>VW|t-V iPVW]Ã VW!Ét& 1e[^_]UWVS}u]t
} tu
   9   tiw
t"                19}$UPhb   C;|܋Mx    19}UPGP#tRC;|GM>SVEPGPSVURGP
SVMQGPSVEPGPe[^_]ÉU,  WVSǅ    } u} ta} t[} ~U]ǅ    u]{G(PG@ Pƃu/Wz$ tG(PB$Pƃu
  v ǅ    } tE@ǅ    } tUROG hj GVCMBEzJBtQ	W} tMA	W h   P SFPǅ    9   ǅ    
 B(WGPj ft^1ۋFC;}$MP PޗuӋ
 ME9};W} tMA} tUJGW [^_]ÐU1]Ív UE@$]@UE@$]@UE@$]@UE@]xÐUE@]x  ÐUE@]x$ ÐUWVSE}WURPUBPG} u^  Exh Q  x G  x =  E    1{Å%  U   t    uPV   tPtWEPCP҉ƃuSz   &    VStC$@P7    PS躐~ uWܔFF   F   C$@FC$@FF$    WURS%Ct2{ tP U@     E    CPHC    SyUBUP$e[^_]ÉUEUMPRQz]ÉUUEPBP  ]Ív UUEPBP  ]Ív UWVS}u]MUEPRQSVGP  e[^_]ÉUWVS}u]MUE PRQSVEPG_l@ PS uGd    h t! tWtz  tPRS!Gde[^_]ÐUVS]MUEPRQCsl@ PVr uCd    {h t!{ tStz  tPRVT!Cde[^]UVS]MUEPRQCsl@ PVj uCd    {h t!{ tStz  tPRV`!Cde[^]UVS]u{h t'{ t!Ctx  tVPClP!CdVEPEPjEPCP6  e[^]ÐU]ÐUVSuFPiEÉ^t&FtP͑Ct& C    FCe[^]ÉUS]{h t#{ tCtx  tPClPx!Cd]]ÉUWVSuUEPRǃ} u@?xu5mu/lu)nu#su uj EPF4P?L} tyE8xuTxmuNxluHxnuBxsu<x u6WEPF4P?EP' 4  W'&  EtPF4PFPf1j WPF4PeKÃt:~ u~  uEPFPlG    EPFPRC~h t4~ t.Vt'z  t!EPSF4PRFlPk!Fd `v SF4PFP7tSEPFPFlPN.t& SF4PFPtSEPFPFlP2tW&Et	P&e[^_]ÐUWVSuF4E~h tGFx$ u>@ tx u1x u+x u%x uVpth FlP҃Fh    EPEP詜Ej Rj FPMǃ I  FP,ux,	} uUWV;l} t%MyuWQU
WEPDU}    U   R*8xuxmuxluRPVMCCtu΃} tAU   R*8xuxmuxltRPVMCCtu΋EPWFP.du} tEPEPFP
dPWP>EtP$} tUR$e[^_]ÉU VS]s4t-{D t'C$PH)щM@EuEPS:{h t'{ t!Ctx  tVPClPZ!CdSje[^]ÉUS]EPCPNPC4PT]]ÉUWVSU}uB4tgPTÃuVWUB4P\`B    SjtVWSIkv VWBOÃSUB4PSe[^_]ÉU]ÐUVSuUE^4PRItCFBFH,u	P,
t& u˅t {uRSSt& RSRe[^]ÐUMUEPRAPw;]Ív UVS]uVC4PCPau&S8~C@DtVPCPaQC4P;e[^]UE@4]@,UWVSu}^4u2C,   H   twPXtpQC(Ph@VaC,t@utMPXtFWC(PhV7PW袋t/tPXtWC,@PC(PhVF    	   1e[^_]ÐUMUEPRA4P9]Ív UVSuE^4PFPOt=VJ,u	B,
t& u˅t {uPS*Qt& PSPe[^]ÐUWVS]}uC4PQtxuVWPzht& VWCP"NPC4PPe[^_]Ív U J
$J\
(Jt
,J
0J@
4J`
J
8J
@Jر
DJL
<J
HJ
LJ|
PJ
TJس
XJ
\J
`Jl
dJ
J
hJ(
lJ0
pJ(
tJX
xJ
|J
]ÐUJ    J    J    J    J    J`
 K    J    J    J    J    J    J|
J
Jس
J
J
J    J
K    J(
J    J(
JX
J
J
]ÐUS]tlCtPfCtPSCtP@CtP-CtPj jS]]Ív UWVSEu1;8}]&    UZVCP蔇u/Ew         MG;9|UB9|5 JPBP~UBuh>$   MYV+C1> t@F> uCE} tURCC    } tMQۅCC    } t"EP"CPURFCC    C    MC    e[^_]U   WVS=0K      0K1ẺEE͉EEEEE    KMFŪt
v CAuKMEtt& CAuEPj j jEP0KP vh[^_]ÐU0KtPt  0K    ]ÉUWVS}=0K u0K1;0}1&    XWCP7u0KF;0|1e[^_]ÉUS]C$uh`P(
3Pu
l  C$PEPEPEPEPEPR]]US]u
hC uhP5t& Pu
  C PEPEPEPEPEPR]]UWVSUB t?xt81;7}2_wEPCP   F;7|΋UB$   xt41;7}._wEPCP赃tKF;7|ҋUB$tHxtA1;7};    _wEPCPju
v F;7|1e[^_]Ív UWVSE@$t?xt81;7}2_vEPCPuF;7|1e[^_]ÉUWVSUB t?xt81;7}2_vEPCP覂   F;7|΋UB$t>xt71;7}1v _vEPCPZtHF;7|҃=0K u=0K1;7}2_vURCPuF;7|1e[^_]ÉU4K4KP8KP8Kt1&    h>	]ÉU,WVS]}58KE    =<K t3h P	h`P	<K     u1  t& t
{
E=8K   4K  h  8Kuh1i  Q  t& 4K+8K9~
58Kފ<u&FlFtF;   t& >u&FgFtF;v&u&FaFmFpF;\"u&FqFuFoFtF;>'u} u&FaFpFoFsF;B<_v
t

t	uFOy}/Phj	]SJڃO} tSBF: uFB<v

tOv2Phj	]SڃO} tt& BF: uπ?  8Ke[^_]U,WVSE}E    u1  &    t
x
EE  EP
Eu"hh>1  t& u? j  t& E+]9~#EEPEPEtފ<u&FlFtF;   v >u&FgFtF;v&u&FaFmFpF;\"u&FqFuFoFtF;>'u} u&FaFpFoFsF;B<_v
t

t	uFOy}/Phj	]SJڃO} tSBF: uFB<v

tOv2Phj	]SڃO} tt& BF: uπ?  Ee[^_]ÉUSjÃujhP}1$t& C        h   C؋]]ÉUVSut71;}v FPC;|FPVe[^]ÐUWVSjIǃuh P1*  UBPGu$h PW1   UBGE    9E   v EÉƋEp_FCFtP'{CC    FtP{CC    FtPzCC    FtPzCC    FtPzCC    EU;:e[^_]ÉUWVSu}   E1;8  EXBp  $h'V]CPV] h1V]CuCPV]h3Vq]$  h'V^]CPV5] { t,h6V:]CPVI] h1t& h?V]CPV] h3V\  h'V\CPV\ { t+h6V\CPV\ h1v h?V\CPV\ { t(hHVj\CuCPV7\h3VB\   hPV.\CPV\ h1V\CuCPV\h3V[   &    hPV[CPV[ { t,h6V[CPV[ h1t& h?V~[CPV[ h3V`[Rh`P EG;8Te[^_]ÐUWVSU]Uu}9s=C|	9s)v 9sB9r&    ?ɀ
B9r+U[^_]Ív UWVSM]M}u9sDC|
9sAt& $<u9s9r$?CA¸v +M[^_]UWVS]uE]}E9   %   =   u0;usv%   =   ub  
  	ʁ   9sGv  wCK  wC   C   9r#t& $?C;uL+][^_]Ív UWVS]uE؉EE]uE;u   Fwo   v1   w
у   1   wу      v
   у   ;usq%   F=   u_?	Ouށ  w;]sGfc     w.S;Us&  
fӉȀf'v +][^_]ÐUE8 ux ux ux<u
      <u"x ux ux u          u<Hux<ux u
      u<ux ux u
   ev u
xu   Pu
xu   >Luxouxu
xu    <ux?uxxu
xmu   1]ÉU  WVS]
1҉Ǎv :t	B  ~鋵2  u1D      t    u
     v     t    u     t&     t2    t    u
	   p      t2    t
    u             t2    t&    u

     2    t2=    tI    u   k      U    u
   B  `    u

     k    u      &    v    u
          u
          u      &        u   e    u   E
    u   %    t	   [^_]U  WVSuuh&    1ҍ2:t	B  ~
 QPƅt3j-Ãt ECEC3S  t& h P1[^_]ÉU=@K uVh   @Kuh@PE(j j hhL
h
h]Ív U=@K tp9HDK¡@Kt% PDK@KP DK@KP@K    DK    HK    ]ÐUS]=@K uuh1    DK1~-hPFhh P.@KDK]]Ív U=@K u1]ÉU  WVSu=@K u[t> uHKr&    @Ka    1ۍ3;t	C  ~ 1;DK}$@K PVtC;DK|1[^_]ÐUEt:Pt@PRhFPt& @PhNP]ÐUWVS}    EXx    K9v
<
t<
t   	KFO9v
<
t<
u<
t<
uC1t=<
t9<
t5    Ph`CPlFt
<
t	<
tN~уhcPBEXv K<
t<
t9t(   heP
G9tFO~݃hgPe[^_]UVSE1X$t{ uP(~	@0ދ\ShhjPE PEPPS t(V#hcPT VPe[^]Ív UVSE1X$t{ uP(~	@0ދ\ShrPE PEPP,S t(VhcP Ve[^]Ív USEX${ uP(~@0\S)h|PZE PEPPS@]]ÐUSEX${ uP(~@0\ShPE PEPP)S]]ÐUVSEuX uhP   v hVLPVL { t.hVLCPVL { t.h{ thVLCPVL hVLe[^]UVSu]uh PmhVKLCPV"L j CPEPu!Ãt&h!VLSV$L Sh#VKe[^]Ív UWVS}u]uh@P?SVW*[ue[^_]ÉUWVS}u]uhPSVW   [ue[^_]ÉUWVS}uuhP  F
uVW    uDF4  PEPÃ|  SWJSPd  &    u;~4 N  hWJF4PWvJ h
      u+hWiJF(PW@J h   F(P  ÃhW0JF( PWJF$tPEPW(t{ thWIFH~4 us~ umt{ uhWIF(PWI hWIF6  @*  !  hWrI  hW^IF4t,P